/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.autotest;

import com.isomorphic.autotest.AwsHelper;
import com.isomorphic.autotest.BatchRunDao;
import com.isomorphic.autotest.ShowcaseSpecifier;
import com.isomorphic.autotest.TestRunner;
import com.isomorphic.autotest.TestRunnerConfiguration;
import com.isomorphic.autotest.Utils;
import com.isomorphic.base.ISCInit;
import com.isomorphic.log.Logger;
import com.isomorphic.mail.TemplatedMailMessage;
import isc.org.apache.oro.text.perl.Perl5Util;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;

public class TestRunnerLauncher
extends TestRunnerConfiguration {
    private static final int EC2_API_RETRY_LIMIT = 5;
    private static Logger log = new Logger(TestRunnerLauncher.class.getName());
    private static String tmpDir = System.getenv("TMP_DIR") != null ? System.getenv("TMP_DIR") : "/tmp";
    private String url;
    private String browser;
    private String timestamp;
    private String mailHost;
    private boolean storeToDb;
    private boolean noSelenium;
    private boolean noUsualTests;
    private boolean batch;
    private boolean commit;
    private boolean launchAws;
    private String ccEmail;
    private String alertEmail;
    private String repeatEmail;
    private String senderEmail;
    private boolean noEmail;
    private boolean onAwsServer;
    private Date batchStartTime;
    private boolean maximize;
    private boolean maximizeSpecified;
    private String username;
    private String cvsDate;
    private String cvsSpam;
    private String branch;
    private String[] scripts;
    protected static final String[] approvedBranches = new String[]{"MAIN", "ISC_90_BRANCH", "ISC_83_BRANCH", "ISC_82_BRANCH"};
    protected static final String cmdLineSyntax = "[OPT1] [ARG1] [OPT2] [ARG2] ... [PATTERN1] [PATTERN2] ...\nRuns the Java TestRunner Framework using the options provided. If any extra arguments are supplied on the command line without associated options, they are interpreted as regex patterns to match against any test scripts underneath the test script root directory.";

    protected TestRunnerLauncher() throws Exception {
    }

    protected TestRunnerLauncher(CommandLine line) throws Exception {
        this.url = line.getOptionValue("u");
        this.storeToDb = line.hasOption("p");
        this.noSelenium = line.hasOption("ns");
        this.noUsualTests = line.hasOption("nt");
        this.batch = !line.hasOption("s");
        this.launchAws = line.hasOption("l");
        this.onAwsServer = false;
    }

    protected TestRunnerLauncher(String fileName, CommandLine line) throws ConfigurationException {
        PropertiesConfiguration config = new PropertiesConfiguration();
        config.setListDelimiter('\u0000');
        config.load(fileName);
        this.browser = (String)config.getProperty("browser");
        this.alertEmail = (String)config.getProperty("email");
        this.timestamp = (String)config.getProperty("timestamp");
        this.mailHost = (String)config.getProperty("mailHost");
        this.storeToDb = Boolean.parseBoolean((String)config.getProperty("storeToDb"));
        this.noSelenium = Boolean.parseBoolean((String)config.getProperty("noSelenium"));
        this.batch = Boolean.parseBoolean((String)config.getProperty("batch"));
        String milliseconds = (String)config.getProperty("batchStartTime");
        this.batchStartTime = new Date(Long.parseLong(milliseconds));
        this.username = (String)config.getProperty("username");
        this.cvsDate = (String)config.getProperty("cvsDate");
        this.cvsSpam = (String)config.getProperty("cvsSpam");
        this.branch = (String)config.getProperty("branch");
        this.onAwsServer = true;
    }

    protected void generatePropertiesFile(String fileName) {
        PropertiesConfiguration config = new PropertiesConfiguration();
        config.setListDelimiter('\u0000');
        this.cvsSpam = this.cvsSpam.replaceAll("\u0000", ".");
        config.setProperty("browser", (Object)this.getBrowser());
        config.setProperty("email", (Object)this.getAlertEmail());
        config.setProperty("timestamp", (Object)this.timestamp);
        config.setProperty("mailHost", (Object)this.getMailHost());
        config.setProperty("storeToDb", (Object)this.storeToDb);
        config.setProperty("noSelenium", (Object)this.noSelenium);
        config.setProperty("sendEmail", (Object)this.shouldSendEmail());
        config.setProperty("batch", (Object)this.batch);
        config.setProperty("batchStartTime", (Object)this.batchStartTime.getTime());
        config.setProperty("username", (Object)this.getUserName());
        config.setProperty("cvsDate", (Object)this.cvsDate);
        config.setProperty("branch", (Object)this.getBranch());
        config.setProperty("cvsSpam", (Object)this.cvsSpam);
        try {
            config.save(fileName);
        }
        catch (ConfigurationException c) {
            log.error((Object)"serialization of the TestRunnerLauncher state has failed");
            log.error((Object)c);
        }
    }

    private void handleAwsLaunch() throws Exception {
        if (!TestRunnerLauncher.isBranchApproved(this.getBranch())) {
            log.info((Object)("Skipping all tests for batch " + this.batchStartTime + " since testing is not supported for branch " + this.getBranch()));
            return;
        }
        if (this.getFatalBatchError() != null) {
            BatchRunDao.updateBatchStatus(this.batchStartTime, this.getFatalBatchError(), false);
        }
        while (true) {
            log.info((Object)"launching AWS server to test Feature Explorer showcases");
            String instanceId = AwsHelper.launchAwsServer(5, this.batchStartTime);
            if (null != instanceId) {
                String fileName = tmpDir + "/TestRunnerLauncher-" + instanceId + ".properties";
                log.info((Object)("serializing TestRunnerLauncher state to " + fileName));
                this.generatePropertiesFile(fileName);
                Utils.sleep(this.getAwsLaunchDelay());
                return;
            }
            log.info((Object)"couldn't launch an AWS instance; waiting before retrying");
            Utils.sleep(60000);
        }
    }

    protected void setOptionsFromStdIn(CommandLine line) throws Exception {
        this.cvsSpam = Utils.getCvsSpamFromSystemIn();
        String spamHeader = StringUtils.substringBefore((String)this.cvsSpam, (String)"\n\n");
        String spamBody = this.cvsSpam.substring(spamHeader.length()).trim();
        if (Utils.matchRegExp("/^X-Generated-By: Google Code$/m", spamHeader)) {
            this.cvsDate = StringUtils.substringBetween((String)spamBody, (String)"Date: ", (String)"\n");
            this.cvsDate = Utils.getCanonicalDate(this.cvsDate.trim(), "America/Los_Angeles", 2);
            this.username = StringUtils.substringBetween((String)spamBody, (String)"Author: ", (String)"\n").trim();
            this.branch = Utils.getCommitBranchFromSvnSpam(spamBody);
            spamBody = StringUtils.substringAfter((String)spamBody, (String)"\nLog: ").trim();
        } else {
            this.cvsDate = StringUtils.substringBetween((String)spamHeader, (String)"Date: ", (String)"\n");
            this.username = StringUtils.substringBetween((String)spamHeader, (String)"Return-Path: <", (String)">");
            this.branch = Utils.getCommitBranchFromCvsSpam(this.cvsSpam);
        }
        this.username = StringUtils.substringBefore((String)this.username, (String)"@");
        this.cvsSpam = spamBody;
    }

    protected void configureMailHost() {
        if (null != this.getMailHost()) {
            TemplatedMailMessage.config.setIfNull((Object)"mail.system.mail.smtp.host", (Object)this.getMailHost());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void launch(String showcase, CommandLine line) throws Exception {
        if (line != null) {
            this.installOptionValues(line);
            String[] restArgs = line.getArgs();
            if (restArgs != null && restArgs.length > 0) {
                this.scripts = restArgs;
            }
        }
        this.initFileRoot();
        if (this.scripts == null && this.getFiles() != null) {
            this.scripts = this.getFiles().split("[\\s]+");
        }
        if (this.scripts != null && showcase != null) {
            this.noUsualTests = true;
        }
        if (this.autoResolveCommit()) {
            this.storeToDb = this.scripts == null;
            this.commit = this.storeToDb;
        }
        if (!this.maximizeSpecified && this.shouldCaptureScreenshot()) {
            this.maximize = true;
        }
        if (!this.onAwsServer) {
            if (this.commit || this.storeToDb && this.shouldSendEmail()) {
                this.setOptionsFromStdIn(line);
            }
            this.batchStartTime = DateUtils.truncate((Date)new Date(), (int)13);
        }
        TestRunner.setConfiguration(this);
        if (this.commit) {
            if ("sourceCommit".equals(this.getBatchRunDS()) && !this.onAwsServer && !this.launchAws) {
                log.error((Object)"It looks like you're trying to create an official SourceCommit record for your local run of TestRunner! This is not allowed as it will corrupt our test results. If you're using the TestRunner main class for the productized TestRunner to test that feature, you mustn't use it in a devenv as it will pick up the official sourceCommit/autoTestResult SQL databases pointing at wrath");
                return;
            }
            TestRunner.createBatchRunRecord(this.batchStartTime, this.cvsSpam, this.getUserName(), this.getBranch(), this.canParseLog());
        }
        if (this.launchAws) {
            this.handleAwsLaunch();
            return;
        }
        if (this.onAwsServer) {
            BatchRunDao.assertState(this.batchStartTime, showcase, null);
            BatchRunDao.setState(this.batchStartTime, showcase, "l");
        }
        try {
            if (this.shouldSendEmail() || this.storeToDb) {
                TestRunner.collectLocalResults();
            }
            if (this.url == null) {
                TestRunner.testAll(this.batchStartTime, this.getBrowser(), this.storeToDb, this.noSelenium, this.noUsualTests(), this.batch, showcase, this.getBranch(), this.scripts);
            } else {
                TestRunner.testUrl(this.batchStartTime, this.url, this.getBrowser(), this.storeToDb);
            }
            if (this.onAwsServer) {
                BatchRunDao.assertState(this.batchStartTime, showcase, "l");
                BatchRunDao.setState(this.batchStartTime, showcase, "t");
            }
            if (this.shouldSendEmail()) {
                this.configureMailHost();
                log.info((Object)"sending email with differences to recipients");
                if (this.storeToDb) {
                    TestRunner.sendDifferencesEmail(this.getAlertEmail(), this.getRepeatEmail(), this.getCcEmail(), this.getUserName(), this.timestamp, this.cvsSpam, this.cvsDate, showcase, this.getBranch(), this.batchStartTime, this.onAwsServer);
                } else {
                    TestRunner.sendLocalDifferencesEmail(this.getAlertEmail(), this.getRepeatEmail(), this.getCcEmail(), this.timestamp, showcase, this.getBranch());
                }
            }
        }
        finally {
            if (this.onAwsServer) {
                String currentState = BatchRunDao.getState(this.batchStartTime, showcase);
                BatchRunDao.setState(this.batchStartTime, showcase, currentState.toUpperCase());
            }
            String lastShowcase = ShowcaseSpecifier.getLastShowcase();
            if (this.commit || this.onAwsServer && lastShowcase.equals(showcase)) {
                TestRunner.completeBatchRunRecord(this.batchStartTime);
            }
        }
    }

    protected List<String> getTestScripts(String testRootPath, String[] identifiers, String suffixRegEx) {
        return this.getFiles() != null ? Utils.getFilesSpecifiedByPath(testRootPath, identifiers, suffixRegEx) : Utils.getFilesMatchingRegExs(testRootPath, identifiers, suffixRegEx);
    }

    protected String extractCommitMessage(String batchLog) {
        if (!Utils.isCvsSpam(batchLog)) {
            String fileSpam = Utils.getFileRegionFromSvnSpam(batchLog);
            return StringUtils.substringBefore((String)batchLog, (String)fileSpam).trim();
        }
        Pattern p = Pattern.compile("<pre class=\"comment\">(.*)</pre>", 32);
        Matcher m = p.matcher(batchLog);
        if (m.find()) {
            return m.group(1).trim();
        }
        return "";
    }

    public void setUserName(String userName) {
        this.username = userName;
    }

    protected String getUserName() {
        if (this.username != null) {
            return this.username;
        }
        return (String)this.getOptionValue(Utils.getCurrentMethodName());
    }

    public void setBatchLog(String message) {
        this.cvsSpam = message;
    }

    protected String getBatchLog() {
        return this.cvsSpam;
    }

    public void setBranch(String branch) {
        this.branch = branch;
    }

    protected String getBranch() {
        if (this.branch != null) {
            return this.branch;
        }
        return (String)this.getOptionValue(Utils.getCurrentMethodName());
    }

    public void setMailHost(String mailHost) {
        this.mailHost = mailHost;
    }

    protected String getMailHost() {
        if (this.mailHost != null) {
            return this.mailHost;
        }
        return (String)this.getOptionValue(Utils.getCurrentMethodName());
    }

    public void setMaximizeBrowser(boolean maximize) {
        this.maximize = maximize;
        this.maximizeSpecified = true;
    }

    protected boolean shouldMaximizeBrowser() {
        return this.maximize;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public void setTimestamp(Date timestamp) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("MM-dd-yyyy_HH:mm");
        this.timestamp = dateFormat.format(timestamp);
    }

    public void setBrowser(String browser) {
        if (browser != null) {
            this.browser = browser;
        }
    }

    protected String getBrowser() {
        if (this.browser != null) {
            return this.browser;
        }
        return (String)this.getOptionValue(Utils.getCurrentMethodName());
    }

    public void setBatchCommit(boolean commit) {
        this.commit = commit;
    }

    protected void setStoreToDb(boolean storeToDb) {
        this.storeToDb = storeToDb;
    }

    public void setAlertEmail(String[] recipients) {
        this.alertEmail = StringUtils.join((Object[])recipients, (String)",");
    }

    public void setAlertEmail(String recipient) {
        this.alertEmail = recipient;
    }

    protected String getAlertEmail() {
        if (this.alertEmail != null) {
            return this.alertEmail;
        }
        return (String)this.getOptionValue(Utils.getCurrentMethodName());
    }

    public void setRepeatEmail(String[] recipients) {
        this.repeatEmail = StringUtils.join((Object[])recipients, (String)",");
    }

    public void setRepeatEmail(String recipient) {
        this.repeatEmail = recipient;
    }

    protected String getRepeatEmail() {
        if (this.repeatEmail != null) {
            return this.repeatEmail;
        }
        String result = (String)this.getOptionValue(Utils.getCurrentMethodName());
        if (!this.useDefaultMailAddresses() || this.getUserName() == null) {
            return result;
        }
        return this.getEmailForUser(this.getUserName());
    }

    public void setCcEmail(String[] recipients) {
        this.ccEmail = StringUtils.join((Object[])recipients, (String)",");
    }

    public void setCcEmail(String recipient) {
        this.ccEmail = recipient;
    }

    protected String getCcEmail() {
        if (this.ccEmail != null) {
            return this.ccEmail;
        }
        return (String)this.getOptionValue(Utils.getCurrentMethodName(), null, !this.useDefaultMailAddresses(), null);
    }

    public void setSenderEmail(String sender) {
        this.senderEmail = sender;
    }

    protected String getSenderEmail() {
        if (this.senderEmail != null) {
            return this.senderEmail;
        }
        String recipients = this.getAlertEmail();
        if (recipients == null) {
            recipients = this.getRepeatEmail();
        }
        if (recipients == null) {
            recipients = this.getCcEmail();
        }
        if (recipients == null) {
            return null;
        }
        Perl5Util regex = new Perl5Util();
        String domain = regex.substitute("s/^[^@,]*@([^,]+).*$/$1/", recipients);
        return "testrunner@" + domain;
    }

    protected String getEmailForUser(String user) {
        Object[] GMAIL_USERS = new String[]{"sanjiv.jivan", "Aleksandras.Novikovas"};
        if ("smartgwt.dev".equals(user)) {
            return this.getCcEmail();
        }
        if (ArrayUtils.indexOf((Object[])GMAIL_USERS, (Object)user) >= 0) {
            return user + "@gmail.com";
        }
        return user + "@isomorphic.com";
    }

    public void setNoEmail() {
        this.noEmail = true;
    }

    protected boolean shouldSendEmail() {
        if (this.noEmail) {
            return false;
        }
        return this.getAlertEmail() != null || this.getRepeatEmail() != null || this.getCcEmail() != null;
    }

    protected boolean noUsualTests() {
        return this.noUsualTests;
    }

    protected boolean useDefaultMailAddresses() {
        return this.storeToDb;
    }

    protected boolean autoResolveCommit() {
        return false;
    }

    protected boolean onAwsServer() {
        return this.onAwsServer;
    }

    protected static void addOptions(Options options) {
        options.addOption("h", "help", false, "Show usage message and exit");
        options.addOption("c", "batch-commit", false, "Create a record for this batch run in the batchRun database; overrides any default behavior from other options");
        options.addOption("nc", "no-batch-commit", false, "Don't create a record for this batch run in the batchRun database; overrides any default behavior from other options");
        options.addOption("p", "persist-results", false, "Store results to testResult database; overrides any default behavior");
        options.addOption("ns", "no-selenium", false, "Do not run selenium HTML script tests");
        options.addOption("nt", "no-tests", false, "Do not run example tree tests");
        options.addOption("e", "alert-email", true, "Recipient(s) to email if fixes or regressions have occurred in batch");
        options.addOption("cc", "cc-email", true, "Recipient(s) to cc email for all batch reports");
        options.addOption("ne", "no-email", false, "Don't send email. This prevents email from being sent even if email addresses are defined, say in server.properties");
        options.addOption("m", "mail-host", true, "Mail host to use (if not configured in server.properties");
        options.addOption("mt", "mail-template", true, "Velocity template file used to generate email body");
        options.addOption("gp", "gwt-dev-port", true, "Specifies port at which the Google code server is listening - activates dev mode");
        options.addOption("sm", "save-messages", false, "Save the developer console messages for each test case database record");
        options.addOption("cs", "screenshot", false, "Capture a screenshot to the database record if a Selenium test case fails");
        options.addOption("x", "maximize", false, "Maximize the browser when running Selenium tests");
        options.addOption("nx", "no-maximize", false, "Don't maximize the browser when running Selenium tests");
        options.addOption("t", "timestamp", true, "Timestamp of batch to compare results");
        options.addOption("br", "branch", true, "Branch to compare against");
        options.addOption("sc", "showcase", true, "Feature Explorer showcase or other special test type to target");
        options.addOption("u", "url", true, "Url for test to run");
        options.addOption("b", "browser", true, "Browser to be used for testing");
        options.addOption("s", "separate-browser", false, "Run separate browser for each test");
        options.addOption("l", "launch-aws", false, "Launch AWS instance that will run TestRunner across all test suites");
        options.addOption("pf", "property-file", true, "Specifies path to the auto-generated file containing settings for a number of test suite options; used to launch TestRunner on an AWS instance");
        options.addOption("hd", "history-depth", true, "Specifies number of past batches to scan for historical test results to include in reported changes");
        TestRunnerConfiguration.addOptions(options);
    }

    protected static void launch(String showcase, CommandLine line, String cmdLineSyntax, Options options, Class runnerClass) throws Exception {
        String[] restArgs = line.getArgs();
        if (restArgs != null && restArgs.length > 0) {
            if (line.hasOption("ns") && line.hasOption("sc")) {
                Utils.outputHelp(cmdLineSyntax, options, "Cannot pass Selenium HTML script file patterns as extra arguments if -ns and -sc options have also been specified");
                return;
            }
            if (line.hasOption("f")) {
                Utils.outputHelp(cmdLineSyntax, options, "Cannot pass test script file patterns as extra arguments if the -f option has been used to specify explicit files");
                return;
            }
        }
        if (line.hasOption("c") && line.hasOption("nc")) {
            Utils.outputHelp(cmdLineSyntax, options, "You have specified mutually exclusive options -c and -nc. Please decide whether you want to commit the batch results");
            return;
        }
        if (line.hasOption("x") && line.hasOption("nx")) {
            Utils.outputHelp(cmdLineSyntax, options, "You have specified mutually exclusive options -x and -nx. Please decide whether you want to maximize Selenium tests");
            return;
        }
        if (line.hasOption("lg") && line.hasOption("lp")) {
            Utils.outputHelp(cmdLineSyntax, options, "You have specified mutually exclusive options -lg and -lp. Please decide whether to pipe the batch log message to stdin or pass it as a command line argument");
            return;
        }
        if (line.hasOption("pf")) {
            if (line.hasOption("p") || line.hasOption("c") || line.hasOption("br")) {
                Utils.outputHelp(cmdLineSyntax, options, "The -pf option may not be used with -p, -c, or -br");
                return;
            }
            String fileName = line.getOptionValue("pf");
            try {
                TestRunnerLauncher launcher = new TestRunnerLauncher(fileName, line);
                launcher.launch(showcase, line);
            }
            catch (ConfigurationException c) {
                log.error((Object)("unable to construct a TestRunnerLauncher from file " + fileName));
                log.error((Object)c);
                return;
            }
        } else {
            if ((line.hasOption("c") || line.hasOption("p") && line.hasOption("e")) && line.hasOption("br") && runnerClass == TestRunnerLauncher.class) {
                Utils.outputHelp(cmdLineSyntax, options, "The -br option may not be used when expecting cvsSpam on stdin");
                return;
            }
            TestRunnerLauncher launcher = (TestRunnerLauncher)runnerClass.getDeclaredConstructor(CommandLine.class).newInstance(line);
            launcher.launch(showcase, line);
        }
    }

    protected static boolean isBranchApproved(String branch) {
        return ArrayUtils.indexOf((Object[])approvedBranches, (Object)branch) >= 0;
    }

    public static InstanceProperties getInstanceProperties(Date batchStartTime, boolean remote) {
        String awsInstance = BatchRunDao.getAwsInstanceId(batchStartTime);
        if (awsInstance == null) {
            log.error((Object)("unable to locate a valid AWS instance ID using batch " + batchStartTime));
            return null;
        }
        String exceptionMessage = " received while trying to read properties from the configuration file for AWS instance " + awsInstance;
        try {
            String userAccount = "packager@wrath.isomorphic.com";
            String fileName = tmpDir + "/TestRunnerLauncher-" + awsInstance + ".properties";
            if (remote) {
                String shellCommand = "scp " + userAccount + ":" + fileName + " " + tmpDir;
                log.info((Object)("executing the shell command: " + shellCommand));
                Process process = Runtime.getRuntime().exec(shellCommand);
                int result = process.waitFor();
                if (result != 0) {
                    log.error((Object)("scp failed with code " + result + " for instance " + awsInstance));
                    return null;
                }
            }
            PropertiesConfiguration config = new PropertiesConfiguration();
            config.setListDelimiter('\u0000');
            config.load(fileName);
            InstanceProperties properties = new InstanceProperties();
            String milliseconds = (String)config.getProperty("batchStartTime");
            properties.instanceEmail = (String)config.getProperty("email");
            properties.instanceBatchTime = new Date(Long.parseLong(milliseconds));
            properties.instanceCvsSpam = (String)config.getProperty("cvsSpam");
            properties.instanceCvsDate = (String)config.getProperty("cvsDate");
            properties.instanceUsername = (String)config.getProperty("username");
            return properties;
        }
        catch (IOException e) {
            log.error((Object)("IOException" + exceptionMessage + ": " + e));
        }
        catch (ConfigurationException e) {
            log.error((Object)("ConfigurationException" + exceptionMessage + ": " + (Object)((Object)e)));
        }
        catch (InterruptedException e) {
            log.error((Object)("InterruptedException" + exceptionMessage + ": " + e));
        }
        return null;
    }

    public static void main(String[] args) throws Exception {
        String showcase;
        ISCInit.go((String)TestRunnerLauncher.class.getName());
        PosixParser parser = new PosixParser();
        Options options = new Options();
        TestRunnerLauncher.addOptions(options);
        CommandLine line = null;
        try {
            line = parser.parse(options, args);
        }
        catch (MissingOptionException moe) {
            Utils.outputHelp(cmdLineSyntax, options, moe.getMessage());
            return;
        }
        if (line.hasOption("h")) {
            Utils.outputHelp(cmdLineSyntax, options);
            System.exit(0);
        }
        if ((showcase = line.getOptionValue("sc")) != null && !ShowcaseSpecifier.isShowcaseValid(showcase)) {
            String[] showcases = ShowcaseSpecifier.possibleShowcases;
            String errorMessage = "Valid values for --showcase are: ";
            for (int i = 0; i < showcases.length; ++i) {
                errorMessage = errorMessage + showcases[i] + " ";
            }
            Utils.outputHelp(cmdLineSyntax, options, errorMessage);
            return;
        }
        if (line.hasOption("l") && !line.hasOption("c")) {
            Utils.outputHelp(cmdLineSyntax, options, "The -l option requires the -c option");
            return;
        }
        if (line.hasOption("ot") && line.hasOption("sc")) {
            Utils.outputHelp(cmdLineSyntax, options, "The -ot option is incompatible with the -sc option");
            return;
        }
        if ("smartgwtrunner".equals(showcase) && line.hasOption("s")) {
            Utils.outputHelp(cmdLineSyntax, options, "The SmartGWTRunner suite must be run in a single browser and is incompatible with -s");
            return;
        }
        TestRunnerLauncher.launch(showcase, line, cmdLineSyntax, options, TestRunnerLauncher.class);
    }

    protected static class InstanceProperties {
        public String instanceEmail;
        public Date instanceBatchTime;
        public String instanceCvsSpam;
        public String instanceCvsDate;
        public String instanceUsername;

        protected InstanceProperties() {
        }
    }
}

