/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.contentexport;

import com.lowagie.text.BadElementException;
import com.lowagie.text.Image;
import com.lowagie.text.pdf.codec.Base64;
import java.io.IOException;
import org.w3c.dom.Element;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.xhtmlrenderer.context.StyleReference;
import org.xhtmlrenderer.css.constants.CSSName;
import org.xhtmlrenderer.css.newmatch.CascadedStyle;
import org.xhtmlrenderer.css.sheet.PropertyDeclaration;
import org.xhtmlrenderer.extend.FSImage;
import org.xhtmlrenderer.extend.ReplacedElement;
import org.xhtmlrenderer.extend.UserAgentCallback;
import org.xhtmlrenderer.layout.LayoutContext;
import org.xhtmlrenderer.pdf.ITextFSImage;
import org.xhtmlrenderer.pdf.ITextImageElement;
import org.xhtmlrenderer.pdf.ITextOutputDevice;
import org.xhtmlrenderer.pdf.ITextReplacedElementFactory;
import org.xhtmlrenderer.render.BlockBox;

public class B64ImgReplacedElementFactory
extends ITextReplacedElementFactory {
    private static final float mmPerCm = 10.0f;
    private static final float mmPerIn = 25.4f;
    private static final float mmPerPica = 4.233333f;
    private static final float mmPerPt = 0.35277778f;

    private static Float getFloatValueDots(LayoutContext c, PropertyDeclaration lengthPropDecl) {
        if (lengthPropDecl == null) {
            return null;
        }
        CSSPrimitiveValue val = lengthPropDecl.getValue();
        if (val == null) {
            return null;
        }
        switch (val.getPrimitiveType()) {
            case 5: {
                return Float.valueOf(val.getFloatValue((short)5) * (float)c.getDotsPerPixel());
            }
            case 6: {
                return Float.valueOf(val.getFloatValue((short)6) * 10.0f / c.getMmPerDot());
            }
            case 8: {
                return Float.valueOf(val.getFloatValue((short)8) * 25.4f / c.getMmPerDot());
            }
            case 10: {
                return Float.valueOf(val.getFloatValue((short)10) * 4.233333f / c.getMmPerDot());
            }
            case 9: {
                return Float.valueOf(val.getFloatValue((short)9) * 0.35277778f / c.getMmPerDot());
            }
        }
        return null;
    }

    public B64ImgReplacedElementFactory(ITextOutputDevice outputDevice) {
        super(outputDevice);
    }

    public ReplacedElement createReplacedElement(LayoutContext c, BlockBox box, UserAgentCallback uac, int cssWidth, int cssHeight) {
        Element e = box.getElement();
        if (e == null) {
            return null;
        }
        String nodeName = e.getNodeName();
        if (nodeName.equals("img")) {
            FSImage fsImage;
            String attribute = e.getAttribute("src");
            try {
                fsImage = this.buildImage(attribute, uac);
            }
            catch (BadElementException e1) {
                fsImage = null;
            }
            catch (IOException e1) {
                fsImage = null;
            }
            if (fsImage != null) {
                CSSPrimitiveValue maxWidthVal;
                float maxWidthPct;
                StyleReference styleRef;
                CascadedStyle cascadedStyle;
                PropertyDeclaration maxWidthDecl;
                if (cssWidth != -1 && (maxWidthDecl = (cascadedStyle = (styleRef = c.getCss()).getCascadedStyle(e, false)).propertyByName(CSSName.MAX_WIDTH)) != null && (maxWidthPct = (maxWidthVal = maxWidthDecl.getValue()).getFloatValue((short)2)) == 100.0f) {
                    int masterWidth;
                    int maxWidth;
                    float extraWidthDots = 0.0f;
                    Float f = B64ImgReplacedElementFactory.getFloatValueDots(c, cascadedStyle.propertyByName(CSSName.BORDER_LEFT_WIDTH));
                    if (f != null) {
                        extraWidthDots += f.floatValue();
                    }
                    if ((f = B64ImgReplacedElementFactory.getFloatValueDots(c, cascadedStyle.propertyByName(CSSName.PADDING_LEFT))) != null) {
                        extraWidthDots += f.floatValue();
                    }
                    if ((f = B64ImgReplacedElementFactory.getFloatValueDots(c, cascadedStyle.propertyByName(CSSName.PADDING_RIGHT))) != null) {
                        extraWidthDots += f.floatValue();
                    }
                    if ((f = B64ImgReplacedElementFactory.getFloatValueDots(c, cascadedStyle.propertyByName(CSSName.BORDER_RIGHT_WIDTH))) != null) {
                        extraWidthDots += f.floatValue();
                    }
                    if ((cssWidth = (int)((float)cssWidth - extraWidthDots)) >= (maxWidth = (masterWidth = c.getLayer().getMaster().getWidth()) - box.getAbsX() - (int)Math.ceil(extraWidthDots))) {
                        cssWidth = maxWidth;
                    }
                }
                if (cssWidth != -1 || cssHeight != -1) {
                    fsImage.scale(cssWidth, cssHeight);
                }
                return new ITextImageElement(fsImage);
            }
        }
        return null;
    }

    protected FSImage buildImage(String srcAttr, UserAgentCallback uac) throws IOException, BadElementException {
        FSImage fsImage;
        if (srcAttr.startsWith("data:image/")) {
            String b64encoded = srcAttr.substring(srcAttr.indexOf("base64,") + "base64,".length(), srcAttr.length());
            fsImage = new ITextFSImage(Image.getInstance((byte[])Base64.decode((String)b64encoded)));
        } else {
            fsImage = uac.getImageResource(srcAttr).getImage();
        }
        return fsImage;
    }

    public void remove(Element e) {
    }

    public void reset() {
    }
}

