/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.sql;

import com.isomorphic.sql.SQLDataSource;
import com.isomorphic.sql.SQLDriver;
import com.isomorphic.util.DataTools;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EscapedValuesMap
extends HashMap {
    public static final int CRITERIA = 1;
    public static final int FILTER_CRITERIA = 2;
    public static final int EQUALS = 3;
    public static final int SUBSTRING_MATCHES = 4;
    public static final int INPUT_VALUES = 5;
    private List dataSources;
    private SQLDataSource firstDS;
    private int mode;
    private boolean isJoin;

    public EscapedValuesMap(Map m, SQLDataSource ds, int mode) {
        this(m, DataTools.makeList((Object)((Object)ds)), mode);
    }

    public EscapedValuesMap(Map m, List dataSources, int mode) {
        this.dataSources = dataSources;
        this.mode = mode;
        this.firstDS = (SQLDataSource)((Object)dataSources.get(0));
        boolean bl = this.isJoin = dataSources.size() > 1;
        if (m != null) {
            this.putAll(m);
        }
    }

    public Object get(Object o) {
        Object rawValue = super.get(o);
        if (!(rawValue instanceof Number || rawValue instanceof String || rawValue instanceof Date)) {
            return rawValue;
        }
        if (rawValue == null) {
            if (this.mode == 3 || this.mode == 4) {
                return "('1'='1')";
            }
            return null;
        }
        String column = (String)o;
        SQLDataSource ds = this.getDSForColumn(column);
        if (ds == null) {
            ds = this.firstDS;
        }
        SQLDriver driver = ds.getDriver();
        String escapedColumnName = ds.escapeColumnName(column);
        if (this.isJoin) {
            escapedColumnName = ds.getTable().getName() + "." + escapedColumnName;
        }
        switch (this.mode) {
            case 2: {
                return ds.valueForWhereClause(rawValue, column, true);
            }
            case 3: {
                return "(" + escapedColumnName + "=" + ds.valueForWhereClause(rawValue, column) + ")";
            }
            case 4: {
                return "(LOWER(" + escapedColumnName + ")" + " LIKE " + ds.escapeValueForFilter(rawValue) + ")" + driver.escapeClause();
            }
            case 5: {
                return ds.sqlValueForFieldValue(column, rawValue);
            }
        }
        return ds.valueForWhereClause(rawValue, column);
    }

    private String getColumnType(Object columnName) {
        if (this.dataSources != null) {
            for (SQLDataSource ds : this.dataSources) {
                String type = ds.getField(columnName.toString()).getType();
                if (type == null) continue;
                return type;
            }
        }
        return "text";
    }

    private SQLDataSource getDSForColumn(Object columnName) {
        if (this.dataSources == null) {
            return null;
        }
        for (SQLDataSource ds : this.dataSources) {
            if (ds.getColumnName((String)columnName) == null) continue;
            return ds;
        }
        return null;
    }
}

