/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.sql;

import com.isomorphic.base.Base;
import com.isomorphic.datasource.DSField;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.IncludeFromDefinition;
import com.isomorphic.datasource.Relation;
import com.isomorphic.log.Logger;
import com.isomorphic.sql.SQLDataSource;
import com.isomorphic.sql.SQLDriver;
import com.isomorphic.util.DataTools;
import com.isomorphic.velocity.Velocity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SQLJoinWhereClause
extends Base {
    private static Logger log = new Logger(SQLJoinWhereClause.class.getName());
    List dataSources = null;
    DSRequest dsRequest = null;
    boolean keepUndeclaredFields = false;
    private boolean qualifyColumnNames = true;
    private List includeFrom = null;
    private boolean isSubSelect = false;
    List joinedDataSources;

    public SQLJoinWhereClause(DSRequest dsRequest, SQLDataSource ds) throws Exception {
        this(dsRequest, ds, false);
    }

    public SQLJoinWhereClause(DSRequest dsRequest, SQLDataSource ds, boolean qualifyColumnNames) throws Exception {
        this(dsRequest, DataTools.makeList((Object)((Object)ds)), qualifyColumnNames);
    }

    public SQLJoinWhereClause(DSRequest dsRequest, List dataSources) throws Exception {
        this(dsRequest, dataSources, false);
    }

    public SQLJoinWhereClause(DSRequest dsRequest, List dataSources, boolean qualifyColumnNames) throws Exception {
        this.qualifyColumnNames = qualifyColumnNames;
        this.dataSources = dataSources;
        this.dsRequest = dsRequest;
        this.includeFrom = dsRequest.getIncludeFrom();
        if (this.includeFrom == null) {
            this.includeFrom = new ArrayList();
        }
    }

    public boolean isEmpty() {
        return this.includeFrom.size() == 0;
    }

    public int size() {
        return this.includeFrom.size();
    }

    public String getSQLString() throws Exception {
        if (this.isEmpty()) {
            return "";
        }
        this.joinedDataSources = new ArrayList();
        SQLDataSource firstDS = (SQLDataSource)((Object)this.dataSources.get(0));
        HashMap<String, DataSource> relatedDataSources = new HashMap<String, DataSource>();
        for (IncludeFromDefinition incFrom : this.includeFrom) {
            if (incFrom.isInError() || !(incFrom.getDataSource() instanceof SQLDataSource) || !this.dsRequest.isGroupBy() && !this.isSubSelect && incFrom.getThisField() != null && incFrom.getThisField().getProperty("groupFunction") != null || relatedDataSources.containsKey(incFrom.getDataSourceName())) continue;
            relatedDataSources.put(incFrom.getDataSourceName(), incFrom.getDataSource());
        }
        String clause = "";
        for (IncludeFromDefinition incFrom : this.includeFrom) {
            if (incFrom.isInError() || !(incFrom.getDataSource() instanceof SQLDataSource) || !this.dsRequest.isGroupBy() && !this.isSubSelect && incFrom.getThisField() != null && incFrom.getThisField().getProperty("groupFunction") != null) continue;
            if (!this.joinedDataSources.contains(incFrom.getDataSourceName())) {
                if (clause.length() > 0) {
                    clause = clause + " AND ";
                }
                DataSource rds = incFrom.getDataSource();
                Relation relation = incFrom.getRelation();
                if (relation != null) {
                    clause = clause + this.buildExpression(relation, firstDS.getDriver());
                }
            }
            IncludeFromDefinition target = incFrom.getTargetIncludeFrom();
            while (target != null) {
                if (!this.joinedDataSources.contains(target.getDataSourceName())) {
                    if (clause.length() > 0) {
                        clause = clause + " AND ";
                    }
                    DataSource rds = target.getDataSource();
                    Relation relation = target.getRelation();
                    if (relation == null) {
                        relation = incFrom.getDataSource().getRelation(rds);
                    }
                    clause = clause + this.buildExpression(relation, firstDS.getDriver());
                }
                incFrom = target;
                target = incFrom.getTargetIncludeFrom();
            }
        }
        return clause;
    }

    private String buildExpression(Relation relation, SQLDriver driver) throws Exception {
        Object overrideTableName = null;
        StringBuffer joinClause = new StringBuffer();
        List fromFields = relation.getFromFields();
        List toFields = relation.getToFields();
        if (toFields.size() != fromFields.size()) {
            throw new Exception("Cannot join DataSources " + relation.getFromDataSource().getName() + " and " + relation.getToDataSource().getName() + " - are your foreignKey definitions correct?");
        }
        for (int i = 0; i < fromFields.size(); ++i) {
            String to = this.getColumnNameForField((DSField)toFields.get(i));
            String from = this.getColumnNameForField((DSField)fromFields.get(i));
            SQLDataSource relatedDS = (SQLDataSource)relation.getToDataSource();
            String escapedTo = relatedDS.driver.escapeColumnName(to);
            String toTable = relatedDS.getTable().getName();
            escapedTo = toTable + "." + escapedTo;
            String escapedFrom = driver.escapeColumnName(from);
            String fromTable = ((SQLDataSource)relation.getFromDataSource()).getTable().getName();
            escapedFrom = fromTable + "." + escapedFrom;
            if (((DSField)fromFields.get(i)).get((Object)"customSelectExpression") != null || ((DSField)fromFields.get(i)).get((Object)"customSQLExpression") != null) {
                escapedFrom = this.getCustomSelectExpression((DSField)fromFields.get(i));
            }
            if (((DSField)toFields.get(i)).get((Object)"customSelectExpression") != null || ((DSField)toFields.get(i)).get((Object)"customSQLExpression") != null) {
                escapedTo = this.getCustomSelectExpression((DSField)toFields.get(i));
            }
            if (joinClause.length() > 0) {
                joinClause.append(" AND ");
            }
            joinClause.append(driver.generateJoinClause(escapedTo, escapedFrom, relation));
        }
        this.joinedDataSources.add(relation.getToDataSource().getName());
        while (relation.getNextRelation() != null) {
            if (!(relation = relation.getNextRelation()).isValid()) continue;
            if (!this.joinedDataSources.contains(relation.getToDataSource().getName())) {
                if (joinClause.length() > 0) {
                    joinClause.append(" AND ");
                }
                joinClause.append(this.buildExpression(relation, driver));
            }
            this.joinedDataSources.add(relation.getToDataSource().getName());
        }
        return joinClause.toString();
    }

    private String getColumnNameForField(DSField field) {
        if (field.getNativeName() != null) {
            return field.getNativeName();
        }
        return field.getName();
    }

    public void setIsSubSelect(boolean isSubSelect) {
        this.isSubSelect = isSubSelect;
    }

    private String getCustomSelectExpression(DSField field) throws Exception {
        Map context = Velocity.getStandardContextMap((DSRequest)this.dsRequest);
        String expr = (String)field.get((Object)"customSelectExpression");
        if (expr == null) {
            expr = (String)field.get((Object)"customSQLExpression");
        }
        return Velocity.evaluateAsString((String)expr, (Map)context, (String)"customSelectExpression", (DataSource)this.dsRequest.getDataSource(), (boolean)field.getBoolean("autoQuoteCustomExpressions", true));
    }
}

