/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.datasource;

import com.isomorphic.base.Base;
import com.isomorphic.base.Config;
import com.isomorphic.base.Reflection;
import com.isomorphic.base.ReflectionArgument;
import com.isomorphic.base.VersionSafeChecker;
import com.isomorphic.criteria.AdvancedCriteria;
import com.isomorphic.criteria.Evaluator;
import com.isomorphic.criteria.Operator;
import com.isomorphic.datasource.AuditDSGenerator;
import com.isomorphic.datasource.BasicDataSource;
import com.isomorphic.datasource.DSField;
import com.isomorphic.datasource.DSRepo;
import com.isomorphic.datasource.DSRepoRegistry;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.datasource.DataSourceManager;
import com.isomorphic.datasource.DynamicDSGenerator;
import com.isomorphic.datasource.ForeignKeyNotFoundException;
import com.isomorphic.datasource.FreeResourcesHandler;
import com.isomorphic.datasource.ISCMapBean;
import com.isomorphic.datasource.IType;
import com.isomorphic.datasource.IncludeFromInfo;
import com.isomorphic.datasource.Relation;
import com.isomorphic.datasource.RelationFieldInfo;
import com.isomorphic.datasource.RelationInfo;
import com.isomorphic.datasource.StreamingResponseException;
import com.isomorphic.datasource.ValidationContext;
import com.isomorphic.datasource.Validator;
import com.isomorphic.datasource.VirtualDataSource;
import com.isomorphic.io.ISCFile;
import com.isomorphic.js.IBeanFilter;
import com.isomorphic.js.IContextBeanFilter;
import com.isomorphic.js.IToJSON;
import com.isomorphic.js.JSONFilter;
import com.isomorphic.js.JSTranslater;
import com.isomorphic.js.UnconvertableException;
import com.isomorphic.log.Logger;
import com.isomorphic.store.DataStructCache;
import com.isomorphic.util.DataTools;
import com.isomorphic.util.ErrorReport;
import com.isomorphic.util.ISCDate;
import com.isomorphic.util.ISCTime;
import com.isomorphic.util.JXPathContextObjectFactory;
import com.isomorphic.xml.XML;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.map.LinkedMap;
import org.apache.commons.jxpath.AbstractFactory;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.Pointer;
import org.apache.commons.jxpath.ri.model.beans.BeanPropertyPointer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSource
extends Base
implements IType,
IToJSON,
FreeResourcesHandler,
Serializable {
    protected static final int DEFAULT_PROGRESSIVE_LOADING_THRESHOLD = 200000;
    protected static final int DEFAULT_LOOKAHEAD = 1;
    protected static final int DEFAULT_END_GAP = 20;
    private static Logger log = new Logger(DataSource.class.getName());
    protected String dsName;
    protected String dsConfigFile;
    protected Map dsConfig;
    protected Map dsConfigAnnotated;
    protected List fieldList;
    protected long configTimestamp = -1L;
    protected boolean passive = false;
    public static int totalInstantiationTime = 0;
    public static int totalDataSources = 0;
    protected static long nextInstanceId = 1L;
    protected long instanceId;
    private final String TRANSACTION_OBJECT_KEY;
    protected static final Map<String, DataSource> inInitState = Collections.synchronizedMap(new HashMap());
    protected Map<String, RelationFieldInfo> relationFields;
    protected Map<String, IncludeFromInfo> includeFromFields;
    public static final String OP_FETCH = "fetch";
    public static final String OP_ADD = "add";
    public static final String OP_REMOVE = "remove";
    public static final String OP_UPDATE = "update";
    public static final String OP_CUSTOM = "custom";
    public static final String OP_VALIDATE = "validate";
    public static final String OP_CLIENT_EXPORT = "clientExport";
    private static DynamicDSGenerator defaultDynamicDSGenerator = null;
    private static Map dynamicDSGenerators = new LinkedMap();
    private static Stack gettingDynamic = new Stack();
    public static Map creationCount = new HashMap();
    static final String builtinTypesFile = "builtinTypes.xml";
    static Map builtinTypes = new HashMap();
    public static boolean useAxisForSQLDS;
    Evaluator evaluator;
    private Map<String, RelationInfo> cachedRelations = new HashMap<String, RelationInfo>();
    protected Map<String, String> filenameField = new HashMap<String, String>();
    protected Map<String, String> filesizeField = new HashMap<String, String>();
    protected Map<String, String> dateCreatedField = new HashMap<String, String>();
    private Map<DSField, Class> convertedProps = new HashMap<DSField, Class>();

    public DataSource() {
        this.TRANSACTION_OBJECT_KEY = null;
    }

    public boolean isPassive() {
        return this.passive;
    }

    public void activate() {
        this.passive = false;
    }

    public void passivate() {
        this.passive = true;
    }

    public long getInstanceId() {
        return this.instanceId;
    }

    public static DataSource forName(String dsName, DSRequest dsRequest) throws Exception {
        return DataSource.forName(dsName, dsRequest, false);
    }

    public static DataSource forName(String dsName, DSRequest dsRequest, boolean isSchemaless) throws Exception {
        return DataSource.forName(dsName, "default", dsRequest, isSchemaless);
    }

    public static DataSource forName(String dsName, String repoId, DSRequest dsRequest) throws Exception {
        return DataSource.forName(dsName, repoId, dsRequest, false);
    }

    public static DataSource forName(String dsName, String repoId, DSRequest dsRequest, boolean isSchemaless) throws Exception {
        return DataSource.forName(dsName, DSRepoRegistry.loadDSRepo(repoId), dsRequest, isSchemaless);
    }

    public static DataSource forName(String dsName, DSRepo dsRepo, DSRequest dsRequest, boolean isSchemaless) throws Exception {
        DataSource dynamic = DataSource.getDynamicDataSource(dsName, dsRequest);
        if (dynamic != null) {
            return dynamic;
        }
        return dsRepo.loadDS(dsName, dsRequest, isSchemaless);
    }

    public static void addDynamicDSGenerator(DynamicDSGenerator ddsg) {
        defaultDynamicDSGenerator = ddsg;
    }

    public static void addDynamicDSGenerator(DynamicDSGenerator ddsg, String prefix) {
        dynamicDSGenerators.put(prefix, ddsg);
    }

    public static void addDynamicDSGenerator(DynamicDSGenerator ddsg, Pattern regex) {
        dynamicDSGenerators.put(regex, ddsg);
    }

    public static DynamicDSGenerator removeDynamicDSGenerator() {
        DynamicDSGenerator ddsg = defaultDynamicDSGenerator;
        defaultDynamicDSGenerator = null;
        return ddsg;
    }

    public static DynamicDSGenerator removeDynamicDSGenerator(String prefix) {
        if (dynamicDSGenerators.containsKey(prefix)) {
            DynamicDSGenerator ddsg = (DynamicDSGenerator)dynamicDSGenerators.get(prefix);
            dynamicDSGenerators.remove(prefix);
            return ddsg;
        }
        return null;
    }

    public static DynamicDSGenerator removeDynamicDSGenerator(Pattern regex) {
        if (dynamicDSGenerators.containsKey(regex)) {
            DynamicDSGenerator ddsg = (DynamicDSGenerator)dynamicDSGenerators.get(regex);
            dynamicDSGenerators.remove(regex);
            return ddsg;
        }
        return null;
    }

    public static void clearDynamicDSGenerators() {
        defaultDynamicDSGenerator = null;
        dynamicDSGenerators.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized DataSource getDynamicDataSource(String id, DSRequest dsRequest) {
        if (!gettingDynamic.empty() && gettingDynamic.peek().equals(id)) {
            return null;
        }
        gettingDynamic.push(id);
        DynamicDSGenerator ddsg = null;
        for (Object keyObj : dynamicDSGenerators.keySet()) {
            if (keyObj instanceof String) {
                if (id.indexOf((String)keyObj) != 0) continue;
                ddsg = (DynamicDSGenerator)dynamicDSGenerators.get(keyObj);
                break;
            }
            if (keyObj instanceof Pattern) {
                Pattern p = (Pattern)keyObj;
                Matcher m = p.matcher(id);
                if (!m.find()) continue;
                ddsg = (DynamicDSGenerator)dynamicDSGenerators.get(keyObj);
                break;
            }
            log.warn("In the dynamicDSGenerators list, we found a key of type " + keyObj.getClass().getName() + ". Ignoring");
        }
        if (ddsg == null) {
            ddsg = defaultDynamicDSGenerator;
        }
        DataSource ds = null;
        try {
            if (ddsg != null) {
                ds = ddsg.getDataSource(id, dsRequest);
            }
        }
        finally {
            gettingDynamic.pop();
        }
        return ds;
    }

    public static boolean isDynamic(String id) {
        DynamicDSGenerator ddsg = null;
        for (Object keyObj : dynamicDSGenerators.keySet()) {
            if (keyObj instanceof String) {
                if (id.indexOf((String)keyObj) != 0) continue;
                ddsg = (DynamicDSGenerator)dynamicDSGenerators.get(keyObj);
                break;
            }
            if (keyObj instanceof Pattern) {
                Pattern p = (Pattern)keyObj;
                Matcher m = p.matcher(id);
                if (!m.find()) continue;
                ddsg = (DynamicDSGenerator)dynamicDSGenerators.get(keyObj);
                break;
            }
            log.warn("In the dynamicDSGenerators list, we found a key of type " + keyObj.getClass().getName() + ". Ignoring");
        }
        if (ddsg == null) {
            ddsg = defaultDynamicDSGenerator;
        }
        return ddsg != null;
    }

    public static DataSource fromConfig(Map theConfig, DSRequest dsRequest) throws Exception {
        String dsType;
        if (config.getBoolean((Object)"datasource.detect.bad.creation", false)) {
            Exception e = new Exception("We are in DataSource.fromConfig() and we came through PoolableDataSourceFactory.makeUnpooledObject(), but did not come through DataSourceManager.getDataSource().  This could lead to concurrency problems!");
            StackTraceElement[] ste = e.getStackTrace();
            boolean ok = true;
            for (int i = 0; i < ste.length; ++i) {
                if ("com.isomorphic.datasource.PoolableDataSourceFactory".equals(ste[i].getClassName()) && "makeUnpooledObject".equals(ste[i].getMethodName())) {
                    ok = false;
                    continue;
                }
                if (!"com.isomorphic.datasource.DataSourceManager".equals(ste[i].getClassName()) || !"getDataSource".equals(ste[i].getMethodName())) continue;
                ok = true;
            }
            if (!ok) {
                if (config.getBoolean((Object)"datasource.reject.bad.creation", false)) {
                    throw e;
                }
                log.warn((Object)"Potential concurrency problem", e);
            }
        }
        if ("view".equals(dsType = DataSource.getType(theConfig))) {
            VirtualDataSource ds = new VirtualDataSource();
            ds.initialize(theConfig, null);
            return ds;
        }
        return BasicDataSource.fromConfig(theConfig, dsRequest);
    }

    public final void initialize(Map theConfig, DSRequest dsRequest) throws Exception {
        this.init(theConfig, dsRequest);
        this.initialized();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(Map theConfig, DSRequest dsRequest) throws Exception {
        Object object = DataSource.class;
        synchronized (DataSource.class) {
            this.instanceId = nextInstanceId++;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            this.dsConfig = DataTools.mapMerge(theConfig, (Map)new LinkedMap());
            this.dsName = (String)this.dsConfig.get("ID");
            this.fieldList = new ArrayList();
            if (this.dsName == null) {
                log.warn("dsConfig with no ID: " + DataTools.prettyPrint(this.dsConfig));
            }
            if (log.isDebugEnabled()) {
                if (config.getBoolean((Object)"debug.dataSource.creation", false)) {
                    log.debug("Creating instance of DataSource '" + this.dsName + "' with instanceId " + this.instanceId);
                }
                object = creationCount;
                synchronized (object) {
                    DataTools.incrementIntInMap(creationCount, this.dsName);
                }
                ++totalDataSources;
            }
            return;
        }
    }

    protected void initialized() throws Exception {
    }

    public static DataSource fromXML(Element elem) throws Exception {
        return DataSource.fromXML(elem, null);
    }

    public static DataSource fromXML(Element elem, DSRequest dsRequest) throws Exception {
        return DataSource.fromConfig((Map)XML.toDSRecords(elem), dsRequest);
    }

    public static DataSource fromXML(Document doc) throws Exception {
        return DataSource.fromXML(doc.getDocumentElement());
    }

    public static DataSource fromXML(Document doc, DSRequest dsRequest) throws Exception {
        return DataSource.fromXML(doc.getDocumentElement(), dsRequest);
    }

    public static DataSource fromXML(String xml) throws Exception {
        return DataSource.fromXML(new StringReader(xml));
    }

    public static DataSource fromXML(String xml, DSRequest dsRequest) throws Exception {
        return DataSource.fromXML(new StringReader(xml), dsRequest);
    }

    public static DataSource fromXML(Reader reader) throws Exception {
        return DataSource.fromXML(reader, null);
    }

    public static DataSource fromXML(Reader reader, DSRequest dsRequest) throws Exception {
        return DataSource.fromConfig((Map)XML.toDSRecords(reader), dsRequest);
    }

    public static Map getBuiltinType(String typeID) throws Exception {
        if (typeID == null) {
            return null;
        }
        return (Map)builtinTypes.get(typeID);
    }

    public boolean isStale() {
        if (this.configTimestamp == -1L) {
            return false;
        }
        String filename = this.dsConfigFile;
        File configFile = new File(filename);
        return configFile.exists() && configFile.lastModified() > this.configTimestamp;
    }

    public String getID() {
        return this.getName();
    }

    @Override
    public String getName() {
        return this.dsName;
    }

    public String getConfigFilename() {
        return this.dsConfigFile;
    }

    public Map getServerObjectConfig() {
        return (Map)this.dsConfig.get("serverObject");
    }

    public String getConfigName() {
        return "";
    }

    public List getOperationBindings() {
        return DataSource.getOperationBindings(this.dsConfig);
    }

    public static List getOperationBindings(Map dsConfig) {
        return (List)dsConfig.get("operationBindings");
    }

    public String getAutoOperationId(String operationType) {
        return this.getName() + "_" + operationType;
    }

    public Map getOperationBinding(DSRequest req) {
        return this.getOperationBinding(req.getOperationType(), req.getOperationId());
    }

    public Map getOperationBinding(String operationType) {
        return this.getOperationBinding(operationType, this.getAutoOperationId(operationType));
    }

    public Map getOperationBinding(String operationType, String operationId) {
        List operationBindings = this.getOperationBindings();
        if (operationBindings == null) {
            return null;
        }
        boolean operationIdIsAuto = operationId != null && operationId.equals(this.getAutoOperationId(operationType));
        Map autoOperationBinding = null;
        for (Map operationBinding : operationBindings) {
            if (!operationType.equals((String)operationBinding.get("operationType"))) continue;
            String bindingOperationId = (String)operationBinding.get("operationId");
            if (operationId != null && operationId.equals(bindingOperationId)) {
                return operationBinding;
            }
            if (bindingOperationId != null) continue;
            autoOperationBinding = operationBinding;
        }
        if (autoOperationBinding != null) {
            return autoOperationBinding;
        }
        return null;
    }

    public boolean dropExtraFieldsDefined() {
        return this.dsConfig.get("dropExtraFields") != null;
    }

    public boolean dropExtraFields() {
        Boolean dropExtraFields = (Boolean)this.dsConfig.get("dropExtraFields");
        return dropExtraFields == null || dropExtraFields != false;
    }

    public String getTestFileName() throws Exception {
        String testFilePath;
        String finalPath;
        String testFileName = (String)this.dsConfig.get("dbImportFileName");
        if (testFileName == null) {
            testFileName = (String)this.dsConfig.get("testFileName");
        }
        if (testFileName == null) {
            testFileName = this.dsName + ".data";
        }
        if ((finalPath = this.tryExtension(testFilePath = (testFilePath = testFileName).indexOf("/") == -1 ? DataStructCache.getInstanceDir(this.getName(), "datasources", "ds") + "/test_data/" + testFileName : Config.getGlobal().get("webRoot") + testFileName, ".xml")) == null) {
            finalPath = this.tryExtension(testFilePath, ".csv");
        }
        if (finalPath == null) {
            finalPath = this.tryExtension(testFilePath, ".js");
        }
        if (finalPath == null) {
            log.info("No test data file for datasource '" + this.getName() + ".  Tried " + testFilePath + " with extensions .xml, .csv and .js");
        }
        return finalPath;
    }

    private String tryExtension(String baseName, String extension) throws Exception {
        String fullName = baseName.endsWith(extension) ? baseName : baseName + extension;
        log.debug("Look for test file at path " + fullName);
        ISCFile iscFile = new ISCFile(fullName);
        if (iscFile.exists()) {
            return iscFile.getCanonicalPath();
        }
        return null;
    }

    public List getFieldNames() {
        return this.getFieldNames(true);
    }

    public List getFieldNames(boolean dropIgnored) {
        if (!dropIgnored) {
            return this.fieldList;
        }
        ArrayList fieldNames = new ArrayList(this.fieldList);
        Iterator i = fieldNames.iterator();
        while (i.hasNext()) {
            DSField field = this.getField((String)i.next());
            if (!field.ignore()) continue;
            i.remove();
        }
        return fieldNames;
    }

    public List getFields() {
        return this.getFields(true);
    }

    public List getFields(boolean dropIgnored) {
        List fieldNames = this.getFieldNames(dropIgnored);
        if (fieldNames == null) {
            return null;
        }
        ArrayList<DSField> fields = new ArrayList<DSField>();
        Iterator i = fieldNames.iterator();
        while (i.hasNext()) {
            fields.add(this.getField((String)i.next()));
        }
        return fields;
    }

    public List getPrimaryKeys() {
        return new ArrayList();
    }

    public String getPrimaryKey() {
        List pks = this.getPrimaryKeys();
        if (pks == null || pks.size() == 0 || pks.get(0) == null) {
            return null;
        }
        return pks.get(0).toString();
    }

    public Map getConfig() {
        return this.dsConfig;
    }

    public int getVersion() {
        return new Integer(this.dsConfig.get("dataSourceVersion").toString());
    }

    public static String getType(Map dsConfig) {
        Object type = dsConfig.get("serverType");
        if (type == null) {
            type = dsConfig.get("type");
        }
        if (type == null) {
            type = dsConfig.get("dataSourceType");
        }
        if (type == null && dsConfig.get("constructor") != null && !"DataSource".equals(dsConfig.get("constructor"))) {
            type = dsConfig.get("constructor");
        }
        if (type == null && dsConfig.get("serviceNamespace") != null) {
            type = "webService";
        }
        if (type == null) {
            type = dsConfig.get("dataFormat");
        }
        if (type == null && dsConfig.get("recordXPath") != null) {
            type = "xml";
        }
        return (String)type;
    }

    public String getType() {
        return DataSource.getType(this.dsConfig);
    }

    public boolean getUseStrictJSON() {
        Object useStrictJSON = this.dsConfig.get("useStrictJSON");
        return useStrictJSON == null ? false : (Boolean)useStrictJSON;
    }

    public boolean inheritsFrom(String dsName) {
        return false;
    }

    public Map getRawFields() {
        return (Map)this.dsConfig.get("fields");
    }

    public void _cloneConfigForSecurityAnnotations() throws Exception {
        this.dsConfigAnnotated = (Map)DataTools.deepClone(this.dsConfig);
    }

    public Map getAnnotatedConfig() {
        return this.dsConfigAnnotated;
    }

    public void clearAnnotatedConfig() {
        this.dsConfigAnnotated = null;
    }

    public DSField getField(String fieldName) {
        return null;
    }

    public String getFieldTitle(String fieldName) {
        DSField field = this.getField(fieldName);
        if (field == null) {
            return null;
        }
        return field.getTitle();
    }

    public Map getValueMaps() {
        return this.getValueMaps(this.getFieldNames());
    }

    public Map getValueMaps(List fieldNames) {
        HashMap valueMaps = new HashMap();
        if (fieldNames == null || fieldNames.size() == 0) {
            return valueMaps;
        }
        for (String fieldName : fieldNames) {
            Object valueMap;
            DSField field = this.getField(fieldName);
            if (field == null || (valueMap = field.get("valueMap")) == null || !(valueMap instanceof Map)) continue;
            valueMaps.put(fieldName, valueMap);
        }
        return valueMaps;
    }

    public String getRecordXPath() {
        return (String)this.dsConfig.get("recordXPath");
    }

    public boolean isAdvancedCriteria(Map criteria) {
        if (criteria == null) {
            return false;
        }
        String constructor = (String)criteria.get("_constructor");
        if ("AdvancedCriteria".equals(constructor)) {
            return true;
        }
        String fieldName = (String)criteria.get("fieldName");
        String operator = (String)criteria.get("operator");
        return this.getField("fieldName") == null && this.getField("operator") == null && this.getField(fieldName) != null && operator != null;
    }

    public Map normalizeAdvancedCriteria(Map criteria) throws Exception {
        return this.normalizeAdvancedCriteria(criteria, false);
    }

    public Map normalizeAdvancedCriteria(Map criteria, boolean subLevel) throws Exception {
        String[] canNormalizeArray = new String[]{"equals", "iEquals", "notEqual", "iNotEqual", "startsWith", "iStartsWith", "notStartsWith", "iNotStartsWith", "endsWith", "iEndsWith", "notEndsWith", "iNotEndsWith", "contains", "iContains", "notContains", "iNotContains", "equalsField", "notEqualField", "containsField", "startsWithField", "endsWithField"};
        List<String> canNormalize = Arrays.asList(canNormalizeArray);
        String[] negatedArray = new String[]{"notEqual", "iNotEqual", "notStartsWith", "iNotStartsWith", "notEndsWith", "iNotEndsWith", "notContains", "iNotContains", "notEqualField"};
        List<String> negated = Arrays.asList(negatedArray);
        if (criteria == null || !subLevel && !this.isAdvancedCriteria(criteria)) {
            return criteria;
        }
        Map<String, String> norm = new HashMap<String, String>();
        if (!subLevel) {
            norm.put("_constructor", "AdvancedCriteria");
            if (criteria.get("strictSQLFiltering") != null) {
                norm.put("strictSQLFiltering", (String)criteria.get("strictSQLFiltering"));
            }
        }
        if (criteria.containsKey("criteria")) {
            norm.put("operator", (String)criteria.get("operator"));
            ArrayList<Map> normSubCrit = new ArrayList<Map>();
            if (!(criteria.get("criteria") instanceof List)) {
                throw new Exception("Invalid AdvancedCriteria structure - expected a List");
            }
            for (Object subObj : (List)criteria.get("criteria")) {
                if (!(subObj instanceof Map)) {
                    throw new Exception("Invalid AdvancedCriteria structure - expected a Map");
                }
                normSubCrit.add(this.normalizeAdvancedCriteria((Map)subObj, true));
            }
            norm.put("criteria", (String)((Object)normSubCrit));
        } else if (canNormalize.contains(criteria.get("operator"))) {
            String operator = (String)criteria.get("operator");
            if (criteria.get("value") instanceof List) {
                Iterator i = ((List)criteria.get("value")).iterator();
                if (i.hasNext()) {
                    ArrayList normSubCrit = new ArrayList();
                    norm.put("operator", negated.contains(operator) ? "and" : "or");
                    while (i.hasNext()) {
                        HashMap<String, Object> normSubCriterion = new HashMap<String, Object>();
                        normSubCriterion.put("fieldName", criteria.get("fieldName"));
                        normSubCriterion.put("operator", operator);
                        normSubCriterion.put("value", i.next());
                        normSubCrit.add(normSubCriterion);
                    }
                    norm.put("criteria", (String)((Object)normSubCrit));
                } else {
                    norm.put("operator", operator);
                    norm.put("fieldName", (String)criteria.get("fieldName"));
                    norm.put("value", null);
                }
            } else {
                norm = criteria;
            }
        } else {
            norm = criteria;
        }
        return norm;
    }

    public boolean allowAdvancedCriteria() {
        Object obj = this.dsConfig.get("allowAdvancedCriteria");
        return DataTools.asBoolean(obj, this.getDefaultAllowAdvancedCriteria());
    }

    protected boolean getDefaultAllowAdvancedCriteria() {
        return true;
    }

    public List extractFieldNamesFromAdvancedCriteria(Map advancedCriteria) {
        ArrayList fieldNames = new ArrayList();
        ArrayList<Map> criteria = (ArrayList<Map>)advancedCriteria.get("criteria");
        if (criteria == null) {
            criteria = new ArrayList<Map>();
            criteria.add(advancedCriteria);
        }
        return this.extractFieldNamesRecursively(criteria, fieldNames);
    }

    public List extractFieldNamesRecursively(List criteria, List fieldNames) {
        for (Map criterion : criteria) {
            String fieldName;
            if (criterion.containsKey("criteria")) {
                this.extractFieldNamesRecursively((List)criterion.get("criteria"), fieldNames);
                continue;
            }
            if (!criterion.containsKey("fieldName") || fieldNames.contains(fieldName = (String)criterion.get("fieldName"))) continue;
            fieldNames.add(fieldName);
        }
        return fieldNames;
    }

    public Map extractValuesFromAdvancedCriteria(Map advancedCriteria) {
        HashMap values = new HashMap();
        ArrayList<Map> criteria = (ArrayList<Map>)advancedCriteria.get("criteria");
        if (criteria == null) {
            criteria = new ArrayList<Map>();
            criteria.add(advancedCriteria);
        }
        return this.extractValuesRecursively(criteria, values);
    }

    public Map extractValuesRecursively(List criteria, Map values) {
        for (Map criterion : criteria) {
            if (criterion.containsKey("criteria")) {
                this.extractValuesRecursively((List)criterion.get("criteria"), values);
                continue;
            }
            if (!criterion.containsKey("fieldName")) continue;
            String fieldName = (String)criterion.get("fieldName");
            Object value = criterion.get("value");
            if (values.containsKey(fieldName)) continue;
            values.put(fieldName, value);
        }
        return values;
    }

    public static DataSource getElementType(Element element, ValidationContext context) throws Exception {
        if (element == null) {
            return null;
        }
        String tagName = element.getTagName();
        String constructor = element.getAttribute("constructor");
        BasicDataSource ds = context.getType(constructor);
        if (ds != null) {
            return ds;
        }
        ds = context.getType(tagName);
        return ds;
    }

    public static Object recordsFromXML(Object data) throws Exception {
        return DataSource.recordsFromXML(data, new ValidationContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object recordsFromXML(Object data, ValidationContext context) throws Exception {
        String loadID;
        DataSource ds;
        Element element;
        block12: {
            block13: {
                if (data instanceof List) {
                    return DataSource.recordsFromXML((List)data, context);
                }
                if (!(data instanceof Element)) {
                    return data;
                }
                element = (Element)data;
                ds = DataSource.getElementType(element, context);
                if (ds != null) break block12;
                if (!"true".equals(element.getAttribute("xsi:nil"))) break block13;
                Object var4_4 = null;
                return var4_4;
            }
            if (element.hasAttributes() || !XML.getElementChildren(element).isEmpty()) {
                ds = context.getType("Object");
                break block12;
            }
            String string = XML.toSimpleValue(element);
            return string;
        }
        Object result = ds.toRecords(element, context);
        if ("DataSource".equals(ds.getName()) && (loadID = (String)((Map)result).get("loadID")) != null) {
            DataSource refDS = null;
            try {
                refDS = DataSourceManager.getDataSource(loadID, context.getDSRequest());
                if (refDS == null) {
                    throw new Exception("Unable load DataSource reference by loadID: " + loadID);
                }
                result = refDS.getConfig();
            }
            catch (Throwable throwable) {
                DataSourceManager.freeDataSource(refDS);
                throw throwable;
            }
            DataSourceManager.freeDataSource(refDS);
        }
        if (context.hasErrors()) {
            Logger.validation.warning("Validation errors validating a '" + ds.getName() + "':\n" + DataTools.prettyPrint(context.getErrors()));
        }
        Object object = result;
        return object;
    }

    public static Object recordsFromXML(List elements) throws Exception {
        return DataSource.recordsFromXML(elements, new ValidationContext());
    }

    public static Object recordsFromXML(List elements, ValidationContext context) throws Exception {
        ArrayList<Object> values = new ArrayList<Object>();
        Iterator e = elements.iterator();
        while (e.hasNext()) {
            values.add(DataSource.recordsFromXML(e.next(), context));
        }
        return values;
    }

    @Override
    public Object create(Object data, ValidationContext context) throws Exception {
        return this.toRecords(data, context);
    }

    public Object toRecords(Object data) throws Exception {
        return this.toRecords(data, new ValidationContext());
    }

    public Object toRecords(Object data, ValidationContext context) throws Exception {
        throw new Exception("This DataSource does not support validation");
    }

    public Object toRecord(Object data) throws Exception {
        return this.toRecord(data, new ValidationContext());
    }

    public Object toRecord(Object data, ValidationContext context) throws Exception {
        throw new Exception("This DataSource does not support validation");
    }

    public void ds2Schema(DataSource ds, Writer out) throws Exception {
        out.write("<?xml version='1.0' encoding='UTF-8'?>\n");
        out.write("<xs:schema xmlns:xs='http://www.w3.org/2001/XMLSchema'>\n");
        out.write("<xs:element name='" + ds.getName() + "'>");
        out.write("<xs:complexType>");
        out.write("<xs:any processContents='lax'>");
        List fields = ds.getFieldNames();
        for (String fieldName : fields) {
            String xmlType = ds.getField(fieldName).getType();
            out.write("<xs:attribute name='" + fieldName + "' type='" + xmlType + "'>");
        }
        out.write("<xs:anyAttribute processContents='lax'>");
        out.write("</xs:complexType>");
        out.write("</xs:element>");
        out.write("</xs:schema>");
    }

    public static boolean isModificationOperation(String operationType) {
        return DataSource.isAdd(operationType) || DataSource.isRemove(operationType) || DataSource.isUpdate(operationType) || "replace".equals(operationType);
    }

    public boolean isModificationOperation(String opType, String opId) {
        if (DataSource.isModificationOperation(opType)) {
            return true;
        }
        Map opBinding = this.getOperationBinding(opType, opId);
        return opBinding != null && OP_UPDATE.equals(opBinding.get("sqlType"));
    }

    public boolean isModificationRequest(DSRequest req) {
        return this.isModificationOperation(req.getOperationType(), req.getOperationId());
    }

    public static boolean isFetch(String opType) {
        return OP_FETCH.equals(opType) || "select".equals(opType) || "filter".equals(opType);
    }

    public static boolean isAdd(String opType) {
        return OP_ADD.equals(opType) || "insert".equals(opType);
    }

    public static boolean isRemove(String opType) {
        return OP_REMOVE.equals(opType) || "delete".equals(opType);
    }

    public static boolean isUpdate(String opType) {
        return OP_UPDATE.equals(opType);
    }

    public static boolean isDownload(String opType) {
        return "downloadFile".equals(opType) || "viewFile".equals(opType);
    }

    public static boolean isCustom(String opType) {
        return OP_CUSTOM.equals(opType);
    }

    public static boolean isCrud(String opType) {
        return DataSource.isAdd(opType) || DataSource.isFetch(opType) || DataSource.isUpdate(opType) || DataSource.isRemove(opType);
    }

    public static boolean isAddOrUpdate(String opType) {
        return DataSource.isAdd(opType) || DataSource.isUpdate(opType);
    }

    public static boolean isValidate(String opType) {
        return OP_VALIDATE.equals(opType);
    }

    public DSResponse execute(DSRequest req) throws Exception {
        DSResponse res;
        DSResponse validationFailure;
        req.registerFreeResourcesHandler(this);
        String operationType = req.getOperationType();
        if (!DataSource.isCustom(operationType) && (validationFailure = this.validateDSRequest(req)) != null) {
            return validationFailure;
        }
        req.setRequestStarted(true);
        if (DataSource.isFetch(operationType)) {
            return this.executeFetch(req);
        }
        if (DataSource.isAdd(operationType)) {
            res = this.executeAdd(req);
            this.makeAuditIfRequired(req, res);
            return res;
        }
        if (DataSource.isRemove(operationType)) {
            res = this.executeRemove(req);
            this.makeAuditIfRequired(req, res);
            return res;
        }
        if (DataSource.isUpdate(operationType)) {
            res = this.executeUpdate(req);
            this.makeAuditIfRequired(req, res);
            return res;
        }
        if (operationType.equals("replace")) {
            return this.executeReplace(req);
        }
        if (operationType.equals("loadSchema")) {
            return this.executeLoadDS(req);
        }
        if (DataSource.isDownload(operationType)) {
            return this.executeDownload(req);
        }
        if (operationType.equals(OP_VALIDATE)) {
            DSResponse dsResponse = new DSResponse(this);
            dsResponse.setSuccess();
            return dsResponse;
        }
        if (operationType.equals(OP_CLIENT_EXPORT)) {
            return this.executeClientExport(req);
        }
        return this.executeCustom(req);
    }

    private DSResponse makeAuditIfRequired(DSRequest req, DSResponse res) throws Exception {
        if (res == null || res.statusIsError()) {
            return null;
        }
        BasicDataSource ds = (BasicDataSource)req.getDataSource();
        if (!ds.getConfig().containsKey("audit") || "false".equals(ds.getConfig().get("audit"))) {
            return null;
        }
        BasicDataSource auditDS = (BasicDataSource)ds.getAuditDataSource();
        DSRequest audit = new DSRequest();
        HashMap<String, Object> values = new HashMap<String, Object>();
        if (OP_REMOVE.equals(req.getOperationType())) {
            Map oldValues = req.getOldValues();
            if (oldValues != null) {
                values.putAll(oldValues);
            }
        } else {
            values.putAll(res.getDataMap());
        }
        String fieldName = ds.getAuditUserFieldName();
        if (fieldName != null) {
            values.put(fieldName, req.getUserId());
        }
        if ((fieldName = ds.getAuditTypeFieldName()) != null) {
            values.put(fieldName, req.getOperationType());
        }
        if ((fieldName = ds.getAuditTimestampFieldName()) != null) {
            values.put(fieldName, new Date());
        }
        if (ds.getPrimaryKey() != null) {
            res.getDataField(ds.getPrimaryKey());
            values.put(ds.getPrimaryKey(), res.getDataField(ds.getPrimaryKey()));
        }
        audit.setValues(values);
        audit.setOldValues(req.getOldValues());
        audit.setDataSource(auditDS);
        audit.setOperationType(OP_ADD);
        audit.setRPCManager(req.getRPCManager());
        DSResponse resp = audit.execute();
        if (resp.statusIsError()) {
            log.error("There was an error executing the audit request. ");
            throw new Exception("There was an error executing the audit request.");
        }
        return resp;
    }

    public String getAuditTypeFieldName() {
        return AuditDSGenerator.getAuditTypeFieldName(this);
    }

    public String getAuditRevisionFieldName() {
        return AuditDSGenerator.getAuditRevisionFieldName(this);
    }

    public String getAuditTimestampFieldName() {
        return AuditDSGenerator.getAuditTimestampFieldName(this);
    }

    public String getAuditUserFieldName() {
        return AuditDSGenerator.getAuditUserFieldName(this);
    }

    public Object setProperties(Map properties, Object target) {
        return this.setProperties(properties, target, null, true);
    }

    public Object setProperties(Map properties, Object target, DSRequest dsRequest) {
        return this.setProperties(properties, target, dsRequest, true);
    }

    public Object setProperties(Map properties, Object target, DSRequest dsRequest, boolean clearContext) {
        if (properties == null) {
            properties = new HashMap();
        }
        JXPathContext context = null;
        HashMap tryAsBean = null;
        HashMap adaptedProperties = new HashMap();
        for (String fieldName : properties.keySet()) {
            RelationFieldInfo relationFieldInfo;
            DSField field = this.getField(fieldName);
            if (field == null) continue;
            Object value = properties.get(fieldName);
            if (this.handlesRelations() && this.relationFields != null && (relationFieldInfo = this.relationFields.get(fieldName)) != null) {
                try {
                    this.setRelationFieldValue(relationFieldInfo, target, value);
                }
                catch (Exception e) {
                    log.warn("Couldn't set property '" + fieldName + "' for datasource '" + this.getName() + "'. Actual error: " + (log.isDebugEnabled() ? DataTools.getStackTrace(e) : e.toString()));
                }
                continue;
            }
            String valueXPath = field.getValueWriteXPath();
            String string = valueXPath = valueXPath != null ? valueXPath : field.getValueXPath();
            if (valueXPath == null) {
                if (tryAsBean == null) {
                    tryAsBean = new HashMap();
                }
                if (value instanceof Collection || value instanceof Map) {
                    try {
                        PropertyDescriptor pd = null;
                        try {
                            pd = new PropertyDescriptor(fieldName, target.getClass());
                        }
                        catch (IntrospectionException introspectionException) {
                            // empty catch block
                        }
                        if (pd != null) {
                            value = this.adaptValue(pd, field, value, dsRequest);
                            adaptedProperties.put(fieldName, value);
                        }
                    }
                    catch (Exception e) {
                        log.warn("Exception trying to adapt collection/map: " + fieldName + " for datasource: " + this.getName() + ".  Actual error: " + e.toString());
                    }
                }
                tryAsBean.put(fieldName, value);
                continue;
            }
            if (context == null) {
                context = JXPathContext.newContext((Object)target);
                context.setFactory((AbstractFactory)JXPathContextObjectFactory.getInstance());
            }
            if (valueXPath.contains("/")) {
                try {
                    context.createPath(valueXPath.substring(0, valueXPath.lastIndexOf("/")));
                }
                catch (Exception e) {
                    log.warn("Exception trying to create path for valueXPath: " + valueXPath + " for datasource: " + this.getName() + ".  Actual error: " + e.toString());
                }
            }
            Object adaptedValue = value;
            try {
                Pointer p = context.getPointer(valueXPath);
                if (p instanceof BeanPropertyPointer) {
                    BeanPropertyPointer bpp = (BeanPropertyPointer)p;
                    Object bean = bpp.getBean();
                    PropertyDescriptor pd = new PropertyDescriptor(bpp.getPropertyName(), bean.getClass());
                    if (pd != null) {
                        adaptedValue = this.adaptValue(pd, field, value, dsRequest);
                    }
                }
            }
            catch (Exception e) {
                log.warn("Exception trying to adapt value for valueXPath: " + valueXPath + " for datasource: " + this.getName() + ".  Actual error: " + e.toString());
            }
            try {
                context.setValue(valueXPath, adaptedValue);
            }
            catch (Exception e) {
                log.warn("Couldn't set value at valueXPath: " + valueXPath + " for datasource: " + this.getName() + " - ignoring.  Actual error: " + e.toString());
            }
        }
        for (Object key : adaptedProperties.keySet()) {
            properties.put(key, adaptedProperties.get(key));
            tryAsBean.put((String)key, adaptedProperties.get(key));
        }
        if (tryAsBean != null) {
            try {
                DataTools.setProperties(tryAsBean, target, this, null, clearContext);
            }
            catch (Exception e) {
                log.warn("Exception trying to set properties for datasource: " + this.getName() + " from: " + tryAsBean + " to: " + target + ". Actual error: " + e.toString());
                e.printStackTrace();
            }
        }
        return target;
    }

    private Object adaptValue(PropertyDescriptor pd, DSField field, Object value, DSRequest dsRequest) throws Exception {
        Class javaClass = null;
        Class javaCollectionClass = null;
        Class javaKeyClass = null;
        try {
            javaClass = this._getPropertyJavaClass(field.getName(), field, value);
            String typeName = field.getProperty("javaCollectionClass");
            if (typeName != null) {
                javaCollectionClass = Reflection.classForName(typeName);
            }
            if ((typeName = field.getProperty("javaKeyClass")) != null) {
                javaKeyClass = Reflection.classForName(typeName);
            }
        }
        catch (Exception e) {
            log.warn(e.getClass().getName() + " " + e.getMessage() + " encountered " + "whilst trying to derive Java classes from override class names " + "for DataSource '" + this.getName() + "', field name '" + field.getName() + "'");
        }
        Method method = pd.getWriteMethod();
        Class<?>[] argTypes = method.getParameterTypes();
        List genericInfo = VersionSafeChecker.getGenericParameterTypes(method);
        VersionSafeChecker.GenericParameterNode targetGenericInfo = null;
        if (genericInfo != null && genericInfo.size() > 0) {
            targetGenericInfo = (VersionSafeChecker.GenericParameterNode)genericInfo.get(0);
        }
        if (targetGenericInfo != null && targetGenericInfo.getClassByIndex(0) == argTypes[0]) {
            targetGenericInfo = targetGenericInfo.getChildNode();
        }
        ReflectionArgument reflectionArg = new ReflectionArgument(value.getClass(), value, true, true);
        if (argTypes.length > 0) {
            String fieldType = field.getType();
            DataSource subDataSource = fieldType == null ? null : DataSourceManager.get(fieldType, dsRequest);
            value = Reflection.adaptValue(argTypes[0], targetGenericInfo, reflectionArg, null, subDataSource, javaClass, javaCollectionClass, javaKeyClass, dsRequest);
        }
        return value;
    }

    public List getListProperties(List list) {
        return this.getListProperties(list, true, true);
    }

    public List getListProperties(List list, boolean dropExtraFields, boolean dropIgnoredFields) {
        ArrayList<Map> rtn = new ArrayList<Map>();
        ValidationContext vc = new ValidationContext();
        Iterator i = list.iterator();
        while (i.hasNext()) {
            rtn.add(this.getProperties(i.next(), dropExtraFields, dropIgnoredFields, vc));
        }
        return rtn;
    }

    public Map getProperties(Object obj) {
        return this.getProperties(obj, true, true);
    }

    public Map getProperties(Object obj, boolean dropExtraFields, boolean dropIgnoredFields) {
        return this.getProperties(obj, null, dropExtraFields, dropIgnoredFields);
    }

    public Map getProperties(Object obj, boolean dropExtraFields, boolean dropIgnoredFields, ValidationContext validationContext) {
        return this.getProperties(obj, null, dropExtraFields, dropIgnoredFields, validationContext);
    }

    public Map getProperties(Object obj, Collection propsToKeep) {
        return this.getProperties(obj, propsToKeep, false, false);
    }

    public Map getProperties(Object obj, Collection propsToKeep, ValidationContext validationContext) {
        return this.getProperties(obj, propsToKeep, false, false, validationContext);
    }

    public Map getProperties(Object obj, Collection propsToKeep, boolean dropExtraFields, boolean dropIgnoredFields) {
        return this.getProperties(obj, propsToKeep, dropExtraFields, dropIgnoredFields, null);
    }

    public Map getProperties(Object obj, Collection propsToKeep, boolean dropExtraFields, boolean dropIgnoredFields, ValidationContext validationContext) {
        return this.getProperties(obj, propsToKeep, dropExtraFields, dropIgnoredFields, validationContext, null);
    }

    public Map getProperties(Object obj, Collection propsToKeep, boolean dropExtraFields, boolean dropIgnoredFields, ValidationContext validationContext, List recursedList) {
        return this.getProperties(obj, propsToKeep, dropExtraFields, dropIgnoredFields, validationContext, recursedList, null);
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public Map getProperties(Object obj, Collection propsToKeep, boolean dropExtraFields, boolean dropIgnoredFields, ValidationContext validationContext, List recursedList, Collection propsToDrop) {
        if (obj == null) {
            return null;
        }
        if (DataTools.containsByReference(recursedList = recursedList == null ? new ArrayList<Object>() : new ArrayList<E>(recursedList), obj)) {
            DataSource.log.warn(obj.getClass().getName() + " contains a (potentially indirect) looping" + " reference to itself.  Returning null for recursed value.");
            return null;
        }
        recursedList.add(obj);
        context = null;
        tryAsBean = null;
        ignoredFields = new HashMap<String, String>();
        hadRelation = null;
        hadXPath = null;
        result = new LinkedMap();
        recordIsPlainMap = false;
        if (validationContext != null && validationContext.dsRequest != null && obj instanceof Map) {
            recordIsPlainMap = validationContext.dsRequest.isGroupBy();
            if (!recordIsPlainMap) {
                v0 = recordIsPlainMap = validationContext.dsRequest.getConsolidatedOutputs() != null && validationContext.dsRequest.getConsolidatedOutputs().size() > 0;
            }
            if (!recordIsPlainMap) {
                recordIsPlainMap = validationContext.dsRequest.getGroupFunctionFields() != null && validationContext.dsRequest.getGroupFunctionFields().size() > 0;
            }
        }
        fieldNames = this.getFieldNames(false);
        for (String fieldName : fieldNames) {
            if (propsToKeep != null && !propsToKeep.contains(fieldName) || propsToDrop != null && propsToDrop.contains(fieldName)) continue;
            field = this.getField(fieldName);
            if (dropIgnoredFields && DataTools.getBoolean(field, "ignore")) {
                ignoredFields.put(fieldName, "ignore");
                continue;
            }
            if (dropExtraFields && DataTools.getBoolean(field, "unknownType") && !(fields = (Map)this.dsConfig.get("fields")).containsKey(fieldName)) continue;
            if (this.handlesRelations() && this.relationFields != null && !recordIsPlainMap && (!(obj instanceof Map) || obj instanceof ISCMapBean) && (relationFieldInfo = this.relationFields.get(fieldName)) != null) {
                try {
                    result.put((Object)fieldName, this.getRelationFieldValue(relationFieldInfo, obj, recursedList, validationContext));
                    if (hadRelation == null) {
                        hadRelation = new ArrayList<String>();
                    }
                    hadRelation.add(fieldName);
                }
                catch (Exception e) {
                    DataSource.log.warn("Couldn't get value for property '" + fieldName + "' for datasource '" + this.getName() + "' - ignoring. Actual error: " + (DataSource.log.isDebugEnabled() != false ? DataTools.getStackTrace(e) : e.toString()));
                }
                continue;
            }
            valueXPath = field.getValueXPath();
            if (valueXPath == null || recordIsPlainMap) {
                if (tryAsBean == null) {
                    tryAsBean = new ArrayList<String>();
                }
                tryAsBean.add(fieldName);
                continue;
            }
            if (hadXPath == null) {
                hadXPath = new ArrayList<String>();
            }
            hadXPath.add(fieldName);
            if (context == null) {
                context = JXPathContext.newContext((Object)obj);
            }
            context.setLenient(field.isLenientXPath());
            try {
                value = null;
                if (field.isMultiple()) {
                    valueList = null;
                    valueIterator = context.iterate(valueXPath);
                    while (valueIterator.hasNext()) {
                        if (valueList == null) {
                            valueList = new ArrayList<E>();
                        }
                        valueList.add(valueIterator.next());
                    }
                    value = valueList;
                } else {
                    value = context.getValue(valueXPath);
                }
                subDS /* !! */  = null;
                subDS /* !! */  = validationContext != null ? validationContext.getType(field.getType()) : DataSourceManager.get(field.getType(), null);
                if (subDS /* !! */  != null) {
                    value = this.getSubValue(subDS /* !! */ , field, value, dropExtraFields, dropIgnoredFields, validationContext, recursedList);
                }
                result.put((Object)fieldName, value);
            }
            catch (Exception e) {
                DataSource.log.warn("Couldn't get value at valueXPath: " + valueXPath + " for datasource: " + this.getName() + " - ignoring.  Actual error: " + e.toString());
            }
        }
        if (!dropExtraFields || tryAsBean != null || propsToKeep != null) {
            block61: {
                beanValues = null;
                if (!(obj instanceof Map) || obj instanceof ISCMapBean) {
                    try {
                        if (propsToKeep != null) {
                            if (hadXPath != null) {
                                propsToKeep = new ArrayList<E>(propsToKeep);
                                propsToKeep.removeAll(hadXPath);
                            }
                            if (hadRelation != null) {
                                propsToKeep = new ArrayList<E>(propsToKeep);
                                propsToKeep.removeAll(hadRelation);
                            }
                            beanValues = DataTools.getProperties(obj, propsToKeep);
                            break block61;
                        }
                        if (hadXPath != null && tryAsBean != null) {
                            tryAsBean.removeAll(hadXPath);
                        }
                        if (hadRelation != null && tryAsBean != null) {
                            tryAsBean.removeAll(hadRelation);
                        }
                        if (dropExtraFields) {
                            beanValues = DataTools.getProperties(obj, tryAsBean);
                            break block61;
                        }
                        properties = DataTools.getPropertyDescriptors(obj).keySet();
                        if (ignoredFields != null) {
                            properties.removeAll(ignoredFields.keySet());
                        }
                        if (hadXPath != null) {
                            properties.removeAll(hadXPath);
                        }
                        if (hadRelation != null) {
                            properties.removeAll(hadRelation);
                        }
                        beanValues = DataTools.getProperties(obj, properties);
                    }
                    catch (Exception e) {
                        DataSource.log.warn("Couldn't get values: " + tryAsBean.toString() + " for datasource: " + this.getName() + " - ignoring.  Actual error: " + e.toString());
                    }
                } else {
                    beanValues = new HashMap<K, V>();
                }
            }
            i = beanValues.keySet().iterator();
            while (i.hasNext()) {
                key = i.next().toString();
                if (propsToDrop != null && propsToDrop.contains(key)) {
                    i.remove();
                    continue;
                }
                field = this.getField(key.toString());
                if (field == null || beanValues.get(key) instanceof IToJSON) continue;
                try {
                    subDS /* !! */  = validationContext != null ? validationContext.getType(field.getType()) : DataSourceManager.get(field.getType(), null);
                    if (subDS /* !! */  == null) continue;
                    value = this.getSubValue(subDS /* !! */ , field, beanValues.get(key), dropExtraFields, dropIgnoredFields, validationContext, recursedList);
                    beanValues.put(key, value);
                }
                catch (Exception e) {
                    DataSource.log.warn((Object)("Error looking for sub-DataSource " + field.getType() + " in datasource: " + this.getName()), e);
                }
            }
            if (obj instanceof Map) {
                i = null;
                i = propsToKeep != null ? propsToKeep.iterator() : (dropExtraFields != false ? tryAsBean.iterator() : DataTools.mapDisjunction((Map)obj, ignoredFields).keySet().iterator());
                while (i.hasNext()) {
                    key = i.next();
                    if (propsToDrop != null && propsToDrop.contains(key) || beanValues.get(key) != null) continue;
                    value /* !! */  = ((Map)obj).get(key);
                    field = this.getField(key.toString());
                    if (field != null && !(value /* !! */  instanceof IToJSON)) {
                        try {
                            subDS /* !! */  = validationContext != null ? validationContext.getType(field.getType()) : DataSourceManager.get(field.getType(), null);
                            if (subDS /* !! */  != null) {
                                value /* !! */  = this.getSubValue(subDS /* !! */ , field, value /* !! */ , dropExtraFields, dropIgnoredFields, validationContext, recursedList);
                            }
                        }
                        catch (Exception e) {
                            DataSource.log.warn((Object)("Error looking for sub-DataSource " + field.getType() + " in datasource: " + this.getName()), e);
                        }
                    }
                    if (value /* !! */  == null) continue;
                    beanValues.put(key, value /* !! */ );
                }
            } else if (DataSource.config.getBoolean((Object)"supportDynamicBeans", false) && tryAsBean != null && dropExtraFields) {
                try {
                    getter = Reflection.findMethod(obj, "get");
                    if (getter == null) ** GOTO lbl185
                    for (String propertyName : tryAsBean) {
                        if (beanValues.get(propertyName) != null) continue;
                        params = new String[]{propertyName};
                        value = getter.invoke(obj, params);
                        field = this.getField(propertyName.toString());
                        if (field != null && !(value instanceof IToJSON)) {
                            try {
                                subDS /* !! */  = validationContext != null ? validationContext.getType(field.getType()) : DataSourceManager.get(field.getType(), null);
                                if (subDS /* !! */  != null) {
                                    value = this.getSubValue(subDS /* !! */ , field, value, dropExtraFields, dropIgnoredFields, validationContext, recursedList);
                                }
                            }
                            catch (Exception e) {
                                DataSource.log.warn((Object)("Error looking for sub-DataSource " + field.getType() + " in datasource: " + this.getName()), e);
                            }
                        }
                        if (value == null) continue;
                        beanValues.put(propertyName, value);
                    }
                }
                catch (Exception e) {
                    if (e instanceof NoSuchMethodException) ** GOTO lbl185
                    DataSource.log.warn("Error trying to mine dynamic bean.  Actual error: " + e.toString());
                }
            }
lbl185:
            // 7 sources

            if (hadXPath != null) {
                for (Object key : hadXPath) {
                    if (!hadXPath.contains(key)) continue;
                    beanValues.remove(key);
                }
            }
            DataTools.putAllNotPresent((Map)result, beanValues);
        }
        for (String fieldName : fieldNames) {
            value = result.get((Object)fieldName);
            if (value == null || !(value instanceof Date) || value instanceof ISCDate || value instanceof ISCTime) continue;
            field = this.getField(fieldName);
            fieldType = null;
            try {
                bds_this = (BasicDataSource)this;
                fieldType = bds_this.getSimpleBaseType(field.getType());
                if ("date".equals(fieldType) && !bds_this.simpleTypeInheritsFrom(field.getType(), "datetime") && !bds_this.simpleTypeInheritsFrom(field.getType(), "dateTime")) {
                    value = new ISCDate(((Date)value).getTime());
                    result.put((Object)fieldName, value);
                    continue;
                }
                if (!"time".equals(fieldType)) continue;
                value = new ISCTime(((Date)value).getTime());
                result.put((Object)fieldName, value);
            }
            catch (Exception e) {
                DataSource.log.warn((Object)("Unable to look up simpleBaseType for field: " + fieldName), e);
            }
        }
        return result;
    }

    private Object getSubValue(DataSource subDS, DSField field, Object value, boolean dropExtraFields, boolean dropIgnoredFields, ValidationContext validationContext, List recursedList) {
        dropExtraFields = subDS.dropExtraFields();
        if (value == null) {
            return null;
        }
        if (value instanceof JSONFilter && ((JSONFilter)value).getObj() instanceof Collection) {
            JSONFilter filter = (JSONFilter)value;
            ArrayList<Map> list = new ArrayList<Map>();
            Collection valueCollection = (Collection)filter.getObj();
            for (Object item : valueCollection) {
                IBeanFilter beanFilter = filter.getBeanFilter();
                Map record = subDS.getSubProperties(new JSONFilter(item, beanFilter), dropExtraFields, dropIgnoredFields, validationContext, recursedList);
                list.add(record);
            }
            return list;
        }
        if (value instanceof Collection || field.getBoolean("multiple")) {
            ArrayList<Map> list = new ArrayList<Map>();
            if (value instanceof Collection) {
                Iterator i = ((Collection)value).iterator();
                while (i.hasNext()) {
                    Map record = subDS.getSubProperties(i.next(), dropExtraFields, dropIgnoredFields, validationContext, recursedList);
                    list.add(record);
                }
            } else {
                if (value instanceof Map) {
                    LinkedMap map = new LinkedMap();
                    for (Object key : ((Map)value).keySet()) {
                        Object mapValue = ((Map)value).get(key);
                        if (this.isSerializable(mapValue)) {
                            map.put(key, mapValue);
                            continue;
                        }
                        Map record = subDS.getSubProperties(mapValue, dropExtraFields, dropIgnoredFields, validationContext, recursedList);
                        map.put(key, record);
                    }
                    return map;
                }
                list.add(subDS.getSubProperties(value, dropExtraFields, dropIgnoredFields, validationContext, recursedList));
            }
            return list;
        }
        return subDS.getSubProperties(value, dropExtraFields, dropIgnoredFields, validationContext, recursedList);
    }

    private Map getSubProperties(Object value, boolean dropExtraFields, boolean dropIgnoredFields, ValidationContext validationContext, List recursedList) {
        Map record = null;
        JSONFilter filter = null;
        IBeanFilter beanFilter = null;
        if (value instanceof JSONFilter) {
            filter = (JSONFilter)value;
            value = filter.getObj();
            beanFilter = filter.getBeanFilter();
        }
        try {
            record = beanFilter instanceof IContextBeanFilter ? ((IContextBeanFilter)beanFilter).filter(value, validationContext) : (beanFilter != null ? beanFilter.filter(value) : this.getProperties(value, null, dropExtraFields, dropIgnoredFields, validationContext, recursedList));
        }
        catch (Exception e) {
            log.warn((Object)"Error trying to get sub-object properties", e);
        }
        return record;
    }

    private boolean isSerializable(Object obj) {
        return obj instanceof String || obj instanceof Number || obj instanceof Boolean || obj instanceof Date || VersionSafeChecker.isEnum(obj);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List computeOutputColumns(DSRequest request) {
        String opId;
        ArrayList<String> outputColumns = null;
        if (request == null) {
            return null;
        }
        String opType = request.getOperationType();
        Map opBinding = this.getOperationBinding(opType, opId = request.getOperationId());
        if (opBinding != null && opBinding.get("outputs") != null) {
            String outputString = (String)opBinding.get("outputs");
            String[] outputArray = outputString.split(",");
            outputColumns = new ArrayList<String>();
            for (int i = 0; i < outputArray.length; ++i) {
                outputColumns.add(outputArray[i].trim());
            }
        }
        if (request.outputs() != null) {
            if (outputColumns != null) {
                if (!outputColumns.containsAll(request.outputs())) return null;
                outputColumns = request.outputs();
            } else {
                if (!this.getFieldNames().containsAll(request.outputs())) return null;
                outputColumns = request.outputs();
            }
        }
        if (outputColumns == null || !outputColumns.isEmpty()) return outputColumns;
        return null;
    }

    public ErrorReport validate(Map data, boolean reportMissingRequiredFields) throws Exception {
        ValidationContext context = new ValidationContext();
        context.setPropertiesOnly(!reportMissingRequiredFields);
        this.toRecords(data, context);
        Map errors = context.getErrors();
        if (errors == null) {
            return null;
        }
        return (ErrorReport)errors.values().toArray()[0];
    }

    public DSResponse validateDSRequest(DSRequest dsRequest) throws Exception {
        if (dsRequest.getBeenThroughValidation()) {
            return null;
        }
        dsRequest.setBeenThroughValidation(true);
        List errors = DataSource.validateDSRequest(this, dsRequest);
        if (errors != null) {
            Logger.validation.info("Validation error: " + DataTools.prettyPrint(errors));
            DSResponse dsResponse = new DSResponse(this);
            dsResponse.setStatus(DSResponse.STATUS_VALIDATION_ERROR);
            dsResponse.setErrors(errors);
            return dsResponse;
        }
        return null;
    }

    public static List validateDSRequest(DataSource dataSource, DSRequest dsRequest) throws Exception {
        Object errors;
        String operationType = dsRequest.getOperationType();
        if (DataSource.isRemove(operationType) || !DataSource.isModificationOperation(operationType) && !OP_VALIDATE.equals(operationType)) {
            return null;
        }
        ValidationContext context = new ValidationContext();
        if ("partial".equals(dsRequest.getValidationMode())) {
            context.setPropertiesOnly(true);
        }
        context.setRPCManager(dsRequest.rpc);
        context.setRequestContext(dsRequest.getRequestContext());
        if (dsRequest.getOperationType().equals(OP_UPDATE)) {
            context.setPropertiesOnly();
        }
        context.setDSRequest(dsRequest);
        dsRequest.setValidatedValues(dataSource.toRecords(dsRequest.getValueSets(), context));
        if (log.isDebugEnabled()) {
            log.debug("post-validation valueSet: " + DataTools.prettyPrint(dsRequest.getValueSets()));
        }
        if ((errors = context.getErrors()) != null) {
            errors = ErrorReport.toImpliedForm((Map)errors);
            ArrayList<Object> errorList = new ArrayList<Object>();
            errorList.add(errors);
            return errorList;
        }
        return null;
    }

    public Map validateOperationBinding(DSRequest dsRequest, Map operationBinding) throws Exception {
        return operationBinding;
    }

    public DSResponse executeFetch(DSRequest req) throws Exception {
        return this.notSupported(req);
    }

    public DSResponse executeRemove(DSRequest req) throws Exception {
        return this.notSupported(req);
    }

    public DSResponse executeAdd(DSRequest req) throws Exception {
        return this.notSupported(req);
    }

    public DSResponse executeUpdate(DSRequest req) throws Exception {
        return this.notSupported(req);
    }

    public DSResponse executeReplace(DSRequest req) throws Exception {
        return this.notSupported(req);
    }

    public DSResponse executeDownload(DSRequest req) throws Exception {
        return this.notSupported(req);
    }

    public DSResponse executeCustom(DSRequest req) throws Exception {
        return this.notSupported(req);
    }

    public DSResponse executeClientExport(DSRequest req) throws Exception {
        return this.notSupported(req);
    }

    public DSResponse executeLoadDS(DSRequest req) throws Exception {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("dsName", this.getName());
        result.put("dsData", JSTranslater.instance().toJS(this.getConfig()));
        DSResponse dsResponse = new DSResponse(this);
        dsResponse.setBypassDataFilter(true);
        ArrayList<HashMap<String, String>> list = new ArrayList<HashMap<String, String>>();
        list.add(result);
        dsResponse.setData(list);
        return dsResponse;
    }

    protected DSResponse notSupported(DSRequest req) throws Exception {
        throw new Exception("Operation type '" + req.getOperationType() + "' not supported by this DataSource (" + this.getName() + ")");
    }

    public Object getLastRow() throws Exception {
        throw new Exception("Not supported by this DataSource (" + this.getName() + ")");
    }

    public Map getLastPrimaryKeys() throws Exception {
        throw new Exception("Not supported by this DataSource (" + this.getName() + ")");
    }

    public void clearState() {
        this.clearAnnotatedConfig();
    }

    public List fetch(Object criteria) throws Exception {
        DSRequest req = new DSRequest(this.getName(), OP_FETCH);
        req.setCriteria(criteria);
        return req.execute().getDataList();
    }

    public List fetch(String key, Object value) throws Exception {
        return this.fetch(DataTools.buildMap(key, value));
    }

    public List filter(Object criteria) throws Exception {
        DSRequest req = new DSRequest(this.getName(), "filter");
        req.setCriteria(criteria);
        return req.execute().getDataList();
    }

    public List filter(String key, Object value) throws Exception {
        return this.filter(DataTools.buildMap(key, value));
    }

    public long add(Object values) throws Exception {
        DSRequest req = new DSRequest(this.getName(), OP_ADD);
        req.setValues(values);
        return req.execute().getAffectedRows();
    }

    public long replace(Object values) throws Exception {
        DSRequest req = new DSRequest(this.getName(), "replace");
        req.setValues(values);
        return req.execute().getAffectedRows();
    }

    public long update(Object criteria, Object values) throws Exception {
        DSRequest req = new DSRequest(this.getName(), OP_UPDATE);
        req.setCriteria(criteria);
        req.setValues(values);
        return req.execute().getAffectedRows();
    }

    public long remove(Object criteria) throws Exception {
        DSRequest req = new DSRequest(this.getName(), OP_REMOVE);
        req.setCriteria(criteria);
        return req.execute().getAffectedRows();
    }

    public long insert(Object values) throws Exception {
        return this.add(values);
    }

    public long delete(Object criteria) throws Exception {
        return this.remove(criteria);
    }

    public List select(Object criteria) throws Exception {
        return this.fetch(criteria);
    }

    public List select(String key, Object value) throws Exception {
        return this.fetch(key, value);
    }

    public Map selectSingle(Object criteria) throws Exception {
        return this.fetchSingle(criteria);
    }

    public Map selectSingle(String key, Object value) throws Exception {
        return this.fetchSingle(key, value);
    }

    public Map selectUnique(Map criteria) throws Exception {
        throw new Exception("not supported by this class");
    }

    public Map fetchSingle(String key, Object value) throws Exception {
        return this.forceSingle(this.fetch(key, value));
    }

    public Map fetchSingle(Object criteria) throws Exception {
        return this.forceSingle(this.fetch(criteria));
    }

    public String getTransactionObjectKey() throws Exception {
        return this.TRANSACTION_OBJECT_KEY;
    }

    public Object getTransactionObject(DSRequest req) throws Exception {
        return DataSource.getTransactionObject(req, this.getTransactionObjectKey());
    }

    public static Object getTransactionObject(DSRequest req, String transactionObjectKey) throws Exception {
        if (req == null) {
            throw new Exception("DSRequest must not be null");
        }
        if (req.rpc == null) {
            return null;
        }
        return req.rpc.getAttribute(transactionObjectKey);
    }

    protected Map forceSingle(List result) throws Exception {
        if (result.isEmpty()) {
            return null;
        }
        if (result.size() > 1) {
            throw new Exception("Fetched multiple results when trying single");
        }
        return (Map)result.get(0);
    }

    protected Object forceSingleObject(List result) throws Exception {
        if (result == null || result.isEmpty()) {
            return null;
        }
        if (result.size() > 1) {
            throw new Exception("Fetched multiple results when trying single");
        }
        return result.get(0);
    }

    public String toXML() {
        return this.toXML(this.dsConfig);
    }

    public String toXML(Map dsConfig) {
        StringBuffer buf = new StringBuffer();
        buf.append("<DataSource \n");
        ArrayList complexValueKeys = new ArrayList();
        for (Object key : dsConfig.keySet()) {
            Object value = dsConfig.get(key);
            if (value instanceof List || value instanceof Map) {
                if ("fields".equals(key.toString())) continue;
                complexValueKeys.add(key);
                continue;
            }
            buf.append("\t" + key + "=\"" + value + "\"\n");
        }
        buf.append(">\n");
        buf.append("\n\t<fields>\n");
        Object fieldList = dsConfig.get("fields");
        StringWriter fw = new StringWriter();
        Iterator<Object> fields = null;
        if (fieldList instanceof Map) {
            fields = ((Map)fieldList).values().iterator();
        }
        if (fieldList instanceof List) {
            fields = ((List)fieldList).iterator();
        }
        if (fields != null) {
            while (fields.hasNext()) {
                fw.write("\t\t");
                try {
                    XML.recordToXML("field", (Map)fields.next(), fw, true, null);
                }
                catch (Exception exception) {}
            }
        }
        buf.append(fw.toString());
        buf.append("\t</fields>\n");
        for (Object key : complexValueKeys) {
            Object value = dsConfig.get(key);
            StringWriter sw = new StringWriter();
            try {
                if (value instanceof List) {
                    buf.append("\t<" + key.toString() + ">\n");
                    XML.recordsToXML(key.toString().substring(0, key.toString().length() - 1), (List)value, sw, true, null);
                    buf.append("\t\t" + sw.toString());
                    buf.append("\t</" + key.toString() + ">\n");
                    continue;
                }
                if (!(value instanceof Map)) continue;
                XML.recordToXML(key.toString(), (Map)value, sw, true, null);
                buf.append(sw.toString());
            }
            catch (Exception e) {
                log.warn("Unable to XMLSerialize value for key: " + key.toString());
            }
        }
        buf.append("</DataSource>\n");
        return buf.toString();
    }

    @Override
    public void toJSON(Writer out, JSTranslater jsTrans) throws UnconvertableException, IOException {
        Map dsConfig = this.getAnnotatedConfig();
        if (dsConfig == null) {
            dsConfig = this.getConfig();
        }
        HashMap<String, Object> maskedConfig = new HashMap<String, Object>(dsConfig);
        String tableName = (String)maskedConfig.remove("tableName");
        maskedConfig.remove("dbName");
        maskedConfig.remove("schema");
        maskedConfig.remove("serverObject");
        maskedConfig.remove("serverConstructor");
        maskedConfig.remove("schemaBean");
        maskedConfig.remove("beanClassName");
        maskedConfig.remove("configBean");
        maskedConfig.remove("requires");
        maskedConfig.remove("requiresAuthentication");
        maskedConfig.remove("requiresRole");
        maskedConfig.remove("creatorOverrides");
        maskedConfig.remove("lookAhead");
        maskedConfig.remove("endGap");
        maskedConfig.remove("progressiveLoadingThreshold");
        maskedConfig.remove("qualifyColumnNames");
        maskedConfig.remove("quoteColumnNames");
        maskedConfig.remove("sqlPaging");
        maskedConfig.remove("scriptImport");
        maskedConfig.remove("script");
        List operationBindings = (List)maskedConfig.get("operationBindings");
        if (operationBindings != null) {
            ArrayList newBindings = new ArrayList();
            maskedConfig.put("operationBindings", newBindings);
            for (int i = 0; i < operationBindings.size(); ++i) {
                HashMap newBinding = new HashMap((Map)operationBindings.get(i));
                newBinding.remove("serverObject");
                newBinding.remove("customSQL");
                newBinding.remove("customHQL");
                newBinding.remove("selectClause");
                newBinding.remove("tableClause");
                newBinding.remove("whereClause");
                newBinding.remove("valuesClause");
                newBinding.remove("orderClause");
                newBinding.remove("groupClause");
                newBinding.remove("groupWhereClause");
                newBinding.remove("language");
                newBinding.remove("requires");
                newBinding.remove("requiresAuthentication");
                newBinding.remove("requiresRole");
                newBinding.remove("creatorOverrides");
                newBinding.remove("allowMultiUpdate");
                newBinding.remove("customCriteriaFields");
                newBinding.remove("customFields");
                newBinding.remove("customValueFields");
                newBinding.remove("excludeCriteriaFields");
                newBinding.remove("methodArguments");
                newBinding.remove("qualifyColumnNames");
                newBinding.remove("serverMethod");
                newBinding.remove("skipRowCount");
                newBinding.remove("sqlPaging");
                newBinding.remove("sqlType");
                newBinding.remove("scriptImport");
                newBinding.remove("script");
                newBinding.remove("criteria");
                newBinding.remove("values");
                newBindings.add(newBinding);
            }
        }
        if (this instanceof BasicDataSource && ((BasicDataSource)this).autoDeriveDS != null) {
            DataSource inheritsFrom = ((BasicDataSource)this).autoDeriveDS;
            maskedConfig.put("inheritsFrom", inheritsFrom);
        }
        boolean autoLinkFKs = !Boolean.FALSE.equals(config.getBoolean("datasource.autoLinkFKs"));
        Map fields = (Map)maskedConfig.get("fields");
        BasicDataSource superDS = ((BasicDataSource)this).getSuper();
        HashSet<String> suppressedFilenames = new HashSet<String>();
        if (fields != null) {
            ArrayList<Object> fieldList = new ArrayList<Object>();
            for (String fieldName : fields.keySet()) {
                Object fieldObj = fields.get(fieldName);
                boolean bl = false;
                if (!(fieldObj instanceof Map)) {
                    fieldList.add(fieldObj);
                    continue;
                }
                LinkedMap fieldMap = new HashMap((Map)fieldObj);
                if (!fieldMap.containsKey("name")) {
                    if (!bl) {
                        fieldMap = new LinkedMap(fieldMap);
                        bl = true;
                    }
                    fieldMap.put("name", fieldName);
                }
                if (DataTools.getBoolean(fieldMap, "ignore")) {
                    if (fieldName.toLowerCase().endsWith("_filename")) {
                        suppressedFilenames.add(fieldName.substring(0, fieldName.length() - "_filename".length()));
                    }
                    DSField superField = null;
                    if (superDS != null) {
                        superField = ((DataSource)superDS).getField((String)fieldMap.get("name"));
                    }
                    if (superField == null) continue;
                    if (!bl) {
                        fieldMap = new LinkedMap((Map)fieldMap);
                        bl = true;
                    }
                    fieldMap.put("hidden", true);
                }
                if (fieldMap.get("tableName") != null && fieldMap.get("canEdit") == null) {
                    if (!bl) {
                        fieldMap = new LinkedMap((Map)fieldMap);
                        bl = true;
                    }
                    fieldMap.put("canEdit", Boolean.FALSE);
                }
                try {
                    String typeName = (String)fieldMap.get("type");
                    BasicDataSource cfr_ignored_0 = (BasicDataSource)this;
                    Map typeDef = BasicDataSource.getBuiltinType(typeName);
                    if (typeDef != null) {
                        if (fieldMap.get("hidden") == null && typeDef.get("hidden") != null) {
                            fieldMap.put("hidden", new Boolean(typeDef.get("hidden").toString()));
                        }
                        if (fieldMap.get("canView") == null && typeDef.get("canView") != null) {
                            fieldMap.put("canView", new Boolean(typeDef.get("canView").toString()));
                        }
                        if (fieldMap.get("canEdit") == null && typeDef.get("canEdit") != null) {
                            fieldMap.put("canEdit", new Boolean(typeDef.get("canEdit").toString()));
                        }
                        if (fieldMap.get("canSave") == null && typeDef.get("canSave") != null) {
                            fieldMap.put("canSave", new Boolean(typeDef.get("canSave").toString()));
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                String columnName = (String)fieldMap.get("nativeName");
                if (!DataTools.getBoolean((Map)fieldMap, "canView", true)) {
                    Iterator keys = fieldMap.keySet().iterator();
                    while (keys.hasNext()) {
                        String key = (String)keys.next();
                        if ("name".equals(key) || "canView".equals(key)) continue;
                        keys.remove();
                    }
                } else {
                    fieldMap.remove("viewRequires");
                    fieldMap.remove("viewRequiresAuthentication");
                    fieldMap.remove("viewRequiresRole");
                    fieldMap.remove("editRequires");
                    fieldMap.remove("editRequiresAuthentication");
                    fieldMap.remove("editRequiresRole");
                    fieldMap.remove("initRequires");
                    fieldMap.remove("initRequiresAuthentication");
                    fieldMap.remove("initRequiresRole");
                    fieldMap.remove("updateRequires");
                    fieldMap.remove("updateRequiresAuthentication");
                    fieldMap.remove("updateRequiresRole");
                    fieldMap.remove("creatorOverrides");
                    fieldMap.remove("autoQuoteCustomExpressions");
                    fieldMap.remove("customCriteriaExpression");
                    fieldMap.remove("customInsertExpression");
                    fieldMap.remove("customSelectExpression");
                    fieldMap.remove("customSQL");
                    fieldMap.remove("customUpdateExpression");
                    fieldMap.remove("includeFrom");
                    fieldMap.remove("javaClass");
                    fieldMap.remove("javaCollectionClass");
                    fieldMap.remove("javaKeyClass");
                    fieldMap.remove("sequenceName");
                    fieldMap.remove("sqlDateFormat");
                    fieldMap.remove("sqlFalseValue");
                    fieldMap.remove("sqlStorageStrategy");
                    fieldMap.remove("sqlTrueValue");
                    fieldMap.remove("tableName");
                    fieldMap.remove("implicitSequence");
                    fieldMap.remove("typeInherited");
                    fieldMap.remove("typeExplicitlyDeclared");
                    List validatorList = (List)fieldMap.get("validators");
                    if (validatorList != null) {
                        for (int j = 0; j < validatorList.size(); ++j) {
                            Map validatorMap = (Map)validatorList.get(j);
                            validatorMap.remove("serverObject");
                            validatorMap.remove("serverCondition");
                        }
                    }
                }
                String nativeFKs = (String)fieldMap.remove("nativeFK");
                if ("sql".equals(this.getType()) && autoLinkFKs) {
                    if (nativeFKs != null) {
                        String[] parts = nativeFKs.split("\\.");
                        try {
                            String tableCode = DataTools.hashValue(parts[0].toLowerCase());
                            String columnCode = DataTools.hashValue(parts[1].toLowerCase());
                            fieldMap.put("fkTableCode", tableCode);
                            fieldMap.put("fkColumnCode", columnCode);
                        }
                        catch (Exception e) {
                            log.error((Object)"Can't hash foreign key", e);
                        }
                    }
                    if (columnName == null && (columnName = (String)fieldMap.get("nativeName")) == null) {
                        columnName = (String)fieldMap.get("name");
                    }
                    fieldMap.remove("nativeName");
                    try {
                        String columnCode = DataTools.hashValue(columnName.toLowerCase());
                        fieldMap.put("columnCode", columnCode);
                    }
                    catch (Exception e) {
                        log.error((Object)"Can't hash columnName", e);
                    }
                }
                fieldList.add(fieldMap);
            }
            block12: for (String fieldName : suppressedFilenames) {
                if (fieldName == null) continue;
                for (Map map : fieldList) {
                    String nameInList = (String)map.get("name");
                    if (nameInList == null || !fieldName.toLowerCase().equals(nameInList.toLowerCase())) continue;
                    map.put("filenameSuppressed", true);
                    continue block12;
                }
            }
            maskedConfig.put("fields", fieldList);
        }
        if (useAxisForSQLDS && "sql".equals(this.getType())) {
            dsConfig.put("__autoConstruct", "WSDataSource");
        }
        if ("sql".equals(this.getType()) && autoLinkFKs) {
            try {
                if (tableName == null) {
                    tableName = (String)maskedConfig.get("ID");
                }
                String tableCode = DataTools.hashValue(tableName.toLowerCase());
                maskedConfig.put("tableCode", tableCode);
            }
            catch (Exception e) {
                log.error((Object)"Can't hash tableName", e);
            }
        }
        jsTrans.toJS(maskedConfig, out);
    }

    public String getFieldXML() throws Exception {
        return DataSource.getFieldXML(this.fieldList);
    }

    public static String getFieldXML(List fields) throws Exception {
        StringBuffer xml = new StringBuffer();
        xml.append("<fields>\n");
        for (Object map : fields) {
            if (!(map instanceof Map)) {
                log.warn("Found object of type " + map.getClass() + " in list passed to " + "getFieldXML - was expecting Map");
                continue;
            }
            StringWriter out = new StringWriter();
            XML.recordToXML("field", (Map)map, out);
            xml.append("\t");
            xml.append(out.toString());
        }
        xml.append("</fields>\n");
        return xml.toString();
    }

    public String escapeValueForWhereClause(Object value, Object key) {
        return value == null ? null : value.toString();
    }

    public boolean hasRecord(String columnName, Object value) throws Exception {
        HashMap<String, Object> criteria = new HashMap<String, Object>();
        criteria.put(columnName, value);
        return this.hasRecord(criteria);
    }

    public boolean hasRecord(Map criteria) throws Exception {
        DSRequest req = new DSRequest(this.getName(), OP_FETCH);
        req.setCriteria(criteria);
        req.context = req.context;
        DSResponse resp = req.execute();
        return resp.getRowCount() != 0L;
    }

    public Map fetchById(Object id) throws Exception {
        Map<String, Object> criteria;
        List pks = this.getPrimaryKeys();
        if (pks.size() == 0) {
            throw new Exception("Cannot fetch by ID - DataSource has no primary key field");
        }
        if (pks.size() > 1 && id instanceof Map) {
            criteria = (Map)id;
        } else {
            criteria = new HashMap<String, Object>();
            criteria.put(this.getPrimaryKey(), id);
        }
        DSRequest req = new DSRequest(this.getName(), OP_FETCH);
        req.setCriteria(criteria);
        req.context = req.context;
        DSResponse resp = req.execute();
        return resp.getRecord();
    }

    public String getEnumTranslateStrategy() {
        String value = (String)this.dsConfig.get("enumTranslateStrategy");
        if (value == null) {
            boolean autoDerive = DataTools.getBoolean(this.dsConfig, "autoDeriveSchema", false);
            value = autoDerive ? "name" : "string";
        }
        return value;
    }

    public void setEnumTranslateStrategy(String newValue) {
        this.dsConfig.put("enumTranslateStrategy", newValue);
    }

    public String getEnumOrdinalProperty() {
        String value = (String)this.dsConfig.get("enumOrdinalProperty");
        if (value == null) {
            value = "_ordinal";
        }
        return value;
    }

    public String getEnumConstantProperty() {
        String value = (String)this.dsConfig.get("enumConstantProperty");
        if (value == null) {
            value = "_constant";
        }
        return value;
    }

    public void setEnumOrdinalProperty(String newValue) {
        this.dsConfig.put("enumOrdinalProperty", newValue);
    }

    public void setEnumConstantProperty(String newValue) {
        this.dsConfig.put("enumConstantProperty", newValue);
    }

    Evaluator getEvaluator() {
        if (this.evaluator == null) {
            this.evaluator = new Evaluator();
        }
        return this.evaluator;
    }

    public void addSearchOperator(Operator op) {
        this.getEvaluator().addSearchOperator(op);
    }

    public boolean matchesCriteria(Map values, AdvancedCriteria criteria) throws Exception {
        return this.getEvaluator().valuesMatchCriteria(values, criteria);
    }

    public boolean matchesCriteria(Map values, Map rawCriteria) throws Exception {
        AdvancedCriteria criteria = Evaluator.parseAdvancedCriteria(rawCriteria);
        return this.getEvaluator().valuesMatchCriteria(values, criteria);
    }

    @Override
    public void freeResources(DSRequest req) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void freeQueueResources(DSRequest req) {
        try {
            Map<String, DataSource> includes = req.getCachedDataSourceInstances();
            if (includes != null) {
                Iterator<String> i = includes.keySet().iterator();
                while (i.hasNext()) {
                    DataSource ds = includes.get(i.next());
                    if (ds == req.getDataSource()) continue;
                    DataSourceManager.free(ds);
                }
            }
            if (req.getDataSource() != this) {
                DataSourceManager.free(this);
            }
        }
        catch (Exception e) {
            log.warn((Object)"Exception freeing QueueResources", e);
        }
        finally {
            req.setDataSource(null);
        }
    }

    public boolean hasRelation(DataSource relatedDS) throws Exception {
        return this.getRelation(relatedDS) != null;
    }

    public boolean isRelatedThroughPrimaryKey(DataSource relatedDS) throws Exception {
        Relation rel = this.getRelation(relatedDS);
        if (rel == null) {
            return false;
        }
        List<DSField> keys = rel.getToFields();
        if (keys == null || keys.size() == 0) {
            return false;
        }
        boolean allPKs = true;
        Iterator<DSField> i = keys.iterator();
        while (i.hasNext()) {
            if (i.next().isPrimaryKey()) continue;
            allPKs = false;
            break;
        }
        return allPKs;
    }

    protected void addCachedRelationInfo(String key, RelationInfo relationInfo) {
        this.cachedRelations.put(key, relationInfo);
    }

    protected void removeCachedRelation(String key) {
        this.cachedRelations.remove(key);
    }

    protected RelationInfo getCachedRelationInfo(String key) {
        return this.cachedRelations.get(key);
    }

    public void clearCachedRelations() {
        this.cachedRelations.clear();
    }

    public Relation getRelation(DataSource relatedDS) throws Exception {
        return this.getRelation(new DataSource[]{relatedDS}, true, null);
    }

    public Relation getRelation(DataSource relatedDS, boolean logProblems) throws Exception {
        return this.getRelation(new DataSource[]{relatedDS}, logProblems, null);
    }

    public Relation getRelation(DataSource relatedDS, DSRequest dsRequest) throws Exception {
        return this.getRelation(new DataSource[]{relatedDS}, true, dsRequest);
    }

    public Relation getRelation(DataSource relatedDS, boolean logProblems, DSRequest dsRequest) throws Exception {
        return this.getRelation(new DataSource[]{relatedDS}, logProblems, dsRequest);
    }

    public Relation getRelation(DataSource[] relatedDS, DSRequest dsRequest) throws Exception {
        return this.getRelation(relatedDS, true, dsRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Relation getRelation(DataSource[] relatedDSArray, boolean logProblems, DSRequest dsRequest) throws Exception {
        String includePath = "";
        for (DataSource ds : relatedDSArray) {
            if (!"".equals(includePath)) {
                includePath = includePath + ".";
            }
            includePath = includePath + ds.getName();
        }
        Map<String, DataSource> dsObjectsMap = dsRequest != null ? dsRequest.getCachedDataSourceInstances() : inInitState;
        Map<String, DataSource> len$ = inInitState;
        synchronized (len$) {
            dsObjectsMap.putAll(inInitState);
        }
        if (this.getCachedRelationInfo(includePath) != null && dsObjectsMap != null) {
            log.debug("Returning cached relation for " + this.getName() + " -> " + includePath + " (the relation is not necessarily direct)");
            return Relation.create(this.getCachedRelationInfo(includePath), dsObjectsMap, dsRequest);
        }
        Relation relation = null;
        if (relatedDSArray.length == 1) {
            relation = DataSource._getRelation(this, relatedDSArray[0], logProblems, dsObjectsMap, new HashMap(), false);
        } else {
            for (int i = relatedDSArray.length - 2; i >= -1; --i) {
                DataSource baseDS = null;
                DataSource relatedDS = null;
                if (i >= 0) {
                    baseDS = relatedDSArray[i];
                    relatedDS = relatedDSArray[i + 1];
                } else {
                    baseDS = this;
                    relatedDS = relatedDSArray[i + 1];
                }
                Relation r = DataSource._getRelation(baseDS, relatedDS, logProblems, dsObjectsMap, null, true);
                if (r == null) {
                    relation = null;
                    break;
                }
                if (relation != null) {
                    r.setNextRelation(relation);
                }
                relation = r;
            }
        }
        String nextDS = "";
        if (relation != null && relation.isValid()) {
            String msg = "Path selected from " + this.getName() + " to " + includePath + ": ";
            for (Relation r = relation; r != null; r = r.getNextRelation()) {
                msg = msg + " -> " + r.getFromDataSource().getName();
                nextDS = r.getToDataSource().getName();
            }
            msg = msg + " -> " + nextDS;
            log.debug(msg);
            this.addCachedRelationInfo(includePath, RelationInfo.create(relation));
            return relation;
        }
        String message = "DataSource " + this.getName() + " includes fields from DataSource " + includePath + " but we cannot establish a direct or indirect relation " + "between those DataSources.  You must specify foreignKey field(s) " + "on the including DataSource (" + this.getName() + ") that either express " + "a direct relationship to " + includePath + ", or express an indrect relationship " + "via one or more intervening tables";
        if (logProblems) {
            log.warn(message);
        }
        throw new ForeignKeyNotFoundException(message);
    }

    public static Relation _getRelation(DataSource baseDS, DataSource relatedDS, boolean logProblems, Map<String, DataSource> dsObjectsMap, Map seenBefore, boolean directOnly) throws Exception {
        List<DSField> fks;
        String[] parsed;
        Relation relation = new Relation();
        relation.setFromDataSource(baseDS);
        relation.setToDataSource(relatedDS);
        boolean foundLink = false;
        HashMap<String, List<DSField>> fkSets = new HashMap<String, List<DSField>>();
        for (DSField field : baseDS.getFields()) {
            if (field.getForeignKey() == null) continue;
            parsed = field.getForeignKey().split("\\.");
            String dsName = null;
            if (parsed.length == 1) {
                dsName = baseDS.getName();
                if (baseDS.getName().equals(relatedDS.getName())) {
                    relation.addFromField(field);
                    relation.addToField(field);
                    relation.setJoinType(field.getJoinType());
                    foundLink = true;
                }
            } else if (parsed.length == 2) {
                dsName = parsed[0];
                if (relatedDS.getName().equals(parsed[0])) {
                    relation.addFromField(field);
                    relation.addToField(relatedDS.getField(parsed[1]));
                    relation.setJoinType(field.getJoinType());
                    foundLink = true;
                }
            }
            if (fkSets.containsKey(dsName)) {
                fks = (List)fkSets.get(dsName);
            } else {
                fks = new ArrayList();
                fkSets.put(dsName, fks);
            }
            fks.add(field);
        }
        if (!foundLink) {
            for (DSField field : relatedDS.getFields()) {
                if (field.getForeignKey() == null) continue;
                parsed = field.getForeignKey().split("\\.");
                if (parsed.length == 1) {
                    if (!relatedDS.getName().equals(baseDS.getName())) continue;
                    relation.addFromField(field);
                    relation.addToField(field);
                    relation.setJoinType(field.getJoinType());
                    foundLink = true;
                    continue;
                }
                if (parsed.length != 2 || !baseDS.getName().equals(parsed[0])) continue;
                relation.addFromField(baseDS.getField(parsed[1]));
                relation.addToField(field);
                relation.setJoinType(field.getJoinType());
                foundLink = true;
            }
        }
        if (directOnly) {
            return relation;
        }
        if (!foundLink && dsObjectsMap != null) {
            ArrayList candidates = new ArrayList();
            for (String dsName : fkSets.keySet()) {
                if (seenBefore.containsKey(dsName)) continue;
                DataSource ds = dsObjectsMap.get(dsName);
                if (ds == null) {
                    ds = DataSourceManager.get(dsName, null);
                    if (ds == null) {
                        throw new Exception("DataSource '" + baseDS.getName() + "' declares a foreignKey " + "relation to DataSource '" + dsName + "', which does not exist.");
                    }
                    dsObjectsMap.put(dsName, ds);
                }
                fks = (List)fkSets.get(dsName);
                seenBefore.put(dsName, ds);
                Relation candidate = DataSource._getRelation(ds, relatedDS, logProblems, dsObjectsMap, seenBefore, directOnly);
                if (candidate == null || !candidate.isValid()) continue;
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("relation", candidate);
                map.put("ds", ds);
                map.put("fks", fks);
                candidates.add(map);
            }
            int shortest = Integer.MAX_VALUE;
            int index = -1;
            for (int i = 0; i < candidates.size(); ++i) {
                Relation r = (Relation)((Map)candidates.get(i)).get("relation");
                int length = 1;
                while (r.getNextRelation() != null) {
                    r = r.getNextRelation();
                    ++length;
                }
                if (length < shortest) {
                    shortest = length;
                    index = i;
                    String msg = "Found new shortest path from " + baseDS.getName() + " to " + relatedDS.getName() + ".  Path is: " + baseDS.getName();
                    String nextDS = "";
                    for (r = (Relation)((Map)candidates.get(i)).get("relation"); r != null; r = r.getNextRelation()) {
                        msg = msg + " -> " + r.getFromDataSource().getName();
                        nextDS = r.getToDataSource().getName();
                    }
                    msg = msg + " -> " + nextDS;
                    log.debug(msg);
                    continue;
                }
                String nextDS = "";
                String msg = "Ignoring a path from " + baseDS.getName() + " to " + relatedDS.getName() + " - we already know of one at least as " + "as short.  The ignored path is: " + baseDS.getName();
                for (r = (Relation)((Map)candidates.get(i)).get("relation"); r != null; r = r.getNextRelation()) {
                    msg = msg + " -> " + r.getFromDataSource().getName();
                    nextDS = r.getToDataSource().getName();
                }
                msg = msg + " -> " + nextDS;
                log.debug(msg);
            }
            if (index != -1) {
                DataSource ds = (DataSource)((Map)candidates.get(index)).get("ds");
                fks = (List)((Map)candidates.get(index)).get("fks");
                Relation selected = (Relation)((Map)candidates.get(index)).get("relation");
                relation.setToDataSource(ds);
                relation.setFromFields(fks);
                for (DSField field : fks) {
                    String[] parsed2 = field.getForeignKey().split("\\.");
                    if (parsed2.length == 1) {
                        if (!ds.getName().equals(ds.getName())) continue;
                        relation.addToField(field);
                        relation.setJoinType(field.getJoinType());
                        continue;
                    }
                    if (parsed2.length != 2 || !ds.getName().equals(parsed2[0])) continue;
                    relation.addToField(ds.getField(parsed2[1]));
                    relation.setJoinType(field.getJoinType());
                }
                relation.setNextRelation(selected);
            }
        }
        return relation;
    }

    public boolean canJoinIncludedFields() {
        return false;
    }

    public boolean inheritsParent() {
        return false;
    }

    public List getLocalFieldNames() {
        Map fields = this.getRawFields();
        if (fields == null) {
            return new ArrayList();
        }
        return new ArrayList(fields.keySet());
    }

    public List getLocalFields() {
        List fieldNames = this.getLocalFieldNames();
        ArrayList<DSField> fields = new ArrayList<DSField>();
        if (fieldNames != null) {
            Iterator i = fieldNames.iterator();
            while (i.hasNext()) {
                fields.add(this.getField((String)i.next()));
            }
        }
        return fields;
    }

    public boolean isInherited(DSField field) {
        String name = field.getName();
        for (DataSource ds = this.getSuper(); ds != null; ds = ds.getSuper()) {
            List locals = ds.getLocalFieldNames();
            if (locals.contains(name)) {
                return true;
            }
            if (ds == ds.getSuper()) break;
        }
        return false;
    }

    public boolean isPureInherited(DSField field) {
        String name;
        List locals = this.getLocalFieldNames();
        if (locals.contains(name = field.getName())) {
            return false;
        }
        return this.isInherited(field);
    }

    public boolean isAutoDerived(DSField field) {
        DataSource autoDerive = this.getAutoDeriveDS();
        if (autoDerive == null) {
            return false;
        }
        List fields = autoDerive.getLocalFieldNames();
        String name = field.getName();
        return fields.contains(name);
    }

    public boolean isPureAutoDerived(DSField field) {
        String name;
        List locals = this.getLocalFieldNames();
        if (locals.contains(name = field.getName())) {
            return false;
        }
        return this.isAutoDerived(field);
    }

    protected DataSource getSuper() {
        return null;
    }

    public DataSource getAutoDeriveDS() {
        return null;
    }

    public boolean isBinaryMetadata(DSField field) {
        if (field == null) {
            return false;
        }
        String name = field.getName();
        List fields = this.getFieldNames();
        String[] sfx = new String[]{"_filename", "_filesize", "_date_created"};
        for (int i = 0; i < sfx.length; ++i) {
            if (!name.endsWith(sfx[i]) || !fields.contains(name.substring(0, name.length() - sfx[i].length()))) continue;
            return true;
        }
        return false;
    }

    public String getFilenameField(DSField baseField) {
        if (baseField == null) {
            return null;
        }
        return this.getFilenameField(baseField.getName());
    }

    public String getFilenameField(String baseFieldName) {
        if (this.filenameField.containsKey(baseFieldName)) {
            return this.filenameField.get(baseFieldName);
        }
        this.filenameField.put(baseFieldName, this.getMetadataField(baseFieldName, "_filename"));
        return this.filenameField.get(baseFieldName);
    }

    public String getFilesizeField(DSField baseField) {
        if (baseField == null) {
            return null;
        }
        return this.getFilesizeField(baseField.getName());
    }

    public String getFilesizeField(String baseFieldName) {
        if (this.filesizeField.containsKey(baseFieldName)) {
            return this.filesizeField.get(baseFieldName);
        }
        this.filesizeField.put(baseFieldName, this.getMetadataField(baseFieldName, "_filesize"));
        return this.filesizeField.get(baseFieldName);
    }

    public String getDateCreatedField(DSField baseField) {
        if (baseField == null) {
            return null;
        }
        return this.getDateCreatedField(baseField.getName());
    }

    public String getDateCreatedField(String baseFieldName) {
        if (this.dateCreatedField.containsKey(baseFieldName)) {
            return this.dateCreatedField.get(baseFieldName);
        }
        this.dateCreatedField.put(baseFieldName, this.getMetadataField(baseFieldName, "_date_created"));
        return this.dateCreatedField.get(baseFieldName);
    }

    protected String getMetadataField(String baseFieldName, String suffix) {
        String fld = baseFieldName + suffix;
        List fields = this.getFieldNames();
        for (int i = 0; i < fields.size(); ++i) {
            if (!fld.equalsIgnoreCase((String)fields.get(i))) continue;
            return (String)fields.get(i);
        }
        return fld;
    }

    public static AdvancedCriteria parseAdvancedCriteria(Map rawCriteria) {
        return Evaluator.parseAdvancedCriteria(rawCriteria);
    }

    public boolean handlesRelations() {
        return false;
    }

    protected Object getRelationFieldValue(RelationFieldInfo relationFieldInfo, Object obj, List recursedList, ValidationContext vc) throws Exception {
        return DataTools.getProperties(obj, DataTools.buildList(relationFieldInfo.getFieldName())).get(relationFieldInfo.getFieldName());
    }

    protected void setRelationFieldValue(RelationFieldInfo relationFieldInfo, Object obj, Object value) throws Exception {
        DataTools.setProperties(DataTools.buildMap(relationFieldInfo.getFieldName(), value), obj, this);
    }

    protected IncludeFromInfo getIncludeFromInfo(DSField field, DSRequest dsRequest) throws Exception {
        if (dsRequest != null || log.isDebugEnabled()) {
            // empty if block
        }
        if (this.includeFromFields != null && this.includeFromFields.get(field.getName()) != null) {
            return this.includeFromFields.get(field.getName());
        }
        String text = (String)field.get("includeFrom");
        if (text != null) {
            IncludeFromInfo includeFromInfo = new IncludeFromInfo();
            String[] parsed = text.split("\\.");
            if (parsed.length < 2) {
                log.warn("Field " + field.getName() + " has invalid IncludeFromDefinition definition: '" + includeFromInfo + "'.  Should be of the form 'dataSourceName.fieldName'. " + "You can also define multiple data sources to request certain " + " path to connect indirectly related data sources: " + "'dataSourceName1.dataSourceName2.fieldName'.");
                return null;
            }
            String includePath = text.substring(0, text.lastIndexOf("."));
            String includedFieldName = text.substring(text.lastIndexOf(".") + 1);
            DataSource[] dataSources = new DataSource[parsed.length - 1];
            String[] dataSourceNames = new String[parsed.length - 1];
            for (int i = 0; i < parsed.length - 1; ++i) {
                String dsName = parsed[i];
                DataSource ds = inInitState.get(dsName);
                if (ds == null && dsRequest != null) {
                    ds = dsRequest.getCachedDataSourceInstance(dsName);
                }
                if (ds == null && (ds = DataSourceManager.get(dsName, dsRequest)) != null && dsRequest != null) {
                    log.debug("Caching instance of DS '" + dsName + "' in the DSRequest/RPCManager map");
                    dsRequest.cacheDataSourceInstance(dsName, ds);
                }
                if (ds == null) {
                    log.warn("includeFrom field named '" + field.getName() + "' refers to a " + "related DataSource ('" + dsName + "') that does not exist. Ignoring this field.");
                    return null;
                }
                dataSources[i] = ds;
                dataSourceNames[i] = dsName;
            }
            includeFromInfo.setThisFieldName(field.getName());
            includeFromInfo.setIncludedFieldName(includedFieldName);
            includeFromInfo.setIncludePath(includePath);
            includeFromInfo.setDataSourceNames(dataSourceNames);
            Relation relationObject = this.getRelation(dataSources, dsRequest);
            if (relationObject == null || !relationObject.isValid()) {
                log.warn("includeFrom field named '" + field.getName() + "' refers to a " + "related DataSource ('" + dataSourceNames[dataSourceNames.length - 1] + "'). Failed to discover relation between data sources. Ignoring this field.");
                return null;
            }
            includeFromInfo.setRelation(RelationInfo.create(relationObject));
            DataSource includeFromDS = dataSources[dataSources.length - 1];
            DSField includedField = includeFromDS.getField(includedFieldName);
            if (includedField == null) {
                log.warn("includeFrom field named '" + field.getName() + "' refers to a '" + includedFieldName + "' " + "field that does not exist in '" + includeFromDS.getName() + "' data source. " + "Ignoring this field.");
                return null;
            }
            includeFromInfo.setTargetIncludeFrom(includeFromDS.getIncludeFromInfo(includedField, dsRequest));
            includeFromInfo.setTargetInspected(true);
            Map configField = null;
            Map configFieldsList = (Map)this.getConfig().get("fields");
            if (configFieldsList != null) {
                configField = (Map)configFieldsList.get(field.getName());
            }
            if (!field.getBoolean("canEdit")) {
                field.put("canEdit", Boolean.FALSE);
                if (configField != null) {
                    configField.put("canEdit", Boolean.FALSE);
                }
            }
            for (Object propertyName : includedField.keySet()) {
                if (propertyName == null || "primaryKey".equals(propertyName) || "foreignKey".equals(propertyName) || "required".equals(propertyName) || "validators".equals(propertyName) || propertyName.toString().startsWith("editRequires") || propertyName.toString().startsWith("updateRequires") || propertyName.toString().startsWith("initRequires")) continue;
                if ("type".equals(propertyName)) {
                    field.put(propertyName, includedField.get(propertyName));
                    if (configField == null) continue;
                    configField.put(propertyName, includedField.get(propertyName));
                    continue;
                }
                if (field.containsKey(propertyName)) continue;
                field.put(propertyName, includedField.get(propertyName));
                if (configField == null) continue;
                configField.put(propertyName, includedField.get(propertyName));
            }
            if (this.handlesRelations()) {
                Object propertyName;
                propertyName = null;
                for (RelationInfo r = includeFromInfo.getRelation(); r != null; r = r.getNextRelation()) {
                    propertyName = propertyName == null ? r.getFromFields().get(0) : propertyName + "/" + r.getFromFields().get(0);
                }
                propertyName = includeFromInfo.getTargetIncludeFrom() != null ? propertyName + "/" + includedField.getValueXPath() : propertyName + "/" + includedFieldName;
                field.put("valueXPath", propertyName);
                if (configField != null) {
                    configField.put("valueXPath", propertyName);
                }
            }
            includeFromInfo.setPrepared(true);
            return includeFromInfo;
        }
        return null;
    }

    public boolean supportsGroupFunction(String functionName) {
        return false;
    }

    public Class getPropertyJavaClass(String propertyName, DSField field, Object value) throws Exception {
        if (field == null) {
            return null;
        }
        String typeName = field.getProperty("javaClass");
        if (typeName != null) {
            return Reflection.classForName(typeName);
        }
        return null;
    }

    public void _clearConvertedProperties() {
        this.convertedProps.clear();
    }

    public Class _getPropertyJavaClass(String propertyName, DSField field, Object value) throws Exception {
        if (this.convertedProps.containsKey(field)) {
            return this.convertedProps.get(field);
        }
        Class c = this.getPropertyJavaClass(propertyName, field, value);
        this.convertedProps.put(field, c);
        return c;
    }

    public boolean hasNextRecord(DSResponse response) throws StreamingResponseException {
        throw new StreamingResponseException("Streaming is not supported by this DataSource type");
    }

    public Map streamNextRecord(DSResponse response) throws StreamingResponseException {
        throw new StreamingResponseException("Streaming is not supported by this DataSource type");
    }

    public Object streamNextRecordAsObject(DSResponse response) throws StreamingResponseException {
        throw new StreamingResponseException("Streaming is not supported by this DataSource type");
    }

    public int getProgressiveLoadingThreshold() {
        Object fromConfig = this.dsConfig.get("progressiveLoadingThreshold");
        if (fromConfig == null) {
            return 200000;
        }
        if (fromConfig instanceof Integer) {
            return (Integer)fromConfig;
        }
        return Integer.parseInt(fromConfig.toString());
    }

    public int getLookAhead() {
        Object fromConfig = this.dsConfig.get("lookAhead");
        if (fromConfig == null) {
            return 1;
        }
        if (fromConfig instanceof Integer) {
            return (Integer)fromConfig;
        }
        return Integer.parseInt(fromConfig.toString());
    }

    public int getEndGap() {
        Object fromConfig = this.dsConfig.get("endGap");
        if (fromConfig == null) {
            return 20;
        }
        if (fromConfig instanceof Integer) {
            return (Integer)fromConfig;
        }
        return Integer.parseInt(fromConfig.toString());
    }

    public DSInheritanceMode getInheritanceMode() {
        return DSInheritanceMode.FULL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpCreateTrace(List<Map> createTrace, String dsName, String filename, boolean dumpStack, boolean dumpConfig) throws Exception {
        List<Map> list = createTrace;
        synchronized (list) {
            PrintStream out;
            if (filename == null) {
                out = System.out;
            } else {
                File file = new File(filename);
                file.createNewFile();
                out = new PrintStream(file);
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            out.println("\nDumping Create Trace data for DataSource " + (dsName == null ? "(all)" : dsName + "*"));
            for (Map map : createTrace) {
                String id = (String)map.get("ID");
                if (dsName != null && !id.startsWith(dsName)) continue;
                out.println(sdf.format(new Date((Long)map.get("time"))) + " ID: " + map.get("ID") + ", instanceId: " + map.get("instanceId"));
                if (dumpConfig) {
                    out.println("Config: " + map.get("config"));
                }
                if (!dumpStack) continue;
                out.println("Stacktrace: ");
                StackTraceElement[] ste = (StackTraceElement[])map.get("stack");
                for (int j = 0; j < ste.length; ++j) {
                    out.println(ste[j]);
                }
            }
            out.println("\nEnd of Create Trace data for DataSource " + (dsName == null ? "(all)" : dsName) + "\n");
        }
    }

    public String toString() {
        return this.getID() + " DataSource with instanceId " + this.getInstanceId();
    }

    public void createStorage(boolean dropFirst) throws Exception {
    }

    public boolean isCacheable() {
        return true;
    }

    static {
        List paths = config.getCommaSeparatedList("framework.datasources");
        LinkedMap triedPaths = new LinkedMap();
        Iterator j = paths.iterator();
        while (j.hasNext()) {
            String dsDirPath = ISCFile.canonicalizePath((String)j.next());
            String fileName = null;
            try {
                fileName = dsDirPath + "/" + builtinTypesFile;
                builtinTypes = (Map)XML.toDSRecords(fileName);
                if (builtinTypes == null) continue;
                break;
            }
            catch (Exception e) {
                triedPaths.put(fileName, e);
            }
        }
        if (builtinTypes.size() == 0) {
            System.out.println("Problem loading builtinTypes.xml");
            for (String path : triedPaths.keySet()) {
                Exception e = (Exception)triedPaths.get(path);
                System.out.println("Exception when loading from " + path + ":\n" + DataTools.getStackTrace(e));
            }
        }
        for (String key : builtinTypes.keySet()) {
            Map map = (Map)builtinTypes.get(key);
            Object valObj = map.get("validators");
            if (valObj instanceof List) {
                List valList = (List)valObj;
                for (int j2 = 0; j2 < valList.size(); ++j2) {
                    valObj = valList.get(j2);
                    if (!(valObj instanceof Map)) continue;
                    valList.set(j2, new Validator((Map)valObj));
                }
                continue;
            }
            if (!(valObj instanceof Map)) continue;
            map.put("validators", new Validator((Map)valObj));
        }
        useAxisForSQLDS = config.getBoolean((Object)"useAxisForSQLDS", false);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DSInheritanceMode {
        FULL,
        NONE;


        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

