/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.velocity;

import com.isomorphic.base.Base;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.io.ISCFile;
import com.isomorphic.log.Logger;
import com.isomorphic.rpc.RPCManager;
import com.isomorphic.servlet.RequestContext;
import com.isomorphic.util.DataTools;
import com.isomorphic.velocity.AdvancedCriteriaHandler;
import com.isomorphic.velocity.DataSourcesHandler;
import com.isomorphic.velocity.HttpAttributeHandler;
import com.isomorphic.velocity.HttpParameterHandler;
import com.isomorphic.velocity.ISCReferenceInsertionEventHandler;
import com.isomorphic.velocity.ResponseDataHandler;
import com.isomorphic.velocity.ServletRequestAttributeMapFacade;
import com.isomorphic.velocity.SessionAttributeMapFacade;
import com.isomorphic.velocity.UserIdHandler;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

public class Velocity
extends Base {
    private static Logger log = new Logger(Velocity.class.getName());
    private static VelocityEngine vEngine;

    public static VelocityEngine getEngine() throws Exception {
        if (vEngine != null) {
            return vEngine;
        }
        vEngine = new VelocityEngine();
        Properties properties = new Properties();
        properties.put("file.resource.loader.path", "");
        properties.put("runtime.log.logsystem.class", "org.apache.velocity.runtime.log.SimpleLog4JLogSystem");
        properties.put("runtime.log.logsystem.log4j.category", "org.apache.Velocity");
        vEngine.init(properties);
        return vEngine;
    }

    public static synchronized Object evaluateTemplateFile(String fileName, Map parameters) throws Exception {
        ISCFile file = new ISCFile(DataTools.makePathAbsolute(fileName));
        return Velocity.evaluate(file.getAsString(), parameters);
    }

    public static synchronized String evaluateTemplateFileAsString(String fileName, Map parameters) throws Exception {
        Object obj = Velocity.evaluateTemplateFile(fileName, parameters);
        return obj == null ? null : obj.toString();
    }

    public static synchronized String evaluateAsString(String template, Map parameters) throws Exception {
        Object obj = Velocity.evaluate(template, parameters);
        return obj == null ? null : obj.toString();
    }

    public static synchronized Object evaluate(String template, Map parameters) throws Exception {
        return Velocity.evaluate(template, parameters, "notProvided", null, false);
    }

    public static synchronized String evaluateAsString(String template, Map parameters, String operationName, DataSource ds, boolean quoteValues) throws Exception {
        Object obj = Velocity.evaluate(template, parameters, operationName, ds, quoteValues);
        return obj == null ? null : obj.toString();
    }

    public static synchronized Object evaluate(String template, Map parameters, String operationName, DataSource ds, boolean quoteValues) throws Exception {
        if (template == null) {
            throw new NullPointerException("The template String provided for Velocity evaluation is null. Operation name is '" + operationName + "'");
        }
        StringWriter out = new StringWriter();
        VelocityContext context = new VelocityContext(parameters);
        ISCReferenceInsertionEventHandler handler = new ISCReferenceInsertionEventHandler((Context)context, ds, quoteValues);
        if (!Velocity.getEngine().evaluate((Context)context, (Writer)out, operationName, template)) {
            return null;
        }
        if (handler.foundObject != null && handler.foundObject.toString().equals(out.toString())) {
            return handler.foundObject;
        }
        return out.toString();
    }

    public static synchronized Boolean evaluateBooleanExpression(String template, Map parameters) throws Exception {
        return Velocity.evaluateBooleanExpression(template, parameters, "notProvided", null);
    }

    public static synchronized Boolean evaluateBooleanExpression(String template, Map parameters, String operationName, DataSource ds) throws Exception {
        Object obj2 = null;
        Object obj = Velocity.evaluate(template, parameters, operationName, ds, true);
        if (!(obj != null && (obj instanceof Boolean || obj.toString().trim().toLowerCase().equals("true") || obj.toString().trim().toLowerCase().equals("false") || obj.toString().trim().toLowerCase().equals("'true'") || obj.toString().trim().toLowerCase().equals("'false'")))) {
            String postEval = obj.toString();
            if (template.indexOf("'true'") == -1) {
                postEval = postEval.replaceAll("'true'", "true");
            }
            if (template.indexOf("'false'") == -1) {
                postEval = postEval.replaceAll("'false'", "false");
            }
            String wrappedTemplate = "#if(" + postEval + ") true #else false #end";
            try {
                obj = Velocity.evaluate(wrappedTemplate, parameters, operationName, ds, true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (obj != null) {
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            if (obj.toString().trim().toLowerCase().equals("true")) {
                return Boolean.TRUE;
            }
            if (obj.toString().trim().toLowerCase().equals("'true'")) {
                return Boolean.TRUE;
            }
            if (obj.toString().trim().toLowerCase().equals("false")) {
                return Boolean.FALSE;
            }
            if (obj.toString().trim().toLowerCase().equals("'false'")) {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    public static Map getStandardContextMap(DSRequest dsReq) {
        HashMap<String, Object> context;
        if (dsReq == null) {
            return new HashMap();
        }
        if (dsReq.getRPCManager() != null) {
            context = new HashMap(dsReq.getRPCManager().getTemplateContext());
            context.put("responseData", new ResponseDataHandler(dsReq.getRPCManager(), dsReq));
        } else {
            context = new HashMap<String, Object>();
            Date currentDate = new Date();
            context.put("currentDate", currentDate);
            context.put("transactionDate", currentDate);
        }
        HashMap criteria = dsReq.getCriteria() != null ? new HashMap(dsReq.getCriteria()) : new HashMap();
        HashMap values = dsReq.getValues() != null ? new HashMap(dsReq.getValues()) : new HashMap();
        context.put("criteria", criteria);
        context.put("values", values);
        context.put("dsRequest", dsReq);
        if (dsReq != null) {
            context.put("primaryDSRequest", dsReq.getPrimaryDSRequest());
        }
        context.put("dataSources", new DataSourcesHandler(dsReq));
        context.put("advancedCriteria", new AdvancedCriteriaHandler(dsReq));
        context.putAll(Velocity.getServletContextMap(dsReq.context));
        context.put("util", new DataTools());
        context.put("userId", new UserIdHandler(dsReq));
        if (dsReq.getTemplateContext() != null) {
            for (String key : dsReq.getTemplateContext().keySet()) {
                if (context.get(key) != null) {
                    log.warning("DSRequest-specified a template context variable: " + key + " collides with derived key of the same name" + " - using the DSRequest-specified value.");
                }
                context.put(key, dsReq.getTemplateContext().get(key));
            }
        }
        return context;
    }

    public static Map getServletContextMap(RPCManager rpc) {
        if (rpc == null) {
            return new HashMap();
        }
        return Velocity.getServletContextMap(rpc.getContext());
    }

    public static Map getServletContextMap(RequestContext reqContext) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        ServletRequestAttributeMapFacade escRequest = null;
        SessionAttributeMapFacade escSession = null;
        if (reqContext != null) {
            escRequest = new ServletRequestAttributeMapFacade((HttpServletRequest)reqContext.request);
            if (reqContext.request != null) {
                escSession = new SessionAttributeMapFacade(reqContext.request.getSession());
            }
        }
        context.put("httpParameters", new HttpParameterHandler((HttpServletRequest)escRequest));
        context.put("requestAttributes", new HttpAttributeHandler((HttpServletRequest)escRequest));
        context.put("sessionAttributes", new HttpAttributeHandler(escSession));
        if (escRequest != null) {
            context.put("servletRequest", escRequest);
        }
        if (escSession != null) {
            context.put("session", escSession);
        }
        return context;
    }

    public static Map getServletContextMap(HttpServletRequest req) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        ServletRequestAttributeMapFacade escRequest = null;
        SessionAttributeMapFacade escSession = null;
        escRequest = new ServletRequestAttributeMapFacade(req);
        if (req != null) {
            escSession = new SessionAttributeMapFacade(req.getSession());
        }
        context.put("httpParameters", new HttpParameterHandler((HttpServletRequest)escRequest));
        context.put("requestAttributes", new HttpAttributeHandler((HttpServletRequest)escRequest));
        context.put("sessionAttributes", new HttpAttributeHandler(escSession));
        if (escRequest != null) {
            context.put("servletRequest", escRequest);
        }
        if (escSession != null) {
            context.put("session", escSession);
        }
        return context;
    }
}

