/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server.handler;

import com.google.common.collect.Maps;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.remote.server.JsonParametersAware;
import org.openqa.selenium.remote.server.Session;
import org.openqa.selenium.remote.server.handler.WebDriverHandler;
import org.openqa.selenium.remote.server.rest.ResultType;

public class AddCookie
extends WebDriverHandler
implements JsonParametersAware {
    private volatile Map<String, Object> rawCookie;

    public AddCookie(Session session) {
        super(session);
    }

    @Override
    public ResultType call() throws Exception {
        Cookie cookie = this.createCookie();
        this.getDriver().manage().addCookie(cookie);
        return ResultType.SUCCESS;
    }

    @Override
    public void setJsonParameters(Map<String, Object> allParameters) throws Exception {
        if (allParameters == null) {
            return;
        }
        this.rawCookie = Maps.newHashMap((Map)((Map)allParameters.get("cookie")));
    }

    protected Cookie createCookie() {
        Number expiryNum;
        if (this.rawCookie == null) {
            return null;
        }
        String name = (String)this.rawCookie.get("name");
        String value = (String)this.rawCookie.get("value");
        String path = (String)this.rawCookie.get("path");
        String domain = (String)this.rawCookie.get("domain");
        Boolean secure = (Boolean)this.rawCookie.get("secure");
        if (secure == null) {
            secure = false;
        }
        Date expiry = (expiryNum = (Number)this.rawCookie.get("expiry")) == null ? null : new Date(TimeUnit.SECONDS.toMillis(expiryNum.longValue()));
        return new Cookie.Builder(name, value).path(path).domain(domain).isSecure(secure).expiresOn(expiry).build();
    }

    public String toString() {
        return "[add cookie: " + this.createCookie() + "]";
    }
}

