/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.safari;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.internal.Base64Encoder;
import org.openqa.selenium.io.TemporaryFilesystem;
import org.openqa.selenium.remote.DesiredCapabilities;

public class SafariOptions {
    public static final String CAPABILITY = "safari.options";
    private static final String JSON_KEY_DATADIR = "dataDir";
    private static final String JSON_KEY_EXTENSIONS = "extensions";
    private static final String JSON_KEY_SKIPEXTENSIONINSTALL = "skipExtensionInstallation";
    private static final String JSON_KEY_USECLEANSESSION = "cleanSession";
    private static final String JSON_KEY_USECUSTOMDRIVEREXTENSION = "customDriverExtension";
    private static final String JSON_KEY_PORT = "port";
    private File dataDir;
    private List<File> extensionFiles = Lists.newArrayList();
    private int port = 0;
    private boolean skipExtensionInstallation = false;
    private boolean useCleanSession = false;
    private boolean useCustomDriverExtension = false;

    public static SafariOptions fromCapabilities(Capabilities capabilities) throws WebDriverException {
        Object cap = capabilities.getCapability(CAPABILITY);
        if (cap instanceof SafariOptions) {
            return (SafariOptions)cap;
        }
        if (cap instanceof Map) {
            try {
                return SafariOptions.fromJsonMap((Map)cap);
            }
            catch (IOException e) {
                throw new WebDriverException(e);
            }
        }
        SafariOptions options = new SafariOptions();
        options.setUseCleanSession(capabilities.is("safari.cleanSession"));
        cap = capabilities.getCapability("safari.dataDir");
        if (cap instanceof String) {
            options.setDataDir(new File((String)cap));
        } else if (cap instanceof File) {
            options.setDataDir((File)cap);
        }
        if (capabilities.is("safari.extension.noInstall")) {
            options.setSkipExtensionInstallation(true);
        }
        return options;
    }

    public void addExtensions(File ... paths) {
        this.addExtensions((List<File>)ImmutableList.copyOf((Object[])paths));
    }

    public void addExtensions(List<File> paths) {
        for (File path : paths) {
            this.verifyPathIsSafariextz(path);
        }
        this.extensionFiles.addAll(paths);
    }

    public void setDataDir(File dataDir) {
        this.dataDir = dataDir;
    }

    public void setDriverExtension(File driverExtension) {
        if (this.useCustomDriverExtension) {
            this.extensionFiles.remove(0);
            this.useCustomDriverExtension = false;
        }
        if (driverExtension != null) {
            this.verifyPathIsSafariextz(driverExtension);
            this.extensionFiles.add(0, driverExtension);
            this.useCustomDriverExtension = true;
        }
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setSkipExtensionInstallation(boolean skipExtensionInstallation) {
        this.skipExtensionInstallation = skipExtensionInstallation;
    }

    public void setUseCleanSession(boolean useCleanSession) {
        this.useCleanSession = useCleanSession;
    }

    public File getDataDir() {
        return this.dataDir;
    }

    public List<File> getExtensions() {
        if (this.skipExtensionInstallation) {
            return ImmutableList.of();
        }
        return ImmutableList.copyOf(this.extensionFiles);
    }

    public int getPort() {
        return this.port;
    }

    public boolean getSkipExtensionInstallation() {
        return this.skipExtensionInstallation;
    }

    public boolean getUseCustomDriverExtension() {
        return this.useCustomDriverExtension || this.skipExtensionInstallation;
    }

    public boolean getUseCleanSession() {
        return this.useCleanSession;
    }

    public JSONObject toJson() throws IOException, JSONException {
        JSONObject options = new JSONObject();
        if (this.dataDir != null) {
            options.put(JSON_KEY_DATADIR, (Object)this.dataDir.getPath());
        }
        options.put(JSON_KEY_EXTENSIONS, (Object)this.extensionsToJson());
        options.put(JSON_KEY_PORT, this.port);
        options.put(JSON_KEY_SKIPEXTENSIONINSTALL, this.skipExtensionInstallation);
        options.put(JSON_KEY_USECLEANSESSION, this.useCleanSession);
        options.put(JSON_KEY_USECUSTOMDRIVEREXTENSION, this.useCustomDriverExtension);
        return options;
    }

    private static SafariOptions fromJsonMap(Map options) throws IOException {
        Object useCustomDriverExtension;
        Object useCleanSession;
        Object skipExtensionInstallation;
        Object port;
        Object extensions;
        SafariOptions safariOptions = new SafariOptions();
        Object path = options.get(JSON_KEY_DATADIR);
        if (path != null) {
            safariOptions.setDataDir(new File((String)path));
        }
        if ((extensions = options.get(JSON_KEY_EXTENSIONS)) != null) {
            safariOptions.addExtensionsFromJsonList((List)extensions);
        }
        if ((port = options.get(JSON_KEY_PORT)) != null) {
            safariOptions.setPort(((Long)port).intValue());
        }
        if ((skipExtensionInstallation = options.get(JSON_KEY_SKIPEXTENSIONINSTALL)) != null) {
            safariOptions.setSkipExtensionInstallation((Boolean)skipExtensionInstallation);
        }
        if ((useCleanSession = options.get(JSON_KEY_USECLEANSESSION)) != null) {
            safariOptions.setUseCleanSession((Boolean)useCleanSession);
        }
        if ((useCustomDriverExtension = options.get(JSON_KEY_USECUSTOMDRIVEREXTENSION)) != null) {
            safariOptions.useCustomDriverExtension = (Boolean)useCustomDriverExtension;
        }
        return safariOptions;
    }

    private void verifyPathIsSafariextz(File path) {
        Preconditions.checkNotNull((Object)path);
        Preconditions.checkArgument((boolean)path.exists(), (String)"%s does not exist", (Object[])new Object[]{path.getAbsolutePath()});
        Preconditions.checkArgument((!path.isDirectory() ? 1 : 0) != 0, (String)"%s is a directory", (Object[])new Object[]{path.getAbsolutePath()});
        Preconditions.checkArgument((boolean)path.getName().endsWith(".safariextz"), (String)"%s does not end with .safariextz", (Object[])new Object[]{path.getName()});
    }

    private JSONArray extensionsToJson() throws IOException, JSONException {
        JSONArray extensionsList = new JSONArray();
        for (File path : this.extensionFiles) {
            JSONObject extensionInfo = new JSONObject();
            extensionInfo.put("filename", (Object)path.getName());
            String encoded = new Base64Encoder().encode(Files.toByteArray((File)path));
            extensionInfo.put("contents", (Object)encoded);
            extensionsList.put((Object)extensionInfo);
        }
        return extensionsList;
    }

    private void addExtensionsFromJsonList(List<Map<String, String>> extensions) throws IOException {
        File dir = TemporaryFilesystem.getDefaultTmpFS().createTempDir("SafariOptions", "safaridriver");
        for (Map<String, String> extensionInfo : extensions) {
            String path = extensionInfo.get("filename");
            String encoded = extensionInfo.get("contents");
            byte[] decoded = new Base64Encoder().decode(encoded);
            File file = new File(dir, path);
            Files.write((byte[])decoded, (File)file);
            this.addExtensions(file);
        }
    }

    DesiredCapabilities toCapabilities() {
        DesiredCapabilities capabilities = DesiredCapabilities.safari();
        capabilities.setCapability(CAPABILITY, this);
        capabilities.setCapability("safari.cleanSession", this.getUseCleanSession());
        capabilities.setCapability("safari.dataDir", this.getDataDir());
        capabilities.setCapability("safari.extension.noInstall", this.getSkipExtensionInstallation());
        return capabilities;
    }

    public boolean equals(Object other) {
        if (!(other instanceof SafariOptions)) {
            return false;
        }
        SafariOptions that = (SafariOptions)other;
        return Objects.equal((Object)this.dataDir, (Object)that.dataDir) && Objects.equal(this.extensionFiles, that.extensionFiles) && this.port == that.port && this.skipExtensionInstallation == that.skipExtensionInstallation && this.useCleanSession == that.useCleanSession && this.useCustomDriverExtension == that.useCustomDriverExtension;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.dataDir, this.extensionFiles, this.port, this.skipExtensionInstallation, this.useCleanSession, this.useCustomDriverExtension});
    }
}

