/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.jpa;

import com.isomorphic.base.Config;
import com.isomorphic.base.Reflection;
import com.isomorphic.jpa.EMFProviderInterface;
import com.isomorphic.log.Logger;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Properties;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceException;

public class EMF {
    private static final String CLASS_NAME = EMF.class.getName();
    private static final Logger log = new Logger(CLASS_NAME);
    public static final String JPA_PREFIX = "jpa";
    public static final String EMF_PROVIDER = "emfProvider";
    public static final String JPA_EMF_PROVIDER = "jpa.emfProvider";
    public static final String TRANSACTION_ATTR = "_isc_jpa_transaction_";
    private static HashMap<String, EMFProviderInterface> providers = new HashMap();

    public static EntityManagerFactory get() {
        return EMF.get("");
    }

    public static EntityManagerFactory get(String configName) {
        return EMF.getProvider(configName).get();
    }

    public static EntityManager getEntityManager() throws PersistenceException {
        return EMF.getEntityManager("");
    }

    public static EntityManager getEntityManager(String configName) throws PersistenceException {
        return EMF.getProvider(configName).getEntityManager();
    }

    public static void returnEntityManager(EntityManager em) {
        EMF.returnEntityManager("", em);
    }

    public static void returnEntityManager(String configName, EntityManager em) {
        EMF.getProvider(configName).returnEntityManager(em);
    }

    public static Object getTransaction(EntityManager em) throws Exception {
        return EMF.getTransaction("", em);
    }

    public static Object getTransaction(String configName, EntityManager em) throws Exception {
        return EMF.getProvider(configName).getTransaction(em);
    }

    public static void commitTransaction(Object tx) throws Exception {
        EMF.commitTransaction("", tx);
    }

    public static void commitTransaction(String configName, Object tx) throws Exception {
        EMF.getProvider(configName).commitTransaction(tx);
    }

    public static void rollbackTransaction(Object tx) {
        EMF.rollbackTransaction("", tx);
    }

    public static void rollbackTransaction(String configName, Object tx) {
        EMF.getProvider(configName).rollbackTransaction(tx);
    }

    private static EMFProviderInterface getProvider(String configName) {
        EMFProviderInterface emfProvider;
        if (configName == null) {
            configName = "";
        }
        if ((emfProvider = providers.get(configName)) == null) {
            emfProvider = EMF.initializeProvider(configName);
        }
        return emfProvider;
    }

    private static synchronized EMFProviderInterface initializeProvider(String configName) {
        EMFProviderInterface emfProvider = null;
        if ("".equals(configName)) {
            String emfProviderClassName = Config.getGlobal().getString((Object)JPA_EMF_PROVIDER, null);
            log.debug((Object)("Initializing default EMF provider: " + emfProviderClassName));
            try {
                Class<EMFProviderInterface> emfProviderClass = Reflection.classForName((String)emfProviderClassName).asSubclass(EMFProviderInterface.class);
                emfProvider = emfProviderClass.newInstance();
            }
            catch (Exception ex) {
                throw new PersistenceException("Unable to initialize default EMF provider: " + emfProviderClassName, (Throwable)ex);
            }
        }
        Properties providerProperties = Config.getGlobal().getSubtree("jpa." + configName).asProperties();
        String emfProviderClassName = providerProperties.getProperty(EMF_PROVIDER);
        log.debug((Object)("Initializing EMF provider: " + emfProviderClassName + " for configuration '" + configName + "'"));
        try {
            Class<EMFProviderInterface> emfProviderClass = Reflection.classForName((String)emfProviderClassName).asSubclass(EMFProviderInterface.class);
            Constructor<EMFProviderInterface> emfProviderConstructor = emfProviderClass.getConstructor(Properties.class);
            emfProvider = emfProviderConstructor.newInstance(providerProperties);
        }
        catch (Exception ex) {
            throw new PersistenceException("Unable to initialize EMF provider: " + emfProviderClassName + " for configuration '" + configName + "'", (Throwable)ex);
        }
        providers.put(configName, emfProvider);
        return emfProvider;
    }
}

