/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.rpc;

import com.isomorphic.base.Config;
import com.isomorphic.base.ISCInit;
import com.isomorphic.base.Reflection;
import com.isomorphic.datasource.BasicDataSource;
import com.isomorphic.datasource.DSField;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.DataSourceBeanFilter;
import com.isomorphic.datasource.DataSourceManager;
import com.isomorphic.datasource.ISCBinaryValue;
import com.isomorphic.datasource.PartialCommitException;
import com.isomorphic.datasource.ValidationContext;
import com.isomorphic.interfaces.ISQLDataSource;
import com.isomorphic.io.ISCFile;
import com.isomorphic.js.CurrentMillisMarker;
import com.isomorphic.js.IBeanFilter;
import com.isomorphic.js.JSONFilter;
import com.isomorphic.js.JSTranslater;
import com.isomorphic.js.KeepPropertiesBeanFilter;
import com.isomorphic.js.UnconvertableException;
import com.isomorphic.log.Logger;
import com.isomorphic.rpc.ClientMustResubmitException;
import com.isomorphic.rpc.DataExport;
import com.isomorphic.rpc.HttpServletRequestParser;
import com.isomorphic.rpc.QueueAlreadyStartedException;
import com.isomorphic.rpc.RPCManagerCompletionCallback;
import com.isomorphic.rpc.RPCRequest;
import com.isomorphic.rpc.RPCResponse;
import com.isomorphic.servlet.RequestContext;
import com.isomorphic.servlet.RequestTimer;
import com.isomorphic.servlet.ServletTools;
import com.isomorphic.util.DataTools;
import com.isomorphic.velocity.ServletRequestAttributeMapFacade;
import com.isomorphic.velocity.SessionAttributeMapFacade;
import com.isomorphic.velocity.Velocity;
import com.isomorphic.xml.XML;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.map.LinkedMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RPCManager {
    private static Config config = Config.getGlobal();
    private static int maxRequestDebugLength = config.getInt("RPCManager.maxRequestDebugLength", 1024);
    private static boolean globalOmitNullMapValuesInResponse = config.getBoolean((Object)"RPCManager.omitNullMapValuesInResponse", false);
    private static boolean globalPrettyPrintResponse = config.getBoolean((Object)"RPCManager.prettyPrintResponse", false);
    public static final String structuredRPCStart = "//isc_RPCResponseStart-->";
    public static final String structuredRPCEnd = "//isc_RPCResponseEnd";
    private static final String IFRAME_RECURSE_UP = "iframe";
    private static final String IFRAME_NEW_WINDOW = "iframeNewWindow";
    private static final String IFRAME_TARGET = "__iframeTarget__";
    private static final String IFRAME_CALLBACK_METHOD = "isc.Comm.hiddenFrameReply";
    private RequestContext context;
    private Map responseMap = new HashMap();
    private Long transactionNum;
    private String jsCallback;
    private Map transaction;
    private List requests;
    private boolean responseIsCustom = false;
    private static boolean initNotRunMessageShown = false;
    private boolean isDownload = false;
    private String charset = config.getString("RPCManager.defaultCharset", "UTF-8");
    public boolean closeConnection = false;
    public boolean omitNullMapValuesInResponse = globalOmitNullMapValuesInResponse;
    public boolean prettyPrintResponse = globalPrettyPrintResponse;
    private Map templateContext = new HashMap();
    public static Logger log = new Logger(RPCManager.class.getName());
    private boolean isExport = false;
    public boolean enableAllDS = false;
    private long constructed;
    private long started;
    String customHTML = config.getString("RPCManager.customHTML", null);
    String serverVersion = config.getString("iscVersionNumber");
    boolean devenv = config.getBoolean((Object)"devenv", false);
    private List dataSourcesToFree = new ArrayList();
    private Boolean authenticated;
    private List userRoles;
    private String userId;
    private Map attributes = new HashMap();
    protected Set callbacks = new LinkedHashSet();
    protected int transactionPolicy = Config.getGlobal().getInt("RPCManager.transactionPolicy", 0);
    protected boolean requestProcessingStarted = false;
    private List associatedRequests = new ArrayList();
    private Map<String, DataSource> cachedDataSources = new HashMap<String, DataSource>();

    public RequestContext getContext() {
        return this.context;
    }

    public RPCManager omitNullMapValuesInResponse(boolean value) {
        this.omitNullMapValuesInResponse = value;
        return this;
    }

    public RPCManager prettyPrintResponse(boolean value) {
        this.prettyPrintResponse = value;
        return this;
    }

    public Map getTemplateContext() {
        return this.templateContext;
    }

    public Object getFromTemplateContext(Object key) {
        return this.templateContext.get(key);
    }

    public void addToTemplateContext(Object key, Object value) {
        this.templateContext.put(key, value);
    }

    public void enableAllDataSources() {
        this.enableAllDS = true;
    }

    public long getConstructedTimestamp() {
        return this.constructed;
    }

    public long getStartedTimestamp() {
        return this.started;
    }

    public void setJsCallback(String jsCallback) {
        this.jsCallback = jsCallback;
    }

    public boolean isREST() {
        DSRequest dsReq = this.getDSRequest(true);
        if (dsReq != null) {
            return Boolean.TRUE.equals(dsReq.getREST());
        }
        return false;
    }

    public boolean isREST(Object req) {
        if (req instanceof DSRequest) {
            DSRequest dsReq = (DSRequest)req;
            return Boolean.TRUE.equals(dsReq.getREST());
        }
        return false;
    }

    public static boolean isRPC(HttpServletRequest request) {
        String queryString = request.getQueryString();
        if (queryString == null) {
            return false;
        }
        return queryString.indexOf("isc_rpc=1") != -1 || queryString.indexOf("is_isc_rpc=true") != -1;
    }

    public static boolean isXmlHttp(HttpServletRequest request) {
        String queryString = request.getQueryString();
        if (queryString == null) {
            return false;
        }
        return queryString.indexOf("isc_xhr=1") != -1 || queryString.indexOf("xmlHttp=true") != -1;
    }

    public static long getTransactionNum(HttpServletRequest request) {
        try {
            Map queryParams = ServletTools.parseQueryString(request.getQueryString());
            String transactionNum = (String)queryParams.get("isc_tnum");
            if (transactionNum == null) {
                transactionNum = (String)queryParams.get("iscTNum");
            }
            if (RPCManager.isXmlHttp(request)) {
                transactionNum = request.getParameter("isc_tnum");
            }
            if (transactionNum == null) {
                return -1L;
            }
            return Long.valueOf(transactionNum);
        }
        catch (Exception e) {
            log.warn((Object)"Error parsing transaction from query params", e);
            return -1L;
        }
    }

    private static String getClientVersion(HttpServletRequest request) {
        try {
            Map queryParams = ServletTools.parseQueryString(request.getQueryString());
            String version = (String)queryParams.get("isc_v");
            if (version == null) {
                version = (String)queryParams.get("isc_clientVersion");
            }
            return version;
        }
        catch (Exception e) {
            log.warn("Error decoding query string: " + request.getQueryString() + " - can't determine client version");
            return null;
        }
    }

    public static void writeDocumentDomain(Writer out, RequestContext context) throws IOException {
        String documentDomain = RPCManager.getDocumentDomain((HttpServletRequest)context.request);
        if (documentDomain != null) {
            out.write("<SCRIPT>document.domain = '" + documentDomain + "';</SCRIPT>\n");
        }
    }

    private static String getDocumentDomain(HttpServletRequest request) {
        try {
            Map queryParams = ServletTools.parseQueryString(request.getQueryString());
            String dd = (String)queryParams.get("isc_dd");
            if (dd == null) {
                dd = (String)queryParams.get("docDomain");
            }
            return dd;
        }
        catch (Exception e) {
            log.warn("Error decoding query string: " + request.getQueryString() + " - can't determine docDomain");
            return null;
        }
    }

    public RPCManager(Servlet servlet, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this(servlet, request, response, null);
    }

    public RPCManager(Servlet servlet, HttpServletRequest request, HttpServletResponse response, HttpServletRequestParser parser) throws Exception {
        this.constructed = System.currentTimeMillis();
        if (!ISCInit.isInitialized() && !initNotRunMessageShown) {
            log.warn("ISC Init has not been run.");
            initNotRunMessageShown = true;
        }
        if (request == null) {
            throw new Exception("RPCManager constructor was passed a null HttpServletRequest");
        }
        this.context = RequestContext.instance(servlet, request, response);
        this.initLog(request);
        if (parser == null) {
            this.parseRequest();
        } else {
            parser.parseRequest(this, request);
        }
        this.addToTemplateContext("servletRequest", new ServletRequestAttributeMapFacade(request));
        this.addToTemplateContext("session", new SessionAttributeMapFacade(request.getSession()));
        this.started = System.currentTimeMillis();
        for (int i = 0; i < this.requests.size(); ++i) {
            Object obj = this.requests.get(i);
            if (!(obj instanceof DSRequest)) continue;
            DSRequest dsRequest = (DSRequest)obj;
            dsRequest.recordTimingData("RPCManager construction", DSRequest.TimingLogType.END, this.getStartedTimestamp());
            dsRequest.recordTimingData("RPCManager processing", DSRequest.TimingLogType.START, this.getStartedTimestamp());
        }
    }

    public RPCManager(HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (request == null) {
            throw new Exception("RPCManager constructor was passed a null HttpServletRequest");
        }
        this.context = RequestContext.instance(ISCFile.servletContext, (ServletRequest)request, (ServletResponse)response);
        this.initLog(request);
        this.parseRequest();
        this.addToTemplateContext("servletRequest", new ServletRequestAttributeMapFacade(request));
        this.addToTemplateContext("session", new SessionAttributeMapFacade(request.getSession()));
    }

    protected void initLog(HttpServletRequest request) {
        try {
            Map queryParams = ServletTools.parseQueryString(request.getQueryString());
            String logging = (String)queryParams.get("isc_rpc_logging");
            if ("off".equals(logging)) {
                log.setInstanceLevel(Logger.OFF);
            }
        }
        catch (Exception e) {
            log.warn((Object)"Error initializing log settings", e);
        }
    }

    public RPCManager(HttpServletRequest request, HttpServletResponse response, Writer out) throws Exception {
        this(request, response);
        this.context.setOut(out);
        this.addToTemplateContext("servletRequest", new ServletRequestAttributeMapFacade(request));
        this.addToTemplateContext("session", new SessionAttributeMapFacade(request.getSession()));
    }

    public void setCustomHTML(String customHTML) {
        this.customHTML = customHTML;
    }

    public void doCustomResponse() {
        this.responseIsCustom = true;
    }

    public void setResponseCharset(String charset) {
        this.charset = charset;
    }

    public Object getData() {
        return this.getRequest().getData();
    }

    public DSRequest getDSRequest() {
        return this.getDSRequest(false);
    }

    public DSRequest getDSRequest(boolean skipWarning) {
        Object req;
        int requestCount = this.requestCount();
        if (requestCount > 1 && !skipWarning) {
            log.warn((Object)("getDSRequest() on multiop RPC (" + requestCount + " requests pending) "), new Exception());
        }
        if ((req = this.requests.get(0)) instanceof DSRequest) {
            return (DSRequest)req;
        }
        return null;
    }

    public RPCRequest getRequest() {
        int requestCount = this.requestCount();
        if (requestCount > 1) {
            log.warn((Object)("getRequest() on multiop RPC (" + requestCount + " requests pending) "), new Exception());
        }
        return (RPCRequest)this.requests.get(0);
    }

    public List getRequests() {
        return this.requests;
    }

    public int requestCount() {
        return this.requests.size();
    }

    public void send(Object data) throws Exception {
        this.send(new RPCResponse(data));
    }

    public void send(RPCResponse rpcResponse) throws Exception {
        RPCRequest rpcRequest = this.getRequest();
        if (this.responseMap.get(rpcRequest) != null) {
            throw new Exception("Single-argument send() method called twice.  This method may only be called once in response to a single RPCRequest.");
        }
        this.send(rpcRequest, rpcResponse);
    }

    public void send(RPCRequest rpcRequest, RPCResponse rpcResponse) throws Exception {
        if (this.responseMap.get(rpcRequest) != null) {
            throw new Exception("send(rpcRequest, rpcResponse) called twice for the same rpcRequest.  Only one RPCResponse can be sent to an RPCRequest.");
        }
        this.responseMap.put(rpcRequest, rpcResponse);
        if (this.responseMap.size() == this.requestCount()) {
            this.completeResponse();
        }
    }

    public void send(RPCRequest rpcRequest, Object data) throws Exception {
        RPCResponse rpcResponse = new RPCResponse();
        rpcResponse.setData(data);
        rpcResponse.setStatus(RPCResponse.STATUS_SUCCESS);
        this.send(rpcRequest, rpcResponse);
    }

    public void sendXMLString(RPCRequest rpcRequest, String xml) throws Exception {
        ValidationContext validationContext = new ValidationContext();
        Object data = XML.toDSRecords(new StringReader(xml), validationContext);
        this.send(rpcRequest, data);
    }

    public void send(DSRequest dsRequest, DSResponse dsResponse) throws Exception {
        if (!this.isDownload) {
            this.isDownload = dsRequest.isDownload();
        }
        if (!this.isExport) {
            this.isExport = dsRequest.isExport();
        }
        this.responseMap.put(dsRequest, dsResponse);
        if (this.responseMap.size() == this.requestCount()) {
            this.completeResponse();
        }
    }

    public void send(DSRequest dsRequest, Object data) throws Exception {
        DSResponse dsResponse = new DSResponse(dsRequest == null ? (DataSource)null : dsRequest.getDataSource());
        dsResponse.setData(data);
        dsResponse.setStatus(DSResponse.STATUS_SUCCESS);
        this.send(dsRequest, dsResponse);
    }

    public void sendXMLString(DSRequest dsRequest, String xml) throws Exception {
        ValidationContext validationContext = new ValidationContext();
        Object data = XML.toDSRecords(new StringReader(xml), validationContext);
        this.send(dsRequest, data);
    }

    public void sendSuccess(RPCRequest rpcRequest) throws Exception {
        RPCResponse rpcResponse = new RPCResponse("success");
        this.send(rpcRequest, rpcResponse);
    }

    public void sendFailure(Object request, String error) throws Exception {
        if (request instanceof DSRequest) {
            DSResponse dsResponse = new DSResponse(((DSRequest)request).getDataSource(), DSResponse.STATUS_FAILURE);
            dsResponse.setData(error);
            this.send((DSRequest)request, dsResponse);
        } else {
            RPCResponse rpcResponse = new RPCResponse(error);
            rpcResponse.setStatus(RPCResponse.STATUS_FAILURE);
            this.send((RPCRequest)request, rpcResponse);
        }
    }

    public void sendFailure(Object request, Throwable t) throws Exception {
        this.sendFailure(request, DataTools.getStackTrace(Reflection.getRealTargetException(t)));
    }

    public static Object filterDSResponseData(DSResponse dsResponse, DataSource ds) throws Exception {
        Map jsResponse = dsResponse.getJSResponse();
        Object data = jsResponse.get("data");
        if (ds == null || dsResponse.getBypassDataFilter().booleanValue()) {
            return data;
        }
        if (data instanceof JSONFilter) {
            IBeanFilter beanFilter = ((JSONFilter)data).getBeanFilter();
            if (beanFilter instanceof KeepPropertiesBeanFilter) {
                Collection propsToKeep = ((KeepPropertiesBeanFilter)beanFilter).getPropsToKeep();
                Object obj = ((JSONFilter)data).getObj();
                DataSourceBeanFilter newFilter = new DataSourceBeanFilter(ds, propsToKeep);
                return new JSONFilter(obj, newFilter);
            }
        } else {
            boolean dropExtraFields = config.getBoolean((Object)"DSResponse.dropExtraFields", false);
            if (dsResponse.getDropExtraFields() != null) {
                dropExtraFields = dsResponse.getDropExtraFields();
                log.debug("DMI response, dropExtraFields: " + dropExtraFields);
            } else {
                if (ds.dropExtraFieldsDefined()) {
                    dropExtraFields = ds.dropExtraFields();
                }
                log.debug("non-DMI response, dropExtraFields: " + dropExtraFields);
            }
            return new JSONFilter(data, ds, dropExtraFields);
        }
        return data;
    }

    public static Object filterDSResponseData(DSRequest dsRequest, DSResponse dsResponse, DataSource ds) throws Exception {
        Map jsResponse = dsResponse.getJSResponse();
        Object data = jsResponse.get("data");
        if (ds == null || dsResponse.getBypassDataFilter().booleanValue()) {
            return data;
        }
        if (data instanceof JSONFilter) {
            return RPCManager.filterDSResponseData(dsResponse, ds);
        }
        boolean dropExtraFields = config.getBoolean((Object)"DSResponse.dropExtraFields", false);
        if (dsResponse.getDropExtraFields() != null) {
            dropExtraFields = dsResponse.getDropExtraFields();
            log.debug("DMI response, dropExtraFields: " + dropExtraFields);
        } else {
            if (ds.dropExtraFieldsDefined()) {
                dropExtraFields = ds.dropExtraFields();
            }
            log.debug("non-DMI response, dropExtraFields: " + dropExtraFields);
        }
        DataSourceBeanFilter filter = new DataSourceBeanFilter(ds, dsRequest.getConsolidatedOutputs(), dsRequest.getDroppedFields(), dropExtraFields, true);
        return new JSONFilter(data, filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completeResponse() throws Exception {
        try {
            DSRequest dsRequest;
            if (this.responseIsCustom) {
                return;
            }
            if (this.isDownload) {
                Object binaryObj;
                dsRequest = (DSRequest)this.getRequests().get(0);
                String fileName = dsRequest.getDownloadFileName();
                String fieldName = dsRequest.getDownloadFieldName();
                DataSource ds = dsRequest.getDataSource();
                DSField field = ds.getField(fieldName);
                String fieldMimeType = field.getMimeType();
                if (fieldMimeType != null) {
                    this.context.setContentType(fieldMimeType);
                } else {
                    String mimeType = ServletTools.mimeTypeForContext(this.context);
                    if (mimeType != null) {
                        this.context.setContentType(mimeType);
                    }
                }
                DSResponse dsResponse = (DSResponse)this.responseMap.get(dsRequest);
                Object dataObj = dsResponse.getData();
                Map data = dsResponse.getRecord();
                if (data == null) {
                    log.warn("dsResponse.getRecord() returned null when attempting to process a data member of type " + (dataObj == null ? "null" : dataObj.getClass().getName()) + ". Can't continue.");
                    return;
                }
                String nativeName = field.getNativeName();
                if (nativeName == null) {
                    nativeName = fieldName;
                }
                long contentLength = 0L;
                Object lengthObj = data.get(ds.getFilesizeField(nativeName));
                if (lengthObj != null) {
                    contentLength = Long.valueOf(lengthObj.toString());
                }
                if (!ISCBinaryValue.isBinary(binaryObj = data.get(fieldName))) {
                    log.warn("dsResponse.getData().get(\"" + fieldName + "\") returned " + (binaryObj == null ? "null" : " an instance of " + binaryObj.getClass().getName()) + " when we were expecting an InputStream, Byte[] or byte[]. Can't continue.");
                    return;
                }
                String fileNameEncoding = fileName != null ? this.encodeParameter("fileName", fileName) : "";
                if (dsRequest.getOperationType().equals("downloadFile")) {
                    this.context.response.addHeader("content-disposition", "attachment; " + fileNameEncoding);
                } else {
                    this.context.response.addHeader("content-disposition", "inline; " + fileNameEncoding);
                }
                if (contentLength > 0L) {
                    this.context.response.setContentLength((int)contentLength);
                }
                ServletOutputStream os = this.context.response.getOutputStream();
                ISCBinaryValue.copyToOutputStream(binaryObj, (OutputStream)os);
                os.flush();
                return;
            }
            if (this.isExport) {
                Map opBinding;
                dsRequest = (DSRequest)this.getRequests().get(0);
                DSResponse dsResponse = (DSResponse)this.responseMap.get(dsRequest);
                if (!(dsResponse.getExportAs() != null && dsResponse.getExportAs() != "" || !"json".equals(dsRequest.getExportAs()) || (opBinding = dsRequest.getDataSource().getOperationBinding(dsRequest)) != null && "json".equals(opBinding.get("exportAs")))) {
                    String err = "For security reasons, client is not allowed to specify exportAs: 'json'.  Either use a different format or create an operationBinding that specifies exportAs: 'json' instead.";
                    log.warn(err);
                    this.context.out().write(err);
                    return;
                }
                dsRequest.copyExportSettingsToResponse(dsResponse);
                if (dsResponse.getStatus() != DSResponse.STATUS_SUCCESS && !dsResponse.shouldExportToClient().booleanValue()) {
                    JSTranslater jsTrans = JSTranslater.instance();
                    jsTrans.omitNullMapValues(this.omitNullMapValuesInResponse);
                    jsTrans.enablePrettyPrinting(this.prettyPrintResponse);
                    jsTrans = this.setEnumProperties(jsTrans);
                    ValidationContext vc = new ValidationContext();
                    vc.setDSRequest(dsRequest);
                    jsTrans.setTypeLookupVC(vc);
                    ArrayList<Map> responseList = new ArrayList<Map>();
                    responseList.add(dsResponse.getJSResponse());
                    this.context.out().write(structuredRPCStart);
                    jsTrans.toJS(responseList, this.context.out());
                    this.context.out().write(structuredRPCEnd);
                    return;
                }
                if (dsResponse.shouldExportToClient().booleanValue() || dsResponse.shouldExportToFilesystem().booleanValue() && dsResponse.getExportTo() == null) {
                    String lineBreakStyle;
                    String exportAs;
                    List<Object> data = new ArrayList();
                    Iterator iterator = null;
                    Object initData = dsResponse.getData();
                    if (initData instanceof List) {
                        data = (List)initData;
                    } else if (initData instanceof Object[]) {
                        Object[] arr = (Object[])initData;
                        for (int i = 0; i < arr.length; ++i) {
                            data.add(arr[i]);
                        }
                    } else if (initData instanceof Iterator) {
                        iterator = (Iterator)initData;
                    } else {
                        data.add(initData);
                    }
                    HashMap<String, String> fieldMap = dsResponse.getExportFieldTitles();
                    boolean receivedTitleMap = true;
                    if (fieldMap == null) {
                        fieldMap = new HashMap<String, String>();
                        receivedTitleMap = false;
                    }
                    DataSource ds = dsResponse.getDataSource() != null ? dsResponse.getDataSource() : dsRequest.getDataSource();
                    List fieldNames = ds != null ? ds.getFieldNames() : dsResponse.getExportFields();
                    List exportFields = dsResponse.getExportFields();
                    if (exportFields == null) {
                        exportFields = fieldNames;
                    }
                    Map exportFieldTitles = dsResponse.getExportFieldTitles();
                    HashMap<String, String> exportOtherFields = (HashMap<String, String>)dsResponse.getParameter("exportOtherFields");
                    if (exportOtherFields == null) {
                        exportOtherFields = new HashMap<String, String>();
                    }
                    if ((exportAs = dsResponse.getExportAs()) != null) {
                        exportAs = exportAs.toLowerCase();
                    }
                    if ((lineBreakStyle = dsResponse.getLineBreakStyle()) != null) {
                        lineBreakStyle = lineBreakStyle.toLowerCase();
                    }
                    String separatorChar = dsResponse.getExportTitleSeparatorChar();
                    for (int i = 0; i < exportFields.size(); ++i) {
                        String fieldName = (String)exportFields.get(i);
                        String fieldTitle = (String)exportOtherFields.get(fieldName);
                        if (fieldTitle == null) {
                            String string = fieldTitle = exportFieldTitles != null ? (String)exportFieldTitles.get(fieldName) : null;
                        }
                        if (fieldTitle == null) {
                            DSField field;
                            fieldTitle = fieldName;
                            if (ds != null && (field = ds.getField(fieldName)) != null && !field.getBoolean("hidden")) {
                                String string = fieldTitle = field.getProperty("exportTitle") != null ? field.getProperty("exportTitle") : field.getTitle();
                            }
                        }
                        if (exportAs.equals("xml")) {
                            if (separatorChar == null) {
                                separatorChar = "";
                            }
                            if (fieldTitle == null) {
                                fieldTitle = fieldName;
                            }
                            fieldTitle = fieldTitle.replaceAll("[$&<>() ]", separatorChar);
                        }
                        if (!receivedTitleMap) {
                            fieldMap.put(fieldName, fieldName);
                        }
                        exportOtherFields.put(fieldName, fieldTitle);
                    }
                    LinkedMap settings = new LinkedMap();
                    settings.put("exportAs", exportAs);
                    settings.put("lineBreakStyle", lineBreakStyle);
                    settings.put("exportDelimiter", dsResponse.getExportDelimiter());
                    settings.put("dataSource", ds);
                    settings.put("exportFields", exportFields);
                    settings.put("exportHeader", dsResponse.getExportHeader());
                    settings.put("exportHeaderless", dsResponse.getExportHeaderless());
                    settings.put("exportFooter", dsResponse.getExportFooter());
                    settings.put("exportOtherFields", exportOtherFields);
                    settings.put("exportDatesAsFormattedString", dsResponse.getExportDatesAsFormattedString());
                    DataExport de = DataExport.getDataExport((Map)settings, dsRequest);
                    OutputStream os1 = null;
                    BufferedOutputStream os2 = null;
                    String fileName = dsResponse.getExportFilename();
                    if (fileName == null) {
                        fileName = "export";
                    }
                    if (fileName.indexOf(".") == -1) {
                        fileName = fileName + "." + (exportAs.equals("ooxml") ? "xlsx" : exportAs);
                    }
                    String qname = config.getPath("export.location");
                    if (!config.getBoolean((Object)"export.allow.filesystem", false) && dsResponse.shouldExportToFilesystem().booleanValue()) {
                        log.warn("Cannot export to filesystem because the system is not configured to allow it. Add 'export.allow.filesystem: true' to your server.properties file to correct this");
                        dsResponse.setExportToFilesystem(false);
                    } else if (dsResponse.shouldExportToFilesystem().booleanValue()) {
                        String path;
                        if (qname == null) {
                            qname = "";
                        }
                        if (!qname.endsWith("/") && qname.length() > 0) {
                            qname = qname + "/";
                        }
                        if ((path = dsResponse.getExportPath()) != null) {
                            qname = qname + path;
                        }
                        if (!qname.endsWith("/") && qname.length() > 0) {
                            qname = qname + "/";
                        }
                        if (fileName != null) {
                            qname = qname + fileName;
                        }
                        os1 = new BufferedOutputStream(new FileOutputStream(qname));
                    }
                    if (dsRequest.shouldExportToClient()) {
                        String fileNameEncoding = this.encodeParameter("fileName", fileName);
                        if (dsResponse.getExportDisplay().equals("download")) {
                            this.context.response.addHeader("content-disposition", "attachment; " + fileNameEncoding);
                            this.context.setContentType(DataExport.getMimeTypeForFormat(exportAs));
                        } else {
                            this.context.response.addHeader("content-disposition", "inline; " + fileNameEncoding);
                        }
                        if (os1 == null) {
                            os1 = new BufferedOutputStream((OutputStream)this.context.response.getOutputStream());
                        } else {
                            os2 = new BufferedOutputStream((OutputStream)this.context.response.getOutputStream());
                        }
                    }
                    if (iterator == null) {
                        iterator = data.iterator();
                    }
                    int contentLength = de.exportResultSet(iterator, fieldMap, os1, os2, dsResponse);
                    if (dsResponse.shouldExportToFilesystem().booleanValue() && os1 != null) {
                        os1.flush();
                        os1.close();
                    }
                    if (dsRequest.shouldExportToClient()) {
                    } else {
                        JSTranslater jsTrans = JSTranslater.instance();
                        jsTrans.omitNullMapValues(this.omitNullMapValuesInResponse);
                        jsTrans.enablePrettyPrinting(this.prettyPrintResponse);
                        jsTrans = this.setEnumProperties(jsTrans);
                        ValidationContext vc = new ValidationContext();
                        vc.setDSRequest(dsRequest);
                        jsTrans.setTypeLookupVC(vc);
                        DSResponse clientResponse = new DSResponse();
                        clientResponse.setStatus(DSResponse.STATUS_SUCCESS);
                        if (dsResponse.shouldExportToFilesystem().booleanValue()) {
                            clientResponse.setData("Successfully exported " + qname);
                        }
                        ArrayList<Map> responseList = new ArrayList<Map>();
                        responseList.add(clientResponse.getJSResponse());
                        this.context.out().write(structuredRPCStart);
                        jsTrans.toJS(responseList, this.context.out());
                        this.context.out().write(structuredRPCEnd);
                    }
                }
                return;
            }
            boolean isXMLHttp = this.context.response != null && RPCManager.isXmlHttp((HttpServletRequest)this.context.request);
            try {
                this.context.setNoCacheHeaders();
            }
            catch (Exception e) {
                log.warn(e.toString());
            }
            try {
                String contentType;
                String string = contentType = isXMLHttp ? "text/plain" : "text/html";
                if (this.charset != null && !this.charset.trim().equals("")) {
                    contentType = contentType + "; charset=" + this.charset;
                }
                this.context.setContentType(contentType);
                log.debug("Content type for RPC transaction: " + contentType);
            }
            catch (Exception e) {
                log.warn(e.toString());
            }
            Writer out = config.getBoolean((Object)"IDACall.showClientOutput", false) && (this.getDSRequest(true) == null || !this.getDSRequest(true).shouldStreamResults()) ? new StringWriter() : this.context.out();
            boolean failure = this.queueHasFailures();
            boolean partialCommit = false;
            try {
                if (failure) {
                    this.onFailure();
                } else {
                    this.onSuccess();
                }
            }
            catch (PartialCommitException pce) {
                partialCommit = true;
            }
            catch (Exception e) {
                log.warn(DataTools.getStackTrace(Reflection.getRealTargetException(e)));
            }
            this.encodeBinaryStreams();
            long rpcCompletionTimestamp = System.currentTimeMillis();
            ArrayList<Map> orderedResponseList = new ArrayList<Map>();
            for (Object request : this.requests) {
                Map timing;
                Object response = this.responseMap.get(request);
                if (response == null) {
                    throw new Exception("No response for request: " + request.toString());
                }
                if (response instanceof RPCResponse) {
                    HashMap<String, Object> payload = new HashMap<String, Object>();
                    payload.put("data", ((RPCResponse)response).getData());
                    payload.put("status", new Integer(((RPCResponse)response).getStatus()));
                    orderedResponseList.add(payload);
                    if (((RPCResponse)response).getStatus() >= 0) continue;
                    failure = true;
                    continue;
                }
                if (!(response instanceof DSResponse)) continue;
                DSResponse dsResponse = (DSResponse)response;
                if (dsResponse.wantsConnectionClosed()) {
                    this.closeConnection = true;
                }
                if (dsResponse.getStatus() < 0) {
                    failure = true;
                }
                Map jsResponse = dsResponse.getJSResponse(true);
                DSRequest dsRequest2 = (DSRequest)request;
                String dsName = dsRequest2.getDataSourceName();
                DataSource ds = dsRequest2.getDataSource();
                if (ds != null) {
                    Object data = RPCManager.filterDSResponseData(dsRequest2, dsResponse, ds);
                    jsResponse.put("data", data);
                }
                if (dsRequest2.trackTimings() && (timing = (Map)jsResponse.get("timing")) != null) {
                    List topLevelChildren = (List)timing.get("children");
                    if (topLevelChildren != null) {
                        for (int k = 0; k < topLevelChildren.size(); ++k) {
                            Map entry = (Map)topLevelChildren.get(k);
                            if (!"RPCManager processing".equals(entry.get("name"))) continue;
                            entry.put("end", rpcCompletionTimestamp);
                            break;
                        }
                    }
                    LinkedMap serialize = new LinkedMap();
                    serialize.put("name", "DSResponse serialization");
                    serialize.put("start", rpcCompletionTimestamp);
                    serialize.put("end", new CurrentMillisMarker());
                    topLevelChildren.add(serialize);
                    timing.put("end", new CurrentMillisMarker());
                }
                orderedResponseList.add(jsResponse);
            }
            DSRequest dsReq = this.getDSRequest(true);
            if (isXMLHttp || this.isREST(dsReq)) {
                if (this.isREST(dsReq)) {
                    if (this.jsCallback != null) {
                        RPCManager.writeIframePrefix(out, this, null, null);
                    }
                    if (!isXMLHttp && dsReq.getWrapJSONResponses().booleanValue() && "json".equalsIgnoreCase(dsReq.getDataFormat())) {
                        out.write(dsReq.getJsonPrefix());
                    }
                } else {
                    out.write(structuredRPCStart);
                }
                JSTranslater jsTrans = JSTranslater.instance();
                jsTrans.omitNullMapValues(this.omitNullMapValuesInResponse);
                jsTrans.enablePrettyPrinting(this.prettyPrintResponse);
                jsTrans = this.setEnumProperties(jsTrans);
                ValidationContext vc = new ValidationContext();
                vc.setDSRequest(dsReq);
                jsTrans.setTypeLookupVC(vc);
                if (this.isREST(dsReq)) {
                    jsTrans.strictJSONMode();
                    jsTrans.setWriteXMLSchemaDate(true);
                    if ("json".equalsIgnoreCase(dsReq.getDataFormat())) {
                        if (orderedResponseList.size() > 1) {
                            ArrayList<LinkedMap> restList = new ArrayList<LinkedMap>();
                            for (int i = 0; i < orderedResponseList.size(); ++i) {
                                LinkedMap restContainer = new LinkedMap();
                                restContainer.put("response", orderedResponseList.get(i));
                                restList.add(restContainer);
                            }
                            jsTrans.toJS(restList, out);
                        } else {
                            LinkedMap restContainer = new LinkedMap();
                            restContainer.put("response", orderedResponseList.get(0));
                            jsTrans.toJS(restContainer, out);
                        }
                    } else {
                        StringWriter sw = new StringWriter();
                        sw.write("<?xml version=\"1.0\"?>\n");
                        if (orderedResponseList.size() > 1) {
                            sw.write("<responses>\n");
                        }
                        for (int i = 0; i < this.requests.size(); ++i) {
                            dsReq = (DSRequest)this.requests.get(i);
                            DSResponse response = (DSResponse)this.responseMap.get(dsReq);
                            response.setDataSource(dsReq.getDataSource());
                            sw.write("<response>\n");
                            sw.write("<status>" + response.getStatus() + "</status>\n");
                            Object queueStatus = response.getProperty("queueStatus");
                            if (queueStatus != null) {
                                sw.write("<queueStatus>" + queueStatus + "</queueStatus>");
                            }
                            if (response.statusIsSuccess()) {
                                sw.write("<startRow>" + response.getStartRow() + "</startRow>\n");
                                sw.write("<endRow>" + response.getEndRow() + "</endRow>\n");
                                sw.write("<totalRows>" + response.getTotalRows() + "</totalRows>\n");
                                sw.write("<data>\n");
                                Object data = response.getData();
                                XML.recordsToXML("record", response.getRecords(), sw, false, dsReq);
                                sw.write("</data>\n");
                            } else {
                                XML.recordToXML("errors", (Map)((Object)response.getErrorReport()), sw, false, dsReq);
                            }
                            sw.write("</response>\n");
                        }
                        if (orderedResponseList.size() > 1) {
                            sw.write("</responses>");
                        }
                        out.write(sw.toString());
                    }
                } else {
                    if (dsReq != null && dsReq.getUseStrictJSON()) {
                        jsTrans.strictJSONMode();
                    }
                    jsTrans.toJS(orderedResponseList, out);
                }
                if (this.isREST(dsReq)) {
                    if (!isXMLHttp && dsReq.getWrapJSONResponses().booleanValue() && "json".equalsIgnoreCase(dsReq.getDataFormat())) {
                        out.write(dsReq.getJsonSuffix());
                    }
                    if ("json".equalsIgnoreCase(dsReq.getDataFormat())) {
                        this.context.response.setContentType("application/json");
                    } else {
                        this.context.response.setContentType("text/xml");
                    }
                    if (this.jsCallback != null) {
                        this.context.response.setContentType("text/html");
                        RPCManager.writeIframePostfix(out);
                    }
                } else {
                    out.write(structuredRPCEnd);
                }
            } else {
                this.iframeWrite(out, true, orderedResponseList);
            }
            out.flush();
            if (out instanceof StringWriter) {
                String output = out.toString();
                int outputSize = output.length();
                log.debug("Uncompressed result size: " + outputSize + " bytes");
                this.context.out().write(output);
                this.context.out().flush();
                if (config.getBoolean((Object)"devenv", false)) {
                    log.debug((Object)"Output to client", output);
                }
            }
        }
        catch (Exception e) {
            try {
                this.onFailure();
            }
            catch (Exception e2) {
                log.warn(DataTools.getStackTrace(Reflection.getRealTargetException(e2)));
            }
            finally {
                throw e;
            }
        }
        finally {
            for (Object request : this.requests) {
                if (!(request instanceof DSRequest)) continue;
                DSRequest dsRequest = (DSRequest)request;
                if (!dsRequest.getFreeOnExecute()) {
                    dsRequest.freeResources();
                }
                dsRequest.freeQueueResources();
            }
            this.freeRPCResources();
        }
    }

    protected void freeRPCResources() {
        for (DSRequest associatedRequest : this.associatedRequests) {
            if (this.requests.contains(associatedRequest)) continue;
            associatedRequest.freeResources();
            associatedRequest.freeQueueResources();
        }
    }

    public boolean queueHasFailures() {
        for (Object req : this.requests) {
            Object resp = this.responseMap.get(req);
            if (resp instanceof RPCResponse && ((RPCResponse)resp).getStatus() < 0) {
                return true;
            }
            if (!(resp instanceof DSResponse) || ((DSResponse)resp).getStatus() >= 0) continue;
            return true;
        }
        return false;
    }

    protected void onFailure() throws Exception {
        this.onFailure(null);
    }

    protected void onFailure(DataSource testDS) throws Exception {
        boolean transactionalFailure = false;
        for (Object obj : this.requests) {
            if (!(obj instanceof DSRequest)) continue;
            DSRequest req = (DSRequest)obj;
            BasicDataSource ds = (BasicDataSource)req.getDataSource();
            if (testDS != null && ds != null && !ds.getName().equals(testDS.getName())) continue;
            DSResponse resp = this.getResponse((DSRequest)obj);
            if (testDS == null && (resp == null || resp.getStatus() >= 0)) continue;
            if (req.isPartOfTransaction()) {
                transactionalFailure = true;
                break;
            }
            if (req.isPartOfTransactionKnown() || ds == null || !ds.shouldAutoJoinTransaction(req) || !ds.shouldAutoStartTransaction(req, true) && !this.requestQueueIncludesPriorUpdate(req)) continue;
            transactionalFailure = true;
            break;
        }
        for (Object obj : this.requests) {
            Object trxObj2;
            Object trxObj1;
            if (!(obj instanceof DSRequest)) continue;
            DSResponse resp = this.getResponse((DSRequest)obj);
            resp.setProperty("queueStatus", -1);
            if (!transactionalFailure) continue;
            DSRequest req = (DSRequest)obj;
            if (testDS != null && testDS instanceof BasicDataSource && req.getDataSource() instanceof BasicDataSource && (trxObj1 = ((BasicDataSource)testDS).getTransactionObject(req)) != (trxObj2 = ((BasicDataSource)req.getDataSource()).getTransactionObject(req)) || !req.isPartOfTransaction() || resp == null || resp.getStatus() != DSResponse.STATUS_SUCCESS) continue;
            resp.setStatus(-10);
        }
        ArrayList list = new ArrayList();
        int dsPosition = 0;
        for (Object obj : this.callbacks) {
            if (obj instanceof DataSource) {
                list.add(dsPosition++, obj);
                continue;
            }
            list.add(obj);
        }
        for (RPCManagerCompletionCallback callback : list) {
            if (testDS != null && callback instanceof DataSource && !((DataSource)((Object)callback)).getName().equals(testDS.getName())) continue;
            try {
                callback.onFailure(this, transactionalFailure);
            }
            catch (Exception e) {
                if (testDS == null) {
                    log.warn((Object)"Exception thrown during onFailure processing", e);
                    continue;
                }
                throw e;
            }
        }
    }

    protected void onSuccess() throws Exception {
        for (Object requestObj : this.requests) {
            if (!(requestObj instanceof DSRequest)) continue;
            DSRequest dsRequest = (DSRequest)requestObj;
            DSResponse dsResponse = this.getResponse(dsRequest);
            dsResponse.setProperty("queueStatus", 0);
        }
        ArrayList<String> partialCommits = new ArrayList<String>();
        ArrayList list = new ArrayList();
        int dsPosition = 0;
        for (Object obj : this.callbacks) {
            if (obj instanceof DataSource) {
                list.add(dsPosition++, obj);
                continue;
            }
            list.add(obj);
        }
        for (RPCManagerCompletionCallback callback : list) {
            try {
                callback.onSuccess(this);
            }
            catch (Exception e) {
                String warning = "Exception thrown during onSuccess processing in class " + callback.getClass().getName();
                if (callback instanceof DataSource) {
                    warning = warning + " (DataSource " + ((DataSource)((Object)callback)).getName() + ")" + " - changes might not have been committed";
                    partialCommits.add("DataSource " + ((DataSource)((Object)callback)).getName());
                    log.warn((Object)warning, e);
                    try {
                        this.onFailure((DataSource)((Object)callback));
                    }
                    catch (Exception e2) {
                        log.warn((Object)"Exception thrown during onFailure processing invoked to handle a failure detected during onSuccess", e2);
                    }
                    continue;
                }
                partialCommits.add(callback.getClass().getName());
                log.warn((Object)warning, e);
            }
        }
        if (partialCommits.size() > 0) {
            throw new PartialCommitException("Some callbacks failed during onSuccess processing - changes might not have been committed.  Failing classes: " + ((Object)partialCommits).toString());
        }
    }

    public void encodeBinaryStreams() throws Exception {
        for (Object request : this.requests) {
            if (!(request instanceof DSRequest)) continue;
            DSResponse resp = this.getResponse((DSRequest)request);
            DataSource ds = resp.getDataSource();
            List data = null;
            if (ds == null) continue;
            List fields = ds.getFields();
            for (DSField field : fields) {
                if (field == null || !field.shouldEncodeInResponse()) continue;
                if (data == null) {
                    data = resp.getRecords();
                }
                for (Map record : data) {
                    Object value;
                    if (record == null || !((value = record.get(field.getName())) instanceof InputStream)) continue;
                    String encoded = DataTools.base64Encode((InputStream)value);
                    record.put(field.getName(), encoded);
                }
            }
        }
    }

    public DSResponse getResponse(DSRequest req) {
        Object resp = this.responseMap.get(req);
        if (resp instanceof DSResponse) {
            return (DSResponse)resp;
        }
        return null;
    }

    public DSResponse findLastResponse(String dsName, String opType) {
        return this.findResponse("last", dsName, opType);
    }

    public DSResponse findFirstResponse(String dsName, String opType) {
        return this.findResponse("first", dsName, opType);
    }

    public RPCResponse getResponse(RPCRequest req) {
        Object resp = this.responseMap.get(req);
        if (resp instanceof RPCResponse) {
            return (RPCResponse)resp;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JSTranslater setEnumProperties(JSTranslater jsTrans) throws Exception {
        Object requestObj = null;
        for (int i = 0; i < this.requests.size() && !(requestObj instanceof DSRequest); ++i) {
            requestObj = this.requests.get(i);
        }
        if (requestObj instanceof DSRequest) {
            String dsName = ((DSRequest)requestObj).getDataSourceName();
            if (dsName == null) {
                return jsTrans;
            }
            DataSource ds = ((DSRequest)requestObj).getDataSource();
            boolean freeDS = false;
            if (ds == null) {
                ds = DataSourceManager.getDataSource(dsName, requestObj);
                freeDS = true;
            }
            if (ds == null) {
                return jsTrans;
            }
            try {
                jsTrans.setEnumTranslateStrategy(ds.getEnumTranslateStrategy());
                jsTrans.setEnumOrdinalProperty(ds.getEnumOrdinalProperty());
                jsTrans.setEnumConstantProperty(ds.getEnumConstantProperty());
            }
            finally {
                if (freeDS) {
                    DataSourceManager.freeDataSource(ds);
                }
            }
        }
        return jsTrans;
    }

    public String encodeParameter(String name, String value) {
        Pattern tspecials = Pattern.compile("[<()@,;:/?={} >\"\\[\\]\\t\\\\]");
        Matcher matcher = tspecials.matcher(value);
        if (value.length() <= 78) {
            if (!matcher.find()) {
                return name + "=" + value;
            }
            return name + "=" + "\"" + value + "\"";
        }
        return name + "=" + "\"" + value + "\"";
    }

    private void iframeWrite(Writer out, boolean structured, Object data) throws IOException, UnconvertableException {
        RPCManager.writeIframePrefix(out, this, null, null);
        if (structured) {
            out.write(structuredRPCStart);
        }
        JSTranslater jsTrans = new JSTranslater();
        jsTrans.quoteForTextArea();
        jsTrans.omitNullMapValues(this.omitNullMapValuesInResponse);
        jsTrans.enablePrettyPrinting(this.prettyPrintResponse);
        try {
            jsTrans = this.setEnumProperties(jsTrans);
        }
        catch (Exception e) {
            UnconvertableException uce = new UnconvertableException();
            uce.initCause(e);
            throw uce;
        }
        jsTrans.toJS(data, out);
        if (structured) {
            out.write(structuredRPCEnd);
        }
        RPCManager.writeIframePostfix(out);
    }

    private void writeCustomIFramePrefix(Writer out) throws IOException {
        if (this.customHTML != null) {
            out.write(this.customHTML);
        }
    }

    public static void writeIframePostfix(Writer out) throws IOException {
        out.write("</TEXTAREA>");
        out.write("</FORM>\n");
        out.write("</BODY></HTML>");
    }

    public static void writeIframePrefix(Writer out, RPCManager rpc, RequestContext context, String jsCallback) throws IOException {
        if (context == null && rpc != null) {
            context = rpc.getContext();
        }
        if (jsCallback == null && rpc != null) {
            jsCallback = rpc.jsCallback;
        }
        out.write("<HTML>\n");
        RPCManager.writeDocumentDomain(out, context);
        if (rpc != null) {
            rpc.writeCustomIFramePrefix(out);
        }
        out.write("<BODY ONLOAD='var results = document.formResults.results.value;" + jsCallback + "'>");
        out.write("<BR><BR><BR><BR><BR><BR><BR><BR><BR><BR><BR><BR><BR><BR><BR><BR><BR><BR>");
        out.write("<FORM name='formResults'><TEXTAREA readonly name='results'>\n");
    }

    private void parseRequest() throws Exception {
        Object operationData;
        if (!RPCManager.isRPC((HttpServletRequest)this.context.request)) {
            throw new Exception("Non-RPC request ignored.");
        }
        String clientVersion = RPCManager.getClientVersion((HttpServletRequest)this.context.request);
        if (!(this.devenv || clientVersion != null && this.serverVersion.equals(clientVersion))) {
            if (clientVersion == null) {
                clientVersion = "pre-5.5b2";
            }
            log.warn("client/server version mismatch.  Client is version: " + clientVersion + ", server is version: " + this.serverVersion + " - mixing different client/server versions is generally not supported." + "  If you've installed a more recent client version, try clearing" + " the browser cache and reloading the page.");
        }
        Map queryParamsMap = new HashMap();
        try {
            queryParamsMap = ServletTools.parseQueryString(this.context.request.getQueryString());
        }
        catch (Exception e) {
            log.error((Object)"caught exception parsing queryParams", e);
        }
        String rawTransactionData = (String)queryParamsMap.get("_transaction");
        if (rawTransactionData == null) {
            rawTransactionData = this.context.request.getParameter("_transaction");
        }
        if (rawTransactionData == null || rawTransactionData.equals("")) {
            Writer out = this.context.out();
            ServletTools.sendHTMLStart(out);
            log.warn("Detected zero-length IDA transaction, asking client to retry.");
            log.warn("Outputting extra debug information:");
            log.warn(this.context.getCookiesAsString());
            log.warn(this.context.getHeadersAsString());
            try {
                log.warn(this.context.getParamsAsString());
            }
            catch (Exception e) {
                log.warn((Object)"Couldn't log params", e);
            }
            RPCManager.writeDocumentDomain(out, this.context);
            out.write("<SCRIPT>");
            out.write("parent.isc.RPCManager.retryOperation(window.name);");
            out.write("</SCRIPT>");
            ServletTools.sendHTMLEnd(out);
            out.flush();
            this.context.response.flushBuffer();
            throw new ClientMustResubmitException("");
        }
        Object transactionData = null;
        if (rawTransactionData.trim().startsWith("{")) {
            transactionData = JSTranslater.instance().fromJS(rawTransactionData);
        } else {
            ValidationContext validationContext = new ValidationContext();
            validationContext.setRestrictedXMLMode(true);
            transactionData = XML.toDSRecords(new StringReader(rawTransactionData), validationContext);
            validationContext.freeResources();
        }
        if (!(transactionData instanceof Map)) {
            throw new Exception("Invalid transaction format: " + (transactionData == null ? "null" : transactionData.getClass().getName()));
        }
        this.transaction = (Map)transactionData;
        this.jsCallback = (String)this.transaction.get("jscallback");
        Long transactionNum = (Long)this.transaction.get("transactionNum");
        Boolean nullValuesHandling = (Boolean)this.transaction.get("omitNullMapValuesInResponse");
        if (nullValuesHandling != null) {
            this.omitNullMapValuesInResponse(nullValuesHandling);
        }
        if (this.jsCallback != null && !DataTools.isIdentifier(this.jsCallback)) {
            throw new Exception("Invalid jsCallback parameter: " + DataTools.escapeHTML(this.jsCallback));
        }
        if (IFRAME_NEW_WINDOW.equals(this.jsCallback) || IFRAME_RECURSE_UP.equals(this.jsCallback)) {
            this.jsCallback = this.generateIFrameCallback(this.jsCallback, transactionNum);
        }
        if (!((operationData = this.transaction.get("operations")) instanceof List)) {
            throw new Exception("Invalid 'operations' format" + operationData.getClass().getName());
        }
        List operations = (List)operationData;
        int requestNum = 0;
        log.debug("Processing " + operations.size() + " requests.");
        Iterator i = operations.iterator();
        while (i.hasNext()) {
            Map m;
            ++requestNum;
            Object payload = i.next();
            if (payload instanceof Map && (m = (Map)payload).get("appID") != null && m.get("operation") != null) {
                BasicDataSource ds;
                DSRequest dsRequest;
                Object criteria;
                if (!config.getBoolean((Object)"datasource.allowClientAdditionalOutputs", true)) {
                    m.remove("additionalOutputs");
                }
                if ((criteria = m.remove("where")) != null) {
                    m.put("criteria", criteria);
                }
                if ((dsRequest = new DSRequest(m, this.context, this)).shouldStreamResults()) {
                    dsRequest.setFreeOnExecute(false);
                }
                if ((ds = (BasicDataSource)dsRequest.getDataSource()) != null && DataTools.getBoolean(ds.getConfig(), "noNullUpdates")) {
                    for (Object key : m.keySet()) {
                        if (!key.equals("criteria") && !key.equals("values")) continue;
                        Map values = (Map)m.get(key);
                        for (String vKey : values.keySet()) {
                            DSField field;
                            Object value = values.get(vKey);
                            if (value != null || !ds.getSimpleBaseType((field = ds.getField(vKey)).getType()).equals("text")) continue;
                            values.put(vKey, "");
                        }
                    }
                }
                if (log.isDebugEnabled() && maxRequestDebugLength != 0) {
                    String payloadString = DataTools.prettyPrint(m);
                    if (maxRequestDebugLength > 0 && payloadString.length() > maxRequestDebugLength) {
                        payloadString = payloadString.substring(0, maxRequestDebugLength) + "....[truncated " + (payloadString.length() - maxRequestDebugLength) + "bytes - to change, set config param RPCManager.maxRequestDebugLength" + " to desired max bytes (in server.properties)" + " - zero disables/negative value allows arbitrary length messages].";
                    }
                    log.debug("Request #" + requestNum + " (DSRequest) payload: " + payloadString);
                }
                this.addRequest(dsRequest);
                continue;
            }
            if (payload instanceof String) {
                if ("__ISC_NULL__".equals((String)payload)) {
                    payload = null;
                } else if ("__ISC_EMPTY_STRING__".equals((String)payload)) {
                    payload = "";
                }
            }
            if (log.isDebugEnabled() && maxRequestDebugLength != 0) {
                String payloadString = DataTools.prettyPrint(payload);
                if (maxRequestDebugLength > 0 && payloadString.length() > maxRequestDebugLength) {
                    payloadString = payloadString.substring(0, maxRequestDebugLength) + "....[truncated " + (payloadString.length() - maxRequestDebugLength) + "bytes - to change, set config param RPCManager.maxRequestDebugLength" + " to desired max bytes (in server.properties)" + " - zero disables/negative value allows arbitrary length messages].";
                }
                log.debug("Request #" + requestNum + " (RPCRequest) data: " + payloadString);
            }
            RPCRequest rpcRequest = new RPCRequest(payload, this.context);
            rpcRequest.rpc = this;
            this.addRequest(rpcRequest);
        }
        String localeName = this.context.request.getParameter("locale");
        if (localeName != null) {
            Locale locale = DataTools.deriveLocaleFromName(localeName);
            if (locale == null) {
                log.warn("Locale " + localeName + " was explicitly specified on the " + "HttpServletRequest, but it is not a valid locale name.  Ignoring.");
            } else if (this.context != null) {
                this.context.setLocale(locale);
            }
        }
    }

    public void addRequest(DSRequest req) {
        if (this.requests == null) {
            this.requests = new ArrayList();
        }
        this.requests.add(req);
    }

    private String generateIFrameCallback(String jsCallback, Long transactionNum) {
        if (IFRAME_NEW_WINDOW.equals(jsCallback)) {
            return "window.opener.parent.isc.Comm.hiddenFrameReply(" + transactionNum + ",results,window)";
        }
        return "if (!(new RegExp(\"^(\\\\d{1,3}\\\\.){3}\\\\d{1,3}$\").test(document.domain))) {while (!window.isc && document.domain.indexOf(\".\") != -1 ) { try { parent.isc; break;} catch (e) {document.domain = document.domain.replace(/.*?\\./, \"\");}}}parent.isc.Comm.hiddenFrameReply(" + transactionNum + ",results)";
    }

    public void addRequest(RPCRequest req) {
        if (this.requests == null) {
            this.requests = new ArrayList();
        }
        this.requests.add(req);
    }

    public Long getTransactionNum() {
        return this.transactionNum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        RequestTimer requestTimer = new RequestTimer(request);
        RPCManager rpc = null;
        try {
            RequestContext context = RequestContext.instance((ServletRequest)request, (ServletResponse)response);
            try {
                rpc = new RPCManager(null, request, response);
            }
            catch (ClientMustResubmitException cmre) {
                requestTimer.stop();
                try {
                    response.flushBuffer();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return;
            }
            rpc.processRPCTransaction();
        }
        catch (Throwable e) {
            Logger.observeThread();
            log.error((Object)"Error processing RPC Request: ", Reflection.getRealTargetException(e));
            ServletTools.handleServletError(response, " top-level exception", e);
        }
        finally {
            requestTimer.stop();
            try {
                response.flushBuffer();
            }
            catch (IOException iOException) {}
        }
    }

    public void processRPCTransaction() throws Exception {
        log.info("Performing " + this.requestCount() + " operation(s)");
        for (Object r : this.getRequests()) {
            if (r instanceof RPCRequest) {
                RPCRequest rpcRequest = (RPCRequest)r;
                this.send(rpcRequest, rpcRequest.execute());
                continue;
            }
            DSRequest dsRequest = (DSRequest)r;
            try {
                this.send(dsRequest, dsRequest.execute());
            }
            catch (Exception e) {
                Logger.observeThread();
                try {
                    log.error((Object)("Error executing operation: " + dsRequest.getOperation()), e);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.sendFailure((Object)dsRequest, e);
            }
        }
    }

    public DataSource getDataSource(String dsName) throws Exception {
        return this.getDataSource(dsName, null);
    }

    public DataSource getDataSource(String dsName, DSRequest dsRequest) throws Exception {
        DataSource ds = DataSourceManager.getDataSource(dsName, dsRequest);
        if (ds != null) {
            this.dataSourcesToFree.add(ds);
        }
        return ds;
    }

    public void freeDataSources() throws Exception {
        Iterator i = this.dataSourcesToFree.iterator();
        while (i.hasNext()) {
            DataSourceManager.free((DataSource)i.next());
        }
    }

    public void applyEarlierResponseValues(DSRequest dsReq) throws Exception {
        String value;
        String fieldName;
        String opId;
        DataSource ds;
        this.requestProcessingStarted = true;
        Date currentDate = new Date();
        this.addToTemplateContext("currentDate", currentDate);
        if (this.getFromTemplateContext("transactionDate") == null) {
            this.addToTemplateContext("transactionDate", currentDate);
        }
        if ((ds = dsReq.getDataSource()) == null) {
            return;
        }
        String opType = dsReq.getOperationType();
        Map opBinding = ds.getOperationBinding(opType, opId = dsReq.getOperationId());
        if (opBinding == null) {
            return;
        }
        Object criteriaObj = opBinding.get("criteria");
        Object valuesObj = opBinding.get("values");
        if (criteriaObj == null && valuesObj == null) {
            return;
        }
        Map params = Velocity.getStandardContextMap(dsReq);
        if (criteriaObj != null) {
            ArrayList criteria;
            if (criteriaObj instanceof List) {
                criteria = (ArrayList)criteriaObj;
            } else {
                criteria = new ArrayList();
                criteria.add(criteriaObj);
            }
            for (Map map : criteria) {
                fieldName = (String)map.get("fieldName");
                value = (String)map.get("value");
                String operator = (String)map.get("operator");
                String start = (String)map.get("start");
                String end = (String)map.get("end");
                if (fieldName == null) continue;
                Object evalValue = null;
                Object evalEnd = null;
                Object evalStart = null;
                if (!"isNull".equals(operator) && !"notNull".equals(operator)) {
                    if (value == null && start == null && end == null) {
                        log.warn("DataSource " + ds.getID() + ", operation " + opId + ": Found a <criteria> definition for field '" + fieldName + "', operator '" + operator + "' " + "that does not specify value, start or end - skipping");
                        continue;
                    }
                    if (value != null) {
                        evalValue = Velocity.evaluate(value, params);
                    }
                    if (start != null) {
                        evalStart = Velocity.evaluate(start, params);
                    }
                    if (end != null) {
                        evalEnd = Velocity.evaluate(end, params);
                    }
                }
                dsReq.addToCriteria(fieldName, operator, evalValue, evalStart, evalEnd);
            }
        }
        if (valuesObj != null) {
            ArrayList values;
            if (valuesObj instanceof List) {
                values = (ArrayList)valuesObj;
            } else {
                values = new ArrayList();
                values.add(valuesObj);
            }
            for (Map map : values) {
                fieldName = (String)map.get("fieldName");
                value = (String)map.get("value");
                if (fieldName == null || value == null) continue;
                Object evaluation = Velocity.evaluate(value, params);
                dsReq.getValues().put(fieldName, evaluation);
            }
        }
    }

    public DSResponse findResponse(String firstOrLast, String dsName, String opType) {
        DSRequest dsReq;
        int stop;
        int inc;
        int loop;
        DSRequest thisDSReq = null;
        for (Object obj : this.requests) {
            if (!(obj instanceof DSRequest) || this.responseMap.get(obj) != null) continue;
            thisDSReq = (DSRequest)obj;
            break;
        }
        if (thisDSReq == this.requests.get(0)) {
            log.debug("Transaction chaining invoked on first request, ignoring");
            return null;
        }
        if (firstOrLast.equals("first")) {
            loop = 0;
            inc = 1;
            stop = this.requests.size();
        } else {
            inc = -1;
            stop = -1;
            for (loop = this.requests.size() - 1; loop != stop; --loop) {
                dsReq = (DSRequest)this.requests.get(loop);
                if (dsReq != thisDSReq) continue;
                --loop;
                break;
            }
        }
        while (loop != stop) {
            if (this.requests.get(loop) instanceof DSRequest) {
                dsReq = (DSRequest)this.requests.get(loop);
                if ((dsName == null || dsName.equals(dsReq.getDataSourceName())) && (opType == null || opType.equals(dsReq.getOperationType()))) {
                    DSResponse dsResp = (DSResponse)this.responseMap.get(dsReq);
                    if (dsResp == null) {
                        log.warn("Found null DSResponse mapped to valid-looking DSRequest when searching for " + firstOrLast + " operation on DataSource " + dsName + " with operation type " + opType + ". Maybe requests " + "have been run out of order?");
                        return null;
                    }
                    return dsResp;
                }
            }
            loop += inc;
        }
        log.warn("Could not find a suitable dsRequest searching for " + firstOrLast + " operation on DataSource " + dsName + " with operation type " + opType);
        return null;
    }

    public Object findResponseData(String firstOrLast, String dsName, String opType) {
        Object data = null;
        DSResponse dsResponse = this.findResponse(firstOrLast, dsName, opType);
        if (dsResponse != null) {
            data = dsResponse.getData();
        }
        if (data == null) {
            log.warn("Found null dsResponse.data when searching for " + firstOrLast + " operation on DataSource " + dsName + " with operation type " + opType + ". Looks like the " + "operation does not return anything.");
            return null;
        }
        if (data instanceof List) {
            data = ((List)data).get(0);
        }
        return data;
    }

    public void setUserId(String userId) {
        this.userId = userId;
        this.setAuthenticated(true);
    }

    public String getUserId() {
        if (this.userId != null) {
            return this.userId;
        }
        if (this.context.request != null) {
            return this.context.request.getRemoteUser();
        }
        return null;
    }

    public Boolean getAuthenticated() {
        return this.authenticated;
    }

    public void setAuthenticated(boolean authenticated) {
        this.authenticated = new Boolean(authenticated);
    }

    public void setAuthenticated(Boolean newValue) {
        this.authenticated = newValue;
    }

    public List getUserRoles() {
        return this.userRoles;
    }

    public void setUserRoles(String rolesString) {
        this.userRoles = new ArrayList();
        String[] roles = rolesString.split(",");
        for (int i = 0; i < roles.length; ++i) {
            this.userRoles.add(roles[i].trim());
        }
    }

    public void setUserRoles(List rolesList) {
        this.userRoles = rolesList;
    }

    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    public void setAttribute(String key, Object value) {
        this.attributes.put(key, value);
    }

    public void removeAttribute(String key) {
        this.attributes.remove(key);
    }

    public void registerCallback(RPCManagerCompletionCallback callback) {
        if (!this.callbacks.contains(callback)) {
            this.callbacks.add(callback);
        }
    }

    public int getTransactionPolicy() {
        return this.transactionPolicy;
    }

    public void setTransactionPolicy(int tp) throws QueueAlreadyStartedException {
        if (this.requestProcessingStarted) {
            throw new QueueAlreadyStartedException("Queue processing has started; transaction policy cannot be changed");
        }
        this.transactionPolicy = tp;
    }

    public boolean requestQueueIncludesPriorUpdate(DSRequest req) {
        return this._requestQueueIncludesPriorUpdate(req);
    }

    public boolean requestQueueIncludesUpdates() {
        return this._requestQueueIncludesPriorUpdate(null);
    }

    private boolean _requestQueueIncludesPriorUpdate(DSRequest req) {
        try {
            if (req.getDataSource().isModificationRequest(req)) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (Object requestObj : this.requests) {
            if (requestObj.equals(req)) {
                return false;
            }
            if (!(requestObj instanceof DSRequest)) continue;
            DSRequest request = (DSRequest)requestObj;
            try {
                if (!request.getDataSource().isModificationRequest(request)) continue;
                return true;
            }
            catch (Exception exception) {
            }
        }
        return false;
    }

    public Connection startSQLTransaction(DSRequest dsReq) throws Exception {
        if (dsReq != null) {
            DataSource ds = dsReq.getDataSource();
            if (ds instanceof ISQLDataSource) {
                dsReq.registerFreeResourcesHandler(ds);
                return ((ISQLDataSource)((Object)ds)).getTransactionalConnection(dsReq);
            }
            log.warn("RPCManager.startSQLTransaction is only applicable to SQL DataSources but was called was called for a DSRequest on a non-SQL DataSource ('" + ds.getName() + "', which is of type " + ds.getClass().getCanonicalName() + ")");
        }
        return null;
    }

    public void dumpResponseMap() {
        log.debug(this.responseMap);
    }

    public void addAssociatedRequest(DSRequest request) {
        this.associatedRequests.add(request);
    }

    public Map<String, DataSource> getCachedDataSourceInstances() {
        return this.cachedDataSources;
    }
}

