/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.sql;

import com.isomorphic.base.Base;
import com.isomorphic.datasource.DSField;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.IncludeFromDefinition;
import com.isomorphic.log.Logger;
import com.isomorphic.sql.SQLDataSource;
import com.isomorphic.sql.SQLDriver;
import com.isomorphic.sql.SQLJoinWhereClause;
import com.isomorphic.sql.SQLTableClause;
import com.isomorphic.util.DataTools;
import com.isomorphic.velocity.Velocity;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SQLSelectClause
extends Base {
    private static Logger log = new Logger(SQLSelectClause.class.getName());
    private List dataSources;
    private Map remapTable;
    private Map column2TableMap = new HashMap();
    private boolean qualifyColumnNames = true;
    private List customValueFields = null;
    private DSRequest request;
    private String groupByString = null;
    private boolean ignoreOutputs = false;

    public SQLSelectClause(List dataSources) {
        this.dataSources = dataSources;
        this.remapTable = DataTools.getSortedMap((Map)SQLDataSource.getField2ColumnMap(dataSources));
        if (dataSources.size() > 1) {
            this.column2TableMap = SQLDataSource.getColumn2TableMap(dataSources);
        }
    }

    public SQLSelectClause(SQLDataSource ds) {
        this(DataTools.makeList((Object)((Object)ds)));
    }

    public SQLSelectClause(DSRequest request, SQLDataSource ds, boolean qualifyColumnNames) {
        this(request, DataTools.makeList((Object)((Object)ds)), qualifyColumnNames);
    }

    public SQLSelectClause(DSRequest request, List dataSources, boolean qualifyColumnNames) {
        this(dataSources);
        this.request = request;
        List groupByColumns = request.getGroupByFields();
        if (groupByColumns != null && !groupByColumns.isEmpty()) {
            this.remapTable = DataTools.subsetMap((Map)this.remapTable, (List)groupByColumns, (boolean)true);
        } else {
            DataSource ds = (DataSource)dataSources.get(0);
            List outputColumns = ds.computeOutputColumns(request);
            boolean bl = this.ignoreOutputs = outputColumns == null;
            if (outputColumns != null) {
                this.remapTable = DataTools.subsetMap((Map)this.remapTable, (List)outputColumns, (boolean)true);
            }
        }
        this.qualifyColumnNames = qualifyColumnNames;
    }

    public SQLSelectClause(DSRequest request, List outputColumns, List dataSources, boolean qualifyColumnNames) {
        this(dataSources);
        List groupByColumns = request.getGroupByFields();
        if (groupByColumns != null && !groupByColumns.isEmpty()) {
            this.remapTable = DataTools.subsetMap((Map)this.remapTable, (List)groupByColumns, (boolean)true);
        } else if (outputColumns != null) {
            this.remapTable = DataTools.subsetMap((Map)this.remapTable, (List)outputColumns, (boolean)true);
        }
        this.qualifyColumnNames = qualifyColumnNames;
    }

    public SQLSelectClause(DSRequest request, List outputColumns, SQLDataSource ds, boolean qualifyColumnNames) {
        this(request, outputColumns, DataTools.makeList((Object)((Object)ds)), qualifyColumnNames);
    }

    public List getCustomValueFields() {
        return this.customValueFields;
    }

    public void setCustomValueFields(List fields) {
        this.customValueFields = fields;
    }

    public String toString(SQLDriver driver) throws Exception {
        return this.getSQLString(driver);
    }

    public String getSQLString() throws Exception {
        return this.getSQLString(((SQLDataSource)((Object)this.dataSources.get(0))).getDriver());
    }

    public String getSQLString(SQLDriver driver) throws Exception {
        if (this.remapTable == null || this.remapTable.size() == 0) {
            log.warning((Object)"SQLSelectClause is null or zero size, remap and conversions won't work!");
            return "*";
        }
        String opType = this.request.getOperationType();
        String opId = this.request.getOperationId();
        DataSource ds = (DataSource)this.dataSources.get(0);
        Map opBinding = ds.getOperationBinding(opType, opId);
        boolean vanillaFetch = false;
        if (opBinding != null && !this.request.isGroupBy()) {
            if (opBinding.get("customSQL") == null && opBinding.get("selectClause") == null && opBinding.get("tableClause") == null && opBinding.get("whereClause") == null && opBinding.get("groupClause") == null && opBinding.get("orderClause") == null && opBinding.get("valueClause") == null) {
                vanillaFetch = true;
            }
        } else {
            vanillaFetch = true;
        }
        StringBuffer result = new StringBuffer();
        StringBuffer groupByResult = new StringBuffer();
        for (String rsName : this.remapTable.keySet()) {
            DataSource firstDS;
            String tableName;
            if (!this.request.isGroupBy() && (!this.ignoreOutputs && this.request.getConsolidatedOutputs() != null && !this.request.getConsolidatedOutputs().contains(rsName) || this.request.getDroppedFields() != null && this.request.getDroppedFields().contains(rsName))) continue;
            String columnName = (String)this.remapTable.get(rsName);
            if (columnName != null && columnName.contains(".")) {
                columnName = columnName.substring(columnName.lastIndexOf(".") + 1);
            }
            String string = tableName = this.qualifyColumnNames ? (String)this.column2TableMap.get(columnName) : null;
            if (tableName == null && this.qualifyColumnNames && (firstDS = (DataSource)this.dataSources.get(0)) instanceof SQLDataSource) {
                tableName = ((SQLDataSource)firstDS).getTable().getName();
            }
            boolean skipCustomSQLCheck = false;
            if (this.customValueFields != null) {
                Iterator i = this.customValueFields.iterator();
                while (i.hasNext()) {
                    if (!i.next().equals(rsName)) continue;
                    skipCustomSQLCheck = true;
                    break;
                }
            }
            boolean exclude = false;
            DSField field = null;
            for (int i = 0; i < this.dataSources.size(); ++i) {
                ds = (DataSource)this.dataSources.get(i);
                field = ds.getField(rsName);
                if (field == null) continue;
                if (field.getIncludeFrom(this.request) != null) {
                    exclude = true;
                    break;
                }
                if (!skipCustomSQLCheck && field.getBoolean("customSQL")) {
                    exclude = true;
                    break;
                }
                if (field.get((Object)"tableName") != null && vanillaFetch) {
                    exclude = true;
                    break;
                }
                if (field.isInapplicable()) {
                    exclude = true;
                    break;
                }
                if (!this.qualifyColumnNames || field.get((Object)"tableName") == null) break;
                tableName = field.get((Object)"tableName").toString();
                break;
            }
            if (exclude) continue;
            String functionName = null;
            Map fieldFunctionMap = this.request.getFieldFunctions();
            if (fieldFunctionMap != null && fieldFunctionMap.containsKey(rsName)) {
                functionName = (String)fieldFunctionMap.get(rsName);
            }
            if (result.length() != 0) {
                result.append(", ");
            }
            if (field != null && "relatedCount".equals(field.getProperty("type"))) {
                result.append(this.aggregationSubSelect(driver, columnName, rsName, tableName, field));
                continue;
            }
            if (field != null && (field.getProperty("customSelectExpression") != null || field.getProperty("customSQLExpression") != null)) {
                result.append(this.customSQLExpression(field));
                continue;
            }
            result.append(driver.sqlOutTransform(columnName, rsName, tableName, functionName, (Map)field));
            List groupByList = this.request.getGroupBy();
            if (groupByList == null || !groupByList.contains(rsName)) continue;
            if (groupByResult.length() != 0) {
                groupByResult.append(", ");
            }
            groupByResult.append(driver.sqlOutTransform(columnName, null, tableName, null));
        }
        this.addSQLForJoinedFields(driver, result, groupByResult);
        if (groupByResult != null && groupByResult.length() > 0) {
            this.groupByString = groupByResult.toString();
        }
        return result.toString();
    }

    private void addSQLForJoinedFields(SQLDriver driver, StringBuffer sbSelect, StringBuffer sbGroupBy) throws Exception {
        if (this.request.getIncludeFrom() == null || this.request.getIncludeFrom().size() == 0) {
            return;
        }
        for (IncludeFromDefinition incFrom : this.request.getIncludeFrom()) {
            List groupByList;
            if (incFrom.isInError() || incFrom.isCriteria() && !this.request.selectCriteriaFields() || incFrom.isSortBy() && !this.request.selectSortByFields()) continue;
            String thisFieldName = incFrom.getThisFieldName();
            IncludeFromDefinition target = incFrom.getTargetIncludeFrom();
            while (target != null && incFrom.getDataSource() instanceof SQLDataSource) {
                incFrom = target;
                target = incFrom.getTargetIncludeFrom();
            }
            if (!(incFrom.getDataSource() instanceof SQLDataSource)) continue;
            DSField thisField = incFrom.getThisField();
            if (!this.request.isGroupBy() && thisField != null && thisField.getProperty("groupFunction") != null) {
                this.addSubSelectForIncludeGroupField(incFrom, driver, sbSelect);
                continue;
            }
            String fieldName = incFrom.getIncludedFieldName();
            String columnName = incFrom.getIncludedField().getNativeName();
            if (columnName == null) {
                columnName = fieldName;
            }
            SQLDataSource relatedDS = (SQLDataSource)incFrom.getDataSource();
            String tableName = relatedDS.getTable().getName();
            if (this.request.isGroupBy() && !this.request.getGroupByFields().contains(thisFieldName)) continue;
            String functionName = null;
            Map fieldFunctionsMap = this.request.getFieldFunctions();
            if (fieldFunctionsMap != null && fieldFunctionsMap.containsKey(thisFieldName)) {
                functionName = (String)fieldFunctionsMap.get(thisFieldName);
            }
            if (sbSelect.length() > 0) {
                sbSelect.append(", ");
            }
            if (thisField != null && (thisField.getProperty("customSelectExpression") != null || thisField.getProperty("customSQLExpression") != null)) {
                sbSelect.append(this.customSQLExpression(thisField));
            } else {
                sbSelect.append(relatedDS.driver.sqlOutTransform(columnName, thisFieldName, tableName, functionName, (Map)incFrom.getThisField()));
            }
            if ((groupByList = this.request.getGroupBy()) == null || !groupByList.contains(thisFieldName)) continue;
            if (sbGroupBy.length() != 0) {
                sbGroupBy.append(", ");
            }
            sbGroupBy.append(driver.sqlOutTransform(columnName, null, tableName, null));
        }
    }

    private void addSubSelectForIncludeGroupField(IncludeFromDefinition incFrom, SQLDriver driver, StringBuffer sbSelect) throws Exception {
        DSField thisField = incFrom.getThisField();
        String thisFieldName = thisField.getName();
        String fieldName = incFrom.getIncludedFieldName();
        String columnName = incFrom.getIncludedField().getNativeName();
        if (columnName == null) {
            columnName = fieldName;
        }
        SQLDataSource relatedDS = (SQLDataSource)incFrom.getDataSource();
        SQLDataSource thisDS = (SQLDataSource)incFrom.getThisDataSource();
        String tableName = relatedDS.getTable().getName();
        String groupFunction = thisField.getProperty("groupFunction");
        if ("FIRST".equals(groupFunction.toUpperCase())) {
            groupFunction = "MIN";
        }
        if (!thisDS.supportsGroupFunction(groupFunction)) {
            log.warn((Object)("Function name: '" + groupFunction + "' specified in groupFunction attribute for field '" + thisDS.getName() + "." + thisFieldName + "' is not supported by this type of data source. Skipping."));
            return;
        }
        StringBuffer subSelect = new StringBuffer();
        subSelect.append("SELECT ");
        subSelect.append(relatedDS.driver.sqlOutTransform(columnName, thisFieldName, tableName, groupFunction, (Map)incFrom.getThisField()));
        SQLTableClause tableClause = new SQLTableClause(this.request, Arrays.asList(incFrom.getDataSources()));
        tableClause.setIsSubSelect(true);
        subSelect.append(" FROM ");
        subSelect.append(tableClause.getSQLString());
        SQLJoinWhereClause whereClause = new SQLJoinWhereClause(this.request, this.dataSources, this.qualifyColumnNames);
        whereClause.setIsSubSelect(true);
        subSelect.append(" WHERE " + whereClause.getSQLString());
        if (sbSelect.length() > 0) {
            sbSelect.append(", ");
        }
        sbSelect.append("(" + subSelect.toString() + ")");
        sbSelect.append(" AS " + driver.escapeColumnName(thisFieldName));
    }

    public String getGroupByString() {
        return this.groupByString;
    }

    public boolean isGroupBy() {
        return this.groupByString != null;
    }

    public boolean isJoin() {
        return this.dataSources.size() > 1;
    }

    protected String aggregationSubSelect(SQLDriver driver, String columnName, String rsName, String tableName, DSField field) throws Exception {
        String relatedTable = field.getProperty("relatedTable");
        String relatedColumn = field.getProperty("relatedColumn");
        String localField = field.getProperty("localField");
        String subselect = " (SELECT ";
        subselect = subselect + "COUNT";
        subselect = subselect + "(";
        subselect = subselect + "*";
        subselect = subselect + ") FROM ";
        subselect = subselect + field.getProperty("relatedTable");
        subselect = subselect + " WHERE ";
        subselect = subselect + driver.sqlOutTransform(localField, localField, tableName);
        subselect = subselect + " = ";
        subselect = subselect + driver.sqlOutTransform(relatedColumn, relatedColumn, relatedTable);
        subselect = subselect + ") AS ";
        subselect = subselect + field.getName();
        return subselect;
    }

    protected String customSQLExpression(DSField field) throws Exception {
        String expression = field.getProperty("customSelectExpression");
        if (expression == null) {
            expression = field.getProperty("customSQLExpression");
        }
        Map context = Velocity.getStandardContextMap((DSRequest)this.request);
        expression = Velocity.evaluateAsString((String)expression, (Map)context, (String)"customSelectExpression", (DataSource)this.request.getDataSource(), (boolean)field.getBoolean("autoQuoteCustomExpressions", true));
        expression = expression + " AS ";
        expression = expression + field.getName();
        return expression;
    }
}

