/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.datasource;

import com.isomorphic.datasource.BasicDataSource;
import com.isomorphic.util.DataTools;
import com.isomorphic.util.ErrorMessage;
import com.isomorphic.util.IDoNotAdapt;
import com.isomorphic.velocity.Velocity;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Validator
extends HashMap
implements IDoNotAdapt {
    private Map errorVariables = new HashMap();

    public Validator() {
    }

    public Validator(Map fieldData) {
        this(fieldData, null);
    }

    public Validator(Map fieldData, BasicDataSource ds) {
        DataTools.mapMerge(fieldData, this);
    }

    public boolean getBoolean(String key) {
        return DataTools.getBoolean(this, key);
    }

    public String getProperty(String property) {
        if (this.get(property) == null) {
            return null;
        }
        return this.get(property).toString();
    }

    public Object getObjectProperty(String property) {
        if (this.get(property) == null) {
            return null;
        }
        return this.get(property);
    }

    public List getListProperty(String property) {
        if (this.get(property) == null) {
            return null;
        }
        return (List)this.get(property);
    }

    public Map getMapProperty(String property) {
        if (this.get(property) == null) {
            return null;
        }
        return (Map)this.get(property);
    }

    public boolean isClientOnly() {
        return this.getBoolean("clientOnly");
    }

    public boolean isServerOnly() {
        return this.getBoolean("serverOnly");
    }

    public boolean isStopIfFalse() {
        return this.getBoolean("stopIfFalse");
    }

    public String getErrorMessage() {
        return this.getProperty("errorMessage");
    }

    public String getServerCondition() {
        Object obj = this.getObjectProperty("serverCondition");
        if (obj == null) {
            return null;
        }
        if (obj instanceof Map) {
            return (String)((Map)obj).get("#text");
        }
        return obj.toString();
    }

    public Object getScriptImports() {
        return this.getObjectProperty("scriptImport");
    }

    public String getLanguage() {
        Object obj = this.getObjectProperty("serverCondition");
        if (obj != null && obj instanceof Map) {
            return (String)((Map)obj).get("language");
        }
        return null;
    }

    public String getType() {
        String type = this.getProperty("type");
        if (type == null) {
            type = this.getProperty("_constructor");
        }
        return type;
    }

    public void addErrorMessageVariable(String name, String value) {
        this.errorVariables.put(name, value);
    }

    public Map getErrorMessageVariables() {
        return this.errorVariables;
    }

    public ErrorMessage evaluateErrorMessage(ErrorMessage error) throws Exception {
        String evaluated = Velocity.evaluateAsString(error.getErrorString(), this.errorVariables, "evaluating error message", null, false);
        error.setErrorString(evaluated);
        return error;
    }
}

