/*
 * Isomorphic SmartGWT web presentation layer
 * Copyright 2000 and beyond Isomorphic Software, Inc.
 *
 * OWNERSHIP NOTICE
 * Isomorphic Software owns and reserves all rights not expressly granted in this source code,
 * including all intellectual property rights to the structure, sequence, and format of this code
 * and to all designs, interfaces, algorithms, schema, protocols, and inventions expressed herein.
 *
 *  If you have any questions, please email <sourcecode@isomorphic.com>.
 *
 *  This entire comment must accompany any portion of Isomorphic Software source code that is
 *  copied or moved from this file.
 */
package com.smartgwt.sample.showcase.client.componentXML;

import com.smartgwt.client.rpc.LoadScreenCallback;
import com.smartgwt.client.rpc.RPCManager;
import com.smartgwt.client.rpc.RPCResponse;
import com.smartgwt.client.util.SC;
import com.smartgwt.client.widgets.Button;
import com.smartgwt.client.widgets.Canvas;
import com.smartgwt.client.widgets.events.ClickEvent;
import com.smartgwt.client.widgets.events.ClickHandler;
import com.smartgwt.client.widgets.form.DynamicForm;
import com.smartgwt.sample.showcase.client.PanelFactory;
import com.smartgwt.sample.showcase.client.ShowcasePanel;
import com.smartgwt.sample.showcase.client.SourceEntity;

import java.util.Map;

public class AddingHandlers extends ShowcasePanel {

    private static final String DESCRIPTION =
        "The form and button below have been loaded from Component XML, then, a " +
        "ClickHandler has been added via Java code which performs some specialized " +
        "validation before saving." +
        "<P> Click the \"Save\" button to see a warning message generated by the " +
        "ClickHandler, then check the \"In Stock\" button and hit \"Save\" again to allow " +
        "saving to proceed." +
        "<P> With this development approach, the form and button can be reorganized " +
        "arbitrarily by editing of XML, possibly in a visual tool such as Visual Builder, " +
        "or in any tool of your own design that can produce Component XML. So long as the " +
        "relevant controls and fields are not renamed, the Java code will work unchanged " +
        "with the new layout.";

    public static class Factory implements PanelFactory {

        private String id;

        public ShowcasePanel create() {
            AddingHandlers panel = new AddingHandlers();
            id = panel.getID();
            return panel;
        }

        public String getID() {
            return id;
        }

        public String getDescription() {
            return DESCRIPTION;
        }
    }

    @Override
    protected boolean isTopIntro() {
        return true;
    }

    public Canvas getViewPanel() {
        final Canvas layout = new Canvas();
        RPCManager.loadScreen("addingHandlers", new LoadScreenCallback() {
            @Override
            public void execute() {
                Button saveButton = (Button) this.getScreen().getByLocalId("saveButton");
                final DynamicForm saveForm = (DynamicForm) this.getScreen().getByLocalId("saveForm");
                saveButton.addClickHandler(new ClickHandler() {
                    @Override
                    public void onClick(ClickEvent event) {
                        if (Boolean.FALSE.equals((Boolean)saveForm.getValue("inStock")) &&
                            saveForm.getValue("nextShipment") == null) {
                            SC.warn("New stock items which are not already stocked must have a Stock Date");
                        }
                    }
                });
                layout.addChild(this.getScreen());
            }
        });
        return layout;
    }

    @Override
    public String getIntro() {
        return DESCRIPTION;
    }

    @Override
    public SourceEntity[] getSourceUrls() {
        return new SourceEntity[]{
            new SourceEntity("addingHandlers.ui.xml", JAVA, "source/addingHandlers.ui.xml.html", true),
            new SourceEntity("supplyItem.ds.xml", JAVA, "source/supplyItem.ds.xml.html", true)
        };
    }
}
