
/*

  SmartClient Ajax RIA system
  Version v9.0p_2021-05-01/LGPL Deployment (2021-05-01)

  Copyright 2000 and beyond Isomorphic Software, Inc. All rights reserved.
  "SmartClient" is a trademark of Isomorphic Software, Inc.

  LICENSE NOTICE
     INSTALLATION OR USE OF THIS SOFTWARE INDICATES YOUR ACCEPTANCE OF
     ISOMORPHIC SOFTWARE LICENSE TERMS. If you have received this file
     without an accompanying Isomorphic Software license file, please
     contact licensing@isomorphic.com for details. Unauthorized copying and
     use of this software is a violation of international copyright law.

  DEVELOPMENT ONLY - DO NOT DEPLOY
     This software is provided for evaluation, training, and development
     purposes only. It may include supplementary components that are not
     licensed for deployment. The separate DEPLOY package for this release
     contains SmartClient components that are licensed for deployment.

  PROPRIETARY & PROTECTED MATERIAL
     This software contains proprietary materials that are protected by
     contract and intellectual property law. You are expressly prohibited
     from attempting to reverse engineer this software or modify this
     software for human readability.

  CONTACT ISOMORPHIC
     For more information regarding license rights and restrictions, or to
     report possible license violations, please contact Isomorphic Software
     by email (licensing@isomorphic.com) or web (www.isomorphic.com).

*/
//> @groupDef viewFile
//<

//>	@class ViewFileItem
//
// Item for displaying the contents of "imageFile" fields in DynamicForms. 
// <P>
// Displays one of two UIs, according to the value of 
// +link{viewFileItem.showFileInline, showFileInline}.  If showFileInline is false, this Item
// displays the View and Download icons and the filename.  Otherwise, it streams the image-file 
// and displays it inline.
//
// @group upload
// @treeLocation Client Reference/Forms/Form Items
// @visibility external
//<
isc.ClassFactory.defineClass("ViewFileItem", "CanvasItem");

isc.ViewFileItem.addProperties({

    shouldSaveValue: false,
    colSpan: "*",
    height: 20,
    width: "*",
    overflow: "visible",

    //> @attr viewFileItem.showFileInline    (boolean : null : [IR])
    // Indicates whether to stream the image and display it
    // inline or to display the View and Download icons.
    // 
    // @visibility external
    //<

    canvasDefaults: {
        _constructor: "Canvas",
        height: 10, width: "100%"
    },

    isEditable : function () {
        return false;
    },
    
    init : function () {
        this.addAutoChild("canvas");
        this.Super('init', arguments);
    },

    formValuesChanged : function () {
        this.setCanvasContent(null);
    },

    setValue : function(data) {
        this.setCanvasContent(data);
        this.Super("setValue", arguments);
    },

    setCanvasContent : function (data) {

        var record = this.getFormRecord();

        
        if ((this.type == "imageFile" || this.type == "viewFile") && this.showFileInline != false) {
            this.canvas.setHeight("*");
            this.canvas.setWidth("*");
            this.canvas.setContents(this.getImageHTML() || "&nbsp;");
        } else {
            if (this.showFileInline == true) { // non-imageFile field
	            this.logWarn("setValue(): Unsupported field-type for showFileInline: " +this.type);
            }
            this.canvas.setHeight(20);
            this.canvas.setWidth("*");
            this.canvas.setContents(this.getViewDownloadHTML(data, record) || "&nbsp;");
        }
    },

    getViewDownloadHTML : function (value, record) {

        //if (isc.isA.String(value)) return value;
        if (record == null) return null;

        var form = this.form,
            ds = form.getDataSource(),
            field = ds ? ds.getField(this.name) : null,
            filenameField = (ds ? ds.getFilenameField(this.name) : null) || this.name + "_filename",
            name = record[filenameField],
            // see if the form has a value for the pk-field
            pkFields = ds ? ds.getPrimaryKeyFieldNames() : null,
            missingPkValues = (pkFields == null)
        ;

        
        if (field && !field.filenameSuppressed && (name == null || isc.isAn.emptyString(name))) {
            return this.emptyCellValue;
        }

        if (pkFields) {
            var values = form.getValues();
            for (var i = 0; i < pkFields.length; i++) {
                var pk = pkFields[i];
                if (isc.DynamicForm._getFieldValue(pk, this, values, form, true) == null) {
                    missingPkValues = true;
                    break;
                }
            }
        }

        
        if (missingPkValues) {
            // never show view/download if the record has no PK
            return this.emptyCellValue;
        }

        var viewIconHTML = isc.Canvas.imgHTML({
                src: "[SKIN]actions/view.png",
                width: 16,
                height: 16,
                extraCSSText: "cursor:" + isc.Canvas.HAND,
                extraStuff: " onclick='" + this.getID() + ".viewFile()'"
            }),
            downloadIconHTML = isc.Canvas.imgHTML({
                src: "[SKIN]actions/download.png",
                width: 16,
                height: 16,
                extraCSSText: "cursor:" + isc.Canvas.HAND,
                extraStuff: " onclick='" + this.getID() + ".downloadFile()'"
            })
        ;

        return "<nobr>" + viewIconHTML + "&nbsp;" + downloadIconHTML + 
            (name ? "&nbsp;" + name : "") + "</nobr>";
    },
    
    getFormDataSource : function () {
        // get the DS from either the parent form or it's VM
        var ds = this.form.getDataSource() || 
                (this.form.valuesManager ? this.form.valuesManager.getDataSource() : null)
        ;
        return ds;
    },
    
    getFormRecord : function () {
        // get the data from either the VM or the parent form
        var record = this.form.valuesManager ? this.form.valuesManager.getValues() : null;
        if (!record || isc.isAn.emptyObject(record)) record = this.form.getValues();
        return record;
    },

    getImageHTML : function () {
        var record = this.getFormRecord(),
            field = this.form.getField(this.name),
            urlProperty = this.name + "_imgURL",
            value;

        if (!record || isc.isAn.emptyObject(record)) return;

        var formDS = this.getFormDataSource();
        if (!record[urlProperty] && formDS != null) {
            var dimensions = isc.Canvas.getFieldImageDimensions(field, record);

            value = record[urlProperty] = 
                isc.Canvas.imgHTML(formDS.streamFile(record, field.name),
                    dimensions.width, dimensions.height);
        } else 
            value = record[urlProperty];

        return value;
    },

    viewFile : function () {
        isc.DS.get(this.getFormDataSource()).viewFile(this.getFormRecord(), this.name);
    },

    downloadFile : function () {
        isc.DS.get(this.getFormDataSource()).downloadFile(this.getFormRecord(), this.name);
    },
    
    _shouldAllowExpressions : function () {
        return false;
    }
});
