/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.autotest;

import com.isomorphic.autotest.BatchEvaluator;
import com.isomorphic.autotest.ConfiguredBase;
import com.isomorphic.autotest.InconsistentBatchRunTableException;
import com.isomorphic.autotest.ShowcaseSpecifier;
import com.isomorphic.autotest.Utils;
import com.isomorphic.criteria.AdvancedCriteria;
import com.isomorphic.criteria.Criterion;
import com.isomorphic.criteria.criterion.AndCriterion;
import com.isomorphic.criteria.criterion.NotNullCriterion;
import com.isomorphic.criteria.criterion.OrCriterion;
import com.isomorphic.criteria.criterion.SimpleCriterion;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.log.Logger;
import edu.emory.mathcs.backport.java.util.Collections;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

public class BatchRunDao
extends ConfiguredBase {
    private static Logger log = new Logger(BatchRunDao.class.getName());

    public static void add(Date batchStartTime, String user, String branch, String modifiedFiles, String log) throws Exception {
        DSRequest dsReq = new DSRequest(config.getBatchRunDS(), "add");
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("batchStartTime", batchStartTime);
        dataMap.put("user", user);
        dataMap.put("branch", branch);
        if (config.canParseLog()) {
            modifiedFiles = BatchRunDao.clipTextField("modifiedFiles", modifiedFiles);
            dataMap.put("modifiedFiles", modifiedFiles);
        }
        dataMap.put("log", BatchRunDao.clipTextField("log", log));
        dsReq.setValues(dataMap);
        dsReq.execute();
    }

    public static List<Date> getBatchTimes(String branch, AdvancedCriteria advancedCriteria) throws Exception {
        DSRequest dsReq = new DSRequest(config.getBatchRunDS(), "fetch");
        if (advancedCriteria != null) {
            dsReq.setAdvancedCriteria(advancedCriteria);
        } else if (branch != null) {
            HashMap<String, String> criteria = new HashMap<String, String>();
            criteria.put("branch", branch);
            dsReq.setCriteria(criteria);
        } else {
            NotNullCriterion criterion = new NotNullCriterion("branch");
            dsReq.setAdvancedCriteria(new AdvancedCriteria((Criterion)criterion));
        }
        dsReq.setOutputs(Arrays.asList("batchStartTime"));
        DSResponse dsResp = dsReq.execute();
        List data = dsResp.getDataList();
        ArrayList<Date> result = new ArrayList<Date>();
        for (Object dateRow : data) {
            Map row = (Map)dateRow;
            Date d = (Date)row.get("batchStartTime");
            result.add(d);
        }
        Collections.sort(result, (Comparator)Collections.reverseOrder());
        return result;
    }

    public static Date getLastBatchFromPreviousDay(String branch) throws Exception {
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 20);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        TimeZone pacificZone = TimeZone.getTimeZone("America/Los_Angeles");
        long pacificUtcOffset = pacificZone.getOffset(new Date().getTime());
        long startOfToday = calendar.getTime().getTime() - 86400000L - pacificUtcOffset;
        long startOfYesterday = startOfToday - 86400000L;
        startOfToday = (long)((double)startOfToday + config.getNightlyBuildOffset() * 3600.0 * 1000.0);
        List<Date> batches = BatchRunDao.getBatchTimes(branch, null);
        for (int i = 0; i < batches.size(); ++i) {
            long kthBatchStartTime = batches.get(i).getTime();
            if (kthBatchStartTime < startOfYesterday) {
                return null;
            }
            if (kthBatchStartTime >= startOfToday) continue;
            return batches.get(i);
        }
        return null;
    }

    public static Date getLatestPassingBatchStartTime(Date batchStartTime, String showcase, String branch, Double threshold) throws Exception {
        String camelShowcase = ShowcaseSpecifier.getShowcaseAsCamelCase(showcase, "standAlone");
        ArrayList<SimpleCriterion> stateCheck = new ArrayList<SimpleCriterion>();
        stateCheck.add(new SimpleCriterion(camelShowcase + "State", "contains", (Object)"T"));
        stateCheck.add(new SimpleCriterion(camelShowcase + "State", "contains", (Object)"R"));
        ArrayList<Object> totalCheck = new ArrayList<Object>();
        totalCheck.add(new SimpleCriterion("branch", "equals", (Object)branch));
        totalCheck.add(new OrCriterion(stateCheck));
        List<Date> batches = BatchRunDao.getBatchTimes(branch, new AdvancedCriteria((Criterion)new AndCriterion(totalCheck)));
        for (int i = 0; i < batches.size(); ++i) {
            Date kthBatchStartTime = batches.get(i);
            if (kthBatchStartTime.compareTo(batchStartTime) >= 0 || threshold != null && !(BatchEvaluator.getPassRatio(kthBatchStartTime, showcase, branch) >= threshold)) continue;
            return kthBatchStartTime;
        }
        return null;
    }

    public static Date getSuccessorBatchStartTime(Date batchStartTime, String branch) throws Exception {
        List<Date> commits = BatchRunDao.getBatchTimes(branch, null);
        if (commits == null) {
            return null;
        }
        int index = commits.indexOf(batchStartTime);
        if (index <= 0) {
            return null;
        }
        return commits.get(index - 1);
    }

    public static Date getPredecessorBatchStartTime(Date batchStartTime, String branch) throws Exception {
        List<Date> commits = BatchRunDao.getBatchTimes(branch, null);
        if (commits == null) {
            return null;
        }
        int index = commits.indexOf(batchStartTime);
        if (index < 0 || index + 1 >= commits.size()) {
            return null;
        }
        return commits.get(index + 1);
    }

    public static String getBranch(Date batchStartTime) throws Exception {
        DSRequest dsReq = new DSRequest(config.getBatchRunDS(), "fetch");
        dsReq.setCriteria("batchStartTime", (Object)batchStartTime);
        DSResponse dsResp = dsReq.execute();
        List data = dsResp.getDataList();
        if (data.size() != 1) {
            throw new InconsistentBatchRunTableException("not exactly one entry for batch " + batchStartTime);
        }
        Map row = (Map)data.get(0);
        return (String)row.get("branch");
    }

    public static String getState(Date batchStartTime, String showcase) throws Exception {
        DSRequest dsReq = new DSRequest(config.getBatchRunDS(), "fetch");
        dsReq.setCriteria("batchStartTime", (Object)batchStartTime);
        DSResponse dsResp = dsReq.execute();
        List data = dsResp.getDataList();
        if (data.size() != 1) {
            throw new InconsistentBatchRunTableException("not exactly one entry for batch " + batchStartTime);
        }
        Map row = (Map)data.get(0);
        String camelShowcase = ShowcaseSpecifier.getShowcaseAsCamelCase(showcase, "standAlone");
        return (String)row.get(camelShowcase + "State");
    }

    public static void setState(Date batchStartTime, String showcase, String newState) throws Exception {
        String camelShowcase = ShowcaseSpecifier.getShowcaseAsCamelCase(showcase, "standAlone");
        DSRequest dsReq = new DSRequest(config.getBatchRunDS(), "update");
        dsReq.setCriteria("batchStartTime", (Object)batchStartTime);
        dsReq.setFieldValue((Object)(camelShowcase + "State"), (Object)newState);
        dsReq.execute();
    }

    public static void assertState(Date batchStartTime, String showcase, String stateValue) throws Exception {
        String actualState = BatchRunDao.getState(batchStartTime, showcase);
        if (stateValue == null && actualState != null || stateValue != null && !stateValue.equals(actualState)) {
            throw new InconsistentBatchRunTableException("in batch " + batchStartTime + ", showcase " + showcase + " doesn't have state " + stateValue);
        }
    }

    protected static boolean isStateSuccess(Date batchStartTime, String showcase) throws Exception {
        return Utils.matchRegExp("/T|R/i", BatchRunDao.getState(batchStartTime, showcase));
    }

    public static String getBatchProperty(Date batchStartTime, String property) {
        try {
            DSRequest dsReq = new DSRequest(config.getBatchRunDS(), "fetch");
            dsReq.setCriteria("batchStartTime", (Object)batchStartTime);
            DSResponse dsResp = dsReq.execute();
            List data = dsResp.getDataList();
            if (data.size() != 1) {
                throw new InconsistentBatchRunTableException("not exactly one entry for batch " + batchStartTime);
            }
            Map row = (Map)data.get(0);
            return (String)row.get(property);
        }
        catch (Exception e) {
            log.error((Object)("encountered exception finding " + property + " property for batch " + batchStartTime + ":"), (Throwable)e);
            return null;
        }
    }

    public static boolean getBatchPropertyAsBoolean(Date batchStartTime, String property) {
        try {
            DSRequest dsReq = new DSRequest(config.getBatchRunDS(), "fetch");
            dsReq.setCriteria("batchStartTime", (Object)batchStartTime);
            DSResponse dsResp = dsReq.execute();
            List data = dsResp.getDataList();
            if (data.size() != 1) {
                throw new InconsistentBatchRunTableException("not exactly one entry for batch " + batchStartTime);
            }
            Map row = (Map)data.get(0);
            return row.get(property) != null;
        }
        catch (Exception e) {
            log.error((Object)("encountered exception finding " + property + " property for batch " + batchStartTime + ":"), (Throwable)e);
            return false;
        }
    }

    public static void setCurrentDateAsBatchProperty(Date batchStartTime, String property) throws Exception {
        DSRequest dsReq = new DSRequest(config.getBatchRunDS(), "update");
        dsReq.setAllowMultiUpdate(true);
        dsReq.setCriteria("batchStartTime", (Object)batchStartTime);
        dsReq.setFieldValue((Object)property, (Object)new Date());
        dsReq.execute();
    }

    public static String getAwsInstanceId(Date batchStartTime) {
        return BatchRunDao.getBatchProperty(batchStartTime, "instanceId");
    }

    public static void registerAwsInstanceId(Date batchStartTime, String instanceId) {
        String logMessage = "instance " + instanceId + " with batch " + batchStartTime;
        try {
            DSRequest dsReq = new DSRequest(config.getBatchRunDS(), "update");
            dsReq.setCriteria("batchStartTime", (Object)batchStartTime);
            dsReq.setFieldValue((Object)"instanceId", (Object)instanceId);
            dsReq.execute();
            log.info((Object)("registered " + logMessage));
        }
        catch (Exception e) {
            log.error((Object)("failed to register " + logMessage), (Throwable)e);
        }
    }

    public static boolean isBatchValidated(Date batchStartTime) {
        return BatchRunDao.getBatchPropertyAsBoolean(batchStartTime, "validated");
    }

    public static void updateBatchStatus(Date batchStartTime, String newStatus, boolean validate) {
        try {
            DSRequest dsReq = new DSRequest(config.getBatchRunDS(), "update");
            dsReq.setCriteria("batchStartTime", (Object)batchStartTime);
            String oldStatus = BatchRunDao.getBatchProperty(batchStartTime, "completionStatus");
            if (oldStatus == null) {
                dsReq.setFieldValue((Object)"completionStatus", (Object)newStatus);
            }
            if (validate) {
                dsReq.setFieldValue((Object)"validated", (Object)new Date());
            }
            dsReq.execute();
        }
        catch (Exception e) {
            log.error((Object)("unable to validate batch " + batchStartTime + ":"), (Throwable)e);
        }
    }

    public static void setBatchEndTime(Date batchStartTime) throws Exception {
        BatchRunDao.setCurrentDateAsBatchProperty(batchStartTime, "batchEndTime");
    }

    public static String clipTextField(String fieldName, String text) throws Exception {
        return Utils.clipTextField(config.getBatchRunDS(), fieldName, text);
    }

    public static boolean isBatchAnalyzed(Date batchStartTime) {
        return BatchRunDao.getBatchPropertyAsBoolean(batchStartTime, "history");
    }

    public static void setBatchAsAnalyzed(Date batchStartTime) throws Exception {
        BatchRunDao.setCurrentDateAsBatchProperty(batchStartTime, "history");
    }

    public static boolean isShowcaseDone(Date batchStartTime, String showcase) throws Exception {
        String state = BatchRunDao.getState(batchStartTime, showcase);
        if (Utils.matchRegExp("/T|R/i", state)) {
            return true;
        }
        String status = BatchRunDao.getBatchProperty(batchStartTime, "completionStatus");
        if (!(status == null || "wrathJsDocFailure".equals(status) && showcase == null)) {
            return true;
        }
        return BatchRunDao.isBatchAnalyzed(batchStartTime);
    }
}

