/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.datasource;

import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.DataSourceManager;
import com.isomorphic.datasource.ValidationContext;
import com.isomorphic.js.IContextBeanFilter;
import java.util.Collection;
import java.util.Map;

public class DataSourceBeanFilter
implements IContextBeanFilter {
    String dsName;
    DataSource ds;
    boolean dropExtraFields = false;
    Collection propsToKeep;
    boolean dropIgnoredFields = true;
    Collection propsToDrop;

    public DataSourceBeanFilter(String dataSource, boolean dropExtraFields) {
        this.dsName = dataSource;
        this.dropExtraFields = dropExtraFields;
    }

    public DataSourceBeanFilter(DataSource dataSource, boolean dropExtraFields) {
        this.ds = dataSource;
        this.dropExtraFields = dropExtraFields;
    }

    public DataSourceBeanFilter(String dataSource, boolean dropExtraFields, boolean dropIgnoredFields) {
        this.dsName = dataSource;
        this.dropExtraFields = dropExtraFields;
        this.dropIgnoredFields = dropIgnoredFields;
    }

    public DataSourceBeanFilter(DataSource dataSource, boolean dropExtraFields, boolean dropIgnoredFields) {
        this.ds = dataSource;
        this.dropExtraFields = dropExtraFields;
        this.dropIgnoredFields = dropIgnoredFields;
    }

    public DataSourceBeanFilter(String dataSource, Collection propsToKeep) {
        this.dsName = dataSource;
        this.propsToKeep = propsToKeep;
    }

    public DataSourceBeanFilter(DataSource dataSource, Collection propsToKeep) {
        this.ds = dataSource;
        this.propsToKeep = propsToKeep;
    }

    public DataSourceBeanFilter(DataSource dataSource, Collection propsToKeep, Collection propsToDrop, boolean dropExtraFields, boolean dropIgnoredFields) {
        this.ds = dataSource;
        this.propsToKeep = propsToKeep;
        this.propsToDrop = propsToDrop;
        this.dropExtraFields = dropExtraFields;
        this.dropIgnoredFields = dropIgnoredFields;
    }

    public Map filter(Object o) throws Exception {
        return this.filter(o, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map filter(Object o, ValidationContext validationContext) throws Exception {
        boolean freeDS = false;
        if (this.ds == null) {
            if (validationContext != null) {
                this.ds = validationContext.getType(this.dsName);
            } else {
                freeDS = true;
                this.ds = DataSourceManager.get(this.dsName, validationContext == null ? null : validationContext.getDSRequest());
            }
        }
        try {
            Map map = this.ds.getProperties(o, this.propsToKeep, this.dropExtraFields, this.dropIgnoredFields, validationContext, null, this.propsToDrop);
            return map;
        }
        finally {
            if (freeDS) {
                DataSourceManager.free(this.ds);
                this.ds = null;
            }
        }
    }
}

