/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.pool;

import com.isomorphic.base.Config;
import com.isomorphic.log.Logger;
import com.isomorphic.pool.ISCPoolableObjectFactory;
import com.isomorphic.util.DataTools;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;

public class ISCObjectPool
extends GenericObjectPool {
    private static Logger log = new Logger(ISCObjectPool.class.getName());
    private static Config globalConfig = Config.getGlobal();
    private ISCPoolableObjectFactory factory;
    HashMap objectsInPool = new HashMap();
    HashMap objectsBorrowed = new HashMap();

    public ISCObjectPool(ISCPoolableObjectFactory factory, Map thisConfig) {
        super((PoolableObjectFactory)factory);
        this.factory = factory;
        String whenExhaustedAction = (String)thisConfig.remove("whenExhaustedAction");
        Byte action = null;
        if (whenExhaustedAction != null) {
            if ("grow".equals(whenExhaustedAction = whenExhaustedAction.toLowerCase())) {
                action = new Byte(2);
            }
            if ("block".equals(whenExhaustedAction)) {
                action = new Byte(1);
            }
            if ("fail".equals(whenExhaustedAction)) {
                action = new Byte(0);
            }
        }
        if (action != null) {
            thisConfig.put("whenExhaustedAction", action);
        } else {
            log.error("Ignoring unknown value: " + whenExhaustedAction + " for whenExhaustedAction." + " Valid values are: grow, block, fail.");
        }
        try {
            DataTools.setProperties(thisConfig, (Object)this);
        }
        catch (Exception e) {
            log.warning((Object)"Problem setting requested config parameters on pool.", e);
        }
    }

    public ISCPoolableObjectFactory getObjectFactory() {
        return this.factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnObject(Object obj) throws Exception {
        HashMap hashMap = this.objectsInPool;
        synchronized (hashMap) {
            Exception e = (Exception)this.objectsInPool.get(obj);
            if (e != null) {
                log.error((Object)("return of object already in pool - stack trace of previous return: " + DataTools.getStackTrace(e) + " stack trace of this call: "), new Exception());
                Exception ee = (Exception)this.objectsBorrowed.get(obj);
                log.error((Object)"object was originally borrowed here: ", ee);
            } else {
                this.objectsInPool.put(obj, new Exception());
            }
            super.returnObject(obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object borrowObject() throws Exception {
        HashMap hashMap = this.objectsInPool;
        synchronized (hashMap) {
            Object obj = super.borrowObject();
            this.objectsInPool.remove(obj);
            this.objectsBorrowed.put(obj, new Exception());
            return obj;
        }
    }
}

