/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.web.servlet;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.openqa.grid.common.exception.GridException;
import org.openqa.grid.internal.Registry;
import org.openqa.grid.web.servlet.RegistryBasedServlet;

public class HubStatusServlet
extends RegistryBasedServlet {
    public HubStatusServlet() {
        super(null);
    }

    public HubStatusServlet(Registry registry) {
        super(registry);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.process(request, response);
    }

    protected void process(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        response.setStatus(200);
        try {
            JSONObject res = this.getResponse(request);
            response.getWriter().print(res);
            response.getWriter().close();
        }
        catch (JSONException e) {
            throw new GridException(e.getMessage());
        }
    }

    private JSONObject getResponse(HttpServletRequest request) throws IOException, JSONException {
        JSONObject requestJSON = null;
        JSONObject res = new JSONObject();
        res.put("success", true);
        try {
            if (request.getInputStream() != null) {
                Set<String> paramsToReturn;
                JSONArray keys;
                String line;
                BufferedReader rd = new BufferedReader(new InputStreamReader((InputStream)request.getInputStream()));
                StringBuilder s = new StringBuilder();
                while ((line = rd.readLine()) != null) {
                    s.append(line);
                }
                rd.close();
                String json = s.toString();
                if (!"".equals(json)) {
                    requestJSON = new JSONObject(json);
                }
                JSONArray jSONArray = keys = requestJSON != null ? requestJSON.getJSONArray("configuration") : null;
                if (requestJSON == null || keys.length() == 0) {
                    paramsToReturn = this.getRegistry().getConfiguration().getAllParams().keySet();
                } else {
                    paramsToReturn = new HashSet<String>();
                    int i = 0;
                    while (i < keys.length()) {
                        paramsToReturn.add(keys.getString(i));
                        ++i;
                    }
                }
                for (String key : paramsToReturn) {
                    Object value = this.getRegistry().getConfiguration().getAllParams().get(key);
                    if (value == null) {
                        res.put(key, JSONObject.NULL);
                        continue;
                    }
                    res.put(key, value);
                }
            }
        }
        catch (Exception e) {
            res.put("success", false);
            res.put("msg", (Object)e.getMessage());
        }
        return res;
    }
}

