/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server;

import com.google.common.base.Preconditions;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.server.CapabilitiesComparator;
import org.openqa.selenium.remote.server.DriverFactory;

public class DefaultDriverFactory
implements DriverFactory {
    private static final Logger log = Logger.getLogger(DefaultDriverFactory.class.getName());
    private Map<Capabilities, Class<? extends WebDriver>> capabilitiesToDriver = new ConcurrentHashMap<Capabilities, Class<? extends WebDriver>>();

    @Override
    public void registerDriver(Capabilities capabilities, Class<? extends WebDriver> implementation) {
        this.capabilitiesToDriver.put(capabilities, implementation);
    }

    protected Class<? extends WebDriver> getBestMatchFor(Capabilities desired) {
        Preconditions.checkState((!this.capabilitiesToDriver.isEmpty() ? 1 : 0) != 0, (String)"No drivers have been registered, will be unable to match %s", (Object[])new Object[]{desired});
        Capabilities bestMatchingCapabilities = CapabilitiesComparator.getBestMatch(desired, this.capabilitiesToDriver.keySet());
        return this.capabilitiesToDriver.get(bestMatchingCapabilities);
    }

    @Override
    public WebDriver newInstance(Capabilities capabilities) {
        log.info("Creating a new session for " + capabilities);
        Class<? extends WebDriver> clazz = this.getBestMatchFor(capabilities);
        return this.callConstructor(clazz, capabilities);
    }

    private WebDriver callConstructor(Class<? extends WebDriver> from, Capabilities capabilities) {
        try {
            Constructor<? extends WebDriver> constructor = from.getConstructor(Capabilities.class);
            return constructor.newInstance(capabilities);
        }
        catch (NoSuchMethodException e) {
            try {
                return from.newInstance();
            }
            catch (InstantiationException instantiationException) {
                throw new WebDriverException(e);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new WebDriverException(e);
            }
        }
        catch (InvocationTargetException e) {
            throw new WebDriverException(e);
        }
        catch (InstantiationException e) {
            throw new WebDriverException(e);
        }
        catch (IllegalAccessException e) {
            throw new WebDriverException(e);
        }
    }

    @Override
    public boolean hasMappingFor(Capabilities capabilities) {
        return this.capabilitiesToDriver.containsKey(capabilities);
    }
}

