/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.messaging;

import com.isomorphic.messaging.MessagingConnectionHandler;
import com.isomorphic.servlet.BaseServlet;
import com.isomorphic.servlet.RequestContext;
import java.io.IOException;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class MessagingServlet
extends BaseServlet {
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String contentType;
        boolean eventStream = "true".equals(request.getParameter("eventStream"));
        boolean disconnectUponConnect = "true".equals(request.getParameter("disconnectUponConnect"));
        String encoding = this.getServletConfig().getInitParameter("encoding");
        if (encoding == null) {
            encoding = "UTF-8";
        }
        String string = contentType = eventStream ? "text/event-stream" : "text/html";
        if (eventStream) {
            contentType = contentType + ";charset=UTF-8";
            response.setContentType(contentType);
        } else if (!"none".equalsIgnoreCase(encoding)) {
            request.setCharacterEncoding(encoding);
            contentType = contentType + ";charset=" + encoding;
            response.setContentType(contentType);
        } else {
            response.setContentType(contentType);
        }
        try {
            RequestContext context = RequestContext.instance((Servlet)this, (HttpServletRequest)request, (HttpServletResponse)response);
            context.setContentType(contentType);
            MessagingConnectionHandler handler = new MessagingConnectionHandler(context);
            handler.eventStream = eventStream;
            handler.disconnectUponConnect = disconnectUponConnect;
            handler.process();
        }
        catch (Exception e) {
            this.log.error((Object)"MessagingServlet top-level exception", (Throwable)e);
            response.getWriter().print("MessagingServlet top-level exception: " + e.getMessage());
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }
}

