/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.base;

import com.isomorphic.base.Base;
import com.isomorphic.log.Logger;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public class VersionSafeChecker
extends Base {
    private static final float JVM_15_VERSION = 49.0f;
    private static final float JVM_16_VERSION = 50.0f;
    private static float jvmVersion = -1.0f;
    private static Logger log = new Logger(VersionSafeChecker.class.getName());

    public static boolean is5() {
        return jvmVersion >= 49.0f;
    }

    public static boolean isEnum(Object object) {
        return VersionSafeChecker.isEnum(object.getClass());
    }

    public static boolean isEnum(Class theClass) {
        if (jvmVersion >= 49.0f) {
            return theClass.isEnum();
        }
        return false;
    }

    public static boolean isAnnotation(Object object) {
        return VersionSafeChecker.isAnnotation(object.getClass());
    }

    public static boolean isAnnotation(Class theClass) {
        if (jvmVersion >= 49.0f) {
            return theClass.isAnnotation();
        }
        return false;
    }

    public static boolean genericsRecognized() {
        if (config.getBoolean((Object)"detectJavaGenericTypes", true)) {
            return jvmVersion >= 49.0f;
        }
        return false;
    }

    public static List getGenericParameterTypes(Method method) {
        ArrayList<GenericParameterNode> list = new ArrayList<GenericParameterNode>();
        if (method == null) {
            return list;
        }
        Class<?>[] ordinaryParameterTypes = method.getParameterTypes();
        if (!VersionSafeChecker.genericsRecognized()) {
            for (int i = 0; i < ordinaryParameterTypes.length; ++i) {
                GenericParameterNode gpn = new GenericParameterNode(ordinaryParameterTypes[i]);
                list.add(gpn);
            }
        } else {
            Type[] gParams = method.getGenericParameterTypes();
            for (int i = 0; i < gParams.length; ++i) {
                GenericParameterNode gpn = gParams[i] instanceof ParameterizedType ? VersionSafeChecker.buildGenericParameterTree((ParameterizedType)gParams[i]) : new GenericParameterNode((Class)gParams[i]);
                list.add(gpn);
            }
        }
        return list;
    }

    public static GenericParameterNode getGenericReturnType(Method method) {
        if (method == null) {
            return null;
        }
        GenericParameterNode gpn = new GenericParameterNode();
        if (!VersionSafeChecker.genericsRecognized()) {
            gpn.addClass(method.getReturnType());
        } else {
            Type gRtnType = method.getGenericReturnType();
            if (gRtnType instanceof ParameterizedType) {
                gpn = VersionSafeChecker.buildGenericParameterTree((ParameterizedType)gRtnType);
            } else {
                gpn.addClass((Class)gRtnType);
            }
        }
        return gpn;
    }

    private static GenericParameterNode buildGenericParameterTree(ParameterizedType type) {
        GenericParameterNode gpn = new GenericParameterNode();
        Type[] paramTypes = type.getActualTypeArguments();
        if (paramTypes.length == 1 && paramTypes[0] instanceof Class) {
            gpn.addClass((Class)paramTypes[0]);
            return gpn;
        }
        gpn.addClass((Class)type.getRawType());
        for (int j = 0; j < paramTypes.length; ++j) {
            if (paramTypes[j] instanceof Class) {
                if (gpn.getChildNode() == null) {
                    gpn.setChildNode(new GenericParameterNode((Class)paramTypes[j]));
                    continue;
                }
                gpn.getChildNode().addClass((Class)paramTypes[j]);
                continue;
            }
            gpn.setChildNode(VersionSafeChecker.buildGenericParameterTree((ParameterizedType)paramTypes[j]));
        }
        return gpn;
    }

    static {
        String classVer = System.getProperty("java.class.version");
        try {
            jvmVersion = Float.parseFloat(classVer);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public static class GenericParameterNode {
        private List classes = new ArrayList();
        private GenericParameterNode childNode;

        public GenericParameterNode() {
            this(null);
        }

        public GenericParameterNode(Class theClass) {
            if (theClass != null) {
                this.classes.add(theClass);
            }
            this.childNode = null;
        }

        public Class getClassByIndex(int index) {
            if (index < this.classes.size()) {
                return (Class)this.classes.get(index);
            }
            return null;
        }

        public void addClass(Class theClass) {
            this.classes.add(theClass);
        }

        public GenericParameterNode getChildNode() {
            return this.childNode;
        }

        public void setChildNode(GenericParameterNode childNode) {
            this.childNode = childNode;
        }
    }
}

