/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.sql;

import com.isomorphic.datasource.DSField;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.interfaces.IHibernateDataSource;
import com.isomorphic.interfaces.InterfaceProvider;
import com.isomorphic.log.Logger;
import com.isomorphic.sql.SQLDataSource;
import com.isomorphic.sql.SQLDriver;
import com.isomorphic.sql.SQLTable;
import java.sql.Connection;
import java.util.List;
import java.util.Map;

public class HibernateDriver
extends SQLDriver {
    private static Logger log = new Logger(HibernateDriver.class.getName());
    private SQLDriver underlyingDriver;

    public HibernateDriver(String dbName, SQLTable table) throws Exception {
        super(dbName, table);
        this.init(dbName);
    }

    public HibernateDriver(String dbName) throws Exception {
        super(dbName, null);
        this.init(dbName);
    }

    public static SQLDriver instance(String dbName, SQLTable table) throws Exception {
        return new HibernateDriver(dbName, table);
    }

    public static SQLDriver instance(String dbName) throws Exception {
        return new HibernateDriver(dbName);
    }

    public void init(String dbName) throws Exception {
        String dbType = this.getHibernateDialectAsSmartClientDbType();
        if (dbType == null) {
            throw new Exception("Tried to create SQLDriver for Hibernate connection to a database with unknown dialect");
        }
        this.underlyingDriver = SQLDriver.instance("::hibernate::", dbType, this.table);
        this.underlyingDriver.quoteColumnNames = this.quoteColumnNames = config.getBoolean((Object)("sql." + dbType + ".quoteColumnNames"), false);
    }

    public Connection getConnection() {
        return this.underlyingDriver.getConnection();
    }

    public boolean supportsNativeReplace() {
        return this.underlyingDriver.supportsNativeReplace();
    }

    public Map fetchLastPrimaryKeys(Map primaryKeysPresent, List sequencesNotPresent, SQLDataSource ds, DSRequest req) throws Exception {
        return this.underlyingDriver.fetchLastPrimaryKeys(primaryKeysPresent, sequencesNotPresent, ds, req);
    }

    public String escapeValue(Object value) {
        return this.underlyingDriver.escapeValue(value);
    }

    public String escapeValueForFilter(Object value, String filterStyle) {
        return this.underlyingDriver.escapeValueForFilter(value, filterStyle);
    }

    public String escapeValueUnquoted(Object value, boolean escapeForFilter) {
        return this.underlyingDriver.escapeValueUnquoted(value, escapeForFilter);
    }

    public String formatValue(Object value) {
        return this.underlyingDriver.formatValue(value);
    }

    public String escapeClause() {
        return this.underlyingDriver.escapeClause();
    }

    public String sqlOutTransform(String columnName, String remapName, String tableName) throws Exception {
        return this.underlyingDriver.sqlOutTransform(columnName, remapName, tableName);
    }

    public String getNextSequenceValue(String columnName, SQLDataSource ds) throws Exception {
        return this.underlyingDriver.getNextSequenceValue(columnName, ds);
    }

    protected String getExpressionForSortBy(String column, Map valueMap, DSRequest request) {
        return this.underlyingDriver.getExpressionForSortBy(column, valueMap, request);
    }

    public void clearState() {
        this.underlyingDriver.clearState();
    }

    public String escapeColumnName(Object columnName, boolean forceQuoteColumnName) {
        return this.underlyingDriver.escapeColumnName(columnName, forceQuoteColumnName);
    }

    public String escapeColumnName(Object columnName) {
        return this.underlyingDriver.escapeColumnName(columnName);
    }

    public boolean execute(String sql) throws Exception {
        return this.underlyingDriver.execute(sql);
    }

    public List executeQuery(String query, List dataSources, DSRequest req) throws Exception {
        return this.underlyingDriver.executeQuery(query, dataSources, req);
    }

    public List executeQuery(String query, DSRequest req) throws Exception {
        return this.underlyingDriver.executeQuery(query, req);
    }

    public Object executeScalar(String query, DSRequest req) throws Exception {
        return this.underlyingDriver.executeScalar(query, req);
    }

    public int executeUpdate(String update, List data, DSRequest req) throws Exception {
        return this.underlyingDriver.executeUpdate(update, data, req);
    }

    public int executeUpdate(String update, DSRequest req) throws Exception {
        return this.underlyingDriver.executeUpdate(update, req);
    }

    public Map forceSingleRow(List rows) throws Exception {
        return this.underlyingDriver.forceSingleRow(rows);
    }

    public synchronized void freeConnection() {
    }

    public String getDBName() {
        return "::hibernate::";
    }

    public String getUnderlyingDBName() {
        return this.underlyingDriver.getDBName();
    }

    public String getDBType() {
        return this.underlyingDriver.getDBType();
    }

    protected String getSequenceName(String columnName, SQLDataSource dataSource) throws Exception {
        return this.underlyingDriver.getSequenceName(columnName, dataSource);
    }

    protected String getSequenceName(String columnName) throws Exception {
        return this.underlyingDriver.getSequenceName(columnName);
    }

    public SQLTable getTable() {
        return this.underlyingDriver.getTable();
    }

    public boolean hasBrokenCursorAPIs() {
        return this.underlyingDriver.hasBrokenCursorAPIs();
    }

    public String limitQuery(String query, long startRow, long totalRows, List outputColumns, DSRequest req) throws Exception {
        return this.underlyingDriver.limitQuery(query, startRow, totalRows, outputColumns, req);
    }

    public String sortBy(Object order, Map remapTable, Map valueMaps) {
        return this.underlyingDriver.sortBy(order, remapTable, valueMaps);
    }

    public String sqlInTransform(Object value, DSField field, SQLDataSource ds) {
        return this.underlyingDriver.sqlInTransform(value, field, ds);
    }

    public String sqlOutTransform(String columnName, String remapName) throws Exception {
        return this.underlyingDriver.sqlOutTransform(columnName, remapName);
    }

    public String sqlOutTransform(String columnName) throws Exception {
        return this.underlyingDriver.sqlOutTransform(columnName);
    }

    public boolean supportsSQLLimit() {
        return this.underlyingDriver.supportsSQLLimit();
    }

    public boolean useColumnLabelInMetadata() {
        return this.underlyingDriver.useColumnLabelInMetadata();
    }

    public Connection getHibernateConnection() throws Exception {
        IHibernateDataSource hbds = (IHibernateDataSource)InterfaceProvider.load((String)"IHibernateDataSource");
        return hbds.getStaticConnection();
    }

    public void freeHibernateConnection(Connection conn) throws Exception {
        IHibernateDataSource hbds = (IHibernateDataSource)InterfaceProvider.load((String)"IHibernateDataSource");
        hbds.freeStaticConnection(conn);
    }

    public String getHibernateDialectAsSmartClientDbType() throws Exception {
        IHibernateDataSource hbds = (IHibernateDataSource)InterfaceProvider.load((String)"IHibernateDataSource");
        String dbType = hbds.getHibernateDialectAsSmartClientDbType();
        log.debug((Object)("Getting databbase type for ::hibernate:: - dbType is " + dbType));
        return dbType;
    }

    public String getNaturalTableName(String tableName) {
        return this.underlyingDriver.getNaturalTableName(tableName);
    }
}

