/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.sql;

import com.isomorphic.datasource.DSField;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.Relation;
import com.isomorphic.log.Logger;
import com.isomorphic.sql.SQLDataSource;
import com.isomorphic.sql.SQLDriver;
import com.isomorphic.sql.SQLTable;
import com.isomorphic.util.DataTools;
import com.isomorphic.util.LocaleMessage;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class OracleDriver
extends SQLDriver {
    private static Logger log = new Logger(OracleDriver.class.getName());
    public static final int UNIQUE_CONSTRAINT_VIOLATED = 1;
    boolean driverSupportsSQLLimit = false;
    boolean databaseSupportsSQLLimit = false;
    static Map newEscapeSyntax = new HashMap();

    private static boolean useNewEscapeSyntax(String dbName) {
        if (!newEscapeSyntax.containsKey(dbName)) {
            if (config.get((Object)"sql.oracle.encloseEscapeClauseInBraces") != null) {
                newEscapeSyntax.put(dbName, !config.getBoolean((Object)"sql.oracle.encloseEscapeClauseInBraces", false));
            } else {
                newEscapeSyntax.put(dbName, Boolean.TRUE);
            }
        }
        return (Boolean)newEscapeSyntax.get(dbName);
    }

    public static SQLDriver instance(String dbName, SQLTable table) throws Exception {
        return new OracleDriver(dbName, table);
    }

    public static SQLDriver instance(String dbName) throws Exception {
        return new OracleDriver(dbName);
    }

    public OracleDriver(String dbName, SQLTable table) throws Exception {
        super(dbName, table);
        this.init(dbName);
    }

    public OracleDriver(String dbName) throws Exception {
        super(dbName, null);
        this.init(dbName);
    }

    public void init(String dbName) throws Exception {
        this.driverSupportsSQLLimit = config.getBoolean((Object)("sql." + dbName + ".driver.supportsSQLLimit"), false);
        this.databaseSupportsSQLLimit = config.getBoolean((Object)"sql.oracle.supportsSQLLimit", false);
    }

    public boolean supportsNativeReplace() {
        return false;
    }

    public boolean supportsSQLLimit() {
        return this.databaseSupportsSQLLimit || this.driverSupportsSQLLimit;
    }

    public String limitQuery(String query, long startRow, long batchSize, List outputColumns, DSRequest req) {
        DataSource ds = null;
        try {
            ds = req.getDataSource();
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean useHint = true;
        if (ds != null) {
            useHint = DataTools.getBoolean((Map)ds.getConfig(), (Object)"sqlUsePagingHint", (boolean)true);
            Map opConfig = ds.getOperationBinding(req);
            if (opConfig != null && opConfig.containsKey("sqlUsePagingHint")) {
                useHint = DataTools.getBoolean((Map)opConfig, (Object)"sqlUsePagingHint", (boolean)true);
            }
        }
        query = "SELECT * FROM (SELECT " + (useHint ? "/*+ FIRST_ROWS(" + batchSize + ") */ " : "") + "a.*, rownum myrownum FROM " + "(" + query + ") a where rownum <=" + (startRow + batchSize) + ")" + " WHERE myrownum >= " + (startRow + 1L);
        return query;
    }

    public Map fetchLastPrimaryKeys(Map primaryKeysPresent, List sequencesNotPresent, SQLDataSource ds, DSRequest req) throws Exception {
        if (this.dbConnection == null && req == null) {
            throw new Exception("no existing db connection exists for last row fetch");
        }
        Object sqlStatement = null;
        Map primaryKeys = primaryKeysPresent;
        for (String sequenceName : sequencesNotPresent) {
            String sequence = this.getCurrentSequenceValue(sequenceName, ds);
            if (sequence == null) continue;
            Object obj = OracleDriver.getScalarResult("SELECT " + sequence + " FROM DUAL", this.dbConnection, this.dbName, this, req);
            BigDecimal value = new BigDecimal(obj.toString());
            primaryKeys.put(sequenceName, value.toString());
        }
        return primaryKeys;
    }

    public String formatValue(Object value) {
        return value.toString();
    }

    public String sqlInTransform(Object value, DSField field, SQLDataSource ds) {
        if (value instanceof java.util.Date && (field == null || field.get((Object)"sqlStorageStrategy") == null)) {
            boolean convertToUTC;
            long timeStamp = ((java.util.Date)value).getTime();
            String dateTime = this.formatTimestamp(timeStamp, convertToUTC = field != null && "datetime".equals(field.getType()), ds);
            int periodIndex = dateTime.lastIndexOf(".");
            if (periodIndex != -1) {
                dateTime = dateTime.substring(0, periodIndex);
            }
            String format = config.getString((Object)"sql.defaultDateTimeFormat");
            return "TO_DATE(" + this.escapeValue(dateTime) + ",'" + format + "')";
        }
        return super.sqlInTransform(value, field, ds);
    }

    public String sqlOutTransform(String columnName, String remapName, String tableName) throws Exception {
        boolean forceRemap = false;
        String output = this.escapeColumnName(columnName);
        if (remapName != null && !columnName.equals(remapName)) {
            output = output + " AS " + this.escapeColumnName(remapName);
        }
        if (tableName != null) {
            output = tableName + "." + output;
        }
        return output;
    }

    public String sqlOutTransform(String columnName, String remapName, String tableName, String functionName, Map functionParams) throws Exception {
        String output = this.escapeColumnName(columnName);
        if (tableName != null) {
            output = tableName + "." + output;
        }
        if (functionName != null && !"".equals(functionName)) {
            if ("CONCAT".equals(functionName.toUpperCase())) {
                String prefix = "";
                String suffix = "";
                String delimiter = ", ";
                if (functionParams != null) {
                    prefix = functionParams.get("joinPrefix") == null ? prefix : (String)functionParams.get("joinPrefix");
                    suffix = functionParams.get("joinSuffix") == null ? suffix : (String)functionParams.get("joinSuffix");
                    delimiter = functionParams.get("joinString") == null ? delimiter : (String)functionParams.get("joinString");
                }
                output = "LISTAGG ('" + prefix + "' || " + output + " || '" + suffix + "', '" + delimiter + "') WITHIN GROUP (ORDER BY " + output + ")";
            } else {
                output = functionName + "(" + output + ")";
            }
            if (remapName != null) {
                output = output + " AS " + this.escapeColumnName(remapName);
            }
        } else if (remapName != null && !remapName.equals(columnName)) {
            output = output + " AS " + this.escapeColumnName(remapName);
        }
        return output;
    }

    public int getMaximumSetSize() {
        return 1000;
    }

    public String escapeValue(Object value) {
        if (value == null) {
            return null;
        }
        return "'" + this.escapeValueUnquoted(value.toString(), false) + "'";
    }

    public String escapeValueForFilter(Object value, String filterStyle) {
        if (value == null) {
            return null;
        }
        String rtn = "'";
        if (!"startsWith".equals(filterStyle)) {
            rtn = rtn + "%";
        }
        return rtn + this.escapeValueUnquoted(value, true) + "%'";
    }

    public String escapeValueUnquoted(Object value, boolean escapeForFilter) {
        if (value == null) {
            return null;
        }
        String escaped = globalPerl.substitute("s/'/''/g", value.toString());
        if (escapeForFilter) {
            escaped = globalPerl.substitute("s'\\\\'\\\\'g", escaped);
            escaped = globalPerl.substitute("s'%'\\%'g", escaped);
            escaped = globalPerl.substitute("s'_'\\_'g", escaped);
        }
        return escaped;
    }

    public String escapeClause() {
        if (OracleDriver.useNewEscapeSyntax(this.dbName)) {
            return " ESCAPE'\\' ";
        }
        return " {ESCAPE '\\'}";
    }

    public String getNextSequenceValue(String columnName, SQLDataSource dataSource) throws Exception {
        String sequenceName = this.getSequenceName(columnName, dataSource);
        if (sequenceName == null) {
            return null;
        }
        String schema = "";
        if (dataSource != null) {
            schema = (String)dataSource.getConfig().get("schema");
            schema = schema == null ? "" : schema + ".";
        }
        return schema + sequenceName + ".NextVal";
    }

    public String getCurrentSequenceValue(String columnName, SQLDataSource dataSource) throws Exception {
        String sequenceName = this.getSequenceName(columnName);
        if (sequenceName == null) {
            return null;
        }
        String schema = "";
        if (dataSource != null) {
            schema = (String)dataSource.getConfig().get("schema");
            schema = schema == null ? "" : schema + ".";
        }
        return schema + sequenceName + ".CurrVal";
    }

    protected String getExpressionForSortBy(String column, Map valueMap, DSRequest request) {
        if (valueMap == null || valueMap.size() == 0) {
            return column;
        }
        String expr = "DECODE(" + column;
        for (String actualValue : valueMap.keySet()) {
            String displayValue;
            if (valueMap.get(actualValue) instanceof LocaleMessage) {
                Locale locale = request != null ? request.context.getLocale() : Locale.getDefault();
                displayValue = ((LocaleMessage)valueMap.get(actualValue)).getMessage(locale);
            } else {
                displayValue = valueMap.get(actualValue) == null ? null : valueMap.get(actualValue).toString();
            }
            displayValue = this.escapeValue(displayValue);
            expr = expr + ", '" + actualValue + "', " + displayValue;
        }
        expr = expr + ", " + column + ")";
        return expr;
    }

    public boolean fieldIsSearchable(DSField field) {
        Long fieldLength = field.getLength();
        return super.fieldIsSearchable(field) && (fieldLength == null || fieldLength <= 4000L);
    }

    public boolean fieldAssignableInline(DSField field) {
        String fieldType = field.getType();
        Long fieldLength = field.getLength();
        return super.fieldAssignableInline(field) && (fieldLength == null || fieldLength <= 4000L);
    }

    public boolean shouldSetFetchSizeForStreaming() {
        return false;
    }

    public Object modifyTemporalObject(Object obj, ResultSet rs, int ii) throws SQLException {
        Timestamp work = rs.getTimestamp(ii);
        if (work == null) {
            return obj;
        }
        return new Date(work.getTime());
    }

    public String generateJoinClause(String escapedTo, String escapedFrom, Relation relation) {
        return escapedFrom + " = " + escapedTo + (relation.getJoinType() == 1 ? "(+)" : "");
    }

    public String getNaturalTableName(String tableName) {
        return tableName.toUpperCase();
    }
}

