/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.sql;

import com.isomorphic.base.Config;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.log.Logger;
import com.isomorphic.sql.SQLDataSource;
import com.isomorphic.sql.SQLDriver;
import com.isomorphic.sql.SQLTable;
import com.isomorphic.util.LocaleMessage;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class PostgresDriver
extends SQLDriver {
    private static Logger log = new Logger(PostgresDriver.class.getName());

    public static SQLDriver instance(String dbName, SQLTable table) throws Exception {
        return new PostgresDriver(dbName, table);
    }

    public static SQLDriver instance(String dbName) throws Exception {
        return new PostgresDriver(dbName);
    }

    public PostgresDriver(String dbName, SQLTable table) throws Exception {
        super(dbName, table);
        this.init(dbName);
    }

    public PostgresDriver(String dbName) throws Exception {
        super(dbName, null);
        this.init(dbName);
    }

    public void init(String dbName) throws Exception {
    }

    public boolean supportsNativeReplace() {
        return false;
    }

    public boolean supportsSQLLimit() {
        return true;
    }

    public String limitQuery(String query, long startRow, long batchSize, List outputColumns) {
        return query + " OFFSET " + startRow + " LIMIT " + batchSize;
    }

    public Map fetchLastPrimaryKeys(Map primaryKeysPresent, List sequencesNotPresent, SQLDataSource ds, DSRequest req) throws Exception {
        if (this.dbConnection == null && req == null) {
            throw new Exception("no existing db connection exists for last row fetch");
        }
        Object sqlStatement = null;
        Map primaryKeys = primaryKeysPresent;
        for (String sequenceName : sequencesNotPresent) {
            String sequence = this.getCurrentSequenceValue(sequenceName, ds);
            if (sequence == null) continue;
            Object obj = PostgresDriver.getScalarResult("SELECT " + sequence, this.dbConnection, this.dbName, this, req);
            primaryKeys.put(sequenceName, obj);
        }
        return primaryKeys;
    }

    public String formatValue(Object value) {
        return value.toString();
    }

    public String sqlOutTransform(String columnName, String remapName, String tableName) throws Exception {
        String output = this.escapeColumnName(columnName);
        if (remapName != null && !columnName.equals(remapName)) {
            output = output + " AS " + this.escapeColumnName(remapName);
        }
        if (tableName != null) {
            output = tableName + "." + output;
        }
        return output;
    }

    public String escapeValue(Object value) {
        if (value == null) {
            return null;
        }
        return "'" + this.escapeValueUnquoted(value.toString(), false) + "'";
    }

    public String escapeValueForFilter(Object value, String filterStyle) {
        if (value == null) {
            return null;
        }
        String rtn = "'";
        if (!"startsWith".equals(filterStyle)) {
            rtn = rtn + "%";
        }
        return rtn + this.escapeValueUnquoted(value, true) + "%'";
    }

    public String escapeValueUnquoted(Object value, boolean escapeForFilter) {
        if (value == null) {
            return null;
        }
        String escaped = globalPerl.substitute("s/'/''/g", value.toString());
        if (Config.getGlobal().getBoolean((Object)"sql.postgresql.escapeBackslashes", false)) {
            escaped = globalPerl.substitute("s'\\\\'\\\\\\\\'g", escaped);
        }
        if (!escapeForFilter) {
            escaped = globalPerl.substitute("s'\\\\'\\\\\\\\'go", escaped);
        } else {
            escaped = globalPerl.substitute("s'\\\\'\\\\\\\\\\\\\\\\'go", escaped);
            escaped = globalPerl.substitute("s'%'\\%'g", escaped);
            escaped = globalPerl.substitute("s'_'\\_'g", escaped);
        }
        return escaped;
    }

    public String getNextSequenceValue(String columnName, SQLDataSource ds) throws Exception {
        String sequenceName = this.getSequenceName(columnName, ds);
        if (sequenceName == null) {
            return null;
        }
        String schema = "";
        if (ds != null) {
            schema = (String)ds.getConfig().get("schema");
            schema = schema == null ? "" : schema + ".";
        }
        return "nextval('" + schema + sequenceName + "')";
    }

    public String getCurrentSequenceValue(String columnName, SQLDataSource ds) throws Exception {
        String sequenceName = this.getSequenceName(columnName);
        if (sequenceName == null) {
            return null;
        }
        String schema = "";
        if (ds != null) {
            schema = (String)ds.getConfig().get("schema");
            schema = schema == null ? "" : schema + ".";
        }
        return "currval('" + schema + sequenceName + "')";
    }

    protected String getExpressionForSortBy(String column, Map valueMap, DSRequest request) {
        if (valueMap == null || valueMap.size() == 0) {
            return column;
        }
        String expr = "CASE " + column;
        for (String actualValue : valueMap.keySet()) {
            String displayValue;
            if (valueMap.get(actualValue) instanceof LocaleMessage) {
                Locale locale = request != null ? request.context.getLocale() : Locale.getDefault();
                displayValue = ((LocaleMessage)valueMap.get(actualValue)).getMessage(locale);
            } else {
                displayValue = valueMap.get(actualValue) == null ? null : valueMap.get(actualValue).toString();
            }
            displayValue = this.escapeValue(displayValue);
            expr = expr + " WHEN '" + actualValue + "' THEN " + displayValue;
        }
        expr = expr + " ELSE CAST (" + column + " AS TEXT) END";
        return expr;
    }

    public boolean canSetFetchSize() {
        return false;
    }

    public boolean castNumbersBeforeLikeCompare() {
        return true;
    }

    public String getNaturalTableName(String tableName) {
        return tableName.toLowerCase();
    }

    public boolean aliasRequiredForSubselect() {
        return true;
    }

    public boolean shouldParameterizeNullValues() {
        return false;
    }
}

