/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.sql;

import com.isomorphic.base.Reflection;
import com.isomorphic.datasource.BasicDataSource;
import com.isomorphic.datasource.DSField;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.IncludeFromDefinition;
import com.isomorphic.log.Logger;
import com.isomorphic.sql.SQLDataSource;
import com.isomorphic.sql.SQLDriver;
import com.isomorphic.sql.SQLTransformException;
import com.isomorphic.util.DataTools;
import com.isomorphic.util.ISCDate;
import com.isomorphic.util.ISCTime;
import java.io.InputStream;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

public class SQLTransform {
    private static Logger log = new Logger(SQLTransform.class.getName());
    private static Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
    public static final int ALL_ROWS = -1;

    public static Map toAttributeMap(ResultSet rs, ResultSetMetaData rsmd, boolean useColumnLabel) throws SQLException {
        return SQLTransform.toAttributeMap(rs, null, rsmd, useColumnLabel, null, null, null);
    }

    public static Map toAttributeMap(ResultSet rs, List dataSources, ResultSetMetaData rsmd, boolean useColumnLabel, Map caseInsensitiveMap, List outputs, DSRequest req) throws SQLException {
        int columns = rsmd.getColumnCount();
        HashMap<String, String[]> result = new HashMap<String, String[]>(columns + 1);
        boolean warnAboutOracleTimestampConversion = false;
        for (int ii = 1; ii <= columns; ++ii) {
            String columnName = useColumnLabel ? rsmd.getColumnLabel(ii) : rsmd.getColumnName(ii);
            if (caseInsensitiveMap != null && caseInsensitiveMap.get(columnName) != null) {
                columnName = (String)caseInsensitiveMap.get(columnName);
            }
            Object obj = null;
            try {
                obj = rs.getObject(ii);
            }
            catch (Exception e) {
                log.warn((Object)("Crashed trying to getObject for column " + columnName));
                if (e instanceof SQLException) {
                    throw (SQLException)e;
                }
                e.printStackTrace();
            }
            if (obj == null || outputs != null && !outputs.contains(columnName)) continue;
            if (dataSources != null) {
                for (DataSource ds : dataSources) {
                    String sqlType;
                    DSField field = ds.getField(columnName);
                    if (field == null) continue;
                    boolean useUTCDateTimes = true;
                    SQLDriver driver = null;
                    if (ds instanceof SQLDataSource) {
                        useUTCDateTimes = ((SQLDataSource)ds).shouldUseUTCDateTimes();
                        driver = ((SQLDataSource)ds).driver;
                    }
                    String baseType = field.getType();
                    try {
                        baseType = ((BasicDataSource)ds).getSimpleBaseType(baseType);
                    }
                    catch (Exception e) {
                        log.warn((Object)("Exception trying to derive base type for field " + field.getName()));
                    }
                    if ("boolean".equals(baseType)) {
                        sqlType = (String)field.get((Object)"sqlStorageStrategy");
                        if ("number".equals(sqlType) || "integer".equals(sqlType)) {
                            String value = obj.toString();
                            obj = "1".equals(value) || "true".equals(value.toLowerCase()) ? Boolean.TRUE : Boolean.FALSE;
                        } else if (sqlType != null && sqlType.indexOf("singleChar") == 0) {
                            obj = SQLTransform.convertSingleCharValue(sqlType, obj, field);
                        } else if (sqlType != null && sqlType.equals("string")) {
                            String trueValue = (String)field.get((Object)"sqlTrueValue");
                            String falseValue = (String)field.get((Object)"sqlFalseValue");
                            if (trueValue == null && falseValue == null) {
                                log.warn((Object)("Could not establish a storage strategy for boolean 'true' and 'false' for field " + field.getName() + " - returning 'false'"));
                                obj = Boolean.FALSE;
                            } else {
                                obj = trueValue != null ? Boolean.valueOf(trueValue.equals(obj)) : Boolean.valueOf(Boolean.valueOf(falseValue.equals(obj)) == false);
                            }
                        } else {
                            obj = Boolean.valueOf(obj.toString());
                        }
                    } else {
                        if (field.isBinary()) {
                            obj = rs.getBinaryStream(ii);
                            try {
                                obj = ((SQLDataSource)ds).driver.handleInputStream((InputStream)obj);
                            }
                            catch (Exception e) {
                                log.warn((Object)"Error attempting to handle a binary InputStream", (Throwable)e);
                                continue;
                            }
                            if (req == null) break;
                            req.setFreeOnExecute(false);
                            break;
                        }
                        if (obj instanceof Clob || "clob".equals(field.getType())) {
                            obj = rs.getCharacterStream(ii);
                            if (req == null) break;
                            req.setFreeOnExecute(false);
                            break;
                        }
                        if (("date".equals(baseType) || "time".equals(baseType)) && !field.isMultiple()) {
                            sqlType = (String)field.get((Object)"sqlStorageStrategy");
                            if ("number".equals(sqlType) || "integer".equals(sqlType) || "text".equals(sqlType)) {
                                String sqlFormat = (String)field.get((Object)"sqlDateFormat");
                                if (sqlFormat == null) {
                                    sqlFormat = "yyyyMMdd";
                                }
                                SimpleDateFormat sdf = null;
                                if ("number".equals(sqlType) && ("epoch".equalsIgnoreCase(sqlFormat) || "epochms".equalsIgnoreCase(sqlFormat))) {
                                    long e = obj instanceof Number ? ((Number)obj).longValue() : Long.parseLong(rs.getString(ii));
                                    int milliseconds = 1000;
                                    if ("epochms".equalsIgnoreCase(sqlFormat)) {
                                        milliseconds = 1;
                                    }
                                    obj = new Date(e * (long)milliseconds);
                                    continue;
                                }
                                sdf = new SimpleDateFormat(sqlFormat);
                                if (("number".equals(sqlType) || "integer".equals(sqlType)) && Float.parseFloat(obj.toString()) == 0.0f) {
                                    obj = null;
                                    continue;
                                }
                                String str = obj.toString();
                                if (obj.toString().length() < sqlFormat.length()) {
                                    for (int j = str.length(); j < sqlFormat.length(); ++j) {
                                        str = "0" + str;
                                    }
                                } else if (obj.toString().length() > sqlFormat.length()) {
                                    log.warn((Object)("Unable to parse a valid date, time or datetime out of value " + obj + " using format string " + sqlFormat));
                                    obj = null;
                                    continue;
                                }
                                try {
                                    obj = sdf.parse(str);
                                }
                                catch (ParseException pe) {
                                    log.warn((Object)("Unable to parse a valid date, time or datetime out of value " + obj + " using format string " + sqlFormat));
                                }
                            } else if (obj instanceof Timestamp && "datetime".equals(field.getType())) {
                                if (useUTCDateTimes) {
                                    Calendar c = calendar;
                                    obj = rs.getTimestamp(ii, calendar);
                                    if (driver != null) {
                                        obj = driver.adjustTimestamp((Timestamp)obj);
                                    }
                                }
                            } else if (driver != null) {
                                obj = driver.modifyTemporalObject(obj, rs, ii);
                            }
                            if (!(obj instanceof Date)) {
                                log.warn((Object)("received a non-java.util.Date class: " + obj.getClass().getName() + " for date field: " + field.getName()));
                            } else if ("date".equals(field.getType())) {
                                obj = new ISCDate(((Date)obj).getTime());
                            } else if ("time".equals(field.getType())) {
                                obj = new ISCTime(((Date)obj).getTime());
                            }
                        } else if (field.isMultiple() && field.getMultipleStorage() == null) {
                            if (obj instanceof String) {
                                String string = (String)obj;
                                obj = string.split(",");
                            }
                        } else {
                            obj = driver.transformFieldValue(field, obj);
                        }
                    }
                    if (!"text".equals(baseType) || field.typeIsDefaulted()) continue;
                    if (obj instanceof Collection) {
                        ArrayList<String> collection = new ArrayList<String>();
                        for (Object o : (Collection)obj) {
                            collection.add(o == null ? null : o.toString());
                        }
                        obj = collection;
                        continue;
                    }
                    if (obj != null && obj.getClass().isArray()) {
                        Object[] array = DataTools.toObjectArray((Object)obj);
                        for (int k = 0; k < array.length; ++k) {
                            array[k] = array[k] == null ? null : array[k].toString();
                        }
                        obj = array;
                        continue;
                    }
                    obj = obj.toString();
                }
            }
            result.put(columnName, (String[])obj);
        }
        return result;
    }

    protected static Boolean convertSingleCharValue(String sqlType, Object columnValue, DSField field) {
        String t = (String)field.get((Object)"sqlTrueValue");
        if ("singleChar10".equals(sqlType)) {
            t = "1";
        } else if ("singleCharYN".equals(sqlType)) {
            t = "Y";
        } else if ("singleCharTF".equals(sqlType)) {
            t = "T";
        }
        if (t == null) {
            log.warn((Object)("Could not establish a storage strategy for boolean 'true' for field " + field.getName() + " - returning 'false'"));
            return Boolean.FALSE;
        }
        return t.equals(columnValue);
    }

    public static boolean hasBrokenCursorAPIs(SQLDriver driver) {
        return driver.hasBrokenCursorAPIs();
    }

    public static boolean hasBrokenCursorAPIs(String dbName) throws Exception {
        return SQLTransform.hasBrokenCursorAPIs(SQLDriver.instance(dbName));
    }

    public static List toListOfMaps(ResultSet rs) throws SQLException {
        return SQLTransform.toListOfMaps(rs, -1L, false);
    }

    public static List toListOfMaps(ResultSet rs, SQLDriver driver) throws SQLException {
        return SQLTransform.toListOfMaps(rs, -1L, SQLTransform.hasBrokenCursorAPIs(driver));
    }

    public static List toListOfMaps(ResultSet rs, boolean brokenCursorAPIs) throws SQLException {
        return SQLTransform.toListOfMaps(rs, -1L, brokenCursorAPIs);
    }

    public static List toListOfMaps(ResultSet rs, long numRows) throws SQLException {
        return SQLTransform.toListOfMaps(rs, numRows, false);
    }

    public static List toListOfMaps(ResultSet rs, long numRows, SQLDriver driver) throws SQLException {
        return SQLTransform.toListOfMaps(rs, numRows, SQLTransform.hasBrokenCursorAPIs(driver));
    }

    public static List toListOfMaps(ResultSet rs, long numRows, boolean brokenCursorAPIs) throws SQLException {
        return SQLTransform.toListOfMapsOrBeans(rs, numRows, brokenCursorAPIs, null);
    }

    public static List toListOfMapsOrBeans(ResultSet rs, SQLDriver driver, List dataSources) throws SQLException {
        return SQLTransform.toListOfMapsOrBeans(rs, -1L, SQLTransform.hasBrokenCursorAPIs(driver), dataSources);
    }

    public static List toListOfMaps(ResultSet rs, long numRows, SQLDriver driver, List dataSources) throws SQLException {
        return SQLTransform.toListOfMapsOrBeans(rs, numRows, SQLTransform.hasBrokenCursorAPIs(driver), dataSources);
    }

    public static List toListOfMapsOrBeans(ResultSet rs, boolean brokenCursorAPIs, List dataSources) throws SQLException {
        return SQLTransform.toListOfMapsOrBeans(rs, -1L, brokenCursorAPIs, dataSources);
    }

    public static List toListOfMapsOrBeans(ResultSet rs, long numRows, boolean brokenCursorAPIs, List dataSources) throws SQLException {
        return SQLTransform.toListOfMapsOrBeans(rs, numRows, brokenCursorAPIs, dataSources, null);
    }

    public static List toListOfMapsOrBeans(ResultSet rs, SQLDriver driver, List dataSources, Map opConfig) throws SQLException {
        return SQLTransform.toListOfMapsOrBeans(rs, -1L, SQLTransform.hasBrokenCursorAPIs(driver), dataSources, opConfig);
    }

    public static List toListOfMapsOrBeans(ResultSet rs, SQLDriver driver, List dataSources, Map opConfig, DSRequest req) throws SQLException {
        return SQLTransform.toListOfMapsOrBeans(rs, -1L, SQLTransform.hasBrokenCursorAPIs(driver), dataSources, opConfig, req);
    }

    public static List toListOfMapsOrBeans(ResultSet rs, boolean brokenCursorAPIs, List dataSources, Map opConfig) throws SQLException {
        return SQLTransform.toListOfMapsOrBeans(rs, -1L, brokenCursorAPIs, dataSources, opConfig);
    }

    public static List toListOfMapsOrBeans(ResultSet rs, boolean brokenCursorAPIs, List dataSources, Map opConfig, DSRequest req) throws SQLException {
        return SQLTransform.toListOfMapsOrBeans(rs, -1L, brokenCursorAPIs, dataSources, opConfig, req);
    }

    public static List toListOfMapsOrBeans(ResultSet rs, long numRows, SQLDriver driver, List dataSources, Map opConfig) throws SQLException {
        return SQLTransform.toListOfMapsOrBeans(rs, numRows, SQLTransform.hasBrokenCursorAPIs(driver), dataSources, opConfig);
    }

    public static List toListOfMapsOrBeans(ResultSet rs, long numRows, SQLDriver driver, List dataSources, Map opConfig, DSRequest req) throws SQLException {
        return SQLTransform.toListOfMapsOrBeans(rs, numRows, SQLTransform.hasBrokenCursorAPIs(driver), dataSources, opConfig, req);
    }

    public static List toListOfMapsOrBeans(ResultSet rs, long numRows, boolean brokenCursorAPIs, List dataSources, Map opConfig) throws SQLException {
        return SQLTransform.toListOfMapsOrBeans(rs, numRows, brokenCursorAPIs, dataSources, opConfig, null);
    }

    public static List toListOfMapsOrBeans(ResultSet rs, long numRows, boolean brokenCursorAPIs, List dataSources, Map opConfig, DSRequest req) throws SQLException {
        return SQLTransform.toListOfMapsOrBeans(rs, numRows, brokenCursorAPIs, dataSources, opConfig, req, true);
    }

    public static List toListOfMapsOrBeans(ResultSet rs, long numRows, boolean brokenCursorAPIs, List dataSources, Map opConfig, DSRequest req, boolean convertToBeans) throws SQLException {
        return SQLTransform.toListOfMapsOrBeans(rs, numRows, brokenCursorAPIs, dataSources, opConfig, req, convertToBeans, null);
    }

    public static List toListOfMapsOrBeans(ResultSet rs, long numRows, boolean brokenCursorAPIs, List dataSources, Map opConfig, DSRequest req, boolean convertToBeans, DSResponse dsResponse) throws SQLException {
        DataSource ds;
        String beanClassName = null;
        ArrayList<String> outputs = null;
        if (opConfig != null) {
            beanClassName = (String)opConfig.get("beanClassName");
            String outputsString = (String)opConfig.get("outputs");
            if (outputsString != null) {
                outputs = new ArrayList<String>();
                String[] outputsArray = outputsString.split(",");
                for (int i = 0; i < outputsArray.length; ++i) {
                    outputs.add(outputsArray[i].trim());
                }
            }
        }
        if (beanClassName == null && dataSources != null) {
            DataSource firstDS = (DataSource)dataSources.get(0);
            beanClassName = (String)firstDS.getConfig().get("beanClassName");
        }
        ArrayList<Object> result = new ArrayList<Object>();
        Date start = new Date();
        if (brokenCursorAPIs) {
            if (numRows != -1L) {
                throw new SQLTransformException("Partial processing of ResultSets is not supported for this database");
            }
            if (!rs.next()) {
                return result;
            }
        } else {
            boolean isBeforeFirst = false;
            boolean isAfterLast = false;
            try {
                isBeforeFirst = rs.isBeforeFirst();
                isAfterLast = rs.isAfterLast();
            }
            catch (Exception ignored) {
                log.debug((Object)"isBeforeFirst()/isAfterLast() throwing exceptions - attempting workaround");
            }
            if ((isBeforeFirst || isAfterLast || rs.getRow() == 0) && !rs.next()) {
                return result;
            }
        }
        ResultSetMetaData rsmd = rs.getMetaData();
        HashMap<String, String> caseInsensitiveMap = null;
        boolean useColumnLabel = false;
        if (dataSources != null && (ds = (DataSource)dataSources.get(0)) instanceof SQLDataSource) {
            SQLDriver driver = ((SQLDataSource)ds).getDriver();
            useColumnLabel = driver.useColumnLabelInMetadata();
        }
        if (dataSources != null) {
            caseInsensitiveMap = new HashMap<String, String>();
            int columns = rsmd.getColumnCount();
            for (int i = 1; i <= columns; ++i) {
                List includeFrom;
                List names;
                String fieldName = null;
                String columnName = useColumnLabel ? rsmd.getColumnLabel(i) : rsmd.getColumnName(i);
                for (DataSource ds2 : dataSources) {
                    names = ds2.getFieldNames();
                    if (!names.contains(columnName)) continue;
                    fieldName = columnName;
                    break;
                }
                if (fieldName == null) {
                    for (DataSource ds2 : dataSources) {
                        names = ds2.getFieldNames();
                        for (String name : names) {
                            if (!name.equalsIgnoreCase(columnName)) continue;
                            fieldName = name;
                            break;
                        }
                        if (fieldName == null) continue;
                        break;
                    }
                }
                if (fieldName == null && req != null && (includeFrom = req.getIncludeFrom()) != null && includeFrom.size() > 0) {
                    IncludeFromDefinition incFrom;
                    for (Object incFromObject : includeFrom) {
                        incFrom = (IncludeFromDefinition)incFromObject;
                        if (!incFrom.getThisFieldName().equals(columnName)) continue;
                        fieldName = columnName;
                        break;
                    }
                    if (fieldName == null) {
                        for (Object incFromObject : includeFrom) {
                            incFrom = (IncludeFromDefinition)incFromObject;
                            if (!incFrom.getThisFieldName().equalsIgnoreCase(columnName)) continue;
                            fieldName = incFrom.getThisFieldName();
                            break;
                        }
                    }
                }
                if (fieldName != null) {
                    caseInsensitiveMap.put(columnName, fieldName);
                    continue;
                }
                caseInsensitiveMap.put(columnName, columnName);
            }
        }
        int i = 0;
        while ((long)i < numRows || numRows == -1L) {
            Map map = SQLTransform.toAttributeMap(rs, dataSources, rsmd, useColumnLabel, caseInsensitiveMap, outputs, req);
            if (!convertToBeans || beanClassName == null || beanClassName.equals("")) {
                result.add(map);
            } else {
                try {
                    Object bean = DataTools.setProperties((Map)map, Reflection.classForName((String)beanClassName).newInstance());
                    result.add(bean);
                }
                catch (Exception e) {
                    log.warn((Object)("Couldn't create bean of class '" + beanClassName + "':" + e.getMessage()));
                    throw new SQLException(e.getMessage());
                }
            }
            if (!rs.next()) {
                if (dsResponse == null) break;
                dsResponse._setHasNextRecord(false);
                break;
            }
            ++i;
        }
        Date end = new Date();
        Logger.timing.debug((Object)("SQLTransform (" + result.size() + " rows): " + (end.getTime() - start.getTime()) + "ms"));
        return result;
    }

    public static Map toMapOfLists(ResultSet rs) throws SQLException {
        int ii;
        HashMap result = new HashMap();
        ResultSetMetaData header = rs.getMetaData();
        for (ii = 1; ii <= header.getColumnCount(); ++ii) {
            result.put(header.getColumnName(ii), new ArrayList());
        }
        while (rs.next()) {
            for (ii = 1; ii < header.getColumnCount(); ++ii) {
                ((List)result.get(header.getColumnName(ii))).add(rs.getObject(ii));
            }
        }
        return result;
    }

    public static List toValuesList(ResultSet results, String column) throws SQLException {
        ArrayList<Object> valuesList = new ArrayList<Object>();
        while (results.next()) {
            Object value = results.getObject(column);
            if (value == null) continue;
            valuesList.add(value);
        }
        return valuesList;
    }
}

