/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.sql;

import com.isomorphic.datasource.DSRequest;
import com.isomorphic.log.Logger;
import com.isomorphic.sql.SQLDataSource;
import com.isomorphic.sql.SQLDriver;
import com.isomorphic.sql.SQLTable;
import com.isomorphic.util.LocaleMessage;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

public class MysqlDriver
extends SQLDriver {
    private static Logger log = new Logger(MysqlDriver.class.getName());

    public static SQLDriver instance(String dbName, SQLTable table) throws Exception {
        return new MysqlDriver(dbName, table);
    }

    public static SQLDriver instance(String dbName) throws Exception {
        return new MysqlDriver(dbName);
    }

    public MysqlDriver(String dbName, SQLTable table) throws Exception {
        super(dbName, table);
        this.init(dbName);
    }

    public void init(String dbName) throws Exception {
    }

    public MysqlDriver(String dbName) throws Exception {
        super(dbName, null);
        this.init(dbName);
    }

    public String openQuote() {
        return "`";
    }

    public String closeQuote() {
        return "`";
    }

    public boolean supportsSQLLimit() {
        return true;
    }

    public String limitQuery(String query, long startRow, long batchSize, List outputColumns) {
        return query + " LIMIT " + startRow + ", " + batchSize;
    }

    public Map fetchLastPrimaryKeys(Map primaryKeysPresent, List sequencesNotPresent, SQLDataSource ds, DSRequest req) throws Exception {
        log.debug((Object)("fetchLastRow data - primaryKeysPresent: " + primaryKeysPresent.toString() + "sequencesNotPresent: " + sequencesNotPresent.toString()));
        if (sequencesNotPresent.size() > 1) {
            throw new Exception("mysql can't handle more than one auto_increment primary_key");
        }
        if (this.dbConnection == null && req == null) {
            throw new Exception("no connection exists for last row fetch");
        }
        Object sqlStatement = null;
        Map primaryKeys = primaryKeysPresent;
        if (!sequencesNotPresent.isEmpty()) {
            String sequenceName = (String)sequencesNotPresent.get(0);
            String obj = MysqlDriver.getScalarResult("SELECT LAST_INSERT_ID()", this.dbConnection, this.dbName, this, req).toString();
            Long sequenceValue = new Long(obj.toString());
            primaryKeys.put(sequenceName, sequenceValue);
        }
        return primaryKeys;
    }

    public boolean supportsNativeReplace() {
        return true;
    }

    public String sqlOutTransform(String columnName, String remapName, String tableName) throws Exception {
        String output = this.escapeColumnName(columnName);
        if (tableName != null) {
            output = tableName + "." + output;
        }
        if (remapName != null && !columnName.equals(remapName)) {
            output = output + " AS " + remapName;
        }
        return output;
    }

    public String escapeValue(Object value) {
        if (value == null) {
            return null;
        }
        return "'" + this.escapeValueUnquoted(value, false) + "'";
    }

    public String escapeValueForFilter(Object value) {
        return this.escapeValueForFilter(value, null);
    }

    public String escapeValueForFilter(Object value, String filterStyle) {
        if (value == null) {
            return null;
        }
        if (filterStyle == null) {
            filterStyle = "substring";
        }
        String rtn = "'";
        if (!"startsWith".equals(filterStyle)) {
            rtn = rtn + "%";
        }
        return rtn + this.escapeValueUnquoted(value, true) + "%'";
    }

    public String escapeValueUnquoted(Object value, boolean escapeForFilter) {
        if (value == null) {
            return null;
        }
        String escaped = globalPerl.substitute("s/'/''/go", value.toString());
        if (!escapeForFilter) {
            escaped = globalPerl.substitute("s'\\\\'\\\\\\\\'go", escaped);
        } else {
            escaped = globalPerl.substitute("s'\\\\'\\\\\\\\\\\\\\\\'go", escaped);
            escaped = globalPerl.substitute("s'%'\\%'g", escaped);
            escaped = globalPerl.substitute("s'_'\\_'g", escaped);
        }
        return escaped;
    }

    public String formatValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            return this.utcDateTimeFormatter.format((Date)value);
        }
        return value.toString();
    }

    public String getNextSequenceValue(String columnName, SQLDataSource ds) throws Exception {
        return "null";
    }

    protected String getExpressionForSortBy(String column, Map valueMap, DSRequest request) {
        if (valueMap == null || valueMap.size() == 0) {
            return column;
        }
        String expr = "CASE " + column;
        for (String actualValue : valueMap.keySet()) {
            String displayValue;
            if (valueMap.get(actualValue) instanceof LocaleMessage) {
                Locale locale = request != null ? request.context.getLocale() : Locale.getDefault();
                displayValue = ((LocaleMessage)valueMap.get(actualValue)).getMessage(locale);
            } else {
                displayValue = valueMap.get(actualValue) == null ? null : valueMap.get(actualValue).toString();
            }
            displayValue = this.escapeValue(displayValue);
            expr = expr + " WHEN '" + actualValue + "' THEN " + displayValue;
        }
        expr = expr + " ELSE " + column + " END";
        return expr;
    }

    public String getURLParameterString() {
        return this.useUTCDateTimes ? "serverTimezone=UTC" : null;
    }

    public void addDriverProperties(Map properties) {
        if (this.useUTCDateTimes) {
            properties.put("serverTimezone", "UTC");
        }
    }

    public Timestamp adjustTimestamp(Timestamp timestamp) {
        long millis = timestamp.getTime();
        TimeZone tz = TimeZone.getDefault();
        int offset = tz.getOffset(millis);
        return new Timestamp(millis + (long)offset);
    }

    public int caseInsensitiveStrategy() {
        return 0;
    }

    public String caseSensitiveEqualsPredicate() {
        return " LIKE BINARY ";
    }

    public String caseSensitiveNotEqualPredicate() {
        return " NOT LIKE BINARY ";
    }

    public String getNaturalTableName(String tableName) {
        return tableName;
    }

    public String sqlConcat(String ... strings) {
        if (strings == null || strings.length == 0) {
            return "";
        }
        if (strings.length == 1) {
            return strings[0];
        }
        StringBuffer sql = new StringBuffer("CONCAT(");
        for (String s : strings) {
            if (sql.length() > "CONCAT(".length()) {
                sql.append(", ");
            }
            sql.append(s);
        }
        sql.append(")");
        return sql.toString();
    }

    public boolean aliasRequiredForSubselect() {
        return true;
    }

    public int maxAllowedSequenceColumns() {
        return 1;
    }
}

