/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.sql;

import com.isomorphic.base.Base;
import com.isomorphic.base.Config;
import com.isomorphic.log.Logger;
import com.isomorphic.sql.InformixDriver;
import com.isomorphic.sql.SQLConnectionManager;
import com.isomorphic.sql.SQLDriver;
import com.isomorphic.sql.SQLMetaData;
import com.isomorphic.sql.SQLServerDriver;
import com.isomorphic.util.DataTools;
import com.isomorphic.velocity.Velocity;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SQLDSGenerator
extends Base {
    private Logger log = new Logger(SQLDSGenerator.class.getName());
    public static final String DEFAULT_TIMESTAMP_TYPE = "datetime";
    private static Map jdbcTypes = new HashMap();
    private String tableName;
    private String schema;
    private String dbName;
    private Map autoDeriveSchemaOperation = null;
    private String serverType;
    private String timestampType;
    private boolean returnSQLType;
    private boolean autoDeriveFKs = true;
    private Connection conn;
    private String ID;
    private Map overriddenFields;
    private String discoveredSchema;

    public static List getFieldsFromTable(Connection conn, String tableName, String schema) throws Exception {
        SQLDSGenerator instance = new SQLDSGenerator(tableName, schema);
        instance.setConn(conn);
        return instance.getFieldsFromTable();
    }

    public SQLDSGenerator(String tableName, String schema) {
        this(tableName, schema, null, "sql", DEFAULT_TIMESTAMP_TYPE, false);
    }

    public SQLDSGenerator(String tableName, String schema, String dbName) {
        this(tableName, schema, dbName, "sql", DEFAULT_TIMESTAMP_TYPE, false);
    }

    public SQLDSGenerator(String tableName, String schema, String dbName, String serverType) {
        this(tableName, schema, dbName, serverType, DEFAULT_TIMESTAMP_TYPE, false);
    }

    public SQLDSGenerator(String tableName, String schema, String dbName, String serverType, String timestampType, boolean returnSQLType) {
        this.tableName = tableName;
        this.schema = schema;
        this.dbName = dbName;
        this.serverType = serverType;
        this.timestampType = timestampType;
        this.returnSQLType = returnSQLType;
        this.autoDeriveFKs = !Boolean.FALSE.equals(config.getBoolean((Object)"datasource.autoLinkFKs"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map generate() throws Exception {
        Config iscConfig;
        if (this.serverType == null) {
            this.serverType = "sql";
        }
        HashMap<String, Object> config = new HashMap<String, Object>();
        if (this.ID == null) {
            this.ID = this.tableName;
        }
        config.put("ID", this.ID);
        config.put("dataSourceVersion", String.valueOf(1));
        if (this.tableName != null) {
            config.put("tableName", this.tableName);
        }
        if (this.schema != null) {
            config.put("schema", this.schema);
        }
        config.put("serverType", this.serverType);
        if ("hibernate".equals(this.serverType)) {
            config.put("xmlFromConfig", "true");
        }
        if ((iscConfig = Config.getGlobal()) != null) {
            String version = iscConfig.getString((Object)"iscVersion") + " " + iscConfig.getString((Object)"iscPackageDate");
            config.put("generatedBy", version);
        }
        List fields = null;
        boolean freeConnection = false;
        if (this.conn == null) {
            freeConnection = true;
            this.conn = SQLConnectionManager.getConnection(this.dbName);
        }
        boolean impSeq = false;
        try {
            this.discoveredSchema = null;
            List list = fields = this.autoDeriveSchemaOperation == null ? this.getFieldsFromTable() : this.getFieldsFromOperation(this.autoDeriveSchemaOperation);
            if (this.discoveredSchema != null) {
                config.put("schema", this.discoveredSchema);
            }
            if (this.overriddenFields != null) {
                Iterator<Object> i = this.overriddenFields.keySet().iterator();
                while (i.hasNext()) {
                    Map fieldDef;
                    boolean ignore;
                    Object fieldDefObj = this.overriddenFields.get(i.next());
                    if (!(fieldDefObj instanceof Map) || !(ignore = DataTools.getBoolean((Map)(fieldDef = (Map)fieldDefObj), (Object)"ignore"))) continue;
                    String fieldName = (String)fieldDef.get("name");
                    for (int j = 0; j < fields.size(); ++j) {
                        String name;
                        if (!(fields.get(j) instanceof Map) || (name = (String)((Map)fields.get(j)).get("name")) == null || !name.equals(fieldName)) continue;
                        fields.remove(j);
                    }
                }
            }
            for (Map fieldDef : fields) {
                if (impSeq || !DataTools.getBoolean((Map)fieldDef, (Object)"implicitSequence", (boolean)false)) continue;
                impSeq = true;
                break;
            }
        }
        finally {
            if (freeConnection) {
                SQLConnectionManager.free(this.conn);
            }
        }
        config.put("fields", fields);
        if (this.autoDeriveSchemaOperation != null) {
            ArrayList<Map> operationBindings = new ArrayList<Map>();
            operationBindings.add(this.autoDeriveSchemaOperation);
            config.put("operationBindings", operationBindings);
        }
        if (impSeq && config.get("sequenceMode") == null) {
            config.put("sequenceMode", "jdbcDriver");
        }
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getFieldsFromOperation(Map operation) throws Exception {
        boolean freeConnection = false;
        if (this.conn == null) {
            freeConnection = true;
            this.conn = SQLConnectionManager.getConnection();
        }
        try {
            ArrayList fields = new ArrayList();
            String query = (String)operation.get("command");
            if (query == null) {
                query = (String)operation.get("customSQL");
            }
            if (query == null) {
                String tableClause;
                String selectClause = (String)operation.get("selectClause");
                if (selectClause == null) {
                    selectClause = "$defaultSelectClause";
                }
                if ((tableClause = (String)operation.get("tableClause")) == null) {
                    throw new Exception("command, customSQL or tableClause is required for auto-deriving schema from an operationBinding");
                }
                String whereClause = (String)operation.get("whereClause");
                if (whereClause == null) {
                    whereClause = "$defaultWhereClause";
                }
                query = "SELECT " + selectClause + " FROM " + tableClause + " WHERE " + whereClause;
            }
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("defaultWhereClause", "1=0");
            params.put("defaultSelectClause", "*");
            query = Velocity.evaluateAsString((String)query, params);
            this.log.info((Object)("Auto-deriving datasource using query: " + query));
            Statement s = this.conn.createStatement();
            ResultSet rs = s.executeQuery(query);
            ResultSetMetaData rsmd = rs.getMetaData();
            int numCols = rsmd.getColumnCount();
            if (numCols == 0) {
                throw new Exception("autoDeriveSchema query produced zero columns: " + query);
            }
            for (int i = 1; i <= numCols; ++i) {
                String columnLabel;
                String dsType;
                String fieldName = rsmd.getColumnName(i);
                this.log.warn((Object)("processing field: " + fieldName));
                Integer type = new Integer(rsmd.getColumnType(i));
                String typeName = rsmd.getColumnTypeName(i);
                if (type == 1111 && ("FLOAT".equals(typeName) || "DOUBLE".equals(typeName))) {
                    type = new Integer(6);
                }
                if ((dsType = this.overrideTypeConversion((int)type, fieldName, rsmd)) == null) {
                    dsType = this.dsTypeForDBType(type, null, null);
                }
                HashMap<String, Object> dsField = new HashMap<String, Object>();
                dsField.put("name", fieldName);
                dsField.put("type", dsType);
                if (this.returnSQLType) {
                    dsField.put("sqlType", jdbcTypes.get(type));
                }
                if (dsType.equals("text")) {
                    Integer length = new Integer(rsmd.getColumnDisplaySize(i));
                    dsField.put("length", length);
                }
                if ((columnLabel = rsmd.getColumnLabel(i)) != null && !columnLabel.equals("")) {
                    dsField.put("title", columnLabel);
                }
                fields.add(dsField);
            }
            ArrayList arrayList = fields;
            return arrayList;
        }
        finally {
            if (freeConnection) {
                SQLConnectionManager.free(this.conn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getFieldsFromTable() throws Exception {
        boolean freeConnection = false;
        if (this.conn == null) {
            freeConnection = true;
            this.conn = SQLConnectionManager.getConnection();
        }
        SQLDriver driver = SQLDriver.instance(this.dbName != null ? this.dbName : config.getString((Object)"sql.defaultDatabase"));
        try {
            ArrayList fields = new ArrayList();
            SQLMetaData md = new SQLMetaData(this.conn);
            String catalog = this.conn.getCatalog();
            this.log.info((Object)("Fetching column metadata for table: " + this.tableName));
            this.log.info((Object)("=============Using catalog: " + catalog));
            List columns = md.getColumnMetaData(catalog, this.schema, driver.getNaturalTableName(this.tableName));
            this.log.info((Object)("Fetching column metadata for " + this.tableName + " complete"));
            if (columns.size() == 0 && (columns = md.getColumnMetaData(catalog, this.schema, this.tableName)).size() == 0) {
                this.log.info((Object)("table " + this.tableName + " does not exist or contains no columns, " + " aborting and throwing Exception"));
                throw new Exception("table " + this.tableName + " does not exist or contains no columns.");
            }
            HashMap foreignKeysAssociations = new HashMap();
            if (this.autoDeriveFKs) {
                try {
                    List foreignKeys = md.getForeignKeys(catalog, this.schema, driver.getNaturalTableName(this.tableName));
                    for (Map data : foreignKeys) {
                        Map overriddenField;
                        String tableField = "PKTABLE_NAME";
                        String columnField = "PKCOLUMN_NAME";
                        if (driver instanceof InformixDriver) {
                            tableField = tableField.toLowerCase();
                            columnField = columnField.toLowerCase();
                        }
                        String tableName = (String)data.get(tableField);
                        String fieldName = (String)data.get(columnField);
                        if (this.overriddenFields != null && (overriddenField = (Map)this.overriddenFields.get(fieldName)) != null && Boolean.FALSE.equals(overriddenField.get("autoDeriveFKs"))) continue;
                        String fkColumnField = "FKCOLUMN_NAME";
                        if (driver instanceof InformixDriver) {
                            fkColumnField = fkColumnField.toLowerCase();
                        }
                        foreignKeysAssociations.put(data.get(fkColumnField), tableName + "." + fieldName);
                    }
                }
                catch (Exception e) {
                    this.log.error((Object)"Unable to load foreign key information for autoDeriveFK logic.", (Throwable)e);
                }
            }
            List pks = md.getPrimaryKeys(catalog, driver.getNaturalTableName(this.tableName));
            for (Map metaData : columns) {
                Object commentsObj;
                String dsType;
                String columnName = (String)metaData.get("COLUMN_NAME");
                if (columnName == null) {
                    columnName = (String)metaData.get("column_name");
                }
                if (columnName == null) {
                    columnName = (String)metaData.get("NAME");
                }
                if (columnName == null) {
                    this.log.warn((Object)("Found no COLUMN_NAME element in field metadata entry: " + metaData));
                    continue;
                }
                String fieldName = this.makeValidJSIdentifier(columnName);
                Object typeObj = metaData.get("DATA_TYPE");
                if (typeObj == null) {
                    typeObj = metaData.get("data_type");
                }
                if (typeObj == null) continue;
                Integer type = new Integer(typeObj.toString());
                if (type == 1111) {
                    String typeName = (String)metaData.get("TYPE_NAME");
                    if (typeName == null) {
                        typeName = (String)metaData.get("type_name");
                    }
                    if ("FLOAT".equals(typeName) || "DOUBLE".equals(typeName)) {
                        type = new Integer(6);
                    }
                    if (typeName != null && typeName.toLowerCase().startsWith("timestamp")) {
                        type = new Integer(93);
                    }
                }
                if (this.isBinary(type)) {
                    String[] suffix = new String[]{"filename", "filesize", "date_created"};
                    boolean ok0 = false;
                    boolean ok1 = false;
                    boolean ok2 = false;
                    for (int j = 0; j < columns.size(); ++j) {
                        String otherField = (String)((Map)columns.get(j)).get("COLUMN_NAME");
                        if (otherField == null) {
                            otherField = (String)((Map)columns.get(j)).get("column_name");
                        }
                        if (otherField == null) {
                            otherField = (String)((Map)columns.get(j)).get("NAME");
                        }
                        if (otherField == null) {
                            this.log.warn((Object)("Looking for '_filename' fields, found no COLUMN_NAME element in field metadata entry: " + columns.get(j)));
                            continue;
                        }
                        if (!ok0 && otherField.equalsIgnoreCase(fieldName + "_" + suffix[0])) {
                            ok0 = true;
                        }
                        if (!ok1 && otherField.equalsIgnoreCase(fieldName + "_" + suffix[1])) {
                            ok1 = true;
                        }
                        if (!ok2 && otherField.equalsIgnoreCase(fieldName + "_" + suffix[2])) {
                            ok2 = true;
                        }
                        if (ok0 && ok1 && ok2) break;
                    }
                    if (!ok0 || !ok1 || !ok2) continue;
                }
                if ((dsType = this.overrideTypeConversion((int)type, fieldName, md)) == null) {
                    dsType = this.dsTypeForDBType(type, null, metaData, driver);
                }
                HashMap<String, Object> dsField = new HashMap<String, Object>();
                dsField.put("name", fieldName);
                if (!fieldName.equals(columnName)) {
                    dsField.put("nativeName", columnName);
                    dsField.put("title", DataTools.deriveTitleFromName((String)columnName));
                }
                if (foreignKeysAssociations.containsKey(columnName)) {
                    String nativeFK = (String)foreignKeysAssociations.get(columnName);
                    String[] parts = nativeFK.split("\\.");
                    try {
                        String tableCode = DataTools.hashValue((String)parts[0].toLowerCase());
                        String columnCode = DataTools.hashValue((String)parts[1].toLowerCase());
                        dsField.put("fkTableCode", tableCode);
                        dsField.put("fkColumnCode", columnCode);
                    }
                    catch (Exception e) {
                        this.log.error((Object)"Can't hash foreign key", (Throwable)e);
                    }
                }
                dsField.put("type", dsType);
                if (this.returnSQLType) {
                    dsField.put("sqlType", jdbcTypes.get(type));
                    Object size = metaData.get("COLUMN_SIZE");
                    if (size == null) {
                        metaData.get("column_size");
                    }
                    dsField.put("sqlLength", size);
                }
                if (dsType.equals("text")) {
                    Object lengthObj = metaData.get("COLUMN_SIZE");
                    if (lengthObj == null) {
                        lengthObj = metaData.get("column_size");
                    }
                    if (lengthObj != null) {
                        Integer length = new Integer(lengthObj.toString());
                        dsField.put("length", length);
                    }
                }
                if ((commentsObj = metaData.get("REMARKS")) == null) {
                    commentsObj = metaData.get("remarks");
                }
                if (commentsObj != null && !commentsObj.equals("")) {
                    dsField.put("title", commentsObj.toString());
                }
                if (pks.contains(fieldName)) {
                    String columnDef;
                    dsField.put("primaryKey", new Boolean(true));
                    if (dsType.equals("integer")) {
                        dsField.put("type", "sequence");
                    }
                    if ("serial".equals(metaData.get("TYPE_NAME"))) {
                        dsField.put("implicitSequence", true);
                    }
                    if ("YES".equals(metaData.get("IS_AUTOINCREMENT"))) {
                        dsField.put("implicitSequence", true);
                    }
                    if ((columnDef = (String)metaData.get("COLUMN_DEF")) != null && (columnDef = columnDef.toUpperCase()).contains("ISEQ$$") && columnDef.endsWith(".NEXTVAL")) {
                        dsField.put("type", "sequence");
                        dsField.put("implicitSequence", true);
                    }
                }
                fields.add(dsField);
                String discoveredSchema = (String)metaData.get("TABLE_SCHEM");
                if (discoveredSchema == null) {
                    discoveredSchema = (String)metaData.get("table_schem");
                }
                if (discoveredSchema == null) continue;
                this.discoveredSchema = discoveredSchema;
            }
            ArrayList arrayList = fields;
            return arrayList;
        }
        finally {
            if (freeConnection) {
                SQLConnectionManager.free(this.conn);
            }
        }
    }

    private boolean isBinary(int i) {
        return i == -2 || i == -3 || i == -4 || i == 2004;
    }

    public String dsTypeForDBType(Number dbType, String dbName, SQLDriver driver) throws Exception {
        return this.dsTypeForDBType(dbType, dbName, null, driver);
    }

    public String dsTypeForDBType(Number dbType, String dbName, Map metadata, SQLDriver driver) throws Exception {
        switch (dbType.intValue()) {
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                return "text";
            }
            case -16: 
            case -15: 
            case -9: 
            case 2011: {
                return driver instanceof SQLServerDriver ? "ntext" : "text";
            }
            case -7: 
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                return "integer";
            }
            case 2: 
            case 3: {
                if (metadata != null) {
                    Integer iDecimalDigits;
                    Object oDecimalDigits = metadata.get("DECIMAL_DIGITS");
                    if (oDecimalDigits == null) {
                        oDecimalDigits = metadata.get("decimal_digits");
                    }
                    if (oDecimalDigits != null && (iDecimalDigits = new Integer(oDecimalDigits.toString())) == 0) {
                        return "integer";
                    }
                }
                return "float";
            }
            case 6: 
            case 7: 
            case 8: {
                return "float";
            }
            case 91: {
                return "date";
            }
            case 92: {
                return "time";
            }
            case 93: {
                return this.timestampType;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                return "binary";
            }
        }
        return "text";
    }

    public String getTimestampType() {
        return this.timestampType;
    }

    public void setTimestampType(String timestampType) {
        this.timestampType = timestampType;
    }

    public Connection getConn() {
        return this.conn;
    }

    public void setConn(Connection conn) {
        this.conn = conn;
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public String getID() {
        return this.ID;
    }

    public void setID(String id) {
        this.ID = id;
    }

    public Map getOverriddenFields() {
        return this.overriddenFields;
    }

    public void setOverriddenFields(Map overriddenFields) {
        this.overriddenFields = overriddenFields;
    }

    public String getServerType() {
        return this.serverType;
    }

    public void setServerType(String serverType) {
        this.serverType = serverType;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setAutoDeriveSchemaOperation(Map autoDeriveSchemaOperation) {
        this.autoDeriveSchemaOperation = autoDeriveSchemaOperation;
    }

    public Map getAutoDeriveSchemaOperation() {
        return this.autoDeriveSchemaOperation;
    }

    public String overrideTypeConversion(int javaSQLType, String columnName, SQLMetaData metadata) {
        return null;
    }

    public String overrideTypeConversion(int javaSQLType, String columnName, ResultSetMetaData metadata) {
        return null;
    }

    public String makeValidJSIdentifier(String in) {
        return in.replaceAll("^[^\\$_A-Za-z]", "_").replaceAll("[^\\$_A-Za-z0-9]", "_");
    }

    public void setAutoDeriveFKs(Boolean autoDeriveFKs) {
        this.autoDeriveFKs = !Boolean.FALSE.equals(autoDeriveFKs) && !Boolean.FALSE.equals(config.getBoolean((Object)"datasource.autoLinkFKs"));
    }

    static {
        jdbcTypes.put(new Integer(-7), "bit");
        jdbcTypes.put(new Integer(-6), "tinyint");
        jdbcTypes.put(new Integer(5), "smallint");
        jdbcTypes.put(new Integer(4), "integer");
        jdbcTypes.put(new Integer(-5), "bigint");
        jdbcTypes.put(new Integer(6), "float");
        jdbcTypes.put(new Integer(7), "real");
        jdbcTypes.put(new Integer(8), "double");
        jdbcTypes.put(new Integer(2), "numeric");
        jdbcTypes.put(new Integer(3), "decimal");
        jdbcTypes.put(new Integer(1), "char");
        jdbcTypes.put(new Integer(12), "varchar");
        jdbcTypes.put(new Integer(-1), "longvarchar");
        jdbcTypes.put(new Integer(91), "date");
        jdbcTypes.put(new Integer(92), "time");
        jdbcTypes.put(new Integer(93), "timestamp");
        jdbcTypes.put(new Integer(-2), "binary");
        jdbcTypes.put(new Integer(-3), "varbinary");
        jdbcTypes.put(new Integer(-4), "longvarbinary");
        jdbcTypes.put(new Integer(0), "null");
        jdbcTypes.put(new Integer(1111), "other");
        jdbcTypes.put(new Integer(2000), "java_object");
        jdbcTypes.put(new Integer(2001), "distinct");
        jdbcTypes.put(new Integer(2002), "struct");
        jdbcTypes.put(new Integer(2003), "array");
        jdbcTypes.put(new Integer(2004), "blob");
        jdbcTypes.put(new Integer(2005), "clob");
        jdbcTypes.put(new Integer(2006), "ref");
        jdbcTypes.put(new Integer(70), "datalink");
        jdbcTypes.put(new Integer(16), "boolean");
    }
}

