/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.messaging;

import com.isomorphic.log.Logger;
import com.isomorphic.messaging.ISCMessage;
import com.isomorphic.messaging.ISCMessageDispatcher;
import com.isomorphic.messaging.ISubscriber;
import com.isomorphic.naming.JNDI;
import java.io.Serializable;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jms.BytesMessage;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageEOFException;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.ResourceAllocationException;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.naming.Context;
import javax.rmi.PortableRemoteObject;

public class JMSMessageDispatcher
extends ISCMessageDispatcher
implements ExceptionListener {
    private static Logger log = new Logger(JMSMessageDispatcher.class.getName());
    private static Map<String, TopicSubscriber> topicSubscriberForChannel = Collections.synchronizedMap(new HashMap());
    Context jndiContext;
    TopicConnectionFactory topicConnectionFactory;
    TopicConnection topicConnection;
    TopicSession topicSession;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconnect() throws Exception {
        List<String> channels = ISCMessageDispatcher.getAllChannels();
        JMSMessageDispatcher jMSMessageDispatcher = this;
        synchronized (jMSMessageDispatcher) {
            if (this.topicSession != null) {
                try {
                    this.topicSession.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (this.topicConnection != null) {
                try {
                    this.topicConnection.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            String jmsContext = config.getString((Object)"messaging.jms.context", "_container_");
            String jndiPrefix = config.getString((Object)"messaging.jms.jndiPrefix", null);
            String topicConnectionFactoryName = config.getString((Object)"messaging.jms.topicConnectionFactory", "TopicConnectionFactory");
            this.jndiContext = JNDI.bindConfiguredContext((String)jmsContext);
            if (jndiPrefix != null && !jndiPrefix.equals("")) {
                this.jndiContext = (Context)this.jndiContext.lookup(jndiPrefix);
            }
            this.topicConnectionFactory = (TopicConnectionFactory)this.jndiContext.lookup(topicConnectionFactoryName);
            this.topicConnection = this.topicConnectionFactory.createTopicConnection();
            this.topicSession = this.topicConnection.createTopicSession(false, 1);
            try {
                this.topicConnection.setExceptionListener((ExceptionListener)this);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.topicConnection.start();
            for (String channel : channels) {
                this.bindToChannel(channel);
            }
        }
    }

    private synchronized void ensureConnected() throws Exception {
        if (this.topicConnection == null) {
            this.reconnect();
        }
    }

    public synchronized void closeConnection() {
        try {
            this.topicConnection.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void bindToChannel(final String channel) throws Exception {
        Topic topic = (Topic)PortableRemoteObject.narrow((Object)this.jndiContext.lookup(channel), Topic.class);
        if (topic == null) {
            topic = this.topicSession.createTopic(channel);
        }
        TopicSubscriber topicSubscriber = this.topicSession.createSubscriber(topic);
        topicSubscriber.setMessageListener(new MessageListener(){

            public void onMessage(Message arg0) {
                log.debug((Object)"Received message from JMS");
                try {
                    ISCMessage iscMessage = JMSMessageDispatcher.this.iscMessage(arg0, channel);
                    JMSMessageDispatcher.this.deliverToLocalSubscribers(iscMessage);
                }
                catch (Exception e) {
                    log.error((Object)"Unable to deliver jms message", (Throwable)e);
                }
            }
        });
        topicSubscriberForChannel.put(channel, topicSubscriber);
    }

    public void onException(JMSException e) {
        if (e instanceof IllegalStateException || e instanceof InvalidDestinationException || e instanceof MessageEOFException || e instanceof ResourceAllocationException) {
            log.warn((Object)"caught exception", (Throwable)e);
            try {
                this.reconnect();
            }
            catch (Exception ee) {
                log.warn((Object)"Unable to reconnect to JMS", (Throwable)ee);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribe(ISubscriber s, String channel) throws Exception {
        super.subscribe(s, channel);
        JMSMessageDispatcher jMSMessageDispatcher = this;
        synchronized (jMSMessageDispatcher) {
            this.ensureConnected();
            if (topicSubscriberForChannel.get(channel) != null) {
                return;
            }
            this.bindToChannel(channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribe(ISubscriber s, String channel) throws Exception {
        super.unsubscribe(s, channel);
        List<ISubscriber> channels = ISCMessageDispatcher.getSubscribersOfChannel(channel);
        if (channels != null && channels.size() > 0) {
            return;
        }
        JMSMessageDispatcher jMSMessageDispatcher = this;
        synchronized (jMSMessageDispatcher) {
            this.ensureConnected();
            TopicSubscriber topicSubscriber = topicSubscriberForChannel.get(channel);
            topicSubscriber.close();
            this.topicSession.unsubscribe(channel);
            topicSubscriberForChannel.remove(channel);
        }
    }

    public void unregister(ISubscriber s) throws Exception {
        List<String> channels = JMSMessageDispatcher.getChannelsOfSubscriber(s);
        if (channels != null) {
            for (String channel : channels) {
                this.unsubscribe(s, channel);
            }
        }
        super.unregister(s);
    }

    public synchronized void deliver(ISCMessage iscMessage) throws Exception {
        this.ensureConnected();
        for (String channel : iscMessage.getTargetChannels()) {
            Topic topic = (Topic)this.jndiContext.lookup(channel);
            TopicPublisher topicPublisher = this.topicSession.createPublisher(topic);
            Message jmsMessage = this.jmsMessage((Serializable)iscMessage.getData());
            topicPublisher.publish(jmsMessage);
            topicPublisher.close();
        }
    }

    public ISCMessage iscMessage(Message jmsMessage) throws Exception {
        String channel = ((Topic)jmsMessage.getJMSDestination()).getTopicName();
        Object data = null;
        if (jmsMessage instanceof BytesMessage) {
            data = "Not Yet Implemented";
        } else if (jmsMessage instanceof MapMessage) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            Enumeration e = ((MapMessage)jmsMessage).getMapNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                map.put(key, ((MapMessage)jmsMessage).getObject(key));
            }
            data = map;
        } else if (jmsMessage instanceof ObjectMessage) {
            data = ((ObjectMessage)jmsMessage).getObject();
        } else if (jmsMessage instanceof StreamMessage) {
            data = "Not Yet Implemented";
        } else if (jmsMessage instanceof TextMessage) {
            data = ((TextMessage)jmsMessage).getText();
        }
        log.debug((Object)("Decoded jmsMessage for channel: " + channel + " data"), data);
        return new ISCMessage(channel, data, jmsMessage.getJMSMessageID());
    }

    public ISCMessage iscMessage(Message jmsMessage, String channel) throws Exception {
        Object data = null;
        if (jmsMessage instanceof BytesMessage) {
            data = "Not Yet Implemented";
        } else if (jmsMessage instanceof MapMessage) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            Enumeration e = ((MapMessage)jmsMessage).getMapNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                map.put(key, ((MapMessage)jmsMessage).getObject(key));
            }
            data = map;
        } else if (jmsMessage instanceof ObjectMessage) {
            data = ((ObjectMessage)jmsMessage).getObject();
        } else if (jmsMessage instanceof StreamMessage) {
            data = "Not Yet Implemented";
        } else if (jmsMessage instanceof TextMessage) {
            data = ((TextMessage)jmsMessage).getText();
        }
        log.debug((Object)("Decoded jmsMessage for channel: " + channel + " data"), data);
        return new ISCMessage(channel, data, jmsMessage.getJMSMessageID());
    }

    public Message jmsMessage(Serializable payload) throws Exception {
        return this.topicSession.createObjectMessage(payload);
    }
}

