/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.tools;

import com.isomorphic.base.Base;
import com.isomorphic.datasource.DSField;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.DataSourceManager;
import com.isomorphic.log.Logger;
import com.isomorphic.tools.DataImport;
import com.isomorphic.util.DataTools;
import com.isomorphic.util.ErrorReport;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BatchUpload
extends Base {
    private static Logger log = new Logger(BatchUpload.class.getName());

    public DSResponse batchUpload(DSRequest dsRequest) throws Exception {
        String quoteString;
        String dsName = (String)dsRequest.getValues().get("dsName");
        DataSource ds = DataSourceManager.getDataSource((String)dsName, (DSRequest)dsRequest);
        HashMap<Object, String> columnMap = new HashMap<Object, String>();
        for (String fieldName : ds.getFieldNames()) {
            String title;
            DSField field = ds.getField(fieldName);
            if (field.get((Object)"uploadFieldName") != null) {
                columnMap.put(field.get((Object)"uploadFieldName"), fieldName);
            } else {
                columnMap.put(fieldName, fieldName);
            }
            if ((title = (String)field.get((Object)"title")) == null || columnMap.containsValue(title)) continue;
            columnMap.put(title, fieldName);
        }
        HashMap<String, List> data = new HashMap<String, List>();
        InputStream is = dsRequest.getUploadedFileStream("file");
        String delimiter = (String)dsRequest.getValues().get("delimiter");
        if (delimiter == null) {
            delimiter = ",";
        }
        if ((quoteString = (String)dsRequest.getValues().get("quoteString")) == null) {
            quoteString = "\"";
        }
        DataImport di = new DataImport(1, delimiter, quoteString);
        String encoding = dsRequest.getHttpServletRequest().getCharacterEncoding();
        if (encoding == null) {
            encoding = "UTF-8";
        }
        List rows = di.importToRows((Reader)new InputStreamReader(is, encoding), columnMap);
        log.debug((Object)("Rows: " + DataTools.prettyPrint((Object)rows)));
        List errors = this.validateRows(rows, ds);
        data.put("gridRows", rows);
        if (errors.size() != 0) {
            data.put("errors", errors);
        }
        DSResponse dsResponse = new DSResponse(ds);
        dsResponse.setData(data);
        return dsResponse;
    }

    private List validateRows(List rows, DataSource ds) throws Exception {
        List fieldNames = ds.getFieldNames();
        ArrayList errors = new ArrayList();
        int rowNum = 0;
        for (Map row : rows) {
            ErrorReport er = ds.validate(row, true, true);
            if (er != null) {
                HashMap<String, Serializable> rowError = new HashMap<String, Serializable>();
                errors.add(rowError);
                HashMap errorObj = new HashMap();
                rowError.put("errors", errorObj);
                rowError.put("rowNum", new Integer(rowNum));
                for (String fieldName : fieldNames) {
                    List error = er.getErrors(fieldName);
                    if (error == null || error.size() <= 0) continue;
                    ArrayList errorStrings = new ArrayList();
                    for (Map m : error) {
                        errorStrings.add(m.get("errorMessage"));
                    }
                    errorObj.put(fieldName, errorStrings);
                }
            }
            ++rowNum;
        }
        return errors;
    }
}

