/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.tools.doclets;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.Tag;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;

public class IsoGlobal {
    private static PrintStream out = System.out;
    public static final String OPTION_VISIBILITY = "-visibility";
    public static final String TAG_VISIBILITY = "visibility";
    public static final String VISIBILITY_INTERNAL = "internal";
    public static final String VISIBILITY_EXTERNAL = "external";
    private static List visibilityList = new ArrayList();
    private static boolean visibilityInternal = false;

    public static void setVisibility(String visibility) {
        for (String v : visibility.split(",")) {
            String visibilityTag = v.trim();
            if ("".equals(visibilityTag)) continue;
            if (VISIBILITY_INTERNAL.equals(visibilityTag)) {
                visibilityInternal = true;
            }
            visibilityList.add(visibilityTag.toLowerCase());
        }
        if (visibilityInternal) {
            out.println("Internal visibility used - generating all docs.");
        } else {
            if (visibilityList.size() == 0) {
                visibilityList.add(VISIBILITY_EXTERNAL);
            }
            out.println("Visibility tags used: " + visibilityList.toString());
        }
    }

    public static List getVisibleList(List docs) {
        ArrayList<Doc> visibleList = new ArrayList<Doc>();
        for (Doc c : docs) {
            if (!IsoGlobal.isVisible(c)) continue;
            visibleList.add(c);
        }
        return visibleList;
    }

    public static ClassDoc[] excludeNonVisible(ClassDoc[] docs) {
        ArrayList<ClassDoc> visibleList = new ArrayList<ClassDoc>();
        for (ClassDoc doc : docs) {
            if (!IsoGlobal.isVisible((Doc)doc)) continue;
            visibleList.add(doc);
        }
        Object[] d = visibleList.toArray();
        ClassDoc[] visibleArray = new ClassDoc[d.length];
        for (int i = 0; i < d.length; ++i) {
            visibleArray[i] = (ClassDoc)d[i];
        }
        return visibleArray;
    }

    public static boolean isVisible(Doc item) {
        Tag[] visibilityTags = item.tags(TAG_VISIBILITY);
        if (visibilityInternal) {
            return true;
        }
        for (Tag tag : visibilityTags) {
            for (String v : tag.text().split(",")) {
                String visibilityTag = v.trim().toLowerCase();
                if (!visibilityList.contains(visibilityTag)) continue;
                return true;
            }
        }
        return false;
    }
}

