/*
 * Isomorphic SmartGWT web presentation layer
 * Copyright 2000 and beyond Isomorphic Software, Inc.
 *
 * OWNERSHIP NOTICE
 * Isomorphic Software owns and reserves all rights not expressly granted in this source code,
 * including all intellectual property rights to the structure, sequence, and format of this code
 * and to all designs, interfaces, algorithms, schema, protocols, and inventions expressed herein.
 *
 *  If you have any questions, please email <sourcecode@isomorphic.com>.
 *
 *  This entire comment must accompany any portion of Isomorphic Software source code that is
 *  copied or moved from this file.
 */

package com.smartgwt.sample.showcase.client;

import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.ui.RootPanel;
import com.smartgwt.client.Version;
import com.smartgwt.client.core.KeyIdentifier;
import com.smartgwt.client.types.Alignment;
import com.smartgwt.client.types.Overflow;
import com.smartgwt.client.types.VerticalAlignment;
import com.smartgwt.client.util.Page;
import com.smartgwt.client.util.SC;
import com.smartgwt.client.util.AutoTest;
import com.smartgwt.client.widgets.Canvas;
import com.smartgwt.client.widgets.Label;
import com.smartgwt.client.widgets.Window;
import com.smartgwt.client.widgets.events.DrawEvent;
import com.smartgwt.client.widgets.events.DrawHandler;
import com.smartgwt.client.widgets.events.ResizedEvent;
import com.smartgwt.client.widgets.events.ResizedHandler;
import com.smartgwt.client.widgets.events.VisibilityChangedEvent;
import com.smartgwt.client.widgets.events.VisibilityChangedHandler;
import com.smartgwt.client.widgets.grid.events.RecordDoubleClickEvent;
import com.smartgwt.client.widgets.grid.events.RecordDoubleClickHandler;
import com.smartgwt.client.widgets.layout.HLayout;
import com.smartgwt.client.widgets.layout.HStack;
import com.smartgwt.client.widgets.layout.Layout;
import com.smartgwt.client.widgets.layout.LayoutSpacer;
import com.smartgwt.client.widgets.layout.VLayout;
import com.smartgwt.client.widgets.layout.VStack;
import com.smartgwt.client.widgets.menu.Menu;
import com.smartgwt.client.widgets.menu.MenuItem;
import com.smartgwt.client.widgets.menu.MenuItemIfFunction;
import com.smartgwt.client.widgets.menu.events.ClickHandler;
import com.smartgwt.client.widgets.menu.events.MenuItemClickEvent;
import com.smartgwt.client.widgets.tab.Tab;
import com.smartgwt.client.widgets.tab.TabSet;
import com.smartgwt.client.widgets.tab.events.TabSelectedEvent;
import com.smartgwt.client.widgets.tab.events.TabSelectedHandler;
import com.smartgwt.client.widgets.toolbar.ToolStrip;
import com.smartgwt.client.widgets.tree.Tree;
import com.smartgwt.client.widgets.tree.TreeNode;
import com.smartgwt.client.widgets.tree.events.NodeClickEvent;
import com.smartgwt.client.widgets.tree.events.NodeClickHandler;
import com.smartgwt.sample.showcase.client.data.CommandTreeNode;
import com.smartgwt.sample.showcase.client.data.ExplorerTreeNode;
import com.smartgwt.sample.showcase.client.data.FolderTreeNode;

/**
 * Entry point classes define <code>onModuleLoad()</code>.
 */
public class Showcase implements EntryPoint {
	
SCConstants scConstants = (SCConstants)GWT.create(SCConstants.class);
private boolean isc_websiteMode = scConstants.websiteMode();

	private HLayout hLayout;
	private HLayout topPane;
	private Canvas canvas;
	private VStack rightPane;
	private HStack bottomPane;
	private HLayout bottomPaneLeft;
	private HLayout bottomPaneRight;
    private TabSet mainTabSet;
    private SideNavTree sideNav;
    private Menu contextMenu;

    public static String getSGWTProductName() {
        String editionString = "";
        if (isEEOrEnterpriseEval()) editionString = " EE";
        else if (isProEdition())    editionString = " Pro Edition";
        else if (isPowerEdition())  editionString = " Power Edition";
        return "Smart GWT" + editionString;
    }

    private static boolean isEEOrEnterpriseEval() {
        final String licenseType = SC.getLicenseType();
        return ("Enterprise".equals(licenseType) || "Eval".equals(licenseType) || licenseType.startsWith("Eval") ||
                "AllModules".equals(licenseType));
    }

    private static boolean isProEdition() {
        return SC.getLicenseType().startsWith("Pro");
    }

    private static boolean isPowerEdition() {
        return SC.getLicenseType().startsWith("Power");
    }

    public static boolean hasBatchUploader() {
        return (isEEOrEnterpriseEval() || isPowerEdition());
    }

    public static boolean hasClientExport() {
        return (isEEOrEnterpriseEval() || isPowerEdition());
    }

    public static boolean hasServerAdvancedFiltering() {
        return isEEOrEnterpriseEval();
    }

    public static boolean hasSQLTemplating() {
        return isEEOrEnterpriseEval();
    }

    public static boolean hasTransactionChaining() {
        return isEEOrEnterpriseEval();
    }
    
    public void onModuleLoad() {
        String isc_websiteModeParam = com.google.gwt.user.client.Window.Location.getParameter("isc_websiteMode");
        if(isc_websiteModeParam!=null) {
        	isc_websiteMode = Boolean.parseBoolean(isc_websiteModeParam);
        }

        final String initToken = History.getToken();

        //setup overall layout / viewport
        VLayout main = new VLayout() {
            {
                setID("isc_Showcase_1_0");
            }

            protected void onInit() {
                super.onInit();
                onHistoryChanged(initToken);
                /*if (initToken != null && initToken.length() != 0) {
                    onHistoryChanged(initToken);
                }*/
            }
        };

        main.setWidth100();
        main.setHeight100();
        main.setLayoutMargin(5);
        main.setStyleName("tabSetContainer");

        topPane = new HLayout();
        topPane.setHeight100();
        topPane.setOverflow(Overflow.HIDDEN);
        
        hLayout = new HLayout();
        hLayout.setResizeBarTarget("next");
        hLayout.setOverflow(Overflow.HIDDEN);

        VLayout sideNavLayout = new VLayout();
        sideNavLayout.setHeight100();
        sideNavLayout.setWidth(290);
        sideNavLayout.setShowResizeBar(true);

        sideNav = new SideNavTree();
        sideNav.setID("isc_SideNavTree_0");
        sideNav.addNodeClickHandler(new NodeClickHandler() {
            public void onNodeClick(NodeClickEvent event) {
                TreeNode node = event.getNode();
                showSample(node);
            }
        });
        
        // open example tree completely for automated test framework
        if (ShowcaseConfiguration.getSingleton().isOpenForTesting()) {
            sideNav.getData().openAll();
        }

        sideNavLayout.addMember(sideNav);
        
        ToolStrip toolStripVersion = new ToolStrip();
        Label version = new Label("Version: "+Version.getVersion()+"  (built "+Version.getBuildDate()+")");
        version.setWidth100();
        version.setPadding(5);
        toolStripVersion.addMember(version);
        sideNavLayout.addMember(toolStripVersion);
        
        hLayout.addMember(sideNavLayout);

        mainTabSet = new TabSet();
        mainTabSet.setWidth100();
        mainTabSet.setHeight100();

        Layout paneContainerProperties = new Layout();
        paneContainerProperties.setLayoutMargin(0);
        paneContainerProperties.setLayoutTopMargin(1);
        mainTabSet.setPaneContainerProperties(paneContainerProperties);

        mainTabSet.setWidth100();
        mainTabSet.setHeight100();
        mainTabSet.addTabSelectedHandler(new TabSelectedHandler() {
            public void onTabSelected(TabSelectedEvent event) {
                Tab selectedTab = event.getTab();

                Canvas pane = selectedTab.getPane();
                if (pane instanceof ShowcasePanel) {
                    ShowcasePanel panel =(ShowcasePanel)pane;
                    Canvas viewPanel = panel.viewPanel;
                    AutoTest.setTestRoot(panel.shouldWrapViewPanel() ? 
                                         viewPanel.getParentElement() : viewPanel);
                }

                String historyToken = selectedTab.getAttribute("historyToken");
                if (historyToken != null) {
                    History.newItem(historyToken, false);
                } else {
                    History.newItem("main", false);
                }
            }
        });

        Tab tab = new Tab();
        tab.setTitle(getSGWTProductName() + " Showcase&nbsp;&nbsp;");
        tab.setIcon("silk/database_connect.png");

        ShowcaseGrid tocGrid = new ShowcaseGrid();
        tocGrid.setHeight100();
        tocGrid.setWidth100();

        tocGrid.addRecordDoubleClickHandler(new RecordDoubleClickHandler() {
            public void onRecordDoubleClick(RecordDoubleClickEvent event) {
                TreeNode node = (TreeNode) event.getRecord();
                showSample(node);
            }
        });

        HLayout mainPanel = new HLayout();
        mainPanel.setHeight100();
        mainPanel.setWidth100();

        if (SC.hasFirebug()) {
            Label label = new Label();
            label.setContents("<p>Firebug can make the Showcase application run slowly.</p><p>For the best performance, we suggest disabling Firebug for this site. Note: You may need to restart Firefox after closing Firebug.</p>");
            label.setWidth100();
            label.setHeight("auto");
            label.setMargin(20);
            Window fbWindow = new Window();
            fbWindow.setHeaderIcon("silk/bug.png", 16, 16);
            fbWindow.setTitle("Firebug Detected");
            fbWindow.addItem(label);
            fbWindow.setWidth(220);
            fbWindow.setHeight(130);

            LayoutSpacer spacer = new LayoutSpacer();
            spacer.setWidth100();
            mainPanel.addMember(spacer);
            mainPanel.addMember(fbWindow);
        }
        
        mainPanel.addChild(tocGrid);

        contextMenu = createContextMenu();
        tab.setPane(mainPanel);

        mainTabSet.addTab(tab);

        canvas = new Canvas();
        canvas.setBackgroundImage("[SKIN]/shared/background.gif");
        canvas.setWidth100();
        canvas.setHeight100();
        canvas.addChild(mainTabSet);

        // Build and add the rightPane, with callToAction buttons
        rightPane = new VStack();
        rightPane.setDefaultLayoutAlign(Alignment.CENTER);
        rightPane.setOverflow(Overflow.HIDDEN);
        rightPane.setWidth(234);
        rightPane.hide();
                
        // Add bottomPane
        bottomPaneLeft = new HLayout();
        bottomPaneLeft.setWidth("50%");
        bottomPaneLeft.setHeight(30);
        bottomPaneLeft.setAlign(Alignment.LEFT);
        bottomPaneLeft.setLayoutLeftMargin(10);
        bottomPaneLeft.setMembersMargin(10);
        
        bottomPaneRight = new HLayout();
        bottomPaneRight.setWidth("50%");
        bottomPaneRight.setHeight(30);
        bottomPaneRight.setAlign(Alignment.RIGHT);
        bottomPaneRight.setLayoutLeftMargin(10);

        bottomPane = new HStack();
        bottomPane.addMember(bottomPaneLeft);
        bottomPane.addMember(bottomPaneRight);
        bottomPane.setOverflow(Overflow.HIDDEN);
        bottomPane.setHeight(30);
        bottomPane.setWidth100();
        bottomPane.setStyleName("explorerBottomPane");
        bottomPane.hide();
        
        // Right Pane buttons
        // SmartGWT Call to action button in right panel
        Layout smartGwtButtonBoxR = new Layout();
        smartGwtButtonBoxR.setStyleName("explorerButtonBoxR");
        smartGwtButtonBoxR.setWidth(200);
        rightPane.addMember(smartGwtButtonBoxR);
        
        Label smartGwtButtonR = new Label("<div style='font-size: 9pt;''>Prefer to write UI in JavaScript?</div>" +
					"<img src='images/icon_javascript_t.png'" +
						"style='height: 30pt; float: left; margin-right: 2pt; " +
					"margin-left: 2pt; margin-top: 10pt;'/>" +
					"<a target='_top' style='line-height: 12pt; padding-top: 5pt;' "+
					"href='" + "/#Welcome" + "' " +
					">" + "SmartClient<br/>Hands-On Demo" + "</a>");
        smartGwtButtonR.setStyleName("darkgrey_Ebutton ERbutton");
        smartGwtButtonR.setWidth(200);
        smartGwtButtonR.setHeight(1);
        smartGwtButtonR.setAlign(Alignment.CENTER);
        smartGwtButtonR.setValign(VerticalAlignment.CENTER);
        smartGwtButtonBoxR.addMember(smartGwtButtonR);
        
        // Contact Us Call to action button in right panel
        Layout contactUsButtonBoxR = new Layout();
        contactUsButtonBoxR.setStyleName("explorerButtonBoxR explorerButtonBoxGradient");
        contactUsButtonBoxR.setWidth(200);
        rightPane.addMember(contactUsButtonBoxR);
        
        Label contactUsButtonR = new Label("<div>Got questions?" +
        		  "<div style='font-size: 8pt;'>We'd love to hear from you!</div>" +
        		  "</div>" +
					"<a target='_top' href='" + "/company/contact.jsp" + "' " +
					">" + "Contact Us" + "</a>");
        contactUsButtonR.setStyleName("darkgrey_Ebutton ERbutton");
        contactUsButtonR.setWidth(200);
        contactUsButtonR.setHeight(1);
        contactUsButtonR.setAlign(Alignment.CENTER);
        contactUsButtonR.setValign(VerticalAlignment.CENTER);
        contactUsButtonBoxR.addMember(contactUsButtonR);

        // Free Trial Call to action button in right panel
        Layout freeTrialButtonBoxR = new Layout();
        freeTrialButtonBoxR.setStyleName("explorerButtonBoxR explorerButtonBoxGradient");
        freeTrialButtonBoxR.setWidth(200);
        rightPane.addMember(freeTrialButtonBoxR);
        
        Label freeTrialButtonR = new Label("<div>Try it out for yourself!</div>" +
        			"<a target='_top' style='line-height: 12pt; padding-top: 5pt;' " +
        			"href='" + "/product/download.jsp" + "' " +
        			">" + "Free Trial<br/><span style='font-size: 8pt;'>60 days</span>" + "</a>");
        freeTrialButtonR.setStyleName("blue_Ebutton ERbutton");
        freeTrialButtonR.setWidth(200);
        freeTrialButtonR.setHeight(1);
        freeTrialButtonR.setAlign(Alignment.CENTER);
        freeTrialButtonR.setValign(VerticalAlignment.CENTER);
        freeTrialButtonBoxR.addMember(freeTrialButtonR);

        // Pricing Call to action button in right panel
        Layout pricingTrialButtonBoxR = new Layout();
        pricingTrialButtonBoxR.setStyleName("explorerButtonBoxR explorerButtonBoxGradient");
        pricingTrialButtonBoxR.setWidth(200);
        rightPane.addMember(pricingTrialButtonBoxR);
        
        Label pricingTrialButtonR = new Label("<div>Want your own?</div>" +
				"<a target='_top' href='" + "/product/" + "' " +
				">" + "Editions & Pricing" + "</a>");
        pricingTrialButtonR.setStyleName("orange_Ebutton ERbutton");
        pricingTrialButtonR.setWidth(200);
        pricingTrialButtonR.setHeight(1);
        pricingTrialButtonR.setAlign(Alignment.CENTER);
        pricingTrialButtonR.setValign(VerticalAlignment.CENTER);
        pricingTrialButtonBoxR.addMember(pricingTrialButtonR);

        // Learn More Call to action button in right panel
        Layout learnMoreButtonBoxR = new Layout();
        learnMoreButtonBoxR.setStyleName("explorerButtonBoxR explorerButtonBoxGradient");
        learnMoreButtonBoxR.setWidth(200);
        rightPane.addMember(learnMoreButtonBoxR);
        
        Label learnMoreButtonR = new Label("<div>Isomorphic has the advantage.</div>" +
				"<a target='_top' href='" + "/technology/whysmart.jsp" + "' " +
				">" + "Learn More >" + "</a>");
        learnMoreButtonR.setStyleName("darkgrey_Ebutton ERbutton");
        learnMoreButtonR.setWidth(200);
        learnMoreButtonR.setHeight(1);
        learnMoreButtonR.setAlign(Alignment.CENTER);
        learnMoreButtonR.setValign(VerticalAlignment.CENTER);
        learnMoreButtonBoxR.addMember(learnMoreButtonR);
        
        // Bottom Pane buttons
        // Free Trial Call to action button in bottom panel
        Label freeTrialButtonB = new Label("<a target='_top' href='/product/download.jsp' " +
    			">Free Trial</a>");
        freeTrialButtonB.setStyleName("blue_Ebutton EBbutton");
        bottomPaneLeft.addMember(freeTrialButtonB);
        
        // Pricing Call to action button in bottom panel
        Label pricingButtonB = new Label("<a target='_top' href='/product/' " +
			">Editions & Pricing</a>");
        pricingButtonB.setStyleName("orange_Ebutton EBbutton");
        bottomPaneLeft.addMember(pricingButtonB);

        // SmartGWT Call to action button in bottom panel
        Label smartGWTButtonPreB = new Label("<span>Prefer to write UI in JavaScript?</span>");
        smartGWTButtonPreB.setStyleName("EBbutton");
        smartGWTButtonPreB.setWidth("220pt");
        bottomPaneRight.addMember(smartGWTButtonPreB);
        Label smartGWTButtonB = new Label("<a target='_top' style='width: 130pt;' " +
			"href='/#Welcome'" +
			" >SmartClient Live Demo</a>");
        smartGWTButtonB.setStyleName("darkgrey_Ebutton EBbutton");
        bottomPaneRight.addMember(smartGWTButtonB);
        
        hLayout.addMember(canvas);
        topPane.addMember(hLayout);
        topPane.addMember(rightPane);
        main.addMember(topPane);
        main.addMember(bottomPane);
        
        main.addDrawHandler(new DrawHandler() {
			@Override
			public void onDraw(DrawEvent event) {
				pageRedrawn();
			}
		});
                
        main.addResizedHandler(new ResizedHandler() {
			@Override
			public void onResized(ResizedEvent event) {
				pageResized();
			}
		});
        
        rightPane.addVisibilityChangedHandler(new VisibilityChangedHandler() {
			@Override
			public void onVisibilityChanged(VisibilityChangedEvent event) {
				rightPaneVisibilityChanged(event.getIsVisible());
			}
		});

        main.draw();

        // Add history listener
        History.addValueChangeHandler(new ValueChangeHandler<String>() {
            @Override
            public void onValueChange(ValueChangeEvent<String> event) {
                onHistoryChanged(event.getValue());
            }
        });

        RootPanel.get("loadingMsg").getElement().setInnerHTML("");
    }
	private void pageRedrawn() {
    	if(isc_websiteMode==true) {
			hLayout.setShowResizeBar(true);
			// If browser width > 900px, show right, else show bottom
			if(Page.getWidth()>900) {
				rightPane.show();
				bottomPane.hide();
			} else {
				bottomPane.show();
				rightPane.hide();
			}
		}
	}

    private void rightPaneVisibilityChanged(boolean isVisible) {
    	if(isc_websiteMode==true) {
    		if(Page.getWidth()<=900) {
    			rightPane.hide();
    			bottomPane.show();
    			return;
    		}
    		if(isVisible) {
    			canvas.setHeight100();
    			bottomPane.hide();
    			rightPane.show();
    		} else {
    			canvas.setHeight(hLayout.getHeight()-bottomPane.getHeight());
    			bottomPane.show();
    			rightPane.hide();
    		}
    	}
    }
    
    private void pageResized() {
    	if(isc_websiteMode==true) {
    		if(hLayout!=null && Page.getWidth()<=900) {
    			if(hLayout.getShowResizeBar()) {
    				rightPane.hide();
    				bottomPane.show();
    			} else {
    				rightPane.show();
    				bottomPane.hide();    				
    			}
    		}
    	}
    }
    
    private Menu createContextMenu() {
        Menu menu = new Menu();
        menu.setWidth(140);

        MenuItemIfFunction enableCondition = new MenuItemIfFunction() {
            public boolean execute(Canvas target, Menu menu, MenuItem item) {
                int selectedTab = mainTabSet.getSelectedTabNumber();
                return selectedTab != 0;
            }
        };

        MenuItem closeItem = new MenuItem("<u>C</u>lose");
        closeItem.setEnableIfCondition(enableCondition);
        closeItem.setKeyTitle("Alt+C");
        KeyIdentifier closeKey = new KeyIdentifier();
        closeKey.setAltKey(true);
        closeKey.setKeyName("C");
        closeItem.setKeys(closeKey);
        closeItem.addClickHandler(new ClickHandler() {
            public void onClick(MenuItemClickEvent event) {
                int selectedTab = mainTabSet.getSelectedTabNumber();
                mainTabSet.removeTab(selectedTab);
                mainTabSet.selectTab(selectedTab - 1);
            }
        });

        MenuItem closeAllButCurrent = new MenuItem("Close All But Current");
        closeAllButCurrent.setEnableIfCondition(enableCondition);
        closeAllButCurrent.addClickHandler(new ClickHandler() {
            public void onClick(MenuItemClickEvent event) {
                int selected = mainTabSet.getSelectedTabNumber();
                Tab[] tabs = mainTabSet.getTabs();
                int[] tabsToRemove = new int[tabs.length - 2];
                int cnt = 0;
                for (int i = 1; i < tabs.length; i++) {
                    if (i != selected) {
                        tabsToRemove[cnt] = i;
                        cnt++;
                    }
                }
                mainTabSet.removeTabs(tabsToRemove);
            }
        });

        MenuItem closeAll = new MenuItem("Close All");
        closeAll.setEnableIfCondition(enableCondition);
        closeAll.addClickHandler(new ClickHandler() {
            public void onClick(MenuItemClickEvent event) {
                Tab[] tabs = mainTabSet.getTabs();
                int[] tabsToRemove = new int[tabs.length - 1];

                for (int i = 1; i < tabs.length; i++) {
                    tabsToRemove[i - 1] = i;
                }
                mainTabSet.removeTabs(tabsToRemove);
                mainTabSet.selectTab(0);
            }
        });

        menu.setItems(closeItem, closeAllButCurrent, closeAll);
        return menu;
    }

    protected void showSample(TreeNode node) {
        boolean isExplorerTreeNode = node instanceof ExplorerTreeNode;
        if (node instanceof CommandTreeNode) {
            CommandTreeNode commandTreeNode = (CommandTreeNode) node;
            commandTreeNode.getCommand().execute();
        } else if (node instanceof FolderTreeNode && sideNav.getTree().hasChildren(node)) {
            FolderTreeNode folderTreeNode  = (FolderTreeNode) node;
            String panelID = folderTreeNode.getNodeID();
            Tab tab = null;
            if (panelID != null) {
                String tabID = panelID + "_tab";
                tab = mainTabSet.getTab(tabID);
            }
            if (tab == null) {
                tab = new Tab();
                tab.setID(folderTreeNode.getNodeID() + "_tab");
                //store history token on tab so that when an already open is selected, one can retrieve the
                //history token and update the URL
                tab.setAttribute("historyToken", folderTreeNode.getNodeID());
                tab.setContextMenu(contextMenu);

                String folderName = folderTreeNode.getName();
                String icon = folderTreeNode.getIcon();
                if (icon == null) {
                    icon = "silk/plugin.png";
                }
                String imgHTML = Canvas.imgHTML(icon, 16, 16);
                tab.setTitle("<span>" + imgHTML + "&nbsp;" + folderName + "</span>");
                
                Window window = new Window();
                window.setTitle(tab.getTitle());
                window.setWidth(500);
                window.setHeight(375);
                window.setKeepInParentRect(true);
                window.setTop(30);
                window.setLeft(30);
                window.setCanDragResize(true);
                
                if (folderTreeNode.getDescription() != null) {
                    String descriptionText = "<p class='intro-para'>" + folderTreeNode.getDescription() + "</p>";
                    Canvas descriptionCanvas = new Canvas();
                    descriptionCanvas.setPadding(10);
                    descriptionCanvas.setContents(descriptionText);
                    window.addItem(descriptionCanvas);
                }
                
                TreeNode[] children = sideNav.getTree().getChildren(node);
                for (TreeNode l: children) {
                    System.out.println("leave: " + l.getName());
                }
                int numRows = (int) Math.round(children.length / 2f);
                StringBuffer buf = new StringBuffer();
                int firstColIndex = 0;
                int secondColIndex = numRows;
                buf.append("<table class='explorerFolderList' align='center' cellSpacing='5'>");
                for (int i = 0; i < numRows; i++) {    
                    ExplorerTreeNode node1 = (ExplorerTreeNode) children[firstColIndex++];
                    ExplorerTreeNode node2 = (secondColIndex < children.length ? (ExplorerTreeNode) children[secondColIndex++] : null);
                    
                    this._htmlForCell(node1, buf);
                    buf.append("<td width=10>&nbsp;</td>");
                    this._htmlForCell(node2, buf);
                    buf.append("</tr>");
                }
                buf.append("</table>");
                
                Canvas tableCanvas = new Canvas();
                tableCanvas.setPadding(10);
                tableCanvas.setContents(buf.toString());
                window.addItem(tableCanvas);
                
                VLayout panel = new VLayout();
                panel.addChild(window);
                tab.setPane(panel);
                
                tab.setCanClose(true);
                mainTabSet.addTab(tab);
                mainTabSet.selectTab(tab);
            } else {
                mainTabSet.selectTab(tab);
            }
            History.newItem(folderTreeNode.getNodeID(), false);
        } else if (isExplorerTreeNode) {
            ExplorerTreeNode explorerTreeNode = (ExplorerTreeNode) node;
            PanelFactory factory = explorerTreeNode.getFactory();
            if (factory != null) {
                String panelID = factory.getID();
                Tab tab = null;
                if (panelID != null) {
                    String tabID = panelID + "_tab";
                    tab = mainTabSet.getTab(tabID);
                }
                if (tab == null) {
                    boolean autotest = ShowcaseConfiguration.getSingleton().isOpenForTesting();
                    final Canvas panel;
                    if (autotest) {
                        panel = SampleResultsManager.create(mainTabSet, factory);
                    } else if (factory instanceof AdvancedPanelFactory) {
                        final AdvancedPanelFactory advancedFactory = (AdvancedPanelFactory)factory;
                        panel = (advancedFactory.isEnabled() ? advancedFactory.create() : advancedFactory.getDisabledViewPanel());
                    } else {
                        panel = factory.create();
                    }
                    tab = new Tab();
                    tab.setID(factory.getID() + "_tab");
                    //store history token on tab so that when an already open is selected, one can retrieve the
                    //history token and update the URL
                    tab.setAttribute("historyToken", explorerTreeNode.getNodeID());
                    tab.setContextMenu(contextMenu);

                    String sampleName = explorerTreeNode.getName();


                    String icon = explorerTreeNode.getIcon();
                    if (icon == null) {
                        icon = "silk/plugin.png";
                    }
                    String imgHTML = Canvas.imgHTML(icon, 16, 16);
                    tab.setTitle("<span>" + imgHTML + "&nbsp;" + sampleName + "</span>");
                    tab.setPane(panel);
                    tab.setCanClose(true);
                    mainTabSet.addTab(tab);
                    mainTabSet.selectTab(tab);
                } else {
                    mainTabSet.selectTab(tab);
                }
                History.newItem(explorerTreeNode.getNodeID(), false);
            } else if ((explorerTreeNode.getNodeID() != null) && (explorerTreeNode.getNodeID().equals("doc_category"))) {
                mainTabSet.selectTab(0);
            }
        }
    }

    private void _htmlForCell(ExplorerTreeNode node, StringBuffer buf) {
        if (node == null) {
            buf.append("<td>&nbsp;</td>");
            return;
        }
        
        String icon = node.getIcon() != null ? node.getIcon() : "silk/plugin.png";
        String imgHTML = Canvas.imgHTML(icon, 16, 16);
        
        buf.append("<td>");
        buf.append(imgHTML);
        buf.append("&nbsp;");
        buf.append("<a target='_top' href='#" + node.getNodeID() + "'>" + node.getName() + "</a>");
        buf.append("</td>");
    }
    
    private void onHistoryChanged(String historyToken) {
        if (historyToken == null || historyToken.length() == 0 || historyToken.equalsIgnoreCase("main")) {
            mainTabSet.selectTab(0);
            sideNav.selectRecord(0);
        } else {
            ExplorerTreeNode[] showcaseData = sideNav.getShowcaseData();
            for (ExplorerTreeNode explorerTreeNode : showcaseData) {
                if (explorerTreeNode.getNodeID().equals(historyToken)) {
                    showSample(explorerTreeNode);
                    sideNav.selectRecord(explorerTreeNode);
                    Tree tree = sideNav.getData();
                    TreeNode categoryNode = tree.getParent(explorerTreeNode);

                    while (categoryNode != null && !"/".equals(tree.getName(categoryNode))) {
                        tree.openFolder(categoryNode);
                        categoryNode = tree.getParent(categoryNode);
                    }
                }
            }
        }
    }
}
