
/*

  SmartClient Ajax RIA system
  Version v9.1p_2021-05-18/LGPL Deployment (2021-05-18)

  Copyright 2000 and beyond Isomorphic Software, Inc. All rights reserved.
  "SmartClient" is a trademark of Isomorphic Software, Inc.

  LICENSE NOTICE
     INSTALLATION OR USE OF THIS SOFTWARE INDICATES YOUR ACCEPTANCE OF
     ISOMORPHIC SOFTWARE LICENSE TERMS. If you have received this file
     without an accompanying Isomorphic Software license file, please
     contact licensing@isomorphic.com for details. Unauthorized copying and
     use of this software is a violation of international copyright law.

  DEVELOPMENT ONLY - DO NOT DEPLOY
     This software is provided for evaluation, training, and development
     purposes only. It may include supplementary components that are not
     licensed for deployment. The separate DEPLOY package for this release
     contains SmartClient components that are licensed for deployment.

  PROPRIETARY & PROTECTED MATERIAL
     This software contains proprietary materials that are protected by
     contract and intellectual property law. You are expressly prohibited
     from attempting to reverse engineer this software or modify this
     software for human readability.

  CONTACT ISOMORPHIC
     For more information regarding license rights and restrictions, or to
     report possible license violations, please contact Isomorphic Software
     by email (licensing@isomorphic.com) or web (www.isomorphic.com).

*/
//> @groupDef jUnitSeleniumRC
//
// <div style="width:600px">
//
// Let's take a look at some JUnit code designed to test a standalone version of the
// <smartclient>
// +externalLink{http://localhost:8080/isomorphic/system/reference/SmartClient_Explorer.html#treesEditing, SmartClient Showcase: Trees &gt;&gt; Editing} 
// </smartclient>
// <smartgwt>
// +externalLink{http://localhost:8080/index.html#tree_editing, SmartClient Showcase: Trees &gt;&gt; Editing} 
// </smartgwt>
// example.  The overall test class, TreeTest, contains a test, testTree1, targeted at the TreeGrid in the
//  example, and a test, testTree2, targeted at the SearchForm/ListGrid.  As recommended by the official 
// +externalLink{http://seleniumhq.org/docs/08_user_extensions.html, Selenium documentation},  we create 
// the <code>HttpCommandProcessor</code> separately from <code>DefaultSelenium</code> to provide a way to
// invoke the new user extension command <code>waitForElementClickable()</code> which SmartClient defines.
// (See our Selenium User Guide described in +link{automatedTesting}.)
// <P>
// The test class TreeTest was initially generated by exporting the Selenium script for testTree1 in JUnit 4 
// format, but it was modified by hand as mentioned above to support the <code>waitForElementClickable()</code>.
//
// Below we look at the two test cases testTree1 and testTree2.  Note that in each case, we maximize
// the Selenium browser window in accordance with the best practices mentioned in the User Guide.
// <P>
// If you'd like to experiment with making changes to the sample JUnit code, one improvement that simplifies
// things is to add a myClick() function that handles both the <code>waitForElementClickable()</code> and
// the <code>click</code> on a supplied locator.  Even just assigning each unique locator to a local Java 
// variable so it can be reused for multiple calls will make the code simpler to follow and maintain.
//
// <pre>
// import com.thoughtworks.selenium.*;
// import org.junit.After;
// import org.junit.Before;
// import org.junit.Test;
// import java.util.regex.Pattern;
//
// public class TreeTest extends SeleneseTestCase {
//  
//     HttpCommandProcessor proc;
//  
//     void waitForElementClickable(String locator) {
//         String[] locatorArg = {locator};
//         proc.doCommand("waitForElementClickable", locatorArg);   
//     }
//  
//     &#64;Before
//     public void setUp() throws Exception {
//         proc = new HttpCommandProcessor("localhost", 4444, "*chrome",
//             "http://localhost:8080/"); 
//         selenium = new DefaultSelenium(proc);
//         selenium.start();
//     }
//
//     &#64;Test
//     public void testTree1() throws Exception {
//         selenium.open("treeEdit.html");
//         selenium.windowMaximize();
//
//         waitForElementClickable("scLocator=//TreeGrid[ID=\"employeeTree\"]/body/row[EmployeeId=4||Name=Charles%20Madigen||0]/col[fieldName=Name||0]/open");
//         selenium.click("scLocator=//TreeGrid[ID=\"employeeTree\"]/body/row[EmployeeId=4||Name=Charles%20Madigen||0]/col[fieldName=Name||0]/open");
//         waitForElementClickable("scLocator=//TreeGrid[ID=\"employeeTree\"]/body/row[EmployeeId=189||Name=Gene%20Porter||8]/col[fieldName=Name||0]/open");
//         selenium.click("scLocator=//TreeGrid[ID=\"employeeTree\"]/body/row[EmployeeId=189||Name=Gene%20Porter||8]/col[fieldName=Name||0]/open");
//         waitForElementClickable("scLocator=//TreeGrid[ID=\"employeeTree\"]/body/row[EmployeeId=264||Name=Cheryl%20Pearson||Salary=5650||10]/col[fieldName=Salary||2]");
//         verifyEquals("5650", selenium.getText("scLocator=//TreeGrid[ID=\"employeeTree\"]/body/row[EmployeeId=264||Name=Cheryl%20Pearson||Salary=5650||10]/col[fieldName=Salary||2]"));
//
//         checkForVerificationErrors();
//     }
// </pre>
//
// In test testTree1, the idea is to:
// <ul>
//     <li> Open the node for the top level employee, Charles Madigen,
//     <li> Open the node for his report, Gene Porter, and
//     <li> Verify that the Salary of Cheryl Pearson, who reports to Gene, is 5650
// </ul>
// For this test, the locators were generated by Selenium IDE for us but we did modify the code
// to make use of the function <code>waitForElementClickable()</code>.
// <P>
//      Note that though the locator for Cheryl includes the salary, it will match based on the first
// field, EmployeeId, which is the primary key, so the test will correctly compare the contents 
// of Cheryl's salaray against the value 5650 and fail if it doesn't match.  If for some reason 
// your test requires matching a specific field rather than the default fields and ordering
// generated automatically, you can hand edit the locator.
//
// <pre>
// 
//     public void testTree2() throws Exception {
//         selenium.open("treeEdit.html");
//         selenium.windowMaximize();
//
//         // Steps 1-3: Load the ListGrid with Joan's Reports
//         waitForElementClickable("scLocator=//SearchForm[ID="employeeSearchForm"]/item[index=0||Class=PickTreeItem]/button/");
//         selenium.click("scLocator=//SearchForm[ID="employeeSearchForm"]/item[index=0||Class=PickTreeItem]/button/");
//
//         waitForElementClickable("scLocator=//autoID[Class=SelectionTreeMenu||index=8||length=14||classIndex=0||classLength=2||roleIndex=0||roleLength=2||scRole=menu]/body/row[Name=Charles%20Madigen]/col[fieldName=title||0]");
//         selenium.mouseMove("scLocator=//autoID[Class=SelectionTreeMenu||index=8||length=14||classIndex=0||classLength=2||roleIndex=0||roleLength=2||scRole=menu]/body/row[Name=Charles%20Madigen]/col[fieldName=title||0]");
//
//         waitForElementClickable("scLocator=//SelectionTreeMenu[ID=\"isc_SelectionTreeMenu_0_childrenSubMenu_0\"]/body/row[EmployeeId=183]/col[fieldName=title||1]");
//         selenium.click("scLocator=//SelectionTreeMenu[ID=\"isc_SelectionTreeMenu_0_childrenSubMenu_0\"]/body/row[EmployeeId=183]/col[fieldName=title||1]");
// 
//         // Step 4: Sort by salary, descending, and wait for ListGrid to be redrawn with final result
//         waitForElementClickable("scLocator=//ListGrid[ID=\"employeeGrid\"]/header/headerButton[fieldName=Salary]/");
//         selenium.click("scLocator=//ListGrid[ID=\"employeeGrid\"]/header/headerButton[fieldName=Salary]/");
//         waitForElementClickable("scLocator=//ListGrid[ID=\"employeeGrid\"]/header/headerButton[fieldName=Salary]/");
//         selenium.click("scLocator=//ListGrid[ID=\"employeeGrid\"]/header/headerButton[fieldName=Salary]/");
//
//         selenium.waitForGridDone("scLocator=//ListGrid[ID='employeeGrid']");
//
//         // Step 5: Verify the top salary
//         waitForElementClickable("scLocator=//ListGrid[ID=\"employeeGrid\"]/body/row[0]/col[fieldName=Salary||2]");
//         verifyEquals("9400", selenium.getText("scLocator=//ListGrid[ID=\"employeeGrid\"]/body/row[0]/col[fieldName=Salary||2]"));
//
//         checkForVerificationErrors();
//     }
// </pre>
//
// In test testTree2, the idea is to:
// <P>
// 1. Click on the SearchForm button, revealing a Charles Madigen popup,<BR>
// 2. Issue a MouseMove on the Charles Madigen popup, revealing a list of his reports,<BR>
// 3. Click on his report Joan Little, filling the ListGrid with her reports,<BR>
// 4. Click on the salary column header twice, sorting by descending salary, and<BR>
// 5. Verify the salary in the top row (top salary) is 9400<BR>
// <P>
// This test required more hand modification than the previous one.  In particular three modifications were made:
// <ul>
//    <li> A mouseMove command was manually added to the Selenium IDE script,
//    <li> A call to <code>waitForGridDone()</code> was added to assure the sorting was done before we ran verifyText, and
//    <li> We manually removed all but row qualifier from the automatically generated scLocator for step &#35;5.
// </ul>
// 
// The first modification is required because our user extensions don't record mouseMove
// events, and the second is needed to ensure the sorts are complete before verifyText runs--for
// details see the User Guide (described in +link{automatedTesting}).  The final modification is
// just a reflection of what our intent is in step &#35;5; we want to operate on the top row,
// regardless of its contents, so we don't want our locator matching based on the EmployeeId or
// Name fields of the records.  (Matching by EmployeeId in the locator as automatically
// generated would make the test verify that Kelly Fetterman's salary is 9400 rather than that 9400 
// is the highest salary.)
// 
// <pre>
//     &#64;After
//     public void tearDown() throws Exception {
//         selenium.stop();
//     }
// }
// </pre>
// </div>
// @title JUnit + Selenium RC
// @visibility external
//<




//> @groupDef automatedTesting
// SmartClient supports automated testing with a variety of tools.
// <P>
// <h3>Selenium</h3>
// <P>
// SmartClient includes a free, custom Selenium extension for robust record and playback of tests,
// including the ability to record on one browser and play back on others, support for Selenium
// Remote Control allowing tests to be written in a variety of programming languages and run as
// scripts, as well as SmartClient-specific enhancements to the Selenium IDE.
// <P>
// These extensions can be found in the 
// <smartclient><code>smartclientSDK/tools/selenium/</code></smartclient>
// <smartgwt><code>selenium/</code></smartgwt>
// directory and a user guide can be found +link{group:usingSelenium,here}. 
// <P>
// Selenium supports writing test code in any programming language via
// +externalLink{http://seleniumhq.org/projects/remote-control/,Seleniun RC}.  By writing
// Selenium RC test cases in Java, you can drive them from JUnit, hence creating automated
// tests that can be run from the command line or via Continuous Integration servers such as
// Hudson, allowing for running tests on checkins to source control or in overnight batch runs.
// <P>
// Services such as +externalLink{http://saucelabs.com/ondemand,SauceLabs OnDemand} allow you
// to run the actual browsers in the cloud, tunneling back to a private network via an
// encrypted channel, so that you do not need to set up Selenium RC servers with appropriate
// browsers installed.
// <P>
// For apps requiring load testing, also take a look at
// +externalLink{http://browsermob.com,BrowserMob}, which allows you to run Selenium tests with
// thousands of browsers at once against a test deployment.
// <P>
// <b>JUnit + Selenium RC</b>
// <P>
// Explore +link{jUnitSeleniumRC,JUnit + Selenium RC}, where we walk through a JUnit test built
// using Selenium IDE and targeting a SmartClient Showcase example.
// <P>
// <h3>TestRunner</h3>
// <P>
// +link{group:testRunner,TestRunner} is a system for automatically running a suite of Selenium
// tests, commiting the results to a database, and reporting any regressions (or fixes) via email.
// <P>
// <h3>SOASTA</h3>
// <P>
// SOASTA's CloudTest product includes special support for SmartClient with capabilities
// similar to our Selenium extensions, with special emphasis on load testing.  Find out more at
// +externalLink{http://soasta.com}.
// <P>
// <smartgwt>
// <h3>GwtTestCase</h3>
// <P>
// GWT includes a way to run a GWT application under JUnit, running your GWT application in a
// "headless" browser.  This is a very limited testing approach appropriate for certain unit
// tests only - it cannot replace events such as clicks, and it doesn't run in actual browser
// (instead it runs in a simulator called HtmlUnit), which can lead to false failures in a
// variety of areas, including network communication and XML processing, where HtmlUnit's
// behaviors do not correspond to any real browser.
// <p>
// For these reasons, Isomorphic recommends performing substantially all of your tests via
// Selenium, including unit tests.  In particular, if a test fails under HtmlUnit but would not
// fail in a real browser, this will not be regarded as a bug.
// <P>
// If you use GwtTestCase, note that it has a bug where it does not run onModuleLoad() for
// included GWT modules.  To make sure SmartGWT's onModuleLoad() runs, add a
// <code>gwtSetUp()</code> implementation like so:
// <P>
// <pre>
//   public class SgwtTest extends GWTTestCase {
//     	public void gwtSetUp() {
//     		new SmartGwtEntryPoint().onModuleLoad();		
//     	}
//      ...
// </pre>
// <P>
// You may need to add similar manual calls for other GWT modules you inherit which expect to
// have their <code>onModuleLoad()</code> method called normally.
// </smartgwt>
// <P>
// <h3>WebDriver / "Selenium 2"</h3>
// <P>
// WebDriver, which is now part of Selenium 2, uses a different basic architecture in which
// extensions are added to each browser in order to drive tests, instead of doing so from
// JavaScript.
// <P>
// Support for WebDriver-based testing for SmartClient is now available with the same custom
// locator strategies and custom commands as we provide for Selenium 1.0.  However, we continue
// to recommend Selenium 1.0 rather than WebDriver-based Selenium 2, because:
// <P>
// <ol>
// <li> <b>WebDriver is more complex to install</b>: WebDriver requires installing support for
// each browser where you want to run tests, and in some cases multiple WebDriver plugins for
// multiple versions of the browser
// <li> <b>WebDriver has version / browser support issues</b>: Selenium 1.0 generally works
// with any standards-compliant browser.  Because WebDriver requires deeper integration with
// the browser, new browser releases require updated WebDriver extensions.  This is a
// particular issue with the rapid pace of new releases of Firefox, where the WebDriver
// extension becomes disabled by an update of Firefox, but WebDriver test will still run in a
// "non-native" mode that behaves erratically.  Unfortunately, there is <b>no way we can
// detect and warn users about this</b>; this is a general issue with WebDriver and
// Firefox, not specific to SmartClient.
// <li> <b>Mobile testing issues</b>: Mobile testing is supported only for certain devices,
// requires that an application be installed on the devices, doesn't run a normal browser
// (rather an embedded browser window inside an application), which can introduce spurious
// issues during playback.  In contrast, while Selenium RC doesn't support mobile, with
// Selenium 1.0 you can use Selenium Core to test any mobile device that supports JavaScript
// without installation of an app.  Both situations have drawbacks but we feel that Selenium
// 1.0 has an overall advantage over WebDriver here.
// <li> <b>Java skills required</b>: Tests created in Selenium IDE and stored in Selenese can
// be executed by a variety of tools without requiring Java skills, including our own
// +link{group:testRunner}.  Most ways of running WebDriver tests involve Java coding
// skills or at least the ability to work with a Java IDE.  This tends to mean that all QA
// personnel must either have Java skills or drain the time of Java developers on repetitive
// tasks.
// </ol>
// <P>
// Ultimately, our current recommendation is to use Selenium 1.0 and Selenium RC exclusively or
// at least primarily.  If there are critically important tests that you can only build via
// WebDriver (rare: the most common such case is testing file upload - see below), use WebDriver for
// those tests only, or use manual testing for those tests.
// <P>
// <b>WebDriver Usage</b>
// <P>
// When using WebDriver, we recommend using Selenum IDE to record tests, and storing tests in
// Selenese (as with Selenium RC / 1.0).  WebDriver is not normally able to execute Selenese
// tests, but we provide a Java class <code>SeleneseRunner</code> that can be used to:
// <ul>
// <li> execute Selenese directly from the command line
// <li> execute Selenese from inside a Java program (eg, as part of a JUnit test)
// <li> convert a Selenese test to Java code (as a JUnit test)
// </ul>
// See the server-side JavaDoc for com.isomorphic.webdriver.SeleneseRunner for more information
// on how to use these features.
// <p>
// <b>NOTE:</b> Selenium IDE has an option to export tests as WebDriver-compatible code.  <b>Do
// not use</b> this feature, it exports useless code that doesn't understand custom commands,
// custom locators, or other key features of Selenium IDE.  Use SeleneseRunner instead.
// <p>
// <b>WebDriver Classes overview</b>
// <p>
// Storing and executing Selenese tests recorded in the Selenium IDE is recommended as the
// primary approach for using WebDriver.  However, for certain rare tests it can make sense to
// use WebDriver Java support directly.
// <p>
// SmartClient support for WebDriver is based around 3 different Java classes:
// <P>
// <ol>
// <li> <b>ByScLocator</b>: This implements the ability to find WebElements or WebDriver "By"
// objects using SmartClient Locator strings.  See +link{group:usingSelenium} for more
// background on Locator strings and how to obtain them.  Given a locator String, example usage is:
// <pre>
// ByScLocator.scLocator("//ListGrid[ID=\"countryList\"]/body/row[countryCode=US||0]/col[fieldName=countryCode||0]")
// </pre>
// <li> <b>SmartClientWebDriver</b>: This is an abstract class which provides a number of
// different methods for interacting with the browser, such as:
// <ul>
// <li> open a browser at a particular URL
// <li> find the element or elements which match a given "By" object (either ByScLocator, or a
//      standard WebDriver locator)
// <li> perform events and operations (click, drag, select etc)
// <li> perform custom SmartClient validations / state checks, such as whether a grid has
//      loaded data
// </ul>
// Three concrete implementations of SmartClientWebDriver are provided: SmartClientFireFoxDriver,
// SmartClientChromeDriver and SmartClientIEDriver. There is also a SmartClientRemoteWebdriver class
// which allows the injection of a manually configured RemoteWebDriver instance. This might be
// necessary, for example, for use with Selenium Grid.
// <li> <b>ScAction</b>: a SmartClient-specific version of the standard WebDriver
// "Action" class, providing a builder pattern to create a sequence of operations which can
// then be perform()ed.
// </ol>
// <P>
// These classes are packaged in the library isomorphic_webdriver.jar, which can be found
// in WEB-INF/lib-WebDriverSupport (along with several 3rd-party supporting libraries).
// <P>
// General information regarding WebDriver can be found
// +externalLink{http://docs.seleniumhq.org/docs/03_webdriver.jsp#introducing-webdriver, here}. Setup for
// WebDriver is more complex than for classic Selenium: The basic Java package includes drivers
// for FireFox (subject to important version limitations as described above), but additional drivers must
// be downloaded for +externalLink{http://code.google.com/p/chromium/downloads/list, Google Chrome} and 
// +externalLink{http://code.google.com/p/selenium/downloads/list, Internet Explorer}.
// <P>
// <b>File Upload Example Test</b>
// <P>
// As discussed above, one advantage which WebDriver does have over Classic Selenium is the ability
// to test file upload. It is still limited in that if a click is triggered on the file selection button
// an OS native file selection dialog will be triggered in which case the test will be suspended until the
// file is manually selected. To avoid this, the sendKeys() method can be used to enter the file location.
// Two examples of this are given below - one for the SmartClient showcase, and one for SmartGWT:
// <p>
// <pre>
//    &#47;**
//     * The following test runs against localhost and requires a small (< 50k) image to be in /tmp/image.jpg
//     *&#47;
//    public void fileUploadSC() throws Exception {
//        SmartClientFirefoxDriver driver = new SmartClientFirefoxDriver();
//        driver.setBaseUrl("http://localhost:8080/");
//        driver.get("isomorphic/system/reference/SmartClient_Explorer.html#upload");
//        driver.manage().window().maximize();
//
//        final int origSize = driver.findElements(ByScLocator.scLocator("//TileGrid[ID=\"mediaTileGrid\"]/tile")).size();
//
//        By titleInput = ByScLocator.scLocator("//DynamicForm[ID=\"uploadForm\"]/item[name=title||title=Title||index=0|"
//                                             +"|Class=TextItem]/element");
//        driver.click(titleInput);
//        driver.sendKeys(titleInput, "test image: " + origSize);
//        
//        By uploadForm = ByScLocator.scLocator("//DynamicForm[ID=\"uploadForm\"]/");
//        WebElement form = driver.findElement(uploadForm);
//        WebElement findElement = form.findElement(By.xpath("//input[@type='FILE']"));
//        &#47;*
//         * The following causes a native dialog to be created which prevents further progress. Do NOT uncomment!
//         * We just have to sendKeys() to it
//         *&#47;
//        //findElement.click(); 
//        
//        findElement.sendKeys("/tmp/image.jpg"); // A local file. Please change accordingly
//
//        By saveButton = ByScLocator.scLocator(
//                             "//DynamicForm[ID=\"uploadForm\"]/item[title=Save||index=2||Class=ButtonItem]/button/");
//        driver.waitForElementClickable(saveButton);
//        driver.click(saveButton);
//        &#47;*
//         * Note the following fails once the grid contains more than 3 rows of data
//         * as the index becomes inconsistent as tiles scrolled out of site are removed
//         * and the indices change
//         *&#47;                                                        
//        By tile = ByScLocator.scLocator("//TileGrid[ID=\"mediaTileGrid\"]/tile[Class=SimpleTile||index="
//                         +(origSize)+"||length="+(origSize+1)+"||classIndex="+(origSize)+"||classLength="+(origSize+1)+"]/");
//        driver.waitForElementClickable(tile);
//        WebElement tile1 = driver.findElement(tile);
//        assertEquals("test image: " + origSize, tile1.getText());
//        assertEquals(origSize + 1, driver.findElements(ByScLocator.scLocator("//TileGrid[ID=\"mediaTileGrid\"]/tile")).size());
//        driver.close();
//        driver.quit();
//    }
//    
//    &#47;**
//     * The following test runs against localhost and requires a small (< 50k) image to be in /tmp/image.jpg
//     *&#47;
//    public void fileUploadGWT() throws Exception {
//        final String basePath = "//VLayout[ID=\"isc_Showcase_1_0\"]/member[Class=HLayout||index=0||length=2|"
//                               +"|classIndex=0||classLength=1]/member[Class=HLayout||index=0||length=2||classIndex=0|"
//                               +"|classLength=1]/member[Class=Canvas||index=1||length=2||classIndex=0||classLength=1]"
//                               +"/child[Class=TabSet||index=0||length=1||classIndex=0||classLength=1]/paneContainer/"
//                               +"member[Class=VLayout||index=1||length=2||classIndex=0||classLength=1]/"
//                               +"member[Class=VLayout||index=1||length=2||classIndex=0||classLength=1]/"
//                               +"member[Class=HLayout||index=1||length=2||classIndex=0||classLength=1]/"
//                               +"member[Class=HLayout||index=0||length=1||classIndex=0||classLength=1]/";
//        final String formPath = basePath + "member[Class=DynamicForm||index=0||length=3||classIndex=0||classLength=1]";
//        final String tilesPath = basePath + "member[Class=VLayout||index=2||length=3||classIndex=0||classLength=1]/"
//                                          + "member[Class=TileGrid||index=2||length=4||classIndex=0||classLength=1]/tile";
//        SmartClientFirefoxDriver driver = new SmartClientFirefoxDriver();
//        driver.setBaseUrl("http://localhost:8888/");
//        driver.get("index.html#upload_sql");
//        driver.manage().window().maximize();
//
//        final int origSize = driver.findElements(ByScLocator.scLocator(tilesPath)).size();
//        By uploadForm = ByScLocator.scLocator(formPath);
//        WebElement form = driver.findElement(uploadForm);
//      
//        By titleInput = ByScLocator.scLocator(formPath + "/item[name=title||title=Title||index=0||Class=TextItem]/element");
//        driver.click(titleInput);
//        driver.sendKeys(titleInput, "test image: " + origSize);
//        
//        WebElement findElement = form.findElement(By.xpath("//input[@type='FILE']"));
//        &#47;*
//         * The following causes a native dialog to be created which prevents further progress. Do NOT uncomment!
//         * We just have to sendKeys() to it
//         *&#47;
//        //findElement.click(); 
//        
//        findElement.sendKeys("/tmp/image.jpg"); // A local file. Please change accordingly
//
//        By saveButton = ByScLocator.scLocator(formPath + "/item[title=Save||index=2||Class=ButtonItem]/button/");
//        driver.waitForElementClickable(saveButton);
//        driver.click(saveButton);
//        &#47;*
//         * Note the following fails once the grid contains more than 3 rows of data as the index becomes inconsistent
//         * as tiles scrolled out of site are removed and the indices change
//         *&#47;
//        By tile = ByScLocator.scLocator(tilesPath + "[Class=SimpleTile||index="+(origSize)+"||length="+(origSize+1)
//                                                      + "||classIndex="+(origSize)+"||classLength="+(origSize+1)+"]/");
//        driver.waitForElementClickable(tile);
//        WebElement tile1 = driver.findElement(tile);
//        assertEquals("test image: " + origSize, tile1.getText());
//        assertEquals(origSize + 1, driver.findElements(ByScLocator.scLocator(tilesPath)).size());
//        driver.close();
//        driver.quit();
//    }
// </pre>
// <P>
// <b>Other tools</b>
// <P>
// SmartClient supports a special JavaScript API to allow other test tools to integrate in the
// same manner as Selenium, WebDriver and SOASTA.  This API allows the test tool to record an abstract
// "locator" string representing the logical name for an interactive DOM element, and then
// during test playback, retrieve a DOM element given a locator.
// <P>
// This is critical because, like many modern Ajax systems, SmartClient generates different DOM
// elements in different browsers, in different skins, and in different versions of SmartClient.  
// Testing tools that try to directly record the generated SmartClient DOM produce extremely
// brittle tests because they are effectively recording undocumented internals.
// <P>
// Using the "locator" API allows you to record or write tests that will run in any browser
// supported by SmartClient, in any version of SmartClient, and in any skin.  It also makes
// tests more readable and easier to understand and maintain.
// <P>
// Different testing tools vary in how easily they can be configured to use the locator API,
// and in some older tools it can be a large effort.  We highly recommend using our Selenium
// extensions - it often makes sense to use them even if you have to use them in parallel with
// another, older testing tool.  If you are forced to use another tool exclusively:
// <ul>
// <smartclient>
// <li> Read the +link{class:AutoTest,documentation for the locator system}
// </smartclient>
// <smartgwt>
// <li> Refer to the &#83;martClient documentation for the AutoTest class (because it's a
// JavaScript API).  It can be found
// +externalLink{http://www.smartclient.com/product/documentation.jsp,here}
// </smartgwt>
// <li> Read over the source code of our Selenium extensions to get a clear understanding of
// how the Selenium integration works, because this will be analogous to the work you'll need
// to do
// <li> Search the +externalLink{http://forums.smartclient.com/, forums} for other developers
// who are trying to use the same test tool with SmartClient, and share efforts
// </ul>
//
// @treeLocation Concepts
// @title Automated Testing
// @visibility external
//<



//> @groupDef usingSelenium
// +externalLink{http://seleniumhq.org/,Selenium} is a powerful and popular tool which can be used 
// to test your SmartClient applications. 
// Selenium executes tests against your running application in a browser emulating user interaction 
// and asserting various conditions. Selenium provides a record/playback tool for authoring tests without 
// learning a test scripting language. You must be familiar with +externalLink{http://seleniumhq.org/,Selenium}
// and use of +externalLink{http://seleniumhq.org/projects/ide/,Selenium IDE} before proceeding. 
// Refer to the documentation on the Selenium site.
// <P>
// Selenium supports the concept of +externalLink{http://seleniumhq.org/docs/02_selenium_ide.html#locating-elements,Locators}
// in order to specify the element you'd like a given Selenium command to target. For example Selenium supports XPath based
// locators and DOM ID based locators. XPath based locators are extremely fragile due to complexity of certain 
// highly nested DOM elements you need access to combined with the fact that XPath support varies across browsers and 
// so your tests might not work across different browsers. 
// <P>
// Use of Selenium with SmartClient applications is no different than using Selenium to write and run test cases with 
// any other application with the exception of one caveat: SmartClient occasionally renders a different DOM structure 
// depending on the browser for performance or rendering the UI such that it appears identical across various browsers. 
// As a result using DOM ID or DOM XPath based locators with SmartClient applications is not advisable. 
// <P>
// Instead SmartClient supports a new Selenium locator which is an XPath-like string used by Selenium to robustly identify 
// DOM elements within a SmartClient application. SmartClient locators for Selenium are prefixed by "scLocator=" and have a 
// readable XPath-like value even for cells in ListGrid's or TreeGrids. Typically these locators will not be hand-written and 
// are generated by +externalLink{http://seleniumhq.org/projects/ide/,Selenium IDE}, Selenium's test recording tool. One primary
// locator is based on the ID of the SmartClient widget and has the syntax <b>ID=&lt;Canvas ID&gt;</b>. This simplifies the task of 
// writing tests if you know the ID of the Canvas. For reference, the scLocator syntax for ListGrid cells and DynamicForm 
// FormItems can be found at the end of this document.
// <P>
// <b>You can automate the process of running Selenium tests and saving or reporting results
// using +link{group:testRunner,TestRunner}.</b>
// <P>
// <b>Setup Instructions</b>
// <P>
// SmartClient ships with two Selenium user extension Javascript files: 
// <P>
// <ul>
// <li> user-extensions.js
// <li> user-entensions-ide.js
// </ul>
// <P>
// These extensions (found in the 
// <smartclient><code>smartclientSDK/tools/selenium/</code></smartclient>
// <smartgwt><code>selenium/</code></smartgwt>
// directory) augment the Selenium tools to support SmartClient locators. To integrate these extensions with Selenium, 
// follow the steps below:
// <P>
// <ul>
// <li> Confirm that the Selenium IDE has been installed.
// <li> Copy the user extension files listed above to a common location on your test client machine.
// <li> Open the Selenium IDE and click the Options ==&gt; Options... menu item. On the General tab enter the path to these extension 
// files in the corresponding fields: Selenium Core extensions and Selenium IDE extensions. Refer to the Selenium Documention 
// on +externalLink{http://seleniumhq.org/docs/08_user_extensions.html#using-user-extensions-with-selenium-ide,user extensions} 
// for more information.
// <li> Go to the WebDriver tab and ensure that the "Enable WebDriver Playback" checkbox is unchecked.
// <li> Close and restart Selenium IDE to load the new extensions.
// </ul>
// <P>
// That's it, we're done configuring the environment.
// <P>
// Note: Tests recorded using Selenium IDE can be played back using
// +externalLink{http://seleniumhq.org/projects/remote-control/,Selenium Remote Control}.
// The <code>user-extensions-ide.js</code> file is not required for playback of SmartClient-aware tests using Selenium RC, but the 
// <code>user-extensions.js</code> is. Instructions for using <code>user-extensions.js</code> with Selenium RC can be found 
// +externalLink{http://seleniumhq.org/docs/08_user_extensions.html#using-user-extensions-with-selenium-rc,here}.
// <P>
// <b>Recording Selenium tests with Selenium IDE</b>
// <P>
// Once you have your application running in Firefox, open Selenium IDE from the Tools ==&gt; Selenium IDE menu option. If the Selenium IDE
// is in record mode, then clicking or carrying out other operations like typing in a text field with automatically record the 
// appropriate Selenium commands with the SmartClient locator. In most cases there's no need for you to manually enter the locator, 
// the recorder does this for you! In fact, not only do the provided user extension files record your clicks, drag operations, and 
// typing in the browser--they also try to ensure that your script executes each operaton only when the SmartClient widgets it depends 
// upon exist and are ready to be interacted with.  This ensures that when the test script is executed, then even if one or more triggered 
// operations are asynchronous (delayed), it behaves as expected.
// <P>
// In the screenshot below, note the <b>waitForElementClickable()</b> operation above the click operation; it was added automatically by our 
// user extensions as the click itself was recorded: 
// <P>
// <img src="skin/user-guide-images-selenium/selenium-ide-example.png" width="1017px" height="853px">
// <P>
// Sometimes users may also want finer grain control of what Selenium command is created instead of having the Selenium IDE recorder 
// do this automatically. For example if you want to verify the value of a particular cell in a ListGrid. Instead of typing in the 
// command "verifyTable" and manually enter the SmartClient Locator (scLocator), you can simply right click on the table cell or any 
// other SmartClient widget and the most suitable Selenium commands will appear in the context menu along with the scLocator path for 
// the clicked element. See image below.
// <P>
// <img src="skin/user-guide-images-selenium/selenium-ide-example-verifyText.png" width="1211px" height="737px">
// <P>
// <b>Solving Ordering Issues in Selenium Scripts</b>
// <P>
// Fundamentally, the reason we add <b>waitForElementClickable()</b> calls before each click is to deal with asynchronous SmartClient
// operations. Many operations on widgets or the network are asynchronous, and a correctly coded test should wait for such operations to 
// complete as opposed to inserting an arbitrary delay or using Selenium's <b>setSpeed()</b> function. Using such delays runs the risk of 
// the test failing if replay occurs on a loaded machine or slow network, and also makes the test run slower than needed. 
// <P>
// Asynchronous operations include:
// <P>
// <ul>
// <li> any actual network operation,
// <li> any DataSource operation (even for a clientOnly DataSource),
// <li> any situation where a widget can be marked "dirty" (see notes at <b>Canvas.isDirty()</b>), and then asynchronously 
// redraw itself - this includes API calls like <b>ListGrid.setData()</b>, <b>Canvas.setContents()</b> as well as user interactions like 
// ListGrid sort or filter, regardless of whether the data is already present,
// <li> re-layout that occurs as a result of a size change or new member being added to a Layout or subclass of Layout (eg SectionStack, Window)
// </ul>
// <P>
// The following operations are synchronous and don't require waiting:
// <P>
// <ul>
// <li>draw()ing any widget that has no parent - but note adding a widget to an already-drawn Layout is asynchronous, as above
// </ul>
// <P>
// You may encounter cases where you have to manually insert a <b>waitForElementClickable()</b> or <b>waitForElementNotPresent()</b>
// to get a script to behave properly.  Looking at the SmartClient Showcase Example (Grids / Filtering / Advanced Filter), suppose 
// we wanted to filter by country names containing "Za" and wait for the filter step to complete before proceeding.  Since the 
// ListGrid initially contains many entries and Zaire is not among them, it is not visible and thus we can solve the original 
// problem by manually adding a <b>waitForElementClickable()</b> on the locator for Zaire's ListGrid entry:
// <P>
// &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>scLocator=//ListGrid[ID="filterGrid"]/body/row[pk=216||countryCode=CG||215]/col[fieldName=countryCode||0]</b>
// <P>
// Before the filter operation is issued, the locator is not clickable because the record is not visible:
// <P>
// <img src="skin/user-guide-images-selenium/manual-wait-clickable-before.png" width="767px" height="327px">
// <P>
// When the filter operation completes, Zaire and the other search results become visible and the <b>waitForElementClickable()</b> 
// returns successfully allowing the next script command to execute:
// <P>
// <img src="skin/user-guide-images-selenium/manual-wait-clickable-after.png" width="763px" height="328px">
// <P>
// Finally, suppose you wanted to do another filter operation to look only at countries (from the previous search results) with 
// populations under 30 million.   Since Zaire is above this limit, it will be missing from the search results and you could 
// wait for the filter operation to complete by adding a <b>waitForElementNotPresent()</b> on same locator that we previously used 
// for <b>waitForElementClickable()</b>. It will return true and allow the script to proceed when the filter operation completes:
// <P>
// <img src="skin/user-guide-images-selenium/manual-wait-not-present.png" width="762px" height="317px">
// <P>
// <b>Waiting on Pending ListGrid Operations</b>
// <P>
// There are cases where <b>waitForElementClickable()/waitForElementNotPresent()</b> will not work--for example if you're performing 
// a sort that's rearranging existing elements on the screen, or if you're performing a filter operation where you're not sure of
// the results and thus cannot use the approach from the previous section.  In such a situation, you may need to add a 
// <b>waitForGridDone()</b> command into your script to ensure the pending operations are complete before you hit the next command.
// <P>
// The <b>waitForGridDone()</b> command guarantees it will not complete successfully unless all of the following potential pending 
// operations on the widget are complete:
// <P>
// <ul>
// <li> any fetch or filter operation (the result of applying criteria),
// <li> any sort operation (the result of apply sort specifiers),
// <li> the flush of pending FilterEditor criteria to the parent ListGrid, and
// <li> the saving of any newly edited rows.
// </ul>
// <P>
// This command should be able to block a Selenium script until the ListGrid specified in the locator reaches a stable drawn state with 
// no pending activity.  So for a ListGrid names 'filterGrid', all you'd need to add to ensure all pending operations on it have
// completed is the command:
// <P>
// &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>waitForGridDone("//ListGrid[ID='filterGrid']");</b>
// <P>
// <P>
// <b>Waiting on All Pending Network Operations</b>
// <P>
// Because of the <b>waitForElementClickable</b> commands which are automatically inserted during recording, your scripts will
// automatically wait for the completion of any network operations that block interactivity (via showPrompt, which is enabled by 
// default). However in some cases you may want to wait for all pending network operations to complete, even if they don't block
// user interactivity.
// <P>
// To do this, use <b>RPCManager.requestsArePending()</b> in combination with <b>waitForCondition()</b>.
// So, the JavaScript in your <b>waitForCondition()</b> operation would be:
// <P>
// &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>!selenium.browserbot.getCurrentWindow().isc.RPCManager.requestsArePending()</b>
// <P>
// When the call returns, you'd know that any previously initiated network operations--such as filter/sort operations on DataSources--are 
// complete.
// <P>
// <b>Automatically Waiting on All Pending Network Operations</b>
// <P>
// If you need the functionality from the section above to wait on all pending network operations, but don't want to add extra calls to
// <b>waitForCondition()</b>, you may switch on automatic enforcement of the condition that <b>isc.RPCManager.requestsArePending()</b>
// is false.  There are two ways to do this:
// <P>
// <ul>
// <li> Set the property <b>isc.AutoTest.implicitNetworkWait</b> to true on the page under test after the ISC modules are loaded, or
// <li> Add the Selenium command <b>setImplicitNetworkWait(true)</b> to your selenium script in Selenium IDE.
// </ul>
// <P>
// Like other Selenium IDE commands with a single argument, you'll want to use <b>setImplicitNetworkWait()</b> by passing <b>true</b>
// (or <b>false</b>) in the Target field of the Selenium IDE GUI (right under command). Without any modifications, the default value 
// for <b>isc.AutoTest.implicitNetworkWait</b> of <b>false</b> will prevail.
// <P>
// <b>Capturing Logs</b>
// <P>
// Capturing of client and server-side logs can be switched on by providing appropriate options to +link{testRunner},
// but a few Selenium commands are provided to provide direct control over logging on a per-script basis.  If
// server logging has been configured as "some," then server logs won't be captured for a given script unless you
// add the captureServerLogs() Selenium command after the open command; switching the mode to "all" will force
// server logs to be collected for all Selenium scripts, and no captureServerLogs() command is then required.
// <P>
// To configure logging levels, you can use the commands <b>setClientLogLevel(category, level)</b>, or
// <b>setServerLogLevel(category, level)</b>.  For example:
// <ul>
// <li><b>setClientLogLevel("AutoTest","ERROR")</b>, or
// <li><b>setServerLogLevel("com.isomorphic.rpc.RPCManager", "INFO")</b>
// </ul>
// Note that when entering the above examples into Selenium IDE, you need neither parentheses nor quotes,
// as everything is considered a string and there are fixed slots for each.
// <P>
// <b>Disabling the Selenium SmartClient URL Query String</b>
// <P>
// By default, our user extensions automatically add a special URL variable, <b>sc_selenium</b>, to open command urls to allow 
// JavaScript to detect it's being driven by Selenium in case special logic should be used.  In the unlikely event that this causes a 
// problem with your code or page loading and you don't need the feature, you may eliminate this special URL variable by changing
// <b>Selenium.prototype.use_url_query_sc_selenium</b> from <b>true</b> to <b>false</b> in user-extensions.js.
// <P>
// <hr>
// <P>
// <b><u>Common scLocator syntax</u></b>
// <P>
// For more information on how locators are formed and how to influence them, see the +link{AutoTest,AutoTest} class in 
// the SmartClient Reference. 
// <P>
// <b><u>List Grid cells</u></b>
// <P>
// <b>//ListGrid[ID="itemList"]/body/row[itemID=1996||itemName=Sugar White 1KG||SKU=85201400||1]/col[fieldName=SKU||1]</b>
// <P>
// <ul>
// <li> This assumes the ListGrid has an explicit ID
// <li> the 'body' part might be 'frozenBody' if the field in question was frozen
// <li> row[......] identifies the row (record)
// <li> itemID= - that's the primary key field from the dataSource the grid is bound to
// <li> itemName= - that's the title field value for the record
// <li> SKU=... - that's the cell the user clicked's value
// <li> 1 - that's the index of the row (rowNum)
// <li> col[.....] - identifies the column in the grid
// <li> fieldName=... - field name for the field the user clicked
// <li> 1 - that's the index of the column
// </ul>
// <P>
// <b><u>Form Items</u></b>
// <P>
// <b>//DynamicForm[ID="autoTestForm"]/item[name=textField||title=textField||value=test||index=0||Class=TextItem]/element</b>
// <P>
// This example is the data element (text entry box) for a text field 
// <P>
// <ul>
// <li> this form has an explicit ID
// <li> item[...] identifies the item
// <li> name (field name, if set)
// <li> title (title, if set)
// <li> value (current value if set)
// <li> index (index in the form items array)
// <li> Class (SC class of the item - in this case TextItem) after the "/" we identify the part of the item in question options here include:
// <li> "element" - the data element
// <li> "canvas" - for CanvasItems - points to the canvas embedded in the item
// <li> in this case the xpath might continue to contain, for example children of the canvas or elements within it (cells in a listGrid, etc)
// <li> "textbox" - the "text box" - this is the area where content is written out for items without a 'data element' - like header items
// <li> "[icon=&lt;...&gt;]" - the icon element -- "&lt;...&gt;" would contain the "name" of the icon
// </ul>
// <P>
// <P>
// <hr>
// <P>
// <b><u>Keystroke Capturing (Experimental)</u></b>
// <P>
// We've enabled the capability to capture keyboard interaction with the widgets on a
// SmartClient page as an experimental feature - it's known to have incompatibilities with
// Chrome browser and has been tested mostly with Firefox.  This may be used to:
// <ul>
// <li> capture keystrokes passed to a masked TextItem (printable characters only, not navigation)
// <li> capture navigation keystrokes between records/fields of a ListGrid
// </ul>
// <hr>
// <P>
// <b><u>Best Practices</u></b>
// <P>
// <ul>
// <li> <b>Maximize the test browser window to avoid offscreen widgets</b>: Some browsers will not respond to events on widgets 
// that are not visible in the browser pane (scrolled out of view or clipped off). To avoid having to manually add script commands to 
// scroll such widgets into view, it's recommended to use Selenium's <b>windowMaximize()</b> command which will force the browser to 
// occupy the entire screen.
// <P>
// Note that currently some browsers will respond to events on offscreen widgets (IE will, Firefox will not) however, web standards 
// are unclear on whether this should be allowed and the behavior may change in the future, so best practice is to maximize for all 
// browsers.
// <P>
// <li> <b>Use setID() judiciously to ensure stable locators run-to-run</b>: When setID() is not used to supply a unique component ID,
// locators will sometimes incorporate automatically generated IDs which have a sequence number (eg isc_Object_355). If your test 
// has unpredictable execution order (for example, two simultaneous network operations take place and either may complete first, 
// and both generate UI components on completion) then these IDs will not be stable from run-to-run. They will likewise not be stable 
// if you test part of an app and then embed it in a larger app and try to use the same script.
// <P>
// Use setID() selectively to avoid this problem. Generally, it makes sense to use setID() on all top-level (parentless) widgets - at 
// this point, locators for children that do not have a unique ID will be based on the parent's ID plus a relative path. This relative 
// path will not incorporate auto-generated IDs and will generally continue to work even if the interior layout of the parent is 
// significantly rearranged (such as adding a new intervening container widget).
// </ul>
// <P>
// <hr>
// <P>
// <b><u>Known Limitations</u></b>
// <ul>
// <li> Selenium intermittently fails to generate an scLocator with the "type" command on some FormItems. If this occurs, you can 
// manually enter an scLocator into the target field, or use the drop down to select an alternative locator strategy (such as locating
//  a text input element by name).
// <li> Support for multi-select for SelectItems with selection mode "grid" (non-default)
// </ul>
// <P>
// @treeLocation Concepts/Automated Testing
// @title Using Selenium
// @visibility external
//<

//> @groupDef testRunner
// The SmartClient TestRunner is a system for running a suite of Selenium tests on a periodic
// basis, comparing the results to previous results, and generating email alerts reporting on
// new test failures or fixes to tests that were previously failing.
// <P>
// TestRunner is a key piece of implementing the <i>Continuous Integration</i> methodology,
// whereby continuous testing is applied so that regressions are caught immediately.  This
// allows a product or application to be kept continuously at a very high level of quality,
// allowing for more frequent and predictable releases.
// <P>
// <h3>Database Setup</h3>
// <P>
// Each time TestRunner executes it by default stores results to a SQL database via two 
// SQLDataSources:
// <ul>
// <li><b>batchRun.ds.xml</b>: stores global information about the run as a whole: an ID for
//    the run, when it started and ended, and optional data to be used in emails generated by
//    the system.
// <li><b>testResult.ds.xml</b>: stores the result of each individual test, including when it
//    started and ended, and information about errors that occurred, if any
// </ul>
// These DataSources are present in the 
// <smartclient><code>smartclientSDK/tools/selenium/</code></smartclient>
// <smartgwt><code>selenium/</code></smartgwt>
// directory of your SDK.  If you choose to move them elsewhere, simply update the DataSources
// location (configured by <code>project.datasources</code> in 
// +link{server_properties,server.properties}).
// <P>
// These DataSources behave just like other SQLDataSources: 
// <ul>
// <li> they are compatible with all the database types that SmartClient supports
// <li> they will use the default database configured for your project, or you can set
//      +link{dataSource.dbName} in the .ds.xml file to use a second database instead
// <li> you can setup the database connection and generate SQL tables using the
//      +link{adminConsole}
// <li> you can build your own UI for viewing test results, by loading the
//      <code>batchRun</code> and <code>testResult</code> DataSources like any other
//      SQLDataSource and binding components such as ListGrids to them.
// <li> if you deploy an application that includes these DataSources, third-party tools can
//      access these DataSources via the RESTHandler servlet
// </ul>
// <P>
// If needed, the IDs of these DataSources can be configured via the 
// +link{server_properties,server.properties} settings
// <code>autotest.batchRunDS</code> and <code>autotest.testResultDS</code>.
// <P>
// Note: If you use the default server.properties shipped with the SDK, TestRunner and the 
// SDK web server will share a common SQL database, so that the web server and TestRunner
// cannot both run at once.  This means that you must point TestRunner at the web server of
// a separate SDK installation - on a separate matchine or in a separate filesystem location.
// <P>
// <h3>Adding Test Files</H3>
// <P>
// TestRunner currently supports tests written in Selenese, Selenium's HTML-based format for
// recording automated tests.  The Selenium IDE can be used to record tests and save them in
// Selenese format.  For more background on the Selenium IDE, SmartClient's extensions, and
// the use of WebDriver / Selenium 2, see the 
// +link{group:automatedTesting,Automated Testing Overview}.
// <P>
// Test files should be saved with the extension .rctest.html.  They should all appear under
// a common root directory (called <code>testRoot</code>), but any level of nesting is allowed,
// and any other files that appear under <code>testRoot</code> will be ignored; only
// .rctest.html files will be processed.
// <P>
// The <code>testRoot</code> directory is passed to TestRunner when you execute it.  In the
// database and in emails, test are identified by their directory path relative to
// <code>testRoot</code>.
// <P>
// Adding a test to the test suite is as simple as placing the .rctest.html file somewhere under
// the <code>testRoot</code> directory; on the next TestRunner execution, TestRunner will
// notice the new test and start reporting results for it (including reporting it as a failure
// if it fails in its very first run).
// <P>
// The included test result viewing application (see below) also provides an interface to
// upload tests if you prefer not to allow direct filesystem access to the machine where
// TestRunner executes.
// <P>
// <h3>Running Test Runner</h3>
// <P>
// TestRunner is an ordinary Java class - com.isomorphic.autotest.TestRunner - and can be run
// from the command line in the usual fashion, or run programmatically from within a Java
// application using the wrapper class com.isomorphic.autotest.TestRunnerDriver.  We also
// provide convenience scripts to run the TestRunner Java class in the SDK root directory.
// <P>
// Minimally, TestRunner needs to know the base directory of a set of test files.  All files
// saved anywhere under this base directory which end in the extension .rctest.html will be
// assumed to be Selenese test files and executed.
// <P>
// As is standard for Selenese test files, the first command in the file is typically an "open"
// command with the URL of the application which should be opened in a browser so that
// subsequent commands can be run.  
// <P>
// The assumption is that the application that will be tested is already deployed by the time
// TestRunner is run; how to automate building and deployment of applications is outside of the
// scope of this document, however, the recommendation is that a Revision-Control System (such
// as SVN, git or CVS) is used, and that every time a developer "checks in" or "commits"
// changes, the application being tested is built and deployed to a test server, then TestRunner
// is run.  Continuous Build Servers (such as Hudson, Bamboo or CruiseControl) may help
// automate the step of building from source control and deploying to a test server, then such
// a Build Server can typically be configured to trigger TestRunner.
// <P>
// TestRunner requires several resources to be in expected default locations from the current
// directory unless you provide overrides via the command line or +link{server_properties,server.properties}.
// Some of
// the required resources are:
// <ul>
//    <li> the batch report email template, by default at mailTemplats/batchReport.template
//    <li> the selenium test template, user extensions, and batchRun/testResult dataSource
//         XML files, by default in tools/selenium
//    <li> the dataSource XML schema files, by default in isomorphic/system/schema
// </ul>
// <P>
// <h4>Command-line Examples</h4>
// <P>
// The following command-line would run TestRunner, execute all tests under the default
// testRoot directory "tests", and commit the results:
// <pre>
// java com.isomorphic.autotest.TestRunner</pre>
// This assumes your classpath environment has been set to include the isomorphic SDK JARs;
// you may invoke the convenience script test_runner.sh/.bat/.command in the SDK root directory
// to run the TestRunner Java class without having to set the classpath.
// <P>
// The following command-line would execute TestRunner as above, but run all tests under the
// directory "foo/bar" relative to the current directory, and email a report of the results:
// <pre>
// java com.isomorphic.autotest.TestRunner -tr foo/bar -e user@company.com</pre>
//
// To do the same, but only run a particular test, you can use the files option (-f):
// <pre>
// java com.isomorphic.autotest.TestRunner -tr foo/bar -c -f test1.rctest.html -e user@company.com</pre>
// Note that when a file is specified, the default is not to commit the results unless
// requested via the commit option (-c).
// <P>
// <h4>Java API</h4>
// <P>
// The following Java code would do the same as the last command-line example:
// <pre>
//     TestRunnerDriver driver = new TestRunnerDriver();
//     driver.setTestRoot("foo/bar");
//     driver.setBatchCommit(true);
//     driver.setFiles(new String[] { "test1.rctest.html" });
//     driver.setAlertEmail("user@company.com");
//     driver.run();
// </pre>
// <P>
// <h4>TestRunner Configuration</h4>
// <P>
// TestRunner supports several more command-line options, or equivalent settings that can be
// applied via Java.  The following table summarizes the command-line options, equivalent Java
// Setter in the DriverConfiguration interface, and it's behavior (including default behavior).
// <P>
// <table border="1">
//  <thead>
//    <tr><th>Command-line Option</th><th>Java Setter</th>
//    <th>+link{server_properties,server.properties} Name</th><th>Behavior</th></tr>
//  <thead>
//  <tbody>
//     <tr><td>-b &lt;browser&gt;</td><td>setBrowser</td><td>N/A</td>
//     <td>Specifies the browser string passed to Selenium. Default is <b>*firefox</b>
//     See +link{usingSelenium}</td></tr>
//     <tr><td>-br &lt;branch&gt;</td><td>setBranch</td><td>autotest.branch</td>
//     <td>Specifies a branch for the batch, used in the batch run record and email
//     notification.  Default is <b>MAIN</b>.Test result comparison occurs per branch.</td></tr>
//     <tr><td>-c/-nc</td><td>setBatchCommit</td><td>N/A</td>
//     <td>This pair of argumentless options allows you to force the batch results to 
//     be committed (-c) or not committed (-nc).  This is useful to override the default
//     of committing (or of not committing if the -f option has been passed).</td></tr>
//     <tr><td>-cs</td><td>setCaptureScreenshot</td><td>N/A</td><td>
//     Configures TestRunner to capture a PNG screenshot of the browser if a
//     Selenium test fails, adding the image to the test result record.</td></tr>
//     <tr><td>-f &lt;files&gt;</td><td>setFiles</td><td>N/A</td><td>Specifies a file or list
//     of files to run. This option can restrict which Selenium scripts under testRoot get run.
//     Relative paths from the testRoot or bare filenames may be provided. When present,
//     this option also disables the default behavior of committing test results.</td></tr>
//     <tr><td>-fr &lt;path&gt;</td><td>setFileRoot</td><td>N/A</td><td>Sets the root directory
//     for all other file system paths.  If not set, defaults to current working directory where
//     Java was launched, or the web server root if TestRunner is run in a servlet.</td></tr>
//     <tr><td>-h</td><td>N/A</td><td>N/A</td><td>Lists available command-line options.</td></tr>
//     <tr><td>-hp &lt;port&gt;</td><td>setHttpPort</td><td>N/A</td>
//     <td>Sets the web server port Selenium should use to run the tests.
//     Default is <b>8080</b></td></tr>
//     <tr><td>-ht &lt;host/IP&gt;</td><td>setHttpTarget</td><td>N/A</td>
//     <td>Sets the target web server Selenium should use to run the tests.
//     Default is <b>localhost</b></td></tr>
//     <tr><td>-lg &lt;message&gt;</td><td>setBatchLog</td><td>N/A</td><td>Provides a
//     log message to include in the record for this batch run. (No Default)</td></tr>
//     <tr><td>-lp</td><td>N/A</td><td>N/A</td>
//     <td>Informs TestRunner that a message or file has been piped to STDIN as the
//     batch log message.</td></tr>
//     <tr><td>-sm</td><td>setSaveMessages</td><td>N/A</td>
//     <td>Configures TestRunner to save the client log messages for each test to the
//     associated test record if the test fails.</td></tr>
//     <tr><td>-sr &lt;path&gt;</td><td>setServerFileRoot</td><td>N/A</td>
//     <td>Sets the serverFileRoot directory. Default is <b>/</b>. Selenium scripts executing
//     open() commands on the httpTarget server will by use this default path.</td></tr>
//     <tr><td>-t &lt;timestamp&gt;</td><td>setTimestamp</td><td>N/A</td>
//     <td>Forces comparison of the batch results to be against the batch run with a
//     timestamp closest to that provided, rather than the most recent batch run.  Format
//     is "2012-12-31 23:59:59" in the local time zone.</td></tr>
//     <tr><td>-tr &lt;path&gt;</td><td>setTestRoot</td><td>autotest.testRoot</td>
//     <td>Sets the testRoot directory relative to the current directory. By default, its
//     value is <b>tests</b>, and all Selenium scripts under the testRoot will be executed
//     by TestRunner.</td><tr>
//     <tr><td>-un &lt;userName&gt;</td><td>setUserName</td><td>autotest.userName</td>
//     <td>Specifies a user name for the batch run record. (No Default)</td></tr>
//     <tr><td>-vm &lt;mode&gt;</td><td>setServerLogMode</td><td>N/A</td>
//     <td>Configures TestRunner to collect the server log messages for each test if
//     it fails.  Legal modes are "none", "some", or "all".  Default is <b>some</b>.</td></tr>
//     <tr><td>-vo &lt;out&gt;</td><td>setServerLogOutputMethod</td><td>N/A</td>
//     <td>Configures the output method that TestRunner will use to report or persist
//     any server log messages; only has an effect for server log modes of "some" or "all".
//     Legal values are "email", "datasource", or "both".  Default is <b>email</b>.</td></tr>
//     <tr><td>-x/-nx</td><td>setMaximizeBrowser</td><td>N/A</td>
//     <td>Sets whether to maximize the browser for Selenium tests.  If not explicitly
//     set via this call, the browser will be maximized if and only if screenshots 
//     are being taken.</td></tr>
//  </tbody>
// </table>
// <P>
// <h3>Email Notifications</h3>
// <P>
// At completion of the batch of tests, TestRunner can automatically send out an email
// notification summarizing the results of the test run, including error messages for 
// any newly failing tests.  A velocity template file is used to control its format; see 
// +link{group:velocitySupport, Velocity Support}. 
// The following velocity variables are available:
// <P>
// <ul>
//     <li><b>$firstBatchFound</b>. Whether baseline batch was found with which to compare</li>
//     <li><b>$fixed</b>. A list of the test results for tests fixed in this batch run</li>
//     <li><b>$regression</b>. A list of the test results for tests broken in this batch run</li>
//     <li><b>$totalTestFiles</b>. The total number of tests run in this batch run</li>
//     <li><b>$passedTestFiles</b>. The number of tests that passed  in this batch run</li>
//     <li><b>$batchStartTime</b>. Timestamp associated with start of this batch run</li>
//     <li><b>$batchLog</b>. Log message, if any was provided for this batch run</li>
// </ul>
// A sample/default template is provided as the file <b>mailTemplates/batchReport.template</b>.
// <P>
// The following options govern the Email Notifications:
// <table border="1">
//  <thead>
//    <tr><th>Command-line Option</th><th>Java Setter</th>
//    <th>+link{server_properties,server.properties} Name</th><th>Behavior</th></tr>
//  <thead>
//  <tbody>
//     <tr><td>-cc &lt;recipient&gt;</td><td>setCcEmail</td><td>autotest.ccEmail</td>
//     <td>Sets the recipient email address for batch report email.  This recipient will
//     always be cc'd a copy of the batch report email, regardless of whether fixes or
//     regressions are present. (No Default)</td></tr>
//     <tr><td>-e &lt;recipient&gt;</td><td>setAlertEmail</td><td>autotest.alertEmail</td>
//     <td>Sets the recipient email address for batch report email.  If the "repeat email"
//     recipient address has also been set via -re, this address will only be sent "alert
//     email" reports where fixes or regressions are present.  Otherwise, it will receive all
//     batch report email.  (No Default)</td></tr>
//     <tr><td>-m &lt;mailHost&gt;</td><td>setMailHost</td><td>autotest.mailHost</td>
//     <td>Specifies what mail host to use to send mail.  If not provided, your mail
//     software will decide what host to use.</td></tr>
//     <tr><td>-ms &lt;subject&gt;</td><td>setMailSubject</td><td>autotest.mailSubject</td>
//     <td>Sets subject line base to use when sending the email reporting batch results.
//     Regressions and fixes info will be appended to the provided subject content.</td></tr>
//     <tr><td>-mt &lt;file&gt;</td><td>setMailTemplate</td><td>autotest.mailTemplate</td>
//     <td>Specifies what velocity template file to use when generating the batch report
//     email for this batch run. Default is <b>mailTemplates/batchReport.template</b></td></tr>
//     <tr><td>-ne</td><td>setNoEmail</td><td>N/A</td><td>Disables sending any email for
//     the batch run. If recipient email addresses have not been set through the
//     command line, Java setters, or server.properties, it's not needed.  However, it
//     may be useful in suppressing email in cases where they have been set.</td></tr>
//     <tr><td>-re &lt;recipient&gt;</td><td>setRepeatEmail</td><td>autotest.repeatEmail</td>
//     <td>Sets the recipient email address for batch report email.  If the "alert email"
//     recipient address has also been set via -e, this address will only be sent "repeat
//     email" reports where no fixes or regressions are present.  Otherwise, it will receive
//     all batch report email.  (No Default)</td></tr>
//     <tr><td>-se &lt;sender&gt;</td><td>setSenderEmail</td><td>autotest.senderEmail</td>
//     <td>Sets the sender email address for batch report email.  Only needed if there is
//     a problem sending email using the sender address generated by default.</td></tr>
//  </tbody>
// </table>
// <P>
// Note: If you choose not to have any email sent upon completion of a batch run, and decide
// not to commit the results to the DataSources, the results of each batch run can still be
// determined by examing the Java console log, which captures the output of each RC test script.
// <P>
// <h3>Result Viewer</h3>
// <P>
// TestRunner comes with a very very simple application for interactively viewing and searching
// test results, implemented in &#83;martClient technology.  This application is meant as a
// starting point for building your own application for interactive viewing of test results, if
// you prefer to go beyond email notifications.
// <P>
// The source code for this application is just a single testResultViewer.jsp file in the "selenium"
// directory in the SDK; copy it anywhere under <code>webroot</code> in a project that includes
// the SmartClient Server and it will function.
// <P>
// The result viewing application also includes the ability to upload new test files to
// <code>testRoot</code> as an alternative to providing testers with direct access to the
// filesystem for the machine where TestRunner executes.
// <P>
// <h3>Getting Started FAQ</h3>
// <P>
// <smartclient>
// Q: When I run TestRunner, I want to target the SmartClient server, but TestRunner fails
// due to HSQLDB reporting a locked database.<BR>
// A: You must stop the SC server running from the same SDK installation as TestRunner before 
// running TestRunner.  Another copy of the SDK may be installed elsewhere on the same machine,
// or TestRunner may be pointed at a different machine using the -ht comand-line option.
// </smartclient>
// <smartgwt>
// Q: When I run TestRunner, I want to target the SGWT showcase, but TestRunner fails due to 
// HSQLDB reporting a locked database.<BR>
// A: By default, TestRunner uses the HSQLDB associated with the SGWT showcase when run from
// the SGWT ZIP root directory.  Therefore, if samples/showcase/war has been deployed to a 
// webserver, you must stop it before running TestRunner.  One simple alternative is to deploy
// the file showcase.war from the SGWT ZIP root, which has a separate copy of the HSQLDB.  You
// may also simply install another copy of the SGWT ZIP in a different location on the same 
// machine, or point TestRunner at a different machine using the -ht command-line option.
// </smartgwt>
// <P>
// Q: When I run TestRunner, TestRunner fails reporting that DataSource BatchRun or TestResult
// cannot be found.<BR>
// A: These DataSources must be imported into the default HSQLDB before TestRunner can be used.
// <smartclient>
// Use the "import" option of tools/adminConsole.jsp under the SDK installation root directory
// </smartclient>
// <smartgwt>
// Use the "import" option of showcase/tools/adminConsole.jsp under the deployed SGWT showcase
// </smartgwt>
// to select and import the BatchRun and TestResult DataSources prior to running TestRunner.
// 
// @treeLocation Concepts/Automated Testing 
// @title TestRunner
// @visibility external
//<

//> @class AutoTest
// Standalone class providing a general interface for integration with Automated Testing Tools
// <p>
// <smartclient>
// For automated testing tools we need a way to create string identifiers for DOM elements such that 
// when a page is reloaded, we can retrieve a functionally equivalent DOM element. We call these
// +link{AutoTestLocator,autoTestLocators}.
// <p>
// This allows automated testing tools to set up or record user generated events on DOM elements
// then play them back on page reload and have our components react correctly.
// <P>
// The primary APIs for the AutoTest subsystem are +link{AutoTest.getLocator()} and 
// +link{AutoTest.getElement()}.
// <P>
// Implementation considerations:
// <ul>
// <li> Some components react to the structure of DOM elements embedded within them - for example
//   GridRenderer cells have meaning to the grid. So in some cases we need to identify elements
//   within a component, while in others we can just return a pointer to a handle (A simple
//   canvas click handler doesn't care about what native DOM element within the  handle received
//   the click).
//
// <li>When a DOM element is contained by a component, it is not sufficient to store the component
//   ID. Most SmartClient components are auto-generated by their parents, and rather than 
//   attempting to store a specific component identifier we should instead store the
//   "logical function" of the component.<br>
//   For example a listGrid header button may have a different auto-generated ID across page
//   reloads due to various timing-related issues (which can change the order of of widget
//   creation), loading a new skin, or otherwise trivial changes to an application.<br>
//   Rather than storing the header button ID therefore, we want to store this as
//   a string meaning "The header button representing field X within this list grid".
//
// <li>fallback strategies: In some cases a component or DOM element can be identified in 
//   several ways. For example a cell in a ListGrid can be identified by simple row and
//   column index, but also by fieldName and record primary key value. In these cases we
//   attempt to record information for multiple locator strategies and then when parsing
//   stored values we can provide APIs to govern which strategy is preferred. See the
//   +link{type:LocatorStrategy} documentation for more on this.
// </ul>
// 
// In order to address these concerns the AutoTest locator pattern is similar to an
// XPath type structure, containing a root component identifier, followed by 
// details of sub-components and then potentially details used to identify an element within
// the components handle in the DOM.
// <br>
// The actual implementation covers a large number of common cases, including (but not limited to)
// the following. Note that for cases where an element is being identified from a pool of
// possible candidates, such as the +link{canvas.children} array, we usually will use
// +link{LocatorStrategy,fallback locator paths} rather than simply relying on index:
// <ul><li>Root level components identified by explicit ID</li>
//     <li>Any +link{autoChild,autoChildren}</li>
//     <li>Standard component parts such as scrollbars, edges, shadows, etc</li>
//     <li>Section stack items and headers</li>
//     <li>Window items</li>
//     <li>ListGrid headers and cells</li>
//     <li>TreeGrid headers and cells, including interactive open icon, checkbox icons</li>
//     <li>DynamicForm form items, including details of elements within those items</li>
// </ul>
// </smartclient>
//
// @treeLocation Concepts/Automated Testing
// @visibility external
// @group autoTest
//<

//> @type AutoTestLocator
// An autoTestLocator is an xpath-like string used by the AutoTest subsystem to robustly 
// identify DOM elements within a SmartClient application.
// <P>
// Typically AutoTestLocators will not be hand-written - they should be retrieved by a
// call to +link{AutoTest.getLocator()}. Note also that the +link{group:debugging,Developer Console}
// has built-in functionality to create and display autoTestLocators for a live app.
//
// @group autoTest
// @visibility external
//<

// Document AutoTestObjectLocator as a separate type. As currently implemented it is always a
// valid standard Locator string, but that's an implementation detail and may not always be the case.
//> @type AutoTestObjectLocator
// A string that uses similar syntax to an +link{type:AutoTestLocator}, but is expected to
// resolve to a live SmartClient object such as a +link{Canvas}, or +link{FormItem} rather than
// some element within the DOM. These are created via +link{AutoTest.getObjectLocator()} and
// +link{AutoTest.getRelativeObjectLocator()}
// @group autoTest
// @visibility rules
//<




isc.defineClass("AutoTest");


isc.AutoTest.addClassMethods({

    locatorsEqual : function (locator1, locator2) {
        if (locator1 && locator2) {
            locator1 = locator1.replace(/^[^\/]*(\/\/.*?)[\/]*$/, "$1");
            locator2 = locator2.replace(/^[^\/]*(\/\/.*?)[\/]*$/, "$1");
        }
        return locator1 == locator2;
    },
    
    //> @classMethod AutoTest.getLocator()
    // Returns the +link{type:AutoTestLocator} associated with some DOM element in a SmartClient
    // application page.  If coords, representing the page position, is passed in, the locator
    // may be generated with a specific trailing "target area" identifer that will map back to
    // the appropriate, potentially different, physical coordinates, even if the widget is
    // moved.  The coords argument will only have an effect in cases where the mouse position
    // over the target could potentially change behavior.
    // @param DOMElement (DOMElement) DOM element within in the page. If null the locator for
    //  the last mouse event target will be generated
    // @param [checkForNativeHandling] (boolean) If this parameter is passed in, check whether
    //  the target element responds to native browser events directly rather than going through
    //  the SmartClient widget/event handling model. If we detect this case, return null rather
    //  than a live locator.  This allows us to differentiate between (for example) an event on
    //  a Canvas handle, and an event occurring directly on a simple 
    //  <code>&lt;a href=...&gt;</code> tag written inside a Canvas handle.
    // @param [coords] (array) X, Y page position
    // @return (AutoTestLocator) Locator string allowing the AutoTest subsystem to find
    //   an equivalent DOM element on subsequent page loads.
    // @visibility external
    // @group autoTest
    //<
    getLocator : function (DOMElement, checkForNativeHandling, coords) {
        var lastEvent = isc.EH.lastEvent, fromEvent;
        if (lastEvent) {
            if (DOMElement == null) {
                DOMElement = lastEvent.nativeTarget;
                fromEvent = true;
            }
            if (coords == null) {
                coords = [isc.EH.getX(), isc.EH.getY()];
            }
        }
        var canvas;
        if (isc.isA.Canvas(DOMElement)) {
            canvas = DOMElement;
            DOMElement = canvas.getHandle();
        } else {
            canvas = isc.AutoTest.locateCanvasFromDOMElement(DOMElement);            
        }
        var locator = canvas ? canvas.getLocator(DOMElement, fromEvent, coords) : "";
        if (checkForNativeHandling && locator && locator != "" &&
            canvas.checkLocatorForNativeElement(locator, DOMElement)) 
        {
            locator = "";
        }
        return locator;

    },
    
    //> @classMethod AutoTest.getObjectLocator()
    // Method to derive a locator string for identifying a or SmartClient object. This is
    // a SmartClient component, a FormItem, or SectionStackSection.
    // <P>
    // Use +link{AutoTest.getObject()} to resolve an object locator to a live object.
    //
    // @param baseComponent (Canvas) base component for the relative locator
    // @param target (Canvas or FormItem or SectionStackSection) target for the relative locator. 
    // @return (AutoTestObjectLocator) generated locator
    // @visibility rules
    //<
    
    getObjectLocator : function (target) {
    
        // We can be passed
        // - a FormItem.
        // - a SectionStackSection.
        // - a Canvas.
        // _getCanvasForSCObject will resolve to the nearest "canvas" which will be
        // capable of generating a locator for the actual object.
        var targetCanvas = this._getCanvasForSCObject(target);
        var canvasLocator = targetCanvas.getLocator();

        if (targetCanvas == target) {
            return canvasLocator;
        }
        
        // The 'interiorLocator' will be the xpath to the target object, plus an "objectType" flag
        // we can parse back later.
        var interiorLocator = targetCanvas.getObjectLocator(target);
        if (interiorLocator != null) canvasLocator += "/" + interiorLocator;
        return canvasLocator;
    },
    
    // Helper - extract the "object type" from a locator string.
    
    getLocatorObjectType : function (locator) {
        var objectTypeInfo = locator.substring(locator.lastIndexOf("/")+1);
        if (objectTypeInfo && objectTypeInfo.startsWith("objectType=")) {
            return objectTypeInfo.substring(11);
        }
        return "Canvas";
    },

    
    //> @classMethod AutoTest.locateCanvasFromDOMElement()
    // Given an element in the DOM, returns the canvas containing this element, or null if
    // the element is not contained in any canvas handle.
    // @param element (DOMElement) DOM element within in the page
    // @visibility external
    // @group autoTest
    //<
    locateCanvasFromDOMElement : function (element) {
        
        return isc.EH.getEventTargetCanvas(null, element);
    },
    
    //> @classMethod AutoTest.getRelativeLocator()
    // Method to derive a relative locator string for identifying a DOMElement ultimately nested
    // within some baseComponent.
    // <P>
    // This is useful for cases where a standard pattern of components may be reused within
    // an application - for example multiple Windows containing the same UI within them.
    // In this case the developer can get a 'relative locator' from the base compoent (the Window)
    // to some nested DOM element (may be nested within a number of intervening canvaes),
    // and reuse the locator for other base components (in our example, 
    // other Windows) with the same structure of descendents.
    // <P>
    // Use +link{AutoTest.resolveRelativeLocator()} to resolve a relativeLocator plus
    // baseComponent SmartClient object.
    //
    // @param baseComponent (Canvas) base component for the relative locator
    // @param target (DOMElement) target for the relative locator. 
    // @return (AutoTestLocator) generated locator
    // @visibility rules
    //<
    getRelativeLocator : function (baseComponent, target) {
        // normal behavior if passed a DOM element:  
        var targetCanvas = this.locateCanvasFromDOMElement(target),
            locator = this.getRelativeCanvasLocator(baseComponent, targetCanvas) + "/" 
                        + targetCanvas.getInteriorLocator(target);
        return locator;
    },
    
    // helper to test whether some locator is relative or absolute
    isRelativeLocator : function (locator) {
        return (!locator.startsWith("//"));
    },
    
    getRelativeCanvasLocator : function (baseComponent, targetCanvas) {
        if (baseComponent == targetCanvas) return "";
        // Build the path (needs a loop)
        var currentCanvas = targetCanvas,
            locators = [];
        while (currentCanvas != baseComponent) {
            var parentCanvas = currentCanvas.getLocatorParent();
            // If we don't find a relationship between the base and the child 
            // there's not a lot we can do...
            if (parentCanvas == null) {
                this.logWarn("Unexpected error: attempting to get relative locator from baseCompoenent:"
                    + baseComponent + " and target:"+ targetCanvas + ". Unable to determine "
                    + "relationship between these objects.");
                return "";
            }
            var canvasLocator = parentCanvas.getChildLocator(currentCanvas);
            locators.add(canvasLocator);
            currentCanvas = parentCanvas;
        }
        // Locators array is backwards since we iterated up the hierarchy! flip and join
        var locatorString = "";
        for (var i = locators.length-1; i >=0; i--) {
            locatorString += locators[i];
            if (i != 0) locatorString += "/";
        }
        
        return locatorString;
    },
    
    //> @classMethod AutoTest.getRelativeObjectLocator()
    // Method to derive a relative locator string for identifying a or SmartClient object within 
    // some baseComponent.
    // <P>
    // This is useful for cases where a standard pattern of components may be reused within
    // an application - for example multiple Windows containing the same UI within them.
    // In this case the developer can get a 'relative locator' from the base compoent (the Window)
    // to some nested sub object, and reuse the locator for other base components (in our example, 
    // other Windows) with the same structure of descendents.
    // <P>
    // Use +link{AutoTest.resolveRelativeObjectLocator()} to resolve a relativeLocator plus
    // baseComponent SmartClient object.
    // <P>
    // <b>Note:</b> For working with relativeLocators and DOM elements directly, use
    // +link{AutoTest.getRelativeLocator()} and +link{AutoTest.resolveRelativeLocator()}.
    //
    // @param baseComponent (Canvas) base component for the relative locator
    // @param target (Canvas or FormItem or SectionStackSection) target for the relative locator. 
    // @return (AutoTestObjectLocator) generated locator
    // @visibility rules
    //<
    
    
    getRelativeObjectLocator : function (baseComponent, target) {
    
        // We can be passed
        // - a FormItem.
        // - a SectionStackSection.
        // - a Canvas.
        // _getCanvasForSCObject will resolve to the nearest "canvas" which will be
        // capable of generating a locator for the actual object.
        var targetCanvas = this._getCanvasForSCObject(target);
        var canvasLocator = this.getRelativeCanvasLocator(baseComponent, targetCanvas);

        if (targetCanvas == target) {
            return canvasLocator;
        }
        
        var interiorLocator = targetCanvas.getObjectLocator(target);
        if (interiorLocator != null) canvasLocator += "/" + interiorLocator;
        return canvasLocator;
        
    },
    _getCanvasForSCObject : function (target) {
        // Existing AutoTest APIs (getChildLocator etc) can't handle FormItem etc since
        // there's no property pointing to the containing widget (EG DynamicForm) which would
        // have an understanding of the object passed in.
        // We'll have to resolve these explicitly here looking at properties on the object
        // passed in.
        
        
        // SectionStackSection: We create a SectionHeader for each section (even if it isn't shown)
        // Grab this widget and use 'parentElement' to get a pointer to the stack
        if (target._sectionHeader != null) target = target._sectionHeader;
        if (target.isSectionHeader) {
            return target.parentElement;
        }
        
        // If passed a form item, use item.form
        if (isc.FormItem && isc.isA.FormItem(target)) return target.form;
        
        if (isc.isA.Canvas(target)) return target;
        
        this.logWarn("getRelativeLocatorObject() passed target object:" + this.echo(target) +
            " This is not a recognized supported SmartClient object - expected to be a " +
            "Canvas, FormItem or SectionStackSection only");
        return null;
        
    },
    
    // ------------------------------
    // Retrieving elements from the DOM based on locator string
       
    //> @classMethod AutoTest.getElement()
    // @param locator (AutoTestLocator) Locator String previously returned by 
    //       +link{AutoTest.getLocator()}
    // @return (DOMElement) DOM element this locator refers to in the running application, or
    // null if not found
    // @visibility external
    // @group autoTest
    //<
    
    getElement : function (locator) {
        return this.getAttribute(locator, isc.Canvas._$Element);
    },
    
    //> @classMethod AutoTest.getObject()
    // Given an +link{AutoTestLocator}, return the live SmartClient object it refers to, if any.
    // @param locator (AutoTestLocator) Locator String previously returned by 
    //       +link{AutoTest.getLocator()}
    // @return (Canvas or FormItem or SectionStackSection) target object, or null if
    //  unable to resolve the locator to a live object.
    // @visibility external
    // @group autoTest
    //<
    getObject : function (locator) {
        return this.getAttribute(locator, isc.Canvas._$Object);
    },

    //> @classMethod AutoTest.getValue()
    // Given an +link{AutoTestLocator} that refers to a live SmartClient object or a logical
    // subcomponent of that object, return the associated meaningful JS value, if any.
    // <P>
    // For example:
    // <ul>
    //     <li> For a locator to a ListGrid/CubeGrid cell, return the cell's value
    //     <li> For a locator to a FormItem, return the FormItem's value
    //     <li> For a locator to a ListGrid field header, return the checkbox/sorting state
    //     <li> For a locator to a Calendar EventWindow header or contents, return the text
    // </ul>
    // @param locator (AutoTestLocator) Locator String previously returned by 
    //       +link{AutoTest.getLocator()}
    // @return (Object) value associated with SC object if any, otherwise undefined
    // @visibility external
    // @group autoTest
    //<
    getValue : function (locator) {
        return this.getAttribute(locator, isc.Canvas._$Value);
    },
    
    getAttribute : function (locator, attribute) {
        if (!locator) return null;

        
        locator = locator.replace(/^(scLocator|ScID)=/i, "");
        
        // trim off quote chars from the start/end of the string
        
        if (locator.startsWith("'") || locator.startsWith('"')) locator = locator.substring(1);
        if (locator.endsWith("'") || locator.endsWith('"')) locator = locator.substring(0,locator.length-1);
        
        if (!locator.startsWith("//")) {
            // assume either just an ID or "ID=[ID]"
            if (locator.startsWith("ID=") || locator.startsWith("id=")) {
                locator = locator.substring(3);
            }
            locator = '//*any*[ID="' + locator + '"]';
        }

        var locatorArray = locator.split("/"),
            component;
            
        // account for the 2 slashes
        var baseComponentID = locatorArray[2];
        if (!baseComponentID) return null;
      
        // knock off the first 3 slots
        locatorArray = locatorArray.slice(3);

        var configuration = {attribute: attribute},
            baseComponent = this.getBaseComponentFromLocatorSubstring(baseComponentID,
                                                                      configuration);
        if (!baseComponent) return null;

        return baseComponent.getAttributeFromSplitLocator(locatorArray, configuration);
    },
    
    //> @classMethod AutoTest.resolveRelativeLocator()
    // Given a relative locator (retrieved from +link{AutoTest.getRelativeLocator()}) and a
    // base component, resolve it to the target element in the DOM.
    // @param baseComponent (Canvas) base component to resolve the relative locator from
    // @param relativeLocator (AutoTestLocator) relative locator retrieved from 
    //  +link{AutoTest.getRelativeLocator()}
    // @return (DOMElement) target DOM element, or null if unable to resolve the relative path.
    // 
    // @visibility rules
    //<
    resolveRelativeLocator : function (baseComponent, relativeLocator) {
        var splitLocatorArray = relativeLocator.split("/");
        return baseComponent.getAttributeFromSplitLocator(splitLocatorArray, 
                                                          {attribute: isc.Canvas._$Element});
    },

    //> @classMethod AutoTest.resolveRelativeObjectLocator()
    // Given a relative locator (retrieved from +link{AutoTest.getRelativeObjectLocator()}) and a
    // base component, resolve it to the target SmartClient object. The SmartClient object may
    // be one of:
    // <ul>
    // <li>A Canvas</li>
    // <li>A FormItem</li>
    // <li>A SectionStackSection</li>
    // </ul>
    // @param baseComponent (Canvas) base component to resolve the relative locator from
    // @param relativeLocator (AutoTestObjectLocator) relative locator retrieved from 
    //  +link{AutoTest.getRelativeObjectLocator()}
    // @return (Canvas or FormItem or SectionStackSection) target object, or null if
    //  unable to resolve the relative path.
    // 
    // @visibility rules
    //<
    resolveRelativeObjectLocator : function (baseComponent, relativeLocator) {
        var splitLocator = isc.isAn.Array(relativeLocator) ? relativeLocator : 
                                                             relativeLocator.split("/");
        return baseComponent.getAttributeFromSplitLocator(splitLocator, 
                                                          {attribute:isc.Canvas._$Object});
    },

    //> @classMethod AutoTest.getPageCoords()
    // Returns the page-level coordinates corresponding to the supplied locator.  Note: The
    // physical position might change due to app redesign, but these coordinates would still
    // reflect the same logical part of the DOM element for components where event position
    // matters.
    // @param locator (AutoTestLocator) Locator String previously returned by 
    //       +link{AutoTest.getLocator()}
    // @return (array) X, Y page position
    // @visibility external
    // @group autoTest
    //<
    getPageCoords : function (locator) {
        var element = this.getElement(locator);
        if (element == null) return;
        
        var canvas = this.locateCanvasFromDOMElement(element);    
        return canvas ? canvas.getAutoTestLocatorCoords(locator, element) : null;
    },

    
    // getBaseComponentFromLocatorSubstring: This actually gets the *base* component from
    // a locator substring.
    // 2 possibilities:
    // - explicit ID (respect that)
    // - part of the array of top-level canvii
    getBaseComponentFromLocatorSubstring : function (substring, configuration) {
        var IDMatches = substring.match("(.*)\\[");
        var IDType = IDMatches ? IDMatches[1] : null;

        switch (IDType) {
            // if the recorded canvas had an auto-generated ID, try to find it by looking in the
            // top level (no parent) canvas array.
            // We'll look by name, title, then index by class, scClass and role!
        case "autoID":
            
            var config = isc.AutoTest.parseLocatorFallbackPath(substring),
                widgetConfig = config.config,
                strategy = "name",
                typeStrategy = "Class";

            var canvas = isc.Canvas.getCanvasFromFallbackLocator(
                substring, widgetConfig, isc.Canvas._topCanvii, strategy, typeStrategy);
            if (canvas == null) {
                this.setLogFailureText(true, "there's no top level Canvas identifiable " +
                    "by name or Class from fallback locator '" + substring + "' for locator");
            }
            return canvas;

        case "testRoot":

            if (this.testRoot == null) {
                this.logWarn("Unable to process scLocators starting with " + this._$testRoot +
                             "... when no test root canvas has been configured");
                return null;
            }
            return this.testRoot;

        case "Menu":

            if (!isc.Menu) {
                this.setLogFailureText(true, "the Menu module is required " +
                                       "to resolve locator");
                return null;
            }

            var levelMatches = substring.match(/Menu\[level=(.*)(,.*)?\]/i),
                level = levelMatches ? levelMatches[1] : null;
            if (level != null) {
                var menu = isc.Menu.getMenuAtLevel(level);
                if (menu == null) {
                    this.setLogFailureText(true, "there is no Menu corresponding " + 
                                           "to level '" + level + "' for locator");
                }
                return menu;
            }

            // fall through to allow legacy Menu locators to work!!!

        default:
        
            var className = IDType, 
                IDMatches = substring.match('\\[ID=[\\"\'](.*)[\'\\"](,.*)?\\]'),
                ID = IDMatches ? IDMatches[1] : null;
            
            if (ID == null) {
                this.setLogFailureText(true, "there appears to be a " + 
                                       "problem with the syntax for locator");
                return null;
            }

            // install any declared property bindings into the configuration
            if (IDMatches[2]) this.installLocatorConfiguration(IDMatches[2], configuration);

            var baseComponent = window[ID];
            if (!baseComponent) {
                this.setLogFailureText(true, "there is no " + className + 
                                       "with ID '" + ID + "' for locator");
                return null;
            }

            if (baseComponent && className != "*any*" &&
                (!isc.isA[className] || !isc.isA[className](baseComponent))) 
            {
                this.logWarn("AutoTest.getElement(): Component:"+ baseComponent + 
                            " expected to be of class:" + className);
            }
            return baseComponent;
        }
    },

    //> @classMethod AutoTest.installLocatorConfiguration()
    // Inserts property bindings declared on scLocator into configuration object.
    // @param (String) bindings declaration from scLocator
    // @param (Object) configuration of this scLocator lookup
    //<
    installLocatorConfiguration : function (declaration, configuration) {
        if (!declaration) return;
        var bindings = declaration.split(",");
        for (var i = 0; i < bindings.length; i++) {
            var binding = bindings[i].trim().match("([^=]*)=([^=]*)");
            if (binding) configuration[binding[1]] = binding[2];
        }
    },

     // Retrieving SC objects from locator string
    //> @classMethod AutoTest.getLocatorCanvas()
    // Returns the Canvas for some previously generated locator string.
    // @param (AutoTestLocator) Locator String previously returned by +link{AutoTest.getLocator()}
    // @return (Canvas) Canvas associated with this locator
    // @visibility internal
    // @group autoTest
    //<
    
    getLocatorCanvas : function (locator) {
        
                
        // Simply get the DOM element and pick up the Canvas from it.
        // XXX this will not work if the Canvas is currently undrawn.
        /*
        var DOMElement = this.getElement(locator);
        if (DOMElement != null) {
            return this.locateCanvasFromDOMElement(DOMElement);
        }
        return null;
        */
        
        if (locator == null || isc.isAn.emptyString(locator)) return null;
        var locatorArray = locator.split("/"),
            component;
        
        // bail if the array isn't prefixed with expected '//' (scLocator is an xpath type identifier)
        if (locatorArray == null || locatorArray.length < 3) return null;
        
        //this.logWarn("locatorArray" + locatorArray);
        // account for the 2 slashes
        var baseComponentID = locatorArray[2];
        
        // knock off the first 3 slots
        var length = locatorArray.length;
        for (var i = 3; i < length; i++) {
            locatorArray[i-3] = locatorArray[i];
        }

        locatorArray.length = length-3;
        if (!baseComponentID) return null;
        
        var baseComponent = this.getBaseComponentFromLocatorSubstring(baseComponentID);
        if (baseComponent) {
            var i = 0,
                child = baseComponent.getChildFromLocatorSubstring(locatorArray[i], i, locatorArray);
            
            while (child != null) {
                i++;
                baseComponent = child;
                child = baseComponent.getChildFromLocatorSubstring(locatorArray[i], i, locatorArray);
            }
            return baseComponent;
        }
        return null;
    },
    
    //> @classMethod AutoTest.getLocatorFormItem()
    // Returns the FormItem for some previously generated locator string, or null if no
    // matching FormItem can be found.
    // @param (Locator) Locator String previously returned by +link{AutoTest.getLocator()}
    // @return (Canvas) Canvas associated with this locator
    // @visibility autoTest
    //<
    getLocatorFormItem : function (locator) {
        // Simply get the DOM element and pick up the DynamicForm/ FormItem from it.
        // XXX this will not work if the Canvas is currently undrawn.
        /*
        var DOMElement = this.getElement(locator);
        if (DOMElement != null) {
            var form = this.locateCanvasFromDOMElement(DOMElement);
            if (isc.isA.DynamicForm(form)) {
                var itemInfo = isc.DynamicForm._getItemInfoFromElement(DOMElement,form);
                if (itemInfo) return itemInfo.item;
            }
        }
        return null;
        */
            
        if (locator == null || isc.isAn.emptyString(locator)) return null;
        var locatorArray = locator.split("/"),
            component;
        
        // If it's not prefixed with "//", this isn't an SC-locator
        if (locatorArray == null || locatorArray.length < 3) return null;
            
        // account for the 2 slashes
        var baseComponentID = locatorArray[2];
        
        // knock off the first 3 slots
        var length = locatorArray.length;
        for (var i = 3; i < length; i++) {
            locatorArray[i-3] = locatorArray[i];
        }
        
        locatorArray.length = length-3;
        if (!baseComponentID) return null;
        
        var baseComponent = this.getBaseComponentFromLocatorSubstring(baseComponentID);
        if (baseComponent) {
            
            var child = baseComponent.getChildFromLocatorSubstring(locatorArray[0], 0, locatorArray);
            while (child != null) {
                locatorArray.removeAt(0);
                baseComponent = child;
                child = baseComponent.getChildFromLocatorSubstring(locatorArray[0], 0, locatorArray);
            }
        }
        if (isc.isA.DynamicForm(baseComponent)) {
            return baseComponent.getItemFromSplitLocator(locatorArray);
        }
        return null;
    },
    
    // Fallback locator subsystem:
    // For cases where there is more than one possible way to identify a component or element
    // we generate a string similar to this:
    // "row[a=b||b=c||7]"
    
    // createLocatorFallbackPath()
    // Takes a locator name and an object of the format:
    //   {fieldName:value, fieldName:value}
    // and returns a string in the format
    //   name[fieldName=value||fieldName=value...]
    // standalone values (with no "=" may also be included -- to do this set the "fallback_valueOnlyField"
    // property on the object passed in
    // For example:
    //   var identifier = {a:"b"};
    //   identifier[isc.AutoTest.fallback_valueOnlyField] = "c";
    //   isc.AutoTest.createLocatorFallbackPath("test", identifier);
    // would give back:
    //   "test[a:b||c]"
    
    fallback_valueOnlyField:"_$_standaloneProperty",
    
    fallback_startMarker:"[",
    fallback_endMarker:"]",
    fallback_separator:"||",
    fallback_equalMarker:"=",
    
    // If a property name contains the "/" character we can't store it as we use
    // simple string.split to break up based on this char.
    // Fix this by just sub-ing in a customizable marker when generating locators.
    
    slashMarker:"$fs$",
    
    createLocatorFallbackPath : function (name, config) {
        
        var locator = [];
        
        for (var field in config) {
            var fieldVal = config[field];
            
            // If a string contains "[", "||", etc we can get very confused
            // use 'escape' to HTML encode the string -- we'll unescape when parsing
            // We have to escape actual slashes too as this will break our logic to 
            // break up stored locators.
            // use a regex to just replace them with a customizeable marker
            if (isc.isA.String(fieldVal)) {
                fieldVal = fieldVal.replaceAll("/",this.slashMarker);
                fieldVal = escape(fieldVal);
            }
            
            // Not worrying about other data types for now
            // Numbers / bools will convert automatically
            // If it becomes necessary we could encode dates, arr's, objects etc
            // and unencode on the way back
                
            if (field == this.fallback_valueOnlyField) {
                locator.add(fieldVal);
            } else {
                locator.add(field + this.fallback_equalMarker + fieldVal);
            }
        }
        return name + this.fallback_startMarker + locator.join(this.fallback_separator) + 
                    this.fallback_endMarker;
    },

    _compareLocatorFallbackConfigValues : function (a, b) {
        if (isc.isA.Number(a) || isc.isA.Boolean(a)) a = a.toString();
        if (isc.isA.Number(b) || isc.isA.Boolean(b)) b = b.toString();
        return a == b;
    },
    
    // This method will take a generated locatorFallbackPath string and return a
    // standard config object as described above - property/field values will be unmapped
    // and any standalone value will be stored under the special
    // isc.AutoTest.fallback_valueOnlyField attribute name.
    parseLocatorFallbackPath : function (path) {
        var pathArr = path.split(this.fallback_startMarker);

        // don't crash if we were passed something we don't understand...
        if (pathArr == null || pathArr.length < 2) return;
        
        var name = pathArr[0],
            path = pathArr[1].substring(0, pathArr[1].length-this.fallback_endMarker.length);
            
        var configArr = path.split(this.fallback_separator),
            configObj = {};
        for (var i = 0; i < configArr.length; i++) {
            var string = configArr[i],
                equalsIndex = string.indexOf(this.fallback_equalMarker),
                fieldName;
                
            if (equalsIndex == -1) {
                fieldName = this.fallback_valueOnlyField;
            } else {
                fieldName = string.substring(0,equalsIndex);
                string = string.substring(equalsIndex+1);
            }
            
            // always unescape
            string = unescape(string);
            string = string.replaceAll(this.slashMarker, "/");
            configObj[fieldName] = string;
            
        }
        
        // BackCompat: Standard locator format (pre March 2010) was always of the format
        // item[1][Class="Canvas"]
        // This is still used where we don't run through the fallback-path subsystem but is
        // being incrementally replaced.
        // If we're passed a string of that format, pull the class out of the string passed in
        // and attach it to the config object.
        // This means that for any old auto-test recordings with the previous identifier format
        // if they end up running through this subsystem we should still have predictable results
        if (pathArr[2] != null) {
            var string = pathArr[2].substring(0, pathArr[2].length-this.fallback_endMarker.length),
                equalsIndex = string.indexOf(this.fallback_equalMarker),
                
                key = string.substring(0,equalsIndex),
                val = string.substring(equalsIndex+1);
            // if the string was quoted, eat the quotes!
            if (val.startsWith("\"")) val = val.substring(1, val.length-1);
            
            configObj[key] = val; 
        }
        
        return {name:name, config:configObj};
    },
    
    
    
    // Generate a standard object "locator fallback path" identifier from an object,
    // similar to:
    //  member[title="foo"||index=1||Class="ImgButton"]
    //
    // Parameters:
    // - name attribute specifies the identifier type (in this example "member")
    // - canvas is the object to get an identifier for
    // - properties is an object specifying some default identifier properties to use which
    //   cannot be directly retrieved from the object. Typically used to specify the
    //   index of the object in the named array.
    // - mask is an object or array specifying properties to include in the locator string.
    //   If an array of strings, for each element store the same-named attribute from the object
    //   on the locator string
    //   If an object, for each entry, pick up the value field from the object and store it
    //   under the key on the locator string
    // * When getting properties from the object, use getters if present
    // * if AutoTest.fallback_valueOnlyField is included this will be included in the 
    //   locator string with no key - for example
    //   member[1]
    //
    
    getObjectLocatorFallbackPath : function (name, object, properties, mask) {
        
        if (properties == null) properties = {};
      
        if (mask == null) mask = {
            title:"title",
            // we do this because widget.getClass() gives us the class object whereas
            // widget.getClassName gives us the name of the smartclient class...
            Class:"ClassName"
        };
        
        if (isc.isAn.Array(mask)) {
                
            for (var i = 0; i < mask.length; i++) {
                var value = object.getProperty ? object.getProperty(mask[i]) : object[mask[i]];
                if (value != null && !isc.isAn.emptyString(value)) properties[mask[i]] = value;
            }
        } else {
            for (var field in mask) {
                var value = object.getProperty ? object.getProperty(mask[field]) : object[mask[field]];
                if (value != null && !isc.isAn.emptyString(value)) properties[field] = value;
            }
        }
        
        // This will turn that config object into a standard locator type string.
        return isc.AutoTest.createLocatorFallbackPath(name, properties);
    },
    
    
    // Auto Test locators use various strategies to attempt to locate widgets. In some cases
    // we return a "best guess" type locator string -- for example an index in the members array
    // of a layout -- this is prone to return the wrong element if the page is restructured.
    // When actually retrieving elements from the DOM, we have some hints as to the fact that
    // our locator may be returning the wrong thing -- number of matching elements has changed
    // might be one of them, or the role / class of the widget we think matches is different
    // from what we recorded.
    // In these cases we'll log a warning.
    // This is a generic warning text which we can append to these warnings about how to
    // make identifying more robust in the future
    robustLocatorWarning:"If you are seeing unexpected results in recorded tests, it is likely" +
    " that the application has been modified since the test was recorded. We would recommend re-recording" +
    " your test script with the latest version of your application. Note that you may be able to" +
    " avoid seeing this message in future by using the AutoChild subsystem or providing explicit" +
    " global IDs to components whose function within the page is unlikely to change.",
    logRobustLocatorWarning : function () {
        if (this._loggedWarning) return;
        this.logWarn(this.robustLocatorWarning, "AutoTest");
        this._loggedWarning = true;
    },

    // This call provides a standard way to create a special DetailViewer instance
    // containing a set of test results (from .test file, Feature Explorer example, etc.)
    createDetailViewerForTestResults : function (canvas, results) {

        var seleniumPresent = isc.Browser.seleniumPresent;

        return isc.DetailViewer.create({
            ID:"isc_AutoTest_DetailViewer",
            left:canvas.getWidth() - 300,
            canDragReposition:true,
            width:280,
            showEmptyField:false,
            blockSeparator:"<BR>",
            autoDraw:true,
            fields: [{name:"result", 
                         valueMap:{ 
                             failure:  "<font style='color:red;'>failure</font>",
                             disabled: "<font style='color:blue;'>disabled</font>"
                         }
                     },
                     {name:"description", escapeHTML:true,
                         formatCellValue : function (value, record) {
                             
                             value = value.replace(/\s+/g, " ");
                             value = value.replace(/\<P\>/gi, "   ");
                             var showID = !seleniumPresent || !record._autoAssignedID;
                             if (record.ID && showID) value = record.ID + ": " + value;
                             if (value.length > 250) value = value.substring(0, 250) + "...";
                             return value;
                         }
                     },
                     {name:"detail", escapeHTML:true}],
            data : results
        });
    },

    setLogFailureForReturnValue : function (canvas, locatorArray, value, attribute) {
        var undef,
            clause = canvas.emptyLocatorArray(locatorArray) ? "directly with" :
                      "with the locator suffix '" + locatorArray.join("/") + "' of";
        canvas.setLogFailureText(true, "there is no " + attribute + " associated " +
                                 clause);
        return value;
    },

    getAttributeDefault : function (canvas, attribute) {
        switch (attribute) {
        case isc.Canvas._$Element: return canvas ? canvas._getHandleAndLogFailure() : null;
        case isc.Canvas._$Object:  return canvas ? canvas                           : null;
        case isc.Canvas._$Value:   return;
        }
    }

});

isc.ApplyAutoTestMethods = function () {




isc.Canvas.addClassMethods({

    // attributes that can queried from Canvas.getAttributeFromSplitLocator()
    _$Element: "element",
    _$Object:  "object",
    _$Value:   "value",                                 

    // substring param really just used for logging
    getCanvasFromFallbackLocator : function Canvas_getCanvasFromFallbackLocator (substring, 
                                                config, candidates, strategy, typeStrategy) 
    {
        // Given an array of possible candidates attempt to match as follows:
        
        // - if a 'name' was recorded,
        //  - match by name and class name
        //  - otherwise by name and scClassName
        //  - otherwise by name and scRole
        // - if a title was recorded
        //  - match by title  and class name
        //  - title / scClassName
        //  - title / role
        //
        // Otherwise back off to matching by index:
        //  - try to match by class name / index (of candidates with that className)
        //  - then by scClassName / index
        //  - then by role / index
        //  - then by raw index
        
        // Robustness:
        // We have a big one-time warning to log when we think what we're returning is
        // likely unreliable (see AutoTest.logRobustLocatorWarning())
        // We do this:
        //  - if we find a match by name but it doesn't match class, scclass or role
        //  - if we find a match by title but it doesn't match class scclass or role
        //      (If there is more than one match by title we ignore this strategy and back
        //       off to index with a different warning)
        //  - if, when attempting to find a match by index (by class scClass or role, or by
        //    raw index), we find the array length has changed (meaning the array has
        //    changed, so the index is probably worthless).
        //
        // We also log a less "things are broken" warning everytime we return
        // by raw index as this is very fragile.
        var name = config.name;
        
        // Some common things we're always going to try:
        var className = config.Class,
            // scClass will not have been recorded separately if the recorded class
            // is already a core class.
            scClassName = config.scClass || config.Class,
            role = config.scRole;
     
        
        switch (strategy) {
            
        case "name":
                            
            if (name != null) {
                var nameMatch = candidates.find("name", name);
                // we could check uniqueness as we do with title, but this seems very unlikely
                // to be necessary - name is only really used as a unique ID within some
                // array (though not globally unique)

                if (this.isValidFallbackLocatorCandidate(nameMatch)) {
                    
                    switch (typeStrategy) {
                        
                    case "Class": // scClass // role // none
                    
                      
                        if (className && isc.isA[className] && isc.isA[className](nameMatch)) {
                            if (this.logIsDebugEnabled("AutoTest")) {
                                this.logDebug("Locator string:" + substring + 
                                    " - returning widget with matching name and ClassName:" +
                                    nameMatch, "AutoTest");
                            }
                            return nameMatch;
                        }
                        
                    case "scClass":
                        
                        if (scClassName && isc.isA[scClassName] && isc.isA[scClassName](nameMatch)) 
                        {
                            if (this.logIsDebugEnabled("AutoTest")) {
                                this.logDebug("Locator string:" + substring + 
                                    " - returning widget with matching name and scClassName:" +
                                    nameMatch, "AutoTest");
                            }
                            return nameMatch;
                        }
                        
                    case "role":
                    
                        // If the classes don't match - see if the roles match
                        var scRole = config.scRole;
                        if (nameMatch.ariaRole == scRole) {
                            if (this.logIsDebugEnabled("AutoTest")) {
                                this.logDebug("Locator string:" + substring + 
                                    " - returning widget with matching name and role:" +
                                    nameMatch, "AutoTest");
                            }
                            return nameMatch;
                        }
                    
                    default:
                        
                        // In this case we've got a matching name but we can't match it to
                        // class or role. This is still the most likely candidate (better than
                        // backing off to checking index), so log a warning and return it:
                        
                        if (typeStrategy != "none") {
                            isc.AutoTest.logRobustLocatorWarning();
                            this.logWarn("Locator string:" + substring + 
                                ". Returning closest match:" + nameMatch + ". This has the same name " +
                                "as the recorded component but does not match class or role. ", "AutoTest");
                        } else {
                             if (this.logIsDebugEnabled("AutoTest")) {
                                this.logDebug("Locator string:" + substring + 
                                    " - returning widget with matching name:" +
                                    nameMatch, "AutoTest");
                            }
                        }
                            
                        return nameMatch;
                    }
                }
            }
            
            
            
        case "title":
            var title = config.title;
            if (title != null) {
                var titleMatches = candidates.findAll("title", title) || [];
                titleMatches = titleMatches.filter(this.isValidFallbackLocatorCandidate);
                if (titleMatches.length > 0) {
                    var titleMatch;
                    
                    switch (typeStrategy) {
                        
                    case "Class": // scClass // role // none
                        if (className) {
                            var titleInnerMatches = titleMatches.findAll("Class", className);
                            if (titleInnerMatches != null) {
                                titleMatch = titleInnerMatches[0];
                                if (titleInnerMatches.length == 1 && titleMatch) {
                                    if (this.logIsDebugEnabled("AutoTest")) {
                                        this.logDebug("Locator string:" + substring + 
                                            " - returning widget with matching title and ClassName:" +
                                            titleMatch, "AutoTest");
                                    }
                                    return titleMatch;
                                }
                            }
                        }
                        
                    case "scClass":
                        if (scClassName) {
                            var titleInnerMatches = titleMatches.findAll("_scClass", scClassName);
                            if (titleInnerMatches != null) {
                                if (titleInnerMatches.length == 1 || titleMatch == null)
                                    titleMatch = titleInnerMatches[0];
                               
                                if (titleInnerMatches.length == 1 && titleMatch) {
                                        
                                    if (this.logIsDebugEnabled("AutoTest")) {
                                        this.logDebug("Locator string:" + substring + 
                                            " - returning widget with matching name and scClassName:" +
                                            titleMatch, "AutoTest");
                                    }
                                    return titleMatch;
                                }
                            }
                        }
                    case "role":
                        if (role) {
                            var titleInnerMatches = titleMatches.findAll("ariaRole", role);
                            if (titleInnerMatches != null) {
                                if (titleInnerMatches.length == 1 || titleMatch == null)
                                    titleMatch = titleInnerMatches[0];
                               
                                if (titleInnerMatches.length == 1 && titleMatch) {
                                    
                                    if (this.logIsDebugEnabled("AutoTest")) {
                                        this.logDebug("Locator string:" + substring + 
                                            " - returning widget with matching title and role:" +
                                            titleMatch, "AutoTest");
                                    }
                                    return titleMatch;
                                }
                            }
                        }
                        
                    default:
                        // In this case we've got a matching title but we can't match it to
                        // class or role.
                        // Log the "unreliable locator" one time warning -- the fact that
                        // we couldn't find a match by class as well as title implies things
                        // must have changed since the recording was made...
                        //
                        // Return the match if it's unique, otherwise ignore it and move on to 
                        // matching by index.
                        
                        if (titleMatches.length == 1) {
                            
                            if (typeStrategy != "none") {
                                isc.AutoTest.logRobustLocatorWarning();
                               
                                this.logWarn ("Locator string:" + substring + ". Returning " +
                                              "closest match:" + titleMatches[0] + ". This " +
                                              "has the same title as the recorded component " +
                                              "but does not match class or role.", "AutoTest");
                            } else {
                                if (this.logIsDebugEnabled("AutoTest")) {
                                    this.logDebug("Locator string:" + substring + 
                                        " - returning widget with matching title:" +
                                        titleMatch, "AutoTest");
                                }
                            }
                            return titleMatches[0];
                        } else {
                            this.logWarn("Locator string:" + substring +
                                ", attempt to match by title failed -- multiple candidate components have this " +
                                "same title. Attempting to match by index instead.", "AutoTest");
                        }
                    } // end of inner switch
                }
            }
            
        // either strategy is "index" or we didn't find a title/name match
        default:
                
            
            // back off to index
            // We captured index per class name, per scClass and per role as well as the
            // raw index in the array.
            // Test them in that order.
            // Note that if the lengths have changed this is likely wrong!
             var classIndexMatch,
                scClassIndexMatch,
                roleIndexMatch;
                
             switch (typeStrategy) {
             case "Class": // scClass // role // none
              
    
                if (className && config.classIndex) {
                    var classMatches = candidates.findAll("Class", className);
                    if (classMatches && classMatches.length > 0) {
                        
                        classIndexMatch = classMatches[parseInt(config.classIndex)];
                        
                        if (classMatches.length == parseInt(config.classLength)) {
                        
                            if (this.logIsInfoEnabled("AutoTest")) {
                                this.logInfo("Locator string:" + substring + 
                                        " - returning widget with matching ClassName / index by ClassName:" +
                                        classIndexMatch, "AutoTest");
                            }
                            return classIndexMatch;
                        }
                        // If the lengths didn't match, the index is very likely unreliable
                        // Hang onto it to return it if we can't match by scClassName or role more
                        // reliably
                    }
                }
                
            case "scClass":
                
                if (scClassName && config.scClassIndex) {
                    
                    var scClassMatches = candidates.findAll("_scClass", scClassName);
                    if (scClassMatches && scClassMatches.length > 0) {
                        
                        scClassIndexMatch = scClassMatches[parseInt(config.scClassIndex)];
                        
                        if (scClassMatches.length == parseInt(config.scClassLength)) {
                        
                            if (this.logIsInfoEnabled("AutoTest")) {
                                this.logInfo("Locator string:" + substring + 
                                        " - returning widget with matching SmartClient superclass / index by ClassName:" +
                                        scClassIndexMatch, "AutoTest");
                            }
                            return scClassIndexMatch;
                        }
                        // If the lengths didn't match, the index is very likely unreliable
                        // Try roles before using this
                    }
                }
                
            case "role":
                
                if (role && config.roleIndex) {
                    
                    var roleMatches = candidates.findAll("ariaRole", role);
                    if (roleMatches && roleMatches.length > 0) {
                        
                        roleIndexMatch = roleMatches[parseInt(config.roleIndex)];
                        
                        if (roleMatches.length == parseInt(config.roleLength)) {
                        
                            if (this.logIsInfoEnabled("AutoTest")) {
                                this.logInfo("Locator string:" + substring + 
                                        " - returning widget with matching role / index by role:" +
                                        roleIndexMatch, "AutoTest");
                            }
                            return roleIndexMatch;
                        }
                    }
                }
                
            default:
                
                // At this point if we had class/scClass or role, we know the lengths have changed
                // so index is very unreliable.
                // In this case, or if the overall length has changed, log the robustLocatorWarning
                //
                // Then return our best guess
                if ((typeStrategy != "none" && (className || scClassName || role)) || 
                    (config.length != null && (parseInt(config.length) != candidates.length))) 
                {
                    isc.AutoTest.logRobustLocatorWarning();
                }
                
                var match = classIndexMatch || scClassIndexMatch || roleIndexMatch;
                if (match == null) {
                    var index = config[isc.AutoTest.fallback_valueOnlyField];
                    if (index == null) index = config.index;
                    index = parseInt(index);
                    
                    match = candidates[index];
                }
                
                if (match) {
                    this.logWarn("Locator string:" + substring +
                        " matching by index gave " + match +
                        ". Reliability cannot be guaranteed for matching by index if the underlying " +
                        "application undergoes any changes.", "AutoTest");
                    return match;
                }

            } // closes inner switch statement
        } // closes outer switch statement
        
        // if we're here, we didn't find any candidates, or didn't find a child within them.
        // This doesn't necessarily indicate any kind of failure: We use fallback locators
        // for elements within some components - EG list grid cells
        this.logDebug("AutoTest.getElement(): locator substring:" + substring + 
            " parsed to fallback locator name:" + name + 
            ", unable to find relevant child - may refer to inner element.", "AutoTest");
    },

    // Reject "bad" candidates such as those that are
    // - marked as destroyed
    // - not visible
    // - not drawn
    isValidFallbackLocatorCandidate : function 
    Canvas_isValidFallbackLocatorCandidate (candidate) {
       return candidate && !candidate.destroyed && candidate.isVisible() && candidate.isDrawn();
    }
});

// methods applied to Class are generally needed for both Canvas and FormItem
isc.Class.addClassMethods({

    // use fallback strategies to get at the right object from a stored path.
    getCanvasLocatorFallbackPath : function Class_getCanvasLocatorFallbackPath (name, 
                                               canvas, sourceArray, properties, mask)
    {
       if (properties == null) properties = {};
        
        if (mask == null) mask = {};
        else if (isc.isAn.Array(mask)) {
            var maskObj = {};
            for (var i = 0; i <mask.length; i++) {
                maskObj[mask[i]] = mask[i];
            }
            mask = maskObj;
        }
        
        // Always pick up the following attributes directly from the widget, if present
        if (mask.title == null) mask.title = "title";
        if (mask.scRole == null) mask.scRole = "ariaRole";
        if (mask.name == null) mask.name = "name";
        
        // ClassName / scClassName - this is more complex than just looking at attributes on
        // the widget:
        // We need to pick up the class name, and if that's not a core smartclient class, also
        // pick up the core superclass of that class so we can look at both
        var objectClass     = canvas.getClass(),
            objectClassName = canvas.getClassName();
        
        properties.Class = objectClassName;
        
        var scClassName;
        if (!objectClass.isFrameworkClass) {
            scClassName = objectClass._scClassName;
        }
        if (scClassName != null) properties.scClass = scClassName;
        
        // We also want to pick up index-based locators from the source array
        // Record both the index and the current length
        // Locating by index is always imperfect: If a developer changes the orders of
        // members (for example), it'll break.
        // However if the length is different when a recorded locator is parsed, we have
        // a really good indication that the index based locator is probably unreliable.
        if (sourceArray != null) {
            
            // Raw position in the array
            properties.index = sourceArray.indexOf(canvas);
            properties.length = sourceArray.length;

            // position within widgets of this class in the array
            // Use case: the developer adds something like a 'status label' at the top
            // of an array of buttons
            var matchingClass = sourceArray.findAll("Class", objectClassName);
            properties.classIndex = matchingClass.indexOf(canvas);
            properties.classLength = matchingClass.length;

            // position within widgets of this SmartClient class in the array
            // Use case: The developer subclasses a SmartClient component as the app matures
            // but the application layout stays the same, so an array of buttons becomes
            // an array of custom button subclasses
            if (scClassName != null) {
                var matchingSCClass = sourceArray.findAll("_scClass", scClassName);
                properties.scClassIndex = matchingSCClass.indexOf(canvas);
                properties.scClassLength = matchingSCClass.length;
            }
            
            // Position within widgets with this role in the warray
            // Use case: The smart client class changes due to (say) reskinning (moving from
            // a button to a stretchImgButton), but the role is unchanged
            if (canvas.ariaRole != null) {
                var matchingRoles = sourceArray.findAll("ariaRole", canvas.ariaRole);
                properties.roleIndex = matchingRoles.indexOf(canvas);
                properties.roleLength = matchingRoles.length;
            }
        }
        
        return isc.AutoTest.getObjectLocatorFallbackPath(name, canvas, properties, mask);
    }
    
});

isc.Class.addMethods({

    // given a childType -- for example "peers"
    // figure out the specified child locator strategy.
    // Works by looking for this.locate[pluralName]By -- EG
    // locatePeersBy
    getChildLocatorStrategy : function class_getChildLocatorStrategy (childType) {
        if (isc.AutoTest.locStrategyNames == null) {
            isc.AutoTest.locStrategyNames = {};
        }
        
        var attrName = isc.AutoTest.locStrategyNames[childType];
        if (attrName == null) {
            var pluralName = childType;
            if (isc.isA.String(this._locatorChildren[childType])) {
                pluralName = this._locatorChildren[childType];
            }
            attrName = isc.AutoTest.locStrategyNames[childType] =
                        "locate" + 
                        pluralName.substring(0,1).toUpperCase() + pluralName.substring(1) +
                        "By";
        }
        
        return this[attrName];
    },

    // Same type of logic for type-identifiers
    // checks for this.locate[pluralName]Type -- EG: locatePeersType
    getChildLocatorTypeStrategy : function class_getChildLocatorTypeStrategy (childType) {
           
        if (isc.AutoTest.locStrategyTypes == null) {
            isc.AutoTest.locStrategyTypes = {};
        }
        
        var attrName = isc.AutoTest.locStrategyTypes[childType];
        if (attrName == null) {
            var pluralName = childType;
            if (isc.isA.String(this._locatorChildren[childType])) {
                pluralName = this._locatorChildren[childType];
            }
            attrName = isc.AutoTest.locStrategyTypes[childType] =
                        "locate" + 
                        pluralName.substring(0,1).toUpperCase() + pluralName.substring(1) +
                        "Type";
        }
        
        return this[attrName];
    },
    
    
    getAutoChildLocator : function class_getAutoChildLocator (instance) {
        
        if (this._createdAutoChildren) {
            var ID = instance.getID();
            for (var childName in this._createdAutoChildren) {
                var children = this._createdAutoChildren[childName];
                if (children.contains(ID)) {
                    // common case this.header etc
                    if (instance == this[childName]) return childName;
                    else {
                        // create an array of the *live* auto children (not just their IDs)
                        // this allows us to figure out our index in that array as well as
                        // our index based on role!
                        var liveChildren = [];
                        for (var i = 0; i < children.length; i++) {
                            liveChildren[i] = window[children[i]];
                        }
                        return this.getCanvasLocatorFallbackPath(childName, instance, 
                                                                 liveChildren);
                    }
                }
            }
        }
        return null;
    },

    // substring param really just used for logging
    getChildFromFallbackLocator : function class_getChildFromFallbackLocator (substring,
                                                                  fallbackLocatorConfig)
    {
        var type = fallbackLocatorConfig.name,
            config = fallbackLocatorConfig.config;

        
        if (this == isc.AutoTest.testRoot && this.getScClassName() == "Canvas") {
             if (type == "member") type = "child";
        }

        // default logic:
        // we use the "name" to find candidate widgets, then use the config to
        // figure out which candidate we actually want
        var candidates = this.getFallbackLocatorCandidates(type);
        if (candidates && candidates.length > 0) {
            var strategy = this.getChildLocatorStrategy(type);
            if (strategy == null) strategy = "name";
            var typeStrategy = this.getChildLocatorTypeStrategy(type);
            if (typeStrategy == null) typeStrategy = "Class";
            
            var match = isc.Canvas.getCanvasFromFallbackLocator(
                            substring, config, candidates, 
                            strategy, typeStrategy);
            if (match != null) return match;
        }
        
        // if we're here, we didn't find any candidates, or didn't find a child within them.
        // This doesn't necessarily indicate any kind of failure: We use fallback locators
        // for elements within some components - EG list grid cells
        this.logDebug("AutoTest.getElement(): locator substring:" + substring + 
            " parsed to fallback locator name:" + type + 
            ", unable to find relevant child - may refer to inner element.", "AutoTest");
    },

    getFallbackLocatorCandidates : function class_getFallbackLocatorCandidates (name) {
    
        var candidates;
        
        // check _createdAutoChildren for autoChildren by autoChild name
        if (this._createdAutoChildren != null && this._createdAutoChildren[name] != null) {
            var IDs = this._createdAutoChildren[name];
            candidates = [];
            for (var i = 0; i < IDs.length; i++) {
                candidates[i] = window[IDs[i]];
            }
            
        // _locatorChildren object: This specifies a mapping between known cases where
        // we have an attribute on this widget containing an array of candidates
        // (EG the children array) and a known 'locator' childType name (EG "child")
        
        } else if (isc.isA.String(this._locatorChildren[name])) {
            candidates = this[this._locatorChildren[name]];
        
        // Also support the 'name' pointing directly to an attribute on this widget 
        // containing an array of candidate objects (So could store "children" directly
        // rather than using the remapping above).
        } else if (this[name] && isc.isAn.Array(this[name])) {
            candidates = this[name];
        }
        return candidates;
    },

    // getCanvasLocatorFallbackPath
    // generates a standard 'fallback path' to locate a widget from within a pool of widgets.
    // Used for locating mutliple auto children with the same name, members, peers, children
    // and so on.
    // The concept is that this'll capture as much information as possible so we can
    // use fallback strategies to get at the right object from a stored path.
    getCanvasLocatorFallbackPath : function class_getCanvasLocatorFallbackpath
                         (name, canvas, sourceArray, properties, mask) {
        return isc.Canvas.getCanvasLocatorFallbackPath(name, canvas, sourceArray,
                                                       properties, mask);
    },

    setLogFailureText : function class_setLogFailureText (locator, start, finish) {
        
        var callerFunc = isc.Class.getPrototype().setLogFailureText.caller || arguments.callee.caller,
            callerName = callerFunc.name || isc.Func.getName(callerFunc, true),
            logSlot = callerName.replace(/^.*[_]+([^_]+)/, "\137$1" ) + "Log";
        if (isc.AutoTest[logSlot]) return; // initial reporter has primacy
        isc.AutoTest[logSlot] = this._getLogFailureText(locator, start, finish);
    },

    _getDescription : function class__getDescription (locator) {
        var original = false,
            stable = this.hasStableID(),
            description = this.getScClassName();
            
        // locator true means to add on the original locator
        if (locator == true) {
            locator = false;
            original = true;
        }
        // if the ID is not stable, define the current locator
        if (stable) description += " with ID " + this.ID;
        else if (!isc.isA.String(locator)) locator = this.getLocator();

        // now if either just defined or passed it, set current locator
        if (locator) description += " identified by " + locator;

        // the original locator is now added at the end if required
        if (original) description += isc.AutoTest._createLocatorMarker(locator);

        return description;
    },

    _getLogFailureText : function class__getLogFailureText (locator, start, finish) {
        var description = "the " + this._getDescription(locator);

        if (finish && !finish.match(/^[.,;:\\s]/)) finish = " " + finish;

        if (start)  description  = start + " " + description;
        if (finish) description += finish;

        return description;
    },

    // Should this widget's ID be used during scLocator generation?
    
    hasStableID : function class_hasStableID () {
        if (this._autoAssignedID) return false;

        
        var idPrefixParent = this.creator || this.locatorParent;
        if (idPrefixParent != null) return idPrefixParent.hasStableID();

        return true;
    }
    
});
    
isc.Canvas.addMethods({
    
    //> @method canvas.getLocator()
    // Get an abstract Locator String for an element contained within this Canvas
    // @param (DOMElement) DOM element contained within this Canvas
    // @return (Locator) abstract Locator String
    // @visibility autoTest
    //<
    // No apparent need to expose this directly, unless we are ready to support developers
    // writing their own locator logic in addition to the defaults
    ///
    // Additional 'fromEvent' param tells us we're actually retriving the target for the
    // current mouse event
    // In some cases we can use this to get additional info that isn't available from the
    // actual target element (EG target cell in a GR when showing a floating embedded componet)
    getLocator : function canvas_getLocator (element, fromEvent, coords) {
        var baseLocator = this.getLocatorInternal();
        if (!element) return  baseLocator;
        return [baseLocator, this.getInteriorLocator(element, fromEvent, coords)].join("/");
    },

    // internal logic to return normal or testRoot-based locator
    getLocatorInternal : function canvas_getLocatorInternal (ignoreTestRoot, 
                                                             skipAbsoluteLocator) 
    {
        var parent, absoluteLocator;

        
        var testRoot = ignoreTestRoot ? null : isc.AutoTest.testRoot;
        if (testRoot != this) {

            
            if (this._generated || this.locatorParent || this.creator || !this.hasStableID()) {
                parent = this.getLocatorParent();
            }

            
            if (testRoot != null && parent == null) {
                if (!skipAbsoluteLocator) {
                    skipAbsoluteLocator = true;
                    absoluteLocator = this.getLocatorInternal(true);
                }
                parent = this.getLocatorParent();
            }
        }

        var baseLocator = !parent ? this.getLocatorRoot() : 
            parent.getLocatorInternal(false, skipAbsoluteLocator) + "/" +
            parent.getChildLocator(this);

        return absoluteLocator != null && !baseLocator.startsWith(isc.AutoTest._$testRoot) ?
            absoluteLocator : baseLocator;
    },
    
    // We support generating locators for logical SmartClient objects that aren't necessarily
    // canvii such as FormItems and SectionStackSections
    
    // This method is called to get the locator for some logical object nested within this canvas.
    // Return null to indicate no locator (or object not understood, etc).
    // Subclasses such as DynamicForm will override with concrete implementations.
    getObjectLocator : function canvas_getObjectLocator (target) {
     },

    _locatorRootTemplate: [
    "//",
    ,   // classname
    '[ID="',
    ,   // global ID
    '"]'
    ],
    getLocatorRoot : function canvas_getLocatorRoot () {
        
        if (!this.locatorRoot) {
            // If this widget is the test root, return a special locator based on that.
            // If the widget has an explicitly specified ID always use it above all else!
            // Otherwise we'll use the "fallbackLocator" pattern to find it
            if (this == isc.AutoTest.testRoot) {
                this.locatorRoot = isc.AutoTest._$testRoot;
            } else if (!this.hasStableID() && this.parentElement == null) {
                this.locatorRoot = "//" +
                    isc.Canvas.getCanvasLocatorFallbackPath("autoID", this, isc.Canvas._topCanvii);
            } else {
                this._locatorRootTemplate[1] = this.getClassName();
                this._locatorRootTemplate[3] = this.getID();
                this.locatorRoot = this._locatorRootTemplate.join(isc.emptyString);
            }
        }
        return this.locatorRoot;
    },
    
    containsLocatorChild : function canvas_containsLocatorChild (canvas) {
        if (this.namedLocatorChildren != null) {
            for (var i = 0; i < this.namedLocatorChildren.length; i++) {
                var name = this.namedLocatorChildren[i];
                if (isc.isAn.Object(name)) name = name.attribute;
                if (canvas == this[name]) {
                    return true;
                }
            }
        }
        return false;
    },
    
    getLocatorParent : function canvas_getLocatorParent () {
        // locatorParent -- this is a generic entry point allowing special locator parent/child
        // behavior. 
        // To make use of this a widget could set itself as the locatorParent of some other
        // widget, and implement custom 'containsLocatorChild()' / 'getChildLocator()'  
        if (this.locatorParent && this.locatorParent.containsLocatorChild && 
            this.locatorParent.containsLocatorChild(this)) 
        {
            return this.locatorParent;
        }
        // Canvas and FormItem both support 'getAutoChildLocator'
        if (this.creator && (isc.isA.Canvas(this.creator) || isc.isA.FormItem(this.creator))) {
            var autoChildName = this.creator.getAutoChildLocator(this);
            if (autoChildName == null) {
                // failed to find the child - most likely created via 'createAutoChild' but
                // never ran through addAutoChild() which would make it detectable in the
                // getAutoChildLocator() method
                // This is likely to happen if we are using the auto-child system to create
                // numerous auto-children with common properties, so it's not really a
                // failure.
                // Allow this to continue through the standard master-peer / parent-child
                // logic.
                this.logInfo("Locator code failed to find relationship between parent:"+
                            this.creator.getID() + " and autoChild:"+ this.getID(), "AutoTest");
            } else {
                return this.creator;
            }
        }
        return this.masterElement || this.parentElement;
    },
    
  
    //> @method canvas.getChildLocator()
    // Get the abstract Locator string for finding a child canvas within its parent element 
    // @param (Canvas)
    // @return (Locator) abstract Locator String for finding this child
    //<
    // Leave this internal - developers would call getLocator() directly
    _childLocatorTemplate:[
        ,   // "child" or "peer"
        "[",
        ,   // index of child/peer
        '][Class="',
        ,   // className of child/peer
        '"]'
    ],
     
    
    getChildLocator : function canvas_getChildLocator (canvas) {
        // special case scrollbars
        if (canvas == this.hscrollbar) {
            return "hscrollbar";
        }
        if (canvas == this.vscrollbar) {
            return "vscrollbar";
        }
        
        // More general behavior split into 2 parts for easy overriding - autoChildren are pretty
        // much always respected over other locators such as children / members array
        if (canvas.creator == this) {    
            var autoChildID = this.getAutoChildLocator(canvas);
            if (autoChildID) return autoChildID;
        }
        
        return this.getStandardChildLocator(canvas);
    },
    
    // Called when AutoTest.getLocator() is called with the checkNativeElement parameter.
    // This method tests for the case where we have an element that natively 
    // "has meaning" in terms of events (IE eventHandledNatively is true) and our generated
    // SC-locator won't get back to that element.
    // Example case: A link written into a canvas handle -- the locator will likely point to
    // the canvas, while the link itself is the element that should be recorded.
    // In this case testing tools such as selenium may be able to get a better identifier 
    // based on (EG) ID of the link element.
    //
    // We do have cases where a widget writes out a live element which will handle native events
    // but we already handle generating a full locator to get at them (rather than just the
    // canvas handle). Example case: link elements within the month view of a calendar widget.
    // 
    // We test for this case by doing a round-trip test - if the locator already directly
    // points to the element (via AutoTest.getElement()), we use the locator.
    //
    
    // Implemented at the Canvas level so we can override this in subclasses if appropriate.
    checkLocatorForNativeElement : function canvas_checkLocatorForNativeElement (locator, element) {
        if (element == null || locator == null) return false;
        
        return (isc.EventHandler.eventHandledNatively("mousedown", element, true) &&
                (isc.AutoTest.getElement(locator) != element));
    },

    getNamedLocatorChildString : function canvas_getNamedLocatorChildString (canvas) {
         
        // Fairly common pattern - this.<someAttribute> is set directly to the canvas
        // but for whatever reason it didn't go through the addAutoChild() subsystem.
        // We can handle this explicitly by:
        // - setting locatorParent on the child to point to this widget
        // - adding an entry to the "namedLocatorChildren" array with the attribute name
        if (canvas.locatorParent == this && this.namedLocatorChildren) {
            for (var i = 0; i < this.namedLocatorChildren.length; i++) {
                var name = this.namedLocatorChildren[i],
                    attrName = name;
                    
                // support an object of the format {name:"name", attribute:"attributeName"}
                // This allows us to defeat changing obfuscated names like "_editRowForm"
                if (isc.isA.Object(name)) {
                    attrName = name.attribute,
                    name = name.name;
                }
                if (canvas == this[attrName]) {
                    return name;
                }
            }
        }
    },
    
    getStandardChildLocator : function canvas_getStandardChildLocator (canvas) {
        var nlcs = this.getNamedLocatorChildString(canvas);
        if (nlcs) return nlcs;
       
        
        if (canvas.getMasterCanvas() == this) {
            return this.getCanvasLocatorFallbackPath("peer", canvas, this.peers);
            
        } else if (canvas.getParentCanvas() == this) {
            return this.getCanvasLocatorFallbackPath("child", canvas, this.children);
        } else {
            // Not clear what would cause this - we already catch the autoChild case, 
            // so this is really a sanity check only
            this.logWarn("unexpected error - failed to find relationship between parent:"+
                        this.getID() + " and child:"+ canvas.getID());
            // return the standard root ID for the canvas - when parsing the strings back
            // we will have to explicitly catch this case?
            return canvas.getLocatorRoot();
        }
    },
    
    //> @method canvas.getInteriorLocator()
    // Get a relative Locator for an element contained within this Canvas
    // @param (DOMElement) DOM element contained within this Canvas
    // @return (Locator) abstract Locator String
    //<
    // Overridden to provide standard "meaningful locations" for ListGrids, DynamicForm, etc
    getInteriorLocator : function canvas_getInteriorLocator (element, fromEvent, coords) {
        if (element && this.useEventParts) {
            var partObj = this.getElementPart(element);
            if (partObj != null && partObj.part != null) {
                // This will be of the format "partType_partID"
                return (partObj.partID && partObj.partID != isc.emptyString) ? 
                                        partObj.part + "_" +  partObj.partID : partObj.part;
            }
        }
        if (coords && this.canDragResize) {
            var edgeLocator = this.getEventEdge(null, coords);
            if (edgeLocator) return edgeLocator;
        }
        return isc.emptyString;
    },
    
    // -------------------------
    // Retrieving dom elements from locator strings
    //> @method canvas.getAttributeFromSplitLocator()
    // Given a locator string split into an array, return specified attribute.
    // @param (Locator Array) array of strings
    // @param (object) configuration for request
    // @return (Object) requested attribute
    // @visibility internal
    //<
    // Internal - the parameter format does not match the Locator format returned by
    // canvas.getLocator -- developers should call AutoTest.getElement() rather than directly 
    // accessing this method
    getAttributeFromSplitLocator : function canvas_getAttributeFromSplitLocator (locatorArray,
                                                                                 configuration) 
    {
        var attribute = configuration.attribute,
            child = this.getChildFromLocatorSubstring(locatorArray[0], 0, locatorArray,
                                                      configuration);

        // return value if requested and it was set when the child was located
        if (configuration.value != null) return configuration.value;

        if (child) {
            locatorArray.removeAt(0);
            return child.getAttributeFromSplitLocator(locatorArray, configuration);
        }

        // stop searching for an object and return this Canvas unless it's a DynamicForm
        if (attribute == isc.Canvas._$Object && !isc.isA.DynamicForm(this)) return this;
        
        // split finding attribute within our handle to a separate method for simpler override
        return this.getInnerAttributeFromSplitLocator(locatorArray, configuration);
    },
    
    // Given a substring extracted from a split locator array, return the child widget
    // that matches the specified substring.
    // If there is no matching child, return null - we'll then treat this widget as the
    // innermost child widget treat any remaining locator info as an interior locator
     
    getChildFromLocatorSubstring : function canvas_getChildFromLocatorSubstring (substring, 
                                                                                 index, 
                                                                                 locatorArray)
    {
        if (substring == null || substring == "") return null;
        
        // Standard formats:
        // 
        // Attribute pointing directly to widget:
        // EG:
        // - vscrollbar/hscrollbar 
        // - named autoChild
        // - things in the "namedLocatorChildren" array
        
        if (isc.isA.Canvas(this[substring])) {
            return this[substring];
        }
        
        // - standard attribute<-->name mappings in the namedLocatorChildren array:
        if (this.namedLocatorChildren != null) {
            var rename = this.namedLocatorChildren.find("name", substring);
            if (rename != null) {
                var canvas = this[rename.attribute];
                if (isc.isA.Canvas(canvas)) return canvas;
                this.logWarn("Locator substring:" + substring 
                    + " remaps to attribute:" + rename.attribute + 
                    " but no canvas exists under that attribute name.", "AutoTest");
                // this is probably a failure - could return null here or keep going
                // - keep going in case some other strategy finds the component?
            }
        }
        
        // Fallback locators ([childType][fallback locator for specific child])
        // EG:
        // - autoChildName[<fallback locator within auto children>]
        // - children[<fallback locator>]
        // - members[<fallback locator>]
        var fallbackLocatorConfig =  isc.AutoTest.parseLocatorFallbackPath(substring);
        if (fallbackLocatorConfig != null) {
            var child = this.getChildFromFallbackLocator(substring, fallbackLocatorConfig);
            if (child == null) {
                this.setLogFailureText(true, null, "has no child identifiable " +
                                       "by the fallback locator '" + substring + "'");
            }
            return child;
        }

        // if we're here, we didn't find any candidates, or didn't find a child within them.
        // No need to warn here -- this is likely to happen if the remaining identifier is
        // an inner element locator
        return null;
        
    },
    
    //> @type LocatorStrategy
    // The AutoTest subsystem relies on generating and parsing identifier strings to identify
    // components on the page. A very common pattern is identifying a specific component
    // within a list of possible candidates. There are many many cases where this pattern
    // is used, for example - members in a layout,tabs in a tabset, sections in a section stack.
    // <P>
    // In order to make these identifiers as robust as possible across minor
    // changes to an application, (such as skin changes, minor layout changes, etc) the
    // system will store multiple pieces of information about a component when generating
    // an identification string to retrieve it from a list of candidates.
    // The system has a default strategy for choosing the order in which to look at these
    // pieces of information but in some cases this can be overridden by setting
    // a <code>LocatorStrategy</code>.
    // <p>
    // By default we use the following strategies in order to identify a component from a list of
    // candidates:
    // <UL><li><code>name</code>: Does not apply in all cases but in cases where a specified
    //   <code>name</code> attribute has meaning we will use it - for example for
    //  +link{SectionStackSection.name,sections in a section stack}.</li>
    // <li><code>title</code>: If a title is specified for the component this may be used
    //   as a legitimate identifier if it is unique within the component - for example
    //   differently titled tabs within a tabset.</li>
    // <li><code>index</code>: Locating by index is typically less robust than by name or
    //   title as it is likely to be effected by layout changes on the page.</li>
    // </UL>
    // If an explicit strategy is specified, that will be used to locate the component if 
    // possible. If no matching component is found using that strategy, we will continue to
    // try the remaining strategies in order as described above. In other words setting
    // a locatorStrategy to "title" will skip attempting to find a component by name, and
    // instead attempt to find by title - or failing that by index.
    // <P>
    // Note that we also support matching by type (see +link{type:LocatorTypeStrategy}).
    // Matching by type is used if we were unable to match by name or title or to disambiguate
    // between multiple components with a matching title.
    //
    // @value "name" Match by name if possible.
    // @value "title" Match by title if possible.
    // @value "index" Match by index
    // @visibility external
    // @group autoTest
    //<
    
    //> @type LocatorTypeStrategy
    // When attempting to identify a component from within a list of possible candidates
    // as described +link{type:LocatorStrategy,here}, if we are unable to find a unique match
    // by name or title, we will use the recorded "type" of the component to verify
    // an apparent match.
    // <P>
    // By default we check the following properties in order:
    // <ul><li>Does the Class match?</li>
    //     <li>If this is not a +link{Class.isFrameworkClass,framework class}, does the
    //         core framework superclass match?</li>
    //     <li>Does the <code>role</code> match?</li>
    // </ul>
    // In some cases an explicit locatorTypeStrategy can be specified to modify this
    // behavior. As with +link{type:LocatorStrategy}, if we are unable to match using the
    // specified type strategy we continue to test against the remaining strategies in order - 
    // so if a type strategy of "scClass" was specified but we were unable to find a match
    // with the appropriate core superclass, we will attempt to match by role.
    // Possible values are:
    // @value "Class" Match by class if possible
    // @value "scClass" Ignore specific class and match by the SmartClient framework superclass.
    // @value "role" Ignore class altogether and attempt to match by role
    // @value "none" Don't attempt to compare type in any way
    // @visibility external
    // @group autoTest
    //<

    //> @attr Canvas.locateChildrenBy (LocatorStrategy : null : IRWA)
    // Strategy to use when locating children in this canvas from an autoTest locator string.
    // 
    // @visibility external
    // @group autoTest
    //<
    
    //> @attr Canvas.locateChildrenType (LocatorTypeStrategy : null : IRWA)
    // +link{type:LocatorTypeStrategy} to use when finding children within this canvas.
    // @visibility external
    // @group autoTest
    //<
    
    //> @attr Canvas.locatePeersBy (LocatorStrategy : null : IRWA)
    // Strategy to use when locating peers of this canvas from an autoTest locator string.
    // 
    // @visibility external
    // @group autoTest    
    //<
    
    //> @attr Canvas.locatePeersType (LocatorTypeStrategy : null : IRWA)
    // +link{type:LocatorTypeStrategy} to use when finding peers of this canvas.
    // @visibility external
    // @group autoTest
    //<
    
    _locatorChildren:{
        peer:"peers",
        child:"children"
    },
    
    emptyLocatorArray : function canvas_emptyLocatorArray (locatorArray) {
        return locatorArray == null || locatorArray.length == 0 ||
                (locatorArray.length == 1 && locatorArray[0] == "");
    },
    
    getInnerAttributeFromSplitLocator : function canvas_getInnerAttributeFromSplitLocator (
        locatorArray, configuration) 
    {
        if (configuration.attribute == isc.Canvas._$Value) {

            

            if (isc.Label && isc.isA.Label(this) || 
                (isc.HTMLFlow    && isc.isA.HTMLFlow(this)) &&
                (isc.EventWindow && isc.isA.EventWindow(this.parentElement)))
            {
                var contents = this.getContents();
                if (contents) return contents;
            }
            this.setLogFailureText(true, "the trailing locator suffix '" +
                                   locatorArray.join("/") + "' does not identify any " +
                                   "meaningful part of");
            return;
        }
        
        if (!this.emptyLocatorArray(locatorArray)) {
            // support event-parts in all canvii
            if (locatorArray.length == 1) {
                
                var parts = locatorArray[0].split("_");
                
                var part = {
                        part:   parts[0],
                        partID: parts[1]
                    };
                var element = this.getPartElement(part);
                if (element) return element;

                // return correct edge rather than center if locator has edge part
                if (this._isValidEdge(part.part)) return this._getHandleAndLogFailure();
            }
            
            
            if (configuration.locatorMatching != "permissive") {
                this.setLogFailureText(true, "the trailing locator suffix '" +
                                       locatorArray.join("/") + "' does not identify any AutoChild " +
                                       "or Event Part of", "and permissive mode is not active");
                return null;
            }
        }

        return this._getHandleAndLogFailure();
    },
      
    // Retrieving coordinates based on element / locator string
    getAutoTestLocatorCoords : function canvas_getAutoTestLocatorCoords (locator, element) {

        // we assume both are present for now
        if (locator == null || element == null) return null;

        // If we're writing out double-divs, and the element passed in is our 
        // content-handle, look at the position of the clip-handle rather than the
        // content handle.
        // This is required to avoid potentially returning a coordinate outside the
        // visible widget space if we're overflow:"hidden" and the content handle is clipped
        if (this.getHandle() == element) element = this.getClipHandle();

        var rect = isc.Element.getElementRect(element);
        // return the center of the element
        
        var left   = rect[0],
            width  = rect[2];
        var top    = rect[1],
            height = rect[3];

        // return correct edge rather than center if locator has edge part
        var partLocator = locator.split("/").last(),
            isValidEdge = this._isValidEdge(partLocator);

        if      ( isValidEdge &&  partLocator.contains("B")) top += height;
        else if (!isValidEdge || !partLocator.contains("T")) top += Math.floor(height/2);

        if      ( isValidEdge &&  partLocator.contains("R")) left += width;
        else if (!isValidEdge || !partLocator.contains("L")) left += Math.floor(width/2);

        return [left,top];
    },

    _getHandleAndLogFailure : function canvas__getHandleAndLogFailure() {
        var handle = this.getHandle();
        if (handle != null) return handle;

        var start = "null", finish;
        if (!this.isDrawn()) finish = "which is not drawn";
        else if (!this.handleDrawn()) start = "not drawn";

        start = "the DOM element handle is " + start + " for";

        this.setLogFailureText(true, start, finish);
    },

    _isValidEdge : function canvas__isValidEdge (edgePart) {
        var map = this.edgeCursorMap;
        return edgePart && map != null && map[edgePart] != null;
    },

    _isProcessingDone : function canvas__isProcessingDone (strictMode) {
        if (strictMode && !this.isDrawn()) return true;
        return isc.AutoTest.isCanvasDone(this) != false;
    }

});

// -----------------------------------------------------------------
// Override getPartElement() for special cases
if (isc.Scrollbar) {
    isc.Scrollbar.addMethods({
        getPartElement : function scrollbar_getPartElement(partObj) {
            if (partObj.part == "start") {
                return this.getImage(this.startImg.name);
            } else if (partObj.part == "end") {
                return this.getImage(this.endImg.name);
            }
            return this.Super("getPartElement", arguments);
        }
    });
}

// -----------------------------------------------------------------
// Override getChildLocator() for special cases

if (isc.Layout) {
    isc.Layout.addProperties({
            
        //> @attr Layout.locateMembersBy (LocatorStrategy : null : IRWA)
        // Part of the +link{group:automatedTesting} system, strategy to use when generated
        // locators for members from within this Layout's members array.
        // 
        // @visibility external
        // @group autoTest
        //<
        
        //> @attr Layout.locateMembersType (LocatorTypeStrategy : null : IRWA)
        // +link{type:LocatorTypeStrategy} to use when finding members within this layout.
        // @visibility external
        // @group autoTest
        //<
        
            
        getStandardChildLocator : function canvas_getStandardChildLocator (canvas) {
            var nlcs = this.getNamedLocatorChildString(canvas);
            if (nlcs) return nlcs;
            
            if (this.members.contains(canvas)) {
                return this.getCanvasLocatorFallbackPath("member", canvas, this.members);
            }
            
            return this.Super("getStandardChildLocator", arguments);
        },
        
        
        _locatorChildren:{
            member:"members",
            peer:"peers",
            child:"children"
        }
    });
}

if (isc.Window) {
    isc.Window.addProperties({
        // Code in Window.js sets up Windows as the 'locatorParent' of their items
        containsLocatorChild : function window_containsLocatorChild (canvas) {
            if (this.items && this.items.contains(canvas)) return true;
            return this.Super("containsLocatorChild", arguments);
        },
        getStandardChildLocator : function window_getStandardChildLocator (canvas) {
        
            if (this.items && this.items.contains(canvas)) {
                var template = this._childLocatorTemplate;
                template[0] = "item";
                template[2] = this.items.indexOf(canvas);
                template[4] = canvas.getClassName();
                
                return template.join(isc.emptyString);
            }
            
            return this.invokeSuper(isc.Window, "getStandardChildLocator", canvas);            
        },
        
        _locatorChildren:{
            item:"items",
            member:"members",
            peer:"peers",
            child:"children"
        }
    });
}

if (isc.Dialog) {
    isc.Dialog.addProperties({
        _getDescription : function dialog__getDescription (locator) {
            var title   = this.title   || "",
                message = this.message || "",
                description = this.Super("_getDescription", arguments);
            if (title   != "") description = "'" + title + "' " + description;
            if (this.isModal)  description = "modal " + description;
            if (message != "") description += " with message \"" + message + "\"";
            return description;
        }
    });
}

if (isc.SectionStack) {
    
    // add the _locatorChildren for SectionHeader / ImgSectionHeader - this will
    // allow them to parse the item[fallbacklocator] generated by the
    // sectionStack standard child locator override below
    isc.ImgSectionHeader.changeDefaults("_locatorChildren", {item:"items"});
    isc.SectionHeader.changeDefaults("_locatorChildren", {item:"items"});

    
    // add sections to locatorChildren for SectionStack - allows it to parse the
    // section[fallbackLocator] we create below
    isc.SectionStack.changeDefaults("_locatorChildren", {section:"sections"});
    
    isc.SectionStack.addProperties({
    
        // Override getObjectLocator to handle being passed a SectionStackSection
        getObjectLocator : function sectionStack_getObjectLocator (object) {
            if (object.getSectionHeader) object = object.getSectionHeader();

            // getStandardChildLocator should already handle returning section[name="foo"]
            if (object.isSectionHeader) {
                var sectionLocator = this.getStandardChildLocator(object);
                // hang an 'objectType' flag on the object locator so we can easily figure out
                // what this thing actually is
                sectionLocator += "/objectType=Section";
                return sectionLocator;
            }                
            return this.Super("getObjectLocator", arguments);
        },
        
            
        // override getStandardChildLocator - for sections return 
        //  section[name="name"||title="title"||3]
        // for items, append
        //  item[0]
        getStandardChildLocator : function sectionStack_getStandardChildLocator (canvas) {
            var sections = this.sections || [],
                locatorString;
            for (var i = 0; i < sections.length; i++) {
    
                var items = sections[i].items,
                    section, item;
                if (canvas == sections[i]) {
                    section = canvas;
                    
                } else if (items && items.contains(canvas)) {
                    
                    section = sections[i];
                    item = canvas;
                }
                
                if (section != null) {
                    
                    // This will pick up name by default, then title, index, etc
                    locatorString = this.getCanvasLocatorFallbackPath("section", section, this.sections);
                }
                
                if (item != null) {
                    locatorString += "/" + this.getCanvasLocatorFallbackPath("item", item, section.items);
                }
                if (locatorString != null) return locatorString;
            }
            
            return this.Super("getStandardChildLocator", arguments);
        }
           
        //> @attr SectionStack.locateSectionsBy (LocatorStrategy : null : IRWA)
        // When +link{isc.AutoTest.getElement()} is used to parse locator strings generated by
        // link{isc.AutoTest.getLocator()}, how should sections within this stack be identified?
        // By default if a section has a specified +link{SectionStackSection.name,Section.name} this will always be used.
        // For sections with no name, the following options are available:
        // <ul>
        // <li><code>"title"</code> use the title as an identifier</li>
        // <li><code>"index"</code> use the index of the section in the sections array as an identifier</li>
        // </ul>
        // 
        // If unset, and the section has no specified name, default behavior is to
        // identify by title (if available), otherwise by index.
        // @visibility external
        // @group autoTest
        //<
        
        //> @attr SectionStack.locateSectionsType (LocatorTypeStrategy : null : IRWA)
        // +link{type:LocatorTypeStrategy} to use when finding Sections within this section Stack.
        // @visibility external
        // @group autoTest
        //<
        

        // This will be picked up automatically based on the _locatorChildren object and
        // the standard "getLocatorStrategy()" logic
        
            
    });

    isc.SectionHeader.addProperties({
        // ensure backcompat with SC 8.2, which contains /background/ in SectionHeader locators
        getAttributeFromSplitLocator : function sectionHeader_getAttributeFromSplitLocator 
        (locatorArray, configuration)
        {
            if (!this.emptyLocatorArray(locatorArray) && locatorArray[0] == "background") {
                locatorArray.removeAt(0);
            }
            return this.Super("getAttributeFromSplitLocator", arguments);
        }
    });
   
}

// --------------------------------------------------
// Interior locators

if (isc.StretchImg) {
isc.StretchImg.addProperties({
    getInteriorLocator : function stretchImg_getInteriorLocator (element, fromEvent) {
        // We don't use the useEventParts flag in StretchImgs but in some cases we need to tell the
        // difference between events on different items
        // (EG a track-click and a button click)
        var origElement = element,
            handle = this.getHandle(), canvasName = this.getCanvasName();

        while (element && element != handle && element.getAttribute) {
            // check the "name" property for the open-icon 
            var ID = element.getAttribute("name");
            if (ID && ID.startsWith(canvasName)) {
                return ID.substring(canvasName.length);
            }
            element = element.parentNode;
        }
        return this.Super("getInteriorLocator", [origElement,fromEvent]);
    },
    
    getInnerAttributeFromSplitLocator : function stretchImg_getInnerAttributeFromSplitLocator (
        locatorArray, configuration) 
    {
        if (configuration.attribute == isc.Canvas._$Element) {
            // check for "name" - used for parts
            if (!this.emptyLocatorArray(locatorArray) && locatorArray.length == 1) {
                var image = this.getImage(locatorArray[0]);
                if (image) return image;
            }
        }
        return this.Super("getInnerAttributeFromSplitLocator", arguments);
    }
     
});
}

if (isc.Slider) {
    isc.Slider.addMethods({

        getInteriorLocator : function slider_getInteriorLocator (element, fromEvent, coords) {
            var locator = this.Super("getInteriorLocator", element, fromEvent);
            if (locator == isc.emptyString && coords != null) {
                var value = this._getValueFromCoords(false, coords);
                if (value) locator = "targetValue[" + value + "]";
            }
            return locator;
        },

        getInnerAttributeFromSplitLocator : function slider_getInnerAttributeFromSplitLocator (
            locatorArray, configuration)
        {
            switch (configuration.attribute) {
            case isc.Canvas._$Element:
                if (locatorArray.length == 1 ||
                    locatorArray.length == 2 && locatorArray[0].startsWith("track[")) {
                    if (locatorArray[locatorArray.length - 1].startsWith("targetValue[")) {
                        return this._getHandleAndLogFailure();
                    }
                }
                break;
            case isc.Canvas._$Value:
                return this.getValue();
            }
            return this.Super("getInnerAttributeFromSplitLocator", arguments);
        },

        getAutoTestLocatorCoords : function slider_getAutoTestLocatorCoords (locator, element) {
            if (locator == null || element == null) return null;

            var valueLocator = locator.split("/").last();
            if (valueLocator.startsWith("targetValue[")) {

                var targetValue = parseFloat(valueLocator.replace(/.*\[([\d-+.eE]+)\]$/, "$1"));
                if (isc.isA.Number(targetValue)) {
                    var thumbPosition = this._getThumbPositionFromValue(targetValue);
                    if (this.getHandle() == element) element = this.getClipHandle();
                    var rect = isc.Element.getElementRect(element);

                    var left   = rect[0],
                        width  = rect[2];
                    var top    = rect[1],
                        height = rect[3];

                    if (this.vertical) {
                        return [left + Math.floor(width/2),
                                top  + Math.min(thumbPosition, height)];
                    } else {
                        return [left + Math.min(thumbPosition, width),
                                top  + Math.floor(height/2)];
                    }
                }
            }
            return this.Super("getAutoTestLocatorCoords", arguments);
        },

        getChildFromLocatorSubstring : function (substring, index, locatorArray, configuration)
        {
            if (substring == null) return null;
            var attribute = configuration.attribute;

            if (substring.startsWith("thumb[") && attribute == isc.Canvas._$Value ||
                substring.startsWith("track[")) 
            {
            
                // If a targetValue[ was recorded (recent locator format),
                // redirect track element to slider, and value requests for 
                // track or thumb to slider
                // If no targetValue[... was recorded, delegate to the track etc
                // autoChild as we always have.
                if (locatorArray.length > index+1 &&
                   locatorArray[index+1].startsWith("targetValue[")) 
                {
                    return null;
                }
            }
            return this.Super("getChildFromLocatorSubstring", arguments);
        }

    });
    
    // Note this is for back-compat only: Recently recorded locators will include a
    // targetValue attribute in addition to the "track" child locator and when interpreting
    // them we have the Slider (rather than the track autoChild) resolve to an element
    isc.Slider.changeDefaults("trackDefaults", {
        getInnerAttributeFromSplitLocator : function sliderTrack_getInnerAttributeFromSplitLocator (
            locatorArray, configuration) 
        {
            // Slider: In 8.3 the track was a StretchImg by default. In 9.0 its a 
            // StatefulCanvas [though may still be a StretchImg depending on the skin].
            // If we have a recorded locator which includes a StretchImg part-name from the track but
            // the Slider track isn't a StretchImg, trim this off so we return the track's handle
            if (!isc.isA.StretchImg(this) && locatorArray.length > 0 && 
                    (locatorArray[0] == "stretch" || locatorArray[0] == "start" ||
                        locatorArray[0] == "end")) 
            {
                locatorArray = [];
            }
            return this.Super("getInnerAttributeFromSplitLocator",
                             [locatorArray, configuration], arguments);
        }
    });

}


// label.icon already handled via standard canvas 'eventPart' handling

if (isc.DynamicForm) {
    isc.DynamicForm.addProperties({
    
        getInteriorLocator : function dynamicForm_getInteriorLocator (element) {
            var itemInfo = isc.DynamicForm._getItemInfoFromElement(element, this);
            // itemInfo format:
            // {item:item, overElement:boolean, overTitle:boolean, overTextBox:boolean,
            //  overControlTable:boolean, overIcon:string}
            if (!itemInfo.item) return this.Super("getInteriorLocator", arguments);
            var item = itemInfo.item,
                locator = [this.getItemLocator(item), '/'];
                
            if      (itemInfo.overElement)      locator[locator.length] = "element";
            else if (itemInfo.overTitle)        locator[locator.length] = "title";
            else if (itemInfo.overTextBox)      locator[locator.length] = "textbox";
            else if (itemInfo.overControlTable) locator[locator.length] = "controltable";
            else if (itemInfo.overInlineError)  locator[locator.length] = "inlineerror";
            else if (itemInfo.overIcon)         locator[locator.length] = "[icon=\"" + 
                     itemInfo.overIcon + "\"]";
            
            return locator.join(isc.emptyString);
        },
        
        getItemLocator : function dynamicForm_getItemLocator (item) {
            
            // containerItems contain sub items, which point back up to them via the
            // parentItem attribute
            // If we hit a sub-item of a container item, call getItemLocator on that so
            // the item is located within the containerItem's items array
            // This method is copied from DF to containerItems below
            // the check for item.parentItem != this is required - if this is running
            // on a container item and we contain an item in our items array we need to
            // allow standard identifier construction to continue or we'd have an infinite loop
            if (item.parentItem && (item.parentItem != this)) {
                return this.getItemLocator(item.parentItem) + "/" + 
                            item.parentItem.getItemLocator(item);
            }
            
            var itemIdentifiers = {};
            
            
            if (item.name != null && !item._autoAssignedName) itemIdentifiers.name = item.name;
            
            // Title - default strategy if no name
            var title = item.getTitle();
            if (title != null) itemIdentifiers.title = title;
            
            // Value - useful for things like header items where value is pretty much
            // a valid identifier
            var value = item.getValue();
            if (value != null) itemIdentifiers.value = value;
            
            // Index - cruder identifier
            itemIdentifiers.index = this.getItems().indexOf(item);
            
            // ClassName: Not used by default
            itemIdentifiers.Class = item.getClassName();
            
            var IDString = isc.AutoTest.createLocatorFallbackPath("item", itemIdentifiers);
            return IDString;
        },
        
        // Override getObjectLocator to handle being passed form items
        getObjectLocator : function dynamicForm_getObjectLocator (target) {
            if (isc.isA.FormItem(target)) {
                var itemLocator = this.getItemLocator(target);
                itemLocator += "/objectType=FormItem";
                return itemLocator;
            }
            return this.Super("getObjectLocator", arguments);
        },

        containsLocatorChild : function dynamicForm_containsLocatorChild (canvas) {
            if (isc.isA.DateChooser(canvas) && canvas.callingForm == this) return true;
            return this.Super("containsLocatorChild", arguments);
        },
        getChildLocator : function dynamicForm_getChildLocator (canvas) {
            if (canvas.canvasItem) {
                var item = canvas.canvasItem;
                return this.getItemLocator(item) + "/canvas";
            }
            if (isc.isA.PickListMenu(canvas)) {
                var item = canvas.formItem;
                return this.getItemLocator(item) + "/pickList";
            }
            if (isc.isA.DateChooser(canvas)) {
                var item = canvas.callingFormItem;
                return this.getItemLocator(item) + "/picker";
            }
            
            return this.Super("getChildLocator", arguments);
        },
        
        getItemFromSplitLocator : function dynamicForm_getItemFromSplitLocator (locatorArray) {
            var fullItemID = locatorArray[0],
                className;

            // BackCompat note: Old format for identifying form items was
            //   item[name="foo"][Class="TextItem"]
            // new format is
            //   item[name=foo||title=moo||index=2||Class=TextItem]
            // Handle the old format for backCompat
            if (fullItemID.contains("[Class=")) {
                var split = fullItemID.match(
                    "item\\[(.+)'\\]\\[Class=\"(.+)\"\\]"
                );
                className = split[1].substring(6, split[1].length-2);
                fullItemID = split[0];
            }
            var itemConfig = isc.AutoTest.parseLocatorFallbackPath(fullItemID);
            
            if (itemConfig && itemConfig.name == "item" && itemConfig.config != null) {
                var config = itemConfig.config;
                
                // className is stored even if we don't identify by it.
                className = config.Class;
                
                // if we have a valid name, always have it take precedence
                var item;
                if (config.name != null) {
                    //this.logWarn("locating by name" + config.name);
                    item = this.getItem(config.name);
                } else {
                    //this.logWarn("item locator:" +fullItemID + " has no name - checking for " +
                    //    " title etc.");
                                        
                    // no name - check for the item 'locateItemBy' setting
                    // Options are by title or by value
                    for (var i = 0; i < this.items.length; i++) {
                        var testItem = this.items[i],
                            locateItemBy = testItem.locateItemBy;
                        if (locateItemBy == null) locateItemBy = "title";
                        //this.logWarn("item:" + testItem + ", locate by:" + locateItemBy + 
                        //    "config[locateBy:" + config[locateItemBy]);
                        if (locateItemBy == "title" && config.title != null && 
                            testItem.title == config.title) 
                        {
                            item = testItem;
                        } else if (locateItemBy == "value" && config.value != null && 
                                    testItem.getValue() == config.value) 
                        {
                            item = testItem;
                        }
                    }
                    
                    // If we couldn't find the item by title or value (or locateItemBy was
                    // specified explicitly as index) - locate by index
                    if (item == null) {
                        var index = config.index;
                        if (isc.isA.String(index)) {
                            if (index.startsWith("'") ||
                                index.startsWith('"')) 
                            {
                                index = index.substring(1);
                            }
                            index = parseInt(index);
                        }
                        item = this.items[index];
                    }
                }
                if (!item) {
                    this.logWarn("AutoTest.getElement(): Unable to find item from " +
                        "locator string:" + fullItemID);
                    return null;
                }
                if (!isc.isA[className] || !isc.isA[className](item)) {
                    this.logWarn("AutoTest.getElement(): identifier:"+ fullItemID + 
                                " returned an item of class:"+ item.getClassName());
                }
                return item;
            }
            
            return null;
        },

        getInnerAttributeFromSplitLocator : function 
        dynamicForm_getInnerAttributeFromSplitLocator (locatorArray, configuration) 
        {
            if (!this.emptyLocatorArray(locatorArray)) {
                var item = this.getItemFromSplitLocator(locatorArray);
                if (item != null) {
                    locatorArray.removeAt(0);
                    return item.getAttributeFromSplitLocator(locatorArray, configuration); 
                }
                
                if (configuration.locatorMatching != "permissive") {
                    this.setLogFailureText(true, "the trailing locator suffix '" +
                        locatorArray.join("/") + "' does not identify any FormItem in",
                                           "and permissive mode is not active");
                    return null;
                }
            }
            return isc.AutoTest.getAttributeDefault(this, configuration.attribute);
        }
    });
    
    // containerItems contain sub items
    // copy methods across to them to form locators for sub items and
    // identify sub items from split locators
    isc.ContainerItem.addProperties({
        // getItemLocator -- called directly by DynamicForm.getItemLocator if
        // an item has a parentItem specified
        getItemLocator:isc.DynamicForm.getPrototype().getItemLocator,
        getItemFromSplitLocator:isc.DynamicForm.getPrototype().getItemFromSplitLocator,

        // getInnerAttributeFromSplitLocator - override to check for the presence of items
        getInnerAttributeFromSplitLocator : function 
        containerItem_getInnerAttributeFromSplitLocator (locatorArray, configuration) 
        {
            if (!this.emptyLocatorArray(locatorArray)) {
                var subItem = this.getItemFromSplitLocator(locatorArray);
                if (subItem != null) {
                    locatorArray.removeAt(0);
                    return subItem.getAttributeFromSplitLocator(locatorArray, configuration);
                }
            }
            return this.Super("getInnerAttributeFromSplitLocator", arguments);
        }
    });
    
    
    isc.FormItem.addProperties({
        
        //> @attr FormItem.locateItemBy (string : null : IRWA)
        // When +link{isc.AutoTest.getElement()} is used to parse locator strings generated by
        // link{isc.AutoTest.getLocator()} for this form item, should the item be identified?
        // By default if the item has a name this will always be used, however for items with
        // no name, the following options are available:
        // <ul>
        // <li><code>"title"</code> use the title as an identifier within this form</li>
        // <li><code>"value"</code> use the value of the item to identify it (often used
        //  for items with a static defaultValue such as HeaderItems</li>
        // <li><code>"index"</code> use the index within the form's items array.
        // </ul>
        // 
        // If unset, and the item has no specified name, default behavior is to
        // identify by title (if available), otherwise by index.
        // @visibility external
        // @group autoTest
        //<
        
        // Some form items will use the autoChild subsystem to refer to some auto child, like the
        // miniDateRangeItem's date range dialog.
        // In this case, we can use the standard autoChild behavior to pick up this form item
        // as the locator parent (handled in getLocatorParent()) and we'll need to
        // support getChildLocator()
        getChildLocator : function formItem_getChildLocator (target) {
            
            // More general behavior split into 2 parts for easy overriding - autoChildren are pretty
            // much always respected over other locators such as children / members array
            if (target.creator == this) {    
                var autoChildID = this.getAutoChildLocator(target);
                if (autoChildID) return autoChildID;
            }
        },
        
        // getLocator on a form item. May be called directly if this was picked up as the
        // "parent locator" of an autoChild.
        getLocator : function formItem_getLocator () {
            // Ignore the "element" part - assume this will only be run in the 'autoChild' pattern.
            return this.getLocatorInternal();
        },

        getLocatorInternal : function formItem_getLocatorInternal (ignoreTestRoot, 
                                                                   skipAbsoluteLocator)
        {
            var form = this.form;
            return form.getLocatorInternal(ignoreTestRoot, skipAbsoluteLocator) + "/" +
                form.getItemLocator(this);            
        },

        // Implement getAttributeFromSplitLocator at the FormItem level. This means if a developer
        // assigns an actual ID to a FormItem and calls isc.AutoTest.getElement() passing in that
        // ID (for example //TextItem[ID='foo']) we can find it.
        getAttributeFromSplitLocator : function formItem_getAttributeFromSplitLocator (locatorArray,
                                                                                       configuration) {
            // split finding attribute within our handle to a separate method for simpler override
            return this.getInnerAttributeFromSplitLocator(locatorArray, configuration);
        },
        
        getInnerAttributeFromSplitLocator : function formItem_getInnerAttributeFromSplitLocator (
            locatorArray, configuration) 
        {
            var undef, 
                attribute = configuration.attribute;

            if (!this.emptyLocatorArray(locatorArray)) {
                var part = locatorArray[0];

                // canvasItems
                if (part == "canvas" && this.canvas) {
                    locatorArray.removeAt(0);
                    var result = this.canvas.getAttributeFromSplitLocator(locatorArray, 
                                                                          configuration);
                    // if no attribute could be found in canvas, use formItem's attribute
                    if (result !== undef || attribute == isc.Canvas._$Element) return result;
                }

                // picker (EG date picker)
                if (part == "picker") {
                    if (this.picker) {
                        locatorArray.removeAt(0);
                        return this.picker.getAttributeFromSplitLocator(locatorArray, 
                                                                        configuration);
                    }
                }
                
                // pickList
                if (part == "pickList") {
                    if (!this.pickList) this.makePickList(false);
                    locatorArray.removeAt(0);
                    return this.pickList.getAttributeFromSplitLocator(locatorArray,
                                                                      configuration);
                }
                
                if (attribute == isc.Canvas._$Element) {

                    if (part == "element") return this.getDataElement();
                    if (part == "title") return this.form.getTitleCell(this);
                    if (part == "textbox") return this._getTextBoxElement();
                    if (part == "controltable") return this._getControlTabelElement();
                    if (part == "inlineerror") return this.getInlineErrorHandle();
                    
                
                    // If passed an icon, return a pointer to the img element 
                    // Event if there is a link element, it'll be above that in the DOM
                    // Handle single or double-quotes around the icon name
                    var iconSplit = part.match("\\[icon='(.+)'\\]");
                    if (iconSplit == null) iconSplit = part.match('\\[icon="(.+)"\\]');
                    var iconID = iconSplit ? iconSplit[1] : null;
                    
                    if (iconID) {
                        var imgElement = this._getIconImgElement(iconID);
                        if (imgElement == null) this.setLogFailureText(true,
                            "there is no Icon Image Element associated with " + iconID +
                            " and locator '" + locatorArray.join("/") + "' for");
                        return imgElement;
                    }
                } 
                
                // Could be a named autoChild...
                if (this._createdAutoChildren) {
                    var autoChild = this._getNamedAutoChild(part);
                    if (autoChild) {
                        locatorArray.removeAt(0);
                        return autoChild.getAttributeFromSplitLocator(locatorArray, configuration);
                    }
                }
                
                if (attribute == isc.Canvas._$Element) {
                    this.setLogFailureText(true, "the trailing locator suffix '" +
                                   locatorArray.join("/") + "' does not identify any " +
                                   "Event Part of");
                    return;
                }
            } 

            // default values
            switch (attribute) {
            case isc.Canvas._$Object:
                return this;
            case isc.Canvas._$Value:
                return this.getValue();
            }
            
            // If we weren't passed any details, default to the focus
            // element if there is one otherwise the text box element                
            var element = this.getFocusElement();
            if (element == null) element = this._getTextBoxElement();
            if (element == null) {
                this.setLogFailureText(true, null, "has no focus or textbox elements");
            }
            return element;
        },
        
        _getNamedAutoChild : function (name) {
            var createdAutoChildren = this._createdAutoChildren;
            if (!createdAutoChildren) return;

            var children = createdAutoChildren[name];
            if (children && children.length > 0) {
                if (this[name] != null) return this[name];
            } else {
                var fallbackLocatorConfig = isc.AutoTest.parseLocatorFallbackPath(name);
                if (fallbackLocatorConfig != null) {
                    return this.getChildFromFallbackLocator(name, fallbackLocatorConfig);
                }
            }
        },

        _locatorChildren: { button: "buttons" },

        // copy the 'emptyLocatorArray()' helper function across
        emptyLocatorArray:isc.Canvas.getPrototype().emptyLocatorArray
    });
    
    isc.HeaderItem.addProperties({
        //> @attr HeaderItem.locateItemBy (string : "value" : IRWA)
        // Default to locating header items by value
        // @visibility autoTest
        //<
        locateItemBy: "value"
    });
    
    if (isc.PickListMenu) {
        isc.PickListMenu.addProperties({
            getLocatorParent : function pickListMenu_getLocatorParent () {
                if (this.formItem) return this.formItem.form;
                return this.Super("getLocatorParent", arguments);
            }
        });
    }
}


if (isc.GridRenderer) {
    
    isc.GridRenderer.addProperties({
        // generate some helpful text indicating the GridRenderer's valid row and column ranges
        _getValidIndicesText : function gridRenderer__getValidIndices (includeColumns) {
            var result = "; valid row indices are [0, " + this.getTotalRows() + "]";
            if (includeColumns) {
                result += " and valid column indices for the " + this.getScClassName() +
                    " are [0, " + this.fields.length + "]";
            }
            return result;
        },

        // wrap getTableElement() to log any case where a null DOM element is returned
        _getTableElementAndLogFailure : function gridRenderer__getTableElementAndLogFailure
        (locatorArray, rowNum, colNum) 
        {
            var element = this.getTableElement(rowNum, colNum);
            if (element != null) return element;

            var undef, content, name;
            if (colNum !== undef) {
                content = "(" + rowNum + ", " +  colNum + ")";
                name = "position";
            } else {
                content = rowNum;
                name = "row";
            }

            var guidance = this._getValidIndicesText(colNum !== undef);

            // if the indices are not literals from the locator, display the locatorArrray
            if (rowNum < 0 || colNum < 0) {
                content += ", derived from the locator suffix '" + locatorArray.join("/") + "',";
                if (colNum < 0) {
                    guidance = "; a negative colNum may indicate a field could not be found";
                } else {
                    guidance = "; a negative rowNum may indicate the targeted record is " + 
                               "not present, perhaps not yet loaded";
                }
            }

            this.setLogFailureText(true, content + " does not represent a valid " + name +
                                   " within", guidance);
            if (this.grid) this.grid._testReplayDumpRows();

            return null;
        },

        // report that the row/column locator suffix could not be parsed properly
        _reportInvalidCellLocator : function gridRenderer__reportInvalidCellLocator
        (locatorArray, rowNum, colNum)
        {
            var undef, finish,
                start = "the locator suffix '" + locatorArray.join("/") +"' could not be " +
                        "resolved to a numerical";

            if (colNum !== undef) {
                start += " row and column position within";
                finish = "; only able to resolve to (" + rowNum + ", " + colNum + ")";
            } else {
                start += " row position within";
                finish = "; detected row as " + rowNum;
            }
            this.setLogFailureText(true, start, finish);
            if (this.grid) this.grid._testReplayDumpRows();
        },

        getInteriorLocator : function gridRenderer_getInteriorLocator (element, fromEvent) {
            var cell = this.getCellFromDomElement(element);
            if (cell == null) return this.Super("getInteriorLocator", [element, fromEvent]);
            
            var rowNum = cell[0], colNum = cell[1],
                locator = this.getCellLocator(rowNum, colNum);
            // attach a drop position to the end of the locator to specify where to drop
            if (locator != null && this.grid != null && this == isc.EH.dropTarget) {
                var dropPosition = this.grid.getRecordDropPosition(rowNum);
                if (dropPosition != null) locator += "/" + dropPosition;
            }
            return locator;
        },
        
        //> @method gridRenderer.getCellFromDomElement() [A]
        // Given a pointer to an element in the DOM, this method will check whether this
        // element is contained within a cell of the gridRenderer, and if so return a
        // 2 element array denoting the <code>[rowNum,colNum]</code> of the element
        // in question.
        // @param element (DOM element) DOM element to test
        // @return (Array) 2 element array containing rowNum and colNum, or null if the
        //   element is not contained in any cell in this gridRenderer
        // @group autoTest
        // @visibility external
        //<
        getCellFromDomElement : function gridRenderer_getCellFromDomElement (element) {
            var handle = this.getHandle(),
                table = this.getTableElement();
                
            if (!table) return null;
                
            var rows = table.rows,
                tagName,
                row, cell,
                tr = "tr", TR = "TR",
                td = "td", TD = "TD";
            
            while (element && element != table && element != handle) {
                
                tagName = element.tagName;           
                // document whether it's upper / lower case by default
                if (tagName == td || tagName == TD) {
                    cell = element;
                }
                
                // document whether it's upper / lower case by default
                if (tagName == tr || tagName == TR) {
                    row = element;
                }
                // keep going in case there are nested tables, etc
                element = element.parentNode;
            }
            if (!row || !cell) return null;
            
            var rows = table.rows, rowNum, logicalRowNum;
            for (var i = 0; i < rows.length; i++) {
                if (rows[i] == row) {
                    rowNum = i;
                    break;
                }
            }
            var cells = row.cells, colNum, logicalColNum;
            for (var i = 0; i < cells.length; i++) {
                if (cells[i] == cell) {
                    colNum = i;
                    break;
                }
            }
            logicalRowNum = rowNum + (this._firstDrawnRow || 0);
            logicalColNum = colNum + (this._firstDrawnCol || 0);
            
            return [logicalRowNum,logicalColNum];
        },
        
        getCellLocator : function gridRenderer_getCellLocator (rowNum, colNum) {
            return "row[" + rowNum + "]/col[" + colNum + "]";
        },
        
        getInnerAttributeFromSplitLocator : function 
        gridRenderer_getInnerAttributeFromSplitLocator (locatorArray, configuration) 
        {
            if (configuration.attribute == isc.Canvas._$Element) {

                if (this.emptyLocatorArray(locatorArray)) return this._getHandleAndLogFailure();
                
                // Format should be [row[index], col[index]]
                if (locatorArray.length == 2) {
                    var cell = this.getCellFromLocator(locatorArray[0], locatorArray[1]),
                        rowNum = cell[0], colNum = cell[1];

                    if (isc.isA.Number(rowNum) && isc.isA.Number(colNum)) {
                        // We suppress all events on row/cols during row animation
                        // in this case suppress the element entirely so auto-test engines
                        // don't attempt to fire events on them.
                        
                        if (this._suppressEventHandling()) {
                            this.setLogFailureText(true, null, "is being animated");
                            return null;
                        }
                        return this._getTableElementAndLogFailure(locatorArray, rowNum, colNum);
                    } else {
                        this._reportInvalidCellLocator(locatorArray, rowNum, colNum);
                    }
                }
            }
            return this.Super("getInnerAttributeFromSplitLocator", arguments);
        },

        // assumes rowLocator is row[rowNum]
        // colLocator is col[colNum]
        getCellFromLocator : function gridRenderer_getCellFromLocator (rowLocator, colLocator) {
            // This is a straight parse - to support being passed a fuller format and
            // just extracting the index, if present, we'd want to have 
            // AutoTest.parseFallbackLocator run and then extract the standalone field value
            // knowing that's an index.
            var rowString = rowLocator.replace(/^row.*(?:\|\||\[)([0-9]+)\]$/, "$1"),
                colString = colLocator.replace(/^col.*(?:\|\||\[)([0-9]+)\]$/, "$1");
            return [parseInt(rowString), parseInt(colString)];
        },

        _isProcessingDone : function gridRenderer__isProcessingDone (strictMode) {
            var checkGrid = this.grid && !strictMode;
            if (checkGrid) return this.grid._isProcessingDone();
            else return this.Super("_isProcessingDone", arguments);
        }
    });

}
if (isc.ListGrid) {
    isc.ListGrid.addProperties({
        //> @attr listGrid.remapOverRecordPositionAs (RecordDropAppearance : isc.ListGrid.AFTER : [IRW])
        // If during Selenium playback, we encounter an "over" drop position, but
        // this is not allowed based on +link{listGrid.recordDropAppearance}, then what
        // drop position should it be remapped to?
        //<
        remapOverRecordPositionAs: isc.ListGrid.AFTER,

        // we explicitly set up the locatorParent pointers on these widgets
        // in ListGrid.js
        namedLocatorChildren:[
            "header", "frozenHeader", "body", "frozenBody", 
            {attribute:"_editRowForm", name:"editRowForm"},
            "filterEditor"
        ]
    });
      
      
    // We want to handle identifying cells by fieldName, record primary key etc as well
    // as simple rowNum / colNum.
    // We also need to handle the fact that with the option to freeze fields we can end up
    // with a logical cell that was in one sub-component (the frozen body, say)
    // is now in another (the standard body).
    
    // Implementation:
    // - when generating the Locator string include 'body' / 'frozenBody' as normal but
    //   have getCellLocator overridden in gridBody to record information about the fieldName etc
    //   as well as simple rowNum / colNum
    // - when parsing Locator strings, have the listGrid catch the case where we'd usually
    //   pass through to the body and handle it directly - figuring out which body the
    //   cell is in, and calling 'getTableElement()' on that
  
    isc.GridBody.addProperties({
  
        // override 'getInteriorLocator()' -- if an event occurred over an embedded component such
        // as a rollOverCanvas with eventProxy pointing back to us, we can't rely on the
        // DOM element
        // In the case where we're getting a locator from the event actually handle this by getting
        // coordinates from the event
        
        getInteriorLocator : function gridBody_getInteriorLocator (element, fromEvent) {
            if (fromEvent) {
                var children = this.children;
                if (children != null && children.length > 0) {
                    for (var i = 0; i < children.length; i++) {
                        var child = children[i];
                        if (child && child.eventProxy == this) {
                            var handle = child.getHandle();
                            if (handle != null) {
                                var testElement = element;
                                while (testElement != this.getHandle() && testElement != null) 
                                {
                                    if (testElement == handle) {
                                        var rowNum = this.getEventRow(),
                                            colNum = this.getEventColumn();
                                        return this.getCellLocator(rowNum,colNum);
                                        
                                    }
                                    testElement = testElement.parentNode;
                                }
                            }
                        }
                    }
                }
            }
            return this.Super("getInteriorLocator", arguments);
        },

        getAutoTestLocatorCoords : function gridBody_getAutoTestLocatorCoords (locator, element)
        {
            var coords = this.Super("getAutoTestLocatorCoords", arguments);
            if (coords == null) return null;

            var grid = this.grid,
                locatorArray = locator.split("/").slice(-3),
                dropPosition = locatorArray[2];
                
            if (grid._isValidDropPosition(dropPosition)) {
                var rowNum = grid.getRowNumFromLocator(locatorArray, 0);

                if (isc.isA.Number(rowNum)) {

                    
                    if (dropPosition == isc.ListGrid.OVER &&
                        grid.recordDropAppearance != isc.ListGrid.OVER &&
                        grid.recordDropAppearance != isc.ListGrid.BOTH)
                    {
                        var newPosition = grid.remapOverRecordPositionAs,
                            remap = grid._isValidDropPosition(newPosition);
                        if (isc.TreeGrid && isc.isA.TreeGrid(grid)) {
                            var node = grid.getRecord(rowNum);
                            if (grid.canDropOnLeaves || grid.data.isFolder(node)) {
                                remap = false;
                            }
                        }
                        if (remap) dropPosition = newPosition;
                    }

                    var recordTop    = this.getRowTop(rowNum),
                        recordHeight = this.getRowSize(rowNum);
                    
                    switch(dropPosition) {
                    case isc.ListGrid.BEFORE:
                        coords[1] -= recordHeight/2;
                        break;
                    case isc.ListGrid.AFTER:
                        coords[1] += 3*recordHeight/8;
                        break;
                    }
                }
            }
            return coords;
        },
        
        getCellLocator : function gridBody_getCellLocator (rowNum, colNum) {
            var grid = this.grid;
            if (grid == null) return this.Super("getCellLocator", arguments);
            return grid.getCellLocator(this, rowNum, colNum);
        }
              
    });
    
    isc.ListGrid.addProperties({

        

        testReplayLoggedRows: 50,
        _testReplayDumpRows : function listGrid__testReplayDumpRows () {
            if (!isc.Log.logIsDebugEnabled("testReplay") || !isc.JSON) return;

            var nRows = Math.min(this.testReplayLoggedRows, this.getTotalRows()),
                result = "The first " + nRows + " rows of " + this._getDescription() +
                         " are: \n";

            for (var i = 0; i < nRows; i++) {
                result += "#" + (i + 1) + ": " + isc.JSON.encode(this.getRecord(i)) + "\n";
            }
            isc.AutoTest.logDebug(result.trim(), "testReplay");
        },

        // getCellLocator -- called by the grid body to generate the identifier
        getCellLocator : function listGrid_getCellLocator (body, rowNum, colNum) {
            var rowLocatorOptions = this.getRowLocatorOptions(body, rowNum, colNum),
                colLocatorOptions = this.getColLocatorOptions(body, rowNum, colNum);
            return isc.AutoTest.createLocatorFallbackPath("row", rowLocatorOptions) +
                    "/" + isc.AutoTest.createLocatorFallbackPath("col", colLocatorOptions);
        },
        
        // builds a config type object that we'll pass to createLocatorFallbackPath
        getRowLocatorOptions : function listGrid_getRowLocatorOptions (body, rowNum, colNum) {
            
            var locatorOptions = {},
                gridColNum = this.getFieldNumFromLocal(colNum, body),
                record = this.getCellRecord(rowNum, gridColNum),
                ds = this.getDataSource();
                
            if (record != null) {
                if (ds != null) {
                    var pks = ds.getPrimaryKeyFieldNames();
                    for (var i = 0; i < pks.length; i++) {
                        var pk = pks[i];
                        if (record[pk] != null) {
                            locatorOptions[pk] = record[pk];
                        }
                    }
                }
                
                var titleField = this.getTitleField();
                if (titleField != null && record[titleField] != null) {
                    locatorOptions[titleField] = record[titleField];
                } else if (isc.isA.Tree(this.data)) {
                    var title = record[this.data.titleProperty];
                    if (title != null) locatorOptions[this.data.titleProperty] = title;
                }
                var fieldName = this.getFieldName(gridColNum);
                if (fieldName != null && record[fieldName] != null) {
                    locatorOptions[fieldName] = record[fieldName];
                }
            }
            // also store the rowNum
            locatorOptions[isc.AutoTest.fallback_valueOnlyField] = rowNum;
            return locatorOptions;
        },
        
        getColLocatorOptions : function listGrid_getColLocatorOptions (body, rowNum, colNum) {
            var locatorOptions = {},
                gridColNum = this.getFieldNumFromLocal(colNum, body);
            var field = this.getField(gridColNum);
            if (this.isCheckboxField(field)) {
                locatorOptions.isCheckboxField = true;
            } else {
                var fieldName = this.getFieldName(gridColNum);
                if (fieldName != null) locatorOptions.fieldName = fieldName;
            }
            locatorOptions[isc.AutoTest.fallback_valueOnlyField] = colNum;
            return locatorOptions;  
            
        },
        
        
        // if the child substring is "frozenBody' / "body", return null - we'll handle
        // finding the element at the ListGrid level
        getChildFromLocatorSubstring : function listGrid_getChildFromLocatorSubstring
            (substring, index, locatorArray)
        {
            if (substring == "frozenBody" || substring == "body") {
                // use a switch statement with fall through to validate all locator pieces
                switch (locatorArray.length - index) {
                case 4:
                    if (!this._isValidDropPosition(locatorArray[index + 3])) break;
                case 3:
                    if (!locatorArray[index + 2].startsWith("col[")) break;
                case 2:
                    if (!locatorArray[index + 1].startsWith("row[")) break;
                    return null;
                }
            }
            return this.Super("getChildFromLocatorSubstring", arguments);
        },
        
        getRowNumFromLocator : function listGrid_getRowNumFromLocator (locatorArray, index) {
            // We're looking for an individual row
            var rowLocatorConfig = isc.AutoTest.parseLocatorFallbackPath(locatorArray[index]);
            if (rowLocatorConfig.name != "row") {
                this.logWarn("Error parsing locator: " + locatorArray.join("/") +
                             "; unable to resolve the row");
                return null;
            }
            return this.getRowNumFromLocatorConfig(rowLocatorConfig.config);
        },

        // Override getInnerAttributeFromSplitLocator to handle cells in the body/frozenBody
        getInnerAttributeFromSplitLocator : function listGrid_getInnerAttributeFromSplitLocator (
            locatorArray, configuration) 
        {
            var attribute = configuration.attribute,
                emptyValue   = isc.AutoTest.getAttributeDefault(null, attribute),
                defaultValue = isc.AutoTest.getAttributeDefault(this, attribute);

            if (this.emptyLocatorArray(locatorArray)) {
                return isc.AutoTest.setLogFailureForReturnValue(this, locatorArray, 
                                                                defaultValue, attribute);
            }

            // expected format: "frozenBody", row[...], col[...]"
            var body = locatorArray[0];
            if (body == "body" || body == "frozenBody") {
                var dropPosition = locatorArray[3];

                if (locatorArray.length == 2 && attribute == isc.Canvas._$Element) {

                    var rowNum = this.getRowNumFromLocator(locatorArray, 1);
                    if (rowNum == null) return defaultValue;

                    if (isc.isA.Number(rowNum)) {
                        // We suppress all events on row/cols during row animation
                        // in this case suppress the element entirely so auto-test engines
                        // don't attempt to fire events on them.
                        
                        if (this.body._suppressEventHandling()) {
                            this.body.setLogFailureText(true, null, "is being animated");
                            return emptyValue;
                        }
                        return this.body._getTableElementAndLogFailure(locatorArray, rowNum);
                    }

                } else if (locatorArray.length == 3 ||
                           locatorArray.length == 4 && this._isValidDropPosition(dropPosition))
                {
                    // Start with the field!
                    var colLocator = locatorArray[2],
                        colLocatorConfig = isc.AutoTest.parseLocatorFallbackPath(colLocator);
    
                    // colLocatorConfig will have name:"col", config:{config object}
                    // The 'getChildFromLocatorSubstring() method already checks for this but
                    // as a sanity check verify the name of the col locator
                    if (colLocatorConfig.name != "col") {
                        if (attribute == isc.Canvas._$Element) this.setLogFailureText(true,
                            "could not parse column locator '" + colLocator + "' for");
                        this.logWarn("Error parsing locator:" + locatorArray.join("") + 
                            " returning ListGrid handle");
                        return defaultValue;
                    }
                    
                    var field = this.getFieldFromColLocatorConfig(colLocatorConfig.config),
                        localColNum;
                    // If no fieldName stored, use the previous colNum instead
                    // [we stored the colNum relative to the body in question]
                    if (field == null) {
                        localColNum = parseInt(colLocatorConfig.
                                               config[isc.AutoTest.fallback_valueOnlyField]);
                        if (body == "frozenBody" && this.frozenBody == null) {
                            this.setLogFailureText(true, "the column locator '" + colLocator +
                            "' is specified on a frozen body but", "has none");
                            return emptyValue; // locator is not valid
                        }
                        // convert to string to a pointer to the widget
                        body = this[body];
                    } else {
                        localColNum = this.getLocalFieldNum(this.getFieldNum(field)); 
                        
                        if (this.fieldIsFrozen(field)) body = this.frozenBody;
                        else                           body = this.body;
                    }
                    // Bail if we haven't created the right body for some reason
                    
                    if (body == null) {
                        this.setLogFailureText(true, "there was a problem locating the " +
                            "correct GridBody for field " + field.name + " using column " +
                            "locator '" + colLocator + "' within", ", this field seems " +
                            "to be" + (this.fieldIsFrozen(field) ? " " : " not ") + "frozen");
                        return emptyValue;
                    }
                    
                    // At this point we know what body it's in and what the colNum is within that
                    // body.
                    // Now find the row
                    
                    var rowNum = this.getRowNumFromLocator(locatorArray, 1);
                    if (rowNum == null) {
                        if (attribute == isc.Canvas._$Element) this.setLogFailureText(true,
                            "locator suffix  '" + locatorArray.join("/") + "' does not " +
                            "identify a valid row within");
                        return defaultValue;
                    }

                    var bodyName = body == this.frozenBody ? "frozen GridBody" : "GridBody";

                    if (isc.isA.Number(rowNum) && isc.isA.Number(localColNum)) {
                        // We suppress all events on row/cols during row animation
                        // in this case suppress the element entirely so auto-test engines
                        // don't attempt to fire events on them.
                        
                        if (body._suppressEventHandling()) {
                            body.setLogFailureText(true, null, "is being animated");
                            return emptyValue;
                        }
    
                        switch (attribute) {
                        case isc.Canvas._$Element:                       
                            return body._getTableElementAndLogFailure(locatorArray, 
                                                                      rowNum, localColNum);
                        case isc.Canvas._$Value:
                            var fieldNum = this.getFieldNumFromLocal(localColNum, body),
                                field = this.getField(fieldNum);
                            if (field != null) {
                                var record = this.getCellRecord(rowNum, fieldNum);
                                if (record == null) {
                                    this.setLogFailureText(true, "no record could be found " +
                                                       "for field " + field.name + " and row " +
                                                       rowNum + " in");
                                    break;
                                }
                                if (field._isCheckboxField) return this.isSelected(record);
                                
                                if (field._standardMenuIconField === true) {
                                    return !!record.checked;
                                }
                                
                                return this.getRawCellValue(record, rowNum, fieldNum);
                            } else {
                                this.setLogFailureText(true, "no field could be found for " +
                                    "column " + localColNum + " within the " + bodyName + " of");
                            }
                        }
                    } else {
                        body._reportInvalidCellLocator(locatorArray, rowNum, localColNum);
                    }
                }
            }

            return this.Super("getInnerAttributeFromSplitLocator", arguments);
        },
        
        // helper to pick up field based on 'checkboxField' status and name
        // If neither work, we will use field num instead
        getFieldFromColLocatorConfig : function listGrid_getFieldFromColLocatorConfig (colConfig) {
            //this.logWarn("colConfig:" + this.echo(colConfig));
            if (colConfig.isCheckboxField != null) {
            
                for (var i = 0; i < this.fields.length; i++) {
                    if (this.isCheckboxField(this.fields[i])) {
                        return this.fields[i];
                    }
                    // In this case we didn't find a checkbox field - test is probably
                    // invalid
                    this.logWarn("AutoTest stored a locator for interaction with " +
                            "checkbox field - but this grid is not showing a checkbox field - " +
                            "recorded test may be invalid.", "AutoTest");
                    // returning -1 here - this causes use to not return some other random
                    // unrelated cell (typically the first column in the grid)
                    return -1;
                }
            } else {
       
                var locateColsBy = this.locateColumnsBy;
                //locateColsBy will be one of ("fieldName", "index")    
    
                if (locateColsBy == "fieldName" || locateColsBy == null) {
                    var fieldName = colConfig.fieldName;
                    if (fieldName != null) {
                        return this.getField(fieldName);
                    }
                }
            }
        },
        
        getRowNumFromLocatorConfig : function listGrid_getRowNumFromLocatorConfig (rowConfig) {
            //this.logWarn("rowConfig:" + this.echo(rowConfig));
            var locateRowsBy = this.locateRowsBy;
       
            if (locateRowsBy == null) locateRowsBy = "primaryKey";
            var data = this.data,
                bestGuess;
            switch(locateRowsBy) {
                case "primaryKey":
                    this.logDebug("Trying to locate row by pk", "autotest");
                    //this.logWarn("rowConfig: " + isc.Comm.serialize(rowConfig));
                    var ds = this.getDataSource();
                    if (ds != null) {
                        var pkFields = ds.getPrimaryKeyFieldNames(),
                            allKeys = pkFields.length > 0;
                        for (var i = 0; i < pkFields.length; i++) {
                            if (rowConfig[pkFields[i]] == null) {
                                allKeys = false;
                                break;
                            }
                        }
                        if (allKeys) {
                            var rowNum = this.findRowNum(rowConfig);
                            if (rowNum != -1) {
                                this.logDebug("Located row " + rowNum + " by pk", "autotest");
                                return rowNum;
                            }
                        }
                    }
                    this.logDebug("Failed to locate row by pk.  Config: " + isc.echoAll(rowConfig), "autotest");                    
                    // don't break - if we were unable to use PK, fall back through
                    // titleField / cell value before index

        
                    // NOTE: The skipFallback property is an internal flag to ensure that the
                    // row is located by primary key, or not at all.  The primary motivation 
                    // for adding it is to enable automated testing of the PK functionality; 
                    // for that, we have to be certain that the element was located by 
                    // primaryKey and not some fallback strategy
                    if (isc.AutoTest.skipFallback) return -1;
                        
                case "titleField":
                    //this.logWarn("trying to locate by title field");
                    var titleField = this.getTitleField();
                    if (titleField != null && rowConfig[titleField] != null) {
                        var matches = data.findAllIndices(titleField, rowConfig[titleField]);
                        if (matches.length == 0) return -1;
                        if (matches.length == 1) return matches[0];
                        // Ambiguous - fall through to fallback mechanisms, but first
                        // "sparse-up" the data array so we limit to valid matches!
                        var sparseData = [];
                        for (var i = 0; i < matches.length; i++) {
                            sparseData[matches[i]] = data.get(matches[i]);
                        }
                        bestGuess = matches[0];
                        data = sparseData;
                    }
                    
                case "targetCellValue":
                    //this.logWarn("trying to locate by target");
                    // Assertion: In this case, there was no titleField or primary key
                    // on the config object.
                    // This relies on the fact that we wouldn't store "null"s on that object
                    // when creating the locator options.
                    // All that's left is the original index under the fallback_valueOnlyField
                    // array and the target row cell value
                    for (var fieldName in rowConfig) {
                        if (fieldName == isc.AutoTest.fallback_valueOnlyField) continue;
                        
                        if (rowConfig[fieldName] != null) {
                            var matches = data.findAllIndices(fieldName, rowConfig[fieldName],
                                              isc.AutoTest._compareLocatorFallbackConfigValues);
                            if (matches.length == 0) return -1;
                            if (matches.length == 1) return matches[0];
                            var sparseData = [];
                            for (var i = 0; i < matches.length; i++) {
                                sparseData[matches[i]] = data.get(matches[i]);
                            }
                            bestGuess = matches[0];
                            data = sparseData;
                        }
                    }
                default: 
                    //this.logWarn("locate by rowNum");
                    // Final fallback option- original rowNum as stored
                    // Technically this is locateRowsBy "index"
                    // however if titleField / targetCellValue was ambiguous, this may also
                    // be hit with a sparse array of possible matches.
                    var rowNum = parseInt(rowConfig[isc.AutoTest.fallback_valueOnlyField]);
                    var undef;
                    if (bestGuess == null || data[rowNum] !== undef) return rowNum;
                    
                    else return bestGuess;
            }
        },

        _isValidDropPosition : function listGrid__isValidDropPosition (dropPosition) {
            switch (dropPosition) {
            case isc.ListGrid.BEFORE:
            case isc.ListGrid.AFTER:
            case isc.ListGrid.OVER:
                return true;
            }
            return false;
        },

        _isProcessingDone : function listGrid__isProcessingDone (strictMode) {
            
            var allowEdits = !strictMode || isc.RecordEditor && isc.isA.RecordEditor(this);
            if (isc.AutoTest.isGridDone(this, allowEdits) == false) return false;
            return this.Super("_isProcessingDone", arguments);
        }
    });
}
if (isc.Menu) {

isc.Menu.addClassMethods({


getMenuAtLevel : function (level) {
    var openMenus = isc.Menu._openMenus || [],
        menuAtLevel = openMenus.find("_parentMenu", null);
    if (menuAtLevel == null) return null;

    for (var i = 0; i < level; i++) {
        menuAtLevel = menuAtLevel._open_submenu;
        if (menuAtLevel == null) {
            this.logInfo("Unable to locate active menu at level " + level +
                         " - returning null");
            return null;
        }
    }
    return menuAtLevel;
}

});

isc.Menu.addMethods({

_menuLocatorTemplate: [
"//Menu[level=",
,   // menu level
"]"
],
getLocatorRoot : function menu_getLocatorRoot() {
    // where a stable ID is present, give that preference for simplicity
    if (this.hasStableID()) return this.Super("getLocatorRoot", arguments);
    // otherwise, create a level-based locator since only one menu hierarchy can be open
    if (!this.locatorRoot) {
        var level = 0;
        for (var menu = this; menu && menu._parentMenu; menu = menu._parentMenu) level++;
        this._menuLocatorTemplate[1] = level;
        this.locatorRoot = this._menuLocatorTemplate.join(isc.emptyString);
    }
    return this.locatorRoot;
}

});

}
if (isc.TreeGrid) {
    isc.TreeGridBody.addProperties({
        getOpenAreaWidth : function treeGridBody_getOpenAreaWidth (rowNum, colNum) {
            var grid = this.grid,
                data = grid.data,
                node = grid.getRecord(rowNum);

            // remap colNum relative to TreeGrid's fields
            colNum = grid.getFieldNumFromLocal(colNum, this);

            // fail if field is not the tree field, or we can't determine whether it's a folder
            if (grid.getTreeFieldNum() != colNum || data == null || !data.isFolder(node)) {
                return null;
            }
            return grid.getOpenAreaWidth(node);
        },

        getInteriorLocator : function treeGridBody_getInteriorLocator (element, fromEvent, 
                                                                       coords) 
        {
            var origElement = element;
            
            var grid = this.grid,
                handle = this.getHandle(),
                tableElement = this.getTableElement();

            if (!element || !handle || !tableElement) return isc.emptyString;
            var openAreaPrefix = grid.getCanvasName() + grid._openIconIDPrefix,
                rowNum, colNum;

            // The checkbox icon shows in the "extra icon" slot so
            // we'll have one or the other (not both) and can just store "extraIcon" as an 
            // identifier
            var extraIconPrefix = grid.getCanvasName() + grid._extraIconIDPrefix;

            // optimization - we could duplicate the logic from GR here and avoid
            // double-iterating through the DOM if we're NOT in the open area of the TG.
            while (element != this.tableElement && element != handle && element.getAttribute) {
                // check the "name"/"id" property for the open-icon
                var ID = element.getAttribute(isc.Canvas._generateSpanForBlankImgHTML ? 
                                              "id" : "name");
                if (ID) {
                    if (ID.startsWith(extraIconPrefix)) {
                        rowNum =  parseInt(ID.substring(extraIconPrefix.length));
                        colNum = grid.getLocalFieldNum(grid.getTreeFieldNum());
                        return this.getCellLocator(rowNum,colNum) + "/extra";
                    }
                }
                element = element.parentNode;
            }

            
            var cell = this.getCellFromDomElement(origElement);
            if (cell) {
                var openAreaWidth = this.getOpenAreaWidth(cell[0], cell[1]);
                if (openAreaWidth != null) {
                    var rect = this.getCellPageRect(cell[0], cell[1]),
                        x = coords[0] - rect[0];
                    if (x >= 0 && x < openAreaWidth) {
                        return this.getCellLocator(cell[0], cell[1]) + "/open";
                    }
                }
            }

            
            return this.Super("getInteriorLocator", [origElement, fromEvent, coords]);
        },

        getInnerAttributeFromSplitLocator : function 
        treeGridBody_getInnerAttributeFromSplitLocator (locatorArray, configuration) 
        {
            var grid = this.grid,
                attribute = configuration.attribute,
                emptyValue   = isc.AutoTest.getAttributeDefault(null, attribute),
                defaultValue = isc.AutoTest.getAttributeDefault(this, attribute);

            if (this.emptyLocatorArray(locatorArray)) {
                return isc.AutoTest.setLogFailureForReturnValue(this, locatorArray, 
                                                                defaultValue, attribute);
            }

            // Additional Format is: [row[index], col[index], open]
            if (locatorArray.length == 3) {
                if (locatorArray[2] == "open") {
                    // We suppress all events on row/cols during row animation
                    // Also suppress toggleFolder event target in this case.
                    
                    if (this._suppressEventHandling()) {
                        this.setLogFailureText(true, null, "is being animated");
                        return emptyValue;
                    }
                    
                    var rowLocator = locatorArray[0];
                    var rowNum;
                    
                    //   old format was row3
                    // new format is a standard row locator like
                    //   row[pkFieldValue=foo|3]
                    // Test for old format explicitly since parseLocatorFallbackPath doesn't
                    // handle it.
                    if (rowLocator.charAt(3) != "[") {
                        rowNum = parseInt(rowLocator.substring(3));
                    } else {
                        var rowLocatorConfig = isc.AutoTest.parseLocatorFallbackPath(rowLocator);
                        if (rowLocatorConfig == null || rowLocatorConfig.name != "row") {
                            this.setLogFailureText(true, "the row locator '" +
                                                   rowLocator + "' for", "could not be parsed");
                        }
                        rowNum = grid.getRowNumFromLocatorConfig(rowLocatorConfig.config);
                    }
                    if (attribute == isc.Canvas._$Value) {
                        var data = grid.data,
                            record = grid.getRecord(rowNum);
                        if (record == null || !data) {
                            this.setLogFailureText(true, "no record could be found " +
                                                   "for row " + rowNum + " of");
                            return;
                        }
                        return data.isOpen(record);
                    } else {
                        var colNum = grid.getLocalFieldNum(grid.getTreeFieldNum());
                        if (isc.isA.Number(rowNum) && isc.isA.Number(colNum)) {
                            return this._getTableElementAndLogFailure(locatorArray, 
                                                                      rowNum, colNum);
                        } else {
                            this._reportInvalidCellLocator(locatorArray, rowNum, colNum);
                            return null;
                        }
                    }

                // exactly the same logic for the "extraIcon", which is also used for
                // the checkbox icon when doing checkbox / cascading selection
                } else if (locatorArray[2] == "extra") {
                    if (this._suppressEventHandling()) {
                        this.setLogFailureText(true, null, "is being animated");
                        return emptyValue;
                    }

                    var rowLocator = locatorArray[0];
                    var rowNum;

                    //   old format was row3
                    // new format is a standard row locator like
                    //   row[pkFieldValue=foo|3]
                    // Test for old format explicitly since parseLocatorFallbackPath doesn't
                    // handle it.
                    if (rowLocator.charAt(3) != "[") {
                        rowNum = parseInt(rowLocator.substring(3));
                    } else {
                        var rowLocatorConfig = isc.AutoTest.parseLocatorFallbackPath(rowLocator);
                        if (rowLocatorConfig == null || rowLocatorConfig.name != "row") {
                            this.setLogFailureText(true, "the row locator '" +
                                                   rowLocator + "' for", "could not be parsed");

                        }
                        rowNum = grid.getRowNumFromLocatorConfig(rowLocatorConfig.config);
                    }
                    // we recorded the colNum but we don't need it!
                    //var colNum = grid.getTreeFieldNum();

                    if (attribute == isc.Canvas._$Value) {
                        var selection = grid.selection,
                            record = grid.getRecord(rowNum);

                        if (record == null) {
                            this.setLogFailureText(true, "no record could be found " +
                                                   "for row " + rowNum + " of");
                            return;
                        }
                        if (selection == null) {
                            this.setLogFailureText(true, "no selection object could be found " +
                                                   "for");
                            return;
                        }

                        var isSel = selection.isSelected(record);
                        if (!isSel || !grid.showPartialSelection) return isSel;
                        return selection.isPartiallySelected(record) ? "partial" : isSel;
                    } else {
                        // use getImage since we write a name into the opener icon.
                        var openerID = grid._extraIconIDPrefix + rowNum,
                        image = grid.getImage(openerID, isc.Canvas._generateSpanForBlankImgHTML);
                        if (image) return image;
                        else {
                            this.setLogFailureText(true, "no opener image could be found for " +
                                                   "row " + row + " of");
                            return null;
                        }
                    }
                }
            }
            return this.Super("getInnerAttributeFromSplitLocator", arguments);
        },

        getAutoTestLocatorCoords : function treeGridBody_getAutoTestLocatorCoords (locator,
                                                                                   element)
        {
            var coords = this.Super("getAutoTestLocatorCoords", arguments);
            if (coords == null) return coords;
            
            var tg = this.grid;
            // if we're picking up other icon coords will be position of icon so return it
            if (tg == null || locator.endsWith("/extra")) return coords;

            var offsetY = coords[1] - this.getPageTop()  + this.getScrollTop(),
                offsetX = coords[0] - this.getPageLeft() + this.getScrollLeft();

            var rowNum = this.getEventRow   (offsetY),
                colNum = this.getEventColumn(offsetX),
                openAreaWidth = this.getOpenAreaWidth(rowNum, colNum);
            if (openAreaWidth != null) {
                var rect = isc.Element.getElementRect(element),
                    left  = rect[0],
                    width = rect[2];

                if (locator.endsWith("/open")) {
                    coords[0] = left + Math.floor(openAreaWidth/2);
                } else {
                    left  += openAreaWidth;
                    width -= openAreaWidth;
                    coords[0] = left + Math.floor(width/2);
                }
            }
            return coords;
        }
    });
}
if (isc.TileGrid) {
    isc.TileGrid.addMethods({

        _isProcessingDone : function tileGrid__isProcessingDone (strictMode) {
            if (strictMode && !this.isDrawn()) return true;
            return isc.AutoTest.isTileGridDone(this) != false;
        }
});

}
// TabSets:
// We want to be able to locate tabs by ID or title rather than just index so if the order
// changes they continue to be accessable
if (isc.TabSet) {
    isc.TabSet.addProperties({
        
        // Relevant logic outside this file:
        //
        // In TabSet: tabBarControls layout has locatorParent / namedLocatorChildren set such that
        // the tabset will point directly to that auto-child by name.
        
        
        // In TabBar we have logic in makeButton to set 'locatorParent' on tabs to point
        // straight to the TabSet
        
        // Need to update containsLocatorChild / getStandardChildLocator / ... ? _locatorChildren??
        containsLocatorChild : function tabSet_containsLocatorChild (canvas) {
            if (this.Super("containsLocatorChild", arguments)) return true;
            
            if (this.getTabNumber(canvas) != -1) return true;
            return false;
        },
        
        getStandardChildLocator : function tabSet_getStandardChildLocator (canvas) {
            var tabNum = this.getTabNumber(canvas);
            if (tabNum != -1) {
                var tabObj = this.getTabObject(tabNum);
                
                var locatorConfig = {};
                // locate by name, ID, title or index
                if (tabObj.name != null) locatorConfig.name = tabObj.name;
                if (tabObj.title != null) locatorConfig.title = tabObj.title;
                if (tabObj.ID != null && !tabObj._autoAssignedID) locatorConfig.ID = tabObj.ID;
                locatorConfig.index = tabNum;
                
                return isc.AutoTest.createLocatorFallbackPath("tab", locatorConfig);
            
            }
            return this.Super("getStandardChildLocator", arguments);
        },
        
        //> @attr TabSet.locateTabsBy (string : null : IRWA)
        // When +link{isc.AutoTest.getElement()} is used to parse locator strings generated by
        // link{isc.AutoTest.getLocator()}, how should tabs within this tabset be identified?
        // By default if tab has a specified +link{Tab.ID} this will always be used.
        // For tabs with no ID, the following options are available:
        // <ul>
        // <li><code>"title"</code> use the title as an identifier</li>
        // <li><code>"index"</code> use the index of the tab in the tabset as an identifier</li>
        // </ul>
        // 
        // If unset, and the tab has no specified ID, default behavior is to
        // identify by title (if available), otherwise by index.
        // @visibility external
        // @group autoTest
        //<
        getChildFromLocatorSubstring : function tabSet_getChildFromLocatorSubstring (substring) {
            
            // this startsWith("tab[") is a bit of a hack we will probably just pass the
            // substring to AutoTest.parseLocatorFallbackPath directly and look at the returned
            // 'name' property -- however not sure if it'll handle all formats right now.
            if (substring && substring.startsWith("tab[")) {
                var fallbackConfig = isc.AutoTest.parseLocatorFallbackPath(substring),
                    config = fallbackConfig.config;
                
                // if ID or name is present, always respect it:
                if (config.ID   != null) return this.getTab(config.ID);
                if (config.name != null) return this.getTab(config.name);

                var locateTabsBy = this.locateTabsBy;
                if (locateTabsBy == null) locateTabsBy = "title";
                
                if (config.title && locateTabsBy == "title") {
                    var tabNum = this.tabs.findIndex("title", config.title);
                    return this.getTab(tabNum);
                }
                // last case -- we want to use the raw tab index.
                return this.getTab(parseInt(config.index));
            }
            
            return this.Super("getChildFromLocatorSubstring", arguments);
        }
        
    });
}

// ----------------------------------------------
// Returning element from interior locator

if (isc.StatefulCanvas) {
    isc.StatefulCanvas.addProperties({
          
        getInteriorLocator : function statefulCanvas_getInteriorLocator (element, fromEvent,
                                                                         coords) 
        {
            // special case; handle track from a slider to generate targetValue for coords
            if (isc.Slider && isc.isA.Slider(this.creator) && this.creator._track == this) {
                return this.creator.getInteriorLocator(element, fromEvent, coords);
            }
            return this.Super("getInteriorLocator", arguments);
        },

        getInnerAttributeFromSplitLocator : function statefulCanvas_getInnerAttributeFromSplitLocator (
            locatorArray, configuration) 
        {
            // label floats over statefulCanvas - if we have a specified part, assume it occurred
            // in the label since that's where we write out our icon, etc.
            if (!this.emptyLocatorArray(locatorArray) && this.label) {
                return this.label.getInnerAttributeFromSplitLocator(locatorArray, configuration);
            }
            return this.Super("getInnerAttributeFromSplitLocator", arguments);    
        },

        getAutoTestLocatorCoords : function statefulCanvas_getAutoTestLocatorCoords (locator,
                                                                                     element) 
        {
            // special case; get coords associated with targetValue from the slider
            if (isc.Slider && isc.isA.Slider(this.creator) && this.creator._track == this) {
                return this.creator.getAutoTestLocatorCoords(locator, element);
            }
            return this.Super("getAutoTestLocatorCoords", arguments);
        }
    });
}

if (isc.Menu) {
    isc.Menu.addProperties({
        // Should this widget's ID be used during scLocator generation?
        hasStableID : function menu_hasStableID () {
            var rootMenu = this._rootMenu;
            if (rootMenu != null) return rootMenu.hasStableID();
            else                  return this.Super("hasStableID", arguments);
        }
    });
}

// DateChooser

if (isc.DateChooser) {
    
    
    isc.DateChooser.addMethods({
        
        getInteriorLocator : function dateChooser_getInteriorLocator (element) {
            
            // We don't write any kind of unique DOM IDs or attrs to our buttons which
            // would simplify determining the purpose of the buttons except our click handler.
            
            // 2 possible approaches:
            // 1) Crudely look at the current cell position in whichever table its in - likely to 
            //    break if we rework ... wait a sec
            
            // Ok so playback / record type stuff
            // 
            // Lets say we store this as prevYear, prevMo, moLauncher, nextMo, nextYear and
            // dateCell[rowNum,colNum] and today, cancel
            
            // we can then get back the appropriate button when rerun
            // however if the default date has changed (which it likely will, tests are unlikely 
            // to work unless the user changes to a specific month first....
            
            
            // Alternative would be to remember dateCell[datestamp] - then we simply won't find 
            // the element if the date changes. Ok that seems better - won't get WRONG behavior
            
            // If we have a header, the event may have occurred in it
            var handle = this.getHandle();
            if (!handle || !element) return "";
            
            var cachedString = element._cachedLocatorString;
            if (cachedString != null && cachedString != "") return cachedString;
            
            return element._cachedLocatorString = this._getInteriorLocator(element, handle);
        },
        
        _getInteriorLocator : function dateChooser__getInteriorLocator (element, handle) {
            var targetCell = element;
            while (targetCell && targetCell != null) {
                if (targetCell == handle) {
                    targetCell = null;
                    break;
                }
                if (targetCell.tagName && targetCell.tagName.toLowerCase() == "td") {
                    break;
                }
                targetCell = targetCell.parentElement;
            }
            if (targetCell == null || targetCell.getAttribute == null) return "";

            var eventPart = targetCell.getAttribute(isc.EH._$eventPartAttributeName);
            if (!eventPart) return "";
            
            var childNodes = handle.childNodes,
                tables = [];
            for (var i = 0; i < childNodes.length; i++) {
                if (!childNodes[i].tagName || childNodes[i].tagName.toLowerCase() != "table") {
                    continue;
                }
                tables[tables.length] = childNodes[i];
            }
            
            var headerTable = tables.length == 2 ? tables[0] : null,
                bodyTable = tables.length == 2 ? tables[1] : tables[0];
            
            if (headerTable != null && targetCell.offsetParent == headerTable) {
                // could look at position within rows array -- but then we'd have to also
                // look at the various 'showMonthChooser' etc configurations -- instead
                // lets look directly at the eventpart attribute

                switch (eventPart) {
                    case "showPrevYear":  return "prevYearButton";
                    case "showPrevMonth": return "prevMonthButton";
                    case "showMonthMenu": return "monthMenuButton";
                    case "showYearMenu":  return "yearMenuButton";
                    case "showNextMonth": return "nextMonthButton";
                    case "showNextYear":  return "nextYearButton";
                }
                return "";
                
            } else if (bodyTable != null && targetCell.offsetParent == bodyTable) {
                // If the event was in the body, return the appropriate date identifier

                switch (eventPart) {
                    case "cancel": return "cancelButton";
                    case "today":  return "todayButton";
                    default:
                    var eventId = targetCell.id;
                    if (eventId) {
                        var dateId = eventId.split("_");
                        if (dateId && dateId.length >= 3) {
                            dateId = dateId.slice(dateId.length - 3);
                        }
                        return dateId.join("/");
                    }
                }
            }
            return "";
        },
        
        
        getInnerAttributeFromSplitLocator : function 
        dateChooser_getInnerAttributeFromSplitLocator (locatorArray, configuration) 
        {
            if (configuration.attribute == isc.Canvas._$Value) {
                this.setLogFailureText(true, "getValue() is not supported for");
                return;
            }

            var handle = this._getHandleAndLogFailure();
            if (handle == null || this.emptyLocatorArray(locatorArray)) return handle;
            
            var isDateButton = (locatorArray.length == 3);
            if (!isDateButton) {
                
                var locatorString = locatorArray[0];
                if (locatorString == "") return handle;
                
                var isTodayButton = (locatorString == "todayButton"),
                    isCancelButton = !isTodayButton ? (locatorString == "cancelButton") : false;
                    
                var childNodes = handle.childNodes;
                    
                // today / cancel button show up in the "body" table
                if (isTodayButton || isCancelButton) {
                        
                    if (isTodayButton && !this.showTodayButton) {
                        this.logWarn("DateChooser attempting to locate element for " +
                            "'todayButton' but showTodayButton is false. Returning handle.",
                            "AutoTest");
                        return handle;
                    }
                    if (isCancelButton && !this.showCancelButton) {
                        this.logWarn("DateChooser attempting to locate element for " +
                            "'cancelButton' but showCancelButton is false. Returning handle.",
                            "AutoTest");
                        return handle;
                    }
                    
                    var bodyTable;
                    // we show two tables if the header is showing, or just one if not.
                    // Either way the table we want is the last table in the handle.
                    for (var i = childNodes.length-1; i >= 0; i--) {
                        if (childNodes[i].tagName && 
                            childNodes[i].tagName.toLowerCase() == "table")
                        {
                            bodyTable = childNodes[i];
                            break;
                        }
                    }
                    
                    // today/cancel button cells are in the last row of the table
                    var lastRow = bodyTable.rows[bodyTable.rows.length-1],
                        cells = lastRow.cells;
                    for (var i = 0; i < cells.length; i++) {
                        if (this.getInteriorLocator(cells[i]) == locatorString) {
                            return cells[i];
                        }
                    }
                    
                } else {
                    
                    // Other buttons show up in the header table
                    if (!this.showHeader) {
                        this.logWarn("DateChooser attempting to locate element for " + locatorArray +
                          " but this.showHeader is false so this element will not be present. " +
                          "Returning handle.", "AutoTest");
                        return handle;
                    }
                    
                    var headerTable;
                    // we show two tables if the header is showing, so grab the first table in the
                    // childNodes array
                    for (var i = 0; i < childNodes.length; i++) {
                        if (childNodes[i].tagName && 
                            childNodes[i].tagName.toLowerCase() == "table") 
                        {
                            headerTable = childNodes[i];
                            break;
                        }
                    }
                    if (headerTable) {
                        // controls show up in the first row of cells
                        var row = headerTable.rows[0],
                            cells = row.cells;
                        for (var i = 0; i < cells.length; i++) {
                            if (this.getInteriorLocator(cells[i]) == locatorString) {
                                return cells[i];
                            }
                        }
                    }
                }

            // Date Buttons. Only releveant if we're showing the date in question!
            } else {
                // If we're showing a different year, obviously we're not showing the date button
                var year = locatorArray[0],
                    month = locatorArray[1],
                    date = locatorArray[2];
                // month may differ but only for the few 'spillover' days at the beginning/end
                // of the week - so if the month is off by more than one we're not showing the
                // button
                if ((year == this.year) &&
                        (this.month == month || this.month == month+1 || this.month == month-1))
                {
                    // We could iterate through all the visible buttons looking at locators and
                    // see if they match, or we could figure out the rowNum/colNum in which
                    // the date will be showing (if it is) and pick the cell that way.
                    // We'll take the second approach
                    var buttonDate = Date.createLogicalDate(year,month,date),
                        buttonDay = buttonDate.getDay(),
                        cell = this.dateGrid.getDateCell(buttonDate)
                    ;
                    
                    if (cell) {
                        return this.dateGrid.body._getTableElementAndLogFailure(locatorArray,
                                                                                cell.rowNum, 
                                                                                cell.colNum);
                    }

                } else {
                    this.logInfo("DateChooser passed ID for the wrong year or month - passed:" + 
                        locatorArray + ", showing:" + [this.year,this.month], "AutoTest");
                }
                
                this.logWarn("DateChooser - passed inner locator for date (" +
                            locatorArray.join("/") + ") -- not currently showing this date.",
                            "AutoTest");
            }
                        
            this.logWarn("DateChooser, unable to find element for inner locator:"+
                locatorArray + " returning handle");
            return handle;
        }
    });
}

};


// We want to respond to interaction with calendar events based on event name and 
// potentially date /title.
// Cases to handle:
// - interacting with cells in the 3 standard ListGrid views (day, week, month)
// - interacting with event links within cells in the month view
// - interacting with eventWindow auto-children associated with existing events

// Note we also need to handle interaction with various auto-children -- the date picker,
// prev/next buttons, etc. These should be handled by the standard "single auto child" 
// subsystem rather than needing any special logic.

// Putting this into a method (customizeCalendar()) means we can call this at the end
// of Calendar.js rather than having to worry about whether the module has been loaded or not.
isc.AutoTest.customizeCalendar = function () {
    
    
    // locateCellsBy
    //  - date
    //      - implies date AND time
    //  - index
    //      - rowNum/colNum
    
    
    // locateEventsBy
    //  - name
    //  - title
    //  ? event type
    //  - startDate
    isc._commonCalenderViewFunctions = {
            
        // Override the method to set up the 'rowLocator' - this should store
        // date and time and use that for preference over other locators
        // Note: we're leaving the columns alone here: for the day view we show only
        // two columns -- the label and the day column -- we'll already identify the correct
        // one based on field name
            
        // builds a config type object that we'll pass to createLocatorFallbackPath
        getRowLocatorOptions : function calendarView_getRowLocatorOptions (body, rowNum, colNum) {
            
            // Pick up standard options - this will get the rowNum for us
            // (Other options, such as primary key don't have much use here)
            var options = this.Super("getRowLocatorOptions", arguments);
            
            var date = this.creator.chosenDate;
            options.date = date.toSchemaDate("date");
            
            // time always starts at 12am
            // We show 2 rows per hour.
            // so just count rows to get time
            options.minutes = rowNum * 30;
            return options;
            
        },
        
        
        // parse a stored locator configuration back to the appropriate cell
        // If we're identifying by date, use the stored date / minutes
        // otherwise just use index
        getRowNumFromLocatorConfig : function calendarView_getRowNumFromLocatorConfig (rowConfig) {
            var locateCellsBy = this.creator.locateCellsBy;
            if ((locateCellsBy == "date" || locateCellsBy == null) &&
                rowConfig.date != null)
            {
                var date = isc.Date.parseSchemaDate(rowConfig.date);
                if (!this.showingDate(date)) {
                    this.logWarn("Locator for cell in this calendar day-view grid has date " +
                        "stored as:" + date.toUSShortDate() + ", but we're currently showing " +
                        this.creator.chosenDate.toUSShortDate() +
                        ". The stored date doesn't map to a visible cell so not returning a cell " +
                        "- if this is not the intended behavior in this test case you may need to " +
                        "set calendar.locateCellsBy to 'index'.", "AutoTest");
                    return -1;
                }
                // map the stored minutes to the appropriate rowNum
                
                return parseInt(rowConfig.minutes) / 30;
            }
            this.locateRowsBy = "index";
            return this.Super("getRowNumFromLocatorConfig", arguments);
        },
        
        showingDate : function calendarView_showingDate (date) {
            return (isc.Date.compareLogicalDates(date, this.creator.chosenDate) == 0);
        }
    };
    isc.DaySchedule.addProperties(isc._commonCalenderViewFunctions);
    
    // WeekView - has fields for each day of the week (plus the label field)
    // field names are arbitrary ("day1", "day2" etc, not mapping to days of week).
    // However field objects have year, month, day stored as _yearNum, _dateNum, _monthNum
    // so we don't need to calculate based on location, etc
    isc.WeekSchedule.addProperties(isc._commonCalenderViewFunctions,{
            
        // override 'showingDate' -- we show a range of dates (a week's worth)
        // we could look at this.creator.chosenDate again but seems like it'd be easier just
        // to check the date values already stored on each visible field
        showingDate : function weekSchedule_showingDate (date) {
            for (var i = 0; i < this.fields.length; i++) {
                var field = this.fields[i];
                if (field._yearNum == null) continue;
                if (Date.compareLogicalDates(
                        Date.createLogicalDate(field._yearNum, field._monthNum, field._dateNum),
                        date
                    ) == 0) 
                {
                    this.logWarn("does contain date" + date.toShortDate());
                    return true;
                }
                this.logWarn("date passed in:" + date.toShortDate() +
                    "compared with:" + Date.createLogicalDate(field._yearNum, field._monthNum,
                                                              field._dateNum).toShortDate());
            } 
            
            this.logWarn("doesn't contain date:" + date);
            return false;
        },
        
        
        // Month view has meaningful fields - each column is one day
        // Store date information on our column locators and use it when
        // retrieving columns
        getColLocatorOptions : function weekSchedule_getColLocatorOptions (body, rowNum, colNum) {
            
            var locatorOptions = this.Super("getColLocatorOptions", arguments),
                gridColNum = this.getFieldNumFromLocal(colNum, body),
                field = this.getField(gridColNum);                
            // the label field has no associated date, of course
            if (field && field._dateNum != null) {
                // the month is zero based - add one to it so it looks like the schema date
                // not really necessary but that way the date on the rowNum (derived from
                // this.chosenDate, using getSchemaDate()) will match the
                // date on the colNum in the locator string!
                locatorOptions.date = [field._yearNum, (field._monthNum+1), field._dateNum].join("-");
            }
            
            return locatorOptions;
        },
        
        // helper to pick up field based on 'checkboxField' status and name
        // If neither work, we will use field num instead
        getFieldFromColLocatorConfig : function weekSchedule_getFieldFromColLocatorConfig (colConfig) {
            
            if ((this.locateCellsBy == "date" || this.locateCellsBy == null) &&
                (colConfig.date != null)) 
            {
                var dateArr = colConfig.date.split("-");
                // we can ignore the month and year - if the chosen date wasn't already in
                // the range, rowNum will be -1 anyway so we won't return a cell.
                return this.getFields().find("_dateNum", dateArr[2]);
                
            }
            
            return this.Super("getFieldFromColLocatorConfig", arguments);
        }
    });

    // Month view:
    // MonthSchedule is a subclass of ListGrid as well - it shows one column per day of the
    // week, and 2 rows per week -- one row is the header containing date values
    // second row is the actual events
    // Events are embedded in the cells as link elements
    // We'll need to react to
    //  - click on header rows (goes to day view)
    //  - click on empty cells (shows window to add an event)
    //  - click on stored event links (shows window to edit event)
    // Once again we'll use locateCellsBy "date" to find cells
    // If set to index we'll just set locateRowsByIndex and let standard handling occur
    // for the month
    
    // each field is named 'day1' [, 'day2', ...]
    // Each record has a 'day1' value which matches that of the field header, and a
    //  date1 value which actually specifies the date the row represents
    // The "1", "2", etc is specified by looking at field._dayIndex
    //
    // So the 'date1' value in the first row (a header row) matches the 'date1' value in the
    // second row (an 'event' row), and is the date we're showing in the 'day1' column (the
    // first column) and so on...
    
    // rows that are actual dates have an events array attached to them -- usually empty
    // rows that are not actual dates (so header rows) have no events array
    
    // Events within Month cells:
    // We record info about the event rather than the cell (essentially the date) it's located
    // in for event-links within month cells.
    // When we attempt to find the event links we can therefore have the Calendar find the
    // event and then try to find the link associated with that event in our view.
    
    // Event links call 'monthViewEventClick(rowNum,colNum,index)' on the calendar, so we
    // will parse this href string to determine which event is being interacted with...
    
    isc.MonthSchedule.addProperties({
            
        getRowLocatorOptions : function monthSchedule_getRowLocatorOptions (body, rowNum, colNum) {
            
            // Pick up standard options - this will get the rowNum for us
            // (Other options, such as primary key don't have much use here)
            var options = this.Super("getRowLocatorOptions", arguments);
            var record = this.getRecord(rowNum);
            if (!record) return options; // sanity check only
            
            var field = this.getField(colNum);
            
            var dayIndex = field._dayIndex;
            options.dayIndex = dayIndex;
            var date = record["date" + dayIndex];
            options.date = date.toSchemaDate("date");
            
            var events = record["event" + dayIndex];
            if (events == null) {
                options.isHeaderRow = true;
            } else {
                options.isHeaderRow = false;
            }
            return options;
        },
        
        getRowNumFromLocatorConfig : function monthSchedule_getRowNumFromLocatorConfig (rowConfig) {

            var locateCellsBy = this.creator.locateCellsBy;
            if ((locateCellsBy == "date" || locateCellsBy == null) &&
                rowConfig.date != null)
            {
                var date = isc.Date.parseSchemaDate(rowConfig.date),
                    headerRow = (rowConfig.isHeaderRow == "true"),
                    dateField = "date" + rowConfig.dayIndex,
                    eventField = "event" + rowConfig.dayIndex;
                for (var i = 0; i < this.data.length; i++) {
                    var isHeader = (this.data[i][eventField] == null);
                    if (isHeader == headerRow) {
                        if (Date.compareLogicalDates(this.data[i][dateField], date) == 0) {
                            return i;
                        }
                    }
                }
                // no matching record (by date)
                return -1;
            }
            this.locateRowsBy = "index";
            return this.Super("getRowNumFromLocatorConfig", arguments);
        },
        
        getColLocatorOptions : function monthSchedule_getColLocatorOptions (body, rowNum, colNum) {
            var options = this.Super("getColLocatorOptions", arguments);
            // if we just record the dayIndex we can use that to find the column.
            // If the configuration changes such that (for example) the date isn't showing,
            // we'll just fail to find the cell so return -1 from getRowNumFromLocatorConfig
            options.dayIndex = this.getField(colNum)._dayIndex;
            return options;
        },
        
        getColNumFromLocatorConfig : function monthSchedule_getColNumFromLocatorConfig (colConfig) {
            var locateCellsBy = this.locateCellsBy;
            if (locateCellsBy == null || locateCellsBy == "date") {
                return this.fields.findIndex("_dayIndex", parseInt(colConfig.dayIndex));
            }
            
            this.locateColsBy = "index";
            return this.Super("getColNumFromLocatorConfig", arguments);
        }
        
    });
    
     
    isc.MonthScheduleBody.addProperties({
    
        // override getInterior locator to actually identify event link locators
        // (based on event rather than cell location)
        getInteriorLocator : function monthScheduleBody_getInteriorLocator (element) {
            if (element.tagName.toLowerCase() == "a") {
                var href = element.href;
                if (href != null) {
                    // We're using the href -- this is pretty hokey but no
                    // other info is written into the DOM element...
                    // It should be robust across page reloades etc since the
                    // stored locator is based on the event directly -- not on the
                    // href directly -- we just use that to find the event (and then to
                    // find tha ppropriate link from the event when parsing locators)
                    
                    // double escaping necessary -- first is eaten by quotes
                    var match = href.match("javascript:.*monthViewEventClick\\((\\d+),(\\d+),(\\d+)\\);");
                    //this.logWarn("match!:" + match);
                    if (match) {
                        var row = parseInt(match[1]),   
                            col = parseInt(match[2]),
                            index = parseInt(match[3]);
                        var events = this.grid.getEvents(row,col),
                            event = events[index];
                           
                        if (event == null) {
                            this.logWarn("Unable to determine event associated with apparent event " +
                                "link element -- returning cell");
                            return this.Super("getInteriorLocator", arguments);
                        }
                        
                        var calendar = this.grid.creator,
                            config = calendar.getEventLocatorConfig(event);
                        var string = isc.AutoTest.createLocatorFallbackPath("eventLink", config);
                        //this.logWarn("string:" + string);
                        return string;
                    }
                }
            }
            
            return this.Super("getInteriorLocator", arguments);
        },
        
        getInnerAttributeFromSplitLocator : function 
        monthScheduleBody_getInnerAttributeFromSplitLocator (locatorArray, configuration) 
        {
            if (configuration.attribute == isc.Canvas._$Value) {
                this.setLogFailureText(true, "getValue() is not supported for");
                return;
            }

            if (this.emptyLocatorArray(locatorArray)) return this._getHandleAndLogFailure();
            
            // if it starts with "eventLink" - get the relevant event from the Calendar
            // and then find it in our body if possible
            if (locatorArray.length == 1 && locatorArray[0].startsWith("eventLink")) {
                var fullConfig = isc.AutoTest.parseLocatorFallbackPath(locatorArray[0]);
                
                var calendar = this.grid.creator;
                var event = calendar.getEventFromLocatorConfig(fullConfig.config);
                
                var cell = this.grid.getEventCell(event);
                
                if (cell != null) {
                    var data = this.grid.data,
                        rowNum = cell[0],
                        colNum = cell[1],
                        dayIndex = this.grid.getField(colNum)._dayIndex;
            
                    var cellElement = this.getTableElement(rowNum,colNum),
                        links = cellElement.getElementsByTagName("A");
                    if (links != null) {
                        for (var iii = 0; iii < links.length; iii++) {
                            var href = links[iii].href;
                            if (href != null) {
                                // double escaping necessary -- first is eaten by quotes
                                var match = href.match("javascript:.*monthViewEventClick" +
                                                       "\\((\\d+),(\\d+),(\\d+)\\);");
                                if (match && data[rowNum]["event"+dayIndex][parseInt(match[3])]
                                    == event)
                                {
                                    return links[iii];
                                }
                            }
                        }
                    }
                }
                return this.Super("getInnerAttributeFromSplitLocator", arguments);
            }
         }
            
    });
    
    // Events:
    // Calendars are dataBound components where this.data is a set of events to show
    // (May come from a dataSource).
    // In Day and Week views, events show up as windows floating over the grid body
    // In Month view events are embedded directly in the cells
    // Modify the standard row locator / parsing logic to store / retrieve events
    // and find the appropriate windows (or link elements in the month view)
    isc.Calendar.addProperties({
            
        // this method gets called automatically for autoChildren.
        // Pick up eventWindows and store information based on the event they represent
        getCanvasLocatorFallbackPath : function calendar_getCanvasLocatorFallbackPath (name,
                                                      canvas, sourceArray, properties, mask)
        {
            if (name == "eventWindow") {
                var options = this.getEventLocatorConfig(canvas.event);
                return isc.AutoTest.createLocatorFallbackPath("eventWindow", options);
            }
            return this.Super("getCanvasLocatorFallbackPath", arguments);
        },
        
        getEventLocatorConfig : function calendar_getEventLocatorConfig (event) {
            this.logWarn("In getEventLocatorConfig().  event:" + this.echo(event));
            var config = {};
            if (this.dataSource) {
                var pkFields = this.getDataSource().getPrimaryKeyFieldNames();
                for (var i = 0; i < pkFields.length; i++) {
                    config[pkFields[i]] = event[pkFields[i]];
                }
            }
            
            var nameField = this.nameField;
            config[nameField] = event[nameField];
            
            var startField = this.startDateField;
            var startTime = event[startField];
            config[startField] = startTime.toSchemaDate();
            
            var endField = this.endDateField;
            var endTime = event[endField];
            config[endField] = endTime.toSchemaDate();
            
            config.index = this.data.indexOf(event);
            //this.logWarn("event config: " + this.echo(config));
            return config;
        },
        
        // substring param really just used for logging
        getChildFromFallbackLocator : function calendar_getChildFromFallbackLocator (substring,
                                                                         fallbackLocatorConfig)
        {
            var type = fallbackLocatorConfig.name,
                config = fallbackLocatorConfig.config;
                
            if (type == "eventWindow") {
                var viewName = this.mainView.getSelectedTab().viewName;
                if (viewName == "day") {
                    var children = this.dayView.body.children;
                } else if (viewName == "week") {
                    var children = this.weekView.body.children;
                }
                
                if (children != null) {
                    var event = this.getEventFromLocatorConfig(config),
                        eWindow = children.find("event", event);
                    return eWindow;
                }
                this.logWarn("unable to find event window associated with event:" + this.echo(event) +
                    " based on locator string:" + substring + 
                    ". It's possible that this event is not visible in the current view of " +
                    "this Calendar", "AutoTest");
                return null;
            }
            
            return this.Super("getChildFromFallbackLocator", arguments);
        },
        
        // we need date support.
        // So we need to be able to customize fields to record
        
        getEventFromLocatorConfig : function calendar_getEventFromLocatorConfig (config) {
            var locateBy = this.locateEventsBy;
            if (locateBy == null) locateBy = "primaryKey";
            
            switch (locateBy) {
            case "primaryKey":
                this.logDebug("Trying to locate event by pk", "autotest");
                var ds = this.getDataSource();
                if (ds) {
                    var pkFields = ds.getPrimaryKeyFieldNames(),
                        allKeys = pkFields.length > 0,
                        keyVals = {};
                    for (var i = 0; i < pkFields.length; i++) {
                        if (config[pkFields[i]] == null) {
                            allKeys = false;
                            break;
                        } else {
                            keyVals[pkFields[i]] = config[pkFields[i]];
                        }
                    }
                    if (allKeys) {
                        this.logDebug("All key fields present: " + isc.echoAll(keyVals), "autotest");
                        var record = ds.findByKeys(config, this.data);
                        if (record != null && record != -1) {
                            this.logDebug("Successfully located event by pk.  Record: " + 
                                            isc.echoAll(this.data.get(record)), "autotest");
                            return this.data.get(record);
                        }
                    } else {
                        this.logDebug("PK values missing. Config: " + isc.echoAll(config), 
                                            "autotest");
                    }
                }
                
                this.logDebug("Failed to locate event by pk.  Config: " + isc.echoAll(config), "autotest");                    

                // The missing break statement here is intentional - we want to fall through
                // to the next case

        
                // NOTE: The skipFallback property is an internal flag to ensure that the
                // row is located by primary key, or not at all.  The primary motivation 
                // for adding it is to enable automated testing of the PK functionality; 
                // for that, we have to be certain that the element was located by 
                // primaryKey and not some fallback strategy
                if (isc.AutoTest.skipFallback) return null;
                
            case "name":
                var name = config[this.nameField];
                if (name != null) return this.data.find(this.nameField, name);
                
                
            case "date":
                // we could convert these to dates, and then compare via compareDate but
                // that could trip up on millisecond differences, etc -- this seems a
                // safer approach.
                var startTime = config[this.startDateField],
                    endTime = config[this.endDateField];
                
                // we're going to have to find all dates where start AND end time match
                // we could get more sophisticated and match start / end separately too
                // but that seems like an odd use case
                for (var i = 0; i < this.data.length; i++) {
                    var testEvent = this.data.get(i);
                    if (testEvent == null) continue;
                    
                    if (testEvent[this.startDateField].toSchemaDate() == startTime &&
                        testEvent[this.endDateField].toSchemaDate() == endTime)
                    {
                        return testEvent;
                    }
                    this.logWarn("attempt to match calendar event by startDate / endDate " +
                        "unable to locate any events. Backing off to index within data array");
                }
                
            // back off to locating by index within this.data
            default:
                var index = parseInt(config.index);
                return this.data.get(index);
                
                
            }
        }
        
    });
    
};
if (isc.Calendar) isc.AutoTest.customizeCalendar();


// Hold off applying the AutoTest interface methods to widget classes until the page is done loading
// This ensures we don't depend on module load order

if (!isc.Page.isLoaded()) {
    isc.Page.setEvent("load", "isc.ApplyAutoTestMethods()");
} else {
    isc.ApplyAutoTestMethods();
}

isc.AutoTest.addClassMethods({

    //>	@classAttr AutoTest.implicitNetworkWait (boolean : false : [IRW])
    // Controls whether certain AutoTest APIs wait for network operations to complete
    // before returning true.  When value is true, +link{AutoTest.isElementClickable}
    // will return false until all network operations have completed.
    // @visibility external
    // @group autoTest
    //<
    implicitNetworkWait: false,

    //>	@classAttr AutoTest.testRoot (Canvas : null : [IRW])
    // Sets the implicit root canvas available in scLocators starting "//testRoot[]".
    // Setting this property may enable one to use the same script to test identical
    // widget hierarchies that are rooted under different base widgets.
    // @visibility external
    // @group autoTest
    //<
    
    _$testRoot: "//testRoot[]",
    testRoot: null,

    // helper also used in the user extendion files
    _isTextBased : function (element) {
         var tagName = element.tagName;
        if (!element.tagName) return false;
        tagName = tagName.toLowerCase();
        return tagName == "textarea" || tagName == "input" && 
            (element.type == "text" || element.type == "password" || element.type == "file");
    },

    //> @classMethod AutoTest.setTestRoot()
    // Sets the implicit root canvas available in scLocators starting "//testRoot[]".
    // Setting this property may enable one to use the same script to test identical
    // widget hierarchies that are rooted under different base widgets.
    // @param canvas (Canvas) the implicit root
    // @visibility external
    // @group autoTest
    //<
    setTestRoot : function (canvas) {
        this.testRoot = canvas;
        if (canvas != null) {
            this.logInfo("setting testRoot to canvas " + canvas.ID + ", so scLocators " +
                "starting " + this._$testRoot + "... will now be seen as rooted there");
        } else {
            this.logInfo("clearing the testRoot canvas, so scLocators " +
                "starting " + this._$testRoot + "... may no longer be used");
        }
    },

    // provides access to the canvas capable of scrolling the test root canvas
    getTestRootScrollCanvas : function () {
        if (this.testRoot == null) {
            this.logWarn("Unable to locate the scroll canvas containing the test root " +
                         "when no test root canvas has been configured");
            return null;
        }
        
        var explorer = window.featureExplorer;
        if (explorer != null) return explorer.exampleViewer.viewPane;

        for (var pane = this.testRoot; !isc.isA.PaneContainer(pane); pane = pane.parentElement);
        return pane;    
    },

    //> @classMethod AutoTest.isElementClickable()
    // Given a DOM element, returns whether the associated SmartClient Canvas is ready to
    // be clicked on by a Selenium test.  Returns null if the locator is not valid or
    // doesn't represent a valid Canvas.  Otherwise, returns true or false according as
    // the conditions below are all satisfied:
    // <ul>                               
    //     <li> page has finished loading
    //     <li> no network operations are outstanding (configurable, 
    //          see +link{AutoTest.implicitNetworkWait})
    //     <li> canvas is visible, enabled, and not masked,
    //     <li> canvas satisfies isCanvasDone()
    //     <li> if canvas is a TileGrid, it satisfies isTileGridDone()
    //     <li> if canvas is a ListGrid or body of a ListGrid, it satisfies isGridDone()
    // </ul>
    // Note that for an element in a DynamicForm, the DynamicForm must satisfy the second
    // condition above, while the container widget of the element must satisfy the remaining
    // conditions.
    // 
    // @param element (DOMElement | AutoTestLocator) DOM element to test or SmartClient locator
    // @return (boolean or null) whether element is 'clickable' as described above
    // @visibility external
    // @group autoTest
    //<
    isElementClickable : function (element) {

        // parts of AutoTest.js aren't present until page is loaded
        if (!isc.Page.isLoaded()) {
            this._isElementClickableLog = "the page is not loaded";
            return false;
        }            
        // bail out with null value if element not valid
        if (element == null) {
            this._isElementClickableLog = "the element is null";
            return null;
        }

        // if a Canvas or FormItem has been passed, try to resolve it to element
        if (isc.isA.Canvas(element) || isc.isA.FormItem(element)) {
            element = element.getHandle();
        }

        // support passing a locator as the element in lieu of the element itself
        if (isc.isA.String(element)) element = this.getElement(element);

        // if locator is valid, but Canvas is not valid (null), something is wrong;
        // report the locator as not clickable and log a warning to the console
        var canvas = this.locateCanvasFromDOMElement(element);
        if (canvas == null) {
            this._isElementClickableLog = "there's no Canvas identified by " + 
                element.getLocator();
            return null;
        }
        // check for pending network operations if user has requested implicit waits
        if (this.implicitNetworkWait && isc.RPCManager.requestsArePending()) {
            canvas.setLogFailureText(true, "RPCManager.requestsArePending() for");
            return false;
        }

        // always allow clicking on test root canvas 
        if (canvas == this.testRoot) return true;
        
        // invisible canvas
        if (!canvas.isVisible()) {
            canvas.setLogFailureText(true, null, "isn't visible");
            return false;
        }

        // disabled canvas
        if (canvas.isDisabled()) {
            canvas.setLogFailureText(true, null, "is disabled");
            return false;
        }

        // masked target
        if (isc.EH.targetIsMasked(canvas)) {
            var mask = isc.EH.clickMaskRegistry.last() || {},
                instance = window[mask.ID];
            if (isc.isAn.Instance(instance)) {
                instance.setLogFailureText(false, null, "is blocking clicks at " +
                                           canvas._getDescription(true));
            } else {
                var blocker = mask.ID ? "click mask " + mask.ID : "an unknown click mask";
                canvas.setLogFailureText(true, null, "is blocked by " + blocker);
            }
            return false;
        }

        // remap the canvas if a container widget is in play
        if (isc.DynamicForm && isc.isA.DynamicForm(canvas)) {
            var itemInfo = isc.DynamicForm._getItemInfoFromElement(element, canvas);
            if (itemInfo && itemInfo.item) {
                var containerWidget = itemInfo.item.containerWidget;
                if (containerWidget && !containerWidget._isProcessingDone()) {
                    canvas.setLogFailureText(true, "the container canvas of",
                                             "reports " + this.getLogFailureText(true));
                    return false;
                }
            }
        }

        // verify that the associated canvas is done
        return canvas._isProcessingDone(containerWidget != null);
    },

    //> @classMethod AutoTest.isElementReadyForKeyPresses()
    // Given a DOM element, returns whether the associated SmartClient Canvas or FormItem is
    // ready to receive keyPress events from a Selenium test.  Returns null if the locator is
    // not valid or doesn't represent a valid Canvas.  Otherwise, returns true or false
    // according as the conditions below are all satisfied:
    // <ul>                               
    //     <li> page has finished loading
    //     <li> if a +link{textItem}, +link{fileItem}, or +link{textAreaItem}, 
    //          it has native focus,
    //     <li> if a +link{textItem}, it has no pending delayed selects,
    //     <li> if a +link{picklist}, it has no pending fetch operations, and
    //     <li> the element satisfies +link{Autotest.isElementClickable}
    // </ul>
    // @param element (DOMElement | AutoTestLocator) DOM element to test or SmartClient locator
    // @return (boolean or null) whether element is ready for key presses as described
    // @group autoTest
    //<
    isElementReadyForKeyPresses : function (element) {

        // parts of AutoTest.js aren't present until page is loaded
        if (!isc.Page.isLoaded()) {
            this._isElementReadyForKeyPressesLog = "the page is not loaded";
            return false;
        }            
        // bail out with null value if element not valid
        if (element == null) {
            this._isElementReadyForKeyPressesLog = "the element is null";
            return null;
        }

        // if an Canvas or FormItem has been passed, try to resolve it to element
        if (isc.isA.Canvas(element) || isc.isA.FormItem(element)) {
            element = element.getHandle();
        }

        // support passing a locator to the element in lieu of the element itself
        if (isc.isA.String(element)) element = this.getElement(element);

        // if locator is valid, but Canvas is not valid (null), something is wrong;
        // report the locator as not clickable and log a warning to the console
        var canvas = this.locateCanvasFromDOMElement(element);
        if (canvas == null) {
            this._isElementReadyForKeyPressesLog = "there's no Canvas identified by " +
                element.getLocator();
            return null;
        }

        // text-based elements must have focus to accept keyPresses
        if (this._isTextBased(element) && element != document.activeElement) {
            canvas.setLogFailureText(true, "the text field in", 
                                   "is not the active DOM element");
            return false;
        }

        if (isc.DynamicForm && isc.isA.DynamicForm(canvas)) {
            var itemInfo = isc.DynamicForm._getItemInfoFromElement(element, canvas);
            if (itemInfo && itemInfo.item) {
                var item = itemInfo.item;
            
                // textItems cannot have any pending delayed select operations
                if (isc.isA.TextItem(item) && item._delayedSelect) {
                    item.setLogFailureText(true, "a delayed select operation " +
                                           "is pending for");
                    return false;
                }
                // selectItems/comboBoxItems cannot have pending fetches
                if (isc.isA.PickList(item)) {
                    if (item.pendingActionOnPause("fetch")) {
                        item.setLogFailureText(true, "a delayed fetch is queued for");
                        return false;
                    }
                    if (item._fetchingPickListData) {
                        item.setLogFailureText(true, null, "has a fetch oustanding");
                        return false;
                    }
                }
            }
        }

        return this.isElementClickable(element);
    },

    //> @classMethod AutoTest.isCanvasDone()
    // Given a DOM element corresponding to a Canvas, returns whether the associated Canvas is
    // in a consistent state with no pending operations.  Returns null if the locator is not
    // valid or isn't associated with an element representing a valid Canvas.  Otherwise,
    // returns true or false according as the conditions below are all satisfied:
    // <ul>
    //     <li> page has finished loading
    //     <li> canvas is drawn
    //     <li> canvas isn't dirty
    //     <li> canvas has no queued overflow operations
    //     <li> canvas is not animating
    // </ul>
    // @param element (DOMElement | AutoTestLocator) DOM element to test or SmartClient locator
    // @return (boolean or null) whether element is 'done' as described above
    //<
    isCanvasDone : function (element) {

        // parts of AutoTest.js aren't present until page is loaded
        if (!isc.Page.isLoaded()) {
            this._isCanvasDoneLog = "the page is not loaded";
            return false;
        }            
        // bail out with null value if element not valid
        if (element == null) {
            this._isCanvasDoneLog = "the element is null";
            return null;
        }

        // support passing a locator to the element in lieu of the element itself'
        if (isc.isA.String(element)) element = this.getElement(element);

        // allow a canvas to be passed in as the element
        var canvas = isc.isA.Canvas(element) ? element : 
            this.locateCanvasFromDOMElement(element);

        // if canvas not valid, report to alert the user and return false
        if (canvas == null) {
            this._isCanvasDone = "there's no Canvas identified by " + this.getLocator(element);
            return null;
        }

        // if canvas isn't drawn or is dirty, report as 'not done'
        if (!canvas.isDrawn()) {
            canvas.setLogFailureText(true, null, "isn't drawn");
            return false;
        }
        if (canvas.isDirty()) {
            canvas.setLogFailureText(true, null, "is dirty");
            return false;
        }

        // if canvas has pending overflow operations, report as 'not done'
        if (canvas._overflowQueued) {
            canvas.setLogFailureText(true, null, "has pending overflow operations");
            return false;
        }
        // if canvas is animating, report as 'not done'
        if (canvas.isAnimating()) {
            canvas.setLogFailureText(true,  null, "is currently animating");
            return false;
        }

        return true;
    },

    //> @classMethod AutoTest.isTileGridDone()
    // Given a DOM element corresponding to a TileGrid, returns whether the associated TileGrid
    // is in a consistent state with no pending operations.  Returns null if the locator is not
    // valid or isn't associated with an element representing a TileGrid.  Otherwise, returns
    // true or false according as the conditions below are all satisfied:
    // <ul>
    //     <li> page has finished loading
    //     <li> tileGrid (as a canvas) satisfies autoTest.isCanvasDone()
    //     <li> tileGrid has no pending layout animation operations queued
    //     <li> tileGrid is not currently animating any layout operations
    // </ul>
    // @param element (DOMElement | AutoTestLocator) DOM element to test or SmartClient locator
    // @return (boolean or null) whether element is 'done' as described above
    //<
    isTileGridDone : function (element) {

        // parts of AutoTest.js aren't present until page is loaded
        if (!isc.Page.isLoaded()) {
            this._isTileGridDoneLog = "the page is not loaded";
            return false;
        }            
        // bail out with null value if element not valid
        if (element == null) {
            this._isTileGridDoneLog = "the element is null";
            return null;
        }

        // support passing a locator to the element in lieu of the element itself
        if (isc.isA.String(element)) element = this.getElement(element);

        // allow a canvas to be passed in as the element
        var tileGrid = isc.isA.Canvas(element) ? element : 
            this.locateCanvasFromDOMElement(element);

        // if canvas not valid, report to alert the user and return false
        if (tileGrid == null || !isc.isA.TileGrid(tileGrid)) {
            this._isTileGridDoneLog = this.getLocator(element) +
                " does not correspond to a valid TileGrid!";
            return null;
        }

        // fail if underlying canvas is not reporting done
        if (!this.isCanvasDone(tileGrid)) return false;

        // fail if pending layout animation operations or currently animating
        if (tileGrid.pendingActionOnPause("tileGridAnimate")) {
            tileGrid.setLogFailureText(true, "there is a pending animation for");
            return false;
        }
        if (tileGrid.isAnimatingTileLayout()) {
            tileGrid.setLogFailureText(true, null, "is currently animating");
            return false;
        }        

        return true;
    },

    //> @classMethod AutoTest.isGridDone()
    // Given a DOM element corresponding to or contained in a ListGrid, returns whether the 
    // associated ListGrid is in a consistent state with no pending operations.  Returns null if
    // the locator is not valid or isn't associated with an element inside a valid ListGrid.
    // Otherwise, returns true or false according as the conditions below are all satisfied:
    // <ul>
    //     <li> page has finished loading
    //     <li> no pending filter editor operations
    //     <li> no unsaved edits to the grid records
    //     <li> no outstanding fetch/filter operations are present for the ResultSet
    //     <li> no outstanding sort operations are present that will update the ListGrid
    // </ul>
    // @param element (DOMElement | AutoTestLocator) DOM element to test or SmartClient locator
    // @return (boolean or null) whether element is 'done' as described above
    // @visibility external
    // @group autoTest
    //<
    isGridDone : function (element, allowEdits) {

        // parts of AutoTest.js aren't present until page is loaded
        if (!isc.Page.isLoaded()) {
            this._isGridDoneLog = "the page is not loaded";
            return false;
        }            
        // bail out with null value if element not valid
        if (element == null) {
            this._isGridDoneLog = "the element is null";
            return null;
        }

        // support passing a locator to the element in lieu of the element itself
        if (isc.isA.String(element)) element = this.getElement(element);

        // allow a canvas to be passed in as the element
        var grid = isc.isA.Canvas(element) ? element : 
             this.locateCanvasFromDOMElement(element);

        // element may point to interior widget; search up to find owning ListGrid
        while (grid != null && !isc.isA.ListGrid(grid)) grid = grid.parentElement;

        // if owning ListGrid not found, report to alert the user and return false
        if (grid == null) {
            this._isGridDone = "there's no ListGrid containing locator " + 
                this.getLocator(element);
            return null;
        }

        // if the grid has a summary row child grid, verify that it's done as well
        if (grid.summaryRow && !isc.AutoTest.isGridDone(grid.summaryRow, allowEdits)) {
            // log from nested call should be reported by the testReplay logger
            return false;
        }

        var filterEditor = grid.filterEditor;

        // if the grid's filter editor has pending criteria, we cannot proceed
        if (filterEditor && filterEditor.pendingActionOnPause("performFilter")) {
            grid.setLogFailureText(true, "there is a pending " + 
                                   "filter operation for the FilterEditor of");
            return false;
        }

        // if pending edits are present, grid is not done
        if (!allowEdits && grid.hasChanges()) {
            grid.setLogFailureText(true, null, "has unsaved edits");
            return false;
        }

        // check the ResultSet to make sure there's no outstanding fetch/filter operation
        if (grid.data != null && isc.isA.ResultSet(grid.data)) {
            if (!grid.data.lengthIsKnown()) {
                grid.setLogFailureText(true, "the length of the ResultSet " + 
                                       "associated with", "is not yet known");
                return false;
            }
            if (grid.data.fetchIsPending()) {
                grid.setLogFailureText(true, "has a pending fetch");
                return false;
            }
        }

        // ensure there is no outstanding sort operation that will need to update the ListGrid
        if (grid.body != null && grid.body.isDirty()) {
            grid.setLogFailureText(true, "the body of", "is dirty");
            return false;
        }
        if (grid.frozenBody != null && grid.frozenBody.isDirty()) {
            grid.setLogFailureText( true, "the frozen body of", "is dirty");
            return false;
        }
            
        return true;
    },

    //> @classMethod AutoTest.isSystemDone()
    // Returns whether the loaded page is in a consistent state with no pending operations.
    // Specifically, returns true of false according as the conditions below are all satisfied:
    // <ul>
    //     <li> page has finished loading
    //     <li> all ListGrids (as defined by isc.isA.ListGrid) satisfy isGridDone()
    //     <li> all TileGrids that are drawn satisfy isTileGridDone()
    //     <li> all Canvii that are drawn satisfy isCanvasDone()
    //     <li> no network operations are outstanding (configurable, 
    //          see +link{AutoTest.implicitNetworkWait})
    //     <li> there are no pending Canvas redraws (if includeRedraws parameter is true)
    // </ul>
    // Note: In a situation where messaging is being used to periodically refresh components,
    // or if the application contains a label updated every second to show the current time,
    // it's possible that this call might always return false if includeRedraws is true.
    // @param includeRedraws (boolean) whether to check for pending Canvas redraws
    // @return (boolean) whether loaded page is 'done' as described above
    // @visibility external
    // @group autoTest
    //<
    isSystemDone : function (includeRedraws) {

        // parts of AutoTest.js aren't present until page is loaded
        if (!isc.Page.isLoaded()) {
            this._isSystemDoneLog = "the page is not loaded";
            return false;
        }            

        // check for pending network operations if user has requested implicit waits
        if (this.implicitNetworkWait && isc.RPCManager.requestsArePending()) {
            this._isSystemDoneLog = "RPCManager.requestsArePending() is true";
            return false;
        }

        // check for pending redraws if requested
        var redrawQueue = isc.Canvas._redrawQeuue;
        if (includeRedraws && isc.isAn.Array(redrawQueue) && redrawQueue.length > 0) {
            this._isSystemDoneLog = "there are " + redrawQueue.length + " pending redraws";
            return false;
        }

        // check each canvas in the global list for being "done""
        for (var i = 0; i < isc.Canvas._canvasList.length; i++) {
            var canvas = isc.Canvas._canvasList[i];
            if (!canvas._isProcessingDone(true)) return false;
        }
        return true;
    },

    //////////////////////////////////// TestReplay Logging ////////////////////////////////////
    

    
    _loggedFunctions : [
        "isCanvasDone", "isTileGridDone", "isGridDone", "isSystemDone", 
        "isElementClickable", "isElementReadyForKeyPreses", 
        "getTableElementAndLogFailure", "getHandleAndLogFailure", "reportInvalidCellLocator",
        "getInnerAttributeFromSplitLocator", "getBaseComponentFromLocatorSubstring"
    ],

    _$startLocatorMarker : "!$originalLocator{",
    _$finishLocatorMarker : "}$!",

    _createLocatorMarker : function (locator) {
        if (!locator) locator = "";
        return this._$startLocatorMarker + locator + this._$finishLocatorMarker;
    },
    _replaceLocatorMarker : function (content, locator) {
        return content.replace(/!\$originalLocator\{.*\}\$!/, locator);
    },
    _populateLocatorMarker : function (content, clearMarker) {
        var fillText = "",
            originalLocator = this._originalLocator,
            markerMatch = content.match(/^.*!\$originalLocator\{(.*)\}\$!.*$/);

        if (originalLocator && markerMatch && !clearMarker) {
            var canvasLocator = markerMatch[0].replace(/!\$originalLocator\{(.*)\}\$!/, "$1");
            if (canvasLocator == "" || !this.locatorsEqual(canvasLocator, originalLocator)) {
                fillText = " and corresponding to original locator " + originalLocator;
            }
        }
        return this._replaceLocatorMarker(content, fillText);
    },

    applyFuncToLogSlots : function (slotFunc) {
        var functions = this._loggedFunctions;
        for (var i =0; i < functions.length; i++) {
            var logSlot = "_" + functions[i] + "Log",
                result = slotFunc(logSlot);
            if (result != null) return result;
        }
        return null;
    },
    setLogFailureText : function (locator, start, finish) {
        var callerFunc = isc.AutoTest.setLogFailureText.caller || arguments.callee.caller,
            callerName = callerFunc.name || isc.Func.getName(callerFunc, true),
            logSlot = callerName.replace(/^.*[_]+([^_]+)/, "\137$1" ) + "Log";
        if (this[logSlot]) return; // initial reporter has primacy
        this[logSlot] = this._getLogFailureText(locator, start, finish);
     },
    _getLogFailureText : function (locator, start) {
        var text;
        if (locator == true) text = this._originalLocator;
        else if (isc.isA.String(locator)) text = locator;
        return text ? start + " " + text : start;
    },
    getLogFailureText : function (clearMarker) {
        var autotest = this,
            log = this.applyFuncToLogSlots(function (logSlot) {
            var text = autotest[logSlot];
            if (text != null) autotest[logSlot] = null;
            return text;
        });
        return log ? this._populateLocatorMarker(log, clearMarker) : log;
    },
    clearAllLogSlots : function () {
        var autotest = this;
        return this.applyFuncToLogSlots(function (logSlot) {
            autotest[logSlot] = null;
        });
    },

    // Selenium API with implicit logging of all failures
    seleniumExecute : function (command, element, locator, argument) {

        this.clearAllLogSlots();
        this._originalLocator = locator || element;

        // run the command and return normally if successful
        var undef, result = this[command](element, argument);

        
        switch (command) {
        case "getElement":
            if (isc.isAn.Object(result)) return result;
            break;
        case "getValue":
            if (result !== undef) return result;
            break;
        default:
            if (result) return result;
        }

        // elevate testReplay priority to INFO for Selenium
        var oldPriority = isc.Log.getPriority("testReplay");
        if (oldPriority == null || oldPriority < isc.Log.INFO) {
            isc.Log.setPriority("testReplay", isc.Log.INFO);
        }

        var failureReport = this.getLogFailureText();
        if (failureReport) this.logInfo(command + "() returned " + result + " because " +
                                        failureReport, "testReplay");

        // restore previous testReplay logging level
        if      (oldPriority == null)        isc.Log.clearPriority("testReplay");
        else if (oldPriority < isc.Log.INFO) isc.Log.setPriority  ("testReplay", oldPriority);

        return result;
    }
});
