/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.rpc;

import com.isomorphic.auth.DevModeAuthFilter;
import com.isomorphic.base.Config;
import com.isomorphic.log.Logger;
import com.isomorphic.rpc.RPCDMI;
import com.isomorphic.rpc.RPCManager;
import com.isomorphic.rpc.RPCResponse;
import com.isomorphic.servlet.RequestContext;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class RPCRequest {
    private static Logger log = new Logger(RPCRequest.class.getName());
    private static Config config = Config.getGlobal();
    private Object data;
    public RequestContext context;
    public RPCManager rpc;

    public RPCRequest() {
    }

    public RPCRequest(Object data, RequestContext context) {
        this(data);
        this.context = context;
    }

    public RPCRequest(Object data) {
        this();
        this.setData(data);
    }

    public RequestContext getRequestContext() {
        return this.context;
    }

    public Object getData() {
        return this.data;
    }

    public RPCRequest setData(Object data) {
        this.data = data;
        return this;
    }

    public boolean isDMI() {
        return RPCDMI.isDMIRequest(this);
    }

    public String getAppID() {
        if (this.data == null) {
            return null;
        }
        return (String)((Map)this.data).get("appID");
    }

    public String getServerObjectID() {
        if (this.data == null) {
            return null;
        }
        return (String)((Map)this.data).get("className");
    }

    public String getMethodName() {
        if (this.data == null) {
            return null;
        }
        return (String)((Map)this.data).get("methodName");
    }

    public List getMethodArguments() {
        if (this.data == null) {
            return null;
        }
        return (List)((Map)this.data).get("arguments");
    }

    public RPCResponse execute() throws Exception {
        boolean devModeAuthorized;
        log.info("Executing " + this.getAppID() + "." + this.getMethodName());
        RPCResponse rpcResponse = null;
        if (this.isDMI()) {
            String appID = this.getAppID();
            boolean bl = devModeAuthorized = this.context != null && this.context.request != null ? DevModeAuthFilter.devModeAuthorized((HttpServletRequest)this.context.request) : false;
            if ("isc_builtin".equals(appID) && !config.getBoolean((Object)"RPCManager.enableBuiltinRPCs", false) && !devModeAuthorized) {
                throw new Exception("Received Builtin RPC request, but they are disabled in config - ignoring request.  To enable BuiltinRPCs, set RPCManager.enableBuiltinRPCs: true in server.properties, but note that these are development-only tools not audited from a security standpoint for production use.");
            }
            if (devModeAuthorized) {
                String userId = DevModeAuthFilter.getAuthorizedUserId((HttpServletRequest)this.context.request);
                log.info("DevMode Authorized for userId: " + userId + " enabling BuiltinRPC execution.");
            }
        } else {
            throw new Exception("Received non-DMI RPCRequest in IDACall - ignoring.  To send generic RPCRequests, you should override the actionURL property either on the RPCRequest or globally via RPCManager.actionURL.");
        }
        rpcResponse = RPCDMI.execute(this, this.rpc, this.context, devModeAuthorized);
        return rpcResponse;
    }
}

