/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.tools;

import com.isomorphic.base.Base;
import com.isomorphic.base.Reflection;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.DataSourceManager;
import com.isomorphic.js.JSTranslater;
import com.isomorphic.log.Logger;
import com.isomorphic.tools.ExcelDataImport;
import com.isomorphic.tools.TranslaterException;
import com.isomorphic.util.DataTools;
import com.isomorphic.xml.XML;
import isc.org.apache.oro.text.perl.Perl5Util;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;

public class DataImport
extends Base {
    private static PrintStream sysout = System.out;
    private static PrintStream syserr = System.err;
    private static String db;
    private static Logger log;
    private static PrintStream out;
    private static final List dsTypes;
    private static final List dsTranslaters;
    private static final Map defaultTranslaters;
    protected static JSTranslater jsTrans;
    protected static Perl5Util perl;
    protected int inputType;
    protected String delimiter = null;
    protected String quoteString;
    protected Map errors;
    boolean keepNonRemappedColumns = false;
    public static final int DELIMITED = 1;
    public static final int JS_LITERAL = 2;
    public static final int EXCEL = 3;
    public static final int DEFAULT_INPUT = 1;
    public static final String DEFAULT_DELIMITER = ",";
    public static final String DEFAULT_QUOTE_STRING = "\"";
    public static final String DEFAULT_TRANSLATER = "com.isomorphic.tools.DataImport.parseText";
    private static HashSet dataSources;
    private static String targetDir;
    private static List lastColumns;

    public DataImport() {
        this(1, DEFAULT_DELIMITER, DEFAULT_QUOTE_STRING);
    }

    public DataImport(int theInputType, String theDelimiter) {
        this(theInputType, theDelimiter, DEFAULT_QUOTE_STRING);
    }

    public DataImport(int theInputType, String theDelimiter, String quoteString) {
        this.inputType = theInputType;
        this.delimiter = theDelimiter;
        this.quoteString = quoteString;
        this.errors = new HashMap();
    }

    public void setInputType(int theInputType, String theDelimiter) {
        this.inputType = theInputType;
        this.delimiter = theDelimiter;
    }

    public void setQuoteString(String qs) {
        this.quoteString = qs;
    }

    public void setKeepNonRemappedColumns(boolean keep) {
        this.keepNonRemappedColumns = keep;
    }

    public Map getErrors() {
        return this.errors;
    }

    private void addError(int line, String message) {
        DataTools.putMultiple((Map)this.errors, (Object)new Integer(line), (Object)message);
    }

    public long importToDataSource(Reader in, String dataSourceName) throws Exception {
        return this.importToDataSource(in, (Map)null, null, dataSourceName);
    }

    public long importToDataSource(Reader in, List columns, String tableName) throws Exception {
        return this.importToDataSource(in, DataTools.identityMap((List)columns), null, tableName);
    }

    public long importToDataSource(Reader in, Map columnRemap, String tableName) throws Exception {
        return this.importToDataSource(in, columnRemap, null, tableName);
    }

    public long importToDataSource(Reader in, List columns, Map translaters, String tableName) throws Exception {
        return this.importToDataSource(in, DataTools.identityMap((List)columns), translaters, tableName);
    }

    public long importToDataSource(Reader in, Map columnRemap, Map translaters, String dataSourceName) throws Exception {
        DataSource ds;
        try {
            ds = DataSourceManager.getDataSource((String)dataSourceName, null);
        }
        catch (Exception e) {
            throw new Exception("Problem instantiating datasource: " + dataSourceName + "\n" + e.toString());
        }
        List dsColumns = ds.getFieldNames();
        if (columnRemap == null) {
            columnRemap = DataTools.identityMap((List)dsColumns);
        } else {
            HashMap strippedRemap = new HashMap();
            for (Object key : columnRemap.keySet()) {
                Object value = columnRemap.get(key);
                if (!dsColumns.contains(value)) continue;
                strippedRemap.put(key, value);
            }
            columnRemap = strippedRemap;
        }
        if (translaters == null) {
            translaters = new HashMap();
        }
        for (Object column : columnRemap.keySet()) {
            Object remap = columnRemap.get(column);
            if (translaters.get(column) != null) continue;
            String fieldType = ds.getField((String)remap).getType();
            Object trans = defaultTranslaters.get(fieldType);
            if (trans == null) {
                log.error((Object)("Column " + remap + " had unknown column type " + fieldType));
                trans = DEFAULT_TRANSLATER;
            }
            translaters.put(column, trans);
        }
        List rows = this.importToRows(in, columnRemap, translaters);
        if (rows == null || rows.size() <= 0) {
            log.debug((Object)"Null or empty input results");
            return 0L;
        }
        long result = ds.insert((Object)rows);
        DataSourceManager.freeDataSource((DataSource)ds);
        return result;
    }

    public List importToRows(Reader in) throws Exception {
        return this.importToRows(in, (Map)null, null);
    }

    public List importToRows(Reader in, List columns) throws Exception {
        return this.importToRows(in, DataTools.identityMap((List)columns), null);
    }

    public List importToRows(Reader in, Map columnRemap) throws Exception {
        return this.importToRows(in, columnRemap, null);
    }

    public List importToRows(Reader in, List columns, Map translaters) throws Exception {
        return this.importToRows(in, DataTools.identityMap((List)columns), translaters);
    }

    public List importToRows(Reader in, Map columnRemap, Map translaters) throws Exception {
        LineNumberReader input = new LineNumberReader(in);
        List rows = null;
        if (translaters == null) {
            translaters = new HashMap();
        }
        if (this.inputType == 1) {
            String line;
            rows = new ArrayList();
            List columns = null;
            do {
                if ((columns = this.splitRow(line = input.readLine())) != null) continue;
                log.debug((Object)"Input data was empty");
                return rows;
            } while ((columns = this.trimTrailingEmptyColumns(columns)).size() == 0);
            lastColumns = columns;
            while ((line = input.readLine()) != null) {
                try {
                    if (line.trim().equals("")) continue;
                    List data = this.splitRow(line);
                    if ((data = this.trimTrailingEmptyColumns(data)).size() > columns.size()) {
                        int lineNum = input.getLineNumber();
                        log.warn((Object)("Extra columns at line " + lineNum + " (expected " + columns.size() + ", got " + data.size() + "), ignoring extra column values"));
                        data = data.subList(0, columns.size() - 1);
                    }
                    HashMap<String, Object> row = new HashMap<String, Object>();
                    for (int i = 0; i < data.size(); ++i) {
                        String column = (String)columns.get(i);
                        String rawValue = (String)data.get(i);
                        if (rawValue.equals("")) continue;
                        Object field = this.translate((String)translaters.get(column), rawValue);
                        row.put(column, field);
                    }
                    rows.add(row);
                }
                catch (ParseException e) {
                    int lineNum = input.getLineNumber();
                    log.error((Object)("Malformed line " + lineNum + ": " + e.toString()));
                    this.addError(lineNum, e.toString());
                }
                catch (TranslaterException e) {
                    int lineNum = input.getLineNumber();
                    log.error((Object)("Parse error at line " + input.getLineNumber() + ": " + e.toString()));
                    this.addError(lineNum, e.toString());
                }
            }
        } else if (this.inputType == 2) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            String line = null;
            while ((line = input.readLine()) != null) {
                pw.println(line);
            }
            rows = (List)jsTrans.fromJS(sw.toString());
        } else {
            throw new Exception("Invalid inputType value was set!");
        }
        if (rows != null && columnRemap != null) {
            rows = DataTools.remapRows(rows, (Map)columnRemap, (boolean)this.keepNonRemappedColumns);
        }
        return rows;
    }

    public List importToRows(InputStream in, Map columnRemap, Map translaters) throws Exception {
        if (this.inputType != 3) {
            return this.importToRows((Reader)new InputStreamReader(in), columnRemap, translaters);
        }
        List rows = ExcelDataImport.importExcelStream(in, null, columnRemap, 0, 0, 9999, true);
        if (rows != null && columnRemap != null) {
            rows = DataTools.remapRows((List)rows, (Map)columnRemap, (boolean)this.keepNonRemappedColumns);
        }
        return rows;
    }

    private Object translate(String translater, String field) throws Exception {
        String methodName;
        String className;
        int index;
        if (translater == null) {
            translater = DEFAULT_TRANSLATER;
        }
        if ((index = translater.lastIndexOf(46)) == -1) {
            className = DataImport.class.getName();
            methodName = translater;
        } else {
            className = translater.substring(0, index);
            methodName = translater.substring(index + 1);
        }
        return Reflection.invokeStaticMethod((String)className, (String)methodName, (Object)field);
    }

    private List splitRow(String line) throws ParseException {
        if (line == null) {
            return null;
        }
        if (this.quoteString == null || this.quoteString.equals("")) {
            ArrayList results = new ArrayList();
            perl.split(results, "/" + this.delimiter + "/", line);
            return results;
        }
        ArrayList<String> results = new ArrayList<String>();
        String element = null;
        int offset = 0;
        int lineLength = line.length();
        int delimiterLength = this.delimiter.length();
        int qsLength = this.quoteString.length();
        while (offset <= lineLength) {
            int next;
            if (line.startsWith(this.quoteString, offset)) {
                element = "";
                offset += qsLength;
                while (true) {
                    if ((next = line.indexOf(this.quoteString, offset)) == -1) {
                        throw new ParseException("Unterminated quote string", offset);
                    }
                    element = element + line.substring(offset, next);
                    offset = next + qsLength;
                    if (!line.startsWith(this.quoteString, offset)) break;
                    element = element + this.quoteString;
                    offset += qsLength;
                }
                if (offset != lineLength && !line.startsWith(this.delimiter, offset)) {
                    throw new ParseException("Delimiter or end of line expected after quoted value", offset);
                }
                offset += delimiterLength;
            } else {
                next = line.indexOf(this.delimiter, offset);
                if (next == -1) {
                    next = lineLength;
                }
                element = line.substring(offset, next);
                offset = next + delimiterLength;
            }
            results.add(element);
        }
        return results;
    }

    private List trimTrailingEmptyColumns(List values) {
        if (values == null || values.size() == 0) {
            return values;
        }
        while ("".equals(values.get(values.size() - 1))) {
            values.remove(values.size() - 1);
        }
        return values;
    }

    public static Object parseText(String field) throws TranslaterException {
        return field;
    }

    public static Object parseNumber(String field) throws TranslaterException {
        try {
            return new BigInteger(field);
        }
        catch (NumberFormatException e) {
            throw new TranslaterException(e.toString());
        }
    }

    public static Object parseFloat(String field) throws TranslaterException {
        try {
            return new BigDecimal(field);
        }
        catch (NumberFormatException e) {
            throw new TranslaterException(e.toString());
        }
    }

    public static Object parseDate(String field) throws TranslaterException {
        DateFormat df = DateFormat.getDateInstance();
        df.setLenient(true);
        try {
            return df.parse(field);
        }
        catch (ParseException e) {
            throw new TranslaterException(e.toString());
        }
    }

    public static Object parseDateTime(String field) throws TranslaterException {
        DateFormat df = DateFormat.getDateTimeInstance();
        df.setLenient(true);
        try {
            return df.parse(field);
        }
        catch (ParseException e) {
            throw new TranslaterException(e.toString());
        }
    }

    public static void processDataImportRequest(String fileName, Reader in, Writer out, boolean genDS, boolean jsInput, boolean jsOutput, boolean xmlOutput, String theDelimiter, String datasource, Object columns, Object translaters) throws Exception {
        File file;
        int dotIndex;
        if (!fileName.equals("default") && (dotIndex = (fileName = (file = new File(fileName)).getName()).indexOf(".")) != -1) {
            fileName = fileName.substring(0, dotIndex);
        }
        DataImport di = jsInput ? new DataImport(2, null) : (theDelimiter != null ? new DataImport(1, theDelimiter) : new DataImport());
        if (datasource != null) {
            long results;
            if (columns == null || columns instanceof Map) {
                results = di.importToDataSource(in, (Map)columns, (Map)translaters, datasource);
            } else if (columns instanceof List) {
                results = di.importToDataSource(in, (List)columns, (Map)translaters, datasource);
            } else {
                throw new Exception("columns must be a List or a Map");
            }
            out.write(String.valueOf(results) + " row(s) inserted\n");
            out.flush();
        } else {
            List results;
            if (columns == null || columns instanceof Map) {
                results = di.importToRows(in, (Map)columns, (Map)translaters);
            } else if (columns instanceof List) {
                results = di.importToRows(in, (List)columns, (Map)translaters);
            } else {
                throw new Exception("columns must be a List or a Map");
            }
            String output = "";
            if (jsOutput) {
                output = jsTrans.toJS((Object)results);
            } else if (xmlOutput) {
                File dataFile = new File(fileName + ".data.xml");
                if (dataFile.exists()) {
                    dataFile.delete();
                }
                FileWriter data = new FileWriter(dataFile);
                data.write("<records>\n");
                for (Map record : results) {
                    XML.recordToXML((String)"record", (Map)record, (Writer)data, (boolean)false, null);
                }
                data.write("</records>\n");
                data.flush();
            } else {
                output = results.toString();
            }
            out.write(output + "\n");
            out.flush();
            if (genDS) {
                HashMap c = new HashMap();
                for (String name : lastColumns) {
                    c.put(name, new HashMap());
                }
                DataImport.createDataSource(fileName, c, null);
            }
        }
    }

    public static void createDataSource(String dsName, Map columns, String relation) throws Exception {
        log.info((Object)("Creating datasource: " + dsName));
        File dsFile = new File(targetDir + dsName + ".ds.xml");
        if (dsFile.exists()) {
            dsFile.delete();
        }
        FileWriter dsWriter = new FileWriter(dsFile);
        dsWriter.write("<DataSource ID=\"" + dsName + "\" tableName=\"" + dsName + "\">\n");
        dsWriter.write("\t<fields>\n");
        if (relation != null) {
            dsWriter.write("\t\t<field name=\"parentId\" type=\"integer\" foreignKey=\"" + relation + ".id\" hidden=\"true\"/>\n");
        }
        for (String name : columns.keySet()) {
            Map field = (Map)columns.get(name);
            String title = (String)field.get("label");
            if (title == null) {
                title = name;
            }
            boolean canEdit = true;
            String type = (String)field.get("type");
            if (type == null) {
                type = "text";
            }
            if (type.equals("ro")) {
                canEdit = false;
            }
            type = type.equals("d") ? "date" : (type.equals("num") ? "integer" : (type.equals("curr") ? "float" : "text"));
            String length = (String)field.get("w");
            dsWriter.write("\t\t<field");
            dsWriter.write(" name=\"" + name + DEFAULT_QUOTE_STRING);
            dsWriter.write(" title=\"" + title + DEFAULT_QUOTE_STRING);
            dsWriter.write(" type=\"" + type + DEFAULT_QUOTE_STRING);
            if (type.equals("text") && length != null) {
                dsWriter.write(" length=\"" + length + DEFAULT_QUOTE_STRING);
            }
            if (!canEdit) {
                dsWriter.write(" canEdit=\"false\"");
            }
            dsWriter.write("/>\n");
        }
        dsWriter.write("\t</fields>\n");
        dsWriter.write("</DataSource>\n");
        ((Writer)dsWriter).flush();
        dataSources.add(dsName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        PosixParser parser = new PosixParser();
        String cmdLineSyntax = "dataImport [options] [input files]";
        Options options = new Options();
        options.addOption("h", "help", false, "Display this help message");
        options.addOption("j", "jsInput", false, "Specifies that the input format is a Javascript literal.  (Default format is comma-separated values).  Ignored for imports to datasource or table.");
        options.addOption("J", "jsOutput", false, "Set the output format to Javascript literal.  (Default format is comma-separated values).  Ignored for imports to datasource or table.");
        options.addOption("X", "xmlOutput", false, "Set the output format to XML.  (Default format is comma-separated values).  Ignored for imports to datasource or table.");
        options.addOption("g", "generateDataSource", false, "Generate a datasource (in xml format).");
        OptionBuilder.withLongOpt((String)"datasource");
        OptionBuilder.withDescription((String)"Input data into the table associated with this datasource.");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"datasourceName");
        OptionBuilder.withValueSeparator((char)' ');
        options.addOption(OptionBuilder.create((char)'d'));
        OptionBuilder.withLongOpt((String)"table");
        OptionBuilder.withDescription((String)"Input data into this table. NOT IMPLEMENTED YET!");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"tableName");
        OptionBuilder.withValueSeparator((char)' ');
        options.addOption(OptionBuilder.create((char)'t'));
        OptionBuilder.withLongOpt((String)"columns");
        OptionBuilder.withDescription((String)"Specify the fields to be imported, as a Javascript literal.  Provide either a list of the field names or a map of the input field names to the database field names");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"columns");
        OptionBuilder.withValueSeparator((char)' ');
        options.addOption(OptionBuilder.create((char)'c'));
        OptionBuilder.withLongOpt((String)"delimiter");
        OptionBuilder.withDescription((String)"Set the delimiter. (Default delimiter is a comma - the ',' character)");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"delimiter");
        OptionBuilder.withValueSeparator((char)' ');
        options.addOption(OptionBuilder.create((char)'l'));
        OptionBuilder.withLongOpt((String)"translaters");
        OptionBuilder.withDescription((String)"Specify the translaters as a Javascript literal map. Set the property name to the data type (as specified in the datasource) and the value to the fully-qualified Java method to be used as the translater. If only the method name is specified, then it's assumed it's a method of the com.isomorphic.tools.DataImport class");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"translaters");
        OptionBuilder.withValueSeparator((char)' ');
        options.addOption(OptionBuilder.create((char)'r'));
        if (args.length == 0) {
            DataImport.outputHelp(cmdLineSyntax, options);
            System.exit(0);
        }
        String theDelimiter = null;
        String source = null;
        Object columns = null;
        Object translaters = null;
        boolean jsInput = false;
        boolean jsOutput = false;
        boolean xmlOutput = false;
        boolean genDS = false;
        CommandLine line = null;
        try {
            line = parser.parse(options, args);
            if (line.hasOption("c")) {
                columns = jsTrans.fromJS(line.getOptionValue("c"));
            }
            if (line.hasOption("d")) {
                source = line.getOptionValue("d");
            }
            if (line.hasOption("j")) {
                jsInput = true;
            }
            if (line.hasOption("J")) {
                jsOutput = true;
            }
            if (line.hasOption("X")) {
                xmlOutput = true;
            }
            if (line.hasOption("g")) {
                genDS = true;
            }
            if (line.hasOption("l")) {
                theDelimiter = line.getOptionValue("l");
            }
            if (line.hasOption("r")) {
                translaters = jsTrans.fromJS(line.getOptionValue("r"));
            }
            if (line.hasOption("t")) {
                syserr.println("The import to table option is not supported yet.");
                System.exit(1);
            }
            if (line.hasOption("h")) {
                DataImport.outputHelp(cmdLineSyntax, options);
                System.exit(0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        OutputStreamWriter out = new OutputStreamWriter(sysout);
        boolean inputFromFile = false;
        List fileList = line.getArgList();
        Iterator i = fileList.iterator();
        while (i.hasNext()) {
            inputFromFile = true;
            String fileName = (String)i.next();
            try {
                FileReader in = new FileReader(fileName);
                DataImport.processDataImportRequest(fileName, in, out, genDS, jsInput, jsOutput, xmlOutput, theDelimiter, source, columns, translaters);
                in.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!inputFromFile) {
            InputStreamReader in = null;
            try {
                in = new InputStreamReader(System.in);
                DataImport.processDataImportRequest("default", in, out, genDS, jsInput, jsOutput, xmlOutput, theDelimiter, source, columns, translaters);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        System.exit(0);
    }

    public static void outputHelp(String cmdLineSyntax, Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(cmdLineSyntax, "", options, "\nNotes:\nIf an input file name is not specified, input comes from stdin. Output goes to stdout if neither a datasource nor a table are specified. If no columns are specified, all columns will be imported.");
    }

    static {
        log = new Logger(DataImport.class.getName());
        out = System.out;
        dsTypes = DataTools.arrayToList((Object[])new String[]{"text", "number", "int", "integer", "sequence", "float", "decimal", "datetime", "date"});
        dsTranslaters = DataTools.arrayToList((Object[])new String[]{DEFAULT_TRANSLATER, "com.isomorphic.tools.DataImport.parseNumber", "com.isomorphic.tools.DataImport.parseNumber", "com.isomorphic.tools.DataImport.parseNumber", "com.isomorphic.tools.DataImport.parseNumber", "com.isomorphic.tools.DataImport.parseFloat", "com.isomorphic.tools.DataImport.parseFloat", "com.isomorphic.tools.DataImport.parseDateTime", "com.isomorphic.tools.DataImport.parseDate"});
        defaultTranslaters = DataTools.mapFromLists((List)dsTypes, (List)dsTranslaters);
        jsTrans = new JSTranslater();
        perl = new Perl5Util();
        dataSources = new HashSet();
        targetDir = "";
        db = config.getString((Object)"sql.defaultDatabase");
        if (db == null) {
            log.error((Object)"sql.defaultDatabase not defined in config file!");
        }
    }
}

