/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.xml;

import com.isomorphic.base.Base;
import com.isomorphic.base.Reflection;
import com.isomorphic.base.VersionSafeChecker;
import com.isomorphic.datasource.BasicDataSource;
import com.isomorphic.datasource.DSField;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.DataSourceManager;
import com.isomorphic.datasource.ValidationContext;
import com.isomorphic.io.ISCFile;
import com.isomorphic.js.JSTranslater;
import com.isomorphic.log.Logger;
import com.isomorphic.store.DataStructCache;
import com.isomorphic.store.ProcessedFileCache;
import com.isomorphic.util.DataTools;
import com.isomorphic.util.ISCDate;
import com.isomorphic.util.ISCHttpClient;
import com.isomorphic.util.ISCTime;
import com.isomorphic.xml.XMLParsingException;
import com.isomorphic.xml.XmlToMapHandler;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.collections.map.LinkedMap;
import org.apache.commons.jxpath.JXPathContext;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class XML
extends Base {
    private static Logger log = new Logger(XML.class.getName());
    static String webRoot = config.getPath("webRoot");
    static Set ignoreNamespaceAttributes = new HashSet();
    public static int totalParseTime;
    public static int totalDSParseTime;
    static DocumentCache cache;
    static RecordsFromXMLCache recordsCache;
    static String defaultNamespacePrefix;
    public static SimpleDateFormat xmlDateFormat;

    public static Map parseXMLToMap(String source) throws Exception {
        return XML.parseXMLToMap(new InputSource(new StringReader(source)));
    }

    public static Map parseXMLToMap(InputSource source) throws Exception {
        XMLReader xmlReader = XMLReaderFactory.createXMLReader();
        XmlToMapHandler xmlToMapHandler = new XmlToMapHandler();
        xmlToMapHandler.setUseListsForMultipleElements(true);
        xmlReader.setContentHandler(xmlToMapHandler);
        xmlReader.parse(source);
        return xmlToMapHandler.getResult();
    }

    public static Document parseRestrictedXML(InputSource source) throws Exception {
        return XML.parseXML(source, false, true);
    }

    public static Document parseXML(InputSource source) throws Exception {
        return XML.parseXML(source, false, false);
    }

    public static Document parseXML(InputSource source, boolean validate) throws Exception {
        return XML.parseXML(source, validate, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document parseXML(InputSource source, boolean validate, boolean restricted) throws Exception {
        Document document;
        final String filename = source.getSystemId() != null ? source.getSystemId() : "(in memory stream)";
        InputStream is = null;
        if (source.getSystemId() != null && source.getByteStream() == null) {
            is = new ISCFile(source.getSystemId()).getInputStream();
            source = new InputSource(is);
        }
        try {
            long start = System.currentTimeMillis();
            DocumentBuilderFactory parserFactory = DocumentBuilderFactory.newInstance();
            parserFactory.setNamespaceAware(true);
            if (restricted) {
                validate = false;
                try {
                    parserFactory.setExpandEntityReferences(false);
                }
                catch (Exception e) {
                    log.info((Object)"An exception was thrown while turning off entity expansion: ", e);
                }
                try {
                    parserFactory.setXIncludeAware(false);
                }
                catch (Exception e) {
                    log.debug((Object)"An exception was thrown while turning off X-Include: ", e);
                }
                try {
                    parserFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
                    parserFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
                }
                catch (Throwable e) {
                    log.debug((Object)"An exception was thrown while setting feature strings to prevent loading a DTD: ", e);
                }
                try {
                    if (VersionSafeChecker.is5()) {
                        parserFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                    } else {
                        parserFactory.setAttribute("http://apache.org/xml/properties/security-manager", Reflection.instantiateClass("org.apache.xerces.util.SecurityManager"));
                    }
                }
                catch (Throwable e) {
                    log.debug((Object)"An exception was thrown while setting security manager: ", e);
                }
                if (config.getBoolean((Object)"xml.disallow.doctype", false)) {
                    parserFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                }
            }
            DocumentBuilder parser = parserFactory.newDocumentBuilder();
            if (!validate) {
                parser.setEntityResolver(new EntityResolver(){

                    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                        return new InputSource(new ByteArrayInputStream("<?xml version='1.0' encoding='UTF-8'?>".getBytes()));
                    }
                });
            }
            final ArrayList errors = new ArrayList();
            boolean fatalError = true;
            parser.setErrorHandler(new ErrorHandler(){

                public void warning(SAXParseException e) {
                    String message = "XML parser warning: file '" + filename + "' line " + e.getLineNumber() + ": " + e;
                    errors.add(message);
                    log.warn(message);
                }

                public void error(SAXParseException e) {
                    String message = "XML parser error: file '" + filename + "' line " + e.getLineNumber() + ": " + e;
                    errors.add(message);
                    log.warn(message);
                }

                public void fatalError(SAXParseException e) {
                    String message = "XML parser fatal error: file '" + filename + "' line " + e.getLineNumber() + ": " + e;
                    errors.add(message);
                    log.error(message);
                }
            });
            Document doc = null;
            try {
                doc = parser.parse(source);
                doc.normalize();
            }
            catch (SAXException saxE) {
                log.debug("Exception thrown during XML parsing");
                XMLParsingException e = new XMLParsingException(DataTools.prettyPrint(errors));
                e.setErrors(errors);
                throw e;
            }
            long end = System.currentTimeMillis();
            log.debug("Parsed XML from " + filename + ": " + (end - start) + "ms");
            totalParseTime = (int)((long)totalParseTime + (end - start));
            if (filename != null && filename.endsWith(".ds.xml")) {
                totalDSParseTime = (int)((long)totalDSParseTime + (end - start));
            }
            document = doc;
            Object var16_19 = null;
        }
        catch (Throwable throwable) {
            Object var16_20 = null;
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            if (is != null) {
                is.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return document;
    }

    public static Document getXMLDocument(String filename) throws Exception {
        return XML.getXMLDocument(filename, false);
    }

    public static Document getXMLDocument(String filename, boolean bypassCache) throws Exception {
        HashMap<String, Boolean> flags = new HashMap<String, Boolean>();
        flags.put("bypassCache", new Boolean(bypassCache));
        filename = DataTools.makePathAbsolute(filename);
        return (Document)cache.getObjectFromFile(new ISCFile(filename), flags);
    }

    public static Object toDSRecords(String filename, ValidationContext context, boolean bypassCache) throws Exception {
        return XML.toDSRecords(XML.getXMLDocument(filename, bypassCache).getDocumentElement(), context);
    }

    public static Object toDSRecords(String filename, ValidationContext context) throws Exception {
        return XML.toDSRecords(filename, context, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object toDSRecords(String filename) throws Exception {
        ValidationContext vc = new ValidationContext();
        try {
            Object object = XML.toDSRecords(filename, vc);
            Object var4_3 = null;
            vc.freeResources();
            return object;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            vc.freeResources();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object toDSRecords(String filename, boolean bypassCache) throws Exception {
        ValidationContext vc = new ValidationContext();
        try {
            Object object = XML.toDSRecords(filename, vc, bypassCache);
            Object var5_4 = null;
            vc.freeResources();
            return object;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            vc.freeResources();
            throw throwable;
        }
    }

    public static Object toDSRecords(ISCFile file) throws Exception {
        return XML.toDSRecords(new InputStreamReader(file.getInputStream()));
    }

    public static Object toDSRecords(ISCFile file, ValidationContext context) throws Exception {
        return XML.toDSRecords(new InputStreamReader(file.getInputStream()), context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object toDSRecords(Reader reader) throws Exception {
        ValidationContext vc = new ValidationContext();
        try {
            Object object = XML.toDSRecords(reader, vc);
            Object var4_3 = null;
            vc.freeResources();
            return object;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            vc.freeResources();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object toDSRecords(InputSource source) throws Exception {
        ValidationContext vc = new ValidationContext();
        try {
            Object object = XML.toDSRecords(source, vc);
            Object var4_3 = null;
            vc.freeResources();
            return object;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            vc.freeResources();
            throw throwable;
        }
    }

    public static Object toDSRecords(Reader reader, ValidationContext context) throws Exception {
        return XML.toDSRecords(new InputSource(reader), context);
    }

    public static Object toDSRecords(InputSource source, ValidationContext context) throws Exception {
        if (context.getRestrictedXMLMode()) {
            return XML.toDSRecords(XML.parseRestrictedXML(source).getDocumentElement(), context);
        }
        return XML.toDSRecords(XML.parseXML(source).getDocumentElement(), context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object toDSRecords(Element element) throws Exception {
        ValidationContext vc = new ValidationContext();
        try {
            Object object = XML.toDSRecords(element, vc);
            Object var4_3 = null;
            vc.freeResources();
            return object;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            vc.freeResources();
            throw throwable;
        }
    }

    public static Object toDSRecords(Element element, ValidationContext context) throws Exception {
        long start = System.currentTimeMillis();
        Object result = DataSource.recordsFromXML(element, context);
        long end = System.currentTimeMillis();
        Logger.timing.debug("DataSource record created from XML with document element: '" + element.getTagName() + "': " + (end - start) + "ms");
        return result;
    }

    public static ValidationContext toJS(ISCFile file, Writer out) throws Exception {
        return XML.toJS(file.getReader(), out);
    }

    public static ValidationContext toJS(String xml, Writer out) throws Exception {
        return XML.toJS(new StringReader(xml), out);
    }

    public static ValidationContext toJS(String xml, Locale locale, Writer out) throws Exception {
        return XML.toJS(new StringReader(xml), locale, out);
    }

    public static ValidationContext toJS(Reader reader, Writer out) throws Exception {
        return XML.toJS(reader, null, out);
    }

    public static ValidationContext toJS(Reader reader, Locale locale, Writer out) throws Exception {
        return XML.toJS(reader, locale, out, null);
    }

    public static ValidationContext toJS(Reader reader, Locale locale, Writer out, Boolean obfuscation) throws Exception {
        ValidationContext context = new ValidationContext();
        JSTranslater jst = JSTranslater.instance();
        jst.setLocale(locale);
        if (obfuscation != null) {
            jst.setObfuscation(obfuscation);
        }
        jst.toJS(XML.toDSRecords(reader, context), out);
        context.freeResources();
        return context;
    }

    public static ValidationContext toJS(Element element, Writer out) throws Exception {
        ValidationContext context = new ValidationContext();
        JSTranslater.instance().toJS(XML.toDSRecords(element, context), out);
        context.freeResources();
        return context;
    }

    public static Object loadCacheableDSRecords(ISCFile xmlFile) throws Exception {
        return XML.loadCacheableDSRecords(xmlFile, null);
    }

    public static Object loadCacheableDSRecords(ISCFile xmlFile, Map flags) throws Exception {
        return recordsCache.getObjectFromFile(xmlFile, flags);
    }

    public static String quoteXMLString(String value, boolean asAttr) throws Exception {
        StringWriter out = new StringWriter();
        XML.quoteXMLString(value, out, asAttr);
        return out.toString();
    }

    public static void quoteXMLString(String value, Writer out, boolean asAttr) throws Exception {
        boolean substituting = false;
        int copiedFrom = 0;
        int length = value.length();
        for (int i = 0; i < length; ++i) {
            char quote = value.charAt(i);
            switch (quote) {
                case '\n': 
                case '\"': 
                case '&': 
                case '<': 
                case '>': {
                    substituting = true;
                    out.write(value.substring(copiedFrom, i));
                    switch (quote) {
                        case '>': {
                            out.write("&gt;");
                            break;
                        }
                        case '<': {
                            out.write("&lt;");
                            break;
                        }
                        case '&': {
                            out.write("&amp;");
                            break;
                        }
                        case '\n': {
                            if (asAttr) {
                                out.write("&amp;#010");
                                break;
                            }
                            out.write(quote);
                            break;
                        }
                        case '\"': {
                            if (asAttr) {
                                out.write("&quot;");
                                break;
                            }
                            out.write(quote);
                        }
                    }
                    copiedFrom = i + 1;
                }
            }
        }
        if (substituting) {
            out.write(value.substring(copiedFrom));
        } else {
            out.write(value);
        }
    }

    public static String toXML(NodeList list) throws IOException {
        if (list == null) {
            return "";
        }
        StringWriter out = new StringWriter();
        int length = list.getLength();
        for (int i = 0; i < length; ++i) {
            Node node = list.item(i);
            if (!(node instanceof Node)) continue;
            XML.toXML(out, node);
        }
        return out.toString();
    }

    public static String toXML(Node node) throws IOException {
        if (node == null) {
            return "";
        }
        StringWriter out = new StringWriter();
        XML.toXML(out, node);
        return out.toString();
    }

    public static void toXML(Writer out, Node node) throws IOException {
        XML.toXML(out, node, XML.getUnchangedTransformer());
    }

    public static void toXML(Writer out, Collection c, Transformer transformer) throws IOException {
        for (Object node : c) {
            if (!(node instanceof Node)) continue;
            XML.toXML(out, (Node)node, transformer);
        }
    }

    public static void toXML(Writer out, Node node, Transformer transformer) throws IOException {
        if (node == null) {
            out.write("\n");
            return;
        }
        try {
            transformer.transform(new DOMSource(node), new StreamResult(out));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getElementText(Element element) {
        String ret = null;
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            String s;
            Node child = children.item(i);
            if (child instanceof Element || !"#text".equals(child.getNodeName()) && !"#cdata-section".equals(child.getNodeName()) || (s = child.getNodeValue()) == null || "".equals(s.trim())) continue;
            ret = ret == null ? s : ret + s;
        }
        return ret;
    }

    public static List getChildren(Node node) {
        final NodeList nodeList = node.getChildNodes();
        return new AbstractList(){

            public Object get(int index) {
                return nodeList.item(index);
            }

            public int size() {
                return nodeList.getLength();
            }
        };
    }

    public static Map getElementChildrenMap(Element element) {
        HashMap elementChildren = new HashMap();
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!(child instanceof Element)) continue;
            Element childElement = (Element)child;
            DataTools.putMultiple(elementChildren, childElement.getTagName(), childElement);
        }
        return elementChildren;
    }

    public static List getElementChildren(Element element) {
        return XML.getElementChildren(element, (Map)null);
    }

    public static List getElementChildren(Element element, String tagName) {
        return XML.getElementChildren(element, DataTools.buildMap(tagName, new Object()));
    }

    public static List getElementChildren(Element element, Map tags) {
        ArrayList<Element> elementChildren = new ArrayList<Element>();
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!(child instanceof Element)) continue;
            Element childElement = (Element)child;
            if (tags != null && !tags.containsKey(childElement.getTagName())) continue;
            elementChildren.add(childElement);
        }
        return elementChildren;
    }

    public static String getAttribute(Element element, String attrName) {
        return element.hasAttribute(attrName) ? element.getAttribute(attrName) : null;
    }

    public static Map attributesToMap(Element element) {
        return XML.addAttributesToMap(element, null);
    }

    public static Map addAttributesToMap(Element element, Map map) {
        if (map == null) {
            map = new LinkedMap();
        }
        if (element.hasAttributes()) {
            NamedNodeMap attrs = element.getAttributes();
            for (int i = 0; i < attrs.getLength(); ++i) {
                Node attr = attrs.item(i);
                String namespace = attr.getNamespaceURI();
                if (namespace != null && ignoreNamespaceAttributes.contains(namespace)) continue;
                String attrName = attr.getLocalName();
                if (attrName == null) {
                    attrName = attr.getNodeName();
                }
                if (attrName.equals("_BLANK_")) {
                    attrName = "";
                }
                if (map.containsKey(attrName)) continue;
                map.put(attrName, attr.getNodeValue());
            }
        }
        return map;
    }

    public static Transformer getUnchangedTransformer() {
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer unchanged = null;
        try {
            unchanged = tf.newTransformer();
            unchanged.setOutputProperty("method", "xml");
            unchanged.setOutputProperty("omit-xml-declaration", "yes");
            unchanged.setOutputProperty("indent", "no");
            unchanged.setOutputProperty("encoding", "UTF-8");
        }
        catch (Exception e) {
            log.error("Error trying to create basic XML transformer");
        }
        return unchanged;
    }

    public static String toSimpleValue(Element element) {
        String value;
        if (!element.hasChildNodes() && (value = XML.getAttribute(element, "value")) == null) {
            if ("true".equals(element.getAttribute("xsi:nil"))) {
                return null;
            }
            return "";
        }
        StringWriter out = new StringWriter();
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            try {
                Node child = children.item(i);
                if (child instanceof Text) {
                    ((Writer)out).write(((Text)child).getData());
                    continue;
                }
                if (!(child instanceof Element)) continue;
                XML.toXML((Writer)out, (Element)child, XML.getUnchangedTransformer());
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return ((Object)out).toString();
    }

    public static String getXPathSegment(Element element) {
        String xpath = element.getTagName();
        if (element.hasAttribute("ID")) {
            xpath = xpath + "[@ID=" + element.getAttribute("ID") + "]";
        } else if (element.hasAttribute("name")) {
            xpath = xpath + "[@name=" + element.getAttribute("name") + "]";
        }
        return xpath;
    }

    public static String getXPath(Element element) {
        String xpath = "";
        Element next = element;
        while (true) {
            xpath = "/" + XML.getXPathSegment(next) + xpath;
            Node parent = next.getParentNode();
            if (parent == null || !(parent instanceof Element)) break;
            next = (Element)parent;
        }
        return xpath;
    }

    public static List selectNodes(Object element, String expression) {
        return XML.selectNodes(element, expression, null);
    }

    public static List selectNodes(Object element, String expression, Map namespaces) {
        Element e;
        String nsURI;
        JXPathContext jxpathContext = JXPathContext.newContext((Object)element);
        if ((element instanceof Document || element instanceof Element) && (nsURI = (e = element instanceof Element ? (Element)element : ((Document)element).getDocumentElement()).getNamespaceURI()) != null) {
            if (namespaces == null) {
                namespaces = new HashMap<String, String>();
            }
            if (namespaces.get(defaultNamespacePrefix) == null) {
                namespaces.put(defaultNamespacePrefix, nsURI);
            }
        }
        if (namespaces != null) {
            for (String prefix : namespaces.keySet()) {
                String namespaceURI = (String)namespaces.get(prefix);
                jxpathContext.registerNamespace(prefix, namespaceURI);
            }
        }
        return jxpathContext.selectNodes(expression);
    }

    public static Object elementAsPropertyMap(Element element) {
        Map childMap = XML.getElementChildrenMap(element);
        if (childMap.isEmpty() && !element.hasAttributes()) {
            return XML.toSimpleValue(element);
        }
        XML.addAttributesToMap(element, childMap);
        return childMap;
    }

    public static Object elementAsNamedProperties(Element element) {
        List childElements = XML.getElementChildren(element);
        if (childElements.isEmpty()) {
            if ("true".equals(element.getAttribute("xsi:nil"))) {
                return null;
            }
            if (!element.hasAttributes()) {
                Node child = element.getFirstChild();
                return child != null ? child.getNodeValue() : null;
            }
        }
        LinkedMap result = new LinkedMap();
        result.put("__tagName__", element.getTagName());
        for (Element nameElement : childElements) {
            String propertyName = nameElement.getTagName();
            List indirectChildren = XML.getElementChildren(nameElement);
            if (!nameElement.hasAttributes() && indirectChildren.isEmpty()) {
                Node text = nameElement.getFirstChild();
                if (text == null) continue;
                DataTools.putMultiple((Map)result, propertyName, text.getNodeValue());
                continue;
            }
            if (nameElement.hasAttributes()) {
                DataTools.putMultiple((Map)result, propertyName, nameElement);
                continue;
            }
            DataTools.putCombinedList((Map)result, propertyName, indirectChildren);
        }
        XML.addAttributesToMap(element, (Map)result);
        return result;
    }

    public static String getData(Element element) {
        NodeList list = element.getChildNodes();
        String output = "";
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            if (!(node instanceof CharacterData)) continue;
            output = output + ((CharacterData)node).getData();
        }
        return output;
    }

    public static String nodeType(int nodeType) {
        switch (nodeType) {
            case 2: {
                return "attribute";
            }
            case 4: {
                return "cdata";
            }
            case 8: {
                return "comment";
            }
            case 11: {
                return "document fragment";
            }
            case 9: {
                return "document";
            }
            case 10: {
                return "document type";
            }
            case 1: {
                return "element";
            }
            case 6: {
                return "entity";
            }
            case 5: {
                return "entity reference";
            }
            case 12: {
                return "notation";
            }
            case 7: {
                return "processing instruction";
            }
            case 3: {
                return "text";
            }
        }
        return "";
    }

    public static void recordToXML(String tagName, Map record, Writer out) throws Exception {
        XML.recordToXML(tagName, record, out, true, false, null);
    }

    public static void recordToXML(String tagName, Map record, Writer out, DSRequest dsRequest) throws Exception {
        XML.recordToXML(tagName, record, out, true, false, dsRequest);
    }

    public static void recordToXML(String tagName, Map record, DataSource ds, Writer out) throws Exception {
        XML.recordToXML(tagName, record, out, true, false, ds, null);
    }

    public static void recordToXML(String tagName, Map record, Writer out, boolean useAttributes, DSRequest dsRequest) throws Exception {
        XML.recordToXML(tagName, record, out, useAttributes, false, dsRequest);
    }

    public static void recordToXML(String tagName, Map record, Writer out, boolean useAttributes, boolean collapseListsToAttributes, DSRequest dsRequest) throws Exception {
        XML.recordToXML(tagName, record, out, useAttributes, collapseListsToAttributes, null, dsRequest);
    }

    public static void recordToXML(String tagName, Map record, Writer out, boolean useAttributes, boolean collapseListsToAttributes, DataSource ds, DSRequest dsRequest) throws Exception {
        if (record == null) {
            return;
        }
        Collection<Object> subElementKeys = new ArrayList();
        out.write("<" + tagName);
        if (useAttributes) {
            for (String string : record.keySet()) {
                Object value = record.get(string);
                if (collapseListsToAttributes && value instanceof List) {
                    Object o;
                    List l = (List)value;
                    if (l.size() == 0) continue;
                    if (l.size() == 1 && ((o = l.get(0)) instanceof String || o instanceof Boolean || o instanceof Number)) {
                        value = o;
                    }
                }
                if (value instanceof String || value instanceof Boolean || value instanceof Number) {
                    if (value instanceof String) {
                        value = XML.quoteXMLString((String)value, true);
                    }
                    out.write(" " + string + "=\"" + value + "\"");
                    continue;
                }
                subElementKeys.add(string);
            }
        } else {
            subElementKeys = record.keySet();
        }
        out.write(">");
        if (subElementKeys.size() > 0) {
            out.write("\n");
        }
        for (String string : subElementKeys) {
            DSField field;
            List elementValue = DataTools.makeListIfSingle(record.get(string));
            String typeName = null;
            DataSource subDs = null;
            boolean multipleMode = false;
            if (ds != null && (field = ds.getField(string)) != null) {
                typeName = field.getType();
                if (typeName != null) {
                    subDs = DataSourceManager.get(typeName, dsRequest);
                }
                if (field.getBoolean("multiple")) {
                    multipleMode = true;
                    out.write("<" + string + ">\n");
                    if (field.get("childTagName") != null) {
                        typeName = field.get("childTagName").toString();
                    }
                }
                if (field.get("fields") != null) {
                    HashMap theConfig = new HashMap();
                    theConfig.put("fields", field.get("fields"));
                    subDs = DataSource.fromConfig(theConfig, dsRequest);
                }
            }
            for (Object value : elementValue) {
                if (value instanceof String || value instanceof Boolean || value instanceof Number || value instanceof Date || value instanceof ISCDate || value instanceof ISCTime) {
                    if (value instanceof String) {
                        value = XML.quoteXMLString((String)value, false);
                    }
                    String strValue = value.toString();
                    if (value instanceof ISCDate) {
                        strValue = new SimpleDateFormat("yyyy-MM-dd").format((ISCDate)value);
                    } else if (value instanceof ISCTime) {
                        strValue = new SimpleDateFormat("HH:mm:ss").format((ISCTime)value);
                    } else if (value instanceof Date) {
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
                        strValue = sdf.format((Date)value);
                    }
                    out.write("    <" + string + ">" + strValue + "</" + string + ">\n");
                    continue;
                }
                if (!(value instanceof Map)) continue;
                if (multipleMode) {
                    XML.recordToXML(typeName, (Map)value, out, useAttributes, collapseListsToAttributes, subDs, dsRequest);
                    continue;
                }
                XML.recordToXML(string, (Map)value, out, useAttributes, collapseListsToAttributes, subDs, dsRequest);
            }
            if (!multipleMode) continue;
            out.write("</" + string + ">\n");
        }
        out.write("</" + tagName + ">\n");
    }

    public static void recordsToXML(String tagName, List records, Writer out, boolean useAttributes, DSRequest dsRequest) throws Exception {
        Iterator i = records.iterator();
        while (i.hasNext()) {
            XML.recordToXML(tagName, (Map)i.next(), out, useAttributes, dsRequest);
        }
    }

    public static String collectionsToXMLString(Object data, String rootName) throws Exception {
        if (data == null) {
            return null;
        }
        StringWriter sw = new StringWriter();
        XML.collectionsToXML(sw, data, rootName);
        return sw.toString();
    }

    public static void collectionsToXML(Writer out, Object data, String rootName) throws Exception {
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        XML.toXML(out, XML.collectionsToDOM(data, rootName), transformer);
    }

    public static Element collectionsToDOM(Object data, String rootName) throws Exception {
        DocumentBuilderFactory parserFactory = DocumentBuilderFactory.newInstance();
        parserFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = parserFactory.newDocumentBuilder();
        Document doc = documentBuilder.newDocument();
        Element docElement = doc.createElement(rootName);
        docElement.setAttribute("xmlns:xsi", "http://www.w3.org/1999/XMLSchema-instance");
        doc.appendChild(docElement);
        XML._collectionsToXML(data, doc, docElement);
        return docElement;
    }

    public static void _collectionsToXML(Object data, Document doc, Element e) throws Exception {
        if (data instanceof Map) {
            e.setAttribute("xsi:type", "xsd:Object");
            Map m = (Map)data;
            for (Object key : m.keySet()) {
                Object value = m.get(key);
                Element newElement = doc.createElement(key.toString());
                XML._collectionsToXML(value, doc, newElement);
                e.appendChild(newElement);
            }
        } else if (data instanceof Collection) {
            Collection c = (Collection)data;
            e.setAttribute("xsi:type", "xsd:List");
            for (Object obj : c) {
                Element newElement = doc.createElement("elem");
                XML._collectionsToXML(obj, doc, newElement);
                e.appendChild(newElement);
            }
        } else {
            String xmlData = null;
            if (data instanceof Calendar) {
                data = ((Calendar)data).getTime();
            }
            if (data instanceof Byte) {
                e.setAttribute("xsi:type", "xsd:byte");
            } else if (data instanceof Boolean) {
                e.setAttribute("xsi:type", "xsd:boolean");
            } else if (data instanceof Date) {
                e.setAttribute("xsi:type", "xsd:dateTime");
                xmlData = xmlDateFormat.format((Date)data);
            } else if (data instanceof BigDecimal) {
                e.setAttribute("xsi:type", "xsd:decimal");
            } else if (data instanceof Double) {
                e.setAttribute("xsi:type", "xsd:double");
            } else if (data instanceof Float) {
                e.setAttribute("xsi:type", "xsd:float");
            } else if (data instanceof Integer) {
                e.setAttribute("xsi:type", "xsd:int");
            } else if (data instanceof BigInteger) {
                e.setAttribute("xsi:type", "xsd:integer");
            } else if (data instanceof Long) {
                e.setAttribute("xsi:type", "xsd:long");
            } else if (data instanceof Short) {
                e.setAttribute("xsi:type", "xsd:short");
            } else {
                e.setAttribute("xsi:type", "xsd:string");
            }
            if (xmlData == null) {
                xmlData = data.toString();
            }
            e.appendChild(doc.createTextNode(xmlData));
        }
    }

    public static void applyXSLT(Reader xml, Reader xslt, Writer out) throws Exception {
        XML.applyXSLT(new StreamSource(xml), new StreamSource(xslt), new StreamResult(out));
    }

    public static void applyXSLT(InputStream xml, InputStream xslt, OutputStream out) throws Exception {
        XML.applyXSLT(new StreamSource(xml), new StreamSource(xslt), new StreamResult(out));
    }

    public static void applyXSLT(StreamSource xml, StreamSource xslt, StreamResult out) throws Exception {
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer t = tf.newTransformer(xslt);
        t.transform(xml, out);
    }

    public static void loadWSDL(String url, Writer out) throws Exception {
        XML.loadWSDL(url, "js", out);
    }

    public static void loadWSDL(String url, String format, Writer out) throws Exception {
        InputStream is = null;
        if (!url.startsWith("https://") && !url.startsWith("http://")) {
            if (DataTools.pathIsRelative(url)) {
                throw new Exception("loadWebService() called with non-absolute url: " + url);
            }
            is = new ISCFile(url).getInputStream();
        } else {
            ISCHttpClient httpClient = new ISCHttpClient().warnOnStatusNotOk(true);
            is = httpClient.GET(url);
            if (is == null) {
                throw new Exception("HTTP Fetch of " + url + " failed.");
            }
        }
        boolean outputXML = "xml".equals(format);
        Writer w = outputXML ? out : new StringWriter();
        XML.applyXSLT(new InputStreamReader(is), new ISCFile(config.getPath("webRoot") + "/" + config.getString("isomorphicPathRootRelative", "isomorphic") + "/system/schema/schemaTranslator.xsl").getReader(), w);
        if (!outputXML) {
            XML.toJS(new StringReader(((StringWriter)w).toString()), out).freeResources();
        }
    }

    public static void resetCounters() {
        totalParseTime = 0;
        totalDSParseTime = 0;
        DataSource.totalInstantiationTime = 0;
        ValidationContext.typeLookupTime = 0;
        DataStructCache.getInstanceFileCalls = 0;
        DataStructCache.getInstanceFileTime = 0;
        BasicDataSource.numRecords = 0;
        BasicDataSource.numFields = 0;
    }

    public static void printCounters() {
        if (log.isDebugEnabled()) {
            log.debug("******************************************************* Profiling ************");
            log.debug("XML parsing: " + totalParseTime);
            log.debug("- .ds.xml parsing: " + totalDSParseTime);
            log.debug("- other XML parsing: " + (totalParseTime - totalDSParseTime));
            log.debug("DS instantiation: " + DataSource.totalInstantiationTime);
            log.debug("getInstanceFile(): " + DataStructCache.getInstanceFileTime);
            log.debug("getInstanceFile() #calls: " + DataStructCache.getInstanceFileCalls);
            log.debug("DataSources validated " + BasicDataSource.numRecords + " records containing " + BasicDataSource.numFields + " fields");
        }
        log.debug("******************************************************* Profiling ************");
        XML.resetCounters();
    }

    public static void main(String[] args) throws Exception {
        Object result = XML.toDSRecords("datasources/AppTemplate_DS.ds.xml");
        log.warn("result: " + DataTools.prettyPrint(result));
        result = XML.toDSRecords("sampleComm.xml");
        log.warn("result: " + DataTools.prettyPrint(result));
    }

    static {
        ignoreNamespaceAttributes.add("http://www.w3.org/2000/10/XMLSchema-instance");
        totalParseTime = 0;
        totalDSParseTime = 0;
        cache = new DocumentCache();
        recordsCache = new RecordsFromXMLCache();
        defaultNamespacePrefix = config.getString("XML.defaultNamespacePrefix");
        xmlDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    }

    static class RecordsFromXMLCache
    extends ProcessedFileCache {
        RecordsFromXMLCache() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object loadObjectFromFile(ISCFile file) throws Exception {
            Object object;
            InputStream is = file.getInputStream();
            try {
                InputSource source = new InputSource(is);
                source.setSystemId(file.getCanonicalPath());
                object = XML.toDSRecords(source);
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                try {
                    is.close();
                }
                catch (Exception exception) {}
                throw throwable;
            }
            try {
                is.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return object;
        }
    }

    static class DocumentCache
    extends ProcessedFileCache {
        DocumentCache() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object loadObjectFromFile(ISCFile file) throws Exception {
            Document document;
            InputStream is = file.getInputStream();
            try {
                InputSource source = new InputSource(is);
                source.setSystemId(file.getCanonicalPath());
                document = XML.parseXML(source);
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                try {
                    is.close();
                }
                catch (Exception exception) {}
                throw throwable;
            }
            try {
                is.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return document;
        }
    }
}

