/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.html;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.Cache;
import com.gargoylesoftware.htmlunit.html.HtmlStyle;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClasses;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSSStyleSheet;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;
import java.io.Reader;
import java.io.StringReader;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import org.w3c.css.sac.InputSource;

@JsxClasses(value={@JsxClass(domClass=HtmlStyle.class, browsers={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE, minVersion=11.0f)}), @JsxClass(domClass=HtmlStyle.class, isJSObject=false, browsers={@WebBrowser(value=BrowserName.IE, maxVersion=8.0f)})})
public class HTMLStyleElement
extends HTMLElement {
    private CSSStyleSheet sheet_;

    @JsxConstructor(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF)})
    public HTMLStyleElement() {
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.IE, minVersion=11.0f)})
    public CSSStyleSheet getSheet() {
        if (this.sheet_ != null) {
            return this.sheet_;
        }
        HtmlStyle style = (HtmlStyle)this.getDomNodeOrDie();
        String css = style.getTextContent();
        Cache cache = this.getWindow().getWebWindow().getWebClient().getCache();
        org.w3c.dom.css.CSSStyleSheet cached = cache.getCachedStyleSheet(css);
        String uri = this.getDomNodeOrDie().getPage().getWebResponse().getWebRequest().getUrl().toExternalForm();
        if (cached != null) {
            this.sheet_ = new CSSStyleSheet((HTMLElement)this, cached, uri);
        } else {
            InputSource source = new InputSource((Reader)new StringReader(css));
            this.sheet_ = new CSSStyleSheet((HTMLElement)this, source, uri);
            cache.cache(css, this.sheet_.getWrappedSheet());
        }
        return this.sheet_;
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE, maxVersion=8.0f)})
    public CSSStyleSheet getStyleSheet() {
        return this.getSheet();
    }

    @JsxGetter
    public String getType() {
        HtmlStyle style = (HtmlStyle)this.getDomNodeOrDie();
        return style.getTypeAttribute();
    }

    @JsxSetter
    public void setType(String type) {
        HtmlStyle style = (HtmlStyle)this.getDomNodeOrDie();
        style.setTypeAttribute(type);
    }

    @JsxGetter
    public String getMedia() {
        HtmlStyle style = (HtmlStyle)this.getDomNodeOrDie();
        return style.getAttribute("media");
    }

    @JsxSetter
    public void setMedia(String media) {
        HtmlStyle style = (HtmlStyle)this.getDomNodeOrDie();
        style.setAttribute("media", media);
    }

    @Override
    @JsxSetter
    public void setInnerHTML(Object value) {
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_INNER_HTML_READONLY_FOR_SOME_TAGS)) {
            throw Context.reportRuntimeError((String)"innerHTML is read-only for tag 'style'");
        }
        super.setInnerHTML(value);
    }
}

