/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.datasource;

import com.isomorphic.datasource.IType;
import com.isomorphic.datasource.ValidationContext;
import com.isomorphic.js.IToJSON;
import com.isomorphic.js.JSTranslater;
import com.isomorphic.js.UnconvertableException;
import com.isomorphic.log.Logger;
import com.isomorphic.util.DataTools;
import com.isomorphic.util.DefaultValidators;
import com.isomorphic.util.ErrorReport;
import com.isomorphic.xml.XML;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.w3c.dom.Element;

public class SimpleType
implements IType,
IToJSON {
    List validators = null;
    String name = null;
    Map config = null;
    private static Logger log = new Logger(SimpleType.class.getName());

    public SimpleType(String name, Object validators) {
        this.name = name;
        this.validators = DataTools.makeListIfSingle(validators);
    }

    public SimpleType(String name, Object validators, Map config) {
        this.name = name;
        this.validators = DataTools.makeListIfSingle(validators);
        this.config = config;
    }

    public String getName() {
        return this.name;
    }

    public Object getValidators() {
        return this.validators;
    }

    public Object create(Object value, ValidationContext context) throws Exception {
        if (this.validators == null) {
            return value;
        }
        if (!(value instanceof List)) {
            return this.validateValue(value, context);
        }
        List valueList = (List)value;
        ListIterator<Object> i = valueList.listIterator();
        while (i.hasNext()) {
            i.set(this.validateValue(i.next(), context));
        }
        return valueList;
    }

    public synchronized Object validateValue(Object value, ValidationContext context) throws Exception {
        Object error;
        if (value instanceof Element) {
            context.setCurrentElement((Element)value);
            value = XML.toSimpleValue((Element)value);
        }
        String fieldName = context.getFieldName();
        Map currentRecord = context.getCurrentRecord();
        ErrorReport errors = DefaultValidators.validateField(currentRecord, fieldName, this.validators, context, null, value);
        context.setCurrentElement(null);
        if (errors != null && (error = errors.get(fieldName)) != null) {
            context.addError(error);
        }
        if (context.resultingValueIsSet()) {
            value = context.getResultingValue();
            context.clearResultingValue();
        }
        return value;
    }

    public void toJSON(Writer out, JSTranslater jsTrans) throws UnconvertableException, IOException {
        try {
            Map config = DataTools.getProperties(this);
            if (this.config != null) {
                HashMap toPrint = new HashMap(this.config);
                toPrint.put("validators", config.get("validators"));
                toPrint.remove("__cachedType");
                jsTrans.toJS(toPrint, out);
            } else {
                config.put("__autoConstruct", "SimpleType");
                jsTrans.toJS(config, out);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

