/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.scripting.java;

import com.isomorphic.scripting.java.ISCJavaCompiler;
import com.isomorphic.scripting.java.ISCJavaFileObject;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.nio.CharBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardLocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ISCMemoryJavaFileManager
extends ForwardingJavaFileManager {
    private static final String EXT = ".java";
    private Map<String, byte[]> classBytes = new HashMap<String, byte[]>();
    private ClassLoader loader;
    private ClassLoader containerClassLoader;
    private JavaFileManager stdManager;
    private ISCJavaCompiler compiler;

    public ISCMemoryJavaFileManager(ISCJavaCompiler compiler, JavaFileManager fileManager, ClassLoader loader) {
        super(fileManager);
        this.stdManager = fileManager;
        this.compiler = compiler;
        this.loader = loader;
    }

    public Iterable list(JavaFileManager.Location location, String packageName, Set kinds, boolean recurse) throws IOException {
        if (location == StandardLocation.PLATFORM_CLASS_PATH) {
            return this.stdManager.list(location, packageName, kinds, recurse);
        }
        if (location == StandardLocation.CLASS_PATH && kinds.contains((Object)JavaFileObject.Kind.CLASS)) {
            if (packageName.startsWith("java.")) {
                return this.stdManager.list(location, packageName, kinds, recurse);
            }
            return this.compiler.find(packageName);
        }
        return Collections.emptyList();
    }

    @Override
    public String inferBinaryName(JavaFileManager.Location location, JavaFileObject file) {
        if (file instanceof ISCJavaFileObject) {
            return ((ISCJavaFileObject)file).binaryName();
        }
        return this.stdManager.inferBinaryName(location, file);
    }

    public Map<String, byte[]> getClassBytes() {
        return this.classBytes;
    }

    @Override
    public void close() throws IOException {
        this.classBytes = new HashMap<String, byte[]>();
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
        if (kind == JavaFileObject.Kind.CLASS) {
            return new ClassOutputBuffer(className);
        }
        return super.getJavaFileForOutput(location, className, kind, sibling);
    }

    static JavaFileObject makeStringSource(String name, String code) {
        return new StringInputBuffer(name, code);
    }

    static URI toURI(String name) {
        File file = new File(name);
        if (file.exists()) {
            return file.toURI();
        }
        try {
            StringBuilder newUri = new StringBuilder();
            newUri.append("mfm:///");
            newUri.append(name.replace('.', '/'));
            if (name.endsWith(EXT)) {
                newUri.replace(newUri.length() - EXT.length(), newUri.length(), EXT);
            }
            return URI.create(newUri.toString());
        }
        catch (Exception exp) {
            return URI.create("mfm:///com/sun/script/java/java_source");
        }
    }

    private class ClassOutputBuffer
    extends SimpleJavaFileObject {
        private String name;

        ClassOutputBuffer(String name) {
            super(ISCMemoryJavaFileManager.toURI(name), JavaFileObject.Kind.CLASS);
            this.name = name;
        }

        public OutputStream openOutputStream() {
            return new FilterOutputStream(new ByteArrayOutputStream()){

                public void close() throws IOException {
                    this.out.close();
                    ByteArrayOutputStream bos = (ByteArrayOutputStream)this.out;
                    ISCMemoryJavaFileManager.this.classBytes.put(ClassOutputBuffer.this.name, bos.toByteArray());
                }
            };
        }
    }

    private static class StringInputBuffer
    extends SimpleJavaFileObject {
        final String code;

        StringInputBuffer(String name, String code) {
            super(ISCMemoryJavaFileManager.toURI(name), JavaFileObject.Kind.SOURCE);
            this.code = code;
        }

        public CharBuffer getCharContent(boolean ignoreEncodingErrors) {
            return CharBuffer.wrap(this.code);
        }

        public Reader openReader() {
            return new StringReader(this.code);
        }
    }
}

