/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.tools;

import com.isomorphic.base.Base;
import com.isomorphic.datasource.BasicDataSource;
import com.isomorphic.datasource.DSField;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.DataSourceManager;
import com.isomorphic.datasource.ValidationContext;
import com.isomorphic.js.JSTranslater;
import com.isomorphic.log.Logger;
import com.isomorphic.sql.SQLDataSource;
import com.isomorphic.tools.DataTranslator;
import com.isomorphic.tools.ExcelDataImport;
import com.isomorphic.tools.TranslaterException;
import com.isomorphic.util.AtomicFileWriter;
import com.isomorphic.util.DataTools;
import com.isomorphic.util.DefaultValidators;
import com.isomorphic.util.ErrorReport;
import com.isomorphic.xml.XML;
import isc.org.apache.oro.text.perl.Perl5Util;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import javax.xml.bind.DatatypeConverter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataImport
extends Base {
    private static PrintStream sysout = System.out;
    private static PrintStream syserr = System.err;
    private static String db;
    private static Logger log;
    private static PrintStream out;
    private static final int STATUS_FILE_IS_BLANK_ERROR = -1;
    private static final int STATUS_UNTERMINATED_QUOTE_ERROR = -2;
    private static final int STATUS_DELIMITER_OR_END_OF_LINE_ERROR = -3;
    private static final int STATUS_INPUT_TYPE_ERROR = -4;
    private static final int STATUS_UNDETERMINED_DELIMITER_ERROR = -5;
    private static final Map defaultTranslators;
    protected static JSTranslater jsTrans;
    protected static Perl5Util perl;
    protected ImportFormat inputType;
    protected String delimiter = null;
    protected String quoteString;
    protected Map errors;
    protected boolean crashIfTranslationFails = true;
    protected boolean populateDisplayFields = false;
    protected List<ErrorReport> listErrors;
    protected Map<String, String> columnsMatched;
    protected List<String> discardedColumns;
    protected LinkedHashMap<String, String> columnRemapTitles;
    protected LinkedHashMap<String, String> defaultImportStrategies;
    boolean keepNonRemappedColumns = false;
    public static final ImportFormat DEFAULT_INPUT;
    public static final String DEFAULT_DELIMITER = ",";
    public static final String DEFAULT_QUOTE_STRING = "\"";
    public static final String DEFAULT_TRANSLATOR = "com.isomorphic.tools.DataImport.ParseText";
    private static HashSet dataSources;
    private static String targetDir;
    private static List lastColumns;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getTranslatorFromBaseType(String type) {
        BasicDataSource ds = null;
        String translator = null;
        try {
            ds = (BasicDataSource)DataSourceManager.get((String)"Object");
            translator = ds.simpleTypeInheritsFrom(type, "datetime") ? (String)defaultTranslators.get("datetime") : (defaultTranslators.get(ds.getSimpleBaseType(type)) == null ? null : (String)defaultTranslators.get(ds.getSimpleBaseType(type)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (ds != null) {
                DataSourceManager.freeDataSource((DataSource)ds);
            }
        }
        return translator;
    }

    public void setLocale(Locale locale) {
        Locale.setDefault(locale);
    }

    public DataImport() {
        this(DEFAULT_INPUT, DEFAULT_DELIMITER, DEFAULT_QUOTE_STRING);
    }

    public DataImport(ImportFormat theInputType, String theDelimiter) {
        this(theInputType, theDelimiter, DEFAULT_QUOTE_STRING);
    }

    public DataImport(ImportFormat theInputType, String theDelimiter, String theQuoteString) {
        this.inputType = theInputType;
        this.delimiter = theDelimiter;
        this.quoteString = theQuoteString;
        this.errors = new HashMap();
    }

    public void setInputType(ImportFormat theInputType, String theDelimiter) {
        this.inputType = theInputType;
        this.delimiter = theDelimiter;
    }

    public void setQuoteString(String qs) {
        this.quoteString = qs;
    }

    public void setKeepNonRemappedColumns(boolean keep) {
        this.keepNonRemappedColumns = keep;
    }

    public Map getErrors() {
        return this.errors;
    }

    private void addError(int line, String message) {
        DataTools.putMultiple((Map)this.errors, (Object)new Integer(line), (Object)message);
    }

    public void setCrashIfTranslationFails(boolean crash) {
        this.crashIfTranslationFails = crash;
    }

    public void setPopulateDisplayFields(boolean populate) {
        this.populateDisplayFields = populate;
    }

    private ImportFormat guessFileFormat(String data) {
        ImportFormat importFormat = ImportFormat.CSV;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = dbf.newDocumentBuilder();
            builder.parse(new ByteArrayInputStream(data.getBytes()));
            importFormat = ImportFormat.XML;
        }
        catch (Exception e) {
            log.warn((Object)("File could not be parsed as XML: " + e.getMessage()));
            try {
                List list = (List)jsTrans.fromJS((InputStream)new ByteArrayInputStream(data.getBytes()));
                if (list != null) {
                    importFormat = ImportFormat.JSON;
                }
            }
            catch (Exception ex) {
                log.warn((Object)("File could not be parsed as JSON: " + ex.getMessage()));
            }
        }
        return importFormat;
    }

    public List importAndValidateDSRows(InputStream is, String dataSourceName, ImportFormat importFormat, String fileDelimiter) throws Exception {
        return this.importAndValidateDSRows(new InputStreamReader(is), dataSourceName, importFormat, fileDelimiter);
    }

    public List importAndValidateDSRows(Reader reader, String dataSourceName, ImportFormat importFormat, String fileDelimiter) throws Exception {
        return this.importAndValidateDSRows(reader, dataSourceName, importFormat, fileDelimiter, null);
    }

    public List importAndValidateDSRows(InputStream is, String dataSourceName, ImportFormat importFormat, String fileDelimiter, DSRequest dsRequest) throws Exception {
        return this.importAndValidateDSRows(new InputStreamReader(is), dataSourceName, importFormat, fileDelimiter, dsRequest);
    }

    public List importAndValidateDSRows(Reader reader, String dataSourceName, ImportFormat importFormat, String fileDelimiter, DSRequest dsRequest) throws Exception {
        DataSource ds;
        try {
            ds = DataSourceManager.getDataSource((String)dataSourceName, null);
        }
        catch (Exception e) {
            throw new Exception("Problem instantiating datasource: " + dataSourceName + "\n" + e.toString());
        }
        List rows = this.importDSRows(reader, ds, importFormat, fileDelimiter, dsRequest);
        this.validateDSRows(rows, ds, dsRequest);
        DataSourceManager.freeDataSource((DataSource)ds);
        return rows;
    }

    protected List importDSRows(Reader reader, DataSource ds, ImportFormat importFormat, String fileDelimiter, DSRequest dsRequest) throws Exception {
        this.listErrors = new ArrayList<ErrorReport>();
        this.columnsMatched = new HashMap<String, String>();
        this.discardedColumns = new ArrayList<String>();
        this.inputType = importFormat == null ? ImportFormat.AUTO : importFormat;
        this.delimiter = fileDelimiter;
        List dsColumns = ds.getFieldNames();
        LinkedHashMap<String, String> columnRemap = new LinkedHashMap<String, String>();
        for (String fieldName : dsColumns) {
            DSField field = ds.getField(fieldName);
            String uploadFieldName = field.getProperty("uploadFieldName");
            columnRemap.put(uploadFieldName != null ? uploadFieldName : fieldName, fieldName);
            this.columnsMatched.put(uploadFieldName != null ? uploadFieldName : fieldName, fieldName);
        }
        HashMap translators = new HashMap();
        for (Object column : columnRemap.keySet()) {
            Object remap = columnRemap.get(column);
            if (translators.get(column) != null) continue;
            String fieldType = ds.getField((String)remap).getType();
            String trans = this.getTranslatorFromBaseType(fieldType);
            if (trans == null) {
                log.error((Object)("Column " + remap + " had unknown column type " + fieldType));
                trans = DEFAULT_TRANSLATOR;
            }
            translators.put(column, trans);
        }
        List rows = this.importToRows(reader, columnRemap, translators, ds, dsRequest);
        if (rows == null || rows.size() <= 0) {
            log.debug((Object)"Null or empty input results");
        }
        return rows;
    }

    protected void validateDSRows(List rows, DataSource ds, DSRequest dsRequest) throws Exception {
        if (rows == null || ds == null) {
            return;
        }
        this.checkForDuplicateFieldsInRecords(rows, ds, dsRequest);
        for (int i = 0; i < rows.size(); ++i) {
            Map record;
            ErrorReport errors;
            ValidationContext context = null;
            if (dsRequest != null) {
                context = new ValidationContext();
                context.setDSRequest(dsRequest);
                context.setRequestContext(dsRequest.context);
            }
            if ((errors = ds.validate(record = (Map)rows.get(i), true, context)) != null) {
                errors.put((Object)"rowNum", (Object)i);
                this.listErrors.add(errors);
            }
            if (context == null) continue;
            context.freeResources();
        }
    }

    public List<ErrorReport> getValidationErrors() {
        return this.listErrors;
    }

    public Map<String, String> getColumnsMatched() {
        return this.columnsMatched;
    }

    public List<String> getDiscardedColumns() {
        return this.discardedColumns;
    }

    public long importToDataSource(Reader in, String dataSourceName) throws Exception {
        return this.importToDataSource(in, (Map)null, null, dataSourceName);
    }

    public long importToDataSource(Reader in, List columns, String tableName) throws Exception {
        return this.importToDataSource(in, DataTools.identityMap((List)columns), null, tableName);
    }

    public long importToDataSource(Reader in, Map columnRemap, String tableName) throws Exception {
        return this.importToDataSource(in, columnRemap, null, tableName);
    }

    public long importToDataSource(Reader in, List columns, Map translators, String tableName) throws Exception {
        return this.importToDataSource(in, DataTools.identityMap((List)columns), translators, tableName);
    }

    public long importToDataSource(Reader in, Map columnRemap, Map translators, String dataSourceName) throws Exception {
        int i;
        DataSource ds;
        this.columnsMatched = new HashMap<String, String>();
        this.discardedColumns = new ArrayList<String>();
        try {
            ds = DataSourceManager.getDataSource((String)dataSourceName, null);
        }
        catch (Exception e) {
            throw new Exception("Problem instantiating datasource: " + dataSourceName + "\n" + e.toString());
        }
        List dsColumns = ds.getFieldNames();
        this.columnRemapTitles = new LinkedHashMap();
        for (i = 0; i < dsColumns.size(); ++i) {
            String fieldName = (String)dsColumns.get(i);
            if (columnRemap != null && columnRemap.containsValue(fieldName) || ds.getFieldTitle(fieldName) == null) continue;
            this.columnRemapTitles.put(ds.getFieldTitle(fieldName), fieldName);
        }
        if (columnRemap == null) {
            columnRemap = new LinkedHashMap<String, String>();
        } else {
            LinkedHashMap strippedRemap = new LinkedHashMap();
            for (Object key : columnRemap.keySet()) {
                Object value = columnRemap.get(key);
                if (dsColumns.contains(value)) {
                    strippedRemap.put(key, value);
                    continue;
                }
                this.discardedColumns.add((String)key);
            }
            columnRemap = strippedRemap;
        }
        for (i = 0; i < dsColumns.size(); ++i) {
            String column = (String)dsColumns.get(i);
            if (columnRemap.containsKey(column)) continue;
            columnRemap.put(column, column);
        }
        this.columnsMatched = columnRemap;
        if (translators == null) {
            translators = new HashMap<String, String>();
        }
        for (String column : columnRemap.keySet()) {
            Object remap = columnRemap.get(column);
            if (translators.get(column) != null) continue;
            String fieldType = ds.getField((String)remap).getType();
            String trans = this.getTranslatorFromBaseType(fieldType);
            if (trans == null) {
                log.error((Object)("Column " + remap + " had unknown column type " + fieldType));
                trans = DEFAULT_TRANSLATOR;
            }
            translators.put(column, trans);
        }
        List rows = this.importToRows(in, columnRemap, translators);
        if (rows == null || rows.size() <= 0) {
            log.debug((Object)"Null or empty input results");
            return 0L;
        }
        long result = 0L;
        if (ds instanceof SQLDataSource) {
            result = ds.insert((Object)rows);
        } else {
            DSRequest dsRequest = new DSRequest(dataSourceName, "add");
            dsRequest.forceInvalidateCache();
            dsRequest.setValues((Object)rows);
            DSResponse dsResponse = dsRequest.execute();
            result = dsResponse.getRowCount();
        }
        DataSourceManager.freeDataSource((DataSource)ds);
        return result;
    }

    private void checkForDuplicateFieldsInRecords(List rows, DataSource ds, DSRequest dsRequest) {
        for (DSField field : ds.getFields()) {
            List validators = field.getValidators();
            if (validators == null) continue;
            for (Map validator : validators) {
                if (!"isUnique".equals(validator.get("type"))) continue;
                String criteriaFields = (String)validator.get("criteriaFields");
                String fieldName = field.getName();
                ArrayList<String> uniqueFields = new ArrayList<String>();
                uniqueFields.add(fieldName);
                if (criteriaFields != null) {
                    uniqueFields.addAll(Arrays.asList(criteriaFields.split(DEFAULT_DELIMITER)));
                }
                HashMap seenMap = new HashMap();
                HashMap duplicateValue = new HashMap();
                String errorMessage = null;
                if (uniqueFields == null) continue;
                for (int i = 0; i < rows.size(); ++i) {
                    Map record = (Map)rows.get(i);
                    duplicateValue = new HashMap();
                    for (int e = 0; e < uniqueFields.size(); ++e) {
                        String primaryKey = (String)uniqueFields.get(e);
                        Object value = record.get(primaryKey);
                        if (value == null || value.toString().trim().length() == 0) continue;
                        duplicateValue.put(primaryKey, record.get(primaryKey));
                    }
                    Integer _row = (Integer)seenMap.get(duplicateValue);
                    if (_row != null) {
                        ErrorReport report;
                        if (errorMessage == null) {
                            Object errorMessageObj = validator.get("errorMessage");
                            errorMessage = DefaultValidators.getErrorString(errorMessageObj, (String)"Value must be unique", (DSRequest)dsRequest);
                        }
                        if (_row != -1) {
                            report = new ErrorReport();
                            report.addError(fieldName, errorMessage);
                            report.put((Object)"rowNum", (Object)_row);
                            this.listErrors.add(report);
                            seenMap.put(duplicateValue, -1);
                        }
                        report = new ErrorReport();
                        report.addError(fieldName, errorMessage);
                        report.put((Object)"rowNum", (Object)i);
                        this.listErrors.add(report);
                        continue;
                    }
                    if (duplicateValue.isEmpty()) continue;
                    seenMap.put(duplicateValue, i);
                }
            }
        }
    }

    public List importDataSourceRecords(Reader in, String dataSourceName) throws Exception {
        return this.importDataSourceRecords(in, (Map)null, null, dataSourceName);
    }

    public List importDataSourceRecords(Reader in, List columns, String dataSourceName) throws Exception {
        return this.importDataSourceRecords(in, DataTools.identityMap((List)columns), null, dataSourceName);
    }

    public List importDataSourceRecords(Reader in, Map columnRemap, String dataSourceName) throws Exception {
        return this.importDataSourceRecords(in, columnRemap, null, dataSourceName);
    }

    public List importDataSourceRecords(Reader in, List columns, Map translators, String dataSourceName) throws Exception {
        return this.importDataSourceRecords(in, DataTools.identityMap((List)columns), translators, dataSourceName);
    }

    public List importDataSourceRecords(Reader in, Map columnRemap, Map translators, String dataSourceName) throws Exception {
        int i;
        DataSource ds;
        this.columnsMatched = new HashMap<String, String>();
        this.discardedColumns = new ArrayList<String>();
        try {
            ds = DataSourceManager.getDataSource((String)dataSourceName, null);
        }
        catch (Exception e) {
            throw new Exception("Problem instantiating datasource: " + dataSourceName + "\n" + e.toString());
        }
        List dsColumns = ds.getFieldNames();
        this.columnRemapTitles = new LinkedHashMap();
        for (i = 0; i < dsColumns.size(); ++i) {
            String fieldName = (String)dsColumns.get(i);
            if (columnRemap != null && columnRemap.containsValue(fieldName) || ds.getFieldTitle(fieldName) == null) continue;
            this.columnRemapTitles.put(ds.getFieldTitle(fieldName), fieldName);
        }
        if (columnRemap == null) {
            columnRemap = new LinkedHashMap<String, String>();
        } else {
            HashMap strippedRemap = new HashMap();
            for (Object key : columnRemap.keySet()) {
                Object value = columnRemap.get(key);
                if (dsColumns.contains(value)) {
                    strippedRemap.put(key, value);
                    continue;
                }
                this.discardedColumns.add((String)key);
            }
            columnRemap = strippedRemap;
        }
        for (i = 0; i < dsColumns.size(); ++i) {
            String column = (String)dsColumns.get(i);
            if (columnRemap.containsKey(column)) continue;
            columnRemap.put(column, column);
        }
        this.columnsMatched = columnRemap;
        if (translators == null) {
            translators = new HashMap<String, String>();
        }
        for (String column : columnRemap.keySet()) {
            Object remap = columnRemap.get(column);
            if (translators.get(column) != null) continue;
            String fieldType = ds.getField((String)remap).getType();
            String trans = this.getTranslatorFromBaseType(fieldType);
            if (trans == null) {
                log.error((Object)("Column " + remap + " had unknown column type " + fieldType));
                trans = DEFAULT_TRANSLATOR;
            }
            translators.put(column, trans);
        }
        List rows = this.importToRows(in, columnRemap, translators, ds);
        if (rows == null || rows.size() <= 0) {
            log.debug((Object)"Null or empty input results");
        }
        DataSourceManager.freeDataSource((DataSource)ds);
        return rows;
    }

    public List importToRows(Reader in) throws Exception {
        return this.importToRows(in, (Map)null, null);
    }

    public List importToRows(Reader in, List columns) throws Exception {
        return this.importToRows(in, DataTools.identityMap((List)columns), null);
    }

    public List importToRows(Reader in, Map columnRemap) throws Exception {
        return this.importToRows(in, columnRemap, null);
    }

    public List importToRows(Reader in, List columns, Map translators) throws Exception {
        return this.importToRows(in, DataTools.identityMap((List)columns), translators);
    }

    public List importToRows(Reader in, Map columnRemap, Map translators) throws Exception {
        return this.importToRows(in, columnRemap, translators, null);
    }

    public List importToRows(Reader in, Map columnRemap, Map translators, DataSource ds) throws Exception {
        return this.importToRows(in, columnRemap, translators, ds, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List importToRows(Reader in, Map columnRemap, Map translators, DataSource dataSource, DSRequest dsRequest) throws Exception {
        LineNumberReader input = new LineNumberReader(in);
        String line = null;
        String headerLine = null;
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        while ((line = input.readLine()) != null) {
            pw.println(line);
        }
        if (sw.toString().trim().length() <= 0) {
            throw new Exception("Provided file is blank:ErrorCode:-1");
        }
        StringReader reader = new StringReader(sw.toString());
        input = new LineNumberReader(reader);
        List rows = null;
        boolean existRows = false;
        if (translators == null) {
            translators = new HashMap();
        }
        this.defaultImportStrategies = new LinkedHashMap();
        if (ImportFormat.AUTO.equals((Object)this.inputType)) {
            this.inputType = this.guessFileFormat(sw.toString());
            this.delimiter = null;
        }
        if (ImportFormat.CSV.equals((Object)this.inputType)) {
            if (this.delimiter == null) {
                int count = 0;
                String auxDelimiter = DEFAULT_DELIMITER;
                int totalColumns = 0;
                while ((line = input.readLine()) != null) {
                    String[] arrayDelimiter = null;
                    if (count == 0) {
                        if (line.contains("\t")) {
                            auxDelimiter = "\t";
                        }
                        if (line.endsWith(auxDelimiter)) {
                            line = line + " ";
                        }
                        arrayDelimiter = line.split(auxDelimiter);
                        totalColumns = arrayDelimiter.length;
                    } else {
                        if (line.endsWith(auxDelimiter)) {
                            line = line + " ";
                        }
                        if ((arrayDelimiter = line.split(auxDelimiter)).length != totalColumns) {
                            throw new Exception("We were unable to guess the delimiter:ErrorCode:-5");
                        }
                    }
                    if (++count != 3) continue;
                    break;
                }
                reader = new StringReader(sw.toString());
                input = new LineNumberReader(reader);
                this.delimiter = auxDelimiter;
            }
            rows = new ArrayList();
            ArrayList columns = null;
            do {
                if ((columns = this.splitRow(headerLine = input.readLine(), input)).isEmpty()) {
                    log.debug((Object)("Empty line: " + input.getLineNumber()));
                    continue;
                }
                columns = this.trimTrailingEmptyColumns(columns);
            } while (columns.isEmpty());
            LinkedHashMap<String, String> linkedColumnRemap = new LinkedHashMap<String, String>();
            LinkedHashMap<Integer, String> linkedDiscardedColumn = new LinkedHashMap<Integer, String>();
            if (columnRemap != null) {
                Set set = columnRemap.keySet();
                for (String key : set) {
                    String value = (String)columnRemap.get(key);
                    linkedColumnRemap.put(key, value);
                    if (columnRemap.containsKey(key = key.toLowerCase())) continue;
                    linkedColumnRemap.put(key, value);
                }
                ArrayList columnsCopy = new ArrayList();
                for (int i = 0; i < columns.size(); ++i) {
                    String column = (String)columns.get(i);
                    boolean exist = false;
                    if (this.columnRemapTitles != null && this.columnRemapTitles.size() != 0) {
                        String columnTitle2 = "";
                        for (String columnTitle2 : this.columnRemapTitles.keySet()) {
                            if (!columnTitle2.equalsIgnoreCase(column)) continue;
                            exist = true;
                            break;
                        }
                        if (exist) {
                            columnsCopy.add(columnTitle2);
                            columnRemap.put(columnTitle2, this.columnRemapTitles.get(columnTitle2));
                        }
                    }
                    if (!exist) {
                        String columnName2 = "";
                        for (String columnName2 : linkedColumnRemap.keySet()) {
                            if (!columnName2.equalsIgnoreCase(column)) continue;
                            exist = true;
                            break;
                        }
                        if (exist) {
                            columnsCopy.add(columnName2);
                        }
                    }
                    if (!exist) {
                        boolean discardedColumn = false;
                        if (this.discardedColumns.size() == 0) {
                            this.discardedColumns.add(column);
                        } else {
                            for (int x = 0; x < this.discardedColumns.size(); ++x) {
                                if (!this.discardedColumns.get(x).equals(column)) continue;
                                discardedColumn = true;
                            }
                            if (!discardedColumn) {
                                this.discardedColumns.add(column);
                            }
                        }
                        linkedDiscardedColumn.put(i, column);
                        continue;
                    }
                    linkedDiscardedColumn.put(i, null);
                }
                columns = columnsCopy;
            }
            boolean existHeader = true;
            if (columns.size() == 0) {
                Iterator e = linkedColumnRemap.keySet().iterator();
                while (e.hasNext()) {
                    columns.add(e.next());
                }
                existHeader = false;
                this.discardedColumns.clear();
                linkedDiscardedColumn.clear();
            }
            lastColumns = columns;
            while ((line = input.readLine()) != null) {
                try {
                    if (line.trim().equals("")) continue;
                    int repeat = 1;
                    if (!existHeader) {
                        repeat = 2;
                    }
                    for (int j = 0; j < repeat; ++j) {
                        List data = null;
                        if (!existHeader) {
                            data = this.splitRow(headerLine, input);
                            existHeader = true;
                        } else {
                            data = this.splitRow(line, input);
                        }
                        data = this.trimTrailingEmptyColumns(data);
                        if (data.size() > columns.size()) {
                            int lineNum = input.getLineNumber();
                            log.warn((Object)("Extra columns at line " + lineNum + " (expected " + columns.size() + ", got " + data.size() + "), ignoring extra column values"));
                        }
                        HashMap<String, Object> row = new HashMap<String, Object>();
                        int count = -1;
                        for (int i = 0; i < data.size(); ++i) {
                            int lineNum;
                            Object field;
                            DSField dsField;
                            if (linkedDiscardedColumn.get(i) != null) continue;
                            String column = (String)columns.get(++count);
                            Object rawValue = data.get(i);
                            DSField dSField = dsField = dataSource != null ? dataSource.getField(column) : null;
                            if (rawValue == null || rawValue.equals("")) continue;
                            if (dataSource != null) {
                                Object transformed = this.transformFieldValue(dataSource, (String)linkedColumnRemap.get(column), rawValue, dsRequest);
                                DataSource.DisplayFieldProperties props = null;
                                if (this.populateDisplayFields) {
                                    props = dataSource.getIncludedDisplayFieldProperties((String)linkedColumnRemap.get(column));
                                }
                                if (props != null) {
                                    if (!rawValue.equals(transformed)) {
                                        row.put(props.displayFieldName, rawValue);
                                        row.put(column, transformed);
                                        continue;
                                    }
                                } else {
                                    rawValue = transformed == null || rawValue.equals(transformed) ? rawValue : transformed;
                                }
                            }
                            String rawValueString = rawValue.toString();
                            try {
                                field = this.translate((String)translators.get(column), rawValueString);
                            }
                            catch (ParseException e) {
                                lineNum = input.getLineNumber();
                                log.error((Object)("Malformed line " + lineNum + ": " + e.toString()));
                                this.addError(lineNum, e.toString());
                                field = rawValue;
                            }
                            catch (TranslaterException e) {
                                lineNum = input.getLineNumber();
                                log.error((Object)("Translation error at line " + input.getLineNumber() + ": " + e.toString()));
                                field = rawValue;
                            }
                            catch (Exception e) {
                                if (this.crashIfTranslationFails) {
                                    throw e;
                                }
                                log.warn((Object)"Error during translation", (Throwable)e);
                                field = rawValue;
                            }
                            row.put(column, field);
                        }
                        rows.add(row);
                    }
                }
                catch (ParseException e) {
                    int lineNum = input.getLineNumber();
                    log.error((Object)("Malformed line " + lineNum + ": " + e.toString()));
                    this.addError(lineNum, e.toString());
                }
                catch (TranslaterException e) {
                    int lineNum = input.getLineNumber();
                    log.error((Object)("Translation error at line " + input.getLineNumber() + ": " + e.toString()));
                }
                catch (IndexOutOfBoundsException e) {
                    int lineNum = input.getLineNumber();
                    log.error((Object)("Parse error at line " + input.getLineNumber() + ". An index is out of range : " + e.toString()));
                    this.addError(lineNum, e.toString());
                }
            }
            input.close();
        } else if (ImportFormat.JS_LITERAL.equals((Object)this.inputType) || ImportFormat.JSON.equals((Object)this.inputType)) {
            input.close();
            try {
                rows = (List)jsTrans.fromJS(sw.toString());
                existRows = true;
            }
            catch (Exception e) {
                log.error((Object)("File could not be parsed as JSON: " + e.getMessage()));
            }
        } else if (ImportFormat.XML.equals((Object)this.inputType)) {
            input.close();
            BasicDataSource ds = null;
            try {
                ds = (BasicDataSource)DataSourceManager.get((String)"Object");
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                dbf.setNamespaceAware(true);
                DocumentBuilder builder = dbf.newDocumentBuilder();
                Document doc = builder.parse(new ByteArrayInputStream(sw.toString().getBytes()));
                doc.normalize();
                Object objects = ds.toRecords((Object)doc.getDocumentElement());
                if (objects instanceof List) {
                    rows = (List)objects;
                } else {
                    Map record = (Map)objects;
                    Set set = record.keySet();
                    Iterator iterator = set.iterator();
                    if (iterator.hasNext()) {
                        String column = (String)iterator.next();
                        rows = (List)record.get(column);
                    }
                }
                existRows = true;
            }
            catch (Exception e) {
                log.error((Object)("File could not be parsed as XML: " + e.getMessage()));
            }
            finally {
                if (ds != null) {
                    DataSourceManager.freeDataSource((DataSource)ds);
                }
            }
        } else {
            throw new Exception("Invalid inputType value was set!:ErrorCode:-4");
        }
        if (existRows) {
            ArrayList rowsAux = new ArrayList();
            if (translators.size() != 0 || dataSource != null) {
                for (int i = 0; i < rows.size(); ++i) {
                    Map record = (Map)rows.get(i);
                    LinkedHashMap<String, Object> updatedRecord = new LinkedHashMap<String, Object>();
                    Iterator j = record.keySet().iterator();
                    while (j.hasNext()) {
                        String column;
                        String columnNameOrig = column = (String)j.next();
                        boolean columnFound = false;
                        if (columnRemap != null) {
                            for (String columnName : columnRemap.keySet()) {
                                if (!columnName.equalsIgnoreCase(column)) continue;
                                column = (String)columnRemap.get(columnName);
                                columnFound = true;
                            }
                        }
                        if (!columnFound && this.columnRemapTitles != null) {
                            for (String columnTitle : this.columnRemapTitles.keySet()) {
                                if (!columnTitle.equalsIgnoreCase(column)) continue;
                                column = this.columnRemapTitles.get(columnTitle);
                            }
                        }
                        Object value = null;
                        if (dataSource != null) {
                            Object rawValue = record.get(columnNameOrig);
                            value = this.transformFieldValue(dataSource, column, rawValue, dsRequest);
                            DataSource.DisplayFieldProperties props = null;
                            if (this.populateDisplayFields) {
                                props = dataSource.getIncludedDisplayFieldProperties(columnRemap != null ? (String)columnRemap.get(column) : column);
                            }
                            if (props != null) {
                                if (!rawValue.equals(value)) {
                                    updatedRecord.put(props.displayFieldName, rawValue);
                                    updatedRecord.put(column, value);
                                }
                            } else {
                                Object object = value = value == null || rawValue.equals(value) ? rawValue : value;
                            }
                        }
                        if (translators.get(column) != null) {
                            String valueString = value == null ? (String)record.get(columnNameOrig) : value.toString();
                            value = this.translate((String)translators.get(column), valueString);
                        }
                        if (value == null) continue;
                        updatedRecord.put(column, value);
                    }
                    rowsAux.add(updatedRecord);
                }
                rows = rowsAux;
            }
        }
        if (rows != null && columnRemap != null) {
            rows = DataTools.remapRows(rows, (Map)columnRemap, (boolean)this.keepNonRemappedColumns);
        }
        return rows;
    }

    public List importToRows(InputStream in, Map columnRemap, Map translators) throws Exception {
        if (!ImportFormat.EXCEL.equals((Object)this.inputType)) {
            return this.importToRows((Reader)new InputStreamReader(in), columnRemap, translators);
        }
        List rows = ExcelDataImport.importExcelStream(in, null, columnRemap, 0, 0, 9999, true);
        if (rows != null && columnRemap != null) {
            rows = DataTools.remapRows((List)rows, (Map)columnRemap, (boolean)this.keepNonRemappedColumns);
        }
        return rows;
    }

    private Object translate(String translator, String field) throws Exception {
        DataTranslator pt;
        if (translator == null) {
            translator = DEFAULT_TRANSLATOR;
        }
        DataImport di = new DataImport();
        Object obj = null;
        if ("com.isomorphic.tools.DataImport.ParseDate".equals(translator)) {
            ParseDate pd = di.new ParseDate();
            obj = pd.translate(field);
        }
        if ("com.isomorphic.tools.DataImport.ParseDateTime".equals(translator)) {
            ParseDateTime pdt = di.new ParseDateTime();
            obj = pdt.translate(field);
        }
        if ("com.isomorphic.tools.DataImport.ParseTime".equals(translator)) {
            pt = di.new ParseTime();
            obj = ((ParseTime)pt).translate(field);
        }
        if (DEFAULT_TRANSLATOR.equals(translator)) {
            pt = di.new ParseText();
            obj = ((ParseText)pt).translate(field);
        }
        if ("com.isomorphic.tools.DataImport.ParseNumber".equals(translator)) {
            ParseNumber pn = di.new ParseNumber();
            obj = pn.translate(field);
        }
        if ("com.isomorphic.tools.DataImport.ParseFloat".equals(translator)) {
            ParseFloat pf = di.new ParseFloat();
            obj = pf.translate(field);
        }
        return obj;
    }

    private List splitRow(String line, LineNumberReader input) throws ParseException, IOException {
        if (line == null || line.trim().length() == 0) {
            return new ArrayList();
        }
        if (this.quoteString == null || this.quoteString.equals("")) {
            ArrayList results = new ArrayList();
            perl.split(results, "/" + this.delimiter + "/", line);
            return results;
        }
        ArrayList<String> results = new ArrayList<String>();
        String element = null;
        String newLine = System.getProperty("line.separator");
        int offset = 0;
        int lineLength = line.length();
        int delimiterLength = this.delimiter.length();
        int qsLength = this.quoteString.length();
        while (offset <= lineLength) {
            int next;
            if (line.startsWith(this.quoteString, offset)) {
                element = "";
                offset += qsLength;
                while (true) {
                    next = line.indexOf(this.quoteString, offset);
                    int delimiterPos = line.indexOf(this.delimiter, offset);
                    while (next < 0) {
                        String anotherLine = input.readLine();
                        String emptyLines = "";
                        while (anotherLine == null || anotherLine.trim().length() == 0) {
                            if (anotherLine == null) {
                                return results;
                            }
                            anotherLine = input.readLine();
                            emptyLines = emptyLines + newLine;
                        }
                        element = element + line.substring(offset, lineLength);
                        element = element + emptyLines + newLine;
                        line = line + anotherLine;
                        offset = lineLength;
                        lineLength = line.length();
                        next = line.indexOf(this.quoteString, offset);
                    }
                    element = element + line.substring(offset, next);
                    offset = next + qsLength;
                    if (!line.startsWith(this.quoteString, offset)) break;
                    element = element + this.quoteString;
                    offset += qsLength;
                }
                if (offset != lineLength && !line.startsWith(this.delimiter, offset)) {
                    throw new ParseException("Delimiter or end of line expected after quoted value:ErrorCode:-3", offset);
                }
                offset += delimiterLength;
            } else {
                next = line.indexOf(this.delimiter, offset);
                if (next == -1) {
                    next = lineLength;
                }
                element = line.substring(offset, next);
                offset = next + delimiterLength;
            }
            results.add(element);
        }
        return results;
    }

    private List trimTrailingEmptyColumns(List values) {
        if (values == null || values.isEmpty()) {
            return values;
        }
        while ("".equals(values.get(values.size() - 1))) {
            values.remove(values.size() - 1);
        }
        return values;
    }

    protected Object transformFieldValue(DataSource dataSource, String fieldName, Object rawValue, DSRequest dsRequest) throws Exception {
        Object transformed;
        if (!this.defaultImportStrategies.containsKey(fieldName)) {
            String importStrategy;
            DSField field = dataSource.getField(fieldName);
            String string = importStrategy = field == null ? null : (String)field.get((Object)"importStrategy");
            if (importStrategy == null || importStrategy.equals("auto")) {
                this.defaultImportStrategies.put(fieldName, dataSource.getRelatedDisplayRecord(fieldName, rawValue, dsRequest) == null ? "key" : "display");
            } else {
                this.defaultImportStrategies.put(fieldName, importStrategy);
            }
        }
        if ((transformed = dataSource.transformImportValue(fieldName, rawValue, this.defaultImportStrategies.get(fieldName), dsRequest)) == null) {
            return null;
        }
        if (transformed != rawValue) {
            return transformed;
        }
        return rawValue;
    }

    public static Object parseText(String field) throws TranslaterException {
        return field;
    }

    public static Object parseNumber(String field) throws TranslaterException {
        try {
            return new BigInteger(field);
        }
        catch (NumberFormatException e) {
            throw new TranslaterException(e.toString());
        }
    }

    public static Object parseFloat(String field) throws TranslaterException {
        try {
            return new BigDecimal(field);
        }
        catch (NumberFormatException e) {
            throw new TranslaterException(e.toString());
        }
    }

    public static Object parseDate(String field) throws TranslaterException {
        DateFormat df = DateFormat.getDateInstance();
        df.setLenient(true);
        try {
            return df.parse(field);
        }
        catch (ParseException e) {
            throw new TranslaterException(e.toString());
        }
    }

    public static Object parseDateTime(String field) throws TranslaterException {
        DateFormat df = DateFormat.getDateTimeInstance();
        df.setLenient(true);
        try {
            return df.parse(field);
        }
        catch (ParseException e) {
            throw new TranslaterException(e.toString());
        }
    }

    public static void processDataImportRequest(String fileName, Reader in, Writer out, boolean genDS, boolean jsInput, boolean jsOutput, boolean xmlOutput, String theDelimiter, String datasource, Object columns, Object translators) throws Exception {
        File file;
        int dotIndex;
        if (!fileName.equals("default") && (dotIndex = (fileName = (file = new File(fileName)).getName()).indexOf(".")) != -1) {
            fileName = fileName.substring(0, dotIndex);
        }
        DataImport di = jsInput ? new DataImport(ImportFormat.JS_LITERAL, null) : (theDelimiter != null ? new DataImport(ImportFormat.CSV, theDelimiter) : new DataImport());
        if (datasource != null) {
            long results;
            if (columns == null || columns instanceof Map) {
                results = di.importToDataSource(in, (Map)columns, (Map)translators, datasource);
            } else if (columns instanceof List) {
                results = di.importToDataSource(in, (List)columns, (Map)translators, datasource);
            } else {
                throw new Exception("columns must be a List or a Map");
            }
            out.write(String.valueOf(results) + " row(s) inserted\n");
            out.flush();
        } else {
            List results;
            if (columns == null || columns instanceof Map) {
                results = di.importToRows(in, (Map)columns, (Map)translators);
            } else if (columns instanceof List) {
                results = di.importToRows(in, (List)columns, (Map)translators);
            } else {
                throw new Exception("columns must be a List or a Map");
            }
            String output = "";
            if (jsOutput) {
                output = jsTrans.toJS((Object)results);
            } else if (xmlOutput) {
                File dataFile = new File(fileName + ".data.xml");
                if (dataFile.exists()) {
                    dataFile.delete();
                }
                FileWriter data = new FileWriter(dataFile);
                data.write("<records>\n");
                for (Map record : results) {
                    XML.recordToXML((String)"record", (Map)record, (Writer)data, (boolean)false, null);
                }
                data.write("</records>\n");
                data.flush();
            } else {
                output = results.toString();
            }
            out.write(output + "\n");
            out.flush();
            if (genDS) {
                HashMap c = new HashMap();
                for (String name : lastColumns) {
                    c.put(name, new HashMap());
                }
                DataImport.createDataSource(fileName, c, null);
            }
        }
    }

    public static void createDataSource(String dsName, Map columns, String relation) throws Exception {
        log.info((Object)("Creating datasource: " + dsName));
        String dsFileName = targetDir + dsName + ".ds.xml";
        AtomicFileWriter dsWriter = new AtomicFileWriter(dsFileName);
        dsWriter.write("<DataSource ID=\"" + dsName + "\" tableName=\"" + dsName + "\">\n");
        dsWriter.write("\t<fields>\n");
        if (relation != null) {
            dsWriter.write("\t\t<field name=\"parentId\" type=\"integer\" foreignKey=\"" + relation + ".id\" hidden=\"true\"/>\n");
        }
        for (String name : columns.keySet()) {
            Map field = (Map)columns.get(name);
            String title = (String)field.get("label");
            if (title == null) {
                title = name;
            }
            boolean canEdit = true;
            String type = (String)field.get("type");
            if (type == null) {
                type = "text";
            }
            if (type.equals("ro")) {
                canEdit = false;
            }
            type = type.equals("d") ? "date" : (type.equals("num") ? "integer" : (type.equals("curr") ? "float" : "text"));
            String length = (String)field.get("w");
            dsWriter.write("\t\t<field");
            dsWriter.write(" name=\"" + name + DEFAULT_QUOTE_STRING);
            dsWriter.write(" title=\"" + title + DEFAULT_QUOTE_STRING);
            dsWriter.write(" type=\"" + type + DEFAULT_QUOTE_STRING);
            if (DataSource.simpleTypeInheritsFromBuiltInType((String)type, (String)"text") && length != null) {
                dsWriter.write(" length=\"" + length + DEFAULT_QUOTE_STRING);
            }
            if (!canEdit) {
                dsWriter.write(" canEdit=\"false\"");
            }
            dsWriter.write("/>\n");
        }
        dsWriter.write("\t</fields>\n");
        dsWriter.write("</DataSource>\n");
        dsWriter.flush();
        dsWriter.close();
        dataSources.add(dsName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        DefaultParser parser = new DefaultParser();
        String cmdLineSyntax = "dataImport [options] [input files]";
        Options options = new Options();
        options.addOption("h", "help", false, "Display this help message");
        options.addOption("j", "jsInput", false, "Specifies that the input format is a Javascript literal.  (Default format is comma-separated values).  Ignored for imports to datasource or table.");
        options.addOption("J", "jsOutput", false, "Set the output format to Javascript literal.  (Default format is comma-separated values).  Ignored for imports to datasource or table.");
        options.addOption("X", "xmlOutput", false, "Set the output format to XML.  (Default format is comma-separated values).  Ignored for imports to datasource or table.");
        options.addOption("g", "generateDataSource", false, "Generate a datasource (in xml format).");
        OptionBuilder.withLongOpt((String)"datasource");
        OptionBuilder.withDescription((String)"Input data into the table associated with this datasource.");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"datasourceName");
        OptionBuilder.withValueSeparator((char)' ');
        options.addOption(OptionBuilder.create((char)'d'));
        OptionBuilder.withLongOpt((String)"table");
        OptionBuilder.withDescription((String)"Input data into this table. NOT IMPLEMENTED YET!");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"tableName");
        OptionBuilder.withValueSeparator((char)' ');
        options.addOption(OptionBuilder.create((char)'t'));
        OptionBuilder.withLongOpt((String)"columns");
        OptionBuilder.withDescription((String)"Specify the fields to be imported, as a Javascript literal.  Provide either a list of the field names or a map of the input field names to the database field names");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"columns");
        OptionBuilder.withValueSeparator((char)' ');
        options.addOption(OptionBuilder.create((char)'c'));
        OptionBuilder.withLongOpt((String)"delimiter");
        OptionBuilder.withDescription((String)"Set the delimiter. (Default delimiter is a comma - the ',' character)");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"delimiter");
        OptionBuilder.withValueSeparator((char)' ');
        options.addOption(OptionBuilder.create((char)'l'));
        OptionBuilder.withLongOpt((String)"translators");
        OptionBuilder.withDescription((String)"Specify the translators as a Javascript literal map. Set the property name to the data type (as specified in the datasource) and the value to the fully-qualified Java method to be used as the translator. If only the method name is specified, then it's assumed it's a method of the com.isomorphic.tools.DataImport class");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"translators");
        OptionBuilder.withValueSeparator((char)' ');
        options.addOption(OptionBuilder.create((char)'r'));
        if (args.length == 0) {
            DataImport.outputHelp(cmdLineSyntax, options);
            System.exit(0);
        }
        String theDelimiter = null;
        String source = null;
        Object columns = null;
        Object translators = null;
        boolean jsInput = false;
        boolean jsOutput = false;
        boolean xmlOutput = false;
        boolean genDS = false;
        CommandLine line = null;
        try {
            line = parser.parse(options, args);
            if (line.hasOption("c")) {
                columns = jsTrans.fromJS(line.getOptionValue("c"));
            }
            if (line.hasOption("d")) {
                source = line.getOptionValue("d");
            }
            if (line.hasOption("j")) {
                jsInput = true;
            }
            if (line.hasOption("J")) {
                jsOutput = true;
            }
            if (line.hasOption("X")) {
                xmlOutput = true;
            }
            if (line.hasOption("g")) {
                genDS = true;
            }
            if (line.hasOption("l")) {
                theDelimiter = line.getOptionValue("l");
            }
            if (line.hasOption("r")) {
                translators = jsTrans.fromJS(line.getOptionValue("r"));
            }
            if (line.hasOption("t")) {
                syserr.println("The import to table option is not supported yet.");
                System.exit(1);
            }
            if (line.hasOption("h")) {
                DataImport.outputHelp(cmdLineSyntax, options);
                System.exit(0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        OutputStreamWriter out = new OutputStreamWriter(sysout);
        boolean inputFromFile = false;
        List fileList = line.getArgList();
        Iterator i = fileList.iterator();
        while (i.hasNext()) {
            inputFromFile = true;
            String fileName = (String)i.next();
            try {
                FileReader in = new FileReader(fileName);
                DataImport.processDataImportRequest(fileName, in, out, genDS, jsInput, jsOutput, xmlOutput, theDelimiter, source, columns, translators);
                in.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!inputFromFile) {
            InputStreamReader in = null;
            try {
                in = new InputStreamReader(System.in);
                DataImport.processDataImportRequest("default", in, out, genDS, jsInput, jsOutput, xmlOutput, theDelimiter, source, columns, translators);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        System.exit(0);
    }

    public static void outputHelp(String cmdLineSyntax, Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(cmdLineSyntax, "", options, "\nNotes:\nIf an input file name is not specified, input comes from stdin. Output goes to stdout if neither a datasource nor a table are specified. If no columns are specified, all columns will be imported.");
    }

    static {
        log = new Logger(DataImport.class.getName());
        out = System.out;
        defaultTranslators = new HashMap();
        jsTrans = new JSTranslater();
        perl = new Perl5Util();
        DEFAULT_INPUT = ImportFormat.CSV;
        dataSources = new HashSet();
        targetDir = "";
        db = config.getString((Object)"sql.defaultDatabase");
        if (db == null) {
            log.error((Object)"sql.defaultDatabase not defined in config file!");
        }
        defaultTranslators.put("date", "com.isomorphic.tools.DataImport.ParseDate");
        defaultTranslators.put("datetime", "com.isomorphic.tools.DataImport.ParseDateTime");
        defaultTranslators.put("time", "com.isomorphic.tools.DataImport.ParseTime");
        defaultTranslators.put("text", DEFAULT_TRANSLATOR);
        defaultTranslators.put("integer", "com.isomorphic.tools.DataImport.ParseNumber");
        defaultTranslators.put("float", "com.isomorphic.tools.DataImport.ParseFloat");
    }

    public class ParseFloat
    implements DataTranslator {
        public Object translate(Object object) throws TranslaterException {
            try {
                return new BigDecimal((String)object);
            }
            catch (NumberFormatException e) {
                throw new TranslaterException(e.toString());
            }
        }
    }

    public class ParseNumber
    implements DataTranslator {
        public Object translate(Object object) throws TranslaterException {
            try {
                return new BigInteger((String)object);
            }
            catch (NumberFormatException e) {
                throw new TranslaterException(e.toString());
            }
        }
    }

    public class ParseText
    implements DataTranslator {
        public Object translate(Object object) throws TranslaterException {
            return (String)object;
        }
    }

    public class ParseTime
    implements DataTranslator {
        public Object translate(Object object) throws TranslaterException {
            try {
                Calendar calendar = DatatypeConverter.parseTime((String)((String)object));
                return calendar.getTime();
            }
            catch (IllegalArgumentException e) {
                throw new TranslaterException(e.toString());
            }
        }
    }

    public class ParseDateTime
    implements DataTranslator {
        public Object translate(Object object) throws TranslaterException {
            try {
                Calendar calendar = DatatypeConverter.parseDateTime((String)((String)object));
                calendar.setTimeZone(TimeZone.getDefault());
                return calendar.getTime();
            }
            catch (IllegalArgumentException e) {
                throw new TranslaterException(e.toString());
            }
        }
    }

    public class ParseDate
    implements DataTranslator {
        public Object translate(Object object) throws TranslaterException {
            try {
                Calendar calendar = DatatypeConverter.parseDate((String)((String)object));
                return calendar.getTime();
            }
            catch (IllegalArgumentException e) {
                throw new TranslaterException(e.toString());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ImportFormat {
        CSV("csv"),
        JS_LITERAL("js"),
        EXCEL("xls"),
        JSON("json"),
        XML("xml"),
        AUTO("auto");

        private String value;

        private ImportFormat(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

