/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.datasource;

import com.isomorphic.application.AppBase;
import com.isomorphic.criteria.AdvancedCriteria;
import com.isomorphic.criteria.Criterion;
import com.isomorphic.criteria.DefaultOperators;
import com.isomorphic.criteria.Evaluator;
import com.isomorphic.criteria.OperatorBase;
import com.isomorphic.criteria.SimpleCriteria;
import com.isomorphic.criteria.criterion.AndCriterion;
import com.isomorphic.criteria.criterion.CustomCriterion;
import com.isomorphic.criteria.criterion.IsNullCriterion;
import com.isomorphic.criteria.criterion.LogicalCriterion;
import com.isomorphic.criteria.criterion.NotNullCriterion;
import com.isomorphic.criteria.criterion.OtherFieldCriterion;
import com.isomorphic.criteria.criterion.RangeCriterion;
import com.isomorphic.criteria.criterion.SetCriterion;
import com.isomorphic.criteria.criterion.SimpleCriterion;
import com.isomorphic.datasource.BasicDataSource;
import com.isomorphic.datasource.Committable;
import com.isomorphic.datasource.DSField;
import com.isomorphic.datasource.DSRequestAlreadyStartedException;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.datasource.DSTransaction;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.DataSourceDMI;
import com.isomorphic.datasource.DataSourceManager;
import com.isomorphic.datasource.DeclarativeSecurity;
import com.isomorphic.datasource.FreeResourcesHandler;
import com.isomorphic.datasource.IncludeFromDefinition;
import com.isomorphic.datasource.IncludeFromInfo;
import com.isomorphic.datasource.Relation;
import com.isomorphic.datasource.SummaryFunctionType;
import com.isomorphic.io.ISCFile;
import com.isomorphic.js.JSONFilter;
import com.isomorphic.log.Logger;
import com.isomorphic.mail.TemplatedMailMessage;
import com.isomorphic.rpc.BaseRequest;
import com.isomorphic.rpc.DataExport;
import com.isomorphic.rpc.RPCManager;
import com.isomorphic.servlet.ISCFileItem;
import com.isomorphic.servlet.RequestContext;
import com.isomorphic.util.AtomicFileOutputStream;
import com.isomorphic.util.DataTools;
import com.isomorphic.util.ErrorMessage;
import com.isomorphic.util.ErrorReport;
import com.isomorphic.velocity.IOWrapper;
import com.isomorphic.velocity.Velocity;
import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.Message;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.map.LinkedMap;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DSRequest
extends BaseRequest<DSRequest, DSResponse>
implements Committable {
    private static Logger log = new Logger(DSRequest.class.getName());
    private Map requestData;
    private AppBase app;
    Object clientSuppliedValues;
    Object clientSuppliedCriteria;
    private boolean beenThroughDMI = false;
    private boolean validated = false;
    private boolean allowAnyRPC = false;
    private Boolean partOfTransaction = null;
    private boolean beenThroughMailProcessing = false;
    private List subRequests = new ArrayList();
    private Map<String, DataSource> cachedDataSources = new HashMap<String, DataSource>();
    private boolean exportObjectCalled = false;
    private boolean sendRegularDSResponse = false;
    protected DSRequest primaryDSRequest = null;
    private boolean resourcesFreed = false;
    private boolean queueResourcesFreed = false;
    private String operationType = null;
    List uploadedFiles;
    String downloadFieldName = null;
    String downloadFileName = null;
    private Boolean includeBinaryFields = null;
    private Object sortBy = null;
    private List<String> summaryFields;
    private List<String> groupBy = null;
    private Map<String, SummaryFunctionType> summaryFunctions = null;
    private List summaryFunctionFields;
    public static final long FETCH_ALL = -1L;
    private long batchSize = -1L;
    private long startRow = 0L;
    private long endRow = -1L;
    public static final long ENDROW_UNSET = -1L;
    private String dataSourceName;
    DataSource ds;
    boolean requestStarted = false;
    private static String responseDataRegex = "\\$responseData\\.(last|first)(\\( *('[\\$_a-zA-Z][\\$_a-zA-Z0-9]*'|\"[\\$_a-zA-Z][\\$_a-zA-Z0-9]*\")( *, *('(";
    private static Pattern responseDataPattern;
    private static String responsesRegex;
    private static Pattern responsesPattern;
    private boolean preparedFieldData = false;
    Map templateContext = new HashMap();
    public static final String BUILTIN_APPLICATION = "builtinApplication";
    private Boolean _allowMultiUpdate = null;
    private Object constraints = null;
    private List outputs = null;
    private List additionalOutputs = null;
    private Map operationConfig = null;
    private boolean forceInvalidateCache = false;
    OutputStream exportOutputStream = null;
    protected String userId;
    protected List<String> userRoles = Arrays.asList("*");
    protected String securityFailureMessage;
    List checkedDataSources = new ArrayList();
    private Map attributes = new HashMap();
    private Boolean joinTransaction = null;
    FreeResourcesHandler freeResourcesHandler;
    private Boolean freeOnExecute = null;
    private List includeFrom = new ArrayList();
    private List consolidatedOutputs;
    private List droppedFields;
    private boolean selectCriteriaFields = false;
    private boolean selectSortByFields = false;
    private boolean isNestedSubRequest = false;
    private Comparator comparator = new Comparator(){

        public int compare(Object arg0, Object arg1) {
            Map map1;
            Map map0;
            if (arg0 == null) {
                if (arg1 == null) {
                    return 0;
                }
                return -1;
            }
            if (arg1 == null) {
                return 1;
            }
            if (arg0 instanceof Map) {
                map0 = (Map)arg0;
                map1 = (Map)arg1;
            } else {
                try {
                    map0 = DSRequest.this.getDataSource().getProperties(arg0);
                    map1 = DSRequest.this.getDataSource().getProperties(arg1);
                }
                catch (Exception e) {
                    log.warn((Object)"Exception during sorting", e);
                    return 0;
                }
            }
            for (String fieldName : DSRequest.this.getSortByFields()) {
                int result;
                IncludeFromDefinition incFrom;
                boolean descending = false;
                if (fieldName.indexOf("-") == 0) {
                    fieldName = fieldName.substring(1);
                    descending = true;
                }
                if ((incFrom = IncludeFromDefinition.forSortByField(DSRequest.this.includeFrom, fieldName, true)) != null) {
                    fieldName = incFrom.getThisFieldName();
                }
                Object value0 = map0.get(fieldName);
                Object value1 = map1.get(fieldName);
                if (value0 == null) {
                    if (value1 == null) {
                        return 0;
                    }
                    return -1;
                }
                if (value1 == null) {
                    return 1;
                }
                if (!(value0 instanceof Comparable) || (result = ((Comparable)value0).compareTo(value1)) == 0) continue;
                return result * (descending ? -1 : 1);
            }
            return 0;
        }
    };
    private Boolean skipAudit = null;
    private boolean usingSpringTransaction = false;

    public Object getParameter(Object key) {
        return this.requestData.get(key);
    }

    public DSRequest setParameter(Object key, Object value) {
        this.requestData.put(key, value);
        return this;
    }

    public boolean getBeenThroughDMI() {
        return this.beenThroughDMI;
    }

    public DSRequest setBeenThroughDMI(boolean newValue) {
        this.beenThroughDMI = newValue;
        return this;
    }

    public boolean getValidated() {
        return this.validated;
    }

    public DSRequest setValidated(boolean newValue) {
        this.validated = newValue;
        return this;
    }

    public boolean isPartOfTransaction() {
        return Boolean.TRUE.equals(this.partOfTransaction);
    }

    public boolean isPartOfTransactionKnown() {
        return this.partOfTransaction != null;
    }

    public DSRequest addSubRequest(DSRequest req) {
        this.subRequests.add(req);
        return this;
    }

    public List getSubRequests() {
        return this.subRequests;
    }

    public DSRequest cacheDataSourceInstance(String dsName, DataSource ds) {
        if (ds != null && ds.isCacheable()) {
            log.debug("Caching instance " + ds.getInstanceId() + " of DS " + ds.getName());
            this.getCachedDataSourceInstances().put(dsName, ds);
        }
        return this;
    }

    public DSRequest uncacheDataSourceInstance(String dsName) {
        this.getCachedDataSourceInstances().remove(dsName);
        return this;
    }

    public DataSource getCachedDataSourceInstance(String dsName) {
        return this.getCachedDataSourceInstances().get(dsName);
    }

    public Map<String, DataSource> getCachedDataSourceInstances() {
        if (this.getRPCManager() != null) {
            return this.getRPCManager().getCachedDataSourceInstances();
        }
        return this.cachedDataSources;
    }

    public boolean getExportObjectCalled() {
        return this.exportObjectCalled;
    }

    public void setExportObjectCalled(boolean value) {
        this.exportObjectCalled = value;
    }

    public boolean sendRegularDSResponse() {
        return this.sendRegularDSResponse;
    }

    public void setSendRegularDSResponse(boolean value) {
        this.sendRegularDSResponse = value;
    }

    public DSRequest setPartOfTransaction(boolean newValue) {
        this.partOfTransaction = new Boolean(newValue);
        if (newValue) {
            this.setFreeOnExecute(false);
        }
        return this;
    }

    public boolean getUseStrictJSON() {
        Object strict = this.getParameter("useStrictJSON");
        if (strict == null) {
            return false;
        }
        return (Boolean)strict;
    }

    public String getTextMatchStyle() {
        return (String)this.getOperationProperty("textMatchStyle");
    }

    public DSRequest setTextMatchStyle(String textMatchStyle) {
        this.setOperationProperty("textMatchStyle", textMatchStyle);
        return this;
    }

    public DSRequest getPrimaryDSRequest() {
        return this.primaryDSRequest;
    }

    public DSRequest setPrimaryDSRequest(DSRequest newValue) {
        this.primaryDSRequest = newValue;
        return this;
    }

    public boolean isCacheSyncRequest() {
        return this.primaryDSRequest != null;
    }

    @Override
    public DSTransaction getDsTransaction() {
        DSTransaction dsTran = super.getDsTransaction();
        if (dsTran == null && this.isCacheSyncRequest()) {
            dsTran = this.primaryDSRequest.getDsTransaction();
        }
        return dsTran;
    }

    public DSRequest(String dataSourceName, String operationType) {
        this();
        this.operationType = operationType;
        this.dataSourceName = dataSourceName;
        if (this.getTextMatchStyle() == null && config.get("global.default.textMatchStyle") != null) {
            this.setTextMatchStyle(config.getString("global.default.textMatchStyle"));
        }
    }

    public DSRequest(String dataSourceName, String operationType, RPCManager rpcManager) {
        this(dataSourceName, operationType);
        this.setRPCManager(rpcManager);
    }

    public DSRequest() {
        this(new HashMap());
        this.setAppID(BUILTIN_APPLICATION);
    }

    public DSRequest(Map requestData) {
        this.setRequestData(requestData);
    }

    private void setRequestData(Map requestData) {
        Object endRow;
        Object startRow;
        Object summaryFunctionsParam;
        this.requestData = requestData;
        if (this.getRawCriteria() == null) {
            this.setCriteria(new HashMap());
        }
        if (this.getAppID() == null) {
            this.setAppID(BUILTIN_APPLICATION);
        }
        try {
            this.app = this.getApp();
        }
        catch (Exception e) {
            log.error((Object)"Couldn't fetch app definition", e);
        }
        String operation = this.getOperation();
        Map reqOpConfig = (Map)this.getParameter("operationConfig");
        this.operationType = operation;
        HashMap operations = this.app.getOperationsMap();
        if (operations == null) {
            log.error("No operations defined in app '" + this.getAppID() + "' - creating empty config");
            operations = new HashMap();
        }
        Map serverOpConfig = (Map)operations.get(operation);
        Object dataSource = null;
        if (serverOpConfig != null) {
            dataSource = serverOpConfig.get("dataSource");
            if (serverOpConfig.get("type") != null) {
                this.operationType = (String)serverOpConfig.get("type");
            }
            if (dataSource != null) {
                if (dataSource instanceof String) {
                    this.dataSourceName = dataSource;
                } else {
                    List dataSources = dataSource;
                    this.dataSourceName = (String)dataSources.get(0);
                }
            }
        } else if (reqOpConfig != null && reqOpConfig.get("dataSource") != null) {
            this.operationType = (String)reqOpConfig.get("operationType");
            this.dataSourceName = (String)reqOpConfig.get("dataSource");
        } else if (operation != null && operation.indexOf(95) != -1) {
            this.operationType = operation.substring(operation.lastIndexOf(95) + 1);
            this.dataSourceName = operation.substring(0, operation.lastIndexOf(95));
        }
        if (!this.getAppID().equals(BUILTIN_APPLICATION)) {
            List qualifiedUserTypes = DataTools.makeList("*");
            try {
                DataTools.addAll(qualifiedUserTypes, this.app.userIsOfTypes());
            }
            catch (Exception e) {
                log.error((Object)"Can't look up app users", e);
            }
            for (String userType : qualifiedUserTypes) {
                this.addConstraints(this.app.getConstraintsForUserType(userType, operation));
                this.addOutputs(this.app.getOutputsForUserType(userType, operation));
            }
        }
        this.clientSuppliedCriteria = this.getParameter("criteria");
        if (this.clientSuppliedCriteria != null) {
            this.clientSuppliedCriteria = this.clientSuppliedCriteria instanceof List ? new ArrayList((List)this.clientSuppliedCriteria) : new HashMap((Map)this.clientSuppliedCriteria);
        }
        this.clientSuppliedValues = this.getParameter("values");
        if (this.clientSuppliedValues != null) {
            this.clientSuppliedValues = this.clientSuppliedValues instanceof List ? new ArrayList((List)this.clientSuppliedValues) : new HashMap((Map)this.clientSuppliedValues);
        }
        if (this.outputs() == null) {
            Object outputs = this.getParameter("outputs");
            if (outputs instanceof List) {
                this.setOutputs((List)outputs);
            } else if (outputs instanceof String) {
                this.setOutputs(DataTools.commaSeparatedStringToList((String)outputs));
            }
        }
        HashMap opConfig = new HashMap();
        DataTools.mapMerge(serverOpConfig, opConfig);
        DataTools.mapMerge(reqOpConfig, opConfig);
        this.setOperationConfig(opConfig);
        Object sortOrder = this.getParameter("sortBy");
        if (sortOrder == null) {
            sortOrder = opConfig.get("sortBy");
        }
        this.setSortBy(sortOrder);
        Object groupByParam = this.getParameter("groupBy");
        if (groupByParam != null) {
            if (groupByParam instanceof String) {
                this.setGroupBy((String)groupByParam);
            } else if (groupByParam instanceof List) {
                this.setGroupBy((List)groupByParam);
            }
        }
        if ((summaryFunctionsParam = this.getParameter("summaryFunctions")) != null && summaryFunctionsParam instanceof Map) {
            this.setSummaryFunctions(this.convertMapOfStringToMapOfSummaryFunctionType((Map)summaryFunctionsParam));
        }
        if ((startRow = this.getParameter("startRow")) != null) {
            this.setStartRow(Long.parseLong(startRow.toString()));
        }
        if ((endRow = this.getParameter("endRow")) != null) {
            this.setEndRow(Long.parseLong(endRow.toString()));
        }
        try {
            if (!(!DataSource.isUpdate(this.getOperationType()) && !DataSource.isRemove(this.getOperationType()) || this.getAllowMultiUpdate() || config.getBoolean((Object)"allow.case.sensitive.pks", false) || DataTools.getBoolean(this.getDataSource().getConfig(), "allowCaseSensitivePKs", false))) {
                this.setTextMatchStyle("exactCase");
            }
        }
        catch (Exception e) {
            log.warn((Object)"Exception attempting to get DataSource during DSRequest construction", e);
        }
    }

    private Map<String, SummaryFunctionType> convertMapOfStringToMapOfSummaryFunctionType(Map<String, String> incomingMap) {
        HashMap<String, SummaryFunctionType> summaryFunctions = new HashMap<String, SummaryFunctionType>();
        if (incomingMap != null) {
            for (Map.Entry<String, String> entry : incomingMap.entrySet()) {
                if (StringUtils.isEmpty((String)entry.getValue())) {
                    log.warn("Encountered an empty or null SummaryFunctionType. Ignoring.");
                    continue;
                }
                try {
                    summaryFunctions.put(entry.getKey(), SummaryFunctionType.valueOf(entry.getValue().toUpperCase()));
                }
                catch (IllegalArgumentException e) {
                    log.warn("Encountered unknown SummaryFunctionType '" + entry.getValue() + "'. Ignoring.");
                }
            }
        }
        return summaryFunctions;
    }

    public DSRequest(Map requestData, RequestContext context, RPCManager rpc) throws Exception {
        this.setRPCManager(rpc);
        this.context = context;
        this.setRequestData(requestData);
        this.recordTimingData("RPCManager construction", TimingLogType.START, rpc.getConstructedTimestamp());
        this.recordTimingData("DSRequest construction", TimingLogType.START);
        if (this.getOperation() == null) {
            throw new Exception("operation not specified");
        }
        this.setClientRequest(true);
        this.parseUploadedFiles();
        this.decodeUploadedStrings();
        this.recordTimingData("DSRequest construction", TimingLogType.END);
    }

    @Deprecated
    public RequestContext getRequestContext() {
        return this.context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DSRequest parseUploadedFiles() throws Exception {
        Map criteria;
        if (this.context.request.isMultipart()) {
            DataSource ds = this.getDataSource();
            ArrayList<ISCFileItem> uploadedFiles = null;
            HashMap<String, Object> addFields = new HashMap<String, Object>();
            Map values = this.getValues();
            try {
                int dftMaxSize = config.getInt("DSRequest.maxUploadFileSize", 0);
                for (String fieldName : values.keySet()) {
                    DSField field = ds.getField(fieldName);
                    if (field == null || !field.isBinary()) continue;
                    String filename = ISCFile.canonicalizePath((String)values.get(fieldName));
                    String shortFilename = filename;
                    if (shortFilename == null) {
                        shortFilename = "";
                    }
                    if (shortFilename.indexOf("/") != -1) {
                        shortFilename = shortFilename.substring(shortFilename.lastIndexOf("/") + 1);
                    }
                    int maxSize = dftMaxSize;
                    if (field.get("maxFileSize") != null) {
                        maxSize = ((Long)field.get("maxFileSize")).intValue();
                    }
                    ISCFileItem file2 = null;
                    ArrayList<ErrorReport> errors = null;
                    List<ISCFileItem> files = this.context.request.getUploadedFiles(fieldName);
                    if (files != null) {
                        for (ISCFileItem file2 : files) {
                            if (file2.getSize() > (long)maxSize) {
                                errors = new ArrayList<ErrorReport>();
                                ErrorReport errorReport = new ErrorReport();
                                errors.add(errorReport);
                                ErrorMessage errorMessage = new ErrorMessage("Size of '" + file2.getName() + "' (" + DataTools.formatFileSize(file2.getSize()) + ") exceeded maximum allowed file size of " + DataTools.formatFileSize(maxSize));
                                errorReport.addError(fieldName, errorMessage);
                                List<?> prevErrors = file2.getErrors();
                                if (prevErrors != null) {
                                    errors.addAll(0, prevErrors);
                                }
                                file2.setErrors(errors);
                            }
                            if (file2 == null) continue;
                            if (uploadedFiles == null) {
                                uploadedFiles = new ArrayList<ISCFileItem>();
                            }
                            uploadedFiles.add(file2);
                            file2.setFileName(filename);
                            String filenameField = fieldName + "_filename";
                            String filesizeField = fieldName + "_filesize";
                            String dateCreatedField = fieldName + "_date_created";
                            if (ds != null) {
                                filenameField = ds.getFilenameField(fieldName);
                                filesizeField = ds.getFilesizeField(fieldName);
                                dateCreatedField = ds.getDateCreatedField(fieldName);
                            }
                            addFields.put(filenameField, shortFilename);
                            file2.setShortFileName(shortFilename);
                            addFields.put(filesizeField, new Long(file2.getSize()));
                            addFields.put(dateCreatedField, new Date());
                        }
                        continue;
                    }
                    log.warn("We found a filename in the values for DataSource '" + ds.getName() + "', field '" + fieldName + "', but the expected corresponding binary content in the request body was missing.  Maybe a Filter or a framework like Struts has removed it?");
                }
                this.setUploadedFiles(uploadedFiles);
                this.setValues(DataTools.mapMerge(addFields, values));
            }
            finally {
                DataSourceManager.free(ds);
            }
        }
        if ((criteria = this.getCriteria()).get("download_fieldname") != null) {
            this.setDownloadFieldName((String)criteria.get("download_fieldname"));
            this.setDownloadFileName((String)criteria.get("download_filename"));
        }
        return this;
    }

    protected void decodeUploadedStrings() throws Exception {
        if (this.getDataSource() == null) {
            return;
        }
        if (this.getValues() == null || this.getValues().keySet() == null) {
            return;
        }
        for (String fieldName : this.getValues().keySet()) {
            InputStream stream;
            Object value;
            DSField field = this.getDataSource().getField(fieldName);
            if (field == null || (value = this.getValues().get(fieldName)) == null || !field.isBinary() || this.getValues().get(this.getDataSource().getFilenameField(fieldName)) != null || (stream = DataTools.base64Decode(value.toString())) == null) continue;
            this.getValues().put(fieldName, stream);
        }
    }

    public String getOperationType() {
        return this.operationType;
    }

    public DSRequest setOperationType(String operationType) {
        this.operationType = operationType;
        return this;
    }

    public String getOperationSource() {
        return (String)this.getParameter("operationSource");
    }

    public String getOperation() {
        return (String)this.getParameter("operation");
    }

    public String getOperationId() {
        return this.getOperation();
    }

    public DSRequest setOperationId(String operationId) {
        this.setParameter("operation", operationId);
        return this;
    }

    public String getComponentId() {
        return (String)this.getParameter("componentId");
    }

    public DSRequest setComponentId(String componentId) {
        this.setParameter("componentId", componentId);
        return this;
    }

    public Map getCriteria() {
        return this.getCriteria(true);
    }

    public Map getCriteria(boolean returnValuesForAdd) {
        if (returnValuesForAdd && DataSource.isAdd(this.getOperationType())) {
            return this.getValues();
        }
        Object criteria = this.getRawCriteria();
        if (criteria instanceof List) {
            List l = (List)criteria;
            if (l.size() == 0) {
                return null;
            }
            if (l.size() == 1) {
                return (Map)l.get(0);
            }
            log.warning("getCriteria() called on dsRequest containing multiple where clauses, returning first in list.");
            return (Map)l.get(0);
        }
        if (criteria instanceof Map) {
            return (Map)criteria;
        }
        return new HashMap();
    }

    public AdvancedCriteria getAdvancedCriteria() {
        String textMatchStyle = this.getTextMatchStyle();
        String operator = DefaultOperators.IEquals.getID();
        if (textMatchStyle != null) {
            if (textMatchStyle.equals("startsWith")) {
                operator = DefaultOperators.IStartsWith.getID();
            } else if (textMatchStyle.equals("substring")) {
                operator = DefaultOperators.IContains.getID();
            } else if (textMatchStyle.equals("exactCase")) {
                operator = DefaultOperators.Equals.getID();
            }
        }
        return AdvancedCriteria.fromCollections(this.getRawCriteria(), operator, this);
    }

    public boolean getIsAdvancedCriteria() {
        Object criteria = this.getRawCriteria();
        ArrayList l = null;
        if (criteria instanceof List) {
            l = (ArrayList)criteria;
        } else if (criteria instanceof Collection) {
            l = new ArrayList((Collection)criteria);
        }
        if (l != null) {
            if (l.size() == 1) {
                Map critData = (Map)l.get(0);
                return "AdvancedCriteria".equals(critData.get("_constructor"));
            }
            return false;
        }
        if (criteria instanceof Map) {
            Map critData = (Map)criteria;
            return "AdvancedCriteria".equals(critData.get("_constructor"));
        }
        return false;
    }

    public DSRequest setAdvancedCriteria(AdvancedCriteria advancedCriteria) {
        this.requestData.put("criteria", advancedCriteria.getCriteriaAsMap());
        return this;
    }

    public Map getClientSuppliedCriteria() {
        if (DataSource.isAdd(this.getOperationType())) {
            return this.getValues();
        }
        Object criteria = this.clientSuppliedCriteria;
        if (criteria instanceof List) {
            List l = (List)criteria;
            if (l.size() == 0) {
                return null;
            }
            if (l.size() == 1) {
                return (Map)l.get(0);
            }
            log.warning("getClientSuppliedCriteria() called on dsRequest containing multiple where clauses, returning first in list.");
            return (Map)l.get(0);
        }
        return (Map)criteria;
    }

    public List getCriteriaSets() {
        return DataTools.makeListIfSingle(this.getRawCriteria());
    }

    public DSRequest setCriteria(Object criteria) {
        if (criteria instanceof AdvancedCriteria) {
            this.setAdvancedCriteria((AdvancedCriteria)criteria);
        } else {
            this.requestData.put("criteria", criteria);
        }
        return this;
    }

    public DSRequest setCriteria(String fieldName, Object value) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(fieldName, value);
        this.requestData.put("criteria", map);
        return this;
    }

    public Object getRawCriteria() {
        return this.requestData.get("criteria");
    }

    public void setRawCriteria(Object rawCriteria) {
        this.requestData.put("criteria", rawCriteria);
    }

    public DSRequest setUploadedFiles(List uploadedFiles) {
        this.uploadedFiles = uploadedFiles;
        if (uploadedFiles == null) {
            return this;
        }
        String logMsg = "We parsed " + uploadedFiles.size() + " uploaded file(s)";
        if (uploadedFiles.size() > 0) {
            logMsg = logMsg + ": ";
            for (int i = 0; i < uploadedFiles.size(); ++i) {
                if (!(uploadedFiles.get(i) instanceof ISCFileItem)) continue;
                ISCFileItem ifi = (ISCFileItem)uploadedFiles.get(i);
                if (i > 0) {
                    logMsg = logMsg + ", ";
                }
                logMsg = logMsg + "\"" + ifi.getName() + "\" (" + ifi.getSize() + " bytes)";
            }
        }
        log.info(logMsg);
        return this;
    }

    public DSRequest clearUploadedFiles() {
        this.setUploadedFiles(null);
        return this;
    }

    public ISCFileItem getUploadedFile(String fieldName) throws Exception {
        ISCFileItem fileItem = this.context.request.getUploadedFile(fieldName);
        return fileItem;
    }

    public List getUploadedFiles() {
        return this.uploadedFiles;
    }

    public InputStream getUploadedFileStream(String fieldName) throws Exception {
        ISCFileItem fileItem = this.context.request.getUploadedFile(fieldName);
        if (fileItem != null && this.getValues().get(fieldName) instanceof InputStream) {
            return (InputStream)this.getValues().get(fieldName);
        }
        return fileItem.getInputStream();
    }

    public List getUploadedFileStreams() {
        List uploadedFiles = this.getUploadedFiles();
        if (uploadedFiles == null) {
            return null;
        }
        ArrayList<Object> uploadedFileStreams = new ArrayList<Object>();
        for (ISCFileItem file : uploadedFiles) {
            String fieldName = file.getFieldName();
            if (this.getValues().get(fieldName) instanceof InputStream) {
                uploadedFileStreams.add(this.getValues().get(fieldName));
                continue;
            }
            uploadedFileStreams.add(file.getInputStream());
        }
        return uploadedFileStreams;
    }

    public List getBinaryStreams() {
        Map values;
        int j;
        List streams = this.getUploadedFileStreams();
        List uploadedFiles = this.getUploadedFiles();
        ArrayList<Map<Object, Object>> fieldStreamMaps = new ArrayList<Map<Object, Object>>();
        if (uploadedFiles != null) {
            for (int i = 0; i < uploadedFiles.size(); ++i) {
                ISCFileItem file = (ISCFileItem)uploadedFiles.get(i);
                HashMap<String, Object> fieldStreamMap = new HashMap<String, Object>();
                fieldStreamMap.put("name", file.getFieldName());
                fieldStreamMap.put("stream", (InputStream)streams.get(i));
                for (j = 0; j < fieldStreamMaps.size(); ++j) {
                    String yourFieldName;
                    Map otherFieldStreamMap = (Map)fieldStreamMaps.get(j);
                    String myFieldName = (String)fieldStreamMap.get("name");
                    if (myFieldName.compareTo(yourFieldName = (String)otherFieldStreamMap.get("name")) < 0) break;
                }
                fieldStreamMaps.add(j, fieldStreamMap);
            }
        }
        if ((values = this.getValues()) != null) {
            for (String key : values.keySet()) {
                Map<String, InputStream> fieldStreamMap;
                if (!(values.get(key) instanceof InputStream)) continue;
                for (j = 0; j < fieldStreamMaps.size(); ++j) {
                    fieldStreamMap = (Map)fieldStreamMaps.get(j);
                    String fieldName = (String)fieldStreamMap.get("name");
                    if (key == null || fieldName == null || key.equals(fieldName)) {
                        fieldStreamMaps.remove(j);
                        break;
                    }
                    if (key.compareTo(fieldName) < 0) break;
                }
                fieldStreamMap = new HashMap();
                fieldStreamMap.put("name", (InputStream)((Object)key));
                fieldStreamMap.put("stream", (InputStream)values.get(key));
                fieldStreamMaps.add(j, fieldStreamMap);
            }
        }
        ArrayList rtn = new ArrayList();
        Iterator i = fieldStreamMaps.iterator();
        while (i.hasNext()) {
            rtn.add(((Map)i.next()).get("stream"));
        }
        return rtn;
    }

    public DSRequest setDownloadFieldName(String downloadFieldName) {
        this.downloadFieldName = downloadFieldName;
        return this;
    }

    public String getDownloadFieldName() {
        return this.downloadFieldName;
    }

    public DSRequest setDownloadFileName(String downloadFileName) {
        this.downloadFileName = downloadFileName;
        return this;
    }

    public String getDownloadFileName() {
        return this.downloadFileName;
    }

    public boolean isDownload() {
        String opType;
        return this.getDownloadFieldName() != null && ("downloadFile".equals(opType = this.getOperationType()) || "viewFile".equals(opType));
    }

    public void setIncludeBinaryFields(boolean includeBinaryFields) {
        this.includeBinaryFields = includeBinaryFields;
    }

    public boolean getIncludeBinaryFields() {
        if (this.includeBinaryFields != null) {
            return this.includeBinaryFields;
        }
        if (this.isClientRequest() && !this.isDownload()) {
            return false;
        }
        return !this.isCacheSyncRequest();
    }

    public boolean isExport() {
        return this.getExportResults();
    }

    public Map getValues() {
        return this.getValues(true);
    }

    public Map getValues(boolean returnCriteriaForFetch) {
        Object values;
        if (returnCriteriaForFetch) {
            if (DataSource.isFetch(this.getOperationType())) {
                return this.getCriteria();
            }
            if (DataSource.isRemove(this.getOperationType())) {
                return this.getCriteria();
            }
        }
        if ((values = this.getRawValues()) instanceof List) {
            List l = (List)values;
            if (l.size() == 0) {
                return null;
            }
            if (l.size() == 1) {
                return (Map)l.get(0);
            }
            log.warning("getValues() called on dsRequest containing multiple sets of values, returning first in list.");
            return (Map)l.get(0);
        }
        return (Map)values;
    }

    public Map getClientSuppliedValues() {
        if (DataSource.isFetch(this.getOperationType())) {
            return this.getClientSuppliedCriteria();
        }
        if (DataSource.isRemove(this.getOperationType())) {
            return this.getClientSuppliedCriteria();
        }
        Object values = this.clientSuppliedValues;
        if (values instanceof List) {
            List l = (List)values;
            if (l.size() == 0) {
                return null;
            }
            if (l.size() == 1) {
                return (Map)l.get(0);
            }
            log.warning("getClientSuppliedValues() called on dsRequest containing multiple sets of values, returning first in list.");
            return (Map)l.get(0);
        }
        return (Map)values;
    }

    public List getValueSets() {
        if (DataSource.isFetch(this.getOperationType())) {
            return this.getCriteriaSets();
        }
        if (DataSource.isRemove(this.getOperationType())) {
            return this.getCriteriaSets();
        }
        return DataTools.makeListIfSingle(this.getRawValues());
    }

    public DSRequest setValues(Object values) {
        this.requestData.put("values", values);
        return this;
    }

    public Object getRawValues() {
        return this.requestData.get("values");
    }

    public Map getOldValues() {
        Object values = this.getRawOldValues();
        if (values instanceof List) {
            List l = (List)values;
            if (l.size() == 0) {
                return null;
            }
            if (l.size() == 1) {
                return (Map)l.get(0);
            }
            log.warning("getOldValues() called on dsRequest containing multiple sets of values, returning first in list.");
            return (Map)l.get(0);
        }
        return (Map)values;
    }

    public List getOldValueSets() {
        return DataTools.makeListIfSingle(this.getRawOldValues());
    }

    public Object getRawOldValues() {
        return this.requestData.get("oldValues");
    }

    public DSRequest setOldValues(Map oldValues) {
        this.requestData.put("oldValues", oldValues);
        return this;
    }

    public String getSortBy() {
        if (this.sortBy instanceof List) {
            List l = (List)this.sortBy;
            if (l.size() == 0) {
                return null;
            }
            if (l.size() == 1) {
                return (String)l.get(0);
            }
            log.warning("getSortBy() called on dsRequest containing multiple sortBy fields, returning first in list.");
            return (String)l.get(0);
        }
        return (String)this.sortBy;
    }

    public Object getRawSortBy() {
        return this.sortBy;
    }

    public List getSortByFields() {
        return DataTools.makeListIfSingle(this.sortBy);
    }

    public DSRequest setSortBy(Object sortBy) {
        this.sortBy = sortBy;
        return this;
    }

    private void buildSummaryFields() {
        Iterator<Object> i;
        if (this.summaryFields == null) {
            this.summaryFields = new ArrayList<String>();
        } else {
            this.summaryFields.clear();
        }
        List groupByList = null;
        ArrayList<String> newGroupByList = new ArrayList<String>();
        Map<String, SummaryFunctionType> summaryFunctionsMap = null;
        DataSource ds = null;
        try {
            ds = this.getDataSource();
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean allowClientRequestedSummaries = config.getBoolean((Object)"datasources.allowClientRequestedSummaries", true);
        if (ds != null) {
            allowClientRequestedSummaries = DataTools.getBoolean(ds.getConfig(), "allowClientRequestedSummaries", allowClientRequestedSummaries);
            Map opBinding = ds.getOperationBinding(this);
            if (opBinding != null && (allowClientRequestedSummaries = DataTools.getBoolean(opBinding, "allowClientRequestedSummaries", allowClientRequestedSummaries))) {
                groupByList = DataTools.makeListIfSingle(opBinding.get("groupBy"));
                summaryFunctionsMap = this.convertMapOfStringToMapOfSummaryFunctionType((Map)opBinding.get("summaryFunctions"));
            }
        }
        if (allowClientRequestedSummaries && (groupByList == null || groupByList.isEmpty()) && (summaryFunctionsMap == null || summaryFunctionsMap.isEmpty())) {
            groupByList = this.getGroupBy();
            summaryFunctionsMap = this.getSummaryFunctions();
        }
        if (groupByList != null && !groupByList.isEmpty() || summaryFunctionsMap == null || !summaryFunctionsMap.isEmpty()) {
            // empty if block
        }
        if (summaryFunctionsMap != null) {
            i = summaryFunctionsMap.keySet().iterator();
            while (i.hasNext()) {
                String fieldName = (String)i.next();
                if (ds != null) {
                    SummaryFunctionType summaryFunctionType = summaryFunctionsMap.get(fieldName);
                    if (summaryFunctionType == null) {
                        log.warn("A null function name was specified in summaryFunctions for field '" + ds.getName() + "." + fieldName + "'. Skipping.");
                        i.remove();
                        continue;
                    }
                    if (!ds.supportsSummaryFunction(summaryFunctionType.getFunctionName())) {
                        log.warn("Function name: '" + summaryFunctionType.getFunctionName() + "' specified in summaryFunctions for field '" + ds.getName() + "." + fieldName + "' is not supported by this type of data source. Skipping.");
                        i.remove();
                        continue;
                    }
                    DSField field = ds.getField(fieldName);
                    if (field == null) {
                        log.warn("Field name: '" + fieldName + "' specified in group-by or summaryFunctions is not defined in data source. Skipping.");
                        i.remove();
                        continue;
                    }
                    if (!field.getBoolean("allowClientRequestedSummaries", allowClientRequestedSummaries)) {
                        log.warn("Client-requested summarization is NOT allowed for field '" + fieldName + "' specified in group-by or summaryFunctions. Skipping.");
                        i.remove();
                        continue;
                    }
                }
                if (this.summaryFields.contains(fieldName)) continue;
                this.summaryFields.add(fieldName);
            }
        }
        if (groupByList != null) {
            i = groupByList.iterator();
            while (i.hasNext()) {
                String fieldNameString = (String)i.next();
                if (fieldNameString == null) continue;
                boolean fieldShouldBeRemoved = false;
                for (String fieldName : fieldNameString.split(",")) {
                    fieldName = fieldName.trim();
                    if (summaryFunctionsMap != null && summaryFunctionsMap.containsKey(fieldName)) {
                        log.warn("Field name: '" + fieldName + "' is already specified in summary functions to use in select statement. Excluding it from group by clause.");
                        continue;
                    }
                    if (ds != null) {
                        DSField field = ds.getField(fieldName);
                        if (field == null) {
                            log.warn("Field name: '" + fieldName + "' specified in group-by or summary functions is not defined in data source. Skipping.");
                            fieldShouldBeRemoved = true;
                            continue;
                        }
                        if (!field.getBoolean("allowClientRequestedSummaries", allowClientRequestedSummaries)) {
                            log.warn("Client-requested summarization is NOT allowed for field '" + fieldName + "' specified in group-by or summary functions. Skipping.");
                            fieldShouldBeRemoved = true;
                            continue;
                        }
                    }
                    if (this.summaryFields.contains(fieldName)) continue;
                    this.summaryFields.add(fieldName);
                    newGroupByList.add(fieldName);
                }
                if (!fieldShouldBeRemoved) continue;
                i.remove();
            }
        }
        this.setGroupBy(newGroupByList);
        this.setSummaryFunctions(summaryFunctionsMap);
    }

    public List<String> getSummaryFields() {
        return this.summaryFields;
    }

    public boolean isSummary() {
        return this.summaryFields != null && this.summaryFields.size() > 0;
    }

    public List<String> getGroupBy() {
        return this.groupBy;
    }

    public DSRequest setGroupBy(List<String> groupBy) {
        this.groupBy = groupBy;
        return this;
    }

    public DSRequest setGroupBy(String ... groupBy) {
        this.setGroupBy(Arrays.asList(groupBy));
        return this;
    }

    public Map<String, SummaryFunctionType> getSummaryFunctions() {
        return this.summaryFunctions;
    }

    public DSRequest setSummaryFunctions(Map<String, SummaryFunctionType> summaryFunctions) {
        this.summaryFunctions = summaryFunctions;
        return this;
    }

    public List getSummaryFunctionFields() {
        return this.summaryFunctionFields;
    }

    public void setSummaryFunctionFields(List summaryFunctionFields) {
        this.summaryFunctionFields = summaryFunctionFields;
    }

    public boolean isPaged() {
        return this.batchSize != -1L || this.startRow != 0L || this.endRow != -1L;
    }

    public long getBatchSize() {
        return this.batchSize;
    }

    public DSRequest setBatchSize(long batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    public long getStartRow() {
        return this.startRow;
    }

    public DSRequest setStartRow(long startRow) {
        this.startRow = startRow;
        return this;
    }

    public long getEndRow() {
        return this.endRow;
    }

    public DSRequest setEndRow(long endRow) {
        this.endRow = endRow;
        return this;
    }

    public Object getFieldValue(Object fieldName) {
        Map valueSet = this.getValues();
        if (valueSet != null && valueSet.get(fieldName) != null) {
            return valueSet.get(fieldName);
        }
        if (DataSource.isAdd(this.getOperationType())) {
            return null;
        }
        return this.getCriteriaValue(fieldName);
    }

    public Object getCriteriaValue(Object fieldName) {
        if (this.getIsAdvancedCriteria()) {
            Object res;
            AdvancedCriteria ac = this.getAdvancedCriteria();
            if (ac != null && (res = ac.getFieldValue((String)fieldName)) != null) {
                return res;
            }
        } else {
            Map criteria = this.getCriteria();
            if (criteria != null && criteria.get(fieldName) != null) {
                return criteria.get(fieldName);
            }
        }
        return null;
    }

    public Object setCriteriaValue(String fieldName, Object value) {
        Object retValue = null;
        if (this.getIsAdvancedCriteria()) {
            AdvancedCriteria ac = this.getAdvancedCriteria();
            SimpleCriterion newCriterion = new SimpleCriterion(fieldName, "equals", value);
            Criterion oldCriterion = ac.asCriterion();
            ac = new AdvancedCriteria(DefaultOperators.And, newCriterion, oldCriterion);
            this.setAdvancedCriteria(ac);
        } else {
            Map criteria = this.getCriteria();
            retValue = criteria.get(fieldName);
            criteria.put(fieldName, value);
            this.setCriteria(criteria);
        }
        return retValue;
    }

    public DSRequest setFieldValue(Object fieldName, Object value) {
        Map valueSet = this.getValues();
        if (valueSet == null && DataSource.isAddOrUpdate(this.getOperationType())) {
            valueSet = new LinkedMap();
            this.setValues(valueSet);
        }
        if (DataSource.isAddOrUpdate(this.getOperationType())) {
            valueSet.put(fieldName, value);
        } else {
            this.setCriteriaValue(fieldName.toString(), value);
        }
        return this;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public DSRequest setDataSourceName(String dataSourceName) {
        this.uncacheDataSourceInstance(this.dataSourceName);
        this.dataSourceName = dataSourceName;
        DataSourceManager.free(this.ds);
        this.ds = null;
        return this;
    }

    public DataSource getDataSource() throws Exception {
        if (this.ds == null && this.getDataSourceName() != null) {
            this.ds = this.getCachedDataSourceInstance(this.getDataSourceName());
            if (this.ds == null) {
                this.ds = DataSourceManager.getDataSource(this.getDataSourceName(), this);
                log.debug("Caching instance " + (this.ds == null ? "null" : this.ds.getInstanceId() + " of DS '" + this.ds.getID() + "' from DSRequest.getDataSource()"));
                this.cacheDataSourceInstance(this.getDataSourceName(), this.ds);
            }
        }
        return this.ds;
    }

    public DSRequest setDataSource(DataSource ds) {
        if (this.ds != null) {
            DataSourceManager.freeDataSource(this.ds);
        }
        this.ds = ds;
        if (ds != null) {
            this.dataSourceName = ds.getName();
        }
        return this;
    }

    public boolean isDataSourceNull() {
        return this.ds == null;
    }

    public String getValidationMode() {
        return (String)this.requestData.get("validationMode");
    }

    public DSRequest setValidationMode(String validationMode) {
        this.requestData.put("validationMode", validationMode);
        return this;
    }

    public boolean getPendingAddFlag() {
        return DataTools.getBoolean(this.requestData, "pendingAdd", false);
    }

    public DSRequest setPendingAddFlag(boolean pendingAdd) {
        this.requestData.put("pendingAdd", pendingAdd);
        return this;
    }

    public ErrorReport validate() throws Exception {
        List l = DataSource.validateDSRequest(this.getDataSource(), this);
        if (l != null) {
            return (ErrorReport)l.get(0);
        }
        return null;
    }

    public Boolean getGenerateRelatedUpdates() {
        Object generateRelatedUpdates = this.getParameter("generateRelatedUpdates");
        if (generateRelatedUpdates == null) {
            return null;
        }
        return DataTools.asBoolean(generateRelatedUpdates);
    }

    public void setGenerateRelatedUpdates(Boolean generateRelatedUpdates) {
        this.setParameter("generateRelatedUpdates", generateRelatedUpdates);
    }

    public void convertRelativeDates() {
        Criterion criterion = AdvancedCriteria.isAdvancedCriteria(this.getCriteria()) ? Evaluator.parseAdvancedCriteria(this.getCriteria()).asCriterion() : Evaluator.parseCriterion(this.getCriteria());
        this.setCriteria(new AdvancedCriteria(DataSource.convertRelativeDates(criterion)));
    }

    public boolean getRequestStarted() {
        return this.requestStarted;
    }

    public DSRequest setRequestStarted(boolean newValue) {
        this.requestStarted = newValue;
        return this;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public DSResponse execute() throws Exception {
        DSResponse dsResponse;
        DSTransaction dsTransaction;
        block145: {
            Iterator i;
            block142: {
                DataSource ds4;
                block143: {
                    if (this.isClientRequest() ? log.isInfoEnabled() : log.isDebugEnabled()) {
                        Map operationBinding = this.getDataSource().getOperationBinding(this.getOperationType(), this.getOperationId());
                        String operationMessage = "Executing " + this.getDataSourceName() + "." + this.getOperationType();
                        String operationId = null;
                        if (operationBinding != null) {
                            operationId = (String)operationBinding.get("operationId");
                        }
                        if (operationId != null) {
                            operationMessage = operationMessage + "[operationId: " + operationId + "]";
                        }
                        if (this.isClientRequest()) {
                            log.info(operationMessage);
                        } else {
                            log.debug(operationMessage);
                        }
                    }
                    if ((dsTransaction = this.getDsTransaction()) != null) {
                        dsTransaction.registerRequest(this);
                        if (dsTransaction.isSkipRemainingQueue()) {
                            log.debug("DSTransaction.skipRemainingQueue is true so we're returning a DSResponse with status PROCESSING_SKIPPED.");
                            dsResponse = new DSResponse();
                            dsResponse.setStatus(4);
                            dsTransaction.registerResponse(this, dsResponse);
                            return dsResponse;
                        }
                    }
                    this.resourcesFreed = false;
                    dsResponse = null;
                    this.recordTimingData("DSRequest processing", TimingLogType.START);
                    try {
                        try {
                            List mailDefs;
                            Integer cacheSyncBatchSize;
                            Integer defaultFetchBatchSize;
                            this.buildFieldData(false);
                            this.recordTimingData("Declarative security checks", TimingLogType.START);
                            if (!this.passesSecurityChecks()) {
                                throw new SecurityException(this.securityFailureMessage);
                            }
                            this.recordTimingData("Declarative security checks", TimingLogType.END);
                            if (this.getUploadedFiles() != null) {
                                this.recordTimingData("Uploaded files processing", TimingLogType.START);
                                int dftMaxSize = config.getInt("DSRequest.maxUploadFileSize", 0);
                                for (ISCFileItem file : this.getUploadedFiles()) {
                                    List<?> errors = file.getErrors();
                                    if (errors == null) continue;
                                    dsResponse = new DSResponse(this.getDataSource());
                                    DSField field = this.ds.getField(file.getFieldName());
                                    int maxSize = dftMaxSize;
                                    if (field.get("maxFileSize") != null) {
                                        maxSize = ((Long)field.get("maxFileSize")).intValue();
                                    }
                                    dsResponse.setParameter("maxFileSize", DataTools.formatFileSize(maxSize));
                                    dsResponse.setParameter("uploadedFileName", file.getShortFileName());
                                    dsResponse.setParameter("uploadedFileSize", DataTools.formatFileSize(file.getSize()));
                                    dsResponse.setStatus(-11);
                                    dsResponse.requestConnectionClose();
                                }
                                this.recordTimingData("Uploaded files processing", TimingLogType.END);
                                if (dsResponse != null) {
                                    i = dsResponse;
                                    Object var26_29 = null;
                                    if (dsResponse == null || dsTransaction == null) break block142;
                                    this.getDsTransaction().registerResponse(this, dsResponse);
                                    break block143;
                                }
                            }
                            if (this.getEndRow() == -1L && DataSource.isFetch(this.getOperationType()) && (defaultFetchBatchSize = config.getInt("sql.defaultFetchBatchSize")) != null) {
                                this.setBatchSize(defaultFetchBatchSize.intValue());
                            }
                            if (this.isCacheSyncRequest() && (cacheSyncBatchSize = config.getInt("sql.cacheSyncBatchSize")) != null && cacheSyncBatchSize != 0) {
                                this.setBatchSize(cacheSyncBatchSize.intValue());
                            }
                            if (config.getBoolean((Object)"datasources.autoConvertRelativeDates", false)) {
                                this.convertRelativeDates();
                            }
                            if (!this.beenThroughDMI) {
                                if (dsTransaction != null) {
                                    dsTransaction.initiateRequestProcessing();
                                }
                                this.applyFieldValueExpressions();
                                this.recordTimingData("Field-level declarative security checks", TimingLogType.START);
                                DeclarativeSecurity.performFieldLevelDSRequestChecks(this);
                                this.recordTimingData("Field-level declarative security checks", TimingLogType.END);
                                this.recordTimingData("Prepare DSRequest for DMI", TimingLogType.START);
                                if ("update".equals(this.getOperationType()) || "add".equals(this.getOperationType())) {
                                    this.removeIllegalValues();
                                }
                                if (this.getDataSource() != null) {
                                    this.setCriteria(this.getDataSource().normalizeAdvancedCriteria(this.getCriteria()));
                                }
                                this.trimCriteria();
                                if (dsTransaction != null) {
                                    dsTransaction.applyEarlierResponseValues(this);
                                }
                                if ("update".equals(this.getOperationType()) || "add".equals(this.getOperationType())) {
                                    this.hashFieldValues();
                                    this.populateModifierAndCreatorFields("add".equals(this.getOperationType()));
                                    List files = this.getUploadedFiles();
                                    if (files != null) {
                                        for (Object f : files) {
                                            ISCFileItem file = (ISCFileItem)f;
                                            this.getValues().put(file.getFieldName(), file.getInputStream());
                                        }
                                    }
                                }
                                this.recordTimingData("Prepare DSRequest for DMI", TimingLogType.END);
                                this.recordTimingData("DMI", TimingLogType.START);
                                dsResponse = DataSourceDMI.execute(this, this.getRPCManager(), this.context);
                                this.recordTimingData("DMI", TimingLogType.END);
                            }
                            if (dsResponse == null) {
                                dsResponse = this.getApp().execute(this, this.context);
                            }
                            if (dsResponse != null) {
                                dsResponse.setOperationType(this.getOperationType());
                                if (dsResponse.getDataSource() == null) {
                                    dsResponse.setDataSource(this.getDataSource());
                                }
                            }
                            if (DataSource.isFetch(this.getOperationType())) {
                                this.fetchRelatedValues(dsResponse);
                                this.applyManualFilterAndSort(dsResponse);
                            }
                            List<String> outputColumns = null;
                            Map operationBinding = null;
                            DataSource ds2 = this.getDataSource();
                            if (ds2 != null) {
                                operationBinding = ds2.getOperationBinding(this.getOperationType(), this.getOperationId());
                            }
                            if (operationBinding != null && operationBinding.get("outputs") != null) {
                                String outputString = (String)operationBinding.get("outputs");
                                String[] outputArray = outputString.split(",");
                                outputColumns = new ArrayList();
                                for (int i2 = 0; i2 < outputArray.length; ++i2) {
                                    outputColumns.add(outputArray[i2].trim());
                                }
                            }
                            if (!"loadSchema".equals(this.getOperationType())) {
                                if (this.outputs() != null) {
                                    if (outputColumns != null) {
                                        if (outputColumns.containsAll(this.outputs())) {
                                            outputColumns = this.outputs();
                                        } else {
                                            log.warn("The dsRequest contains a client-specified 'outputs', but this is not a subset of the server-specified 'outputs' for this operation binding (" + this.getOperationId() + "). Ignoring the client-specified value.");
                                        }
                                    } else {
                                        List<String> fieldNames = ds2.getFieldNames();
                                        boolean ok = true;
                                        outputColumns = new ArrayList();
                                        for (String outputName : this.outputs) {
                                            if (fieldNames.contains(outputName)) {
                                                outputColumns.add(outputName);
                                                continue;
                                            }
                                            if (IncludeFromDefinition.isDynamicInclusion(outputName)) {
                                                IncludeFromDefinition work = new IncludeFromDefinition(outputName, this);
                                                outputColumns.add(work.getThisFieldName());
                                                continue;
                                            }
                                            ok = false;
                                            break;
                                        }
                                        if (!ok) {
                                            log.warn("The dsRequest contains a client-specified 'outputs' which contains a reference to a field that is not on this DataSource and is not a dynamic reference to a field on another DataSource.  Ignoring the client-specified value.");
                                            outputColumns = null;
                                        }
                                    }
                                    this.consolidatedOutputs = outputColumns;
                                }
                                DeclarativeSecurity.applyCreatorOverridesToResultSet(dsResponse.getDataList(), this);
                            }
                            if (operationBinding != null) {
                                Map map;
                                Object value;
                                if (operationBinding.containsKey("exportResults")) {
                                    Boolean exportResults = (Boolean)operationBinding.get("exportResults");
                                    dsResponse.setExportResults(exportResults);
                                }
                                if (operationBinding.containsKey("exportFilename")) {
                                    dsResponse.setExportFilename((String)operationBinding.get("exportFilename"));
                                }
                                if (operationBinding.containsKey("exportAs")) {
                                    dsResponse.setExportAs((String)operationBinding.get("exportAs"));
                                }
                                if (operationBinding.containsKey("exportDelimiter")) {
                                    dsResponse.setExportDelimiter((String)operationBinding.get("exportDelimiter"));
                                }
                                if (operationBinding.containsKey("exportTitleSeparatorChar")) {
                                    dsResponse.setExportTitleSeparatorChar((String)operationBinding.get("exportTitleSeparatorChar"));
                                }
                                if (operationBinding.containsKey("lineBreakStyle")) {
                                    dsResponse.setLineBreakStyle((String)operationBinding.get("lineBreakStyle"));
                                }
                                if (operationBinding.containsKey("exportDisplay")) {
                                    dsResponse.setExportDisplay((String)operationBinding.get("exportDisplay"));
                                }
                                if (operationBinding.containsKey("exportHeader")) {
                                    dsResponse.setExportHeader((String)operationBinding.get("exportHeader"));
                                }
                                if (operationBinding.containsKey("exportHeaderless")) {
                                    dsResponse.setExportHeaderless(DataTools.asBoolean(operationBinding.get("exportHeaderless"), false));
                                }
                                if (operationBinding.containsKey("exportFooter")) {
                                    dsResponse.setExportFooter((String)operationBinding.get("exportFooter"));
                                }
                                if (operationBinding.containsKey("exportFields") && (value = (map = (Map)operationBinding.get("exportFields")).get(map.keySet().toArray()[0])) instanceof List) {
                                    dsResponse.setExportFields((List)value);
                                }
                                if (operationBinding.containsKey("exportDatesAsFormattedString")) {
                                    Boolean exportDatesAsFormattedString = (Boolean)operationBinding.get("exportDatesAsFormattedString");
                                    dsResponse.setExportDatesAsFormattedString(exportDatesAsFormattedString);
                                }
                            }
                            if (this.getRPCManager() == null && this.shouldExportToFilesystem() || this.getExportTo() != null || this.getExportObjectCalled()) {
                                void var16_55;
                                String lineBreakStyle;
                                String string;
                                this.copyExportSettingsToResponse(dsResponse);
                                List<Object> data = new ArrayList();
                                Iterator iterator = null;
                                Object initData = dsResponse.getData();
                                if (initData instanceof List) {
                                    data = (List)initData;
                                } else if (initData instanceof Object[]) {
                                    Object[] arr = (Object[])initData;
                                    for (int i3 = 0; i3 < arr.length; ++i3) {
                                        data.add(arr[i3]);
                                    }
                                } else if (initData instanceof Iterator) {
                                    iterator = (Iterator)initData;
                                } else {
                                    data.add(initData);
                                }
                                HashMap<String, String> fieldMap = this.getExportFieldTitles();
                                boolean receivedTitleMap = true;
                                if (fieldMap == null) {
                                    fieldMap = new HashMap<String, String>();
                                    receivedTitleMap = false;
                                }
                                ds2 = dsResponse.getDataSource() != null ? dsResponse.getDataSource() : this.getDataSource();
                                List<String> fieldNames = dsResponse.getExportFields();
                                ArrayList<String> finalFields = (ArrayList<String>)dsResponse.getParameter("exportFields");
                                if (finalFields == null) {
                                    finalFields = new ArrayList<String>();
                                }
                                boolean createExportFields = finalFields.isEmpty();
                                if (fieldNames == null || fieldNames.isEmpty()) {
                                    fieldNames = ds2.getFieldNames();
                                }
                                if ((string = dsResponse.getExportAs()) != null) {
                                    String string2 = string.toLowerCase();
                                }
                                if ((lineBreakStyle = dsResponse.getLineBreakStyle()) != null) {
                                    lineBreakStyle = lineBreakStyle.toLowerCase();
                                }
                                String separatorChar = dsResponse.getExportTitleSeparatorChar();
                                HashMap<String, String> otherFields = (HashMap<String, String>)dsResponse.getParameter("exportOtherFields");
                                if (otherFields == null) {
                                    otherFields = new HashMap<String, String>();
                                }
                                boolean createOtherFields = dsResponse.getParameter("exportHeaderSpans") == null && otherFields.isEmpty();
                                for (int i4 = 0; i4 < fieldNames.size(); ++i4) {
                                    String fieldName = fieldNames.get(i4);
                                    if (createOtherFields && !otherFields.containsKey(fieldName)) {
                                        String fieldTitle = fieldName;
                                        Map exportFieldTitles = this.getExportFieldTitles();
                                        DSField field = ds2.getField(fieldName);
                                        if (exportFieldTitles != null && exportFieldTitles.containsKey(fieldName)) {
                                            fieldTitle = (String)exportFieldTitles.get(fieldName);
                                        } else if (field != null && !field.getBoolean("hidden")) {
                                            String string3 = fieldTitle = field.getProperty("exportTitle") != null ? field.getProperty("exportTitle") : field.getTitle();
                                        }
                                        if (var16_55.equals("xml")) {
                                            if (separatorChar == null) {
                                                separatorChar = "";
                                            }
                                            if (fieldTitle == null) {
                                                fieldTitle = fieldName;
                                            }
                                            fieldTitle = fieldTitle.replaceAll("[$&<>() ]", separatorChar);
                                        }
                                        if (!receivedTitleMap) {
                                            fieldMap.put(fieldName, fieldTitle);
                                        }
                                        otherFields.put(field != null ? field.getName() : fieldName, fieldTitle);
                                    }
                                    if (!createExportFields || finalFields.contains(fieldName)) continue;
                                    finalFields.add(fieldName);
                                }
                                LinkedMap settings = new LinkedMap();
                                settings.put("exportAs", var16_55);
                                settings.put("lineBreakStyle", lineBreakStyle);
                                settings.put("exportDelimiter", dsResponse.getExportDelimiter());
                                settings.put("dataSource", ds2);
                                settings.put("exportFields", finalFields);
                                settings.put("exportHeader", dsResponse.getExportHeader());
                                settings.put("exportHeaderless", dsResponse.getExportHeaderless());
                                settings.put("exportFooter", dsResponse.getExportFooter());
                                settings.put("exportHeaderSpans", dsResponse.getParameter("exportHeaderSpans"));
                                settings.put("exportOtherFields", otherFields);
                                settings.put("formulaFields", dsResponse.getParameter("formulaFields"));
                                settings.put("formulaRemap", dsResponse.getParameter("formulaRemap"));
                                settings.put("exportDefaultBGColor", dsResponse.getParameter("exportDefaultBGColor"));
                                settings.put("exportAlternateRowBGColor", dsResponse.getParameter("exportAlternateRowBGColor"));
                                settings.put("exportRowBGColors", dsResponse.getParameter("exportRowBGColors"));
                                settings.put("exportColumnBGColors", dsResponse.getParameter("exportColumnBGColors"));
                                settings.put("exportRawValues", dsResponse.getParameter("exportRawValues"));
                                settings.put("exportCurrencySymbol", dsResponse.getParameter("exportCurrencySymbol"));
                                settings.put("exportHeaderHeight", dsResponse.getParameter("exportHeaderHeight"));
                                settings.put("exportFieldPixelWidths", dsResponse.getParameter("exportFieldPixelWidths"));
                                settings.put("exportWidthScale", dsResponse.getParameter("exportWidthScale"));
                                settings.put("exportWrapHeaderTitles", dsResponse.getParameter("exportWrapHeaderTitles"));
                                settings.put("exportAlignments", dsResponse.getParameter("exportAlignments"));
                                settings.put("exportStreaming", dsResponse.getParameter("exportStreaming"));
                                settings.put("exportPropertyIdentifier", dsResponse.getParameter("exportPropertyIdentifier"));
                                if (this.getValues(false) != null && this.getValues(false).size() != 0) {
                                    settings.put("useTitlesAsAttributeNames", true);
                                } else {
                                    settings.put("useTitlesAsAttributeNames", false);
                                }
                                DataExport de = DataExport.getDataExport((Map)settings, this);
                                OutputStream os = null;
                                String qname = null;
                                if (this.shouldExportToFilesystem()) {
                                    if (dsResponse.getExportTo() != null) {
                                        os = dsResponse.getExportTo();
                                    } else if (!config.getBoolean((Object)"export.allow.filesystem", false)) {
                                        log.warn("Cannot export to filesystem because the system is not configured to allow it. Add 'export.allow.filesystem: true' to your server.properties file to correct this");
                                        dsResponse.setExportToFilesystem(false);
                                    } else {
                                        qname = config.getPath("export.location");
                                        if (qname == null) {
                                            qname = "";
                                        }
                                        if (!qname.endsWith("/") && qname.length() > 0) {
                                            qname = qname + "/";
                                        }
                                        if (!(qname = qname + dsResponse.getExportPath()).endsWith("/") && qname.length() > 0) {
                                            qname = qname + "/";
                                        }
                                        qname = qname + dsResponse.getExportFilename();
                                        os = new BufferedOutputStream((OutputStream)((Object)new AtomicFileOutputStream(qname)));
                                        log.info("Trying to export to file " + qname);
                                    }
                                }
                                if (iterator == null) {
                                    iterator = data.iterator();
                                }
                                de.exportResultSet(iterator, fieldMap, os, dsResponse);
                                if (os != null) {
                                    os.close();
                                }
                            }
                            if (operationBinding == null || operationBinding.get("mail") == null || this.beenThroughMailProcessing) break block145;
                            this.beenThroughMailProcessing = true;
                            if (!(operationBinding.get("mail") instanceof List)) {
                                mailDefs = new ArrayList();
                                mailDefs.add(operationBinding.get("mail"));
                            } else {
                                mailDefs = (List)operationBinding.get("mail");
                            }
                            for (Map mail : mailDefs) {
                                Boolean multiple;
                                Object baseData = dsResponse.getData();
                                String msgData = (String)mail.get("messageData");
                                if (msgData != null) {
                                    baseData = Velocity.evaluate(msgData, Velocity.getStandardContextMap(this));
                                }
                                ArrayList<Object> data = null;
                                if (mail.get("multiple") != null && !(multiple = (Boolean)mail.get("multiple")).booleanValue()) {
                                    data = new ArrayList();
                                    if (baseData instanceof List) {
                                        data.add(((List)baseData).get(0));
                                    } else {
                                        data.add(baseData);
                                    }
                                }
                                if (data == null) {
                                    if (baseData instanceof List) {
                                        data = (ArrayList<Object>)baseData;
                                    } else {
                                        data = new ArrayList<Object>();
                                        if (baseData != null) {
                                            data.add(baseData);
                                        }
                                    }
                                }
                                String messageTemplate = (String)mail.get("messageTemplate");
                                String templateFile = (String)mail.get("templateFile");
                                if (templateFile == null && messageTemplate == null) {
                                    log.warn("DataSource " + this.getDataSourceName() + ", operation " + operationBinding.get("operationId") + ": A <mail> defiition is given, but it does not provide a templateFile property or a <messageTemplate> element. One of these is required - it will form the body of the email.");
                                    continue;
                                }
                                if (templateFile != null && messageTemplate != null) {
                                    log.warn("DataSource " + this.getDataSourceName() + ", operation " + operationBinding.get("operationId") + ": The <mail> defiition for this operation provides both a templateFile property and a <messageTemplate> element. Only one of these is allowed - ignoring the templateFile property.");
                                }
                                for (Object e : data) {
                                    void var16_59;
                                    HashMap item;
                                    block146: {
                                        if (e instanceof Map) {
                                            item = new HashMap((Map)e);
                                        } else {
                                            if (e instanceof JSONFilter) {
                                                Object object = ((JSONFilter)e).getObj();
                                                if (object instanceof Map) {
                                                    item = new HashMap((Map)object);
                                                    break block146;
                                                } else {
                                                    log.warn("Encountered non-Map object [" + object + "] while processing email definitions");
                                                    continue;
                                                }
                                            }
                                            log.warn("Encountered non-Map object [" + e + "] while processing email definitions");
                                            continue;
                                        }
                                    }
                                    TemplatedMailMessage msg = new TemplatedMailMessage();
                                    if (mail.get("from") != null) {
                                        msg.setFrom((String)mail.get("from"));
                                    }
                                    if (mail.get("replyTo") != null) {
                                        msg.setReplyTo((String)mail.get("replyTo"));
                                    }
                                    if (mail.get("to") != null) {
                                        msg.addRecipients((String)mail.get("to"), Message.RecipientType.TO);
                                    }
                                    if (mail.get("cc") != null) {
                                        msg.addRecipients((String)mail.get("cc"), Message.RecipientType.CC);
                                    }
                                    if (mail.get("bcc") != null) {
                                        msg.addRecipients((String)mail.get("bcc"), Message.RecipientType.BCC);
                                    }
                                    if (mail.get("subject") != null) {
                                        msg.setSubject((String)mail.get("subject"));
                                    }
                                    if (mail.get("contentType") != null) {
                                        msg.setContentType((String)mail.get("contentType"));
                                    }
                                    if (mail.get("encoding") != null) {
                                        msg.setEncoding((String)mail.get("encoding"));
                                    }
                                    Map contextMap = DataTools.mapMerge(Velocity.getStandardContextMap(this), item);
                                    msg.setContextMap(contextMap);
                                    msg.setMessageTemplate(messageTemplate);
                                    msg.setTemplateFile(templateFile);
                                    IOWrapper.installWrappersToContext(contextMap, (Map)var16_59);
                                    msg.buildMessage(new HashMap(), (String)null);
                                    try {
                                        msg.send();
                                    }
                                    catch (Exception e2) {
                                        log.warn(e2);
                                        e2.printStackTrace();
                                    }
                                }
                            }
                            break block145;
                        }
                        catch (Exception e) {
                            boolean bindingSkipRemainingQueue;
                            DataSource ds3 = this.getDataSource();
                            if (dsTransaction == null) throw e;
                            if (ds3 == null) throw e;
                            Map binding = ds3.getOperationBinding(this.getOperationType(), this.getOperationId());
                            boolean dsSkipRemainingQueue = "true".equals(ds3.getConfig().get("skipRemainingQueue"));
                            boolean bl = bindingSkipRemainingQueue = binding != null && "true".equals(binding.get("skipRemainingQueue"));
                            if (!dsSkipRemainingQueue) {
                                if (!bindingSkipRemainingQueue) throw e;
                            }
                            dsTransaction.skipRemainingQueue();
                            throw e;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var26_31 = null;
                        if (dsResponse != null && dsTransaction != null) {
                            DataSource ds4;
                            this.getDsTransaction().registerResponse(this, dsResponse);
                            if (dsResponse.statusIsError() && (ds4 = this.getDataSource()) != null) {
                                boolean bindingSkipRemainingQueue;
                                Map binding = ds4.getOperationBinding(this.getOperationType(), this.getOperationId());
                                boolean dsSkipRemainingQueue = "true".equals(ds4.getConfig().get("skipRemainingQueue"));
                                boolean bl = bindingSkipRemainingQueue = binding != null && "true".equals(binding.get("skipRemainingQueue"));
                                if (dsSkipRemainingQueue || bindingSkipRemainingQueue) {
                                    log.debug("DSRequest about to return response with error status and DataSource or operationBinding has skipRemainingQueue set. Calling DSTransaction.skipRemainingQueue()");
                                    dsTransaction.skipRemainingQueue();
                                }
                            }
                        }
                        if (this.getFreeOnExecute()) {
                            log.debug("About to free up resources for request of type " + this.getOperationType() + " on DataSource " + this.getDataSourceName());
                            this.freeResources();
                            if (this.getRPCManager() == null) {
                                this.freeQueueResources();
                            }
                            if (this.getRPCManager() != null) {
                                this.getRPCManager().freeDataSources();
                            }
                        } else {
                            log.debug("freeOnExecute is false for request of type " + this.getOperationType() + " on DataSource " + this.getDataSourceName() + " - not freeing resources!");
                        }
                        if (!this.trackTimings()) throw throwable;
                        this.recordTimingData("DSRequest processing", TimingLogType.END);
                        this.copyTimingDataToResponse(dsResponse);
                        throw throwable;
                    }
                }
                if (dsResponse.statusIsError() && (ds4 = this.getDataSource()) != null) {
                    boolean bindingSkipRemainingQueue;
                    Map binding = ds4.getOperationBinding(this.getOperationType(), this.getOperationId());
                    boolean dsSkipRemainingQueue = "true".equals(ds4.getConfig().get("skipRemainingQueue"));
                    boolean bl = bindingSkipRemainingQueue = binding != null && "true".equals(binding.get("skipRemainingQueue"));
                    if (dsSkipRemainingQueue || bindingSkipRemainingQueue) {
                        log.debug("DSRequest about to return response with error status and DataSource or operationBinding has skipRemainingQueue set. Calling DSTransaction.skipRemainingQueue()");
                        dsTransaction.skipRemainingQueue();
                    }
                }
            }
            if (this.getFreeOnExecute()) {
                log.debug("About to free up resources for request of type " + this.getOperationType() + " on DataSource " + this.getDataSourceName());
                this.freeResources();
                if (this.getRPCManager() == null) {
                    this.freeQueueResources();
                }
                if (this.getRPCManager() != null) {
                    this.getRPCManager().freeDataSources();
                }
            } else {
                log.debug("freeOnExecute is false for request of type " + this.getOperationType() + " on DataSource " + this.getDataSourceName() + " - not freeing resources!");
            }
            if (!this.trackTimings()) return i;
            this.recordTimingData("DSRequest processing", TimingLogType.END);
            this.copyTimingDataToResponse(dsResponse);
            return i;
        }
        boolean logAtDebug = DataSource.isFileSource(this.getOperationType()) || DataSource.isFileSourceSubrequest(this.getOperationType(), this.getOperationId());
        dsResponse.logData(logAtDebug);
        DSResponse i = dsResponse;
        Object var26_30 = null;
        if (dsResponse != null && dsTransaction != null) {
            DataSource ds4;
            this.getDsTransaction().registerResponse(this, dsResponse);
            if (dsResponse.statusIsError() && (ds4 = this.getDataSource()) != null) {
                boolean bindingSkipRemainingQueue;
                Map binding = ds4.getOperationBinding(this.getOperationType(), this.getOperationId());
                boolean dsSkipRemainingQueue = "true".equals(ds4.getConfig().get("skipRemainingQueue"));
                boolean bl = bindingSkipRemainingQueue = binding != null && "true".equals(binding.get("skipRemainingQueue"));
                if (dsSkipRemainingQueue || bindingSkipRemainingQueue) {
                    log.debug("DSRequest about to return response with error status and DataSource or operationBinding has skipRemainingQueue set. Calling DSTransaction.skipRemainingQueue()");
                    dsTransaction.skipRemainingQueue();
                }
            }
        }
        if (this.getFreeOnExecute()) {
            log.debug("About to free up resources for request of type " + this.getOperationType() + " on DataSource " + this.getDataSourceName());
            this.freeResources();
            if (this.getRPCManager() == null) {
                this.freeQueueResources();
            }
            if (this.getRPCManager() != null) {
                this.getRPCManager().freeDataSources();
            }
        } else {
            log.debug("freeOnExecute is false for request of type " + this.getOperationType() + " on DataSource " + this.getDataSourceName() + " - not freeing resources!");
        }
        if (!this.trackTimings()) return i;
        this.recordTimingData("DSRequest processing", TimingLogType.END);
        this.copyTimingDataToResponse(dsResponse);
        return i;
    }

    private void applyFieldValueExpressions() throws Exception {
        if (this.isClientRequest() && !config.getBoolean((Object)"dataSource.allowClientFieldValueExpressions", true)) {
            return;
        }
        Map expressions = this.getFieldValueExpressions();
        if (expressions == null) {
            return;
        }
        Date currentDate = new Date();
        Map<Object, Object> params = Velocity.getStandardContextMap(this);
        for (String fieldName : expressions.keySet()) {
            String value = ((String)expressions.get(fieldName)).trim();
            boolean isKey = this.getDataSource().getPrimaryKeys().contains(fieldName);
            Map valueset = this.getValues();
            if (isKey && !DataSource.isAdd(this.getOperationType()) && !DataSource.isCustom(this.getOperationType())) {
                valueset = this.getCriteria();
            }
            if (this.isClientRequest()) {
                Object evaluated;
                if ("$currentDate".equals(value)) {
                    valueset.put(fieldName, currentDate);
                    continue;
                }
                if ("$transactionDate".equals(value)) {
                    if (this.getDsTransaction() != null) {
                        valueset.put(fieldName, params.get("transactionDate"));
                        continue;
                    }
                    valueset.put(fieldName, currentDate);
                    continue;
                }
                if ("$userId".equals(value)) {
                    valueset.put(fieldName, this.getUserId());
                    continue;
                }
                if ("$masterId".equals(value)) {
                    valueset.put(fieldName, this.getMasterId(fieldName, true));
                    continue;
                }
                if (this.isValidResponseDataExpression(value)) {
                    evaluated = Velocity.evaluate(value, params, this.getOperationId(), this.getDataSource(), false, true);
                    valueset.put(fieldName, evaluated);
                    continue;
                }
                if (this.isValidResponsesExpression(value)) {
                    evaluated = Velocity.evaluate(value, params, this.getOperationId(), this.getDataSource(), false, true);
                    valueset.put(fieldName, evaluated);
                    continue;
                }
                String msg = "Value '" + value + "' not allowed in fieldValueExpression: client-initiated fieldValueExpressions may only be one of the documented fixed variable names, prefixed with '$'.  Please scan the client-side docs for 'fieldValueExpressions'";
                log.warn(msg);
                throw new Exception(msg);
            }
            System.out.println("Evaluating '" + value + "' to '" + Velocity.evaluate(value, params) + "'");
            Velocity.setMasterIdHandler(params, this, fieldName);
            valueset.put(fieldName, Velocity.evaluate(value, params));
        }
    }

    public boolean isValidResponseDataExpression(String value) {
        Matcher matcher = responseDataPattern.matcher(value);
        return matcher.matches();
    }

    public boolean isValidResponsesExpression(String value) {
        Matcher matcher = responsesPattern.matcher(value);
        return matcher.matches();
    }

    public Object getMasterId(String fieldName, boolean warn) throws Exception {
        DSTransaction dsTransaction = this.getDsTransaction();
        if (dsTransaction == null) {
            if (warn) {
                log.warn("$masterId cannot be determined - no DSTransaction");
            }
            return null;
        }
        DataSource ds = this.getDataSource();
        if (ds == null) {
            if (warn) {
                log.warn("$masterId cannot be determined - no DataSource on this DSRequest");
            }
            return null;
        }
        DSField field = ds.getField(fieldName);
        if (field == null) {
            if (warn) {
                log.warn("$masterId cannot be determined - field '" + fieldName + "' not found");
            }
            return null;
        }
        if (field.getForeignKey() == null) {
            if (warn) {
                log.warn("$masterId cannot be determined - field '" + fieldName + "' does not declare a foreignKey");
            }
            return null;
        }
        String[] fkElements = field.getForeignKey().split("\\.");
        DataSource otherDS = null;
        String otherFieldName = null;
        if (fkElements.length == 1) {
            otherDS = ds;
            otherFieldName = fkElements[0];
        } else {
            otherDS = dsTransaction.getDataSource(fkElements[0]);
            otherFieldName = fkElements[1];
        }
        if (otherDS == null) {
            if (warn) {
                log.warn("$masterId cannot be determined for field '" + fieldName + "' - the foreignKey definition (" + field.getForeignKey() + ") does not name a DataSource known to the system");
            }
            return null;
        }
        if (otherDS.getField(otherFieldName) == null) {
            if (warn) {
                log.warn("$masterId cannot be determined for field '" + fieldName + "' - the foreignKey definition (" + field.getForeignKey() + ") targets a field  that does not exist on the target DataSource");
            }
            return null;
        }
        DSResponse lastResponse = (DSResponse)dsTransaction.findLastResponse(otherDS.getName(), "add");
        if (lastResponse == null) {
            if (warn) {
                log.warn("$masterId cannot be determined for field '" + fieldName + "' - no prior \"add\" operation to the master DataSource " + otherDS.getName() + " was found");
            }
            return null;
        }
        Map<String, Object> record = lastResponse.getRecord();
        if (!record.containsKey(otherFieldName)) {
            if (warn) {
                log.warn("$masterId cannot be determined for field '" + fieldName + "' - the response data for the prior \"add\" operation to the master DataSource " + otherDS.getName() + " did not contain a value for field \"" + otherFieldName + "\"");
            }
            return null;
        }
        return record.get(otherFieldName);
    }

    public Map getFieldValueExpressions() {
        return (Map)this.getParameter("fieldValueExpressions");
    }

    public DSRequest setFieldValueExpressions(Map fieldValueExpressions) {
        this.setParameter("fieldValueExpressions", fieldValueExpressions);
        return this;
    }

    public void buildFieldData(boolean overwrite) throws Exception {
        if (!overwrite && this.preparedFieldData) {
            return;
        }
        if (DataSource.isFetch(this.getOperationType()) || DataSource.isAddOrUpdate(this.getOperationType())) {
            this.recordTimingData("includeFrom processing", TimingLogType.START);
            this.includeFrom = this.buildIncludeFromDefinitions(this.getDataSource(), true, null);
            this.recordTimingData("includeFrom processing", TimingLogType.END);
        }
        if (DataSource.isFetch(this.getOperationType())) {
            this.recordTimingData("groupBy processing", TimingLogType.START);
            this.buildSummaryFields();
            this.recordTimingData("groupBy processing", TimingLogType.END);
        }
        this.preparedFieldData = true;
    }

    private DSRequest trimCriteria() throws Exception {
        String opType = this.getOperationType();
        if (!this.getAllowMultiUpdate() && (DataSource.isRemove(opType) || DataSource.isUpdate(opType) || "replace".equals(opType))) {
            Map criteria = this.getCriteria();
            List<String> pkList = this.getDataSource().getPrimaryKeys();
            if (this.getIsAdvancedCriteria()) {
                if ((criteria = this._trimCriteria(criteria, pkList)) != null) {
                    criteria.put("_constructor", "AdvancedCriteria");
                }
                this.setCriteria(criteria);
            } else {
                this.setCriteria(DataTools.subsetMap(criteria, pkList));
            }
        }
        return this;
    }

    private Map _trimCriteria(Map criteria, List pkList) {
        if (criteria == null) {
            return null;
        }
        if (pkList == null) {
            return criteria;
        }
        if (criteria.containsKey("criteria")) {
            ArrayList newCrit = new ArrayList();
            for (Object c : (List)criteria.get("criteria")) {
                if ((c = this._trimCriteria((Map)c, pkList)) == null) continue;
                newCrit.add(c);
            }
            criteria.put("criteria", newCrit);
            return criteria;
        }
        if (criteria.containsKey("fieldName")) {
            String fieldName = (String)criteria.get("fieldName");
            if (pkList.contains(fieldName)) {
                return criteria;
            }
            return null;
        }
        return null;
    }

    public DSRequest copyExportSettingsToResponse(DSResponse dsResponse) {
        dsResponse.setExportResults(this.getExportResults());
        if (dsResponse.getExportAs() == null || dsResponse.getExportAs() == "") {
            dsResponse.setExportAs(this.getExportAs());
        }
        if (dsResponse.getExportFilename() == null || dsResponse.getExportFilename() == "") {
            dsResponse.setExportFilename(this.getExportFilename());
        }
        if (dsResponse.getExportPath() == null || dsResponse.getExportPath() == "") {
            dsResponse.setExportPath(this.getExportPath());
        }
        if (dsResponse.getExportDelimiter() == null || dsResponse.getExportDelimiter() == "") {
            dsResponse.setExportDelimiter(this.getExportDelimiter());
        }
        if (dsResponse.getExportDisplay() == null || dsResponse.getExportDisplay() == "") {
            dsResponse.setExportDisplay(this.getExportDisplay());
        }
        if (dsResponse.getLineBreakStyle() == null || dsResponse.getLineBreakStyle() == "") {
            dsResponse.setLineBreakStyle(this.getLineBreakStyle());
        }
        if (dsResponse.getExportFields() == null || dsResponse.getExportFields().isEmpty()) {
            dsResponse.setExportFields(this.getExportFields());
        }
        if (dsResponse.getExportFieldTitles() == null || dsResponse.getExportFieldTitles().isEmpty()) {
            dsResponse.setExportFieldTitles(this.getExportFieldTitles());
        }
        if (dsResponse.getExportHeader() == null || dsResponse.getExportHeader().length() == 0) {
            dsResponse.setExportHeader(this.getExportHeader());
        }
        if (!dsResponse.getExportHeaderless()) {
            dsResponse.setExportHeaderless(this.getExportHeaderless());
        }
        if (dsResponse.getExportFooter() == null || dsResponse.getExportFooter().length() == 0) {
            dsResponse.setExportFooter(this.getExportFooter());
        }
        if (dsResponse.getExportTitleSeparatorChar() == null) {
            dsResponse.setExportTitleSeparatorChar(this.getExportTitleSeparatorChar());
        }
        if (dsResponse.shouldExportToClient() == null) {
            dsResponse.setExportToClient(this.shouldExportToClient());
        }
        if (dsResponse.shouldExportToFilesystem() == null) {
            dsResponse.setExportToFilesystem(this.shouldExportToFilesystem());
        }
        if (dsResponse.getExportTo() == null) {
            dsResponse.setExportTo(this.getExportTo());
        }
        if (dsResponse.getParameter("exportHeaderSpans") == null) {
            dsResponse.setParameter("exportHeaderSpans", this.getParameter("exportHeaderSpans"));
        }
        if (dsResponse.getParameter("exportOtherFields") == null) {
            dsResponse.setParameter("exportOtherFields", this.getParameter("exportOtherFields"));
        }
        if (dsResponse.getExportDatesAsFormattedString() == null) {
            dsResponse.setExportDatesAsFormattedString(this.getExportDatesAsFormattedString());
        }
        if (dsResponse.getParameter("formulaFields") == null) {
            dsResponse.setParameter("formulaFields", this.getParameter("formulaFields"));
        }
        if (dsResponse.getParameter("formulaRemap") == null) {
            dsResponse.setParameter("formulaRemap", this.getParameter("formulaRemap"));
        }
        if (dsResponse.getParameter("exportDefaultBGColor") == null) {
            dsResponse.setParameter("exportDefaultBGColor", this.getParameter("exportDefaultBGColor"));
        }
        if (dsResponse.getParameter("exportAlternateRowBGColor") == null) {
            dsResponse.setParameter("exportAlternateRowBGColor", this.getParameter("exportAlternateRowBGColor"));
        }
        if (dsResponse.getParameter("exportRowBGColors") == null) {
            dsResponse.setParameter("exportRowBGColors", this.getParameter("exportRowBGColors"));
        }
        if (dsResponse.getParameter("exportColumnBGColors") == null) {
            dsResponse.setParameter("exportColumnBGColors", this.getParameter("exportColumnBGColors"));
        }
        if (dsResponse.getParameter("exportRawValues") == null) {
            dsResponse.setParameter("exportRawValues", this.getParameter("exportRawValues"));
        }
        if (dsResponse.getParameter("exportCurrencySymbol") == null) {
            dsResponse.setParameter("exportCurrencySymbol", this.getParameter("exportCurrencySymbol"));
        }
        if (dsResponse.getParameter("exportHeaderHeight") == null) {
            dsResponse.setParameter("exportHeaderHeight", this.getParameter("exportHeaderHeight"));
        }
        if (dsResponse.getParameter("exportFieldPixelWidths") == null) {
            dsResponse.setParameter("exportFieldPixelWidths", this.getParameter("exportFieldPixelWidths"));
        }
        if (dsResponse.getParameter("exportWidthScale") == null) {
            dsResponse.setParameter("exportWidthScale", this.getParameter("exportWidthScale"));
        }
        if (dsResponse.getParameter("exportWrapHeaderTitles") == null) {
            dsResponse.setParameter("exportWrapHeaderTitles", this.getParameter("exportWrapHeaderTitles"));
        }
        if (dsResponse.getParameter("exportAlignments") == null) {
            dsResponse.setParameter("exportAlignments", this.getParameter("exportAlignments"));
        }
        if (dsResponse.getParameter("exportStreaming") == null) {
            dsResponse.setParameter("exportStreaming", this.getParameter("exportStreaming"));
        }
        if (dsResponse.getParameter("exportPropertyIdentifier") == null) {
            dsResponse.setParameter("exportPropertyIdentifier", this.getParameter("exportPropertyIdentifier"));
        }
        return this;
    }

    public DSRequest addToTemplateContext(String name, Object value) {
        this.templateContext.put(name, value);
        return this;
    }

    public Map getTemplateContext() {
        return this.templateContext;
    }

    public void finalize() throws Throwable {
        if (!this.resourcesFreed) {
            this.freeResources();
        }
    }

    public String getAppID() {
        return (String)this.getParameter("appID");
    }

    public DSRequest setAppID(String appID) {
        this.setParameter("appID", appID);
        this.app = null;
        return this;
    }

    public AppBase getApp() throws Exception {
        if (this.app == null) {
            this.app = AppBase.findByAppID(this.getAppID());
        }
        return this.app;
    }

    public DSRequest setAllowMultiUpdate(boolean newValue) {
        this._allowMultiUpdate = newValue;
        return this;
    }

    public boolean isAllowMultiUpdateExplicitlySet() {
        return this._allowMultiUpdate != null;
    }

    public boolean getAllowMultiUpdate() {
        Boolean multiUpdate;
        Map opBinding = null;
        try {
            opBinding = this.getDataSource().getOperationBinding(this.getOperationType(), this.getOperationId());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (opBinding != null && (multiUpdate = (Boolean)opBinding.get("allowMultiUpdate")) != null) {
            return multiUpdate;
        }
        if (this._allowMultiUpdate != null) {
            return this._allowMultiUpdate;
        }
        String defaultMultiUpdatePolicy = null;
        try {
            defaultMultiUpdatePolicy = (String)this.getDataSource().getConfig().get("defaultMultiUpdatePolicy");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (defaultMultiUpdatePolicy == null || "".equals(defaultMultiUpdatePolicy.trim())) {
            defaultMultiUpdatePolicy = config.getString("datasources.defaultMultiUpdatePolicy", "rpcManager");
        }
        if ("never".equalsIgnoreCase(defaultMultiUpdatePolicy)) {
            return true;
        }
        if ("clientRequest".equalsIgnoreCase(defaultMultiUpdatePolicy)) {
            return !this.isClientRequest();
        }
        if ("rpcManager".equalsIgnoreCase(defaultMultiUpdatePolicy)) {
            return this.getRPCManager() == null;
        }
        if ("always".equals(defaultMultiUpdatePolicy)) {
            return false;
        }
        return false;
    }

    public Object constraints() {
        return this.constraints;
    }

    public DSRequest addConstraints(Object obj) {
        List newConstraints;
        if (obj == null) {
            return this;
        }
        if (this.constraints == null) {
            this.constraints = new ArrayList();
        }
        if ((newConstraints = DataTools.makeListIfSingle(obj)).contains("*")) {
            this.constraints = null;
            return this;
        }
        DataTools.addDisjunctionToSet((List)this.constraints, newConstraints);
        return this;
    }

    public List outputs() {
        return this.outputs;
    }

    public List getOutputs() {
        return this.outputs;
    }

    public DSRequest setOutputs(List outputs) {
        this.outputs = outputs;
        return this;
    }

    public DSRequest addOutputs(Object obj) {
        List addedOutputs;
        if (obj == null) {
            return this;
        }
        if (this.outputs == null) {
            this.outputs = new ArrayList();
        }
        if ((addedOutputs = DataTools.makeListIfSingle(obj)).contains("*")) {
            this.outputs = null;
            return this;
        }
        DataTools.addDisjunctionToSet(this.outputs, addedOutputs);
        return this;
    }

    public List getAdditionalOutputs() {
        if (this.additionalOutputs == null) {
            this.additionalOutputs = new ArrayList();
            String additionalOutputsString = (String)this.getParameter("additionalOutputs");
            if (additionalOutputsString != null) {
                String[] additionalOutputsList;
                for (String singleAdditionalOutput : additionalOutputsList = additionalOutputsString.split(",")) {
                    if (!singleAdditionalOutput.contains("!")) continue;
                    String[] properties = singleAdditionalOutput.split("!");
                    HashMap<String, String> fieldData = new HashMap<String, String>();
                    fieldData.put("includeFrom", properties[1]);
                    if (properties[0] == null || properties[0].trim().equals("")) {
                        if (properties[1].contains(".")) {
                            fieldData.put("name", properties[1].substring(properties[1].lastIndexOf(".") + 1));
                        } else {
                            fieldData.put("name", properties[1]);
                        }
                    } else {
                        fieldData.put("name", properties[0]);
                    }
                    fieldData.put("type", "text");
                    this.additionalOutputs.add(new DSField(fieldData));
                }
            }
        }
        return this.additionalOutputs;
    }

    public Map operationConfig() {
        return this.operationConfig;
    }

    public DSRequest setOperationConfig(Map operationConfig) {
        this.operationConfig = operationConfig;
        return this;
    }

    public Map getOperationConfig() {
        return this.operationConfig;
    }

    public Object getOperationProperty(String property) {
        if (this.operationConfig == null || property == null) {
            return null;
        }
        return this.operationConfig.get(property);
    }

    public Object getOperationProperty(String property, Object defaultValue) {
        Object value = this.getOperationProperty(property);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public DSRequest setOperationProperty(String property, Object value) {
        if (this.operationConfig == null) {
            this.operationConfig = new HashMap();
        }
        if (property != null) {
            this.operationConfig.put(property, value);
        }
        return this;
    }

    public boolean forceInvalidateCache() {
        return this.forceInvalidateCache;
    }

    public DSRequest forceInvalidateCache(boolean value) {
        this.forceInvalidateCache = value;
        return this;
    }

    public DSRequest setValidatedValues(Object values) {
        if (this.requestData.containsKey("_unvalidatedValues")) {
            log.warn("setValidatedValues called more than once for this DSRequest object");
            return this;
        }
        this.requestData.put("_unvalidatedValues", this.getRawValues());
        this.setValues(values);
        return this;
    }

    public Object getUnvalidatedValues() {
        if (this.requestData.containsKey("_unvalidatedValues")) {
            return this.requestData.get("_unvalidatedValues");
        }
        return this.getRawValues();
    }

    public boolean getExportResults() {
        if (this.getParameter("exportResults") == null) {
            return false;
        }
        return (Boolean)this.getParameter("exportResults");
    }

    public DSRequest setExportResults(Boolean exportResults) {
        if (exportResults == null) {
            exportResults = Boolean.FALSE;
        }
        this.setParameter("exportResults", exportResults);
        return this;
    }

    public DSRequest setExportResults(boolean exportResults) {
        this.setParameter("exportResults", new Boolean(exportResults));
        return this;
    }

    public String getExportAs() {
        return (String)this.getParameter("exportAs");
    }

    public DSRequest setExportAs(String exportAs) {
        this.setParameter("exportAs", exportAs);
        return this;
    }

    public String getExportDelimiter() {
        return (String)this.getParameter("exportDelimiter");
    }

    public DSRequest setExportDelimiter(String exportDelimiter) {
        this.setParameter("exportDelimiter", exportDelimiter);
        return this;
    }

    public String getExportTitleSeparatorChar() {
        return (String)this.getParameter("exportTitleSeparatorChar");
    }

    public DSRequest setExportTitleSeparatorChar(String exportTitleSeparatorChar) {
        this.setParameter("exportTitleSeparatorChar", exportTitleSeparatorChar);
        return this;
    }

    public String getExportFilename() {
        return (String)this.getParameter("exportFilename");
    }

    public DSRequest setExportFilename(String exportFilename) {
        this.setParameter("exportFilename", exportFilename);
        return this;
    }

    public String getExportPath() {
        return (String)this.getParameter("exportPath");
    }

    public DSRequest setExportPath(String exportPath) {
        this.setParameter("exportPath", exportPath);
        return this;
    }

    public String getExportDisplay() {
        return (String)this.getParameter("exportDisplay");
    }

    public DSRequest setExportDisplay(String exportDisplay) {
        this.setParameter("exportDisplay", exportDisplay);
        return this;
    }

    public String getLineBreakStyle() {
        return (String)this.getParameter("lineBreakStyle");
    }

    public DSRequest setLineBreakStyle(String lineBreakStyle) {
        this.setParameter("lineBreakStyle", lineBreakStyle);
        return this;
    }

    public List getExportFields() {
        return (List)this.getParameter("exportFields");
    }

    public DSRequest setExportFields(List exportFields) {
        this.setParameter("exportFields", exportFields);
        return this;
    }

    public Map getExportFieldTitles() {
        return (Map)this.getParameter("exportFieldTitles");
    }

    public DSRequest setExportFieldTitles(Map exportFieldTitles) {
        this.setParameter("exportFieldTitles", exportFieldTitles);
        return this;
    }

    public String getExportHeader() {
        return (String)this.getParameter("exportHeader");
    }

    public DSRequest setExportHeader(String exportHeader) {
        this.setParameter("exportHeader", exportHeader);
        return this;
    }

    public boolean getExportHeaderless() {
        return DataTools.asBoolean(this.getParameter("exportHeaderless"), false);
    }

    public DSRequest setExportHeaderless(boolean exportHeaderless) {
        this.setParameter("exportHeaderless", exportHeaderless);
        return this;
    }

    public String getExportFooter() {
        return (String)this.getParameter("exportFooter");
    }

    public DSRequest setExportFooter(String exportFooter) {
        this.setParameter("exportFooter", exportFooter);
        return this;
    }

    public DSRequest setExportDatesAsFormattedString(boolean exportDatesAsFormattedString) {
        return this.setExportDatesAsFormattedString(new Boolean(exportDatesAsFormattedString));
    }

    public DSRequest setExportDatesAsFormattedString(Boolean exportDatesAsFormattedString) {
        this.setParameter("exportDatesAsFormattedString", exportDatesAsFormattedString);
        return this;
    }

    public Boolean getExportDatesAsFormattedString() {
        return (Boolean)this.getParameter("exportDatesAsFormattedString");
    }

    public DSRequest setStreamResults(boolean streamResults) {
        this.setParameter("streamResults", streamResults);
        return this;
    }

    public boolean shouldStreamResults() {
        return DataTools.asBoolean(this.getParameter("streamResults"), false);
    }

    public DSRequest setExportToFilesystem(boolean exportToFilesystem) {
        this.setParameter("exportToFilesystem", exportToFilesystem);
        return this;
    }

    public boolean shouldExportToFilesystem() {
        return DataTools.asBoolean(this.getParameter("exportToFilesystem"), false);
    }

    public DSRequest setExportToClient(boolean exportToClient) {
        this.setParameter("exportToClient", exportToClient);
        return this;
    }

    public boolean shouldExportToClient() {
        return DataTools.asBoolean(this.getParameter("exportToClient"), true);
    }

    public DSRequest setExportDefaultBGColor(String exportDefaultBGColor) {
        this.setParameter("exportDefaultBGColor", exportDefaultBGColor);
        return this;
    }

    public String getExportDefaultBGColor() {
        return (String)this.getParameter("exportDefaultBGColor");
    }

    public DSRequest setExportAlternateRowBGColor(String exportAlternateRowBGColor) {
        this.setParameter("exportAlternateRowBGColor", exportAlternateRowBGColor);
        return this;
    }

    public String getExportAlternateRowBGColor() {
        return (String)this.getParameter("exportAlternateRowBGColor");
    }

    public DSRequest setExportRowBGColors(Map exportRowBGColors) {
        this.setParameter("exportRowBGColors", exportRowBGColors);
        return this;
    }

    public Map getExportRowBGColors() {
        return (Map)this.getParameter("exportRowBGColors");
    }

    public DSRequest setExportColumnBGColors(Map exportColumnBGColors) {
        this.setParameter("exportColumnBGColors", exportColumnBGColors);
        return this;
    }

    public Map getExportColumnBGColors() {
        return (Map)this.getParameter("exportColumnBGColors");
    }

    public OutputStream getExportTo() {
        return this.exportOutputStream;
    }

    public DSRequest setExportTo(OutputStream exportOutputStream) {
        this.exportOutputStream = exportOutputStream;
        if (exportOutputStream != null) {
            this.setExportToFilesystem(true);
        }
        return this;
    }

    public Boolean getREST() {
        return Boolean.TRUE.equals((Boolean)this.getParameter("REST"));
    }

    public DSRequest setREST(Boolean isREST) {
        this.setParameter("REST", isREST);
        return this;
    }

    public String getDataFormat() {
        return (String)this.getParameter("dataFormat");
    }

    public DSRequest setDataFormat(String dataFormat) {
        if (!"xml".equalsIgnoreCase(dataFormat) && !"json".equalsIgnoreCase(dataFormat)) {
            throw new IllegalArgumentException("Accepted values: xml, json. Passed value:" + dataFormat);
        }
        this.setParameter("dataFormat", dataFormat.toLowerCase());
        return this;
    }

    public Boolean getWrapJSONResponses() {
        return Boolean.TRUE.equals(this.getParameter("wrapJSONResponses"));
    }

    public DSRequest setWrapJSONResponses(Boolean wrapJSONResponses) {
        this.setParameter("wrapJSONResponses", wrapJSONResponses);
        return this;
    }

    public String getJsonPrefix() {
        return (String)this.getParameter("jsonPrefix");
    }

    public DSRequest setJsonPrefix(String jsonPrefix) {
        this.setParameter("jsonPrefix", jsonPrefix);
        return this;
    }

    public String getJsonSuffix() {
        return (String)this.getParameter("jsonSuffix");
    }

    public DSRequest setJsonSuffix(String jsonSuffix) {
        this.setParameter("jsonSuffix", jsonSuffix);
        return this;
    }

    boolean passesSecurityChecks() throws Exception {
        return this.passesSecurityChecks(null, null);
    }

    boolean passesSecurityChecks(DataSource ds, String fieldName) throws Exception {
        return DeclarativeSecurity.dsRequestPassesSecurityChecks(this, ds, fieldName);
    }

    boolean checkRelatedSecurity(DataSource ds, String fieldName) throws Exception {
        List includeFromList = null;
        includeFromList = fieldName != null ? this.buildIncludeFromDefinitions(ds, false, fieldName) : this.includeFrom;
        for (IncludeFromDefinition incFrom : includeFromList) {
            if (incFrom.getDataSources() == null || incFrom.getDataSources().length == 0) continue;
            for (Relation r = incFrom.getRelation(); r != null; r = r.getNextRelation()) {
                DataSource relatedDS = r.getToDataSource();
                for (DSField toField : r.getToFields()) {
                    if (!this.passesSecurityChecks(relatedDS, toField.getName())) {
                        this.securityFailureMessage = "Security check on related DataSource '" + relatedDS.getName() + "', required for included field '" + toField.getName() + "', failed.  Failure message is: \"" + this.securityFailureMessage + "\"";
                        return false;
                    }
                    if (relatedDS.getName().equals(incFrom.getDataSourceName()) || this.checkedDataSources.contains(relatedDS.getName())) continue;
                    this.checkedDataSources.add(relatedDS.getName());
                }
            }
            if (!this.passesSecurityChecks(incFrom.getDataSource(), incFrom.getIncludedFieldName())) {
                this.securityFailureMessage = "Security check on related DataSource '" + ds.getName() + "', required for included field '" + incFrom.getThisFieldName() + "', failed.  Failure message is: \"" + this.securityFailureMessage + "\"";
                return false;
            }
            if (this.checkedDataSources.contains(incFrom.getDataSourceName())) continue;
            this.checkedDataSources.add(incFrom.getDataSourceName());
        }
        return true;
    }

    public DSRequest removeField(String fieldName, boolean isFetch) {
        if (isFetch) {
            if (this.droppedFields == null) {
                this.droppedFields = new ArrayList();
            }
            if (!this.droppedFields.contains(fieldName)) {
                this.droppedFields.add(fieldName);
            }
            this.getCriteria(false).remove(fieldName);
            Iterator i = this.includeFrom.iterator();
            while (i.hasNext()) {
                IncludeFromDefinition incFrom = (IncludeFromDefinition)i.next();
                if (!fieldName.equals(incFrom.getThisFieldName())) continue;
                i.remove();
                break;
            }
        } else {
            this.getValues(false).remove(fieldName);
        }
        return this;
    }

    public Boolean getAuthenticated() {
        if (this.getDsTransaction() != null) {
            return this.getDsTransaction().getAuthenticated();
        }
        return new Boolean(true);
    }

    public List<String> getUserRoles() {
        if (this.getDsTransaction() != null) {
            return this.getDsTransaction().getUserRoles();
        }
        return this.userRoles;
    }

    public DSRequest setUserRoles(String rolesString) {
        List<String> list = DataTools.commaSeparatedStringToList(rolesString);
        return this.setUserRoles(list);
    }

    public DSRequest setUserRoles(String ... roles) {
        List<String> list = Arrays.asList(roles);
        return this.setUserRoles(list);
    }

    public DSRequest setUserRoles(List<String> userRoles) {
        if (this.getDsTransaction() != null) {
            this.getDsTransaction().setUserRoles(userRoles);
        } else {
            this.userRoles = userRoles;
        }
        this.setClientRequest(true);
        return this;
    }

    public String getUserId() {
        if (this.getDsTransaction() != null) {
            if (this.getDsTransaction().getUserId() != null) {
                return this.getDsTransaction().getUserId();
            }
            if (this.getRPCManager() != null && this.getRPCManager().getContext() != null && this.getRPCManager().getContext().request != null) {
                return this.getRPCManager().getContext().request.getRemoteUser();
            }
        }
        return this.userId;
    }

    public DSRequest setUserId(String userId) {
        if (this.getDsTransaction() != null) {
            log.warn("setUserId() called on a DSRequest that has a DSTransaction.  User ID is managed at the transaction level for DSRequests like this");
        } else {
            this.userId = userId;
        }
        this.setClientRequest(true);
        return this;
    }

    public boolean isUserInRole(String roles, HttpServletRequest req) {
        List<String> userRoles = this.getUserRoles();
        if (userRoles == null && req == null) {
            return false;
        }
        String superUserRole = StringUtils.trim((String)config.getString("authentication.superuserRole"));
        if (StringUtils.isNotBlank((String)superUserRole) && (userRoles == null && req.isUserInRole(superUserRole) || userRoles.contains(superUserRole))) {
            return true;
        }
        boolean requireAllRoles = config.getBoolean((Object)"authentication.requireAllRoles", false);
        List<String> rolesList = DataTools.commaSeparatedStringToList(roles);
        for (String role : rolesList) {
            boolean inRole = userRoles != null ? userRoles.contains(role) : req.isUserInRole(role);
            if (inRole) {
                return true;
            }
            if (!requireAllRoles) continue;
            return false;
        }
        return requireAllRoles;
    }

    public DSRequest inheritTemplateContext(RPCManager rpc) {
        this.setRPCManager(rpc);
        this.context = rpc.getContext();
        this.setClientRequest(false);
        return this;
    }

    public DSRequest inheritClientContext(DSRequest req) {
        if (req != null) {
            this.context = req.context;
            this.setRPCManager(req.getRPCManager());
            this.setClientRequest(req.isClientRequest());
        }
        return this;
    }

    public HttpServletRequest getHttpServletRequest() {
        return this.context == null ? null : this.context.request;
    }

    public ServletContext getServletContext() {
        return this.context == null ? null : this.context.servletContext;
    }

    @Deprecated
    public DSRequest setRequestContext(RequestContext context) {
        this.context = context;
        return this;
    }

    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    public Iterator getAttributeNames() {
        return this.attributes.keySet().iterator();
    }

    public DSRequest setAttribute(String key, Object value) {
        this.attributes.put(key, value);
        return this;
    }

    public DSRequest removeAttribute(String key) {
        this.attributes.remove(key);
        return this;
    }

    private DSRequest hashFieldValues() throws Exception {
        if (this.getDataSource() == null) {
            return this;
        }
        List<DSField> fields = this.getDataSource().getFields();
        for (DSField field : fields) {
            String value;
            if (field.get("storeWithHash") == null || (value = (String)this.getValues().get(field.getName())) == null) continue;
            value = DataTools.hashValue(value, (String)field.get("storeWithHash"));
            this.getValues().put(field.getName(), value);
        }
        return this;
    }

    protected DSRequest removeIllegalValues() throws Exception {
        DataSource ds = this.getDataSource();
        if (ds == null) {
            return this;
        }
        for (DSField field : ds.getFields()) {
            if (field.getBoolean("canSave", true)) continue;
            this.removeField(field.getName(), false);
        }
        return this;
    }

    private DSRequest populateModifierAndCreatorFields(boolean addMode) throws Exception {
        if (this.getDataSource() == null) {
            return this;
        }
        String modifier = this.getUserId();
        Date modifierTimestamp = this.getRPCManager() != null ? (Date)this.getRPCManager().getFromTemplateContext("transactionDate") : new Date();
        if (this.getValues() == null) {
            this.setValues(new HashMap());
        }
        List<DSField> fields = this.getDataSource().getFields();
        for (DSField field : fields) {
            if ("modifier".equals(field.getType())) {
                this.getValues().put(field.getName(), modifier);
                continue;
            }
            if ("modifierTimestamp".equals(field.getType())) {
                this.getValues().put(field.getName(), modifierTimestamp);
                continue;
            }
            if ("creator".equals(field.getType())) {
                if (addMode) {
                    this.getValues().put(field.getName(), modifier);
                    continue;
                }
                this.getValues().remove(field.getName());
                continue;
            }
            if (!"creatorTimestamp".equals(field.getType())) continue;
            if (addMode) {
                this.getValues().put(field.getName(), modifierTimestamp);
                continue;
            }
            this.getValues().remove(field.getName());
        }
        return this;
    }

    public Boolean shouldJoinTransaction() {
        return this.joinTransaction;
    }

    public DSRequest setJoinTransaction(Boolean newValue) throws DSRequestAlreadyStartedException {
        if (this.requestStarted) {
            throw new DSRequestAlreadyStartedException("Request processing has started;  join transactions setting cannot be changed");
        }
        this.joinTransaction = newValue;
        return this;
    }

    public DSRequest registerFreeResourcesHandler(FreeResourcesHandler handler) {
        if (this.freeResourcesHandler == null || !(this.freeResourcesHandler instanceof DataSource) || handler instanceof DataSource) {
            if (this.freeResourcesHandler != null) {
                log.debug("Clobbering existing FreeResourcesHandler of type '" + this.freeResourcesHandler.getClass().getName() + "' with a '" + handler.getClass().getName() + "'");
            }
            this.freeResourcesHandler = handler;
        } else {
            log.debug("Ignored request to change the FreeResourcesHandler from a '" + this.freeResourcesHandler.getClass().getName() + "' to a '" + handler.getClass().getName() + "'");
        }
        return this;
    }

    @Override
    public DSRequest freeResources() {
        if (!this.resourcesFreed && this.freeResourcesHandler != null && this.getPrimaryDSRequest() == null) {
            this.freeResourcesHandler.freeResources(this);
        } else {
            log.debug("Ignoring freeResources call because " + (this.resourcesFreed ? "they have already been freed" : "this is not a primary request!"));
        }
        this.resourcesFreed = true;
        return this;
    }

    @Override
    public DSRequest freeQueueResources() {
        if (!this.queueResourcesFreed && this.freeResourcesHandler != null && this.getPrimaryDSRequest() == null) {
            this.freeResourcesHandler.freeQueueResources(this);
        } else {
            log.debug("Ignoring freeQueueResources call because " + (this.queueResourcesFreed ? "they have already been freed" : "this is not a primary request!"));
        }
        this.queueResourcesFreed = true;
        return this;
    }

    @Override
    public DSRequest freeAllResources() {
        if (!this.requestStarted) {
            log.warn("freeAllResources() called for a DSRequest that has not yet started processing - ignoring");
            return this;
        }
        this.freeResources();
        this.freeQueueResources();
        return this;
    }

    @Override
    public boolean shouldFreeOnExecute() {
        return this.getFreeOnExecute();
    }

    @Override
    public void commit(DSTransaction dsTransaction) throws Exception {
        this.getDataSource().commit(dsTransaction);
    }

    @Override
    public void rollback(DSTransaction dsTransaction) throws Exception {
        this.getDataSource().rollback(dsTransaction);
    }

    public boolean getFreeOnExecute() {
        return this.freeOnExecute == null ? true : this.freeOnExecute;
    }

    public DSRequest setFreeOnExecute(boolean freeOnExecute) {
        this.freeOnExecute = freeOnExecute;
        return this;
    }

    public boolean isFreeOnExecuteSet() {
        return this.freeOnExecute != null;
    }

    public List getIncludeFrom() {
        return this.includeFrom;
    }

    public List getConsolidatedOutputs() {
        return this.consolidatedOutputs;
    }

    public List getDroppedFields() {
        return this.droppedFields != null ? new ArrayList(this.droppedFields) : null;
    }

    /*
     * WARNING - void declaration
     */
    private List buildIncludeFromDefinitions(DataSource dataSource, boolean includeDynamics, String fieldName) throws Exception {
        List sortBy;
        ArrayList<IncludeFromDefinition> includeFrom = new ArrayList<IncludeFromDefinition>();
        if (this.ds == null) {
            return includeFrom;
        }
        if (this.ds.getConfig().get("cacheRelations") != null) {
            if (!DataTools.getBoolean(this.ds.getConfig(), "cacheRelations")) {
                this.ds.clearCachedRelations();
            }
        } else if (!config.getBoolean((Object)"cacheRelations", true)) {
            this.ds.clearCachedRelations();
        }
        List dsOutputs = this.getOutputs();
        List<String> obOutputs = null;
        Map opBinding = this.ds.getOperationBinding(this.getOperationType(), this.getOperationId());
        if (opBinding != null && opBinding.get("outputs") != null) {
            Object outputsObj = opBinding.get("outputs");
            obOutputs = outputsObj instanceof List ? (List<String>)outputsObj : DataTools.commaSeparatedStringToList(outputsObj.toString());
        }
        if (dsOutputs != null) {
            if (obOutputs == null) {
                this.consolidatedOutputs = new ArrayList(dsOutputs);
            } else {
                this.consolidatedOutputs = new ArrayList();
                StringBuffer droppedFields = new StringBuffer();
                for (String string : dsOutputs) {
                    if (!obOutputs.contains(string)) {
                        if (droppedFields.length() > 0) {
                            droppedFields.append(", ");
                        }
                        droppedFields.append(string);
                        continue;
                    }
                    this.consolidatedOutputs.add(string);
                }
                if (droppedFields.length() > 0) {
                    log.warn("DataSource '" + this.ds.getName() + "', OperationBinding: '" + this.getOperationId() + "': A DSRequest.outputs attribute specified fields that are not included in the OperationBinding.outputs attribute.  Dropping the following disallowed fields: " + droppedFields);
                }
            }
        } else if (obOutputs != null) {
            this.consolidatedOutputs = new ArrayList(obOutputs);
        }
        for (DSField field : dataSource.getFields()) {
            IncludeFromInfo includeFromInfo = dataSource.getIncludeFromInfo(field, this);
            if (includeFromInfo == null) continue;
            String realFieldName = field.getName();
            if (realFieldName == null) {
                realFieldName = includeFromInfo.getIncludedFieldName();
            }
            if (fieldName != null ? !fieldName.equals(realFieldName) : this.isSummary() && !this.getSummaryFields().contains(field.getName()) || this.consolidatedOutputs != null && !this.consolidatedOutputs.contains(field.getName())) continue;
            includeFrom.add(IncludeFromDefinition.create(includeFromInfo, this));
        }
        this.getAdditionalOutputs();
        if (includeDynamics) {
            DataSource relatedDS;
            Object thisFieldName;
            String fldName;
            Iterator<DSField> i = this.additionalOutputs.iterator();
            while (i.hasNext()) {
                DSField fieldObject;
                DSField dSField = fieldObject = i.next();
                String fldName2 = dSField.getName();
                if (this.isSummary() && !this.getSummaryFields().contains(dSField.getName())) continue;
                IncludeFromDefinition incFrom2 = new IncludeFromDefinition(dSField, dSField.getProperty("includeFrom"), this);
                incFrom2.setDynamic(true);
                String[] thisFieldName2 = incFrom2.getThisFieldName();
                if (this.ds.getField((String)thisFieldName2) != null) {
                    log.warn("In outputs, definition '" + fldName2 + "' refers to a field name ('" + (String)thisFieldName2 + "') that is already declared on this dataSource ('" + this.ds.getName() + "').  Ignoring this outputs entry.");
                    continue;
                }
                DataSource relatedDS2 = incFrom2.getDataSource();
                if (relatedDS2 == null) {
                    log.warn("In outputs, definition '" + fldName2 + "' refers to a related DataSource ('" + incFrom2.getDataSourceName() + "') that does not exist.  Ignoring this outputs entry.");
                    continue;
                }
                if (relatedDS2.getField(incFrom2.getIncludedFieldName()) == null) {
                    log.warn("In outputs, definition '" + fldName2 + "' refers to a field name ('" + incFrom2.getIncludedFieldName() + "') that does not exist on the related DataSurce ('" + relatedDS2.getName() + "').  Ignoring this outputs entry.");
                    continue;
                }
                if (incFrom2.getDataSourceNames() != null && incFrom2.getDataSourceNames().length > 0) {
                    String[] stringArray = incFrom2.getDataSourceNames();
                    int n = stringArray.length;
                    for (int j = 0; j < n; ++j) {
                        String dsName = stringArray[j];
                        if (this.getCachedDataSourceInstance(dsName) != null) continue;
                        log.warn("In outputs, definition '" + fldName2 + "' refers to a related DataSource ('" + dsName + "') that does not exist. Ignoring this field.");
                        incFrom2.setInError(true);
                    }
                }
                incFrom2.setRelation(this.ds.getRelation(incFrom2.getDataSources(), dSField.getProperty("includeVia"), this));
                if (incFrom2.getRelation() == null) {
                    log.warn("In outputs, definition '" + fldName2 + "' refers to a related DataSource ('" + incFrom2.getDataSourceName() + "') that is not related to this dataSource ('" + this.ds.getName() + "'). You can only specify fields in related DataSources where a foreignKey property establishes the relation from this dataSource ('" + this.ds.getName() + "') to the related DataSource. Ignoring this outputs entry.");
                    continue;
                }
                includeFrom.add(incFrom2);
            }
            if (this.consolidatedOutputs != null) {
                i = this.consolidatedOutputs.iterator();
                while (i.hasNext()) {
                    fldName = (String)((Object)i.next());
                    if (this.isSummary() && !this.getSummaryFields().contains(fldName) || !IncludeFromDefinition.isDynamicInclusion(fldName)) continue;
                    IncludeFromDefinition includeFromDefinition = new IncludeFromDefinition(fldName, this);
                    includeFromDefinition.setDynamic(true);
                    thisFieldName = includeFromDefinition.getThisFieldName();
                    if (this.ds.getField((String)thisFieldName) != null) {
                        log.warn("In outputs, definition '" + fldName + "' refers to a field name ('" + (String)thisFieldName + "') that is already declared on this dataSource ('" + this.ds.getName() + "').  Ignoring this outputs entry.");
                        i.remove();
                        continue;
                    }
                    relatedDS = includeFromDefinition.getDataSource();
                    if (relatedDS == null) {
                        log.warn("In outputs, definition '" + fldName + "' refers to a related DataSource ('" + includeFromDefinition.getDataSourceName() + "') that does not exist.  Ignoring this outputs entry.");
                        i.remove();
                        continue;
                    }
                    if (relatedDS.getField(includeFromDefinition.getIncludedFieldName()) == null) {
                        log.warn("In outputs, definition '" + fldName + "' refers to a field name ('" + includeFromDefinition.getIncludedFieldName() + "') that does not exist on the related DataSurce ('" + relatedDS.getName() + "').  Ignoring this outputs entry.");
                        i.remove();
                        continue;
                    }
                    if (includeFromDefinition.getDataSourceNames() != null && includeFromDefinition.getDataSourceNames().length > 0) {
                        for (String dsName : includeFromDefinition.getDataSourceNames()) {
                            if (this.getCachedDataSourceInstance(dsName) != null) continue;
                            log.warn("In outputs, definition '" + fldName + "' refers to a related DataSource ('" + dsName + "') that does not exist. Ignoring this field.");
                            includeFromDefinition.setInError(true);
                        }
                    }
                    includeFromDefinition.setRelation(this.ds.getRelation(includeFromDefinition.getDataSources(), this));
                    if (includeFromDefinition.getRelation() == null) {
                        log.warn("In outputs, definition '" + fldName + "' refers to a related DataSource ('" + includeFromDefinition.getDataSourceName() + "') that is not related to this dataSource ('" + this.ds.getName() + "'). You can only specify fields in related DataSources where a foreignKey property establishes the relation from this dataSource ('" + this.ds.getName() + "') to the related DataSource. Ignoring this outputs entry.");
                        i.remove();
                        continue;
                    }
                    includeFrom.add(includeFromDefinition);
                }
            }
            if (this.getCriteria() != null) {
                i = this.ds.isAdvancedCriteria(this.getCriteria()) ? this.ds.extractFieldNamesFromAdvancedCriteria(this.getCriteria()).iterator() : this.getCriteria().keySet().iterator();
                while (i.hasNext()) {
                    DSField field;
                    boolean bl;
                    fldName = (String)((Object)i.next());
                    if (IncludeFromDefinition.isDynamicInclusion(fldName)) {
                        IncludeFromDefinition includeFromDefinition = new IncludeFromDefinition(fldName, this);
                        includeFromDefinition.setCriteria(true);
                        includeFromDefinition.setDynamic(true);
                        thisFieldName = includeFromDefinition.getThisFieldName();
                        if (this.ds.getField((String)thisFieldName) != null) {
                            log.warn("In criteria, definition '" + fldName + "' refers to a field name ('" + (String)thisFieldName + "') that is already declared on this dataSource ('" + this.ds.getName() + "').  Ignoring this criteria entry.");
                            i.remove();
                            continue;
                        }
                        relatedDS = includeFromDefinition.getDataSource();
                        if (relatedDS == null) {
                            log.warn("In criteria, definition '" + fldName + "' refers to a related DataSource ('" + includeFromDefinition.getDataSourceName() + "') that does not exist.  Ignoring this criteria entry.");
                            i.remove();
                            continue;
                        }
                        if (relatedDS.getField(includeFromDefinition.getIncludedFieldName()) == null) {
                            log.warn("In criteria, definition '" + fldName + "' refers to a field name ('" + includeFromDefinition.getIncludedFieldName() + "') that does not exist on the related DataSource ('" + relatedDS.getName() + "').  Ignoring this criteria entry.");
                            i.remove();
                            continue;
                        }
                        if (includeFromDefinition.getDataSourceNames() != null && includeFromDefinition.getDataSourceNames().length > 0) {
                            for (String dsName : includeFromDefinition.getDataSourceNames()) {
                                if (this.getCachedDataSourceInstance(dsName) != null) continue;
                                log.warn("In criteria, definition '" + fldName + "' refers to a related DataSource ('" + dsName + "') that does not exist. Ignoring this field.");
                                includeFromDefinition.setInError(true);
                            }
                        }
                        includeFromDefinition.setRelation(this.ds.getRelation(includeFromDefinition.getDataSources(), this));
                        if (includeFromDefinition.getRelation() == null) {
                            log.warn("In criteria, definition '" + fldName + "' refers to a related DataSource ('" + includeFromDefinition.getDataSourceName() + "') that is not related to this dataSource ('" + this.ds.getName() + "'). You can only specify fields in related DataSources where a foreignKey property establishes the relation from this dataSource ('" + this.ds.getName() + "') to the related DataSource. Ignoring this criteria entry.");
                            i.remove();
                            continue;
                        }
                        includeFrom.add(includeFromDefinition);
                        continue;
                    }
                    boolean bl2 = false;
                    for (Object fieldObject : this.additionalOutputs) {
                        DSField field2 = (DSField)fieldObject;
                        if (!fldName.equals(field2.getName())) continue;
                        IncludeFromDefinition incFrom4 = new IncludeFromDefinition(field2, field2.getProperty("includeFrom"), this);
                        incFrom4.setCriteria(true);
                        includeFrom.add(incFrom4);
                        bl = true;
                        break;
                    }
                    if (bl || this.consolidatedOutputs == null || this.consolidatedOutputs.contains(fldName) || (field = this.ds.getField(fldName)) == null || field.get("includeFrom") == null) continue;
                    IncludeFromDefinition incFrom = new IncludeFromDefinition(field, (String)field.get("includeFrom"), this);
                    incFrom.setCriteria(true);
                    if (incFrom == null) continue;
                    incFrom.setRelation(this.ds.getRelation(incFrom.getDataSources(), field.getProperty("includeVia"), this));
                    includeFrom.add(incFrom);
                }
            }
        }
        if ((sortBy = this.getSortByFields()) != null && sortBy.size() != 0 && fieldName == null) {
            Iterator i = sortBy.iterator();
            while (i.hasNext()) {
                DSField field;
                void var10_22;
                String string = (String)i.next();
                if ("-".equals(string.substring(0, 1))) {
                    String string2 = string.substring(1);
                }
                if (IncludeFromDefinition.isDynamicInclusion((String)var10_22)) {
                    IncludeFromDefinition incFrom5 = new IncludeFromDefinition((String)var10_22, this);
                    incFrom5.setSortBy(true);
                    incFrom5.setDynamic(true);
                    String thisFieldName = incFrom5.getThisFieldName();
                    if (this.ds.getField(thisFieldName) != null) {
                        log.warn("In sortBy, definition '" + (String)var10_22 + "' refers to a field name ('" + (String)thisFieldName + "') that is already declared on this dataSource ('" + this.ds.getName() + "').  Ignoring this sortBy entry.");
                        i.remove();
                        continue;
                    }
                    DataSource relatedDS = incFrom5.getDataSource();
                    if (relatedDS == null) {
                        log.warn("In sortBy, definition '" + (String)var10_22 + "' refers to a related DataSource ('" + incFrom5.getDataSourceName() + "') that does not exist.  Ignoring this sortBy entry.");
                        i.remove();
                        continue;
                    }
                    if (relatedDS.getField(incFrom5.getIncludedFieldName()) == null) {
                        log.warn("In sortBy, definition '" + (String)var10_22 + "' refers to a field name ('" + incFrom5.getIncludedFieldName() + "') that does not exist on the related DataSource ('" + relatedDS.getName() + "').  Ignoring this sortBy entry.");
                        i.remove();
                        continue;
                    }
                    if (incFrom5.getDataSourceNames() != null && incFrom5.getDataSourceNames().length > 0) {
                        for (String dsName : incFrom5.getDataSourceNames()) {
                            if (this.getCachedDataSourceInstance(dsName) != null) continue;
                            log.warn("In sortBy, definition '" + (String)var10_22 + "' refers to a related DataSource ('" + dsName + "') that does not exist. Ignoring this field.");
                            incFrom5.setInError(true);
                        }
                    }
                    incFrom5.setRelation(this.ds.getRelation(incFrom5.getDataSources(), this));
                    if (incFrom5.getRelation() == null) {
                        log.warn("In sortBy, definition '" + (String)var10_22 + "' refers to a related DataSource ('" + incFrom5.getDataSourceName() + "') that is not related to this dataSource ('" + this.ds.getName() + "'). You can only specify fields in related DataSources where a foreignKey property establishes the relation from this dataSource ('" + this.ds.getName() + "') to the related DataSource. Ignoring this sortBy entry.");
                        i.remove();
                        continue;
                    }
                    includeFrom.add(incFrom5);
                    continue;
                }
                boolean found = false;
                for (Object fieldObject : this.additionalOutputs) {
                    DSField field3 = (DSField)fieldObject;
                    if (!var10_22.equals(field3.getName())) continue;
                    IncludeFromDefinition incFrom6 = new IncludeFromDefinition(field3, field3.getProperty("includeFrom"), this);
                    incFrom6.setSortBy(true);
                    includeFrom.add(incFrom6);
                    found = true;
                    break;
                }
                if (found || this.consolidatedOutputs == null || this.consolidatedOutputs.contains(var10_22) || (field = this.ds.getField((String)var10_22)) == null || field.get("includeFrom") == null) continue;
                IncludeFromDefinition incFrom7 = new IncludeFromDefinition(field, (String)field.get("includeFrom"), this);
                incFrom7.setSortBy(true);
                if (incFrom7 == null) continue;
                incFrom7.setRelation(this.ds.getRelation(incFrom7.getDataSources(), field.getProperty("includeVia"), this));
                includeFrom.add(incFrom7);
            }
        }
        for (IncludeFromDefinition includeFromDefinition : includeFrom) {
            if (includeFromDefinition.isTargetInspected()) continue;
            DataSource includeDS = includeFromDefinition.getDataSource();
            DSField includedField = includeFromDefinition.getIncludedField();
            IncludeFromDefinition target = IncludeFromDefinition.create(includeDS.getIncludeFromInfo(includedField, this), this);
            includeFromDefinition.setTargetIncludeFrom(target);
        }
        for (IncludeFromDefinition includeFromDefinition : includeFrom) {
            if (includeFromDefinition.isPrepared()) continue;
            includeFromDefinition.prepareField();
        }
        return includeFrom;
    }

    private DSRequest fetchRelatedValues(DSResponse response) throws Exception {
        DataSource ds;
        ArrayList mappedFieldNames = null;
        if (this.consolidatedOutputs != null) {
            mappedFieldNames = new ArrayList(this.consolidatedOutputs);
            this.mapRawOutputFieldNames(mappedFieldNames);
        }
        if (!(ds = this.getDataSource()).canJoinIncludedFields()) {
            ArrayList<String> includedDataSources = new ArrayList<String>();
            for (IncludeFromDefinition incFrom : this.includeFrom) {
                if (incFrom.isInError() || incFrom.isCriteria() || mappedFieldNames != null && !mappedFieldNames.contains(incFrom.getThisFieldName()) || includedDataSources.contains(incFrom.getDataSourceName())) continue;
                includedDataSources.add(incFrom.getDataSourceName());
            }
            for (String dsName : includedDataSources) {
                Relation relation = null;
                ArrayList<String> outputs = new ArrayList<String>();
                ArrayList<String> mappedOutputs = new ArrayList<String>();
                for (IncludeFromDefinition incFrom : this.includeFrom) {
                    if (incFrom.isInError() || incFrom.isCriteria() || !dsName.equals(incFrom.getDataSourceName())) continue;
                    if (relation == null) {
                        relation = incFrom.getRelation();
                    }
                    mappedOutputs.add(incFrom.getThisFieldName());
                    outputs.add(incFrom.getIncludedFieldName());
                }
                this.applyRelatedDSRequest(dsName, outputs, mappedOutputs, relation, response);
            }
        } else {
            ArrayList<String> includedDataSources = new ArrayList<String>();
            for (IncludeFromDefinition incFrom : this.includeFrom) {
                if (incFrom.isInError() || incFrom.isCriteria()) continue;
                while (incFrom != null && incFrom.getDataSource().canJoinIncludedFields()) {
                    incFrom = incFrom.getTargetIncludeFrom();
                }
                if (incFrom == null || mappedFieldNames != null && !mappedFieldNames.contains(incFrom.getThisFieldName()) || includedDataSources.contains(incFrom.getDataSourceName())) continue;
                includedDataSources.add(incFrom.getDataSourceName());
            }
            for (String dsName : includedDataSources) {
                Relation relation = null;
                ArrayList<String> outputs = new ArrayList<String>();
                ArrayList<String> mappedOutputs = new ArrayList<String>();
                for (IncludeFromDefinition incFrom : this.includeFrom) {
                    if (incFrom.isInError() || incFrom.isCriteria() || !dsName.equals(incFrom.getDataSourceName())) continue;
                    while (incFrom != null && incFrom.getDataSource().canJoinIncludedFields()) {
                        incFrom = incFrom.getTargetIncludeFrom();
                    }
                    if (incFrom == null) continue;
                    if (relation == null) {
                        relation = incFrom.getRelation();
                    }
                    mappedOutputs.add(incFrom.getThisFieldName());
                    outputs.add(incFrom.getIncludedFieldName());
                }
                this.applyRelatedDSRequest(dsName, outputs, mappedOutputs, relation, response);
            }
        }
        return this;
    }

    public boolean selectCriteriaFields() {
        return this.selectCriteriaFields;
    }

    public DSRequest setSelectCriteriaFields(boolean newVal) {
        this.selectCriteriaFields = newVal;
        return this;
    }

    public boolean selectSortByFields() {
        return this.selectSortByFields;
    }

    public DSRequest setSelectSortByFields(boolean newVal) {
        this.selectSortByFields = newVal;
        return this;
    }

    private DSRequest applyRelatedDSRequest(String dsName, List outputs, List mappedOutputs, Relation relation, DSResponse response) throws Exception {
        IncludeFromDefinition incFrom;
        List dataList = response.getRecords();
        if (dataList == null || dataList.size() == 0) {
            return this;
        }
        HashMap criteriaValuesMap = new HashMap();
        HashSet criteriaValuesSet = new HashSet();
        for (int i = 0; i < dataList.size(); ++i) {
            Map record = (Map)dataList.get(i);
            HashMap criteriaValue = new HashMap();
            ArrayList keyValues = new ArrayList();
            StringBuffer mapKey = new StringBuffer();
            if (relation.isComposite()) {
                for (int k = 0; k < relation.getFromFields().size(); ++k) {
                    DSField fromField = relation.getFromFields().get(k);
                    DSField toField = relation.getToFields().get(k);
                    String keyFrom = fromField.getName();
                    String keyTo = toField.getName();
                    Object value = record.get(keyFrom);
                    if (value == null && fromField.getJoinType() == 0) {
                        dataList.remove(i);
                        response.setData(dataList);
                        break;
                    }
                    keyValues.add(value);
                    if (mapKey.length() != 0) {
                        mapKey.append("_");
                    }
                    mapKey.append(value == null ? "" : value.toString());
                    criteriaValue.put(keyTo, value);
                }
                if (criteriaValuesMap.containsKey(mapKey.toString())) continue;
                criteriaValuesMap.put(mapKey.toString(), criteriaValue);
                continue;
            }
            Object value = record.get(relation.getFromFields().get(0).getName());
            if (value == null || criteriaValuesSet.contains(value)) continue;
            criteriaValuesSet.add(value);
        }
        DSRequest req = new DSRequest(dsName, "fetch");
        req.setRPCManager(this.getRPCManager());
        int c = 0;
        for (DSField toField : relation.getToFields()) {
            if (!outputs.contains(toField.getName())) {
                outputs.add(toField.getName());
                mappedOutputs.add(relation.getFromFields().get(c).getName());
            }
            ++c;
        }
        for (String fieldName : this.getCriteria().keySet()) {
            incFrom = IncludeFromDefinition.forCriteriaField(this.includeFrom, fieldName);
            if (incFrom == null || !incFrom.getDataSourceName().equals(dsName)) continue;
            outputs.add(incFrom.getIncludedFieldName());
            mappedOutputs.add(incFrom.getThisFieldName());
            req.setSelectCriteriaFields(true);
        }
        for (String fieldName : this.getSortByFields()) {
            incFrom = IncludeFromDefinition.forSortByField(this.includeFrom, fieldName, false);
            if (incFrom == null || !incFrom.getDataSourceName().equals(dsName)) continue;
            outputs.add(incFrom.getIncludedFieldName());
            mappedOutputs.add(incFrom.getThisFieldName());
            req.setSelectSortByFields(true);
        }
        req.setOutputs(outputs);
        DSResponse work = null;
        DataSource ds = req.getDataSource();
        if (relation.isComposite()) {
            if (ds.allowAdvancedCriteria()) {
                int cn = 0;
                Criterion[] crits = new Criterion[criteriaValuesMap.keySet().size()];
                Iterator i = criteriaValuesMap.keySet().iterator();
                while (i.hasNext()) {
                    Map rawCrit = (Map)criteriaValuesMap.get(i.next());
                    Criterion[] inner = new SimpleCriterion[rawCrit.keySet().size()];
                    int cn2 = 0;
                    for (String fieldName : rawCrit.keySet()) {
                        inner[cn2++] = new SimpleCriterion(fieldName, "equals", rawCrit.get(fieldName));
                    }
                    crits[cn++] = new AndCriterion(inner);
                }
                req.setAdvancedCriteria(new AdvancedCriteria("or", crits));
                req.isNestedSubRequest = true;
                work = req.execute();
            } else {
                work = this.fetchRecordByRecord(ds, criteriaValuesMap);
            }
        } else {
            HashMap criteria = new HashMap();
            criteria.put(relation.getToFields().get(0).getName(), new ArrayList(criteriaValuesSet));
            req.setCriteria(criteria);
            req.isNestedSubRequest = true;
            work = req.execute();
        }
        if (work == null) {
            return this;
        }
        Object responseData = work.getData();
        List<Object> responseList = null;
        if (responseData instanceof List) {
            responseList = (ArrayList<Object>)responseData;
        } else if (responseData instanceof Map) {
            responseList = new ArrayList<Object>();
            responseList.add(responseData);
        } else if (responseData instanceof JSONFilter) {
            if ((responseData = ((JSONFilter)responseData).getObj()) instanceof List) {
                responseList = (List)responseData;
            } else if (responseData instanceof Map) {
                responseList = new ArrayList();
                responseList.add(responseData);
            }
        }
        if (responseList == null) {
            log.warn("Unable to handle response data during processing of related DSRequests. The custom DataSource returned a data member of type '" + responseData.getClass().getName() + "'; we expect a List of Maps or a single Map, or a JSONFilter wrapping a List of Maps or a single Map");
            return this;
        }
        HashMap<String, Integer> index = new HashMap<String, Integer>();
        for (int i = 0; i < dataList.size(); ++i) {
            Map record = (Map)dataList.get(i);
            String criteriaValue = relation.getFromFieldIndexValue(record);
            int indexEntry = -1;
            Map subRecord = null;
            if (criteriaValue == null) continue;
            if (!index.containsKey(criteriaValue)) {
                for (int j = 0; j < responseList.size(); ++j) {
                    subRecord = (Map)responseList.get(j);
                    if (!criteriaValue.equals(relation.getToFieldIndexValue(subRecord))) continue;
                    index.put(criteriaValue, j);
                    indexEntry = j;
                    break;
                }
            } else {
                indexEntry = (Integer)index.get(criteriaValue);
                subRecord = (Map)responseList.get(indexEntry);
            }
            if (indexEntry == -1) {
                if (!relation.isComposite()) {
                    log.warn("In response from related DataSource '" + dsName + "' we could not find a record where primary key field '" + relation.getToFields().get(0).getName() + "' matched the value of the foreign key field '" + relation.getFromFields().get(0).getName() + "' for value [" + criteriaValue + "]. Values from that related DS will be null");
                    continue;
                }
                log.warn("In response from related DataSource '" + dsName + "' we encountered a record where primary key field values could not be matched with foreign key field values (in other words, there is a missing record in the response)");
                continue;
            }
            Iterator i2 = outputs.iterator();
            Iterator i3 = mappedOutputs.iterator();
            while (i2.hasNext()) {
                String includedFieldName = (String)i2.next();
                String thisFieldName = (String)i3.next();
                if (relation.isAToField(includedFieldName)) continue;
                record.put(thisFieldName, subRecord.get(includedFieldName));
            }
        }
        return this;
    }

    protected DSResponse fetchRecordByRecord(DataSource ds, Map criteriaValues) throws Exception {
        ArrayList dataList = new ArrayList();
        Iterator i = criteriaValues.keySet().iterator();
        while (i.hasNext()) {
            DSRequest req = new DSRequest(ds.getName(), "fetch");
            req.setCriteria(criteriaValues.get(i.next()));
            req.isNestedSubRequest = true;
            DSResponse resp = req.execute();
            List records = resp.getRecords();
            if (records == null || records.size() == 0) {
                log.warn("Got null or empty data from a fetch on DataSource " + ds.getName() + " with criteria: " + req.getCriteria());
                continue;
            }
            if (records.size() > 1) {
                log.warn("Got more than one record from a PK fetch on DataSource " + ds.getName() + "; ignoring all but the first.  Criteria was: " + req.getCriteria());
            }
            dataList.add(records.get(0));
        }
        DSResponse resp = new DSResponse();
        resp.setData(dataList);
        return resp;
    }

    private void applyManualFilterAndSort(DSResponse response) throws Exception {
        if (this.includeFrom == null || this.includeFrom.size() == 0) {
            return;
        }
        if (this.isNestedSubRequest) {
            return;
        }
        if (this.getEndRow() != -1L && this.getNonSqlCriteriaFields() != null) {
            log.warn("SmartClient/SmartGWT Server does not currently support sort or filter on fields from non-SQL DataSources when performing paged fetches. If you need to sort or filter on these fields, use a basic fetch (ie, do not specify endRow), but be aware that this may drastically affect performance.  The following fields have been dropped from the specified criteria: " + this.getNonSqlCriteriaFields());
            return;
        }
        DataSource ds = this.getDataSource();
        boolean isAdvanced = ds.isAdvancedCriteria(this.getCriteria());
        if (this.hasNonSqlCriteria() || !ds.canJoinIncludedFields()) {
            int removed = 0;
            AdvancedCriteria ac = null;
            SimpleCriteria sc = null;
            Evaluator evaluator = new Evaluator();
            String textMatchStyle = (String)this.getOperationProperty("textMatchStyle");
            if (textMatchStyle == null && "filter".equals(this.getOperationType())) {
                textMatchStyle = "substring";
            }
            if (isAdvanced) {
                HashMap criteria = new HashMap(this.getCriteria());
                this.mapRawAdvancedCriteria(criteria);
                ac = Evaluator.parseAdvancedCriteria(criteria);
            } else {
                sc = new SimpleCriteria(this.getCriteria());
                this.mapSimpleCriteria(sc);
            }
            List<Object> criteriaFields = new ArrayList(this.getCriteria().keySet());
            if (isAdvanced) {
                criteriaFields = this.getDataSource().extractFieldNamesFromAdvancedCriteria(this.getCriteria());
            }
            this.mapRawCriteriaFieldNames(criteriaFields);
            List<Object> dataList = null;
            Object data = response.getData();
            if (data instanceof List) {
                dataList = (ArrayList<Object>)data;
            } else if (data instanceof Map) {
                dataList = new ArrayList<Object>();
                dataList.add(data);
            } else if (data instanceof JSONFilter) {
                if ((data = ((JSONFilter)data).getObj()) instanceof List) {
                    dataList = (List)data;
                } else if (data instanceof Map) {
                    dataList = new ArrayList();
                    dataList.add(data);
                }
            }
            if (dataList == null) {
                log.warn("DSResponse data was of unexpected type: " + data.getClass().getName() + ".  Abandoning manual filter/sort");
                return;
            }
            if (dataList.size() == 0) {
                log.debug("In manual filter/sort, primary resultset was empty so nothing to do");
                return;
            }
            Object recordObj = dataList.get(0);
            if (!(recordObj instanceof Map)) {
                recordObj = this.getDataSource().getProperties(recordObj);
            }
            Map record = (Map)recordObj;
            String fieldList = "";
            for (String string : criteriaFields) {
                if (record.containsKey(string)) continue;
                if (fieldList.length() > 0) {
                    fieldList = fieldList + ", ";
                }
                fieldList = fieldList + string;
            }
            if (fieldList.length() > 0) {
                log.warn("In manual filter, we found filter values for which there is no corresponding field in the first record of the resultset.  This may be expected, but it may be an indicator that you are not fetching all required fields - manual (ie, non-SQL) sort and filter can only work if you actually fetch the criteria and sortBy fields from the database. Affected fields: " + fieldList);
            }
            ArrayList _dataList = new ArrayList(response.getDataList());
            Iterator iterator = _dataList.iterator();
            while (iterator.hasNext()) {
                recordObj = iterator.next();
                if (!(recordObj instanceof Map)) {
                    recordObj = this.getDataSource().getProperties(recordObj);
                }
                record = (Map)recordObj;
                boolean matches = isAdvanced ? evaluator.valuesMatchCriteria(record, ac) : evaluator.valuesMatchCriteria(record, sc, textMatchStyle);
                if (matches) continue;
                ++removed;
                iterator.remove();
            }
            response.setData(_dataList);
            if (removed > 0) {
                response.setTotalRows(response.getTotalRows() - (long)removed);
                response.setEndRow(response.getEndRow() - (long)removed);
            }
        }
        if (!this.canSortInQuery()) {
            this.applyManualSort(response);
        }
    }

    public boolean hasNonSqlCriteria() throws Exception {
        return this.getNonSqlCriteriaFields() != null;
    }

    public Set getNonSqlCriteriaFields() throws Exception {
        boolean isAdvanced = this.getDataSource().isAdvancedCriteria(this.getCriteria());
        List<Object> criteriaFields = new ArrayList(this.getCriteria().keySet());
        if (isAdvanced) {
            criteriaFields = this.getDataSource().extractFieldNamesFromAdvancedCriteria(this.getCriteria());
        }
        this.mapRawCriteriaFieldNames(criteriaFields);
        HashSet<String> nonSql = null;
        for (IncludeFromDefinition incFrom : this.includeFrom) {
            String fromField = incFrom.getThisFieldName();
            if (!criteriaFields.contains(fromField)) continue;
            while (incFrom != null) {
                if (!incFrom.getDataSource().canJoinIncludedFields()) {
                    if (nonSql == null) {
                        nonSql = new HashSet<String>();
                    }
                    nonSql.add(fromField);
                }
                incFrom = incFrom.getTargetIncludeFrom();
            }
        }
        return nonSql;
    }

    public boolean criteriaIsDivisible() throws Exception {
        if (!this.getDataSource().isAdvancedCriteria(this.getCriteria())) {
            return true;
        }
        return this.testCriteriaDivisibilityRecursively(this.getCriteria(), false);
    }

    private boolean testCriteriaDivisibilityRecursively(Map criteria, boolean negated) {
        String operator = (String)criteria.get("operator");
        List subCriteria = (List)criteria.get("criteria");
        if (operator.equals("not")) {
            boolean bl = negated = !negated;
        }
        if (operator.equals("or") && !negated || operator.equals("and") && negated) {
            return false;
        }
        if (subCriteria == null) {
            return true;
        }
        for (int i = 0; i < subCriteria.size(); ++i) {
            Map subCrit = (Map)subCriteria.get(i);
            if (this.testCriteriaDivisibilityRecursively(subCrit, negated)) continue;
            return false;
        }
        return true;
    }

    public boolean canSortInQuery() throws Exception {
        ArrayList<String> sortByUndecorated = new ArrayList<String>();
        Iterator i = this.getSortByFields().iterator();
        while (i.hasNext()) {
            String fieldName = new String((String)i.next());
            if (fieldName.indexOf("-") == 0) {
                fieldName = fieldName.substring(1);
            }
            sortByUndecorated.add(fieldName);
        }
        for (IncludeFromDefinition incFrom : this.includeFrom) {
            if (!sortByUndecorated.contains(incFrom.getThisFieldName()) && !sortByUndecorated.contains(incFrom.getDataSourceName() + "." + incFrom.getIncludedFieldName())) continue;
            while (incFrom != null) {
                if (!incFrom.getDataSource().canJoinIncludedFields()) {
                    return false;
                }
                incFrom = incFrom.getTargetIncludeFrom();
            }
        }
        return true;
    }

    public DSRequest setComparator(Comparator comparator) {
        this.comparator = comparator;
        return this;
    }

    public Comparator getComparator() {
        return this.comparator;
    }

    private DSRequest applyManualSort(DSResponse response) {
        Collections.sort(response.getDataList(), this.comparator);
        return this;
    }

    private DSRequest mapRawCriteriaFieldNames(List names) {
        for (int i = 0; i < names.size(); ++i) {
            String rawField = (String)names.get(i);
            IncludeFromDefinition incFrom = IncludeFromDefinition.forCriteriaField(this.includeFrom, rawField);
            if (incFrom == null) continue;
            names.set(i, incFrom.getThisFieldName());
        }
        return this;
    }

    private DSRequest mapRawOutputFieldNames(List names) {
        for (int i = 0; i < names.size(); ++i) {
            String rawField = (String)names.get(i);
            IncludeFromDefinition incFrom = IncludeFromDefinition.forRelatedField(this.includeFrom, rawField, this.ds);
            if (incFrom == null) continue;
            names.set(i, incFrom.getThisFieldName());
        }
        return this;
    }

    private DSRequest mapSimpleCriteria(SimpleCriteria sc) {
        for (String key : sc.keySet()) {
            Object criteriaValue = sc.get(key);
            IncludeFromDefinition incFrom = IncludeFromDefinition.forCriteriaField(this.includeFrom, key);
            if (incFrom == null) continue;
            sc.put(incFrom.getThisFieldName(), criteriaValue);
            sc.remove(key);
        }
        return this;
    }

    private DSRequest mapRawAdvancedCriteria(Map ac) {
        this.mapRawAdvancedCriteriaRecursively((List)ac.get("criteria"));
        return this;
    }

    private DSRequest mapRawAdvancedCriteriaRecursively(List criteria) {
        if (criteria == null || criteria.size() == 0) {
            return this;
        }
        for (Map criterion : criteria) {
            IncludeFromDefinition incFrom;
            String fieldName = (String)criterion.get("fieldName");
            if (fieldName != null && (incFrom = IncludeFromDefinition.forCriteriaField(this.includeFrom, fieldName)) != null) {
                criterion.put("fieldName", incFrom.getThisFieldName());
            }
            List subcriteria = (List)criterion.get("criteria");
            this.mapRawAdvancedCriteriaRecursively(subcriteria);
        }
        return this;
    }

    public DSRequest addToCriteria(String fieldName, Object value) throws Exception {
        String baseType;
        BasicDataSource bds;
        DSField field;
        if (!this.getIsAdvancedCriteria()) {
            this.getCriteria().put(fieldName, value);
            return this;
        }
        DataSource ds = this.getDataSource();
        if (ds instanceof BasicDataSource && (field = (bds = (BasicDataSource)ds).getField(fieldName)) != null && ("text".equals(baseType = bds.getSimpleBaseType(field.getType())) || ("integer".equals(baseType) || "float".equals(baseType)) && value instanceof String)) {
            String textMatchStyle = this.getTextMatchStyle();
            String operatorId = null;
            if (textMatchStyle == null) {
                textMatchStyle = bds.getProperty("defaultTextMatchStyle");
            }
            if (textMatchStyle == null) {
                textMatchStyle = "exact";
            }
            operatorId = textMatchStyle.equals("exactCase") ? "equals" : (textMatchStyle.equals("exact") ? "iEquals" : (textMatchStyle.equals("startsWith") ? "iStartsWith" : "iContains"));
            return this.addToCriteria(fieldName, operatorId, (Object)value.toString());
        }
        return this.addToCriteria(fieldName, "equals", value);
    }

    public DSRequest addToCriteria(String fieldName, String operator, Object value) throws Exception {
        return this.addToCriteria(fieldName, operator, value, null, null);
    }

    public DSRequest addToCriteria(String fieldName, String operator, Object[] value) throws Exception {
        return this.addToCriteria(new SetCriterion(fieldName, operator, value));
    }

    public DSRequest addToCriteria(String fieldName, OperatorBase operator, Object value) throws Exception {
        return this.addToCriteria(fieldName, operator.getID(), value, null, null);
    }

    public DSRequest addToCriteria(String fieldName, OperatorBase operator, Object[] value) throws Exception {
        return this.addToCriteria(new SetCriterion(fieldName, operator.getID(), value));
    }

    public DSRequest addToCriteria(String fieldName, String operator, Object value, Object start, Object end) throws Exception {
        return this.addToCriteria(fieldName, operator, value, start, end, null);
    }

    public DSRequest addToCriteria(String fieldName, String operator, Object value, Object start, Object end, List<Criterion> subCriteria) throws Exception {
        Map ac;
        String op;
        if (operator == null && subCriteria == null) {
            return this.addToCriteria(fieldName, value);
        }
        if (operator == null) {
            operator = "equals";
        }
        if (this.getCriteria() == null) {
            this.setCriteria(new HashMap());
        }
        if (!this.getIsAdvancedCriteria()) {
            this.setAdvancedCriteria(this.getAdvancedCriteria());
        }
        if ((op = (String)(ac = this.getCriteria()).get("operator")) == null) {
            throw new Exception("Top-level AdvancedCriteria has no operator specified");
        }
        HashMap<String, Object> newClause = new HashMap<String, Object>();
        if (fieldName == null && subCriteria == null) {
            throw new Exception("Invalid parameters - both fieldName and criteria are null");
        }
        if (fieldName != null) {
            newClause.put("fieldName", fieldName);
        }
        if (subCriteria != null) {
            ArrayList<Map<String, Object>> convertedCriteria = new ArrayList<Map<String, Object>>();
            for (int i = 0; i < subCriteria.size(); ++i) {
                convertedCriteria.add(AdvancedCriteria.getCriteriaAsMap(subCriteria.get(i)));
            }
            newClause.put("criteria", convertedCriteria);
        }
        newClause.put("operator", operator);
        if (value != null) {
            newClause.put("value", value);
        }
        if (start != null) {
            newClause.put("start", start);
        }
        if (end != null) {
            newClause.put("end", end);
        }
        if (!op.equals("and")) {
            HashMap<String, Object> topLevel = new HashMap<String, Object>(ac);
            topLevel.put("operator", "and");
            ArrayList<Map> crit = new ArrayList<Map>();
            crit.add(newClause);
            crit.add(ac);
            topLevel.put("criteria", crit);
            this.setCriteria(topLevel);
        } else {
            Object critObj = ac.get("criteria");
            if (!(critObj instanceof List) && critObj != null) {
                throw new Exception("Top-level AdvancedCriteria has 'criteria' property that is not a java.util.List");
            }
            ArrayList crit = (ArrayList)critObj;
            if (crit == null) {
                crit = new ArrayList();
                ac.put("criteria", crit);
            }
            crit.add(newClause);
        }
        this.setAdvancedCriteria(this.getAdvancedCriteria());
        return this;
    }

    public DSRequest addToCriteria(Criterion criterion) throws Exception {
        if (criterion instanceof SimpleCriterion) {
            SimpleCriterion sc = (SimpleCriterion)criterion;
            return this.addToCriteria(sc.getFieldName(), sc.getOperatorId(), sc.getValue(), null, null);
        }
        if (criterion instanceof CustomCriterion) {
            CustomCriterion cc = (CustomCriterion)criterion;
            return this.addToCriteria(cc.getFieldName(), cc.getOperatorId(), cc.getValue(), null, null);
        }
        if (criterion instanceof IsNullCriterion) {
            IsNullCriterion ic = (IsNullCriterion)criterion;
            return this.addToCriteria(ic.getFieldName(), ic.getOperatorId(), ic.getValue(), null, null);
        }
        if (criterion instanceof NotNullCriterion) {
            NotNullCriterion nc = (NotNullCriterion)criterion;
            return this.addToCriteria(nc.getFieldName(), nc.getOperatorId(), nc.getValue(), null, null);
        }
        if (criterion instanceof LogicalCriterion) {
            LogicalCriterion lc = (LogicalCriterion)criterion;
            return this.addToCriteria(lc.getFieldName(), lc.getOperatorId(), lc.getValue(), null, null, lc.getCriteria());
        }
        if (criterion instanceof OtherFieldCriterion) {
            OtherFieldCriterion oc = (OtherFieldCriterion)criterion;
            return this.addToCriteria(oc.getFieldName(), oc.getOperatorId(), oc.getOtherFieldName(), null, null);
        }
        if (criterion instanceof SetCriterion) {
            SetCriterion sc = (SetCriterion)criterion;
            return this.addToCriteria(sc.getFieldName(), sc.getOperatorId(), sc.getValues(), null, null);
        }
        RangeCriterion rc = (RangeCriterion)criterion;
        return this.addToCriteria(rc.getFieldName(), rc.getOperatorId(), rc.getValue(), rc.getMin(), rc.getMax());
    }

    public DSRequest addToCriteria(AdvancedCriteria criteria) throws Exception {
        return this.addToCriteria(criteria.asCriterion());
    }

    public Map getParentNode() {
        return (Map)this.getParameter("parentNode");
    }

    public String getResultTreeIdField() {
        return (String)this.getParameter("resultTreeIdField");
    }

    public String getResultTreeParentIdField() {
        return (String)this.getParameter("resultTreeParentIdField");
    }

    public boolean getKeepParentsOnFilter() {
        return DataTools.getBoolean(this.requestData, "keepParentsOnFilter", false);
    }

    public List getMissingPrimaryKeysForAdd() throws Exception {
        if (!"add".equals(this.getOperationType()) || !config.getBoolean((Object)"validate.primaryKeys.for.add", true) || !this.isClientRequest() || this.getAllowMultiUpdate()) {
            return new ArrayList();
        }
        DataSource ds = this.getDataSource();
        ArrayList passedKeys = new ArrayList(this.getValues().keySet());
        List<String> keysPresent = DataTools.setIntersection(ds.getPrimaryKeys(), passedKeys);
        List keysMissing = DataTools.setDisjunction(ds.getPrimaryKeys(), keysPresent);
        Iterator missing = keysMissing.iterator();
        while (missing.hasNext()) {
            DSField field = ds.getField((String)missing.next());
            if (field == null || !field.isAutoGenerated() && !field.containsKey("customInsertExpression")) continue;
            missing.remove();
        }
        return keysMissing;
    }

    public boolean trackTimings() {
        if (this.context != null && this.context.request != null) {
            Boolean track = (Boolean)this.context.request.getSession().getAttribute("__isc_trackServerTimings");
            if (Boolean.TRUE.equals(track)) {
                return true;
            }
            if (Boolean.FALSE.equals(track)) {
                return false;
            }
        }
        return config.getBoolean((Object)"DSRequest.returnTimingData", false);
    }

    public void recordTimingData(String description, TimingLogType type) {
        this.recordTimingData(description, type, Long.MIN_VALUE);
    }

    public void recordTimingData(String description, TimingLogType type, long millis) {
        LinkedMap work;
        Map timing;
        Stack timingStack;
        if (!this.trackTimings()) {
            return;
        }
        if (millis == Long.MIN_VALUE) {
            millis = System.currentTimeMillis();
        }
        if ((timingStack = (Stack)this.getAttribute("timingStack")) == null) {
            timingStack = new Stack();
            this.setAttribute("timingStack", timingStack);
            timing = new LinkedMap();
            timing.put("name", "Server processing");
            timing.put("start", millis);
            ArrayList children = new ArrayList();
            timing.put("children", children);
            this.setAttribute("timing", timing);
            timingStack.push(timing);
        }
        timing = (Map)timingStack.peek();
        if (type == TimingLogType.START) {
            work = new LinkedMap();
            work.put("name", description);
            work.put("start", millis);
            ArrayList children = new ArrayList();
            work.put("children", children);
            ((List)timing.get("children")).add(work);
            timingStack.push(work);
        } else if (type == TimingLogType.END) {
            timing.put("end", millis);
            timingStack.pop();
        } else {
            work = new LinkedMap();
            work.put("name", description);
            work.put("millis", millis);
            ((List)timing.get("children")).add(work);
        }
    }

    public DSRequest copyTimingDataToResponse(DSResponse dsResponse) {
        if (dsResponse != null) {
            dsResponse.setParameter("timing", this.getAttribute("timing"));
        }
        return this;
    }

    public void setSkipAudit(boolean skipAudit) {
        this.skipAudit = skipAudit;
    }

    public boolean isAuditSkipped() {
        if (this.skipAudit != null) {
            return this.skipAudit;
        }
        boolean reqSkipAudit = DataTools.getBoolean(this.getOperationConfig(), "skipAudit", false);
        try {
            DataSource ds = this.getDataSource();
            Map opBinding = ds.getOperationBinding(this);
            return DataTools.getBoolean(opBinding, "skipAudit", reqSkipAudit);
        }
        catch (Exception exception) {
            return reqSkipAudit;
        }
    }

    public void setUsingSpringTransaction(boolean b) {
        this.usingSpringTransaction = b;
    }

    public boolean isUsingSpringTransaction() {
        return this.usingSpringTransaction;
    }

    public void setAllowAnyRPC(boolean allowAnyRPC) {
        this.allowAnyRPC = allowAnyRPC;
    }

    public boolean getAllowAnyRPC() {
        return this.allowAnyRPC;
    }

    public void setCanSyncCache(boolean canSyncCache) {
        this.setOperationProperty("canSyncCache", canSyncCache);
    }

    static {
        boolean first = true;
        Iterator<String> i = DataSource.OPS_VALID_FOR_FIELDVALUEEXPRESSION.iterator();
        while (i.hasNext()) {
            if (!first) {
                responseDataRegex = responseDataRegex + "|";
            }
            responseDataRegex = responseDataRegex + i.next();
            first = false;
        }
        responseDataRegex = responseDataRegex + ")'|\"(";
        i = DataSource.OPS_VALID_FOR_FIELDVALUEEXPRESSION.iterator();
        while (i.hasNext()) {
            if (!first) {
                responseDataRegex = responseDataRegex + "|";
            }
            responseDataRegex = responseDataRegex + i.next();
            first = false;
        }
        responseDataRegex = responseDataRegex + ")\"))? *\\))?(\\[[0-9]+\\])?\\.(last\\.)?[\\$_a-zA-Z][\\$_a-zA-Z0-9]*$";
        responseDataPattern = Pattern.compile(responseDataRegex);
        responsesRegex = "\\$responses\\.(last|first)(\\( *('[\\$_a-zA-Z][\\$_a-zA-Z0-9]*'|\"[\\$_a-zA-Z][\\$_a-zA-Z0-9]*\")( *, *('(";
        first = true;
        i = DataSource.OPS_VALID_FOR_FIELDVALUEEXPRESSION.iterator();
        while (i.hasNext()) {
            if (!first) {
                responsesRegex = responsesRegex + "|";
            }
            responsesRegex = responsesRegex + i.next();
            first = false;
        }
        responsesRegex = responsesRegex + ")'|\"(";
        i = DataSource.OPS_VALID_FOR_FIELDVALUEEXPRESSION.iterator();
        while (i.hasNext()) {
            if (!first) {
                responsesRegex = responsesRegex + "|";
            }
            responsesRegex = responsesRegex + i.next();
            first = false;
        }
        responsesRegex = responsesRegex + ")\"))? *\\))?\\.(";
        i = DataSource.RESPONSE_PROPS_VALID_FOR_FIELDVALUEEXPRESSION.iterator();
        while (i.hasNext()) {
            if (!first) {
                responsesRegex = responsesRegex + "|";
            }
            responsesRegex = responsesRegex + i.next();
            first = false;
        }
        responsesRegex = responsesRegex + ")$";
        responsesPattern = Pattern.compile(responsesRegex);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TimingLogType {
        START,
        END,
        NORMAL;

    }
}

