/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.velocity;

import com.isomorphic.log.Logger;
import com.isomorphic.util.DataTools;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class ResponseDataWrapper
implements List {
    private Logger log = new Logger(ResponseDataWrapper.class.getName());
    private Object data;

    public ResponseDataWrapper(Object data) {
        this.data = data;
    }

    public Object get(String propertyName) throws Exception {
        Object data = this.data;
        if (data instanceof List) {
            if (((List)data).size() == 0) {
                this.log.warn("Underlying data object is a zero-length list!");
                return null;
            }
            data = ((List)data).get(0);
        }
        if (data instanceof Object[]) {
            if (((Object[])data).length == 0) {
                this.log.warn("Underlying data object is a zero-length array!");
                return null;
            }
            data = ((Object[])data)[0];
        }
        if (data instanceof Map) {
            return ((Map)data).get(propertyName);
        }
        Map properties = DataTools.getProperties(data);
        if (properties != null) {
            return properties.get(propertyName);
        }
        this.log.warn("Unable to derive a value for property '" + propertyName + "' from the underlying data object: " + this.data);
        return null;
    }

    public Object get(Integer index) throws Exception {
        Object data = this.data;
        if (data instanceof List) {
            return ((List)data).get(index);
        }
        if (data instanceof Object[]) {
            return ((Object[])data)[index];
        }
        throw new Exception("get(Integer index) called, but the underlying data member is not a List or array");
    }

    public Object getLast() throws Exception {
        return this.last();
    }

    public Object last() throws Exception {
        Object data = this.data;
        if (data instanceof List) {
            int last = ((List)data).size() - 1;
            if (last < 0) {
                return null;
            }
            return ((List)data).get(last);
        }
        if (data instanceof Object[]) {
            int last = ((Object[])data).length - 1;
            if (last < 0) {
                return null;
            }
            data = ((Object[])data)[last];
        }
        throw new Exception("last() called, but the underlying data member is not a List or array");
    }

    public int size() {
        if (this.data instanceof List) {
            return ((List)this.data).size();
        }
        if (this.data instanceof Object[]) {
            return ((Object[])this.data).length;
        }
        this.log.warn("List API called when the underlying data object is not a List or array");
        return 0;
    }

    public boolean isEmpty() {
        if (this.data instanceof List) {
            return ((List)this.data).isEmpty();
        }
        if (this.data instanceof Object[]) {
            return ((Object[])this.data).length == 0;
        }
        this.log.warn("List API called when the underlying data object is not a List or array");
        return false;
    }

    public boolean contains(Object o) {
        if (this.data instanceof List) {
            return ((List)this.data).contains(o);
        }
        if (this.data instanceof Object[]) {
            Object[] array = (Object[])this.data;
            for (int i = 0; i < array.length; ++i) {
                if ((o != null || array[i] != null) && !o.equals(array[i])) continue;
                return true;
            }
            return false;
        }
        this.log.warn("List API called when the underlying data object is not a List or array");
        return false;
    }

    public Iterator iterator() {
        if (this.data instanceof List) {
            return ((List)this.data).iterator();
        }
        if (this.data instanceof Object[]) {
            return new Iterator(){
                private int counter = 0;

                public boolean hasNext() {
                    return this.counter < ((Object[])ResponseDataWrapper.this.data).length;
                }

                public Object next() {
                    return ((Object[])ResponseDataWrapper.this.data)[this.counter++];
                }

                public void remove() {
                    for (int i = this.counter; i < ((Object[])ResponseDataWrapper.this.data).length - 1; ++i) {
                        ((Object[])((ResponseDataWrapper)ResponseDataWrapper.this).data)[i] = ((Object[])ResponseDataWrapper.this.data)[i + 1];
                    }
                    ((Object[])((ResponseDataWrapper)ResponseDataWrapper.this).data)[((Object[])((ResponseDataWrapper)ResponseDataWrapper.this).data).length - 1] = null;
                }
            };
        }
        this.log.warn("List API called when the underlying data object is not a List or array");
        return null;
    }

    public Object[] toArray() {
        if (this.data instanceof List) {
            return ((List)this.data).toArray();
        }
        if (this.data instanceof Object[]) {
            Object[] a = new Object[((Object[])this.data).length];
            for (int i = 0; i < ((Object[])this.data).length; ++i) {
                a[i] = ((Object[])this.data)[i];
            }
            return a;
        }
        this.log.warn("List API called when the underlying data object is not a List or array");
        return null;
    }

    public Object[] toArray(Object[] a) {
        if (this.data instanceof List) {
            return ((List)this.data).toArray(a);
        }
        if (this.data instanceof Object[]) {
            return Arrays.asList((Object[])this.data).toArray(a);
        }
        this.log.warn("List API called when the underlying data object is not a List or array");
        return null;
    }

    public boolean add(Object e) {
        if (this.data instanceof List) {
            return ((List)this.data).add(e);
        }
        if (this.data instanceof Object[]) {
            this.log.warn("Dynamic List API called when the underlying data object is a static array");
            return false;
        }
        this.log.warn("List API called when the underlying data object is not a List or array");
        return false;
    }

    public boolean remove(Object o) {
        if (this.data instanceof List) {
            return ((List)this.data).remove(o);
        }
        if (this.data instanceof Object[]) {
            this.log.warn("Dynamic List API called when the underlying data object is a static array");
            return false;
        }
        this.log.warn("List API called when the underlying data object is not a List or array");
        return false;
    }

    public boolean containsAll(Collection c) {
        if (this.data instanceof List) {
            return ((List)this.data).containsAll(c);
        }
        if (this.data instanceof Object[]) {
            Object[] array = (Object[])this.data;
            boolean containsAll = true;
            Iterator a = c.iterator();
            if (a.hasNext()) {
                Object o;
                int i;
                for (i = 0; !(i >= array.length || (o = a.next()) == null && array[i] == null || o.equals(array[i])); ++i) {
                }
                if (i >= array.length) {
                    containsAll = false;
                }
            }
            return containsAll;
        }
        this.log.warn("List API called when the underlying data object is not a List or array");
        return false;
    }

    public boolean addAll(Collection c) {
        if (this.data instanceof List) {
            return ((List)this.data).addAll(c);
        }
        if (this.data instanceof Object[]) {
            this.log.warn("Dynamic List API called when the underlying data object is a static array");
            return false;
        }
        this.log.warn("List API called when the underlying data object is not a List or array");
        return false;
    }

    public boolean addAll(int index, Collection c) {
        if (this.data instanceof List) {
            return ((List)this.data).addAll(index, c);
        }
        if (this.data instanceof Object[]) {
            this.log.warn("Dynamic List API called when the underlying data object is a static array");
            return false;
        }
        this.log.warn("List API called when the underlying data object is not a List or array");
        return false;
    }

    public boolean removeAll(Collection c) {
        if (this.data instanceof List) {
            return ((List)this.data).removeAll(c);
        }
        if (this.data instanceof Object[]) {
            this.log.warn("Dynamic List API called when the underlying data object is a static array");
            return false;
        }
        this.log.warn("List API called when the underlying data object is not a List or array");
        return false;
    }

    public boolean retainAll(Collection c) {
        if (this.data instanceof List) {
            return ((List)this.data).retainAll(c);
        }
        if (this.data instanceof Object[]) {
            this.log.warn("Dynamic List API called when the underlying data object is a static array");
            return false;
        }
        this.log.warn("List API called when the underlying data object is not a List or array");
        return false;
    }

    public void clear() {
        if (this.data instanceof List) {
            ((List)this.data).clear();
            return;
        }
        if (this.data instanceof Object[]) {
            this.log.warn("Dynamic List API called when the underlying data object is a static array");
            return;
        }
        this.log.warn("List API called when the underlying data object is not a List or array");
    }

    public Object get(int index) {
        try {
            return this.get(new Integer(index));
        }
        catch (Exception e) {
            this.log.warn(e);
            return null;
        }
    }

    public Object set(int index, Object element) {
        if (this.data instanceof List) {
            return ((List)this.data).set(index, element);
        }
        if (this.data instanceof Object[]) {
            if (index < ((Object[])this.data).length) {
                ((Object[])this.data)[index] = element;
                return element;
            }
            this.log.warn("Index " + index + " is greater than the length of the underlying array");
            return null;
        }
        this.log.warn("List API called when the underlying data object is not a List or array");
        return false;
    }

    public void add(int index, Object element) {
        if (this.data instanceof List) {
            ((List)this.data).add(index, element);
            return;
        }
        if (this.data instanceof Object[]) {
            this.log.warn("Dynamic List API called when the underlying data object is a static array");
            return;
        }
        this.log.warn("List API called when the underlying data object is not a List or array");
    }

    public Object remove(int index) {
        if (this.data instanceof List) {
            return ((List)this.data).remove(index);
        }
        if (this.data instanceof Object[]) {
            this.log.warn("Dynamic List API called when the underlying data object is a static array");
            return null;
        }
        this.log.warn("List API called when the underlying data object is not a List or array");
        return null;
    }

    public int indexOf(Object o) {
        if (this.data instanceof List) {
            return ((List)this.data).indexOf(o);
        }
        if (this.data instanceof Object[]) {
            for (int i = 0; i < ((Object[])this.data).length; ++i) {
                if ((o != null || ((Object[])this.data)[i] != null) && !o.equals(((Object[])this.data)[i])) continue;
                return i;
            }
            return -1;
        }
        this.log.warn("List API called when the underlying data object is not a List or array");
        return -1;
    }

    public int lastIndexOf(Object o) {
        if (this.data instanceof List) {
            return ((List)this.data).lastIndexOf(o);
        }
        if (this.data instanceof Object[]) {
            for (int i = ((Object[])this.data).length - 1; i >= 0; --i) {
                if ((o != null || ((Object[])this.data)[i] != null) && !o.equals(((Object[])this.data)[i])) continue;
                return i;
            }
            return -1;
        }
        this.log.warn("List API called when the underlying data object is not a List or array");
        return -1;
    }

    public ListIterator listIterator() {
        if (this.data instanceof List) {
            return ((List)this.data).listIterator();
        }
        if (this.data instanceof Object[]) {
            return this.getListIterator(0);
        }
        this.log.warn("List API called when the underlying data object is not a List or array");
        return null;
    }

    public ListIterator listIterator(int index) {
        return this.getListIterator(index);
    }

    private ListIterator getListIterator(final int index) {
        return new ListIterator(){
            private int counter;
            {
                this.counter = index;
            }

            public boolean hasNext() {
                return this.counter < ((Object[])ResponseDataWrapper.this.data).length;
            }

            public Object next() {
                return ((Object[])ResponseDataWrapper.this.data)[this.counter++];
            }

            public boolean hasPrevious() {
                return this.counter > 0;
            }

            public Object previous() {
                return ((Object[])ResponseDataWrapper.this.data)[--this.counter];
            }

            public int nextIndex() {
                return this.counter;
            }

            public int previousIndex() {
                return this.counter - 1;
            }

            public void remove() {
                for (int i = this.counter; i < ((Object[])ResponseDataWrapper.this.data).length - 1; ++i) {
                    ((Object[])((ResponseDataWrapper)ResponseDataWrapper.this).data)[i] = ((Object[])ResponseDataWrapper.this.data)[i + 1];
                }
                ((Object[])((ResponseDataWrapper)ResponseDataWrapper.this).data)[((Object[])((ResponseDataWrapper)ResponseDataWrapper.this).data).length - 1] = null;
            }

            public void set(Object e) {
                ((Object[])((ResponseDataWrapper)ResponseDataWrapper.this).data)[this.counter] = e;
            }

            public void add(Object e) {
                ResponseDataWrapper.this.log.warn("Dynamic List API called when the underlying data object is a static array");
            }
        };
    }

    public List subList(int fromIndex, int toIndex) {
        if (this.data instanceof List) {
            return ((List)this.data).subList(fromIndex, toIndex);
        }
        if (this.data instanceof Object[]) {
            return Arrays.asList((Object[])this.data).subList(fromIndex, toIndex);
        }
        this.log.warn("List API called when the underlying data object is not a List or array");
        return null;
    }
}

