/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.contentexport;

import com.isomorphic.io.ISCFile;
import com.isomorphic.log.Logger;
import com.lowagie.text.BadElementException;
import com.lowagie.text.Image;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.xhtmlrenderer.extend.FSImage;
import org.xhtmlrenderer.layout.SharedContext;
import org.xhtmlrenderer.pdf.ITextFSImage;
import org.xhtmlrenderer.pdf.ITextFontResolver;
import org.xhtmlrenderer.pdf.ITextOutputDevice;
import org.xhtmlrenderer.pdf.ITextUserAgent;
import org.xhtmlrenderer.resource.ImageResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceLoader
extends ITextUserAgent {
    private String resource = "";
    private List<String> extraResources;
    private Logger log = new Logger(ResourceLoader.class.getName());
    private SharedContext sharedContext;
    private ITextFontResolver resolver;

    private static boolean startsWithIgnoreCase(String str, String prefix) {
        if (str.length() < prefix.length()) {
            return false;
        }
        return str.substring(0, prefix.length()).equalsIgnoreCase(prefix);
    }

    public ResourceLoader(ITextOutputDevice outputDevice, String resource, List<String> extraResources, ITextFontResolver resolver) {
        super(outputDevice);
        this.resource = resource;
        this.extraResources = extraResources;
        this.resolver = resolver;
    }

    protected InputStream resolveAndOpenStream(String uri) {
        String[] split;
        String resourceName;
        String resourceFinal;
        Object firstWarningObj;
        String resolvedURL;
        InputStream is;
        block29: {
            is = null;
            resolvedURL = this.resolveURI(uri);
            firstWarningObj = null;
            resourceFinal = "";
            resourceName = "";
            split = null;
            if (uri.toLowerCase().endsWith(".otf") || uri.toLowerCase().endsWith(".ttf") || uri.toLowerCase().endsWith(".ttc")) {
                resourceFinal = this.resource + "fonts";
                split = uri.split("fonts");
                try {
                    resourceName = split[split.length - 1];
                    ISCFile iscFile = ISCFile.newInstance((String)(resourceFinal + resourceName));
                    if (iscFile.exists()) {
                        this.resolver.addFont(resourceFinal + resourceName, "Identity-H", false);
                        is = iscFile.getInputStream();
                    } else {
                        resourceFinal = this.resource;
                        split = uri.split("/");
                        resourceName = split[split.length - 1];
                        iscFile = ISCFile.newInstance((String)(resourceFinal + resourceName));
                        if (iscFile.exists()) {
                            this.resolver.addFont(resourceFinal + resourceName, "Identity-H", false);
                            is = iscFile.getInputStream();
                        } else {
                            this.log.info((Object)("Resource not found in main path: " + resourceFinal + resourceName + ". Searching in alternative paths"));
                            if (this.extraResources.size() != 0) {
                                for (int i = 0; i < this.extraResources.size(); ++i) {
                                    String extraResource = this.extraResources.get(i);
                                    resourceFinal = extraResource + "fonts";
                                    split = uri.split("fonts");
                                    resourceName = split[split.length - 1];
                                    iscFile = ISCFile.newInstance((String)(resourceFinal + resourceName));
                                    if (iscFile.exists()) {
                                        this.resolver.addFont(resourceFinal + resourceName, "Identity-H", false);
                                        is = iscFile.getInputStream();
                                        this.log.info((Object)("Resource '" + resourceName + "' found in an alternative path"));
                                        continue;
                                    }
                                    resourceFinal = extraResource;
                                    split = uri.split("/");
                                    resourceName = split[split.length - 1];
                                    iscFile = ISCFile.newInstance((String)(resourceFinal + resourceName));
                                    if (iscFile.exists()) {
                                        this.resolver.addFont(resourceFinal + resourceName, "Identity-H", false);
                                        is = iscFile.getInputStream();
                                        this.log.info((Object)("Resource '" + resourceName + "' found in an alternative path"));
                                        continue;
                                    }
                                    this.log.info((Object)("Resource not found in alternative path: " + resourceFinal + resourceName));
                                }
                            } else {
                                this.log.info((Object)("Alternative paths not found. Resource not found: " + resourceFinal + resourceName));
                            }
                        }
                    }
                }
                catch (Exception e) {
                    this.log.warn((Object)("Error when trying to load the resource '" + resourceName + "'. Resource not loaded. Error: " + e.getMessage()));
                }
                return is;
            }
            try {
                is = new URL(resolvedURL).openStream();
            }
            catch (MalformedURLException e) {
                this.log.warn((Object)("Malformed URL " + resolvedURL));
            }
            catch (IOException e) {
                firstWarningObj = e;
                if (!(e instanceof FileNotFoundException) || !ResourceLoader.startsWithIgnoreCase(resolvedURL, "http")) break block29;
                firstWarningObj = "java.io.IOException: Server returned HTTP response code: 404";
            }
        }
        if (is == null) {
            resourceFinal = "";
            resourceName = "";
            split = null;
            if (!uri.contains(".css")) {
                resourceFinal = this.resource + "images";
                split = uri.split("images");
            } else {
                resourceFinal = this.resource;
                split = uri.split("/");
            }
            try {
                resourceName = split[split.length - 1];
                ISCFile iscFile = ISCFile.newInstance((String)(resourceFinal + resourceName));
                is = iscFile.getInputStream();
            }
            catch (Exception e) {
                if (firstWarningObj != null) {
                    this.log.warn((Object)("Failed to download " + resolvedURL), firstWarningObj);
                }
                if (this.extraResources.size() != 0) {
                    this.log.info((Object)("Resource not found in main path. Error: " + e.getMessage() + ". Searching in alternative paths"));
                    for (int i = 0; i < this.extraResources.size(); ++i) {
                        String extraResource = this.extraResources.get(i);
                        if (!uri.contains(".css")) {
                            resourceFinal = extraResource + "images";
                            split = uri.split("images");
                        } else {
                            resourceFinal = extraResource;
                            split = uri.split("/");
                        }
                        try {
                            resourceName = split[split.length - 1];
                            is = super.resolveAndOpenStream(resourceFinal + resourceName);
                            if (is == null) {
                                ISCFile iscFile = ISCFile.newInstance((String)(resourceFinal + resourceName));
                                is = iscFile.getInputStream();
                            }
                            this.log.info((Object)("Resource '" + resourceName + "' found in an alternative path"));
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (is == null) {
                        this.log.warn((Object)("Resource '" + resourceName + "' not found in main path or any alternative path."));
                    }
                }
                this.log.warn((Object)("Resource '" + resourceName + "' not found"), (Object)e);
            }
        }
        return is;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageResource getImageResource(String uri) {
        InputStream is;
        ImageResource resource = null;
        resource = (ImageResource)this._imageCache.get(uri = this.resolveURI(uri));
        if (resource == null && (is = this.resolveAndOpenStream(uri)) != null) {
            try {
                int len;
                int size = 1024;
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                byte[] buf = new byte[size];
                while ((len = is.read(buf, 0, size)) != -1) {
                    bos.write(buf, 0, len);
                }
                buf = bos.toByteArray();
                Image image = Image.getInstance((byte[])buf);
                this.scaleToOutputResolution(image);
                resource = new ImageResource((FSImage)new ITextFSImage(image));
                this._imageCache.put(uri, resource);
            }
            catch (IOException e) {
                this.log.error((Object)("Can't read image file; unexpected problem for URI '" + uri + "'"), (Throwable)e);
            }
            catch (BadElementException e) {
                this.log.error((Object)("Can't read image file; unexpected problem for URI '" + uri + "'"), (Throwable)e);
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        if (resource == null) {
            resource = new ImageResource(null);
        }
        return resource;
    }

    private void scaleToOutputResolution(Image image) {
        float factor = this.sharedContext.getDotsPerPixel();
        image.scaleAbsolute(image.getPlainWidth() * factor, image.getPlainHeight() * factor);
    }

    public void setSharedContext(SharedContext sharedContext) {
        this.sharedContext = sharedContext;
        super.setSharedContext(sharedContext);
    }

    public SharedContext getSharedContext() {
        return this.sharedContext;
    }
}

