/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.servlet;

import com.isomorphic.base.Config;
import com.isomorphic.collections.DataTypeMap;
import com.isomorphic.criteria.AdvancedCriteria;
import com.isomorphic.criteria.DefaultOperators;
import com.isomorphic.datasource.DSFileSpec;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.DataSourceManager;
import com.isomorphic.io.SequenceReader;
import com.isomorphic.js.IToJSON;
import com.isomorphic.js.JSTranslater;
import com.isomorphic.js.UnconvertableException;
import com.isomorphic.log.Logger;
import com.isomorphic.util.DataTools;
import com.isomorphic.xml.XML;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Screen
implements IToJSON {
    private static Config config = Config.getGlobal();
    private static Logger log = new Logger(Screen.class.getName());
    private static String storageDS = config.getString("project.vbScreensDS");
    private static String fileType = "ui";
    private static String fileFormat = "xml";
    DataTypeMap data;
    DataTypeMap metadata;

    public Screen(String xml, Map metadata) throws Exception {
        this(Screen.dataFromXML(xml), metadata);
    }

    public Screen(Map data, Map metadata) {
        this.data = new DataTypeMap(data);
        this.metadata = metadata == null ? new DataTypeMap() : new DataTypeMap(metadata);
    }

    private static Map dataFromXML(String xml) throws Exception {
        return (Map)XML.toDSRecords(new SequenceReader("<Object><components xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:type=\"xsd:List\">", xml, "</components></Object>"));
    }

    public static Screen load(String name) throws Exception {
        return Screen.load((Object)DataTools.buildMap("fileName", name));
    }

    public static Screen load(String name, String ownerId) throws Exception {
        return Screen.load((Object)DataTools.buildMap("fileName", name, "ownerId", ownerId));
    }

    public static Screen load(Object criteria) throws Exception {
        List<Screen> resultsMatchingCriteria = Screen.list(criteria);
        if (resultsMatchingCriteria.size() == 0) {
            return null;
        }
        if (resultsMatchingCriteria.size() > 1) {
            throw new Exception("Multiple Screens (" + resultsMatchingCriteria.size() + ") matched criteria for load() - expected only one.");
        }
        return resultsMatchingCriteria.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Screen> list(Object criteria) throws Exception {
        if (criteria == null) {
            criteria = new HashMap();
        }
        if (criteria instanceof Map) {
            Map m = criteria;
            if (m.get("fileType") == null) {
                m.put("fileType", fileType);
            }
            if (m.get("fileFormat") == null) {
                m.put("fileFormat", fileFormat);
            }
        } else {
            AdvancedCriteria c = (AdvancedCriteria)((Object)criteria);
            if (c.getFieldValue("fileType") == null) {
                c.addCriteria("fileType", DefaultOperators.Equals, fileType);
            }
            if (c.getFieldValue("fileFormat") == null) {
                c.addCriteria("fileFormat", DefaultOperators.Equals, fileFormat);
            }
        }
        ArrayList<Screen> results = new ArrayList<Screen>();
        DataSource ds = null;
        try {
            ds = DataSourceManager.get(storageDS);
            List<Map<String, Object>> files = ds.listFiles(criteria);
            for (Map<String, Object> metadata : files) {
                String xml = ds.getFileAsString(new DSFileSpec(metadata));
                results.add(new Screen(xml, metadata));
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            DataSourceManager.free(ds);
            throw throwable;
        }
        DataSourceManager.free(ds);
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Screen persist() throws Exception {
        Screen screen;
        StringWriter sw = new StringWriter();
        List<Map> components = this.getComponents();
        for (Map component : components) {
            Object var8_7;
            String tagName = (String)component.get("__autoConstruct");
            if (tagName == null) {
                tagName = "Object";
            }
            DataSource transformDS = null;
            try {
                transformDS = DataSourceManager.get(tagName);
                var8_7 = null;
            }
            catch (Throwable throwable) {
                var8_7 = null;
                DataSourceManager.free(transformDS);
                throw throwable;
            }
            DataSourceManager.free(transformDS);
            XML.recordToXML(tagName, component, sw, false, false, transformDS, null);
        }
        DataSource ds = null;
        try {
            ds = DataSourceManager.get(storageDS);
            Map<String, Object> metadataAsSaved = ds.saveFile(new DSFileSpec((Map)((Object)this.metadata)), sw.toString());
            screen = Screen.load(metadataAsSaved);
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            DataSourceManager.free(ds);
            throw throwable;
        }
        DataSourceManager.free(ds);
        return screen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove() throws Exception {
        if (this.getName() == null) {
            throw new Exception("Cannot remove a Screen that has not yet been persisted");
        }
        DataSource ds = null;
        try {
            ds = DataSourceManager.get(storageDS);
            ds.removeFile(new DSFileSpec((Map)((Object)this.metadata)));
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            DataSourceManager.free(ds);
            throw throwable;
        }
        DataSourceManager.free(ds);
    }

    @Override
    public void toJSON(Writer out, JSTranslater jsTrans) throws UnconvertableException, IOException {
        List<Map> components = this.getComponents();
        if (components == null) {
            return;
        }
        for (Map component : components) {
            jsTrans.toJS(component, out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Screen rename(String newName) throws Exception {
        Screen screen;
        if (this.getName() == null) {
            throw new Exception("Cannot rename a Screen that has not yet been persisted");
        }
        DataSource ds = null;
        try {
            ds = DataSourceManager.get(storageDS);
            List<Map<String, Object>> renamedFiles = ds.renameFile(new DSFileSpec((Map)((Object)this.metadata)), new DSFileSpec((Map)((Object)DataTools.buildMap("fileName", newName))));
            Map<String, Object> metadataAsSaved = renamedFiles.get(0);
            screen = Screen.load(metadataAsSaved);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            DataSourceManager.free(ds);
            throw throwable;
        }
        DataSourceManager.free(ds);
        return screen;
    }

    public String getName() {
        return this.metadata.getString("fileName");
    }

    public DataTypeMap getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map metadata) {
        this.metadata = new DataTypeMap(metadata);
    }

    public String getOwner() {
        return this.metadata.getString("ownerId");
    }

    public void setOwner(String owner) {
        this.metadata.put("ownerId", owner);
    }

    public List<Map> getComponents() {
        return this.data.getList("components");
    }

    public void setComponents(Collection components) {
        this.data.put("components", new ArrayList(components));
    }
}

