package com.smartgwt.sample.showcase.client.portal;

import com.smartgwt.client.tools.EditNode;
import com.smartgwt.client.tools.Palette;
import com.smartgwt.client.tools.PaletteNode;
import com.smartgwt.client.tools.TilePalette;
import com.smartgwt.client.widgets.drawing.DrawItem;
import com.smartgwt.client.widgets.drawing.DrawPane;
import com.smartgwt.client.widgets.drawing.Gradient;
import com.smartgwt.client.widgets.tile.SimpleTile;
import com.smartgwt.client.widgets.tile.TileRecord;

// Class for all of the tiles in the TilePalette for Diagramming Sample.
// Each tile has a DrawPane that is used to render a single DrawItem.
public class DrawItemTile extends SimpleTile {

	private DrawPane drawPane;

	private static Gradient[] commonGradients;

	public static void setCommonGradients(Gradient[] gradients) {
		commonGradients = gradients;
	}

	public DrawItemTile() {
		super();

		drawPane = new DrawPane();
		drawPane.setWidth100();
		drawPane.setHeight100();
		drawPane.setGradients(commonGradients);
		
		this.addChild(drawPane);
	}

	@Override
	public String getInnerHTML() {
		// We do not want the default HTML generated by the superclass SimpleTile's
		// getInnerHTML() method to be drawn, so just return a blank HTML string here.
		return "&nbsp;";
	}

	
	@Override
	protected void onDraw() {
		super.onDraw();
		drawRecord(this.getRecord());
	}

	private void drawRecord (TileRecord record) {
		PaletteNode paletteNode = new PaletteNode(record.getJsObj());
		
		Palette palette = (TilePalette)this.getCreator();
		EditNode editNode = palette.makeEditNode(paletteNode);
		DrawItem drawItem = editNode.getDrawItemLiveObject();
		drawPane.addDrawItem(drawItem, true);
	}
}
