/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.instrument.classloading;

import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.util.Assert;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShadowingClassLoader
extends ClassLoader {
    public static final String[] DEFAULT_EXCLUDED_PACKAGES = new String[]{"java.", "javax.", "sun.", "oracle.", "com.sun.", "com.ibm.", "COM.ibm.", "org.w3c.", "org.xml.", "org.dom4j.", "org.aspectj.", "org.apache.xerces.", "org.apache.commons.logging."};
    private final ClassLoader enclosingClassLoader;
    private final Set excludedPackages = Collections.synchronizedSet(new HashSet());
    private final Set excludedClasses = Collections.synchronizedSet(new HashSet());
    private final List<ClassFileTransformer> classFileTransformers = new LinkedList<ClassFileTransformer>();
    private final Map<String, Class> classCache = new HashMap<String, Class>();

    public ShadowingClassLoader(ClassLoader enclosingClassLoader) {
        Assert.notNull(enclosingClassLoader, "Enclosing ClassLoader must not be null");
        this.enclosingClassLoader = enclosingClassLoader;
        for (int i = 0; i < DEFAULT_EXCLUDED_PACKAGES.length; ++i) {
            this.excludedPackages.add(DEFAULT_EXCLUDED_PACKAGES[i]);
        }
    }

    public void excludePackage(String packageName) {
        Assert.notNull(packageName, "Package name must not be null");
        this.excludedPackages.add(packageName);
    }

    public void excludeClass(String className) {
        Assert.notNull(className, "Class name must not be null");
        this.excludedClasses.add(className);
    }

    public void addTransformer(ClassFileTransformer transformer) {
        Assert.notNull(transformer, "Transformer must not be null");
        this.classFileTransformers.add(transformer);
    }

    public void copyTransformers(ShadowingClassLoader other) {
        Assert.notNull(other, "Other ClassLoader must not be null");
        this.classFileTransformers.addAll(other.classFileTransformers);
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        if (this.shouldShadow(name)) {
            Class cls = this.classCache.get(name);
            if (cls != null) {
                return cls;
            }
            return this.doLoadClass(name);
        }
        return this.enclosingClassLoader.loadClass(name);
    }

    private boolean shouldShadow(String className) {
        return !className.equals(this.getClass().getName()) && !className.endsWith("ShadowingClassLoader") && this.isEligibleForShadowing(className) && !this.isClassNameExcludedFromShadowing(className);
    }

    protected boolean isEligibleForShadowing(String className) {
        if (this.excludedClasses.contains(className)) {
            return false;
        }
        for (String packageName : this.excludedPackages) {
            if (!className.startsWith(packageName)) continue;
            return false;
        }
        return true;
    }

    protected boolean isClassNameExcludedFromShadowing(String className) {
        return false;
    }

    private Class doLoadClass(String name) throws ClassNotFoundException {
        String internalName = StringUtils.replace(name, ".", "/") + ".class";
        InputStream is = this.enclosingClassLoader.getResourceAsStream(internalName);
        if (is == null) {
            throw new ClassNotFoundException(name);
        }
        try {
            byte[] bytes = FileCopyUtils.copyToByteArray(is);
            bytes = this.applyTransformers(name, bytes);
            Class<?> cls = this.defineClass(name, bytes, 0, bytes.length);
            if (cls.getPackage() == null) {
                String packageName = name.substring(0, name.lastIndexOf(46));
                this.definePackage(packageName, null, null, null, null, null, null, null);
            }
            this.classCache.put(name, cls);
            return cls;
        }
        catch (IOException ex) {
            throw new ClassNotFoundException("Cannot load resource for class [" + name + "]", ex);
        }
    }

    private byte[] applyTransformers(String name, byte[] bytes) {
        String internalName = StringUtils.replace(name, ".", "/");
        try {
            for (ClassFileTransformer transformer : this.classFileTransformers) {
                byte[] transformed = transformer.transform(this, internalName, null, null, bytes);
                bytes = transformed != null ? transformed : bytes;
            }
            return bytes;
        }
        catch (IllegalClassFormatException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public URL getResource(String name) {
        return this.enclosingClassLoader.getResource(name);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        return this.enclosingClassLoader.getResourceAsStream(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        return this.enclosingClassLoader.getResources(name);
    }
}

