/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.sql;

import com.isomorphic.base.Config;
import com.isomorphic.base.Reflection;
import com.isomorphic.datasource.DSField;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.log.Logger;
import com.isomorphic.sql.SQLDataSource;
import com.isomorphic.sql.SQLDriver;
import com.isomorphic.sql.SQLTable;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class InformixDriver
extends SQLDriver {
    private static Logger log = new Logger(InformixDriver.class.getName());

    public static SQLDriver instance(String dbName, SQLTable table) throws Exception {
        return new InformixDriver(dbName, table);
    }

    public static SQLDriver instance(String dbName) throws Exception {
        return new InformixDriver(dbName);
    }

    public InformixDriver(String dbName, SQLTable table) throws Exception {
        super(dbName, table);
        this.init(dbName);
    }

    public void init(String dbName) throws Exception {
    }

    public InformixDriver(String dbName) throws Exception {
        super(dbName, null);
        this.init(dbName);
    }

    public boolean supportsSQLLimit() {
        return true;
    }

    public String limitQuery(String query, long startRow, long batchSize, List outputColumns) {
        String selectToken = query.substring(0, "SELECT".length());
        if (!"SELECT".equalsIgnoreCase(selectToken)) {
            return query;
        }
        return "SELECT SKIP " + startRow + " FIRST " + batchSize + query.substring("SELECT".length());
    }

    public Map fetchLastPrimaryKeys(Map primaryKeysPresent, List sequencesNotPresent, SQLDataSource ds, DSRequest req) throws Exception {
        log.debug((Object)("fetchLastRow data - primaryKeysPresent: " + primaryKeysPresent.toString() + "sequencesNotPresent: " + sequencesNotPresent.toString()));
        if (sequencesNotPresent.size() > 1) {
            throw new Exception("Informix can't handle more than one SERIAL primaryKey");
        }
        if (this.dbConnection == null && req == null) {
            throw new Exception("no connection exists for last row fetch");
        }
        Object sqlStatement = null;
        Map primaryKeys = primaryKeysPresent;
        if (!sequencesNotPresent.isEmpty()) {
            String sequenceName = (String)sequencesNotPresent.get(0);
            throw new Exception("Sequence value missing for field " + sequenceName);
        }
        return primaryKeys;
    }

    public void saveGeneratedKeys(Statement s, DSRequest req) throws Exception {
        SQLDataSource ds = (SQLDataSource)req.getDataSource();
        List pkNames = ds.getPrimaryKeys();
        String pkName = null;
        int count = 0;
        Iterator i = pkNames.iterator();
        while (i.hasNext()) {
            DSField pk = ds.getField((String)i.next());
            if (!"sequence".equals(pk.getType())) continue;
            ++count;
            pkName = pk.getName();
        }
        if (count != 1) {
            return;
        }
        if (!InformixDriver.supportsGetGeneratedKeys(s.getConnection())) {
            Method method = null;
            try {
                method = Reflection.findMethod((Object)s, (String)"getSerial8");
            }
            catch (NoSuchMethodException pk) {
                // empty catch block
            }
            if (method == null) {
                log.warn((Object)("Unable to retrieve last inserted PK value - Statement of class " + s.getClass().getName() + " does not implement a getSerial() method"));
                return;
            }
            Object obj = method.invoke((Object)s, new Object[0]);
            if (obj == null || Long.parseLong(obj.toString()) == 0L) {
                method = null;
                try {
                    method = Reflection.findMethod((Object)s, (String)"getSerial");
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                if (method != null) {
                    obj = method.invoke((Object)s, new Object[0]);
                }
            }
            if (obj == null) {
                log.warn((Object)"Unable to retrieve last inserted PK value - both getSerial8() and getSerial() returned null");
                return;
            }
            if (!(obj instanceof Integer) && !(obj instanceof Long)) {
                log.warn((Object)("Unable to retrieve last inserted PK value - either getSerial8() or getSerial() returned a " + obj.getClass().getName() + ", expected an Integer or a Long"));
                return;
            }
            long value = Long.parseLong(obj.toString());
            if (value == 0L) {
                log.warn((Object)"Unable to retrieve last inserted PK value - either getSerial8() or getSerial() returned 0, which is a special value meaning 'there was a problem'");
                return;
            }
            HashMap<String, Long> primaryKeys = new HashMap<String, Long>();
            primaryKeys.put(pkName, value);
            ds.setLastPrimaryKeys(primaryKeys);
        } else {
            super.saveGeneratedKeys(s, req);
        }
    }

    protected PreparedStatement getPreparedStatement(Connection conn, String update) throws SQLException {
        if (InformixDriver.supportsGetGeneratedKeys(conn)) {
            return conn.prepareStatement(update, 1);
        }
        return conn.prepareStatement(update);
    }

    public boolean supportsNativeReplace() {
        return false;
    }

    public String sqlOutTransform(String columnName, String remapName, String tableName) throws Exception {
        String output = this.escapeColumnName(columnName);
        if (tableName != null) {
            output = tableName + "." + output;
        }
        if (remapName != null && !columnName.equals(remapName)) {
            output = output + " AS " + remapName;
        }
        return output;
    }

    public String escapeValue(Object value) {
        if (value == null) {
            return null;
        }
        return "'" + this.escapeValueUnquoted(value, false) + "'";
    }

    public String escapeValueForFilter(Object value) {
        return this.escapeValueForFilter(value, null);
    }

    public String escapeValueForFilter(Object value, String filterStyle) {
        if (value == null) {
            return null;
        }
        if (filterStyle == null) {
            filterStyle = "substring";
        }
        String rtn = "'";
        if (!"startsWith".equals(filterStyle)) {
            rtn = rtn + "%";
        }
        return rtn + this.escapeValueUnquoted(value, true) + "%'";
    }

    public String escapeValueUnquoted(Object value, boolean escapeForFilter) {
        if (value == null) {
            return null;
        }
        String escaped = globalPerl.substitute("s/'/''/go", value.toString());
        if (!escapeForFilter) {
            escaped = globalPerl.substitute("s'\\\\'\\\\\\\\'go", escaped);
        } else {
            escaped = globalPerl.substitute("s'\\\\'\\\\\\\\\\\\\\\\'go", escaped);
            escaped = globalPerl.substitute("s'%'\\\\%'go", escaped);
            escaped = globalPerl.substitute("s'_'\\\\_'go", escaped);
        }
        return escaped;
    }

    public String formatValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            return this.utcDateTimeFormatter.format((Date)value);
        }
        return value.toString();
    }

    public String getNextSequenceValue(String columnName, SQLDataSource ds) throws Exception {
        return "0";
    }

    protected String getExpressionForSortBy(String column, Map valueMap, DSRequest request) {
        if (valueMap == null || valueMap.size() == 0) {
            return column;
        }
        String expr = "CASE " + column;
        for (String actualValue : valueMap.keySet()) {
            String displayValue = this.getLocalizedDisplayValue(valueMap.get(actualValue), request);
            displayValue = this.escapeValue(displayValue);
            expr = expr + " WHEN '" + actualValue + "' THEN " + displayValue;
        }
        expr = expr + " ELSE " + column + " END";
        return expr;
    }

    public String getURLParameterString() {
        return this.useUTCDateTimes ? "serverTimezone=UTC" : null;
    }

    public void addDriverProperties(Map properties) {
        if (this.useUTCDateTimes) {
            properties.put("serverTimezone", "UTC");
        }
    }

    public String getDriverNameForURL(Config driverConfig) {
        return "informix-sqli";
    }

    public boolean fieldAssignableInline(DSField field) {
        if (!super.fieldAssignableInline(field)) {
            return false;
        }
        return !"text".equals(field.getType()) || field.getLength() == null || field.getLength() < 32739L;
    }

    public boolean castNumbersBeforeLikeCompare() {
        return true;
    }

    public Object transformFieldValue(DSField field, Object obj) {
        if (obj instanceof byte[] && !field.isBinary()) {
            return new String((byte[])obj);
        }
        return obj;
    }

    public String getNaturalDatabaseObjectName(String objectName) {
        return objectName == null ? null : objectName.toLowerCase();
    }

    public String getDummyQuery() {
        return "SELECT COUNT(*) FROM systables";
    }
}

