/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.auth;

import com.isomorphic.auth.IAuthenticator;
import com.isomorphic.base.Base;
import com.isomorphic.base.IAutoConfigurable;
import com.isomorphic.servlet.ISCHttpServletRequest;
import com.isomorphic.servlet.RequestContext;
import com.isomorphic.servlet.ServletTools;
import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileUpload;

public abstract class Authenticator
extends Base
implements IAutoConfigurable,
IAuthenticator {
    public String usernameParameter = "username";
    public String passwordParameter = "password";
    private String userKey = "user";
    private String realmKey = "isc.auth.realm";
    private String loginCounterKey = "loginCounter";
    private String initialTargetKey = "initialTarget";
    private String jsCallbackKey = "jsCallback";

    public boolean containsCredentials(RequestContext context) throws Exception {
        return this.getSubmittedUsername(context) != null && this.getSubmittedPassword(context) != null;
    }

    public String getUsername(RequestContext context, Object user) throws Exception {
        return this.getSubmittedUsername(context);
    }

    protected String getSubmittedUsername(RequestContext context) throws Exception {
        return this.getRequestParameter(this.usernameParameter, context);
    }

    protected String getSubmittedPassword(RequestContext context) throws Exception {
        return this.getRequestParameter(this.passwordParameter, context);
    }

    protected String getRequestParameter(String parameterName, RequestContext context) {
        if (FileUpload.isMultipartContent((HttpServletRequest)context.request)) {
            Map queryParams = null;
            try {
                queryParams = ServletTools.parseQueryString(context.request.getQueryString());
            }
            catch (Exception e) {
                RequestContext.staticLog.error((Object)"Authenticator can't parse queryParams", e);
                return null;
            }
            return (String)queryParams.get(parameterName);
        }
        return context.request.getParameter(parameterName);
    }

    public void logout(RequestContext context) throws Exception {
        this.clearAuthInfo(context);
    }

    public abstract Principal authenticate(RequestContext var1) throws Exception;

    public void setUser(RequestContext context, Principal user) throws Exception {
        this.setContextValue(context, this.userKey, user);
        if (context.request instanceof ISCHttpServletRequest) {
            context.request.setUserPrincipal(user);
        }
    }

    public Principal getUser(RequestContext context) throws Exception {
        return (Principal)this.getContextValue(context, this.userKey);
    }

    public void setRealm(RequestContext context, String realm) throws Exception {
        context.request.setAttribute(this.realmKey, realm);
    }

    public String getRealm(RequestContext context) throws Exception {
        return (String)context.request.getAttribute(this.realmKey);
    }

    public void setLoginCounter(RequestContext context, int counter) throws Exception {
        this.setContextValue(context, this.loginCounterKey, new Integer(counter));
    }

    public int getLoginCounter(RequestContext context) throws Exception {
        Integer counter = (Integer)this.getContextValue(context, this.loginCounterKey);
        if (counter == null) {
            return 0;
        }
        return counter;
    }

    public String getInitialTarget(RequestContext context) throws Exception {
        return (String)this.getContextValue(context, this.initialTargetKey);
    }

    public void setInitialTarget(RequestContext context, String initialTarget) throws Exception {
        this.setContextValue(context, this.initialTargetKey, initialTarget);
    }

    public String getInitialTargetJsCallback(RequestContext context) throws Exception {
        return (String)this.getContextValue(context, this.jsCallbackKey);
    }

    public void setInitialTargetJsCallback(RequestContext context, String jsCallback) throws Exception {
        this.setContextValue(context, this.jsCallbackKey, jsCallback);
    }

    public void clearAuthInfo(RequestContext context) throws Exception {
        String authStateKey = (String)context.request.getAttribute(this.realmKey);
        if (authStateKey == null) {
            return;
        }
        if (context.session == null) {
            context.session = context.request.getSession(true);
        }
        context.session.setAttribute(authStateKey, null);
    }

    protected Object getContextValue(RequestContext context, String key) throws Exception {
        Map contextStore;
        String authStateKey = (String)context.request.getAttribute(this.realmKey);
        if (authStateKey == null) {
            throw new Exception("No context for getContextValue() with key: " + key + " (make sure your authenticator covers this URI: " + context.request.getRequestURI());
        }
        if (context.session == null) {
            context.session = context.request.getSession(true);
        }
        if ((contextStore = (Map)context.session.getAttribute(authStateKey)) == null) {
            return null;
        }
        return contextStore.get(key);
    }

    protected void setContextValue(RequestContext context, String key, Object value) throws Exception {
        HashMap<String, Object> contextStore;
        String authStateKey = (String)context.request.getAttribute(this.realmKey);
        if (authStateKey == null) {
            throw new Exception("No context for getContextValue() with key: " + key + " (make sure your authenticator covers this URI: " + context.request.getRequestURI());
        }
        if (context.session == null) {
            context.session = context.request.getSession(true);
        }
        if ((contextStore = (HashMap<String, Object>)context.session.getAttribute(authStateKey)) == null) {
            contextStore = new HashMap<String, Object>();
            context.session.setAttribute(authStateKey, contextStore);
        }
        contextStore.put(key, value);
    }

    public Object getUserId(RequestContext context) throws Exception {
        Principal user = this.getUser(context);
        if (user != null) {
            return user.getName();
        }
        return null;
    }

    public void track(RequestContext context) throws Exception {
    }
}

