/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.js;

import com.isomorphic.base.Base;
import com.isomorphic.js.JSTranslater;
import com.isomorphic.js.TrailingCommaException;
import com.isomorphic.log.Logger;
import isc.org.apache.oro.text.perl.Perl5Util;

public class JSSyntaxScanner
extends Base {
    private static Logger log = new Logger(JSSyntaxScanner.class.getName());

    public static JSSyntaxScanner instance() {
        return new JSSyntaxScanner();
    }

    public void scanHTML(String buf, String fileName) throws Exception {
        Perl5Util regex = new Perl5Util();
        if (buf == null) {
            return;
        }
        int length = buf.length();
        int startIndex = 0;
        boolean inScript = false;
        int line = 1;
        int lineChar = 0;
        block4: for (int i = 0; i < length; ++i) {
            char theChar = buf.charAt(i);
            ++lineChar;
            switch (theChar) {
                case '\n': 
                case '\r': {
                    ++line;
                    lineChar = 0;
                    continue block4;
                }
                case '<': {
                    if (length > i + 8 && buf.regionMatches(true, i + 1, "/script>", 0, 8)) {
                        if (!inScript) continue block4;
                        if (startIndex != i) {
                            this.scanJS(buf.substring(startIndex, i), fileName);
                        }
                        i += 8;
                        lineChar += 8;
                        inScript = false;
                        continue block4;
                    }
                    if (length <= i + 6 || !buf.regionMatches(true, i + 1, "script", 0, 6)) continue block4;
                    boolean jsBlock = false;
                    int closeIndex = buf.indexOf(">", i + 7);
                    if (buf.charAt(i + 7) == '>') {
                        jsBlock = true;
                    } else {
                        if (closeIndex == -1) {
                            throw new Exception("Script block with missing rightbracket at line: " + line);
                        }
                        String sub = buf.substring(i + 7, closeIndex + 1);
                        jsBlock = true;
                        if (regex.match("m#(language|type)=#i", sub) && !regex.match("m#(language|type)=.*(javascript|ecmascript|jscript)#i", sub)) {
                            jsBlock = false;
                        }
                    }
                    if (!jsBlock) continue block4;
                    inScript = true;
                    lineChar = closeIndex - i;
                    i = closeIndex;
                    startIndex = i + 1;
                }
            }
        }
    }

    public void scanJS(String buffer, String fileName) throws Exception {
        if (buffer == null) {
            return;
        }
        int length = buffer.length();
        boolean haveComma = false;
        int commaCharPos = 0;
        int pos = 0;
        int TT_EOL = -1;
        int TT_COMMENT = -2;
        int TT_STRING = -3;
        int TT_NUMBER = -4;
        int TT_WORD = -5;
        int TT_REGEX = -6;
        int lastToken = TT_EOL;
        char lastQuote = '\u0000';
        boolean stringPlus = false;
        block9: while (pos < buffer.length()) {
            if (lastToken != 43) {
                stringPlus = false;
            }
            char theChar = buffer.charAt(pos);
            switch (theChar) {
                case '\"': 
                case '\'': {
                    int end = JSSyntaxScanner.matchString(buffer, pos);
                    stringPlus = false;
                    pos = end;
                    lastToken = TT_STRING;
                    lastQuote = theChar;
                    haveComma = false;
                    continue block9;
                }
                case ',': {
                    haveComma = true;
                    commaCharPos = pos++;
                    continue block9;
                }
                case '\t': 
                case ' ': {
                    ++pos;
                    continue block9;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    lastToken = TT_NUMBER;
                    ++pos;
                    haveComma = false;
                    continue block9;
                }
                case '\n': 
                case '\r': {
                    ++pos;
                    lastToken = TT_EOL;
                    continue block9;
                }
                case '+': {
                    if (lastToken == TT_STRING) {
                        stringPlus = true;
                    }
                    lastToken = theChar;
                    haveComma = false;
                    ++pos;
                    continue block9;
                }
                case '/': {
                    int end;
                    if (buffer.charAt(pos + 1) == '/') {
                        pos = end = JSSyntaxScanner.findEOL(buffer, pos + 2);
                        lastToken = TT_EOL;
                        continue block9;
                    }
                    if (buffer.charAt(pos + 1) == '*') {
                        pos = end = buffer.indexOf("*/", pos + 2) + 2;
                        continue block9;
                    }
                    haveComma = false;
                    if (lastToken == TT_WORD || lastToken == TT_NUMBER || lastToken == 41) {
                        ++pos;
                        continue block9;
                    }
                    pos = end = JSSyntaxScanner.matchString(buffer, pos);
                    lastToken = TT_REGEX;
                    continue block9;
                }
            }
            if (Character.isJavaIdentifierStart(theChar)) {
                String id = JSSyntaxScanner.grabIdentifier(buffer, pos);
                lastToken = TT_WORD;
                pos += id.length();
                haveComma = false;
                continue;
            }
            if ((theChar == '}' || theChar == ']') && haveComma) {
                throw new TrailingCommaException(buffer, fileName, theChar, commaCharPos);
            }
            lastToken = theChar;
            ++pos;
            haveComma = false;
        }
    }

    public static int matchString(String text, int startPos) {
        char quoteChar = text.charAt(startPos++);
        while (startPos < text.length()) {
            char theChar = text.charAt(startPos);
            if (theChar == quoteChar) {
                return startPos + 1;
            }
            if (theChar == '\\') {
                ++startPos;
            }
            ++startPos;
        }
        return text.length();
    }

    public static int findEOL(String text, int startPos) {
        int pos;
        for (pos = startPos; pos < text.length(); ++pos) {
            char theChar = text.charAt(pos);
            if (theChar != '\r' && theChar != '\n') continue;
            return pos;
        }
        return pos;
    }

    public static String grabIdentifier(String text, int startPos) throws Exception {
        char theChar = text.charAt(startPos);
        if (!JSTranslater.isJSIdentifierStart(theChar)) {
            throw new Exception("not at the start of an identifier");
        }
        int endPos = startPos;
        while (endPos++ < text.length() && JSTranslater.isJSIdentifierPart(theChar = text.charAt(endPos))) {
        }
        return text.substring(startPos, endPos);
    }
}

