/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.messaging;

import com.isomorphic.base.Config;
import com.isomorphic.base.Reflection;
import com.isomorphic.log.Logger;
import com.isomorphic.messaging.IDispatchNotify;
import com.isomorphic.messaging.ISCDispatchNotify;
import com.isomorphic.messaging.ISCMessage;
import com.isomorphic.messaging.ISubscriber;
import com.isomorphic.servlet.RequestContext;
import com.isomorphic.util.DataTools;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ISCMessageDispatcher {
    static Config config = Config.getGlobal();
    private static Logger log = new Logger(ISCMessageDispatcher.class.getName());
    private static final Map<String, Set<ISubscriber>> channelToSubscriberMap = new HashMap<String, Set<ISubscriber>>();
    private static final Map<String, String> selectorForSubscribedChannelMap = new HashMap<String, String>();
    private static final Map<ISubscriber, Set<String>> subscriberToChannelMap = new HashMap<ISubscriber, Set<String>>();
    private static final Set<ISubscriber> localSubscribers = new HashSet<ISubscriber>();
    public IDispatchNotify dispatchNotify;
    public RequestContext context;

    public static ISCMessageDispatcher instance(RequestContext context) throws Exception {
        return ISCMessageDispatcher.instance(null, context);
    }

    public static ISCMessageDispatcher instance() throws Exception {
        return ISCMessageDispatcher.instance(null, null);
    }

    public static ISCMessageDispatcher instance(IDispatchNotify dispatchNotify, RequestContext context) throws Exception {
        String implementer = config.getString((Object)"messaging.dispatcherImplementer");
        ISCMessageDispatcher md = (ISCMessageDispatcher)Reflection.instantiateClass((String)implementer);
        md.dispatchNotify = dispatchNotify;
        if (md.dispatchNotify == null) {
            md.dispatchNotify = new ISCDispatchNotify();
        }
        md.context = context;
        return md;
    }

    public static ISCMessageDispatcher instance(IDispatchNotify dispatchNotify) throws Exception {
        return ISCMessageDispatcher.instance(dispatchNotify, null);
    }

    protected static synchronized List<String> getAllChannels() {
        return new ArrayList<String>(channelToSubscriberMap.keySet());
    }

    protected static synchronized Map<String, String> getAllSelectorsForChannels() {
        return selectorForSubscribedChannelMap;
    }

    static synchronized List<String> getChannelsOfSubscriber(ISubscriber s) {
        Set<String> channels = subscriberToChannelMap.get(s);
        return channels == null ? null : new ArrayList<String>(channels);
    }

    static synchronized List<ISubscriber> getSubscribersOfChannel(String channel) {
        Set<ISubscriber> subscribers = channelToSubscriberMap.get(channel);
        return subscribers == null ? null : new ArrayList<ISubscriber>(subscribers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(ISubscriber s) throws Exception {
        Class<ISCMessageDispatcher> clazz = ISCMessageDispatcher.class;
        synchronized (ISCMessageDispatcher.class) {
            localSubscribers.add(s);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.dispatchNotify.onRegister(s);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRegistered(ISubscriber s) throws Exception {
        Class<ISCMessageDispatcher> clazz = ISCMessageDispatcher.class;
        synchronized (ISCMessageDispatcher.class) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return localSubscribers.contains(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(ISubscriber s) throws Exception {
        Class<ISCMessageDispatcher> clazz = ISCMessageDispatcher.class;
        synchronized (ISCMessageDispatcher.class) {
            Set<String> channels = subscriberToChannelMap.remove(s);
            if (channels != null) {
                for (String channel : channels) {
                    Set<ISubscriber> subscribers = channelToSubscriberMap.get(channel);
                    assert (subscribers != null);
                    assert (subscribers.contains(s));
                    subscribers.remove(s);
                    if (!subscribers.isEmpty()) continue;
                    channelToSubscriberMap.remove(channel);
                    selectorForSubscribedChannelMap.remove(channel);
                }
            }
            localSubscribers.remove(s);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.dispatchNotify.onUnregister(s);
            return;
        }
    }

    public void subscribe(ISubscriber s, String channel) throws Exception {
        this.subscribe(s, channel, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribe(ISubscriber s, String channel, String selector) throws Exception {
        Class<ISCMessageDispatcher> clazz = ISCMessageDispatcher.class;
        synchronized (ISCMessageDispatcher.class) {
            Set<ISubscriber> subscribers;
            Set<String> channels = subscriberToChannelMap.get(s);
            if (channels == null) {
                channels = new HashSet<String>();
                subscriberToChannelMap.put(s, channels);
            }
            if ((subscribers = channelToSubscriberMap.get(channel)) == null) {
                subscribers = new HashSet<ISubscriber>();
                channelToSubscriberMap.put(channel, subscribers);
            }
            if (selectorForSubscribedChannelMap.get(channel) == null && selector != null) {
                selectorForSubscribedChannelMap.put(channel, selector);
            }
            channels.add(channel);
            subscribers.add(s);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            this.dispatchNotify.onSubscribe(s, channel);
            return;
        }
    }

    public void subscribe(ISubscriber s, Map<String, ?> channels) throws Exception {
        if (channels != null) {
            for (String channel : channels.keySet()) {
                Map dataChannel = channels.get(channel) == null ? null : (Map)channels.get(channel);
                String selector = dataChannel.get("selector") == null ? null : (String)dataChannel.get("selector");
                this.subscribe(s, channel, selector);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribe(ISubscriber s, String channel) throws Exception {
        Class<ISCMessageDispatcher> clazz = ISCMessageDispatcher.class;
        synchronized (ISCMessageDispatcher.class) {
            Set<ISubscriber> subscribers = channelToSubscriberMap.get(channel);
            if (subscribers == null) {
                assert (!subscriberToChannelMap.containsKey(s) || !subscriberToChannelMap.get(s).contains(channel));
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
            if (!subscribers.remove(s)) {
                Set<String> channels = subscriberToChannelMap.get(s);
                assert (channels == null || channels.isEmpty());
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
            if (subscribers.isEmpty()) {
                channelToSubscriberMap.remove(channel);
                selectorForSubscribedChannelMap.remove(channel);
            }
            Set<String> channels = subscriberToChannelMap.get(s);
            assert (channels != null);
            assert (channels.contains(channel));
            channels.remove(channel);
            if (channels.isEmpty()) {
                subscriberToChannelMap.remove(s);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            this.dispatchNotify.onUnsubscribe(s, channel);
            return;
        }
    }

    public void unsubscribe(ISubscriber s, List<String> channels) throws Exception {
        Iterator<String> i = channels.iterator();
        while (i.hasNext()) {
            this.unsubscribe(s, i.next());
        }
    }

    public void send(ISCMessage msg) throws Exception {
        this.deliver(msg);
    }

    public abstract void deliver(ISCMessage var1) throws Exception;

    public abstract void closeConnection();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deliverToLocalSubscribers(ISCMessage msg) throws Exception {
        List<String> targetChannels = msg.getTargetChannels();
        if (targetChannels == null) {
            return;
        }
        HashMap<ISubscriber, ISCMessage> targetSubscriberToMessageMap = new HashMap<ISubscriber, ISCMessage>();
        Class<ISCMessageDispatcher> clazz = ISCMessageDispatcher.class;
        synchronized (ISCMessageDispatcher.class) {
            for (String channel : targetChannels) {
                log.debug((Object)("sending message to channel: " + channel));
                Set<ISubscriber> channelMembers = channelToSubscriberMap.get(channel);
                if (channelMembers == null) continue;
                for (ISubscriber s : channelMembers) {
                    if (targetSubscriberToMessageMap.containsKey(s)) continue;
                    List channelsIntersection = DataTools.setIntersection(targetChannels, (Collection)subscriberToChannelMap.get(s));
                    ISCMessage targetedMessage = new ISCMessage(channelsIntersection, msg.getData(), msg.getID());
                    targetSubscriberToMessageMap.put(s, targetedMessage);
                }
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            for (Map.Entry e : targetSubscriberToMessageMap.entrySet()) {
                ISubscriber s = (ISubscriber)e.getKey();
                ISCMessage targetedMessage = (ISCMessage)e.getValue();
                try {
                    s.send(targetedMessage);
                }
                catch (Exception exception) {}
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSubscribed(ISubscriber s, String channel) throws Exception {
        Class<ISCMessageDispatcher> clazz = ISCMessageDispatcher.class;
        synchronized (ISCMessageDispatcher.class) {
            Set<String> channels = subscriberToChannelMap.get(s);
            if (channels != null && channels.contains(channel)) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return true;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return false;
        }
    }
}

