/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.jpa;

import com.isomorphic.base.Config;
import com.isomorphic.jpa.EMFProviderInterface;
import com.isomorphic.log.Logger;
import java.util.Properties;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.Persistence;
import javax.persistence.PersistenceException;

public class EMFProviderLMT
implements EMFProviderInterface {
    private static final String CLASS_NAME = EMFProviderLMT.class.getName();
    private static final Logger log = new Logger(CLASS_NAME);
    protected EntityManagerFactory emf;

    public EMFProviderLMT() {
        this(Config.getGlobal().getString((Object)"jpa.persistenceUnitName", null));
    }

    public EMFProviderLMT(Properties config) {
        this(config.getProperty("persistenceUnitName"));
    }

    public EMFProviderLMT(String persistenceUnitName) {
        this.emf = Persistence.createEntityManagerFactory((String)persistenceUnitName);
    }

    public EntityManagerFactory get() {
        return this.emf;
    }

    public EntityManager getEntityManager() throws PersistenceException {
        return this.emf.createEntityManager();
    }

    public void returnEntityManager(EntityManager em) {
        if (em != null) {
            try {
                if (em.isOpen()) {
                    em.close();
                }
            }
            catch (PersistenceException ex) {
                log.warn((Object)"Failed to close EntityManager.", (Throwable)ex);
            }
        }
    }

    public Object getTransaction(EntityManager em) throws Exception {
        if (em != null) {
            EntityTransaction tx = em.getTransaction();
            if (!tx.isActive()) {
                tx.begin();
            }
            return tx;
        }
        throw new PersistenceException("Entity manager not provided.");
    }

    public void commitTransaction(Object tx) throws Exception {
        if (tx != null && ((EntityTransaction)tx).isActive()) {
            ((EntityTransaction)tx).commit();
        }
    }

    public void rollbackTransaction(Object tx) {
        if (tx != null && ((EntityTransaction)tx).isActive()) {
            try {
                ((EntityTransaction)tx).rollback();
            }
            catch (Exception ex) {
                log.warn((Object)"Unexpected exception while rolling back transaction", (Throwable)ex);
            }
        }
    }
}

